'use strict';

var constants = require('../constants.js');

const binaryOptions = {
  defaultType: constants.Type.BLOCK_LITERAL,
  lineWidth: 76
};
const boolOptions = {
  trueStr: 'true',
  falseStr: 'false'
};
const intOptions = {
  asBigInt: false
};
const nullOptions = {
  nullStr: 'null'
};
const strOptions = {
  defaultType: constants.Type.PLAIN,
  defaultKeyType: constants.Type.PLAIN,
  defaultQuoteSingle: false,
  doubleQuoted: {
    jsonEncoding: false,
    minMultiLineLength: 40
  },
  fold: {
    lineWidth: 80,
    minContentWidth: 20
  }
};

exports.binaryOptions = binaryOptions;
exports.boolOptions = boolOptions;
exports.intOptions = intOptions;
exports.nullOptions = nullOptions;
exports.strOptions = strOptions;
