'use strict';

var _rollupPluginBabelHelpers = require('../../_virtual/_rollupPluginBabelHelpers.js');
var Pair = require('../../ast/Pair.js');
var Scalar = require('../../ast/Scalar.js');
var YAMLMap = require('../../ast/YAMLMap.js');
var YAMLSeq = require('../../ast/YAMLSeq.js');
var toJS = require('../../ast/toJS.js');
var pairs = require('./pairs.js');

class YAMLOMap extends YAMLSeq.YAMLSeq {
  constructor() {
    super();

    _rollupPluginBabelHelpers.defineProperty(this, "add", YAMLMap.YAMLMap.prototype.add.bind(this));

    _rollupPluginBabelHelpers.defineProperty(this, "delete", YAMLMap.YAMLMap.prototype.delete.bind(this));

    _rollupPluginBabelHelpers.defineProperty(this, "get", YAMLMap.YAMLMap.prototype.get.bind(this));

    _rollupPluginBabelHelpers.defineProperty(this, "has", YAMLMap.YAMLMap.prototype.has.bind(this));

    _rollupPluginBabelHelpers.defineProperty(this, "set", YAMLMap.YAMLMap.prototype.set.bind(this));

    this.tag = YAMLOMap.tag;
  }

  toJSON(_, ctx) {
    const map = new Map();
    if (ctx && ctx.onCreate) ctx.onCreate(map);

    for (const pair of this.items) {
      let key, value;

      if (pair instanceof Pair.Pair) {
        key = toJS.toJS(pair.key, '', ctx);
        value = toJS.toJS(pair.value, key, ctx);
      } else {
        key = toJS.toJS(pair, '', ctx);
      }

      if (map.has(key)) throw new Error('Ordered maps must not include duplicate keys');
      map.set(key, value);
    }

    return map;
  }

}

_rollupPluginBabelHelpers.defineProperty(YAMLOMap, "tag", 'tag:yaml.org,2002:omap');

function parseOMap(seq, onError) {
  const pairs$1 = pairs.parsePairs(seq, onError);
  const seenKeys = [];

  for (const {
    key
  } of pairs$1.items) {
    if (key instanceof Scalar.Scalar) {
      if (seenKeys.includes(key.value)) {
        onError(`Ordered maps must not include duplicate keys: ${key.value}`);
      } else {
        seenKeys.push(key.value);
      }
    }
  }

  return Object.assign(new YAMLOMap(), pairs$1);
}

function createOMap(schema, iterable, ctx) {
  const pairs$1 = pairs.createPairs(schema, iterable, ctx);
  const omap = new YAMLOMap();
  omap.items = pairs$1.items;
  return omap;
}

const omap = {
  identify: value => value instanceof Map,
  nodeClass: YAMLOMap,
  default: false,
  tag: 'tag:yaml.org,2002:omap',
  resolve: parseOMap,
  createNode: createOMap
};

exports.YAMLOMap = YAMLOMap;
exports.omap = omap;
