import { Document } from '../doc/Document.js';
import { composeNode, composeEmptyNode } from './compose-node.js';
import { resolveEnd } from './resolve-end.js';
import { resolveProps } from './resolve-props.js';

function composeDoc(options, directives, { offset, start, value, end }, onError) {
    const opts = Object.assign({ directives }, options);
    const doc = new Document(undefined, opts);
    const props = resolveProps(doc, start, true, 'doc-start', offset, onError);
    if (props.found)
        doc.directives.marker = true;
    doc.contents = value
        ? composeNode(doc, value, props, onError)
        : composeEmptyNode(doc, offset + props.length, start, null, props, onError);
    const re = resolveEnd(end, doc.contents.range[1], false, onError);
    if (re.comment)
        doc.comment = re.comment;
    doc.range = [offset, re.offset];
    return doc;
}

export { composeDoc };
