import { YAMLSeq } from '../nodes/YAMLSeq.js';
import { resolveProps } from './resolve-props.js';

function resolveBlockSeq({ composeNode, composeEmptyNode }, doc, { items, offset }, anchor, onError) {
    const start = offset;
    const seq = new YAMLSeq(doc.schema);
    if (anchor)
        doc.anchors.setAnchor(seq, anchor);
    for (const { start, value } of items) {
        const props = resolveProps(doc, start, true, 'seq-item-ind', offset, onError);
        offset += props.length;
        if (!props.found) {
            if (props.anchor || props.tagName || value) {
                const msg = value && value.type === 'block-seq'
                    ? 'All sequence items must start at the same column'
                    : 'Sequence item without - indicator';
                onError(offset, msg);
            }
            else {
                // TODO: assert being at last item?
                if (props.comment)
                    seq.comment = props.comment;
                continue;
            }
        }
        const node = value
            ? composeNode(doc, value, props, onError)
            : composeEmptyNode(doc, offset, start, null, props, onError);
        offset = node.range[1];
        seq.items.push(node);
    }
    seq.range = [start, offset];
    return seq;
}

export { resolveBlockSeq };
