'use strict';

var Document = require('../doc/Document.js');
var composeNode = require('./compose-node.js');
var resolveEnd = require('./resolve-end.js');
var resolveProps = require('./resolve-props.js');

function composeDoc(options, directives, { offset, start, value, end }, onError) {
    const opts = Object.assign({ directives }, options);
    const doc = new Document.Document(undefined, opts);
    const props = resolveProps.resolveProps(doc, start, true, 'doc-start', offset, onError);
    if (props.found)
        doc.directives.marker = true;
    doc.contents = value
        ? composeNode.composeNode(doc, value, props, onError)
        : composeNode.composeEmptyNode(doc, offset + props.length, start, null, props, onError);
    const re = resolveEnd.resolveEnd(end, doc.contents.range[1], false, onError);
    if (re.comment)
        doc.comment = re.comment;
    doc.range = [offset, re.offset];
    return doc;
}

exports.composeDoc = composeDoc;
