import { Directives } from '../doc/directives.js';
import { YAMLParseError, YAMLWarning } from '../errors.js';
import { Options } from '../options.js';
import type { Token } from '../parse/tokens.js';
/**
 * Compose a stream of CST nodes into a stream of YAML Documents.
 *
 * ```ts
 * const options: Options = { ... }
 * const docs: Document.Parsed[] = []
 * const composer = new Composer(doc => docs.push(doc), options)
 * const parser = new Parser(composer.next)
 * parser.parse(source)
 * composer.end()
 * ```
 */
export declare class Composer {
    private directives;
    private doc;
    private onDocument;
    private options;
    private atDirectives;
    private prelude;
    private errors;
    private warnings;
    constructor(onDocument: Composer['onDocument'], options?: Options);
    private onError;
    private decorate;
    /**
     * Current stream status information.
     *
     * Mostly useful at the end of input for an empty stream.
     */
    streamInfo(): {
        comment: string;
        directives: Directives;
        errors: YAMLParseError[];
        warnings: YAMLWarning[];
    };
    /**
     * Advance the composed by one CST token. Bound to the Composer
     * instance, so may be used directly as a callback function.
     */
    next: (token: Token) => void;
    /** Call at end of input to push out any remaining document. */
    end(): void;
    /**
     * Call at end of input to push out any remaining document.
     *
     * @param forceDoc - If the stream contains no document, still emit a final
     *   document including any comments and directives that would be applied
     *   to a subsequent document.
     * @param offset - Should be set if `forceDoc` is also set, to set the
     *   document range end and to indicate errors correctly.
     */
    end(forceDoc: true, offset: number): void;
}
