'use strict';

function resolveEnd(end, offset, reqSpace, onError) {
    let comment = '';
    if (end) {
        let hasSpace = false;
        let hasComment = false;
        let sep = '';
        for (const { source, type } of end) {
            switch (type) {
                case 'space':
                    hasSpace = true;
                    break;
                case 'comment': {
                    if (reqSpace && !hasSpace)
                        onError(offset, 'Comments must be separated from other tokens by white space characters');
                    const cb = source.substring(1);
                    if (!hasComment)
                        comment = cb;
                    else
                        comment += sep + cb;
                    hasComment = true;
                    sep = '';
                    break;
                }
                case 'newline':
                    if (hasComment)
                        sep += source;
                    hasSpace = true;
                    break;
                default:
                    onError(offset, `Unexpected ${type} at node end`);
            }
            offset += source.length;
        }
    }
    return { comment, offset };
}

exports.resolveEnd = resolveEnd;
