import { Alias } from '../nodes/Alias.js';
import { Node } from '../nodes/Node.js';
import { Pair } from '../nodes/Pair.js';
import { Scalar } from '../nodes/Scalar.js';
import { YAMLSeq } from '../nodes/YAMLSeq.js';
export declare class Anchors {
    map: Record<string, Node>;
    private prefix;
    constructor(prefix: string);
    /**
     * Create a new `Alias` node, adding the required anchor for `node`.
     * If `name` is empty, a new anchor name will be generated.
     */
    createAlias(node: Node, name?: string): Alias<Node>;
    /**
     * Create a new merge `Pair` with the given source nodes.
     * Non-`Alias` sources will be automatically wrapped.
     */
    createMergePair(...sources: Node[]): Pair<Scalar<string>, Alias<Node>> | Pair<Scalar<string>, YAMLSeq<Alias<Node>>>;
    /** The anchor name associated with `node`, if set. */
    getName(node: Node): string | undefined;
    /** List of all defined anchor names. */
    getNames(): string[];
    /** The node associated with the anchor `name`, if set. */
    getNode(name: string): Node;
    /**
     * Find an available anchor name with the given `prefix` and a
     * numerical suffix.
     */
    newName(prefix?: string): string;
    /**
     * Associate an anchor with `node`. If `name` is empty, a new name will be generated.
     * To remove an anchor, use `setAnchor(null, name)`.
     */
    setAnchor(node: Node | null, name?: string): string | null;
}
