'use strict';

var index = require('../tags/index.js');
var getSchemaTags = require('./getSchemaTags.js');

const sortMapEntriesByKey = (a, b) => a.key < b.key ? -1 : a.key > b.key ? 1 : 0;
const coreKnownTags = {
    'tag:yaml.org,2002:binary': index.tags.binary,
    'tag:yaml.org,2002:omap': index.tags.omap,
    'tag:yaml.org,2002:pairs': index.tags.pairs,
    'tag:yaml.org,2002:set': index.tags.set,
    'tag:yaml.org,2002:timestamp': index.tags.timestamp
};
class Schema {
    constructor({ customTags, merge, resolveKnownTags, schema, sortMapEntries }) {
        // Used by createNode(), to avoid circular dependencies
        this.map = index.tags.map;
        this.seq = index.tags.seq;
        this.merge = !!merge;
        this.name = schema || 'core';
        this.knownTags = resolveKnownTags ? coreKnownTags : {};
        this.tags = getSchemaTags.getSchemaTags(index.schemas, index.tags, customTags, this.name);
        // Used by createMap()
        this.sortMapEntries =
            sortMapEntries === true ? sortMapEntriesByKey : sortMapEntries || null;
    }
}

exports.Schema = Schema;
