import type { Alias } from '../nodes/Alias.js';
import { Node } from '../nodes/Node.js';
import type { TagObj } from '../tags/types.js';
import type { Replacer } from './Document.js';
import type { Schema } from './Schema.js';
export interface CreateNodeAliasRef {
    node: Node | undefined;
    value: unknown;
}
export interface CreateNodeContext {
    keepUndefined?: boolean;
    onAlias(source: CreateNodeAliasRef): Alias;
    onTagObj?: (tagObj: TagObj) => void;
    prevObjects: Map<unknown, CreateNodeAliasRef>;
    replacer?: Replacer;
    schema: Schema;
}
export declare function createNode(value: unknown, tagName: string | undefined, ctx: CreateNodeContext): Node;
