import type { LineCounter } from './parse/line-counter';
export declare class YAMLError extends Error {
    name: 'YAMLParseError' | 'YAMLWarning';
    message: string;
    offset: number;
    linePos?: {
        line: number;
        col: number;
    };
    constructor(name: YAMLError['name'], offset: number, message: string);
}
export declare class YAMLParseError extends YAMLError {
    constructor(offset: number, message: string);
}
export declare class YAMLWarning extends YAMLError {
    constructor(offset: number, message: string);
}
export declare const prettifyError: (src: string, lc: LineCounter) => (error: YAMLError) => void;
