import type { Schema } from '../doc/Schema.js';
import { StringifyContext } from '../stringify/stringify.js';
import { NodeBase, NODE_TYPE } from './Node.js';
export declare function collectionFromPath(schema: Schema, path: unknown[], value: unknown): import("./Node.js").Node;
export declare const isEmptyPath: (path: Iterable<unknown> | null | undefined) => boolean;
export declare namespace Collection {
    interface StringifyContext {
        blockItem(node: StringifyNode): string;
        flowChars: {
            start: '{' | '[';
            end: '}' | ']';
        };
        itemIndent: string;
    }
    interface StringifyNode {
        type: 'comment' | 'item';
        str: string;
    }
}
export declare abstract class Collection extends NodeBase {
    static maxFlowStringSingleLineLength: number;
    schema: Schema | undefined;
    [NODE_TYPE]: symbol;
    items: unknown[];
    /**
     * If true, stringify this and all child nodes using flow rather than
     * block styles.
     */
    flow?: boolean;
    constructor(type: symbol, schema?: Schema);
    /** Adds a value to the collection. */
    abstract add(value: unknown): void;
    /**
     * Removes a value from the collection.
     * @returns `true` if the item was found and removed.
     */
    abstract delete(key: unknown): boolean;
    /**
     * Returns item at `key`, or `undefined` if not found. By default unwraps
     * scalar values from their surrounding node; to disable set `keepScalar` to
     * `true` (collections are always returned intact).
     */
    abstract get(key: unknown, keepScalar?: boolean): unknown;
    /**
     * Checks if the collection includes a value with the key `key`.
     */
    abstract has(key: unknown): boolean;
    /**
     * Sets a value in this collection. For `!!set`, `value` needs to be a
     * boolean to add/remove the item from the set.
     */
    abstract set(key: unknown, value: unknown): void;
    /**
     * Adds a value to the collection. For `!!map` and `!!omap` the value must
     * be a Pair instance or a `{ key, value }` object, which may not have a key
     * that already exists in the map.
     */
    addIn(path: Iterable<unknown>, value: unknown): void;
    /**
     * Removes a value from the collection.
     * @returns `true` if the item was found and removed.
     */
    deleteIn([key, ...rest]: Iterable<unknown>): boolean;
    /**
     * Returns item at `key`, or `undefined` if not found. By default unwraps
     * scalar values from their surrounding node; to disable set `keepScalar` to
     * `true` (collections are always returned intact).
     */
    getIn([key, ...rest]: Iterable<unknown>, keepScalar?: boolean): unknown;
    hasAllNullValues(allowScalar?: boolean): boolean;
    /**
     * Checks if the collection includes a value with the key `key`.
     */
    hasIn([key, ...rest]: Iterable<unknown>): boolean;
    /**
     * Sets a value in this collection. For `!!set`, `value` needs to be a
     * boolean to add/remove the item from the set.
     */
    setIn([key, ...rest]: Iterable<unknown>, value: unknown): void;
    _toString(ctx: StringifyContext, { blockItem, flowChars, itemIndent }: Collection.StringifyContext, onComment?: () => void, onChompKeep?: () => void): string;
}
