import { CreateNodeContext } from '../doc/createNode.js';
import { StringifyContext } from '../stringify/stringify.js';
import { Scalar } from './Scalar.js';
import { ToJSContext } from './toJS.js';
import { Node, NodeBase } from './Node.js';
export declare function createPair(key: unknown, value: unknown, ctx: CreateNodeContext): Pair<Node, import("./Alias.js").Alias<Node> | Scalar<unknown> | import("./YAMLMap.js").YAMLMap<unknown, unknown> | import("./YAMLSeq.js").YAMLSeq<unknown>>;
export declare class Pair<K = unknown, V = unknown> extends NodeBase {
    static readonly MERGE_KEY = "<<";
    /** Always Node or null when parsed, but can be set to anything. */
    key: K;
    /** Always Node or null when parsed, but can be set to anything. */
    value: V | null;
    constructor(key: K, value?: V | null);
    get commentBefore(): string | null | undefined;
    set commentBefore(cb: string | null | undefined);
    get spaceBefore(): boolean | undefined;
    set spaceBefore(sb: boolean | undefined);
    addToJSMap(ctx: ToJSContext | undefined, map: Map<unknown, unknown> | Set<unknown> | Record<string | number | symbol, unknown>): Map<unknown, unknown> | Set<unknown> | Record<string | number | symbol, unknown>;
    toJSON(_?: unknown, ctx?: ToJSContext): Map<unknown, unknown> | Set<unknown> | Record<string | number | symbol, unknown>;
    toString(ctx?: StringifyContext, onComment?: () => void, onChompKeep?: () => void): string;
}
