'use strict';

var core = require('./core.js');
var index = require('./failsafe/index.js');
var json = require('./json.js');
var index$1 = require('./yaml-1.1/index.js');
var map = require('./failsafe/map.js');
var seq = require('./failsafe/seq.js');
var binary = require('./yaml-1.1/binary.js');
var omap = require('./yaml-1.1/omap.js');
var pairs = require('./yaml-1.1/pairs.js');
var set = require('./yaml-1.1/set.js');
var timestamp = require('./yaml-1.1/timestamp.js');

const schemas = { core: core.core, failsafe: index.failsafe, json: json.json, yaml11: index$1.yaml11 };
const tags = {
    binary: binary.binary,
    bool: core.boolObj,
    float: core.floatObj,
    floatExp: core.expObj,
    floatNaN: core.nanObj,
    floatTime: timestamp.floatTime,
    int: core.intObj,
    intHex: core.hexObj,
    intOct: core.octObj,
    intTime: timestamp.intTime,
    map: map.map,
    null: core.nullObj,
    omap: omap.omap,
    pairs: pairs.pairs,
    seq: seq.seq,
    set: set.set,
    timestamp: timestamp.timestamp
};

exports.schemas = schemas;
exports.tags = tags;
