import { Node } from '../nodes/Node.js';
import type { Schema } from '../schema/Schema.js';
import type { CollectionTag, ScalarTag } from '../schema/types.js';
import type { Replacer } from './Document.js';
export interface CreateNodeContext {
    keepUndefined?: boolean;
    onAnchor(source: unknown): string;
    onTagObj?: (tagObj: ScalarTag | CollectionTag) => void;
    sourceObjects: Map<unknown, {
        anchor: string | null;
        node: Node | null;
    }>;
    replacer?: Replacer;
    schema: Schema;
}
export declare function createNode(value: unknown, tagName: string | undefined, ctx: CreateNodeContext): Node;
