"use strict";
/**
 * @package      npmjs.com/package/@yandeu/events (events.min.js)
 *
 * @author       Arnout Kazemier (https://github.com/3rd-Eden)
 * @copyright    Copyright (c) 2014 Arnout Kazemier
 * @license      {@link https://github.com/primus/eventemitter3/blob/master/LICENSE|MIT}
 *
 * @author       Yannick Deubel (https://github.com/yandeu)
 * @copyright    Copyright (c) 2021 Yannick Deubel; Project Url: https://github.com/yandeu/events
 * @license      {@link https://github.com/yandeu/events/blob/master/LICENSE|MIT}
 */
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Events = void 0;
var version_1 = require("./version");
var EE = /** @class */ (function () {
    function EE(fn, context, once) {
        if (once === void 0) { once = false; }
        this.fn = fn;
        this.context = context;
        this.once = once;
    }
    return EE;
}());
var addListener = function (emitter, event, fn, context, once) {
    if (typeof fn !== 'function') {
        throw new TypeError('The listener must be a function');
    }
    var listener = new EE(fn, context || emitter, once);
    if (!emitter._events.has(event))
        emitter._events.set(event, listener), emitter._eventsCount++;
    else if (!emitter._events.get(event).fn)
        emitter._events.get(event).push(listener);
    else
        emitter._events.set(event, [emitter._events.get(event), listener]);
    return emitter;
};
var clearEvent = function (emitter, event) {
    if (--emitter._eventsCount === 0)
        emitter._events = new Map();
    else
        emitter._events.delete(event);
};
var Events = /** @class */ (function () {
    function Events() {
        this._events = new Map();
        this._eventsCount = 0;
    }
    Object.defineProperty(Events, "VERSION", {
        get: function () {
            return version_1.VERSION;
        },
        enumerable: false,
        configurable: true
    });
    Events.prototype.eventNames = function () {
        return Array.from(this._events.keys());
    };
    Events.prototype.listeners = function (event) {
        var handlers = this._events.get(event);
        if (!handlers)
            return [];
        if (handlers.fn)
            return [handlers.fn];
        for (var i = 0, l = handlers.length, ee = new Array(l); i < l; i++) {
            ee[i] = handlers[i].fn;
        }
        return ee;
    };
    Events.prototype.listenerCount = function (event) {
        var listeners = this._events.get(event);
        if (!listeners)
            return 0;
        if (listeners.fn)
            return 1;
        return listeners.length;
    };
    Events.prototype.emit = function (event) {
        var _a, _b;
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (!this._events.has(event))
            return false;
        var listeners = this._events.get(event);
        var i;
        if (listeners.fn) {
            if (listeners.once)
                this.removeListener(event, listeners.fn, undefined, true);
            return (_a = listeners.fn).call.apply(_a, __spreadArray([listeners.context], args)), true;
        }
        else {
            var length_1 = listeners.length;
            for (i = 0; i < length_1; i++) {
                if (listeners[i].once)
                    this.removeListener(event, listeners[i].fn, undefined, true);
                (_b = listeners[i].fn).call.apply(_b, __spreadArray([listeners[i].context], args));
            }
        }
        return true;
    };
    Events.prototype.on = function (event, fn, context) {
        return addListener(this, event, fn, context, false);
    };
    Events.prototype.once = function (event, fn, context) {
        return addListener(this, event, fn, context, true);
    };
    Events.prototype.removeListener = function (event, fn, context, once) {
        if (!this._events.has(event))
            return this;
        if (!fn) {
            clearEvent(this, event);
            return this;
        }
        var listeners = this._events.get(event);
        if (listeners.fn) {
            if (listeners.fn === fn && (!once || listeners.once) && (!context || listeners.context === context)) {
                clearEvent(this, event);
            }
        }
        else {
            for (var i = 0, events = [], length = listeners.length; i < length; i++) {
                if (listeners[i].fn !== fn || (once && !listeners[i].once) || (context && listeners[i].context !== context)) {
                    events.push(listeners[i]);
                }
            }
            // Reset the array, or remove it completely if we have no more listeners.
            if (events.length)
                this._events.set(event, events.length === 1 ? events[0] : events);
            else
                clearEvent(this, event);
        }
        return this;
    };
    Events.prototype.removeAllListeners = function (event) {
        if (event) {
            if (this._events.delete(event))
                clearEvent(this, event);
        }
        else {
            this._events = new Map();
            this._eventsCount = 0;
        }
        return this;
    };
    Object.defineProperty(Events.prototype, "off", {
        // alias
        get: function () {
            return this.removeListener;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Events.prototype, "addListener", {
        // alias
        get: function () {
            return this.on;
        },
        enumerable: false,
        configurable: true
    });
    return Events;
}());
exports.Events = Events;
/** TESTING SECTION */
// type Colors = 'red' | 'blue' | 'yellow'
// interface EventMap {
//   signal: () => void
//   error: (err: string) => void
//   something: (a: number, b: { colors?: Colors[] }, c: [number, number, string]) => void
// }
// const test = new Events<EventMap>()
// const listener: EventListener<EventMap, 'something'> = (a, b, c) => {
//   console.log(a, b.colors, c)
// }
// test.on('something', listener)
// setTimeout(() => {
//   test.removeListener('something', listener)
// }, 5000)
// test.once('error', err => {
//   console.log('error:', err)
// })
// console.log(test.eventNames())
// test.emit('error', 'ok')
// test.emit('error', 'failed')
// test.emit('something', 1234, { colors: ['blue'] }, [3, 3, 'k'])
//# sourceMappingURL=index.js.map