/**
 * @package      npmjs.com/package/@yandeu/tap (tap.min.js)
 *
 * @author       Yannick Deubel (https://github.com/yandeu)
 * @copyright    Copyright (c) 2021 Yannick Deubel; Project Url: https://github.com/yandeu/tap
 * @license      {@link https://github.com/yandeu/tap/blob/master/LICENSE|MIT}
 * @description  Inspired by tapjs (https://www.npmjs.com/package/tapjs)
 */
export declare type TapIsDragging = boolean;
export declare type TapCallback = (data: TapEvent) => void;
export declare type TapVector2 = {
    x: number;
    y: number;
};
export interface TapEvent {
    position: TapVector2;
    event: Event;
    dragging?: TapIsDragging;
}
export interface TapEventMap {
    down: (event: TapEvent) => void;
    move: (event: TapEvent) => void;
    up: (event: TapEvent) => void;
}
export declare class Tap {
    static get VERSION(): string;
    private _events;
    private domElement;
    private _isDown;
    private _isPaused;
    private active;
    private registered;
    private _currentPosition;
    private _lastPosition;
    private _isPointerLockAvailable;
    constructor(domElement: HTMLElement);
    get isDown(): boolean;
    private set _position(value);
    get currentPosition(): TapVector2;
    get lastPosition(): TapVector2;
    get isPaused(): boolean;
    pause(): void;
    resume(): void;
    private _onPointerLockChange;
    get pointerLock(): {
        onceChange: () => Promise<unknown>;
        request: () => Promise<unknown>;
        exit: () => Promise<unknown>;
        available: boolean;
        isLocked: boolean;
    };
    /** (once ignores paused) */
    get once(): {
        down: (callback: TapCallback) => void;
        move: (callback: TapCallback) => void;
        up: (callback: TapCallback) => void;
    };
    get on(): {
        down: (callback: TapCallback) => void;
        move: (callback: TapCallback) => void;
        up: (callback: TapCallback) => void;
    };
    private _add;
    private _remove;
    destroy(): void;
    private _calcPosition;
    private _removeDuplicates;
    private _onDown;
    private _onMove;
    private _onUp;
}
//# sourceMappingURL=index.d.ts.map