'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.clearLine = clearLine;
exports.toStartOfLine = toStartOfLine;
exports.writeOnNthLine = writeOnNthLine;
exports.clearNthLine = clearNthLine;


const readline = require('readline');

function clearLine(stdout) {
  readline.clearLine(stdout, 0);
  readline.cursorTo(stdout, 0);
}

function toStartOfLine(stdout) {
  readline.cursorTo(stdout, 0);
}

function writeOnNthLine(stdout, n, msg) {
  if (n == 0) {
    clearLine(stdout);
    stdout.write(msg);
    return;
  }
  readline.cursorTo(stdout, 0);
  readline.moveCursor(stdout, 0, -n);
  readline.clearLine(stdout, 0);
  stdout.write(msg);
  readline.cursorTo(stdout, 0);
  readline.moveCursor(stdout, 0, n);
}

function clearNthLine(stdout, n) {
  if (n == 0) {
    clearLine(stdout);
    return;
  }
  readline.cursorTo(stdout, 0);
  readline.moveCursor(stdout, 0, -n);
  readline.clearLine(stdout, 0);
  readline.moveCursor(stdout, 0, n);
}