(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
  typeof define === 'function' && define.amd ? define(['exports'], factory) :
  (factory((global.Zipkin = {})));
}(this, (function (exports) { 'use strict';

  function _typeof(obj) {
    "@babel/helpers - typeof";

    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function (obj) {
        return typeof obj;
      };
    } else {
      _typeof = function (obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    return Constructor;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf(o);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf(o, p);
  }

  function _isNativeReflectConstruct() {
    if (typeof Reflect === "undefined" || !Reflect.construct) return false;
    if (Reflect.construct.sham) return false;
    if (typeof Proxy === "function") return true;

    try {
      Date.prototype.toString.call(Reflect.construct(Date, [], function () {}));
      return true;
    } catch (e) {
      return false;
    }
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (typeof call === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized(self);
  }

  function _createSuper(Derived) {
    var hasNativeReflectConstruct = _isNativeReflectConstruct();

    return function () {
      var Super = _getPrototypeOf(Derived),
          result;

      if (hasNativeReflectConstruct) {
        var NewTarget = _getPrototypeOf(this).constructor;

        result = Reflect.construct(Super, arguments, NewTarget);
      } else {
        result = Super.apply(this, arguments);
      }

      return _possibleConstructorReturn(this, result);
    };
  }

  var None = {
    get type() {
      return 'None';
    },

    get present() {
      return false;
    },

    map: function map() {
      return this;
    },
    ifPresent: function ifPresent() {},
    flatMap: function flatMap() {
      return this;
    },
    getOrElse: function getOrElse(f) {
      return f instanceof Function ? f() : f;
    },
    equals: function equals(other) {
      return other === this;
    },
    toString: function toString() {
      return 'None';
    }
  };

  var Some = /*#__PURE__*/function () {
    function Some(value) {
      _classCallCheck(this, Some);

      this.value = value;
    }

    _createClass(Some, [{
      key: "map",
      value: function map(f) {
        return new Some(f(this.value));
      }
    }, {
      key: "ifPresent",
      value: function ifPresent(f) {
        f(this.value);
      }
    }, {
      key: "flatMap",
      value: function flatMap(f) {
        return f(this.value);
      }
    }, {
      key: "getOrElse",
      value: function getOrElse() {
        return this.value;
      }
    }, {
      key: "equals",
      value: function equals(other) {
        return other instanceof Some && other.value === this.value;
      }
    }, {
      key: "toString",
      value: function toString() {
        return "Some(".concat(this.value, ")");
      }
    }, {
      key: "type",
      get: function get() {
        // eslint-disable-line class-methods-use-this
        return 'Some';
      }
    }, {
      key: "present",
      get: function get() {
        // eslint-disable-line class-methods-use-this
        return true;
      }
    }]);

    return Some;
  }(); // Used to validate input arguments


  function isOptional(data) {
    return data instanceof Some || None.equals(data);
  }

  function verifyIsOptional(data) {
    if (data == null) {
      throw new Error('Error: data is not Optional - it\'s null');
    }

    if (isOptional(data)) {
      if (isOptional(data.value)) {
        throw new Error("Error: data (".concat(data.value, ") is wrapped in Option twice"));
      }
    } else {
      throw new Error("Error: data (".concat(data, ") is not an Option!"));
    }
  }

  function verifyIsNotOptional(data) {
    if (isOptional(data)) {
      throw new Error("Error: data (".concat(data, ") is an Option!"));
    }
  }

  function fromNullable(nullable) {
    return nullable == null ? None : new Some(nullable);
  }

  var Some_1 = Some;
  var None_1 = None;
  var isOptional_1 = isOptional;
  var verifyIsOptional_1 = verifyIsOptional;
  var verifyIsNotOptional_1 = verifyIsNotOptional;
  var fromNullable_1 = fromNullable;
  var option = {
    Some: Some_1,
    None: None_1,
    isOptional: isOptional_1,
    verifyIsOptional: verifyIsOptional_1,
    verifyIsNotOptional: verifyIsNotOptional_1,
    fromNullable: fromNullable_1
  };

  var global$1 = typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {};

  // shim for using process in browser
  // based off https://github.com/defunctzombie/node-process/blob/master/browser.js
  function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
  }

  function defaultClearTimeout() {
    throw new Error('clearTimeout has not been defined');
  }

  var cachedSetTimeout = defaultSetTimout;
  var cachedClearTimeout = defaultClearTimeout;

  if (typeof global$1.setTimeout === 'function') {
    cachedSetTimeout = setTimeout;
  }

  if (typeof global$1.clearTimeout === 'function') {
    cachedClearTimeout = clearTimeout;
  }

  function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
      //normal enviroments in sane situations
      return setTimeout(fun, 0);
    } // if setTimeout wasn't available but was latter defined


    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
      cachedSetTimeout = setTimeout;
      return setTimeout(fun, 0);
    }

    try {
      // when when somebody has screwed with setTimeout but no I.E. maddness
      return cachedSetTimeout(fun, 0);
    } catch (e) {
      try {
        // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
        return cachedSetTimeout.call(null, fun, 0);
      } catch (e) {
        // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
        return cachedSetTimeout.call(this, fun, 0);
      }
    }
  }

  function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
      //normal enviroments in sane situations
      return clearTimeout(marker);
    } // if clearTimeout wasn't available but was latter defined


    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
      cachedClearTimeout = clearTimeout;
      return clearTimeout(marker);
    }

    try {
      // when when somebody has screwed with setTimeout but no I.E. maddness
      return cachedClearTimeout(marker);
    } catch (e) {
      try {
        // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
        return cachedClearTimeout.call(null, marker);
      } catch (e) {
        // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
        // Some versions of I.E. have different rules for clearTimeout vs setTimeout
        return cachedClearTimeout.call(this, marker);
      }
    }
  }

  var queue = [];
  var draining = false;
  var currentQueue;
  var queueIndex = -1;

  function cleanUpNextTick() {
    if (!draining || !currentQueue) {
      return;
    }

    draining = false;

    if (currentQueue.length) {
      queue = currentQueue.concat(queue);
    } else {
      queueIndex = -1;
    }

    if (queue.length) {
      drainQueue();
    }
  }

  function drainQueue() {
    if (draining) {
      return;
    }

    var timeout = runTimeout(cleanUpNextTick);
    draining = true;
    var len = queue.length;

    while (len) {
      currentQueue = queue;
      queue = [];

      while (++queueIndex < len) {
        if (currentQueue) {
          currentQueue[queueIndex].run();
        }
      }

      queueIndex = -1;
      len = queue.length;
    }

    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
  }

  function nextTick(fun) {
    var args = new Array(arguments.length - 1);

    if (arguments.length > 1) {
      for (var i = 1; i < arguments.length; i++) {
        args[i - 1] = arguments[i];
      }
    }

    queue.push(new Item(fun, args));

    if (queue.length === 1 && !draining) {
      runTimeout(drainQueue);
    }
  } // v8 likes predictible objects

  function Item(fun, array) {
    this.fun = fun;
    this.array = array;
  }

  Item.prototype.run = function () {
    this.fun.apply(null, this.array);
  };

  var title = 'browser';
  var platform = 'browser';
  var browser = true;
  var env = {};
  var argv = [];
  var version = ''; // empty string to avoid regexp issues

  var versions = {};
  var release = {};
  var config = {};

  function noop() {}

  var on = noop;
  var addListener = noop;
  var once = noop;
  var off = noop;
  var removeListener = noop;
  var removeAllListeners = noop;
  var emit = noop;
  function binding(name) {
    throw new Error('process.binding is not supported');
  }
  function cwd() {
    return '/';
  }
  function chdir(dir) {
    throw new Error('process.chdir is not supported');
  }
  function umask() {
    return 0;
  } // from https://github.com/kumavis/browser-process-hrtime/blob/master/index.js

  var performance = global$1.performance || {};

  var performanceNow = performance.now || performance.mozNow || performance.msNow || performance.oNow || performance.webkitNow || function () {
    return new Date().getTime();
  }; // generate timestamp or delta
  // see http://nodejs.org/api/process.html#process_process_hrtime


  function hrtime(previousTimestamp) {
    var clocktime = performanceNow.call(performance) * 1e-3;
    var seconds = Math.floor(clocktime);
    var nanoseconds = Math.floor(clocktime % 1 * 1e9);

    if (previousTimestamp) {
      seconds = seconds - previousTimestamp[0];
      nanoseconds = nanoseconds - previousTimestamp[1];

      if (nanoseconds < 0) {
        seconds--;
        nanoseconds += 1e9;
      }
    }

    return [seconds, nanoseconds];
  }
  var startTime = new Date();
  function uptime() {
    var currentTime = new Date();
    var dif = currentTime - startTime;
    return dif / 1000;
  }
  var process = {
    nextTick: nextTick,
    title: title,
    browser: browser,
    env: env,
    argv: argv,
    version: version,
    versions: versions,
    on: on,
    addListener: addListener,
    once: once,
    off: off,
    removeListener: removeListener,
    removeAllListeners: removeAllListeners,
    emit: emit,
    binding: binding,
    cwd: cwd,
    chdir: chdir,
    umask: umask,
    hrtime: hrtime,
    platform: platform,
    release: release,
    config: config,
    uptime: uptime
  };

  /*
  The MIT License (MIT)

  Copyright (c) 2016 CoderPuppy

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in all
  copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.

  */
  var _endianness;

  function endianness() {
    if (typeof _endianness === 'undefined') {
      var a = new ArrayBuffer(2);
      var b = new Uint8Array(a);
      var c = new Uint16Array(a);
      b[0] = 1;
      b[1] = 2;

      if (c[0] === 258) {
        _endianness = 'BE';
      } else if (c[0] === 513) {
        _endianness = 'LE';
      } else {
        throw new Error('unable to figure out endianess');
      }
    }

    return _endianness;
  }
  function hostname() {
    if (typeof global$1.location !== 'undefined') {
      return global$1.location.hostname;
    } else return '';
  }
  function loadavg() {
    return [];
  }
  function uptime$1() {
    return 0;
  }
  function freemem() {
    return Number.MAX_VALUE;
  }
  function totalmem() {
    return Number.MAX_VALUE;
  }
  function cpus() {
    return [];
  }
  function type() {
    return 'Browser';
  }
  function release$1() {
    if (typeof global$1.navigator !== 'undefined') {
      return global$1.navigator.appVersion;
    }

    return '';
  }
  function networkInterfaces() {}
  function getNetworkInterfaces() {}
  function tmpDir() {
    return '/tmp';
  }
  var tmpdir = tmpDir;
  var EOL = '\n';
  var os = {
    EOL: EOL,
    tmpdir: tmpdir,
    tmpDir: tmpDir,
    networkInterfaces: networkInterfaces,
    getNetworkInterfaces: getNetworkInterfaces,
    release: release$1,
    type: type,
    cpus: cpus,
    totalmem: totalmem,
    freemem: freemem,
    uptime: uptime$1,
    loadavg: loadavg,
    hostname: hostname,
    endianness: endianness
  };

  function pickInterface(interfaces, family) {
    /* eslint-disable */
    for (var i in interfaces) {
      /* eslint-enable */
      for (var j = interfaces[i].length - 1; j >= 0; j -= 1) {
        var face = interfaces[i][j];
        var reachable = family === 'IPv4' || face.scopeid === 0;
        if (!face.internal && face.family === family && reachable) return face.address;
      }
    }

    return family === 'IPv4' ? '127.0.0.1' : '::1';
  }

  function reduceInterfaces(interfaces, iface) {
    var ifaces = {};
    /*eslint-disable */

    for (var i in interfaces) {
      /* eslint-enable */
      if (i === iface) ifaces[i] = interfaces[i];
    }

    return ifaces;
  }

  function ipv4(iface) {
    var interfaces = os.networkInterfaces();
    if (iface) interfaces = reduceInterfaces(interfaces, iface);
    return pickInterface(interfaces, 'IPv4');
  }

  function ipv6(iface) {
    var interfaces = os.networkInterfaces();
    if (iface) interfaces = reduceInterfaces(interfaces, iface);
    return pickInterface(interfaces, 'IPv6');
  }

  ipv4.ipv4 = ipv4;
  ipv4.ipv6 = ipv6;
  var network = ipv4;

  var InetAddress = /*#__PURE__*/function () {
    function InetAddress(addr) {
      _classCallCheck(this, InetAddress);

      this.addr = addr;
    } // returns undefined if this isn't an IPv4 string


    _createClass(InetAddress, [{
      key: "ipv4",
      value: function ipv4() {
        // coercing to int forces validation here
        var ipv4Int = this.toInt();

        if (ipv4Int && ipv4Int !== 0) {
          return this.addr;
        }

        return undefined;
      }
    }, {
      key: "toInt",
      value: function toInt() {
        // e.g. 10.57.50.83
        // should become
        // 171520595
        var parts = this.addr.split('.'); // The eslint tool always complains about using bitwise operators,
        // but in this case it's actually intentional, so we disable the warning:

        /* eslint-disable-next-line */

        return parts[0] << 24 | parts[1] << 16 | parts[2] << 8 | parts[3];
      }
    }, {
      key: "toString",
      value: function toString() {
        return "InetAddress(".concat(this.addr, ")");
      }
    }]);

    return InetAddress;
  }(); // In non-node environments we fallback to 127.0.0.1


  function getLocalAddress() {
    var isNode = (typeof process === "undefined" ? "undefined" : _typeof(process)) === 'object' && typeof process.on === 'function';

    if (!isNode) {
      return new InetAddress('127.0.0.1');
    } // eslint-disable-next-line global-require


    var networkAddress = network;
    return new InetAddress(networkAddress.ipv4());
  } // Cache this value at import time so as to avoid network interface
  // lookup on every call


  var cachedLocalAddress = getLocalAddress();

  InetAddress.getLocalAddress = function () {
    return cachedLocalAddress;
  };

  var InetAddress_1 = InetAddress;

  var SimpleAnnotation = /*#__PURE__*/function () {
    function SimpleAnnotation() {
      _classCallCheck(this, SimpleAnnotation);
    }

    _createClass(SimpleAnnotation, [{
      key: "toString",
      value: function toString() {
        return "".concat(this.annotationType, "()");
      }
    }]);

    return SimpleAnnotation;
  }();

  var ClientSend = /*#__PURE__*/function (_SimpleAnnotation) {
    _inherits(ClientSend, _SimpleAnnotation);

    var _super = _createSuper(ClientSend);

    function ClientSend() {
      _classCallCheck(this, ClientSend);

      return _super.apply(this, arguments);
    }

    return ClientSend;
  }(SimpleAnnotation);

  var ClientRecv = /*#__PURE__*/function (_SimpleAnnotation2) {
    _inherits(ClientRecv, _SimpleAnnotation2);

    var _super2 = _createSuper(ClientRecv);

    function ClientRecv() {
      _classCallCheck(this, ClientRecv);

      return _super2.apply(this, arguments);
    }

    return ClientRecv;
  }(SimpleAnnotation);

  var ServerSend = /*#__PURE__*/function (_SimpleAnnotation3) {
    _inherits(ServerSend, _SimpleAnnotation3);

    var _super3 = _createSuper(ServerSend);

    function ServerSend() {
      _classCallCheck(this, ServerSend);

      return _super3.apply(this, arguments);
    }

    return ServerSend;
  }(SimpleAnnotation);

  var ServerRecv = /*#__PURE__*/function (_SimpleAnnotation4) {
    _inherits(ServerRecv, _SimpleAnnotation4);

    var _super4 = _createSuper(ServerRecv);

    function ServerRecv() {
      _classCallCheck(this, ServerRecv);

      return _super4.apply(this, arguments);
    }

    return ServerRecv;
  }(SimpleAnnotation);

  var ProducerStart = /*#__PURE__*/function (_SimpleAnnotation5) {
    _inherits(ProducerStart, _SimpleAnnotation5);

    var _super5 = _createSuper(ProducerStart);

    function ProducerStart() {
      _classCallCheck(this, ProducerStart);

      return _super5.apply(this, arguments);
    }

    return ProducerStart;
  }(SimpleAnnotation);

  var ProducerStop = /*#__PURE__*/function (_SimpleAnnotation6) {
    _inherits(ProducerStop, _SimpleAnnotation6);

    var _super6 = _createSuper(ProducerStop);

    function ProducerStop() {
      _classCallCheck(this, ProducerStop);

      return _super6.apply(this, arguments);
    }

    return ProducerStop;
  }(SimpleAnnotation);

  var ConsumerStart = /*#__PURE__*/function (_SimpleAnnotation7) {
    _inherits(ConsumerStart, _SimpleAnnotation7);

    var _super7 = _createSuper(ConsumerStart);

    function ConsumerStart() {
      _classCallCheck(this, ConsumerStart);

      return _super7.apply(this, arguments);
    }

    return ConsumerStart;
  }(SimpleAnnotation);

  var ConsumerStop = /*#__PURE__*/function (_SimpleAnnotation8) {
    _inherits(ConsumerStop, _SimpleAnnotation8);

    var _super8 = _createSuper(ConsumerStop);

    function ConsumerStop() {
      _classCallCheck(this, ConsumerStop);

      return _super8.apply(this, arguments);
    }

    return ConsumerStop;
  }(SimpleAnnotation);

  function LocalOperationStart(name) {
    this.name = name;
  }

  LocalOperationStart.prototype.toString = function () {
    return "LocalOperationStart(\"".concat(this.name, "\")");
  };

  var LocalOperationStop = /*#__PURE__*/function (_SimpleAnnotation9) {
    _inherits(LocalOperationStop, _SimpleAnnotation9);

    var _super9 = _createSuper(LocalOperationStop);

    function LocalOperationStop() {
      _classCallCheck(this, LocalOperationStop);

      return _super9.apply(this, arguments);
    }

    return LocalOperationStop;
  }(SimpleAnnotation);

  function Message(message) {
    this.message = message;
  }

  Message.prototype.toString = function () {
    return "Message(\"".concat(this.message, "\")");
  };

  function ServiceName(serviceName) {
    this.serviceName = serviceName;
  }

  ServiceName.prototype.toString = function () {
    return "ServiceName(\"".concat(this.serviceName, "\")");
  };

  function Rpc(name) {
    this.name = name;
  }

  Rpc.prototype.toString = function () {
    return "Rpc(\"".concat(this.name, "\")");
  };

  function ClientAddr(_ref) {
    var host = _ref.host,
        port = _ref.port;
    this.host = host;
    this.port = port;
  }

  ClientAddr.prototype.toString = function () {
    return "ClientAddr(host=\"".concat(this.host, "\", port=").concat(this.port, ")");
  };

  function ServerAddr(_ref2) {
    var serviceName = _ref2.serviceName,
        host = _ref2.host,
        port = _ref2.port;
    this.serviceName = serviceName;
    this.host = host || undefined;
    this.port = port || 0;
  }

  ServerAddr.prototype.toString = function () {
    return "ServerAddr(serviceName=\"".concat(this.serviceName, "\", host=\"").concat(this.host, "\", port=").concat(this.port, ")");
  };

  function LocalAddr(_ref3) {
    var host = _ref3.host,
        port = _ref3.port;
    this.host = host || InetAddress_1.getLocalAddress();
    this.port = port || 0;
  }

  LocalAddr.prototype.toString = function () {
    return "LocalAddr(host=\"".concat(this.host.toString(), "\", port=").concat(this.port, ")");
  };

  function MessageAddr(_ref4) {
    var serviceName = _ref4.serviceName,
        host = _ref4.host,
        port = _ref4.port;
    this.serviceName = serviceName;
    this.host = host;
    this.port = port;
  }

  MessageAddr.prototype.toString = function () {
    return "MessageAddr(serviceName=\"".concat(this.serviceName, "\", host=\"").concat(this.host, "\", port=").concat(this.port, ")");
  };

  function BinaryAnnotation(key, value) {
    this.key = key;
    this.value = value;
  }

  BinaryAnnotation.prototype.toString = function () {
    return "BinaryAnnotation(".concat(this.key, "=\"").concat(this.value, "\")");
  };

  var annotation = {
    ClientSend: ClientSend,
    ClientRecv: ClientRecv,
    ServerSend: ServerSend,
    ServerRecv: ServerRecv,
    ProducerStart: ProducerStart,
    ProducerStop: ProducerStop,
    ConsumerStart: ConsumerStart,
    ConsumerStop: ConsumerStop,
    MessageAddr: MessageAddr,
    Message: Message,
    ServiceName: ServiceName,
    Rpc: Rpc,
    ClientAddr: ClientAddr,
    ServerAddr: ServerAddr,
    LocalAddr: LocalAddr,
    BinaryAnnotation: BinaryAnnotation,
    LocalOperationStart: LocalOperationStart,
    LocalOperationStop: LocalOperationStop
  };
  Object.keys(annotation).forEach(function (key) {
    annotation[key].prototype.annotationType = key;
  });
  var annotation_1 = annotation;

  var isPromise_1 = isPromise;
  var default_1 = isPromise;

  function isPromise(obj) {
    return !!obj && (typeof obj === 'object' || typeof obj === 'function') && typeof obj.then === 'function';
  }
  isPromise_1.default = default_1;

  var Some$1 = option.Some; // Determines whether or not a traceId should be sampled.
  // If no sample decision is already made (by a debug flag, or
  // the "sampled" property is set), it will use evaluator,
  // which is a function traceId => Boolean, and returns true if
  // the traceId should be sampled (stored in Zipkin).

  var Sampler = /*#__PURE__*/function () {
    function Sampler(evaluator) {
      _classCallCheck(this, Sampler);

      this.evaluator = evaluator;
    }

    _createClass(Sampler, [{
      key: "shouldSample",
      value: function shouldSample(traceId) {
        var _this = this;

        var result = traceId.sampled.getOrElse(function () {
          return _this.evaluator(traceId);
        });
        return new Some$1(result);
      }
    }, {
      key: "toString",
      value: function toString() {
        return "Sampler(".concat(this.evaluator.toString(), ")");
      }
    }]);

    return Sampler;
  }();

  function neverSample(traceId) {
    // eslint-disable-line no-unused-vars
    return false;
  }

  neverSample.toString = function () {
    return 'never sample';
  };

  function alwaysSample(traceId) {
    // eslint-disable-line no-unused-vars
    return true;
  }

  alwaysSample.toString = function () {
    return 'always sample';
  };

  function makeCountingEvaluator(sampleRate) {
    if (sampleRate <= 0) {
      return neverSample;
    } else if (sampleRate >= 1) {
      return alwaysSample;
    } else {
      var counter = 0;
      var limit = parseInt(1 / sampleRate);

      var counting = function counting(traceId) {
        // eslint-disable-line no-unused-vars
        counter %= limit;
        var shouldSample = counter === 0;
        counter += 1;
        return shouldSample;
      };

      counting.toString = function () {
        return "countingSampler: sampleRate=".concat(sampleRate);
      };

      return counting;
    }
  }

  var CountingSampler = /*#__PURE__*/function (_Sampler) {
    _inherits(CountingSampler, _Sampler);

    var _super = _createSuper(CountingSampler);

    function CountingSampler() {
      var sampleRate = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;

      _classCallCheck(this, CountingSampler);

      return _super.call(this, makeCountingEvaluator(sampleRate < 1 ? sampleRate : 1));
    }

    return CountingSampler;
  }(Sampler);

  var sampler = {
    Sampler: Sampler,
    CountingSampler: CountingSampler,
    neverSample: neverSample,
    alwaysSample: alwaysSample
  };

  var Record = /*#__PURE__*/function () {
    function Record(_ref) {
      var traceId = _ref.traceId,
          timestamp = _ref.timestamp,
          annotation = _ref.annotation;

      _classCallCheck(this, Record);

      this.traceId = traceId;
      this.timestamp = timestamp;
      this.annotation = annotation;
    }

    _createClass(Record, [{
      key: "toString",
      value: function toString() {
        return "Record(traceId=".concat(this.traceId.toString(), ", annotation=").concat(this.annotation.toString(), ")");
      }
    }]);

    return Record;
  }();

  var record = Record;

  var Some$2 = option.Some,
      None$1 = option.None,
      verifyIsOptional$1 = option.verifyIsOptional,
      verifyIsNotOptional$1 = option.verifyIsNotOptional,
      isOptional$1 = option.isOptional;
  var T = new Some$2(true);

  var TraceId = /*#__PURE__*/function () {
    function TraceId(params) {
      _classCallCheck(this, TraceId);

      var spanId = params.spanId,
          _params$traceId = params.traceId,
          traceId = _params$traceId === void 0 ? spanId : _params$traceId,
          _params$parentId = params.parentId,
          parentId = _params$parentId === void 0 ? None$1 : _params$parentId,
          _params$flags = params.flags,
          flags = _params$flags === void 0 ? 0 : _params$flags,
          _params$debug = params.debug,
          debug = _params$debug === void 0 ? flags === 1 : _params$debug,
          _params$sampled = params.sampled,
          sampled = _params$sampled === void 0 ? None$1 : _params$sampled,
          _params$shared = params.shared,
          shared = _params$shared === void 0 ? false : _params$shared;
      verifyIsNotOptional$1(spanId);
      verifyIsOptional$1(parentId);
      verifyIsOptional$1(sampled); // support old signatures which allowed traceId to be optional

      if (isOptional$1(traceId)) {
        this._traceId = traceId.getOrElse(spanId);
      } else if (typeof traceId === 'undefined' || traceId === null) {
        this._traceId = spanId;
      } else {
        this._traceId = traceId;
      }

      this._parentId = parentId;
      this._spanId = spanId;
      this._sampled = debug ? T : sampled;
      this._debug = debug;
      this._shared = shared;
    }

    _createClass(TraceId, [{
      key: "isDebug",
      value: function isDebug() {
        return this._debug;
      }
    }, {
      key: "isShared",
      value: function isShared() {
        return this._shared;
      }
    }, {
      key: "toString",
      value: function toString() {
        return "TraceId(spanId=".concat(this.spanId.toString()) + ", parentSpanId=".concat(this.parentSpanId.toString()) + ", traceId=".concat(this.traceId.toString(), ")");
      }
    }, {
      key: "traceId",
      get: function get() {
        return this._traceId;
      }
    }, {
      key: "parentSpanId",
      get: function get() {
        return this._parentId;
      }
      /**
       * Please use parentSpanId instead as this can return confusing results (the span ID when absent).
       *
       * @deprecated since version v0.19
       */

    }, {
      key: "parentId",
      get: function get() {
        return this._parentId.getOrElse(this._spanId);
      }
    }, {
      key: "spanId",
      get: function get() {
        return this._spanId;
      }
    }, {
      key: "sampled",
      get: function get() {
        return this._sampled;
      }
      /**
       * Please use isDebug instead.
       *
       * @deprecated since version v0.19
       */

    }, {
      key: "flags",
      get: function get() {
        return this._debug ? 1 : 0;
      }
    }]);

    return TraceId;
  }();

  var TraceId_1 = TraceId;

  // === Generate a random 64-bit number in fixed-length hex format
  function randomTraceId() {
    var digits = '0123456789abcdef';
    var n = '';

    for (var i = 0; i < 16; i += 1) {
      var rand = Math.floor(Math.random() * 16);
      n += digits[rand];
    }

    return n;
  }

  var randomTraceId_1 = randomTraceId;

  var hrTimeSupport = typeof process !== 'undefined' && process.hrtime; // since hrtime isn't available, we can ignore the input parameters

  function nowLegacy() {
    return Date.now() * 1000;
  }

  function nowHrTime(startTimestamp, startTick) {
    if (startTimestamp && startTick) {
      var _hrtime = process.hrtime(startTick);

      var elapsedMicros = Math.floor(_hrtime[0] * 1000000 + _hrtime[1] / 1000);
      return startTimestamp + elapsedMicros;
    } else {
      return Date.now() * 1000;
    }
  } // Returns the current time in epoch microseconds
  // if startTimestamp and startTick are present, process.hrtime is used
  // See https://nodejs.org/api/process.html#process_process_hrtime_time


  var now = hrTimeSupport ? nowHrTime : nowLegacy;
  var hrtime$1 = hrTimeSupport ? function () {
    return process.hrtime();
  } : function () {
    return undefined;
  };
  var time = {
    now: now,
    hrtime: hrtime$1
  };

  function Endpoint(_ref) {
    var serviceName = _ref.serviceName,
        ipv4 = _ref.ipv4,
        port = _ref.port;
    this.setServiceName(serviceName);
    this.setIpv4(ipv4);
    this.setPort(port);
  }

  Endpoint.prototype.setServiceName = function setServiceName(serviceName) {
    // In zipkin, names are lowercase. This eagerly converts to alert users early.
    this.serviceName = serviceName ? serviceName.toLocaleLowerCase() : undefined;
  };

  Endpoint.prototype.setIpv4 = function setIpv4(ipv4) {
    this.ipv4 = ipv4;
  };

  Endpoint.prototype.setPort = function setPort(port) {
    this.port = port || undefined;
  };

  Endpoint.prototype.isEmpty = function isEmpty() {
    return this.serviceName === undefined && this.ipv4 === undefined && this.port === undefined;
  };

  function Annotation(timestamp, value) {
    this.timestamp = timestamp;
    this.value = value.toString();
  }

  Annotation.prototype.toString = function toString() {
    return "Annotation(value=\"".concat(this.value, "\")");
  };

  function Span(traceId) {
    var _this = this;

    this.traceId = traceId.traceId;
    traceId.parentSpanId.ifPresent(function (id) {
      _this.parentId = id;
    });
    this.id = traceId.spanId;
    this.name = undefined; // no default

    this.kind = undefined; // no default

    this.timestamp = undefined;
    this.duration = undefined;
    this.localEndpoint = undefined; // no default

    this.remoteEndpoint = undefined; // no default

    this.annotations = [];
    this.tags = {};
    this.debug = traceId.isDebug();
    this.shared = traceId.isShared();
  }

  Span.prototype.setName = function setName(name) {
    // In zipkin, names are lowercase. This eagerly converts to alert users early.
    this.name = name ? name.toLocaleLowerCase() : undefined;
  };

  Span.prototype.setKind = function setKind(kind) {
    this.kind = kind;
  };

  Span.prototype.setTimestamp = function setTimestamp(timestamp) {
    this.timestamp = timestamp;
  };

  Span.prototype.setDuration = function setDuration(duration) {
    // Due to rounding errors, a fraction ends up as zero, so check undefined
    if (typeof duration !== 'undefined') {
      this.duration = Math.max(duration, 1);
    }
  };

  Span.prototype.setLocalEndpoint = function setLocalEndpoint(ep) {
    if (ep && !ep.isEmpty()) {
      this.localEndpoint = ep;
    } else {
      this.localEndpoint = undefined;
    }
  };

  Span.prototype.setRemoteEndpoint = function setRemoteEndpoint(ep) {
    if (ep && !ep.isEmpty()) {
      this.remoteEndpoint = ep;
    } else {
      this.remoteEndpoint = undefined;
    }
  };

  Span.prototype.addAnnotation = function addAnnotation(timestamp, value) {
    this.annotations.push(new Annotation(timestamp, value));
  };

  Span.prototype.putTag = function putTag(key, value) {
    this.tags[key] = value.toString();
  };

  Span.prototype.setDebug = function setDebug(debug) {
    this.debug = debug;
  };

  Span.prototype.setShared = function setShared(shared) {
    this.shared = shared;
  };

  Span.prototype.toString = function toString() {
    var annotations = this.annotations.map(function (a) {
      return a.toString();
    }).join(', ');
    return "Span(id=".concat(this.traceId, ", annotations=[").concat(annotations, "])");
  };

  var Endpoint_1 = Endpoint;
  var Span_1 = Span;
  var model = {
    Endpoint: Endpoint_1,
    Span: Span_1
  };

  var None$2 = option.None,
      Some$3 = option.Some;
  var Sampler$1 = sampler.Sampler,
      alwaysSample$1 = sampler.alwaysSample;
  var now$1 = time.now,
      hrtime$2 = time.hrtime;
  var Endpoint$1 = model.Endpoint;

  function requiredArg(name) {
    throw new Error("Tracer: Missing required argument ".concat(name, "."));
  }

  function isUndefinedOrNull(obj) {
    return typeof obj === 'undefined' || obj === null;
  }

  var Tracer = /*#__PURE__*/function () {
    function Tracer(_ref) {
      var _ref$ctxImpl = _ref.ctxImpl,
          ctxImpl = _ref$ctxImpl === void 0 ? requiredArg('ctxImpl') : _ref$ctxImpl,
          _ref$recorder = _ref.recorder,
          recorder = _ref$recorder === void 0 ? requiredArg('recorder') : _ref$recorder,
          _ref$sampler = _ref.sampler,
          sampler$$1 = _ref$sampler === void 0 ? new Sampler$1(alwaysSample$1) : _ref$sampler,
          _ref$traceId128Bit = _ref.traceId128Bit,
          traceId128Bit = _ref$traceId128Bit === void 0 ? false : _ref$traceId128Bit,
          _ref$supportsJoin = _ref.supportsJoin,
          supportsJoin = _ref$supportsJoin === void 0 ? true : _ref$supportsJoin,
          localServiceName = _ref.localServiceName,
          localEndpoint = _ref.localEndpoint,
          _ref$log = _ref.log,
          log = _ref$log === void 0 ? console : _ref$log,
          defaultTags = _ref.defaultTags;

      _classCallCheck(this, Tracer);

      this.log = log;
      this.recorder = recorder;
      this.sampler = sampler$$1;
      this.traceId128Bit = traceId128Bit;
      this.supportsJoin = supportsJoin;

      if (localEndpoint) {
        this._localEndpoint = localEndpoint;
      } else {
        this._localEndpoint = new Endpoint$1({
          serviceName: localServiceName || 'unknown'
        });
      }

      this._ctxImpl = ctxImpl; // The sentinel is used until there's a trace ID in scope.
      // Technically, this ID should have been unsampled, but it can break code to change that now.

      this._sentinelTraceId = this.createRootId();
      this._startTimestamp = now$1();
      this._startTick = hrtime$2(); // only set defaultTags in recorders which know about it

      if (this.recorder.setDefaultTags) {
        this.recorder.setDefaultTags(defaultTags);
      }
    }

    _createClass(Tracer, [{
      key: "scoped",
      value: function scoped(callback) {
        return this._ctxImpl.scoped(callback);
      }
    }, {
      key: "letId",
      value: function letId(id, callback) {
        return this._ctxImpl.letContext(id, callback);
      }
    }, {
      key: "createRootId",
      value: function createRootId() {
        var isSampled = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : None$2;
        var isDebug = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
        var rootSpanId = randomTraceId_1();
        var traceId = this.traceId128Bit ? randomTraceId_1() + rootSpanId : rootSpanId;
        var id = new TraceId_1({
          traceId: traceId,
          parentId: None$2,
          spanId: rootSpanId,
          sampled: isSampled,
          flags: isDebug ? 1 : 0
        });

        if (isSampled === None$2) {
          id._sampled = this.sampler.shouldSample(id);
        }

        return id;
      }
    }, {
      key: "createChildId",
      value: function createChildId(parentId) {
        if (isUndefinedOrNull(parentId)) {
          /* eslint-disable no-param-reassign */
          parentId = this._ctxImpl.getContext();
        }

        if (parentId === this._sentinelTraceId || isUndefinedOrNull(parentId)) {
          return this.createRootId();
        }

        var childId = new TraceId_1({
          traceId: parentId.traceId,
          parentId: new Some$3(parentId.spanId),
          spanId: randomTraceId_1(),
          debug: parentId.isDebug(),
          sampled: parentId.sampled
        });

        if (childId.sampled.present === false) {
          childId._sampled = this.sampler.shouldSample(childId);
        }

        return childId;
      } // this allows you to avoid use of implicit trace ID and defer implicit timestamp derivation

    }, {
      key: "_explicitRecord",
      value: function _explicitRecord(traceId, annotation) {
        var timestamp = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : now$1(this._startTimestamp, this._startTick);
        this.recorder.record(new record({
          traceId: traceId,
          timestamp: timestamp,
          annotation: annotation
        }));
      } // creates a span, timing the given callable, adding any error as a tag
      // if the callable returns a promise, a span stops after the promise resolves

    }, {
      key: "local",
      value: function local(operationName, callable) {
        var _this = this;

        if (typeof callable !== 'function') {
          throw new Error('you must pass a function');
        }

        return this.scoped(function () {
          var traceId = _this.createChildId();

          _this.setId(traceId);

          _this.recordServiceName(_this._localEndpoint.serviceName);

          _this.recordAnnotation(new annotation_1.LocalOperationStart(operationName));

          var result;

          try {
            result = callable();
          } catch (err) {
            _this.recordBinary('error', err.message ? err.message : err.toString());

            _this.recordAnnotation(new annotation_1.LocalOperationStop());

            throw err;
          } // Finish the span on a synchronous success


          if (!isPromise_1(result)) {
            _this.recordAnnotation(new annotation_1.LocalOperationStop());

            return result;
          }

          if (!traceId.sampled.getOrElse(false)) {
            return result; // no need to stop as it was never started
          } // At this point we know we are sampled. Explicitly record against the ID
          // Ensure the span representing the promise completes


          return result.then(function (output) {
            _this._explicitRecord(traceId, new annotation_1.LocalOperationStop());

            return output;
          })["catch"](function (err) {
            var message = err.message ? err.message : err.toString();

            _this._explicitRecord(traceId, new annotation_1.BinaryAnnotation('error', message));

            _this._explicitRecord(traceId, new annotation_1.LocalOperationStop());

            throw err;
          });
        });
      }
    }, {
      key: "join",
      value: function join(traceId) {
        if (isUndefinedOrNull(traceId)) {
          throw new Error('traceId is a required arg');
        } // duck type check until we sort out a better way. We don't want to break
        // transpiled usage ex. `traceId instanceof TraceId_1: false` See #422


        if (isUndefinedOrNull(traceId._spanId)) {
          throw new Error('Must be valid TraceId instance');
        }

        if (!this.supportsJoin) {
          return this.createChildId(traceId);
        }

        if (traceId.sampled === None$2) {
          /* eslint-disable no-param-reassign */
          traceId._sampled = this.sampler.shouldSample(traceId);
        } else {
          /* eslint-disable no-param-reassign */
          traceId._shared = true;
        }

        return traceId;
      }
    }, {
      key: "setId",
      value: function setId(traceId) {
        this._ctxImpl.setContext(traceId);
      } // Returns the current trace ID or a sentinel value indicating its absence.

    }, {
      key: "recordAnnotation",
      value: function recordAnnotation(annotation, timestamp) {
        if (this.id.sampled.getOrElse(false)) {
          this._explicitRecord(this.id, annotation, timestamp);
        }
      }
    }, {
      key: "recordMessage",
      value: function recordMessage(message) {
        this.recordAnnotation(new annotation_1.Message(message));
      }
    }, {
      key: "recordServiceName",
      value: function recordServiceName(serviceName) {
        this.recordAnnotation(new annotation_1.ServiceName(serviceName));
      }
    }, {
      key: "recordRpc",
      value: function recordRpc(name) {
        this.recordAnnotation(new annotation_1.Rpc(name));
      }
    }, {
      key: "recordClientAddr",
      value: function recordClientAddr(ia) {
        this.recordAnnotation(new annotation_1.ClientAddr(ia));
      }
    }, {
      key: "recordServerAddr",
      value: function recordServerAddr(ia) {
        this.recordAnnotation(new annotation_1.ServerAddr(ia));
      }
    }, {
      key: "recordLocalAddr",
      value: function recordLocalAddr(ia) {
        this.recordAnnotation(new annotation_1.LocalAddr(ia));
      }
    }, {
      key: "recordBinary",
      value: function recordBinary(key, value) {
        this.recordAnnotation(new annotation_1.BinaryAnnotation(key, value));
      }
    }, {
      key: "writeIdToConsole",
      value: function writeIdToConsole(message) {
        this.log.info("".concat(message, ": ").concat(this.id.toString()));
      }
    }, {
      key: "setTags",
      value: function setTags() {
        var tags = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        // eslint-disable-next-line no-restricted-syntax
        for (var tag in tags) {
          if (Object.prototype.hasOwnProperty.call(tags, tag)) {
            this.recordBinary(tag, tags[tag]);
          }
        }
      }
    }, {
      key: "id",
      get: function get() {
        return this._ctxImpl.getContext() || this._sentinelTraceId;
      }
    }, {
      key: "localEndpoint",
      get: function get() {
        return this._localEndpoint;
      }
    }]);

    return Tracer;
  }();

  var tracer = Tracer;

  var explicitContext = /*#__PURE__*/function () {
    function ExplicitContext() {
      _classCallCheck(this, ExplicitContext);

      this.currentCtx = null;
    }

    _createClass(ExplicitContext, [{
      key: "setContext",
      value: function setContext(ctx) {
        this.currentCtx = ctx;
      }
    }, {
      key: "getContext",
      value: function getContext() {
        return this.currentCtx;
      }
    }, {
      key: "scoped",
      value: function scoped(callable) {
        var prevCtx = this.getContext();

        try {
          return callable();
        } finally {
          this.setContext(prevCtx);
        }
      }
    }, {
      key: "letContext",
      value: function letContext(ctx, callable) {
        var _this = this;

        return this.scoped(function () {
          _this.setContext(ctx);

          return callable();
        });
      }
    }]);

    return ExplicitContext;
  }();

  var noop$1 = function createNoopTracer() {
    var recorder = {
      record: function record() {}
    };
    var ctxImpl = new explicitContext();
    return new tracer({
      recorder: recorder,
      ctxImpl: ctxImpl
    });
  };

  var httpHeaders = {
    TraceId: 'X-B3-TraceId',
    SpanId: 'X-B3-SpanId',
    ParentSpanId: 'X-B3-ParentSpanId',
    Sampled: 'X-B3-Sampled',
    Flags: 'X-B3-Flags'
  };

  var now$2 = time.now;
  var Span$1 = model.Span,
      Endpoint$2 = model.Endpoint;
  /**
   * defaultTags property name
   * @type {symbol}
   */

  var defaultTagsSymbol = Symbol('defaultTags');

  function _timedOut(span) {
    return span.timeoutTimestamp < now$2();
  }
  /**
   * @class PartialSpan
   */


  var PartialSpan = /*#__PURE__*/function () {
    /**
     * @constructor
     * @param {TraceId} traceId
     * @param {number} timeoutTimestamp (epoch in microseconds) after this moment, data
     * should be forcibly flushed
     */
    function PartialSpan(traceId, timeoutTimestamp) {
      _classCallCheck(this, PartialSpan);

      this.traceId = traceId;
      this.timeoutTimestamp = timeoutTimestamp;
      this.delegate = new Span$1(traceId);
      this.localEndpoint = new Endpoint$2({});
      this.shouldFlush = false;
    }
    /**
     * Conditionally records the duration of the span, if it has a timestamp.
     *
     * @param {number} finishTimestamp (epoch in microseconds) to calculate the duration from
     */


    _createClass(PartialSpan, [{
      key: "setDuration",
      value: function setDuration(finishTimestamp) {
        if (this.shouldFlush) {
          return;
        }

        this.shouldFlush = true; // even if we can't derive duration, we should report on finish

        var startTimestamp = this.delegate.timestamp;

        if (typeof startTimestamp === 'undefined') {
          // We can't calculate duration without a start timestamp,
          // but an annotation is better than nothing
          this.delegate.addAnnotation(finishTimestamp, 'finish');
        } else {
          this.delegate.setDuration(finishTimestamp - startTimestamp);
        }
      }
    }]);

    return PartialSpan;
  }();
  /**
   * default timeout = 60 seconds (in microseconds)
   * @type {number}
   */


  var defaultTimeout = 60 * 1000000;
  /**
   * @class BatchRecorder
   */

  var BatchRecorder = /*#__PURE__*/function () {
    /**
     * @constructor
     * @param {Object} options
     * @param {Logger} options.logger logs the data to zipkin server
     * @param {number} options.timeout timeout after which an unfinished span
     * is flushed to zipkin in **microseconds**. Passing this value has
     * implications in the reported data of the span so we discourage users
     * to pass a value for it unless there is a good reason for.
     */
    function BatchRecorder(_ref) {
      var _this = this;

      var logger = _ref.logger,
          _ref$timeout = _ref.timeout,
          timeout = _ref$timeout === void 0 ? defaultTimeout : _ref$timeout;

      _classCallCheck(this, BatchRecorder);

      this.logger = logger;
      this.timeout = timeout;
      /**
       * @type Map<string, PartialSpan>
       */

      this.partialSpans = new Map();
      this[defaultTagsSymbol] = {}; // read through the partials spans regularly
      // and collect any timed-out ones

      var timer = setInterval(function () {
        _this.partialSpans.forEach(function (span, id) {
          if (_timedOut(span)) {
            // the zipkin-js.flush annotation makes it explicit that
            // the span has been reported because of a timeout, even
            // when it is not finished yet (and thus enqueued for reporting)
            span.delegate.addAnnotation(now$2(), 'zipkin-js.flush');

            _this._writeSpan(id, span);
          }
        });
      }, 1000); // every second, this will flush to zipkin any spans that have timed out

      if (timer.unref) {
        // unref might not be available in browsers
        timer.unref(); // Allows Node to terminate instead of blocking on timer
      }
    }

    _createClass(BatchRecorder, [{
      key: "_addDefaultTagsAndLocalEndpoint",
      value: function _addDefaultTagsAndLocalEndpoint(span) {
        var defaultTags = this[defaultTagsSymbol]; // eslint-disable-next-line no-restricted-syntax

        for (var tag in defaultTags) {
          if (Object.prototype.hasOwnProperty.call(defaultTags, tag)) {
            span.delegate.putTag(tag, defaultTags[tag]);
          }
        }

        span.delegate.setLocalEndpoint(span.localEndpoint);
      }
    }, {
      key: "_writeSpan",
      value: function _writeSpan(id,
      /** @type PartialSpan */
      span) {
        var isNew = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

        // TODO(adriancole) refactor so this responsibility isn't in writeSpan
        if (!isNew && typeof this.partialSpans.get(id) === 'undefined') {
          // Span not found. Could have been expired.
          return;
        } // ready for garbage collection


        this.partialSpans["delete"](id);
        var spanToWrite = span.delegate; // Only add default tags and local endpoint on the first report of a span

        if (span.delegate.timestamp) {
          this._addDefaultTagsAndLocalEndpoint(span);
        }

        this.logger.logSpan(spanToWrite);
      }
    }, {
      key: "_updateSpanMap",
      value: function _updateSpanMap(id, timestamp, updater) {
        var span;
        var isNew = false; // we need to special case late finish annotations

        if (this.partialSpans.has(id)) {
          span = this.partialSpans.get(id);
        } else {
          isNew = true;
          span = new PartialSpan(id, timestamp + this.timeout);
        }

        updater(span);

        if (span.shouldFlush) {
          this._writeSpan(id, span, isNew);
        } else {
          this.partialSpans.set(id, span);
        }
      }
      /**
       * Calling this will flush any pending spans to the transport.
       *
       * Note: the transport itself may be batching, in such case you may need to flush that also.
       */

    }, {
      key: "flush",
      value: function flush() {
        var _this2 = this;

        this.partialSpans.forEach(function (span, id) {
          _this2._writeSpan(id, span);
        });
      }
    }, {
      key: "record",
      value: function record(rec) {
        var id = rec.traceId;

        this._updateSpanMap(id, rec.timestamp, function (
        /** @type PartialSpan */
        span) {
          switch (rec.annotation.annotationType) {
            case 'ClientAddr':
              span.delegate.setKind('SERVER');
              span.delegate.setRemoteEndpoint(new Endpoint$2({
                serviceName: rec.annotation.serviceName,
                ipv4: rec.annotation.host && rec.annotation.host.ipv4(),
                port: rec.annotation.port
              }));
              break;

            case 'ClientSend':
              span.delegate.setKind('CLIENT');
              span.delegate.setTimestamp(rec.timestamp);
              break;

            case 'ClientRecv':
              span.delegate.setKind('CLIENT');
              span.setDuration(rec.timestamp);
              break;

            case 'ServerSend':
              span.delegate.setKind('SERVER');
              span.setDuration(rec.timestamp);
              break;

            case 'ServerRecv':
              span.delegate.setShared(id.isShared());
              span.delegate.setKind('SERVER');
              span.delegate.setTimestamp(rec.timestamp);
              break;

            case 'ProducerStart':
              span.delegate.setKind('PRODUCER');
              span.delegate.setTimestamp(rec.timestamp);
              break;

            case 'ProducerStop':
              span.delegate.setKind('PRODUCER');
              span.setDuration(rec.timestamp);
              break;

            case 'ConsumerStart':
              span.delegate.setKind('CONSUMER');
              span.delegate.setTimestamp(rec.timestamp);
              break;

            case 'ConsumerStop':
              span.delegate.setKind('CONSUMER');
              span.setDuration(rec.timestamp);
              break;

            case 'MessageAddr':
              span.delegate.setRemoteEndpoint(new Endpoint$2({
                serviceName: rec.annotation.serviceName,
                ipv4: rec.annotation.host && rec.annotation.host.ipv4(),
                port: rec.annotation.port
              }));
              break;

            case 'LocalOperationStart':
              span.delegate.setName(rec.annotation.name);
              span.delegate.setTimestamp(rec.timestamp);
              break;

            case 'LocalOperationStop':
              span.setDuration(rec.timestamp);
              break;

            case 'Message':
              span.delegate.addAnnotation(rec.timestamp, rec.annotation.message);
              break;

            case 'Rpc':
              span.delegate.setName(rec.annotation.name);
              break;

            case 'ServiceName':
              span.localEndpoint.setServiceName(rec.annotation.serviceName);
              break;

            case 'BinaryAnnotation':
              span.delegate.putTag(rec.annotation.key, rec.annotation.value);
              break;

            case 'LocalAddr':
              span.localEndpoint.setIpv4(rec.annotation.host && rec.annotation.host.ipv4());
              span.localEndpoint.setPort(rec.annotation.port);
              break;

            case 'ServerAddr':
              span.delegate.setKind('CLIENT');
              span.delegate.setRemoteEndpoint(new Endpoint$2({
                serviceName: rec.annotation.serviceName,
                ipv4: rec.annotation.host && rec.annotation.host.ipv4(),
                port: rec.annotation.port
              }));
              break;

            default:
              break;
          }
        });
      }
    }, {
      key: "setDefaultTags",
      value: function setDefaultTags(tags) {
        this[defaultTagsSymbol] = tags;
      }
    }, {
      key: "toString",
      value: function toString() {
        // eslint-disable-line class-methods-use-this
        return 'BatchRecorder()';
      }
    }]);

    return BatchRecorder;
  }();

  var batchRecorder = BatchRecorder;

  /**
   * @class ConsoleRecorder
   */
  var ConsoleRecorder = /*#__PURE__*/function () {
    /* eslint-disable no-console */
    function ConsoleRecorder() {
      var logger = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : console.log;

      _classCallCheck(this, ConsoleRecorder);

      this.logger = logger;
    }

    _createClass(ConsoleRecorder, [{
      key: "record",
      value: function record(rec) {
        var _rec$traceId = rec.traceId,
            spanId = _rec$traceId.spanId,
            parentId = _rec$traceId.parentId,
            traceId = _rec$traceId.traceId;
        this.logger("Record at (timestamp=".concat(rec.timestamp, ", spanId=").concat(spanId, ", parentId=").concat(parentId, ", ") + "traceId=".concat(traceId, "): ").concat(rec.annotation.toString()));
      }
    }, {
      key: "toString",
      value: function toString() {
        // eslint-disable-line class-methods-use-this
        return 'consoleTracer';
      }
    }]);

    return ConsoleRecorder;
  }();

  var consoleRecorder = ConsoleRecorder;

  /*! https://mths.be/punycode v1.4.1 by @mathias */

  /** Highest positive signed 32-bit float value */
  var maxInt = 2147483647; // aka. 0x7FFFFFFF or 2^31-1

  /** Bootstring parameters */

  var base = 36;
  var tMin = 1;
  var tMax = 26;
  var skew = 38;
  var damp = 700;
  var initialBias = 72;
  var initialN = 128; // 0x80

  var delimiter = '-'; // '\x2D'
  var regexNonASCII = /[^\x20-\x7E]/; // unprintable ASCII chars + non-ASCII chars

  var regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g; // RFC 3490 separators

  /** Error messages */

  var errors = {
    'overflow': 'Overflow: input needs wider integers to process',
    'not-basic': 'Illegal input >= 0x80 (not a basic code point)',
    'invalid-input': 'Invalid input'
  };
  /** Convenience shortcuts */

  var baseMinusTMin = base - tMin;
  var floor = Math.floor;
  var stringFromCharCode = String.fromCharCode;
  /*--------------------------------------------------------------------------*/

  /**
   * A generic error utility function.
   * @private
   * @param {String} type The error type.
   * @returns {Error} Throws a `RangeError` with the applicable error message.
   */

  function error(type) {
    throw new RangeError(errors[type]);
  }
  /**
   * A generic `Array#map` utility function.
   * @private
   * @param {Array} array The array to iterate over.
   * @param {Function} callback The function that gets called for every array
   * item.
   * @returns {Array} A new array of values returned by the callback function.
   */


  function map(array, fn) {
    var length = array.length;
    var result = [];

    while (length--) {
      result[length] = fn(array[length]);
    }

    return result;
  }
  /**
   * A simple `Array#map`-like wrapper to work with domain name strings or email
   * addresses.
   * @private
   * @param {String} domain The domain name or email address.
   * @param {Function} callback The function that gets called for every
   * character.
   * @returns {Array} A new string of characters returned by the callback
   * function.
   */


  function mapDomain(string, fn) {
    var parts = string.split('@');
    var result = '';

    if (parts.length > 1) {
      // In email addresses, only the domain name should be punycoded. Leave
      // the local part (i.e. everything up to `@`) intact.
      result = parts[0] + '@';
      string = parts[1];
    } // Avoid `split(regex)` for IE8 compatibility. See #17.


    string = string.replace(regexSeparators, '\x2E');
    var labels = string.split('.');
    var encoded = map(labels, fn).join('.');
    return result + encoded;
  }
  /**
   * Creates an array containing the numeric code points of each Unicode
   * character in the string. While JavaScript uses UCS-2 internally,
   * this function will convert a pair of surrogate halves (each of which
   * UCS-2 exposes as separate characters) into a single code point,
   * matching UTF-16.
   * @see `punycode.ucs2.encode`
   * @see <https://mathiasbynens.be/notes/javascript-encoding>
   * @memberOf punycode.ucs2
   * @name decode
   * @param {String} string The Unicode input string (UCS-2).
   * @returns {Array} The new array of code points.
   */


  function ucs2decode(string) {
    var output = [],
        counter = 0,
        length = string.length,
        value,
        extra;

    while (counter < length) {
      value = string.charCodeAt(counter++);

      if (value >= 0xD800 && value <= 0xDBFF && counter < length) {
        // high surrogate, and there is a next character
        extra = string.charCodeAt(counter++);

        if ((extra & 0xFC00) == 0xDC00) {
          // low surrogate
          output.push(((value & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000);
        } else {
          // unmatched surrogate; only append this code unit, in case the next
          // code unit is the high surrogate of a surrogate pair
          output.push(value);
          counter--;
        }
      } else {
        output.push(value);
      }
    }

    return output;
  }
  /**
   * Converts a digit/integer into a basic code point.
   * @see `basicToDigit()`
   * @private
   * @param {Number} digit The numeric value of a basic code point.
   * @returns {Number} The basic code point whose value (when used for
   * representing integers) is `digit`, which needs to be in the range
   * `0` to `base - 1`. If `flag` is non-zero, the uppercase form is
   * used; else, the lowercase form is used. The behavior is undefined
   * if `flag` is non-zero and `digit` has no uppercase form.
   */


  function digitToBasic(digit, flag) {
    //  0..25 map to ASCII a..z or A..Z
    // 26..35 map to ASCII 0..9
    return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
  }
  /**
   * Bias adaptation function as per section 3.4 of RFC 3492.
   * https://tools.ietf.org/html/rfc3492#section-3.4
   * @private
   */


  function adapt(delta, numPoints, firstTime) {
    var k = 0;
    delta = firstTime ? floor(delta / damp) : delta >> 1;
    delta += floor(delta / numPoints);

    for (;
    /* no initialization */
    delta > baseMinusTMin * tMax >> 1; k += base) {
      delta = floor(delta / baseMinusTMin);
    }

    return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
  }
  /**
   * Converts a string of Unicode symbols (e.g. a domain name label) to a
   * Punycode string of ASCII-only symbols.
   * @memberOf punycode
   * @param {String} input The string of Unicode symbols.
   * @returns {String} The resulting Punycode string of ASCII-only symbols.
   */

  function encode(input) {
    var n,
        delta,
        handledCPCount,
        basicLength,
        bias,
        j,
        m,
        q,
        k,
        t,
        currentValue,
        output = [],

    /** `inputLength` will hold the number of code points in `input`. */
    inputLength,

    /** Cached calculation results */
    handledCPCountPlusOne,
        baseMinusT,
        qMinusT; // Convert the input in UCS-2 to Unicode

    input = ucs2decode(input); // Cache the length

    inputLength = input.length; // Initialize the state

    n = initialN;
    delta = 0;
    bias = initialBias; // Handle the basic code points

    for (j = 0; j < inputLength; ++j) {
      currentValue = input[j];

      if (currentValue < 0x80) {
        output.push(stringFromCharCode(currentValue));
      }
    }

    handledCPCount = basicLength = output.length; // `handledCPCount` is the number of code points that have been handled;
    // `basicLength` is the number of basic code points.
    // Finish the basic string - if it is not empty - with a delimiter

    if (basicLength) {
      output.push(delimiter);
    } // Main encoding loop:


    while (handledCPCount < inputLength) {
      // All non-basic code points < n have been handled already. Find the next
      // larger one:
      for (m = maxInt, j = 0; j < inputLength; ++j) {
        currentValue = input[j];

        if (currentValue >= n && currentValue < m) {
          m = currentValue;
        }
      } // Increase `delta` enough to advance the decoder's <n,i> state to <m,0>,
      // but guard against overflow


      handledCPCountPlusOne = handledCPCount + 1;

      if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
        error('overflow');
      }

      delta += (m - n) * handledCPCountPlusOne;
      n = m;

      for (j = 0; j < inputLength; ++j) {
        currentValue = input[j];

        if (currentValue < n && ++delta > maxInt) {
          error('overflow');
        }

        if (currentValue == n) {
          // Represent delta as a generalized variable-length integer
          for (q = delta, k = base;;
          /* no condition */
          k += base) {
            t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;

            if (q < t) {
              break;
            }

            qMinusT = q - t;
            baseMinusT = base - t;
            output.push(stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0)));
            q = floor(qMinusT / baseMinusT);
          }

          output.push(stringFromCharCode(digitToBasic(q, 0)));
          bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
          delta = 0;
          ++handledCPCount;
        }
      }

      ++delta;
      ++n;
    }

    return output.join('');
  }
  /**
   * Converts a Unicode string representing a domain name or an email address to
   * Punycode. Only the non-ASCII parts of the domain name will be converted,
   * i.e. it doesn't matter if you call it with a domain that's already in
   * ASCII.
   * @memberOf punycode
   * @param {String} input The domain name or email address to convert, as a
   * Unicode string.
   * @returns {String} The Punycode representation of the given domain name or
   * email address.
   */

  function toASCII(input) {
    return mapDomain(input, function (string) {
      return regexNonASCII.test(string) ? 'xn--' + encode(string) : string;
    });
  }

  var lookup = [];
  var revLookup = [];
  var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array;
  var inited = false;

  function init() {
    inited = true;
    var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';

    for (var i = 0, len = code.length; i < len; ++i) {
      lookup[i] = code[i];
      revLookup[code.charCodeAt(i)] = i;
    }

    revLookup['-'.charCodeAt(0)] = 62;
    revLookup['_'.charCodeAt(0)] = 63;
  }

  function toByteArray(b64) {
    if (!inited) {
      init();
    }

    var i, j, l, tmp, placeHolders, arr;
    var len = b64.length;

    if (len % 4 > 0) {
      throw new Error('Invalid string. Length must be a multiple of 4');
    } // the number of equal signs (place holders)
    // if there are two placeholders, than the two characters before it
    // represent one byte
    // if there is only one, then the three characters before it represent 2 bytes
    // this is just a cheap hack to not do indexOf twice


    placeHolders = b64[len - 2] === '=' ? 2 : b64[len - 1] === '=' ? 1 : 0; // base64 is 4/3 + up to two characters of the original data

    arr = new Arr(len * 3 / 4 - placeHolders); // if there are placeholders, only get up to the last complete 4 chars

    l = placeHolders > 0 ? len - 4 : len;
    var L = 0;

    for (i = 0, j = 0; i < l; i += 4, j += 3) {
      tmp = revLookup[b64.charCodeAt(i)] << 18 | revLookup[b64.charCodeAt(i + 1)] << 12 | revLookup[b64.charCodeAt(i + 2)] << 6 | revLookup[b64.charCodeAt(i + 3)];
      arr[L++] = tmp >> 16 & 0xFF;
      arr[L++] = tmp >> 8 & 0xFF;
      arr[L++] = tmp & 0xFF;
    }

    if (placeHolders === 2) {
      tmp = revLookup[b64.charCodeAt(i)] << 2 | revLookup[b64.charCodeAt(i + 1)] >> 4;
      arr[L++] = tmp & 0xFF;
    } else if (placeHolders === 1) {
      tmp = revLookup[b64.charCodeAt(i)] << 10 | revLookup[b64.charCodeAt(i + 1)] << 4 | revLookup[b64.charCodeAt(i + 2)] >> 2;
      arr[L++] = tmp >> 8 & 0xFF;
      arr[L++] = tmp & 0xFF;
    }

    return arr;
  }

  function tripletToBase64(num) {
    return lookup[num >> 18 & 0x3F] + lookup[num >> 12 & 0x3F] + lookup[num >> 6 & 0x3F] + lookup[num & 0x3F];
  }

  function encodeChunk(uint8, start, end) {
    var tmp;
    var output = [];

    for (var i = start; i < end; i += 3) {
      tmp = (uint8[i] << 16) + (uint8[i + 1] << 8) + uint8[i + 2];
      output.push(tripletToBase64(tmp));
    }

    return output.join('');
  }

  function fromByteArray(uint8) {
    if (!inited) {
      init();
    }

    var tmp;
    var len = uint8.length;
    var extraBytes = len % 3; // if we have 1 byte left, pad 2 bytes

    var output = '';
    var parts = [];
    var maxChunkLength = 16383; // must be multiple of 3
    // go through the array every three bytes, we'll deal with trailing stuff later

    for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
      parts.push(encodeChunk(uint8, i, i + maxChunkLength > len2 ? len2 : i + maxChunkLength));
    } // pad the end with zeros, but make sure to not forget the extra bytes


    if (extraBytes === 1) {
      tmp = uint8[len - 1];
      output += lookup[tmp >> 2];
      output += lookup[tmp << 4 & 0x3F];
      output += '==';
    } else if (extraBytes === 2) {
      tmp = (uint8[len - 2] << 8) + uint8[len - 1];
      output += lookup[tmp >> 10];
      output += lookup[tmp >> 4 & 0x3F];
      output += lookup[tmp << 2 & 0x3F];
      output += '=';
    }

    parts.push(output);
    return parts.join('');
  }

  function read(buffer, offset, isLE, mLen, nBytes) {
    var e, m;
    var eLen = nBytes * 8 - mLen - 1;
    var eMax = (1 << eLen) - 1;
    var eBias = eMax >> 1;
    var nBits = -7;
    var i = isLE ? nBytes - 1 : 0;
    var d = isLE ? -1 : 1;
    var s = buffer[offset + i];
    i += d;
    e = s & (1 << -nBits) - 1;
    s >>= -nBits;
    nBits += eLen;

    for (; nBits > 0; e = e * 256 + buffer[offset + i], i += d, nBits -= 8) {}

    m = e & (1 << -nBits) - 1;
    e >>= -nBits;
    nBits += mLen;

    for (; nBits > 0; m = m * 256 + buffer[offset + i], i += d, nBits -= 8) {}

    if (e === 0) {
      e = 1 - eBias;
    } else if (e === eMax) {
      return m ? NaN : (s ? -1 : 1) * Infinity;
    } else {
      m = m + Math.pow(2, mLen);
      e = e - eBias;
    }

    return (s ? -1 : 1) * m * Math.pow(2, e - mLen);
  }
  function write(buffer, value, offset, isLE, mLen, nBytes) {
    var e, m, c;
    var eLen = nBytes * 8 - mLen - 1;
    var eMax = (1 << eLen) - 1;
    var eBias = eMax >> 1;
    var rt = mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0;
    var i = isLE ? 0 : nBytes - 1;
    var d = isLE ? 1 : -1;
    var s = value < 0 || value === 0 && 1 / value < 0 ? 1 : 0;
    value = Math.abs(value);

    if (isNaN(value) || value === Infinity) {
      m = isNaN(value) ? 1 : 0;
      e = eMax;
    } else {
      e = Math.floor(Math.log(value) / Math.LN2);

      if (value * (c = Math.pow(2, -e)) < 1) {
        e--;
        c *= 2;
      }

      if (e + eBias >= 1) {
        value += rt / c;
      } else {
        value += rt * Math.pow(2, 1 - eBias);
      }

      if (value * c >= 2) {
        e++;
        c /= 2;
      }

      if (e + eBias >= eMax) {
        m = 0;
        e = eMax;
      } else if (e + eBias >= 1) {
        m = (value * c - 1) * Math.pow(2, mLen);
        e = e + eBias;
      } else {
        m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen);
        e = 0;
      }
    }

    for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}

    e = e << mLen | m;
    eLen += mLen;

    for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}

    buffer[offset + i - d] |= s * 128;
  }

  var toString = {}.toString;
  var isArray = Array.isArray || function (arr) {
    return toString.call(arr) == '[object Array]';
  };

  var INSPECT_MAX_BYTES = 50;
  /**
   * If `Buffer.TYPED_ARRAY_SUPPORT`:
   *   === true    Use Uint8Array implementation (fastest)
   *   === false   Use Object implementation (most compatible, even IE6)
   *
   * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
   * Opera 11.6+, iOS 4.2+.
   *
   * Due to various browser bugs, sometimes the Object implementation will be used even
   * when the browser supports typed arrays.
   *
   * Note:
   *
   *   - Firefox 4-29 lacks support for adding new properties to `Uint8Array` instances,
   *     See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438.
   *
   *   - Chrome 9-10 is missing the `TypedArray.prototype.subarray` function.
   *
   *   - IE10 has a broken `TypedArray.prototype.subarray` function which returns arrays of
   *     incorrect length in some situations.

   * We detect these buggy browsers and set `Buffer.TYPED_ARRAY_SUPPORT` to `false` so they
   * get the Object implementation, which is slower but behaves correctly.
   */

  Buffer.TYPED_ARRAY_SUPPORT = global$1.TYPED_ARRAY_SUPPORT !== undefined ? global$1.TYPED_ARRAY_SUPPORT : true;

  function kMaxLength() {
    return Buffer.TYPED_ARRAY_SUPPORT ? 0x7fffffff : 0x3fffffff;
  }

  function createBuffer(that, length) {
    if (kMaxLength() < length) {
      throw new RangeError('Invalid typed array length');
    }

    if (Buffer.TYPED_ARRAY_SUPPORT) {
      // Return an augmented `Uint8Array` instance, for best performance
      that = new Uint8Array(length);
      that.__proto__ = Buffer.prototype;
    } else {
      // Fallback: Return an object instance of the Buffer class
      if (that === null) {
        that = new Buffer(length);
      }

      that.length = length;
    }

    return that;
  }
  /**
   * The Buffer constructor returns instances of `Uint8Array` that have their
   * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
   * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
   * and the `Uint8Array` methods. Square bracket notation works as expected -- it
   * returns a single octet.
   *
   * The `Uint8Array` prototype remains unmodified.
   */


  function Buffer(arg, encodingOrOffset, length) {
    if (!Buffer.TYPED_ARRAY_SUPPORT && !(this instanceof Buffer)) {
      return new Buffer(arg, encodingOrOffset, length);
    } // Common case.


    if (typeof arg === 'number') {
      if (typeof encodingOrOffset === 'string') {
        throw new Error('If encoding is specified then the first argument must be a string');
      }

      return allocUnsafe(this, arg);
    }

    return from(this, arg, encodingOrOffset, length);
  }
  Buffer.poolSize = 8192; // not used by this implementation
  // TODO: Legacy, not needed anymore. Remove in next major version.

  Buffer._augment = function (arr) {
    arr.__proto__ = Buffer.prototype;
    return arr;
  };

  function from(that, value, encodingOrOffset, length) {
    if (typeof value === 'number') {
      throw new TypeError('"value" argument must not be a number');
    }

    if (typeof ArrayBuffer !== 'undefined' && value instanceof ArrayBuffer) {
      return fromArrayBuffer(that, value, encodingOrOffset, length);
    }

    if (typeof value === 'string') {
      return fromString(that, value, encodingOrOffset);
    }

    return fromObject(that, value);
  }
  /**
   * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
   * if value is a number.
   * Buffer.from(str[, encoding])
   * Buffer.from(array)
   * Buffer.from(buffer)
   * Buffer.from(arrayBuffer[, byteOffset[, length]])
   **/


  Buffer.from = function (value, encodingOrOffset, length) {
    return from(null, value, encodingOrOffset, length);
  };

  if (Buffer.TYPED_ARRAY_SUPPORT) {
    Buffer.prototype.__proto__ = Uint8Array.prototype;
    Buffer.__proto__ = Uint8Array;
  }

  function assertSize(size) {
    if (typeof size !== 'number') {
      throw new TypeError('"size" argument must be a number');
    } else if (size < 0) {
      throw new RangeError('"size" argument must not be negative');
    }
  }

  function alloc(that, size, fill, encoding) {
    assertSize(size);

    if (size <= 0) {
      return createBuffer(that, size);
    }

    if (fill !== undefined) {
      // Only pay attention to encoding if it's a string. This
      // prevents accidentally sending in a number that would
      // be interpretted as a start offset.
      return typeof encoding === 'string' ? createBuffer(that, size).fill(fill, encoding) : createBuffer(that, size).fill(fill);
    }

    return createBuffer(that, size);
  }
  /**
   * Creates a new filled Buffer instance.
   * alloc(size[, fill[, encoding]])
   **/


  Buffer.alloc = function (size, fill, encoding) {
    return alloc(null, size, fill, encoding);
  };

  function allocUnsafe(that, size) {
    assertSize(size);
    that = createBuffer(that, size < 0 ? 0 : checked(size) | 0);

    if (!Buffer.TYPED_ARRAY_SUPPORT) {
      for (var i = 0; i < size; ++i) {
        that[i] = 0;
      }
    }

    return that;
  }
  /**
   * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
   * */


  Buffer.allocUnsafe = function (size) {
    return allocUnsafe(null, size);
  };
  /**
   * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
   */


  Buffer.allocUnsafeSlow = function (size) {
    return allocUnsafe(null, size);
  };

  function fromString(that, string, encoding) {
    if (typeof encoding !== 'string' || encoding === '') {
      encoding = 'utf8';
    }

    if (!Buffer.isEncoding(encoding)) {
      throw new TypeError('"encoding" must be a valid string encoding');
    }

    var length = byteLength(string, encoding) | 0;
    that = createBuffer(that, length);
    var actual = that.write(string, encoding);

    if (actual !== length) {
      // Writing a hex string, for example, that contains invalid characters will
      // cause everything after the first invalid character to be ignored. (e.g.
      // 'abxxcd' will be treated as 'ab')
      that = that.slice(0, actual);
    }

    return that;
  }

  function fromArrayLike(that, array) {
    var length = array.length < 0 ? 0 : checked(array.length) | 0;
    that = createBuffer(that, length);

    for (var i = 0; i < length; i += 1) {
      that[i] = array[i] & 255;
    }

    return that;
  }

  function fromArrayBuffer(that, array, byteOffset, length) {
    array.byteLength; // this throws if `array` is not a valid ArrayBuffer

    if (byteOffset < 0 || array.byteLength < byteOffset) {
      throw new RangeError('\'offset\' is out of bounds');
    }

    if (array.byteLength < byteOffset + (length || 0)) {
      throw new RangeError('\'length\' is out of bounds');
    }

    if (byteOffset === undefined && length === undefined) {
      array = new Uint8Array(array);
    } else if (length === undefined) {
      array = new Uint8Array(array, byteOffset);
    } else {
      array = new Uint8Array(array, byteOffset, length);
    }

    if (Buffer.TYPED_ARRAY_SUPPORT) {
      // Return an augmented `Uint8Array` instance, for best performance
      that = array;
      that.__proto__ = Buffer.prototype;
    } else {
      // Fallback: Return an object instance of the Buffer class
      that = fromArrayLike(that, array);
    }

    return that;
  }

  function fromObject(that, obj) {
    if (internalIsBuffer(obj)) {
      var len = checked(obj.length) | 0;
      that = createBuffer(that, len);

      if (that.length === 0) {
        return that;
      }

      obj.copy(that, 0, 0, len);
      return that;
    }

    if (obj) {
      if (typeof ArrayBuffer !== 'undefined' && obj.buffer instanceof ArrayBuffer || 'length' in obj) {
        if (typeof obj.length !== 'number' || isnan(obj.length)) {
          return createBuffer(that, 0);
        }

        return fromArrayLike(that, obj);
      }

      if (obj.type === 'Buffer' && isArray(obj.data)) {
        return fromArrayLike(that, obj.data);
      }
    }

    throw new TypeError('First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.');
  }

  function checked(length) {
    // Note: cannot use `length < kMaxLength()` here because that fails when
    // length is NaN (which is otherwise coerced to zero.)
    if (length >= kMaxLength()) {
      throw new RangeError('Attempt to allocate Buffer larger than maximum ' + 'size: 0x' + kMaxLength().toString(16) + ' bytes');
    }

    return length | 0;
  }
  Buffer.isBuffer = isBuffer;

  function internalIsBuffer(b) {
    return !!(b != null && b._isBuffer);
  }

  Buffer.compare = function compare(a, b) {
    if (!internalIsBuffer(a) || !internalIsBuffer(b)) {
      throw new TypeError('Arguments must be Buffers');
    }

    if (a === b) return 0;
    var x = a.length;
    var y = b.length;

    for (var i = 0, len = Math.min(x, y); i < len; ++i) {
      if (a[i] !== b[i]) {
        x = a[i];
        y = b[i];
        break;
      }
    }

    if (x < y) return -1;
    if (y < x) return 1;
    return 0;
  };

  Buffer.isEncoding = function isEncoding(encoding) {
    switch (String(encoding).toLowerCase()) {
      case 'hex':
      case 'utf8':
      case 'utf-8':
      case 'ascii':
      case 'latin1':
      case 'binary':
      case 'base64':
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return true;

      default:
        return false;
    }
  };

  Buffer.concat = function concat(list, length) {
    if (!isArray(list)) {
      throw new TypeError('"list" argument must be an Array of Buffers');
    }

    if (list.length === 0) {
      return Buffer.alloc(0);
    }

    var i;

    if (length === undefined) {
      length = 0;

      for (i = 0; i < list.length; ++i) {
        length += list[i].length;
      }
    }

    var buffer = Buffer.allocUnsafe(length);
    var pos = 0;

    for (i = 0; i < list.length; ++i) {
      var buf = list[i];

      if (!internalIsBuffer(buf)) {
        throw new TypeError('"list" argument must be an Array of Buffers');
      }

      buf.copy(buffer, pos);
      pos += buf.length;
    }

    return buffer;
  };

  function byteLength(string, encoding) {
    if (internalIsBuffer(string)) {
      return string.length;
    }

    if (typeof ArrayBuffer !== 'undefined' && typeof ArrayBuffer.isView === 'function' && (ArrayBuffer.isView(string) || string instanceof ArrayBuffer)) {
      return string.byteLength;
    }

    if (typeof string !== 'string') {
      string = '' + string;
    }

    var len = string.length;
    if (len === 0) return 0; // Use a for loop to avoid recursion

    var loweredCase = false;

    for (;;) {
      switch (encoding) {
        case 'ascii':
        case 'latin1':
        case 'binary':
          return len;

        case 'utf8':
        case 'utf-8':
        case undefined:
          return utf8ToBytes(string).length;

        case 'ucs2':
        case 'ucs-2':
        case 'utf16le':
        case 'utf-16le':
          return len * 2;

        case 'hex':
          return len >>> 1;

        case 'base64':
          return base64ToBytes(string).length;

        default:
          if (loweredCase) return utf8ToBytes(string).length; // assume utf8

          encoding = ('' + encoding).toLowerCase();
          loweredCase = true;
      }
    }
  }

  Buffer.byteLength = byteLength;

  function slowToString(encoding, start, end) {
    var loweredCase = false; // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
    // property of a typed array.
    // This behaves neither like String nor Uint8Array in that we set start/end
    // to their upper/lower bounds if the value passed is out of range.
    // undefined is handled specially as per ECMA-262 6th Edition,
    // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.

    if (start === undefined || start < 0) {
      start = 0;
    } // Return early if start > this.length. Done here to prevent potential uint32
    // coercion fail below.


    if (start > this.length) {
      return '';
    }

    if (end === undefined || end > this.length) {
      end = this.length;
    }

    if (end <= 0) {
      return '';
    } // Force coersion to uint32. This will also coerce falsey/NaN values to 0.


    end >>>= 0;
    start >>>= 0;

    if (end <= start) {
      return '';
    }

    if (!encoding) encoding = 'utf8';

    while (true) {
      switch (encoding) {
        case 'hex':
          return hexSlice(this, start, end);

        case 'utf8':
        case 'utf-8':
          return utf8Slice(this, start, end);

        case 'ascii':
          return asciiSlice(this, start, end);

        case 'latin1':
        case 'binary':
          return latin1Slice(this, start, end);

        case 'base64':
          return base64Slice(this, start, end);

        case 'ucs2':
        case 'ucs-2':
        case 'utf16le':
        case 'utf-16le':
          return utf16leSlice(this, start, end);

        default:
          if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding);
          encoding = (encoding + '').toLowerCase();
          loweredCase = true;
      }
    }
  } // The property is used by `Buffer.isBuffer` and `is-buffer` (in Safari 5-7) to detect
  // Buffer instances.


  Buffer.prototype._isBuffer = true;

  function swap(b, n, m) {
    var i = b[n];
    b[n] = b[m];
    b[m] = i;
  }

  Buffer.prototype.swap16 = function swap16() {
    var len = this.length;

    if (len % 2 !== 0) {
      throw new RangeError('Buffer size must be a multiple of 16-bits');
    }

    for (var i = 0; i < len; i += 2) {
      swap(this, i, i + 1);
    }

    return this;
  };

  Buffer.prototype.swap32 = function swap32() {
    var len = this.length;

    if (len % 4 !== 0) {
      throw new RangeError('Buffer size must be a multiple of 32-bits');
    }

    for (var i = 0; i < len; i += 4) {
      swap(this, i, i + 3);
      swap(this, i + 1, i + 2);
    }

    return this;
  };

  Buffer.prototype.swap64 = function swap64() {
    var len = this.length;

    if (len % 8 !== 0) {
      throw new RangeError('Buffer size must be a multiple of 64-bits');
    }

    for (var i = 0; i < len; i += 8) {
      swap(this, i, i + 7);
      swap(this, i + 1, i + 6);
      swap(this, i + 2, i + 5);
      swap(this, i + 3, i + 4);
    }

    return this;
  };

  Buffer.prototype.toString = function toString() {
    var length = this.length | 0;
    if (length === 0) return '';
    if (arguments.length === 0) return utf8Slice(this, 0, length);
    return slowToString.apply(this, arguments);
  };

  Buffer.prototype.equals = function equals(b) {
    if (!internalIsBuffer(b)) throw new TypeError('Argument must be a Buffer');
    if (this === b) return true;
    return Buffer.compare(this, b) === 0;
  };

  Buffer.prototype.inspect = function inspect() {
    var str = '';
    var max = INSPECT_MAX_BYTES;

    if (this.length > 0) {
      str = this.toString('hex', 0, max).match(/.{2}/g).join(' ');
      if (this.length > max) str += ' ... ';
    }

    return '<Buffer ' + str + '>';
  };

  Buffer.prototype.compare = function compare(target, start, end, thisStart, thisEnd) {
    if (!internalIsBuffer(target)) {
      throw new TypeError('Argument must be a Buffer');
    }

    if (start === undefined) {
      start = 0;
    }

    if (end === undefined) {
      end = target ? target.length : 0;
    }

    if (thisStart === undefined) {
      thisStart = 0;
    }

    if (thisEnd === undefined) {
      thisEnd = this.length;
    }

    if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
      throw new RangeError('out of range index');
    }

    if (thisStart >= thisEnd && start >= end) {
      return 0;
    }

    if (thisStart >= thisEnd) {
      return -1;
    }

    if (start >= end) {
      return 1;
    }

    start >>>= 0;
    end >>>= 0;
    thisStart >>>= 0;
    thisEnd >>>= 0;
    if (this === target) return 0;
    var x = thisEnd - thisStart;
    var y = end - start;
    var len = Math.min(x, y);
    var thisCopy = this.slice(thisStart, thisEnd);
    var targetCopy = target.slice(start, end);

    for (var i = 0; i < len; ++i) {
      if (thisCopy[i] !== targetCopy[i]) {
        x = thisCopy[i];
        y = targetCopy[i];
        break;
      }
    }

    if (x < y) return -1;
    if (y < x) return 1;
    return 0;
  }; // Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
  // OR the last index of `val` in `buffer` at offset <= `byteOffset`.
  //
  // Arguments:
  // - buffer - a Buffer to search
  // - val - a string, Buffer, or number
  // - byteOffset - an index into `buffer`; will be clamped to an int32
  // - encoding - an optional encoding, relevant is val is a string
  // - dir - true for indexOf, false for lastIndexOf


  function bidirectionalIndexOf(buffer, val, byteOffset, encoding, dir) {
    // Empty buffer means no match
    if (buffer.length === 0) return -1; // Normalize byteOffset

    if (typeof byteOffset === 'string') {
      encoding = byteOffset;
      byteOffset = 0;
    } else if (byteOffset > 0x7fffffff) {
      byteOffset = 0x7fffffff;
    } else if (byteOffset < -0x80000000) {
      byteOffset = -0x80000000;
    }

    byteOffset = +byteOffset; // Coerce to Number.

    if (isNaN(byteOffset)) {
      // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
      byteOffset = dir ? 0 : buffer.length - 1;
    } // Normalize byteOffset: negative offsets start from the end of the buffer


    if (byteOffset < 0) byteOffset = buffer.length + byteOffset;

    if (byteOffset >= buffer.length) {
      if (dir) return -1;else byteOffset = buffer.length - 1;
    } else if (byteOffset < 0) {
      if (dir) byteOffset = 0;else return -1;
    } // Normalize val


    if (typeof val === 'string') {
      val = Buffer.from(val, encoding);
    } // Finally, search either indexOf (if dir is true) or lastIndexOf


    if (internalIsBuffer(val)) {
      // Special case: looking for empty string/buffer always fails
      if (val.length === 0) {
        return -1;
      }

      return arrayIndexOf(buffer, val, byteOffset, encoding, dir);
    } else if (typeof val === 'number') {
      val = val & 0xFF; // Search for a byte value [0-255]

      if (Buffer.TYPED_ARRAY_SUPPORT && typeof Uint8Array.prototype.indexOf === 'function') {
        if (dir) {
          return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset);
        } else {
          return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset);
        }
      }

      return arrayIndexOf(buffer, [val], byteOffset, encoding, dir);
    }

    throw new TypeError('val must be string, number or Buffer');
  }

  function arrayIndexOf(arr, val, byteOffset, encoding, dir) {
    var indexSize = 1;
    var arrLength = arr.length;
    var valLength = val.length;

    if (encoding !== undefined) {
      encoding = String(encoding).toLowerCase();

      if (encoding === 'ucs2' || encoding === 'ucs-2' || encoding === 'utf16le' || encoding === 'utf-16le') {
        if (arr.length < 2 || val.length < 2) {
          return -1;
        }

        indexSize = 2;
        arrLength /= 2;
        valLength /= 2;
        byteOffset /= 2;
      }
    }

    function read$$1(buf, i) {
      if (indexSize === 1) {
        return buf[i];
      } else {
        return buf.readUInt16BE(i * indexSize);
      }
    }

    var i;

    if (dir) {
      var foundIndex = -1;

      for (i = byteOffset; i < arrLength; i++) {
        if (read$$1(arr, i) === read$$1(val, foundIndex === -1 ? 0 : i - foundIndex)) {
          if (foundIndex === -1) foundIndex = i;
          if (i - foundIndex + 1 === valLength) return foundIndex * indexSize;
        } else {
          if (foundIndex !== -1) i -= i - foundIndex;
          foundIndex = -1;
        }
      }
    } else {
      if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength;

      for (i = byteOffset; i >= 0; i--) {
        var found = true;

        for (var j = 0; j < valLength; j++) {
          if (read$$1(arr, i + j) !== read$$1(val, j)) {
            found = false;
            break;
          }
        }

        if (found) return i;
      }
    }

    return -1;
  }

  Buffer.prototype.includes = function includes(val, byteOffset, encoding) {
    return this.indexOf(val, byteOffset, encoding) !== -1;
  };

  Buffer.prototype.indexOf = function indexOf(val, byteOffset, encoding) {
    return bidirectionalIndexOf(this, val, byteOffset, encoding, true);
  };

  Buffer.prototype.lastIndexOf = function lastIndexOf(val, byteOffset, encoding) {
    return bidirectionalIndexOf(this, val, byteOffset, encoding, false);
  };

  function hexWrite(buf, string, offset, length) {
    offset = Number(offset) || 0;
    var remaining = buf.length - offset;

    if (!length) {
      length = remaining;
    } else {
      length = Number(length);

      if (length > remaining) {
        length = remaining;
      }
    } // must be an even number of digits


    var strLen = string.length;
    if (strLen % 2 !== 0) throw new TypeError('Invalid hex string');

    if (length > strLen / 2) {
      length = strLen / 2;
    }

    for (var i = 0; i < length; ++i) {
      var parsed = parseInt(string.substr(i * 2, 2), 16);
      if (isNaN(parsed)) return i;
      buf[offset + i] = parsed;
    }

    return i;
  }

  function utf8Write(buf, string, offset, length) {
    return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length);
  }

  function asciiWrite(buf, string, offset, length) {
    return blitBuffer(asciiToBytes(string), buf, offset, length);
  }

  function latin1Write(buf, string, offset, length) {
    return asciiWrite(buf, string, offset, length);
  }

  function base64Write(buf, string, offset, length) {
    return blitBuffer(base64ToBytes(string), buf, offset, length);
  }

  function ucs2Write(buf, string, offset, length) {
    return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length);
  }

  Buffer.prototype.write = function write$$1(string, offset, length, encoding) {
    // Buffer#write(string)
    if (offset === undefined) {
      encoding = 'utf8';
      length = this.length;
      offset = 0; // Buffer#write(string, encoding)
    } else if (length === undefined && typeof offset === 'string') {
      encoding = offset;
      length = this.length;
      offset = 0; // Buffer#write(string, offset[, length][, encoding])
    } else if (isFinite(offset)) {
      offset = offset | 0;

      if (isFinite(length)) {
        length = length | 0;
        if (encoding === undefined) encoding = 'utf8';
      } else {
        encoding = length;
        length = undefined;
      } // legacy write(string, encoding, offset, length) - remove in v0.13

    } else {
      throw new Error('Buffer.write(string, encoding, offset[, length]) is no longer supported');
    }

    var remaining = this.length - offset;
    if (length === undefined || length > remaining) length = remaining;

    if (string.length > 0 && (length < 0 || offset < 0) || offset > this.length) {
      throw new RangeError('Attempt to write outside buffer bounds');
    }

    if (!encoding) encoding = 'utf8';
    var loweredCase = false;

    for (;;) {
      switch (encoding) {
        case 'hex':
          return hexWrite(this, string, offset, length);

        case 'utf8':
        case 'utf-8':
          return utf8Write(this, string, offset, length);

        case 'ascii':
          return asciiWrite(this, string, offset, length);

        case 'latin1':
        case 'binary':
          return latin1Write(this, string, offset, length);

        case 'base64':
          // Warning: maxLength not taken into account in base64Write
          return base64Write(this, string, offset, length);

        case 'ucs2':
        case 'ucs-2':
        case 'utf16le':
        case 'utf-16le':
          return ucs2Write(this, string, offset, length);

        default:
          if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding);
          encoding = ('' + encoding).toLowerCase();
          loweredCase = true;
      }
    }
  };

  Buffer.prototype.toJSON = function toJSON() {
    return {
      type: 'Buffer',
      data: Array.prototype.slice.call(this._arr || this, 0)
    };
  };

  function base64Slice(buf, start, end) {
    if (start === 0 && end === buf.length) {
      return fromByteArray(buf);
    } else {
      return fromByteArray(buf.slice(start, end));
    }
  }

  function utf8Slice(buf, start, end) {
    end = Math.min(buf.length, end);
    var res = [];
    var i = start;

    while (i < end) {
      var firstByte = buf[i];
      var codePoint = null;
      var bytesPerSequence = firstByte > 0xEF ? 4 : firstByte > 0xDF ? 3 : firstByte > 0xBF ? 2 : 1;

      if (i + bytesPerSequence <= end) {
        var secondByte, thirdByte, fourthByte, tempCodePoint;

        switch (bytesPerSequence) {
          case 1:
            if (firstByte < 0x80) {
              codePoint = firstByte;
            }

            break;

          case 2:
            secondByte = buf[i + 1];

            if ((secondByte & 0xC0) === 0x80) {
              tempCodePoint = (firstByte & 0x1F) << 0x6 | secondByte & 0x3F;

              if (tempCodePoint > 0x7F) {
                codePoint = tempCodePoint;
              }
            }

            break;

          case 3:
            secondByte = buf[i + 1];
            thirdByte = buf[i + 2];

            if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
              tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | thirdByte & 0x3F;

              if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
                codePoint = tempCodePoint;
              }
            }

            break;

          case 4:
            secondByte = buf[i + 1];
            thirdByte = buf[i + 2];
            fourthByte = buf[i + 3];

            if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
              tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | fourthByte & 0x3F;

              if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
                codePoint = tempCodePoint;
              }
            }

        }
      }

      if (codePoint === null) {
        // we did not generate a valid codePoint so insert a
        // replacement char (U+FFFD) and advance only 1 byte
        codePoint = 0xFFFD;
        bytesPerSequence = 1;
      } else if (codePoint > 0xFFFF) {
        // encode to utf16 (surrogate pair dance)
        codePoint -= 0x10000;
        res.push(codePoint >>> 10 & 0x3FF | 0xD800);
        codePoint = 0xDC00 | codePoint & 0x3FF;
      }

      res.push(codePoint);
      i += bytesPerSequence;
    }

    return decodeCodePointsArray(res);
  } // Based on http://stackoverflow.com/a/22747272/680742, the browser with
  // the lowest limit is Chrome, with 0x10000 args.
  // We go 1 magnitude less, for safety


  var MAX_ARGUMENTS_LENGTH = 0x1000;

  function decodeCodePointsArray(codePoints) {
    var len = codePoints.length;

    if (len <= MAX_ARGUMENTS_LENGTH) {
      return String.fromCharCode.apply(String, codePoints); // avoid extra slice()
    } // Decode in chunks to avoid "call stack size exceeded".


    var res = '';
    var i = 0;

    while (i < len) {
      res += String.fromCharCode.apply(String, codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH));
    }

    return res;
  }

  function asciiSlice(buf, start, end) {
    var ret = '';
    end = Math.min(buf.length, end);

    for (var i = start; i < end; ++i) {
      ret += String.fromCharCode(buf[i] & 0x7F);
    }

    return ret;
  }

  function latin1Slice(buf, start, end) {
    var ret = '';
    end = Math.min(buf.length, end);

    for (var i = start; i < end; ++i) {
      ret += String.fromCharCode(buf[i]);
    }

    return ret;
  }

  function hexSlice(buf, start, end) {
    var len = buf.length;
    if (!start || start < 0) start = 0;
    if (!end || end < 0 || end > len) end = len;
    var out = '';

    for (var i = start; i < end; ++i) {
      out += toHex(buf[i]);
    }

    return out;
  }

  function utf16leSlice(buf, start, end) {
    var bytes = buf.slice(start, end);
    var res = '';

    for (var i = 0; i < bytes.length; i += 2) {
      res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256);
    }

    return res;
  }

  Buffer.prototype.slice = function slice(start, end) {
    var len = this.length;
    start = ~~start;
    end = end === undefined ? len : ~~end;

    if (start < 0) {
      start += len;
      if (start < 0) start = 0;
    } else if (start > len) {
      start = len;
    }

    if (end < 0) {
      end += len;
      if (end < 0) end = 0;
    } else if (end > len) {
      end = len;
    }

    if (end < start) end = start;
    var newBuf;

    if (Buffer.TYPED_ARRAY_SUPPORT) {
      newBuf = this.subarray(start, end);
      newBuf.__proto__ = Buffer.prototype;
    } else {
      var sliceLen = end - start;
      newBuf = new Buffer(sliceLen, undefined);

      for (var i = 0; i < sliceLen; ++i) {
        newBuf[i] = this[i + start];
      }
    }

    return newBuf;
  };
  /*
   * Need to make sure that buffer isn't trying to write out of bounds.
   */


  function checkOffset(offset, ext, length) {
    if (offset % 1 !== 0 || offset < 0) throw new RangeError('offset is not uint');
    if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length');
  }

  Buffer.prototype.readUIntLE = function readUIntLE(offset, byteLength, noAssert) {
    offset = offset | 0;
    byteLength = byteLength | 0;
    if (!noAssert) checkOffset(offset, byteLength, this.length);
    var val = this[offset];
    var mul = 1;
    var i = 0;

    while (++i < byteLength && (mul *= 0x100)) {
      val += this[offset + i] * mul;
    }

    return val;
  };

  Buffer.prototype.readUIntBE = function readUIntBE(offset, byteLength, noAssert) {
    offset = offset | 0;
    byteLength = byteLength | 0;

    if (!noAssert) {
      checkOffset(offset, byteLength, this.length);
    }

    var val = this[offset + --byteLength];
    var mul = 1;

    while (byteLength > 0 && (mul *= 0x100)) {
      val += this[offset + --byteLength] * mul;
    }

    return val;
  };

  Buffer.prototype.readUInt8 = function readUInt8(offset, noAssert) {
    if (!noAssert) checkOffset(offset, 1, this.length);
    return this[offset];
  };

  Buffer.prototype.readUInt16LE = function readUInt16LE(offset, noAssert) {
    if (!noAssert) checkOffset(offset, 2, this.length);
    return this[offset] | this[offset + 1] << 8;
  };

  Buffer.prototype.readUInt16BE = function readUInt16BE(offset, noAssert) {
    if (!noAssert) checkOffset(offset, 2, this.length);
    return this[offset] << 8 | this[offset + 1];
  };

  Buffer.prototype.readUInt32LE = function readUInt32LE(offset, noAssert) {
    if (!noAssert) checkOffset(offset, 4, this.length);
    return (this[offset] | this[offset + 1] << 8 | this[offset + 2] << 16) + this[offset + 3] * 0x1000000;
  };

  Buffer.prototype.readUInt32BE = function readUInt32BE(offset, noAssert) {
    if (!noAssert) checkOffset(offset, 4, this.length);
    return this[offset] * 0x1000000 + (this[offset + 1] << 16 | this[offset + 2] << 8 | this[offset + 3]);
  };

  Buffer.prototype.readIntLE = function readIntLE(offset, byteLength, noAssert) {
    offset = offset | 0;
    byteLength = byteLength | 0;
    if (!noAssert) checkOffset(offset, byteLength, this.length);
    var val = this[offset];
    var mul = 1;
    var i = 0;

    while (++i < byteLength && (mul *= 0x100)) {
      val += this[offset + i] * mul;
    }

    mul *= 0x80;
    if (val >= mul) val -= Math.pow(2, 8 * byteLength);
    return val;
  };

  Buffer.prototype.readIntBE = function readIntBE(offset, byteLength, noAssert) {
    offset = offset | 0;
    byteLength = byteLength | 0;
    if (!noAssert) checkOffset(offset, byteLength, this.length);
    var i = byteLength;
    var mul = 1;
    var val = this[offset + --i];

    while (i > 0 && (mul *= 0x100)) {
      val += this[offset + --i] * mul;
    }

    mul *= 0x80;
    if (val >= mul) val -= Math.pow(2, 8 * byteLength);
    return val;
  };

  Buffer.prototype.readInt8 = function readInt8(offset, noAssert) {
    if (!noAssert) checkOffset(offset, 1, this.length);
    if (!(this[offset] & 0x80)) return this[offset];
    return (0xff - this[offset] + 1) * -1;
  };

  Buffer.prototype.readInt16LE = function readInt16LE(offset, noAssert) {
    if (!noAssert) checkOffset(offset, 2, this.length);
    var val = this[offset] | this[offset + 1] << 8;
    return val & 0x8000 ? val | 0xFFFF0000 : val;
  };

  Buffer.prototype.readInt16BE = function readInt16BE(offset, noAssert) {
    if (!noAssert) checkOffset(offset, 2, this.length);
    var val = this[offset + 1] | this[offset] << 8;
    return val & 0x8000 ? val | 0xFFFF0000 : val;
  };

  Buffer.prototype.readInt32LE = function readInt32LE(offset, noAssert) {
    if (!noAssert) checkOffset(offset, 4, this.length);
    return this[offset] | this[offset + 1] << 8 | this[offset + 2] << 16 | this[offset + 3] << 24;
  };

  Buffer.prototype.readInt32BE = function readInt32BE(offset, noAssert) {
    if (!noAssert) checkOffset(offset, 4, this.length);
    return this[offset] << 24 | this[offset + 1] << 16 | this[offset + 2] << 8 | this[offset + 3];
  };

  Buffer.prototype.readFloatLE = function readFloatLE(offset, noAssert) {
    if (!noAssert) checkOffset(offset, 4, this.length);
    return read(this, offset, true, 23, 4);
  };

  Buffer.prototype.readFloatBE = function readFloatBE(offset, noAssert) {
    if (!noAssert) checkOffset(offset, 4, this.length);
    return read(this, offset, false, 23, 4);
  };

  Buffer.prototype.readDoubleLE = function readDoubleLE(offset, noAssert) {
    if (!noAssert) checkOffset(offset, 8, this.length);
    return read(this, offset, true, 52, 8);
  };

  Buffer.prototype.readDoubleBE = function readDoubleBE(offset, noAssert) {
    if (!noAssert) checkOffset(offset, 8, this.length);
    return read(this, offset, false, 52, 8);
  };

  function checkInt(buf, value, offset, ext, max, min) {
    if (!internalIsBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance');
    if (value > max || value < min) throw new RangeError('"value" argument is out of bounds');
    if (offset + ext > buf.length) throw new RangeError('Index out of range');
  }

  Buffer.prototype.writeUIntLE = function writeUIntLE(value, offset, byteLength, noAssert) {
    value = +value;
    offset = offset | 0;
    byteLength = byteLength | 0;

    if (!noAssert) {
      var maxBytes = Math.pow(2, 8 * byteLength) - 1;
      checkInt(this, value, offset, byteLength, maxBytes, 0);
    }

    var mul = 1;
    var i = 0;
    this[offset] = value & 0xFF;

    while (++i < byteLength && (mul *= 0x100)) {
      this[offset + i] = value / mul & 0xFF;
    }

    return offset + byteLength;
  };

  Buffer.prototype.writeUIntBE = function writeUIntBE(value, offset, byteLength, noAssert) {
    value = +value;
    offset = offset | 0;
    byteLength = byteLength | 0;

    if (!noAssert) {
      var maxBytes = Math.pow(2, 8 * byteLength) - 1;
      checkInt(this, value, offset, byteLength, maxBytes, 0);
    }

    var i = byteLength - 1;
    var mul = 1;
    this[offset + i] = value & 0xFF;

    while (--i >= 0 && (mul *= 0x100)) {
      this[offset + i] = value / mul & 0xFF;
    }

    return offset + byteLength;
  };

  Buffer.prototype.writeUInt8 = function writeUInt8(value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0);
    if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value);
    this[offset] = value & 0xff;
    return offset + 1;
  };

  function objectWriteUInt16(buf, value, offset, littleEndian) {
    if (value < 0) value = 0xffff + value + 1;

    for (var i = 0, j = Math.min(buf.length - offset, 2); i < j; ++i) {
      buf[offset + i] = (value & 0xff << 8 * (littleEndian ? i : 1 - i)) >>> (littleEndian ? i : 1 - i) * 8;
    }
  }

  Buffer.prototype.writeUInt16LE = function writeUInt16LE(value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);

    if (Buffer.TYPED_ARRAY_SUPPORT) {
      this[offset] = value & 0xff;
      this[offset + 1] = value >>> 8;
    } else {
      objectWriteUInt16(this, value, offset, true);
    }

    return offset + 2;
  };

  Buffer.prototype.writeUInt16BE = function writeUInt16BE(value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);

    if (Buffer.TYPED_ARRAY_SUPPORT) {
      this[offset] = value >>> 8;
      this[offset + 1] = value & 0xff;
    } else {
      objectWriteUInt16(this, value, offset, false);
    }

    return offset + 2;
  };

  function objectWriteUInt32(buf, value, offset, littleEndian) {
    if (value < 0) value = 0xffffffff + value + 1;

    for (var i = 0, j = Math.min(buf.length - offset, 4); i < j; ++i) {
      buf[offset + i] = value >>> (littleEndian ? i : 3 - i) * 8 & 0xff;
    }
  }

  Buffer.prototype.writeUInt32LE = function writeUInt32LE(value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);

    if (Buffer.TYPED_ARRAY_SUPPORT) {
      this[offset + 3] = value >>> 24;
      this[offset + 2] = value >>> 16;
      this[offset + 1] = value >>> 8;
      this[offset] = value & 0xff;
    } else {
      objectWriteUInt32(this, value, offset, true);
    }

    return offset + 4;
  };

  Buffer.prototype.writeUInt32BE = function writeUInt32BE(value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);

    if (Buffer.TYPED_ARRAY_SUPPORT) {
      this[offset] = value >>> 24;
      this[offset + 1] = value >>> 16;
      this[offset + 2] = value >>> 8;
      this[offset + 3] = value & 0xff;
    } else {
      objectWriteUInt32(this, value, offset, false);
    }

    return offset + 4;
  };

  Buffer.prototype.writeIntLE = function writeIntLE(value, offset, byteLength, noAssert) {
    value = +value;
    offset = offset | 0;

    if (!noAssert) {
      var limit = Math.pow(2, 8 * byteLength - 1);
      checkInt(this, value, offset, byteLength, limit - 1, -limit);
    }

    var i = 0;
    var mul = 1;
    var sub = 0;
    this[offset] = value & 0xFF;

    while (++i < byteLength && (mul *= 0x100)) {
      if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
        sub = 1;
      }

      this[offset + i] = (value / mul >> 0) - sub & 0xFF;
    }

    return offset + byteLength;
  };

  Buffer.prototype.writeIntBE = function writeIntBE(value, offset, byteLength, noAssert) {
    value = +value;
    offset = offset | 0;

    if (!noAssert) {
      var limit = Math.pow(2, 8 * byteLength - 1);
      checkInt(this, value, offset, byteLength, limit - 1, -limit);
    }

    var i = byteLength - 1;
    var mul = 1;
    var sub = 0;
    this[offset + i] = value & 0xFF;

    while (--i >= 0 && (mul *= 0x100)) {
      if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
        sub = 1;
      }

      this[offset + i] = (value / mul >> 0) - sub & 0xFF;
    }

    return offset + byteLength;
  };

  Buffer.prototype.writeInt8 = function writeInt8(value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80);
    if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value);
    if (value < 0) value = 0xff + value + 1;
    this[offset] = value & 0xff;
    return offset + 1;
  };

  Buffer.prototype.writeInt16LE = function writeInt16LE(value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000);

    if (Buffer.TYPED_ARRAY_SUPPORT) {
      this[offset] = value & 0xff;
      this[offset + 1] = value >>> 8;
    } else {
      objectWriteUInt16(this, value, offset, true);
    }

    return offset + 2;
  };

  Buffer.prototype.writeInt16BE = function writeInt16BE(value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000);

    if (Buffer.TYPED_ARRAY_SUPPORT) {
      this[offset] = value >>> 8;
      this[offset + 1] = value & 0xff;
    } else {
      objectWriteUInt16(this, value, offset, false);
    }

    return offset + 2;
  };

  Buffer.prototype.writeInt32LE = function writeInt32LE(value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000);

    if (Buffer.TYPED_ARRAY_SUPPORT) {
      this[offset] = value & 0xff;
      this[offset + 1] = value >>> 8;
      this[offset + 2] = value >>> 16;
      this[offset + 3] = value >>> 24;
    } else {
      objectWriteUInt32(this, value, offset, true);
    }

    return offset + 4;
  };

  Buffer.prototype.writeInt32BE = function writeInt32BE(value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000);
    if (value < 0) value = 0xffffffff + value + 1;

    if (Buffer.TYPED_ARRAY_SUPPORT) {
      this[offset] = value >>> 24;
      this[offset + 1] = value >>> 16;
      this[offset + 2] = value >>> 8;
      this[offset + 3] = value & 0xff;
    } else {
      objectWriteUInt32(this, value, offset, false);
    }

    return offset + 4;
  };

  function checkIEEE754(buf, value, offset, ext, max, min) {
    if (offset + ext > buf.length) throw new RangeError('Index out of range');
    if (offset < 0) throw new RangeError('Index out of range');
  }

  function writeFloat(buf, value, offset, littleEndian, noAssert) {
    if (!noAssert) {
      checkIEEE754(buf, value, offset, 4, 3.4028234663852886e+38, -3.4028234663852886e+38);
    }

    write(buf, value, offset, littleEndian, 23, 4);
    return offset + 4;
  }

  Buffer.prototype.writeFloatLE = function writeFloatLE(value, offset, noAssert) {
    return writeFloat(this, value, offset, true, noAssert);
  };

  Buffer.prototype.writeFloatBE = function writeFloatBE(value, offset, noAssert) {
    return writeFloat(this, value, offset, false, noAssert);
  };

  function writeDouble(buf, value, offset, littleEndian, noAssert) {
    if (!noAssert) {
      checkIEEE754(buf, value, offset, 8, 1.7976931348623157E+308, -1.7976931348623157E+308);
    }

    write(buf, value, offset, littleEndian, 52, 8);
    return offset + 8;
  }

  Buffer.prototype.writeDoubleLE = function writeDoubleLE(value, offset, noAssert) {
    return writeDouble(this, value, offset, true, noAssert);
  };

  Buffer.prototype.writeDoubleBE = function writeDoubleBE(value, offset, noAssert) {
    return writeDouble(this, value, offset, false, noAssert);
  }; // copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)


  Buffer.prototype.copy = function copy(target, targetStart, start, end) {
    if (!start) start = 0;
    if (!end && end !== 0) end = this.length;
    if (targetStart >= target.length) targetStart = target.length;
    if (!targetStart) targetStart = 0;
    if (end > 0 && end < start) end = start; // Copy 0 bytes; we're done

    if (end === start) return 0;
    if (target.length === 0 || this.length === 0) return 0; // Fatal error conditions

    if (targetStart < 0) {
      throw new RangeError('targetStart out of bounds');
    }

    if (start < 0 || start >= this.length) throw new RangeError('sourceStart out of bounds');
    if (end < 0) throw new RangeError('sourceEnd out of bounds'); // Are we oob?

    if (end > this.length) end = this.length;

    if (target.length - targetStart < end - start) {
      end = target.length - targetStart + start;
    }

    var len = end - start;
    var i;

    if (this === target && start < targetStart && targetStart < end) {
      // descending copy from end
      for (i = len - 1; i >= 0; --i) {
        target[i + targetStart] = this[i + start];
      }
    } else if (len < 1000 || !Buffer.TYPED_ARRAY_SUPPORT) {
      // ascending copy from start
      for (i = 0; i < len; ++i) {
        target[i + targetStart] = this[i + start];
      }
    } else {
      Uint8Array.prototype.set.call(target, this.subarray(start, start + len), targetStart);
    }

    return len;
  }; // Usage:
  //    buffer.fill(number[, offset[, end]])
  //    buffer.fill(buffer[, offset[, end]])
  //    buffer.fill(string[, offset[, end]][, encoding])


  Buffer.prototype.fill = function fill(val, start, end, encoding) {
    // Handle string cases:
    if (typeof val === 'string') {
      if (typeof start === 'string') {
        encoding = start;
        start = 0;
        end = this.length;
      } else if (typeof end === 'string') {
        encoding = end;
        end = this.length;
      }

      if (val.length === 1) {
        var code = val.charCodeAt(0);

        if (code < 256) {
          val = code;
        }
      }

      if (encoding !== undefined && typeof encoding !== 'string') {
        throw new TypeError('encoding must be a string');
      }

      if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
        throw new TypeError('Unknown encoding: ' + encoding);
      }
    } else if (typeof val === 'number') {
      val = val & 255;
    } // Invalid ranges are not set to a default, so can range check early.


    if (start < 0 || this.length < start || this.length < end) {
      throw new RangeError('Out of range index');
    }

    if (end <= start) {
      return this;
    }

    start = start >>> 0;
    end = end === undefined ? this.length : end >>> 0;
    if (!val) val = 0;
    var i;

    if (typeof val === 'number') {
      for (i = start; i < end; ++i) {
        this[i] = val;
      }
    } else {
      var bytes = internalIsBuffer(val) ? val : utf8ToBytes(new Buffer(val, encoding).toString());
      var len = bytes.length;

      for (i = 0; i < end - start; ++i) {
        this[i + start] = bytes[i % len];
      }
    }

    return this;
  }; // HELPER FUNCTIONS
  // ================


  var INVALID_BASE64_RE = /[^+\/0-9A-Za-z-_]/g;

  function base64clean(str) {
    // Node strips out invalid characters like \n and \t from the string, base64-js does not
    str = stringtrim(str).replace(INVALID_BASE64_RE, ''); // Node converts strings with length < 2 to ''

    if (str.length < 2) return ''; // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not

    while (str.length % 4 !== 0) {
      str = str + '=';
    }

    return str;
  }

  function stringtrim(str) {
    if (str.trim) return str.trim();
    return str.replace(/^\s+|\s+$/g, '');
  }

  function toHex(n) {
    if (n < 16) return '0' + n.toString(16);
    return n.toString(16);
  }

  function utf8ToBytes(string, units) {
    units = units || Infinity;
    var codePoint;
    var length = string.length;
    var leadSurrogate = null;
    var bytes = [];

    for (var i = 0; i < length; ++i) {
      codePoint = string.charCodeAt(i); // is surrogate component

      if (codePoint > 0xD7FF && codePoint < 0xE000) {
        // last char was a lead
        if (!leadSurrogate) {
          // no lead yet
          if (codePoint > 0xDBFF) {
            // unexpected trail
            if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
            continue;
          } else if (i + 1 === length) {
            // unpaired lead
            if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
            continue;
          } // valid lead


          leadSurrogate = codePoint;
          continue;
        } // 2 leads in a row


        if (codePoint < 0xDC00) {
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
          leadSurrogate = codePoint;
          continue;
        } // valid surrogate pair


        codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000;
      } else if (leadSurrogate) {
        // valid bmp char, but last char was a lead
        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
      }

      leadSurrogate = null; // encode utf8

      if (codePoint < 0x80) {
        if ((units -= 1) < 0) break;
        bytes.push(codePoint);
      } else if (codePoint < 0x800) {
        if ((units -= 2) < 0) break;
        bytes.push(codePoint >> 0x6 | 0xC0, codePoint & 0x3F | 0x80);
      } else if (codePoint < 0x10000) {
        if ((units -= 3) < 0) break;
        bytes.push(codePoint >> 0xC | 0xE0, codePoint >> 0x6 & 0x3F | 0x80, codePoint & 0x3F | 0x80);
      } else if (codePoint < 0x110000) {
        if ((units -= 4) < 0) break;
        bytes.push(codePoint >> 0x12 | 0xF0, codePoint >> 0xC & 0x3F | 0x80, codePoint >> 0x6 & 0x3F | 0x80, codePoint & 0x3F | 0x80);
      } else {
        throw new Error('Invalid code point');
      }
    }

    return bytes;
  }

  function asciiToBytes(str) {
    var byteArray = [];

    for (var i = 0; i < str.length; ++i) {
      // Node's code seems to be doing this and not & 0x7F..
      byteArray.push(str.charCodeAt(i) & 0xFF);
    }

    return byteArray;
  }

  function utf16leToBytes(str, units) {
    var c, hi, lo;
    var byteArray = [];

    for (var i = 0; i < str.length; ++i) {
      if ((units -= 2) < 0) break;
      c = str.charCodeAt(i);
      hi = c >> 8;
      lo = c % 256;
      byteArray.push(lo);
      byteArray.push(hi);
    }

    return byteArray;
  }

  function base64ToBytes(str) {
    return toByteArray(base64clean(str));
  }

  function blitBuffer(src, dst, offset, length) {
    for (var i = 0; i < length; ++i) {
      if (i + offset >= dst.length || i >= src.length) break;
      dst[i + offset] = src[i];
    }

    return i;
  }

  function isnan(val) {
    return val !== val; // eslint-disable-line no-self-compare
  } // the following is from is-buffer, also by Feross Aboukhadijeh and with same lisence
  // The _isBuffer check is for Safari 5-7 support, because it's missing
  // Object.prototype.constructor. Remove this eventually


  function isBuffer(obj) {
    return obj != null && (!!obj._isBuffer || isFastBuffer(obj) || isSlowBuffer(obj));
  }

  function isFastBuffer(obj) {
    return !!obj.constructor && typeof obj.constructor.isBuffer === 'function' && obj.constructor.isBuffer(obj);
  } // For Node v0.10 support. Remove this eventually.


  function isSlowBuffer(obj) {
    return typeof obj.readFloatLE === 'function' && typeof obj.slice === 'function' && isFastBuffer(obj.slice(0, 0));
  }

  function isNull(arg) {
    return arg === null;
  }
  function isNullOrUndefined(arg) {
    return arg == null;
  }
  function isString(arg) {
    return typeof arg === 'string';
  }
  function isObject(arg) {
    return typeof arg === 'object' && arg !== null;
  }

  // Copyright Joyent, Inc. and other Node contributors.
  //
  // Permission is hereby granted, free of charge, to any person obtaining a
  // copy of this software and associated documentation files (the
  // "Software"), to deal in the Software without restriction, including
  // without limitation the rights to use, copy, modify, merge, publish,
  // distribute, sublicense, and/or sell copies of the Software, and to permit
  // persons to whom the Software is furnished to do so, subject to the
  // following conditions:
  //
  // The above copyright notice and this permission notice shall be included
  // in all copies or substantial portions of the Software.
  //
  // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  // OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  // MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
  // NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
  // DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
  // OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
  // USE OR OTHER DEALINGS IN THE SOFTWARE.
  // If obj.hasOwnProperty has been overridden, then calling
  // obj.hasOwnProperty(prop) will break.
  // See: https://github.com/joyent/node/issues/1707
  function hasOwnProperty$1(obj, prop) {
    return Object.prototype.hasOwnProperty.call(obj, prop);
  }

  var isArray$2 = Array.isArray || function (xs) {
    return Object.prototype.toString.call(xs) === '[object Array]';
  };

  function stringifyPrimitive(v) {
    switch (typeof v) {
      case 'string':
        return v;

      case 'boolean':
        return v ? 'true' : 'false';

      case 'number':
        return isFinite(v) ? v : '';

      default:
        return '';
    }
  }

  function stringify(obj, sep, eq, name) {
    sep = sep || '&';
    eq = eq || '=';

    if (obj === null) {
      obj = undefined;
    }

    if (typeof obj === 'object') {
      return map$1(objectKeys(obj), function (k) {
        var ks = encodeURIComponent(stringifyPrimitive(k)) + eq;

        if (isArray$2(obj[k])) {
          return map$1(obj[k], function (v) {
            return ks + encodeURIComponent(stringifyPrimitive(v));
          }).join(sep);
        } else {
          return ks + encodeURIComponent(stringifyPrimitive(obj[k]));
        }
      }).join(sep);
    }

    if (!name) return '';
    return encodeURIComponent(stringifyPrimitive(name)) + eq + encodeURIComponent(stringifyPrimitive(obj));
  }

  function map$1(xs, f) {
    if (xs.map) return xs.map(f);
    var res = [];

    for (var i = 0; i < xs.length; i++) {
      res.push(f(xs[i], i));
    }

    return res;
  }

  var objectKeys = Object.keys || function (obj) {
    var res = [];

    for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) res.push(key);
    }

    return res;
  };

  function parse(qs, sep, eq, options) {
    sep = sep || '&';
    eq = eq || '=';
    var obj = {};

    if (typeof qs !== 'string' || qs.length === 0) {
      return obj;
    }

    var regexp = /\+/g;
    qs = qs.split(sep);
    var maxKeys = 1000;

    if (options && typeof options.maxKeys === 'number') {
      maxKeys = options.maxKeys;
    }

    var len = qs.length; // maxKeys <= 0 means that we should not limit keys count

    if (maxKeys > 0 && len > maxKeys) {
      len = maxKeys;
    }

    for (var i = 0; i < len; ++i) {
      var x = qs[i].replace(regexp, '%20'),
          idx = x.indexOf(eq),
          kstr,
          vstr,
          k,
          v;

      if (idx >= 0) {
        kstr = x.substr(0, idx);
        vstr = x.substr(idx + 1);
      } else {
        kstr = x;
        vstr = '';
      }

      k = decodeURIComponent(kstr);
      v = decodeURIComponent(vstr);

      if (!hasOwnProperty$1(obj, k)) {
        obj[k] = v;
      } else if (isArray$2(obj[k])) {
        obj[k].push(v);
      } else {
        obj[k] = [obj[k], v];
      }
    }

    return obj;
  }

  // Copyright Joyent, Inc. and other Node contributors.
  var url = {
    parse: urlParse,
    resolve: urlResolve,
    resolveObject: urlResolveObject,
    format: urlFormat,
    Url: Url
  };
  function Url() {
    this.protocol = null;
    this.slashes = null;
    this.auth = null;
    this.host = null;
    this.port = null;
    this.hostname = null;
    this.hash = null;
    this.search = null;
    this.query = null;
    this.pathname = null;
    this.path = null;
    this.href = null;
  } // Reference: RFC 3986, RFC 1808, RFC 2396
  // define these here so at least they only have to be
  // compiled once on the first module load.

  var protocolPattern = /^([a-z0-9.+-]+:)/i,
      portPattern = /:[0-9]*$/,
      // Special case for a simple path URL
  simplePathPattern = /^(\/\/?(?!\/)[^\?\s]*)(\?[^\s]*)?$/,
      // RFC 2396: characters reserved for delimiting URLs.
  // We actually just auto-escape these.
  delims = ['<', '>', '"', '`', ' ', '\r', '\n', '\t'],
      // RFC 2396: characters not allowed for various reasons.
  unwise = ['{', '}', '|', '\\', '^', '`'].concat(delims),
      // Allowed by RFCs, but cause of XSS attacks.  Always escape these.
  autoEscape = ['\''].concat(unwise),
      // Characters that are never ever allowed in a hostname.
  // Note that any invalid chars are also handled, but these
  // are the ones that are *expected* to be seen, so we fast-path
  // them.
  nonHostChars = ['%', '/', '?', ';', '#'].concat(autoEscape),
      hostEndingChars = ['/', '?', '#'],
      hostnameMaxLen = 255,
      hostnamePartPattern = /^[+a-z0-9A-Z_-]{0,63}$/,
      hostnamePartStart = /^([+a-z0-9A-Z_-]{0,63})(.*)$/,
      // protocols that can allow "unsafe" and "unwise" chars.
  unsafeProtocol = {
    'javascript': true,
    'javascript:': true
  },
      // protocols that never have a hostname.
  hostlessProtocol = {
    'javascript': true,
    'javascript:': true
  },
      // protocols that always contain a // bit.
  slashedProtocol = {
    'http': true,
    'https': true,
    'ftp': true,
    'gopher': true,
    'file': true,
    'http:': true,
    'https:': true,
    'ftp:': true,
    'gopher:': true,
    'file:': true
  };

  function urlParse(url, parseQueryString, slashesDenoteHost) {
    if (url && isObject(url) && url instanceof Url) return url;
    var u = new Url();
    u.parse(url, parseQueryString, slashesDenoteHost);
    return u;
  }

  Url.prototype.parse = function (url, parseQueryString, slashesDenoteHost) {
    return parse$1(this, url, parseQueryString, slashesDenoteHost);
  };

  function parse$1(self, url, parseQueryString, slashesDenoteHost) {
    if (!isString(url)) {
      throw new TypeError('Parameter \'url\' must be a string, not ' + typeof url);
    } // Copy chrome, IE, opera backslash-handling behavior.
    // Back slashes before the query string get converted to forward slashes
    // See: https://code.google.com/p/chromium/issues/detail?id=25916


    var queryIndex = url.indexOf('?'),
        splitter = queryIndex !== -1 && queryIndex < url.indexOf('#') ? '?' : '#',
        uSplit = url.split(splitter),
        slashRegex = /\\/g;
    uSplit[0] = uSplit[0].replace(slashRegex, '/');
    url = uSplit.join(splitter);
    var rest = url; // trim before proceeding.
    // This is to support parse stuff like "  http://foo.com  \n"

    rest = rest.trim();

    if (!slashesDenoteHost && url.split('#').length === 1) {
      // Try fast path regexp
      var simplePath = simplePathPattern.exec(rest);

      if (simplePath) {
        self.path = rest;
        self.href = rest;
        self.pathname = simplePath[1];

        if (simplePath[2]) {
          self.search = simplePath[2];

          if (parseQueryString) {
            self.query = parse(self.search.substr(1));
          } else {
            self.query = self.search.substr(1);
          }
        } else if (parseQueryString) {
          self.search = '';
          self.query = {};
        }

        return self;
      }
    }

    var proto = protocolPattern.exec(rest);

    if (proto) {
      proto = proto[0];
      var lowerProto = proto.toLowerCase();
      self.protocol = lowerProto;
      rest = rest.substr(proto.length);
    } // figure out if it's got a host
    // user@server is *always* interpreted as a hostname, and url
    // resolution will treat //foo/bar as host=foo,path=bar because that's
    // how the browser resolves relative URLs.


    if (slashesDenoteHost || proto || rest.match(/^\/\/[^@\/]+@[^@\/]+/)) {
      var slashes = rest.substr(0, 2) === '//';

      if (slashes && !(proto && hostlessProtocol[proto])) {
        rest = rest.substr(2);
        self.slashes = true;
      }
    }

    var i, hec, l, p;

    if (!hostlessProtocol[proto] && (slashes || proto && !slashedProtocol[proto])) {
      // there's a hostname.
      // the first instance of /, ?, ;, or # ends the host.
      //
      // If there is an @ in the hostname, then non-host chars *are* allowed
      // to the left of the last @ sign, unless some host-ending character
      // comes *before* the @-sign.
      // URLs are obnoxious.
      //
      // ex:
      // http://a@b@c/ => user:a@b host:c
      // http://a@b?@c => user:a host:c path:/?@c
      // v0.12 TODO(isaacs): This is not quite how Chrome does things.
      // Review our test case against browsers more comprehensively.
      // find the first instance of any hostEndingChars
      var hostEnd = -1;

      for (i = 0; i < hostEndingChars.length; i++) {
        hec = rest.indexOf(hostEndingChars[i]);
        if (hec !== -1 && (hostEnd === -1 || hec < hostEnd)) hostEnd = hec;
      } // at this point, either we have an explicit point where the
      // auth portion cannot go past, or the last @ char is the decider.


      var auth, atSign;

      if (hostEnd === -1) {
        // atSign can be anywhere.
        atSign = rest.lastIndexOf('@');
      } else {
        // atSign must be in auth portion.
        // http://a@b/c@d => host:b auth:a path:/c@d
        atSign = rest.lastIndexOf('@', hostEnd);
      } // Now we have a portion which is definitely the auth.
      // Pull that off.


      if (atSign !== -1) {
        auth = rest.slice(0, atSign);
        rest = rest.slice(atSign + 1);
        self.auth = decodeURIComponent(auth);
      } // the host is the remaining to the left of the first non-host char


      hostEnd = -1;

      for (i = 0; i < nonHostChars.length; i++) {
        hec = rest.indexOf(nonHostChars[i]);
        if (hec !== -1 && (hostEnd === -1 || hec < hostEnd)) hostEnd = hec;
      } // if we still have not hit it, then the entire thing is a host.


      if (hostEnd === -1) hostEnd = rest.length;
      self.host = rest.slice(0, hostEnd);
      rest = rest.slice(hostEnd); // pull out port.

      parseHost(self); // we've indicated that there is a hostname,
      // so even if it's empty, it has to be present.

      self.hostname = self.hostname || ''; // if hostname begins with [ and ends with ]
      // assume that it's an IPv6 address.

      var ipv6Hostname = self.hostname[0] === '[' && self.hostname[self.hostname.length - 1] === ']'; // validate a little.

      if (!ipv6Hostname) {
        var hostparts = self.hostname.split(/\./);

        for (i = 0, l = hostparts.length; i < l; i++) {
          var part = hostparts[i];
          if (!part) continue;

          if (!part.match(hostnamePartPattern)) {
            var newpart = '';

            for (var j = 0, k = part.length; j < k; j++) {
              if (part.charCodeAt(j) > 127) {
                // we replace non-ASCII char with a temporary placeholder
                // we need this to make sure size of hostname is not
                // broken by replacing non-ASCII by nothing
                newpart += 'x';
              } else {
                newpart += part[j];
              }
            } // we test again with ASCII char only


            if (!newpart.match(hostnamePartPattern)) {
              var validParts = hostparts.slice(0, i);
              var notHost = hostparts.slice(i + 1);
              var bit = part.match(hostnamePartStart);

              if (bit) {
                validParts.push(bit[1]);
                notHost.unshift(bit[2]);
              }

              if (notHost.length) {
                rest = '/' + notHost.join('.') + rest;
              }

              self.hostname = validParts.join('.');
              break;
            }
          }
        }
      }

      if (self.hostname.length > hostnameMaxLen) {
        self.hostname = '';
      } else {
        // hostnames are always lower case.
        self.hostname = self.hostname.toLowerCase();
      }

      if (!ipv6Hostname) {
        // IDNA Support: Returns a punycoded representation of "domain".
        // It only converts parts of the domain name that
        // have non-ASCII characters, i.e. it doesn't matter if
        // you call it with a domain that already is ASCII-only.
        self.hostname = toASCII(self.hostname);
      }

      p = self.port ? ':' + self.port : '';
      var h = self.hostname || '';
      self.host = h + p;
      self.href += self.host; // strip [ and ] from the hostname
      // the host field still retains them, though

      if (ipv6Hostname) {
        self.hostname = self.hostname.substr(1, self.hostname.length - 2);

        if (rest[0] !== '/') {
          rest = '/' + rest;
        }
      }
    } // now rest is set to the post-host stuff.
    // chop off any delim chars.


    if (!unsafeProtocol[lowerProto]) {
      // First, make 100% sure that any "autoEscape" chars get
      // escaped, even if encodeURIComponent doesn't think they
      // need to be.
      for (i = 0, l = autoEscape.length; i < l; i++) {
        var ae = autoEscape[i];
        if (rest.indexOf(ae) === -1) continue;
        var esc = encodeURIComponent(ae);

        if (esc === ae) {
          esc = escape(ae);
        }

        rest = rest.split(ae).join(esc);
      }
    } // chop off from the tail first.


    var hash = rest.indexOf('#');

    if (hash !== -1) {
      // got a fragment string.
      self.hash = rest.substr(hash);
      rest = rest.slice(0, hash);
    }

    var qm = rest.indexOf('?');

    if (qm !== -1) {
      self.search = rest.substr(qm);
      self.query = rest.substr(qm + 1);

      if (parseQueryString) {
        self.query = parse(self.query);
      }

      rest = rest.slice(0, qm);
    } else if (parseQueryString) {
      // no query string, but parseQueryString still requested
      self.search = '';
      self.query = {};
    }

    if (rest) self.pathname = rest;

    if (slashedProtocol[lowerProto] && self.hostname && !self.pathname) {
      self.pathname = '/';
    } //to support http.request


    if (self.pathname || self.search) {
      p = self.pathname || '';
      var s = self.search || '';
      self.path = p + s;
    } // finally, reconstruct the href based on what has been validated.


    self.href = format$1(self);
    return self;
  } // format a parsed object into a url string


  function urlFormat(obj) {
    // ensure it's an object, and not a string url.
    // If it's an obj, this is a no-op.
    // this way, you can call url_format() on strings
    // to clean up potentially wonky urls.
    if (isString(obj)) obj = parse$1({}, obj);
    return format$1(obj);
  }

  function format$1(self) {
    var auth = self.auth || '';

    if (auth) {
      auth = encodeURIComponent(auth);
      auth = auth.replace(/%3A/i, ':');
      auth += '@';
    }

    var protocol = self.protocol || '',
        pathname = self.pathname || '',
        hash = self.hash || '',
        host = false,
        query = '';

    if (self.host) {
      host = auth + self.host;
    } else if (self.hostname) {
      host = auth + (self.hostname.indexOf(':') === -1 ? self.hostname : '[' + this.hostname + ']');

      if (self.port) {
        host += ':' + self.port;
      }
    }

    if (self.query && isObject(self.query) && Object.keys(self.query).length) {
      query = stringify(self.query);
    }

    var search = self.search || query && '?' + query || '';
    if (protocol && protocol.substr(-1) !== ':') protocol += ':'; // only the slashedProtocols get the //.  Not mailto:, xmpp:, etc.
    // unless they had them to begin with.

    if (self.slashes || (!protocol || slashedProtocol[protocol]) && host !== false) {
      host = '//' + (host || '');
      if (pathname && pathname.charAt(0) !== '/') pathname = '/' + pathname;
    } else if (!host) {
      host = '';
    }

    if (hash && hash.charAt(0) !== '#') hash = '#' + hash;
    if (search && search.charAt(0) !== '?') search = '?' + search;
    pathname = pathname.replace(/[?#]/g, function (match) {
      return encodeURIComponent(match);
    });
    search = search.replace('#', '%23');
    return protocol + host + pathname + search + hash;
  }

  Url.prototype.format = function () {
    return format$1(this);
  };

  function urlResolve(source, relative) {
    return urlParse(source, false, true).resolve(relative);
  }

  Url.prototype.resolve = function (relative) {
    return this.resolveObject(urlParse(relative, false, true)).format();
  };

  function urlResolveObject(source, relative) {
    if (!source) return relative;
    return urlParse(source, false, true).resolveObject(relative);
  }

  Url.prototype.resolveObject = function (relative) {
    if (isString(relative)) {
      var rel = new Url();
      rel.parse(relative, false, true);
      relative = rel;
    }

    var result = new Url();
    var tkeys = Object.keys(this);

    for (var tk = 0; tk < tkeys.length; tk++) {
      var tkey = tkeys[tk];
      result[tkey] = this[tkey];
    } // hash is always overridden, no matter what.
    // even href="" will remove it.


    result.hash = relative.hash; // if the relative url is empty, then there's nothing left to do here.

    if (relative.href === '') {
      result.href = result.format();
      return result;
    } // hrefs like //foo/bar always cut to the protocol.


    if (relative.slashes && !relative.protocol) {
      // take everything except the protocol from relative
      var rkeys = Object.keys(relative);

      for (var rk = 0; rk < rkeys.length; rk++) {
        var rkey = rkeys[rk];
        if (rkey !== 'protocol') result[rkey] = relative[rkey];
      } //urlParse appends trailing / to urls like http://www.example.com


      if (slashedProtocol[result.protocol] && result.hostname && !result.pathname) {
        result.path = result.pathname = '/';
      }

      result.href = result.format();
      return result;
    }

    var relPath;

    if (relative.protocol && relative.protocol !== result.protocol) {
      // if it's a known url protocol, then changing
      // the protocol does weird things
      // first, if it's not file:, then we MUST have a host,
      // and if there was a path
      // to begin with, then we MUST have a path.
      // if it is file:, then the host is dropped,
      // because that's known to be hostless.
      // anything else is assumed to be absolute.
      if (!slashedProtocol[relative.protocol]) {
        var keys = Object.keys(relative);

        for (var v = 0; v < keys.length; v++) {
          var k = keys[v];
          result[k] = relative[k];
        }

        result.href = result.format();
        return result;
      }

      result.protocol = relative.protocol;

      if (!relative.host && !hostlessProtocol[relative.protocol]) {
        relPath = (relative.pathname || '').split('/');

        while (relPath.length && !(relative.host = relPath.shift()));

        if (!relative.host) relative.host = '';
        if (!relative.hostname) relative.hostname = '';
        if (relPath[0] !== '') relPath.unshift('');
        if (relPath.length < 2) relPath.unshift('');
        result.pathname = relPath.join('/');
      } else {
        result.pathname = relative.pathname;
      }

      result.search = relative.search;
      result.query = relative.query;
      result.host = relative.host || '';
      result.auth = relative.auth;
      result.hostname = relative.hostname || relative.host;
      result.port = relative.port; // to support http.request

      if (result.pathname || result.search) {
        var p = result.pathname || '';
        var s = result.search || '';
        result.path = p + s;
      }

      result.slashes = result.slashes || relative.slashes;
      result.href = result.format();
      return result;
    }

    var isSourceAbs = result.pathname && result.pathname.charAt(0) === '/',
        isRelAbs = relative.host || relative.pathname && relative.pathname.charAt(0) === '/',
        mustEndAbs = isRelAbs || isSourceAbs || result.host && relative.pathname,
        removeAllDots = mustEndAbs,
        srcPath = result.pathname && result.pathname.split('/') || [],
        psychotic = result.protocol && !slashedProtocol[result.protocol];
    relPath = relative.pathname && relative.pathname.split('/') || []; // if the url is a non-slashed url, then relative
    // links like ../.. should be able
    // to crawl up to the hostname, as well.  This is strange.
    // result.protocol has already been set by now.
    // Later on, put the first path part into the host field.

    if (psychotic) {
      result.hostname = '';
      result.port = null;

      if (result.host) {
        if (srcPath[0] === '') srcPath[0] = result.host;else srcPath.unshift(result.host);
      }

      result.host = '';

      if (relative.protocol) {
        relative.hostname = null;
        relative.port = null;

        if (relative.host) {
          if (relPath[0] === '') relPath[0] = relative.host;else relPath.unshift(relative.host);
        }

        relative.host = null;
      }

      mustEndAbs = mustEndAbs && (relPath[0] === '' || srcPath[0] === '');
    }

    var authInHost;

    if (isRelAbs) {
      // it's absolute.
      result.host = relative.host || relative.host === '' ? relative.host : result.host;
      result.hostname = relative.hostname || relative.hostname === '' ? relative.hostname : result.hostname;
      result.search = relative.search;
      result.query = relative.query;
      srcPath = relPath; // fall through to the dot-handling below.
    } else if (relPath.length) {
      // it's relative
      // throw away the existing file, and take the new path instead.
      if (!srcPath) srcPath = [];
      srcPath.pop();
      srcPath = srcPath.concat(relPath);
      result.search = relative.search;
      result.query = relative.query;
    } else if (!isNullOrUndefined(relative.search)) {
      // just pull out the search.
      // like href='?foo'.
      // Put this after the other two cases because it simplifies the booleans
      if (psychotic) {
        result.hostname = result.host = srcPath.shift(); //occationaly the auth can get stuck only in host
        //this especially happens in cases like
        //url.resolveObject('mailto:local1@domain1', 'local2@domain2')

        authInHost = result.host && result.host.indexOf('@') > 0 ? result.host.split('@') : false;

        if (authInHost) {
          result.auth = authInHost.shift();
          result.host = result.hostname = authInHost.shift();
        }
      }

      result.search = relative.search;
      result.query = relative.query; //to support http.request

      if (!isNull(result.pathname) || !isNull(result.search)) {
        result.path = (result.pathname ? result.pathname : '') + (result.search ? result.search : '');
      }

      result.href = result.format();
      return result;
    }

    if (!srcPath.length) {
      // no path at all.  easy.
      // we've already handled the other stuff above.
      result.pathname = null; //to support http.request

      if (result.search) {
        result.path = '/' + result.search;
      } else {
        result.path = null;
      }

      result.href = result.format();
      return result;
    } // if a url ENDs in . or .., then it must get a trailing slash.
    // however, if it ends in anything else non-slashy,
    // then it must NOT get a trailing slash.


    var last = srcPath.slice(-1)[0];
    var hasTrailingSlash = (result.host || relative.host || srcPath.length > 1) && (last === '.' || last === '..') || last === ''; // strip single dots, resolve double dots to parent dir
    // if the path tries to go above the root, `up` ends up > 0

    var up = 0;

    for (var i = srcPath.length; i >= 0; i--) {
      last = srcPath[i];

      if (last === '.') {
        srcPath.splice(i, 1);
      } else if (last === '..') {
        srcPath.splice(i, 1);
        up++;
      } else if (up) {
        srcPath.splice(i, 1);
        up--;
      }
    } // if the path is allowed to go above the root, restore leading ..s


    if (!mustEndAbs && !removeAllDots) {
      for (; up--; up) {
        srcPath.unshift('..');
      }
    }

    if (mustEndAbs && srcPath[0] !== '' && (!srcPath[0] || srcPath[0].charAt(0) !== '/')) {
      srcPath.unshift('');
    }

    if (hasTrailingSlash && srcPath.join('/').substr(-1) !== '/') {
      srcPath.push('');
    }

    var isAbsolute = srcPath[0] === '' || srcPath[0] && srcPath[0].charAt(0) === '/'; // put the host back

    if (psychotic) {
      result.hostname = result.host = isAbsolute ? '' : srcPath.length ? srcPath.shift() : ''; //occationaly the auth can get stuck only in host
      //this especially happens in cases like
      //url.resolveObject('mailto:local1@domain1', 'local2@domain2')

      authInHost = result.host && result.host.indexOf('@') > 0 ? result.host.split('@') : false;

      if (authInHost) {
        result.auth = authInHost.shift();
        result.host = result.hostname = authInHost.shift();
      }
    }

    mustEndAbs = mustEndAbs || result.host && srcPath.length;

    if (mustEndAbs && !isAbsolute) {
      srcPath.unshift('');
    }

    if (!srcPath.length) {
      result.pathname = null;
      result.path = null;
    } else {
      result.pathname = srcPath.join('/');
    } //to support request.http


    if (!isNull(result.pathname) || !isNull(result.search)) {
      result.path = (result.pathname ? result.pathname : '') + (result.search ? result.search : '');
    }

    result.auth = relative.auth || result.auth;
    result.slashes = result.slashes || relative.slashes;
    result.href = result.format();
    return result;
  };

  Url.prototype.parseHost = function () {
    return parseHost(this);
  };

  function parseHost(self) {
    var host = self.host;
    var port = portPattern.exec(host);

    if (port) {
      port = port[0];

      if (port !== ':') {
        self.port = port.substr(1);
      }

      host = host.substr(0, host.length - port.length);
    }

    if (host) self.hostname = host;
  }

  function parseRequestUrl(requestUrl) {
    var parsed = url.parse(requestUrl);
    return {
      host: parsed.hostname,
      path: parsed.pathname
    };
  }

  var parseUrl = parseRequestUrl;

  var Some$4 = option.Some,
      None$3 = option.None;

  function stringToBoolean(str) {
    return str === '1' || str === 'true';
  }

  function stringToIntOption(str) {
    try {
      return new Some$4(parseInt(str));
    } catch (err) {
      return None$3;
    }
  }

  function containsRequiredHeaders(readHeader) {
    return readHeader(httpHeaders.TraceId) !== None$3 && readHeader(httpHeaders.SpanId) !== None$3;
  }

  function requiredArg$1(name) {
    throw new Error("HttpServerInstrumentation: Missing required argument ".concat(name, "."));
  }

  var HttpServerInstrumentation = /*#__PURE__*/function () {
    function HttpServerInstrumentation(_ref) {
      var _ref$tracer = _ref.tracer,
          tracer = _ref$tracer === void 0 ? requiredArg$1('tracer') : _ref$tracer,
          _ref$serviceName = _ref.serviceName,
          serviceName = _ref$serviceName === void 0 ? tracer.localEndpoint.serviceName : _ref$serviceName,
          host = _ref.host,
          _ref$port = _ref.port,
          port = _ref$port === void 0 ? requiredArg$1('port') : _ref$port;

      _classCallCheck(this, HttpServerInstrumentation);

      this.tracer = tracer;
      this.serviceName = serviceName;
      this.host = host && new InetAddress_1(host);
      this.port = port;
    }

    _createClass(HttpServerInstrumentation, [{
      key: "_createIdFromHeaders",
      value: function _createIdFromHeaders(readHeader) {
        if (containsRequiredHeaders(readHeader)) {
          var spanId = readHeader(httpHeaders.SpanId);
          var parentId = spanId.map(function (sid) {
            var traceId = readHeader(httpHeaders.TraceId);
            var parentSpanId = readHeader(httpHeaders.ParentSpanId);
            var sampled = readHeader(httpHeaders.Sampled);
            var flags = readHeader(httpHeaders.Flags).flatMap(stringToIntOption).getOrElse(0);
            return new TraceId_1({
              traceId: traceId.getOrElse(),
              parentId: parentSpanId,
              spanId: sid,
              debug: flags === 1,
              sampled: sampled.map(stringToBoolean)
            });
          });
          return new Some$4(this.tracer.join(parentId.getOrElse()));
        } else if (readHeader(httpHeaders.Flags) !== None$3 || readHeader(httpHeaders.Sampled) !== None$3) {
          var sampled = readHeader(httpHeaders.Sampled) === None$3 ? None$3 : readHeader(httpHeaders.Sampled).map(stringToBoolean);
          var flags = readHeader(httpHeaders.Flags).flatMap(stringToIntOption).getOrElse(0);
          return new Some$4(this.tracer.createRootId(sampled, flags === 1));
        } else {
          return new Some$4(this.tracer.createRootId());
        }
      }
    }, {
      key: "spanNameFromRoute",
      value: function spanNameFromRoute(method, route, code) {
        // eslint-disable-line class-methods-use-this
        if (code > 299 && code < 400) return "".concat(method, " redirected");
        if (code === 404) return "".concat(method, " not_found");
        if (!route || route === '') return method;
        return "".concat(method, " ").concat(route);
      }
    }, {
      key: "recordRequest",
      value: function recordRequest(method, requestUrl, readHeader) {
        var _this = this;

        this._createIdFromHeaders(readHeader).ifPresent(function (id) {
          return _this.tracer.setId(id);
        });

        var id = this.tracer.id;

        var _parseRequestUrl = parseUrl(requestUrl),
            path = _parseRequestUrl.path;

        this.tracer.recordServiceName(this.serviceName);
        this.tracer.recordRpc(method.toUpperCase());
        this.tracer.recordBinary('http.path', path);
        this.tracer.recordAnnotation(new annotation_1.ServerRecv());
        this.tracer.recordAnnotation(new annotation_1.LocalAddr({
          host: this.host,
          port: this.port
        }));
        return id;
      }
    }, {
      key: "recordResponse",
      value: function recordResponse(id, statusCode, error) {
        this.tracer.setId(id);
        this.tracer.recordBinary('http.status_code', statusCode.toString());

        if (error) {
          this.tracer.recordBinary('error', error.toString());
        } else if (statusCode < 200 || statusCode > 399) {
          this.tracer.recordBinary('error', statusCode.toString());
        }

        this.tracer.recordAnnotation(new annotation_1.ServerSend());
      }
    }]);

    return HttpServerInstrumentation;
  }();

  var httpServer = HttpServerInstrumentation;

  function appendZipkinHeaders(req, traceId) {
    var headers = req.headers || {};
    headers[httpHeaders.TraceId] = traceId.traceId;
    headers[httpHeaders.SpanId] = traceId.spanId;
    traceId.parentSpanId.ifPresent(function (psid) {
      headers[httpHeaders.ParentSpanId] = psid;
    });
    traceId.sampled.ifPresent(function (sampled) {
      headers[httpHeaders.Sampled] = sampled ? '1' : '0';
    });

    if (traceId.isDebug()) {
      headers[httpHeaders.Flags] = '1';
    }

    return headers;
  }

  function addZipkinHeaders(req, traceId) {
    var headers = appendZipkinHeaders(req, traceId);
    return Object.assign({}, req, {
      headers: headers
    });
  }

  var request = {
    addZipkinHeaders: addZipkinHeaders
  };

  function requiredArg$2(name) {
    throw new Error("HttpClientInstrumentation: Missing required argument ".concat(name, "."));
  }

  var HttpClientInstrumentation = /*#__PURE__*/function () {
    function HttpClientInstrumentation(_ref) {
      var _ref$tracer = _ref.tracer,
          tracer = _ref$tracer === void 0 ? requiredArg$2('tracer') : _ref$tracer,
          _ref$serviceName = _ref.serviceName,
          serviceName = _ref$serviceName === void 0 ? tracer.localEndpoint.serviceName : _ref$serviceName,
          remoteServiceName = _ref.remoteServiceName;

      _classCallCheck(this, HttpClientInstrumentation);

      this.tracer = tracer;
      this.serviceName = serviceName;
      this.remoteServiceName = remoteServiceName;
    }

    _createClass(HttpClientInstrumentation, [{
      key: "recordRequest",
      value: function recordRequest(request$$1, url, method) {
        this.tracer.setId(this.tracer.createChildId());
        var traceId = this.tracer.id;

        var _parseRequestUrl = parseUrl(url),
            path = _parseRequestUrl.path;

        this.tracer.recordServiceName(this.serviceName);
        this.tracer.recordRpc(method.toUpperCase());
        this.tracer.recordBinary('http.path', path);
        this.tracer.recordAnnotation(new annotation_1.ClientSend());

        if (this.remoteServiceName) {
          // TODO: can we get the host and port of the http connection?
          this.tracer.recordAnnotation(new annotation_1.ServerAddr({
            serviceName: this.remoteServiceName
          }));
        }

        return request.addZipkinHeaders(request$$1, traceId);
      }
    }, {
      key: "recordResponse",
      value: function recordResponse(traceId, statusCode) {
        this.tracer.setId(traceId);
        this.tracer.recordBinary('http.status_code', statusCode.toString());

        if (statusCode < 200 || statusCode > 399) {
          this.tracer.recordBinary('error', statusCode.toString());
        }

        this.tracer.recordAnnotation(new annotation_1.ClientRecv());
      }
    }, {
      key: "recordError",
      value: function recordError(traceId, error) {
        this.tracer.setId(traceId);
        this.tracer.recordBinary('error', error.toString());
        this.tracer.recordAnnotation(new annotation_1.ClientRecv());
      }
    }]);

    return HttpClientInstrumentation;
  }();

  var httpClient = HttpClientInstrumentation;

  var instrumentation = {
    HttpServer: httpServer,
    HttpClient: httpClient
  };

  function toV1Endpoint(endpoint) {
    if (endpoint === undefined) {
      return undefined;
    }

    var res = {
      serviceName: endpoint.serviceName || '' // undefined is not allowed in v1

    };

    if (endpoint.ipv4) {
      res.ipv4 = endpoint.ipv4;
    }

    if (endpoint.port) {
      res.port = endpoint.port;
    }

    return res;
  }

  function toV1Annotation(ann, endpoint) {
    return {
      value: ann.value,
      timestamp: ann.timestamp,
      endpoint: endpoint
    };
  }

  function encodeV1(span) {
    var res = {
      traceId: span.traceId
    };

    if (span.parentId) {
      // instead of writing "parentId": NULL
      res.parentId = span.parentId;
    }

    res.id = span.id;
    res.name = span.name || ''; // undefined is not allowed in v1
    // Log timestamp and duration if this tracer started and completed this span.

    if (!span.shared) {
      res.timestamp = span.timestamp;
      res.duration = span.duration;
    }

    var jsonEndpoint = toV1Endpoint(span.localEndpoint);
    var beginAnnotation;
    var endAnnotation;
    var addressKey;

    switch (span.kind) {
      case 'CLIENT':
        beginAnnotation = span.timestamp ? 'cs' : undefined;
        endAnnotation = 'cr';
        addressKey = 'sa';
        break;

      case 'SERVER':
        beginAnnotation = span.timestamp ? 'sr' : undefined;
        endAnnotation = 'ss';
        addressKey = 'ca';
        break;

      case 'PRODUCER':
        beginAnnotation = span.timestamp ? 'ms' : undefined;
        endAnnotation = 'ws';
        addressKey = 'ma';
        break;

      case 'CONSUMER':
        if (span.timestamp && span.duration) {
          beginAnnotation = 'wr';
          endAnnotation = 'mr';
        } else if (span.timestamp) {
          beginAnnotation = 'mr';
        }

        addressKey = 'ma';
        break;

      default:
    }

    if (span.annotations.length > 0 || beginAnnotation) {
      // don't write empty array
      res.annotations = span.annotations.map(function (ann) {
        return toV1Annotation(ann, jsonEndpoint);
      });
    }

    if (beginAnnotation) {
      res.annotations.push({
        value: beginAnnotation,
        timestamp: span.timestamp,
        endpoint: jsonEndpoint
      });

      if (span.duration) {
        res.annotations.push({
          value: endAnnotation,
          timestamp: span.timestamp + span.duration,
          endpoint: jsonEndpoint
        });
      }
    }

    var keys = Object.keys(span.tags);

    if (keys.length > 0 || span.remoteEndpoint) {
      // don't write empty array
      res.binaryAnnotations = keys.map(function (key) {
        return {
          key: key,
          value: span.tags[key],
          endpoint: jsonEndpoint
        };
      });
    }

    if (span.remoteEndpoint) {
      var address = {
        key: addressKey,
        value: true,
        endpoint: toV1Endpoint(span.remoteEndpoint)
      };
      res.binaryAnnotations.push(address);
    }

    if (span.debug) {
      // instead of writing "debug": false
      res.debug = true;
    }

    return JSON.stringify(res);
  }

  function encodeV2(span) {
    var copy = {
      traceId: span.traceId
    };

    if (span.parentId) {
      copy.parentId = span.parentId;
    }

    copy.id = span.id;

    if (span.name) {
      copy.name = span.name;
    }

    if (span.kind) {
      copy.kind = span.kind;
    }

    if (span.timestamp) {
      copy.timestamp = span.timestamp;
    }

    if (span.duration) {
      copy.duration = span.duration;
    }

    if (span.localEndpoint) {
      copy.localEndpoint = span.localEndpoint;
    }

    if (span.remoteEndpoint) {
      copy.remoteEndpoint = span.remoteEndpoint;
    }

    if (span.annotations.length > 0) {
      copy.annotations = span.annotations;
    }

    if (Object.keys(span.tags).length > 0) {
      copy.tags = span.tags;
    }

    if (span.debug) {
      copy.debug = true;
    }

    if (span.shared) {
      copy.shared = true;
    }

    return JSON.stringify(copy);
  }

  var JSON_V1 = {
    encode: function encode(span) {
      return encodeV1(span);
    }
  };
  var JSON_V2 = {
    encode: function encode(span) {
      return encodeV2(span);
    }
  };
  var jsonEncoder = {
    JSON_V1: JSON_V1,
    JSON_V2: JSON_V2
  };

  exports.option = option;
  exports.Annotation = annotation_1;
  exports.Tracer = tracer;
  exports.createNoopTracer = noop$1;
  exports.randomTraceId = randomTraceId_1;
  exports.sampler = sampler;
  exports.TraceId = TraceId_1;
  exports.HttpHeaders = httpHeaders;
  exports.InetAddress = InetAddress_1;
  exports.BatchRecorder = batchRecorder;
  exports.ConsoleRecorder = consoleRecorder;
  exports.ExplicitContext = explicitContext;
  exports.Instrumentation = instrumentation;
  exports.Request = request;
  exports.jsonEncoder = jsonEncoder;
  exports.model = model;
  exports.parseRequestUrl = parseUrl;

  Object.defineProperty(exports, '__esModule', { value: true });

})));
