'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var os = _interopDefault(require('os'));
var url = _interopDefault(require('url'));

function _typeof(obj) {
  "@babel/helpers - typeof";

  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof = function (obj) {
      return typeof obj;
    };
  } else {
    _typeof = function (obj) {
      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    };
  }

  return _typeof(obj);
}

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}

function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  return Constructor;
}

function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }

  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      writable: true,
      configurable: true
    }
  });
  if (superClass) _setPrototypeOf(subClass, superClass);
}

function _getPrototypeOf(o) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
    return o.__proto__ || Object.getPrototypeOf(o);
  };
  return _getPrototypeOf(o);
}

function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };

  return _setPrototypeOf(o, p);
}

function _isNativeReflectConstruct() {
  if (typeof Reflect === "undefined" || !Reflect.construct) return false;
  if (Reflect.construct.sham) return false;
  if (typeof Proxy === "function") return true;

  try {
    Date.prototype.toString.call(Reflect.construct(Date, [], function () {}));
    return true;
  } catch (e) {
    return false;
  }
}

function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return self;
}

function _possibleConstructorReturn(self, call) {
  if (call && (typeof call === "object" || typeof call === "function")) {
    return call;
  }

  return _assertThisInitialized(self);
}

function _createSuper(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct();

  return function () {
    var Super = _getPrototypeOf(Derived),
        result;

    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf(this).constructor;

      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }

    return _possibleConstructorReturn(this, result);
  };
}

// Copyright 2020 The OpenZipkin Authors; licensed to You under the Apache License, Version 2.0.
var None = {
  get type() {
    return 'None';
  },

  get present() {
    return false;
  },

  map: function map() {
    return this;
  },
  ifPresent: function ifPresent() {},
  flatMap: function flatMap() {
    return this;
  },
  getOrElse: function getOrElse(f) {
    return f instanceof Function ? f() : f;
  },
  equals: function equals(other) {
    return other === this;
  },
  toString: function toString() {
    return 'None';
  }
};

var Some = /*#__PURE__*/function () {
  function Some(value) {
    _classCallCheck(this, Some);

    this.value = value;
  }

  _createClass(Some, [{
    key: "map",
    value: function map(f) {
      return new Some(f(this.value));
    }
  }, {
    key: "ifPresent",
    value: function ifPresent(f) {
      f(this.value);
    }
  }, {
    key: "flatMap",
    value: function flatMap(f) {
      return f(this.value);
    }
  }, {
    key: "getOrElse",
    value: function getOrElse() {
      return this.value;
    }
  }, {
    key: "equals",
    value: function equals(other) {
      return other instanceof Some && other.value === this.value;
    }
  }, {
    key: "toString",
    value: function toString() {
      return "Some(".concat(this.value, ")");
    }
  }, {
    key: "type",
    get: function get() {
      // eslint-disable-line class-methods-use-this
      return 'Some';
    }
  }, {
    key: "present",
    get: function get() {
      // eslint-disable-line class-methods-use-this
      return true;
    }
  }]);

  return Some;
}(); // Used to validate input arguments


function isOptional(data) {
  return data instanceof Some || None.equals(data);
}

function verifyIsOptional(data) {
  if (data == null) {
    throw new Error('Error: data is not Optional - it\'s null');
  }

  if (isOptional(data)) {
    if (isOptional(data.value)) {
      throw new Error("Error: data (".concat(data.value, ") is wrapped in Option twice"));
    }
  } else {
    throw new Error("Error: data (".concat(data, ") is not an Option!"));
  }
}

function verifyIsNotOptional(data) {
  if (isOptional(data)) {
    throw new Error("Error: data (".concat(data, ") is an Option!"));
  }
}

function fromNullable(nullable) {
  return nullable == null ? None : new Some(nullable);
}

var Some_1 = Some;
var None_1 = None;
var isOptional_1 = isOptional;
var verifyIsOptional_1 = verifyIsOptional;
var verifyIsNotOptional_1 = verifyIsNotOptional;
var fromNullable_1 = fromNullable;
var option = {
  Some: Some_1,
  None: None_1,
  isOptional: isOptional_1,
  verifyIsOptional: verifyIsOptional_1,
  verifyIsNotOptional: verifyIsNotOptional_1,
  fromNullable: fromNullable_1
};

function pickInterface(interfaces, family) {
  /* eslint-disable */
  for (var i in interfaces) {
    /* eslint-enable */
    for (var j = interfaces[i].length - 1; j >= 0; j -= 1) {
      var face = interfaces[i][j];
      var reachable = family === 'IPv4' || face.scopeid === 0;
      if (!face.internal && face.family === family && reachable) return face.address;
    }
  }

  return family === 'IPv4' ? '127.0.0.1' : '::1';
}

function reduceInterfaces(interfaces, iface) {
  var ifaces = {};
  /*eslint-disable */

  for (var i in interfaces) {
    /* eslint-enable */
    if (i === iface) ifaces[i] = interfaces[i];
  }

  return ifaces;
}

function ipv4(iface) {
  var interfaces = os.networkInterfaces();
  if (iface) interfaces = reduceInterfaces(interfaces, iface);
  return pickInterface(interfaces, 'IPv4');
}

function ipv6(iface) {
  var interfaces = os.networkInterfaces();
  if (iface) interfaces = reduceInterfaces(interfaces, iface);
  return pickInterface(interfaces, 'IPv6');
}

ipv4.ipv4 = ipv4;
ipv4.ipv6 = ipv6;
var network = ipv4;

var InetAddress = /*#__PURE__*/function () {
  function InetAddress(addr) {
    _classCallCheck(this, InetAddress);

    this.addr = addr;
  } // returns undefined if this isn't an IPv4 string


  _createClass(InetAddress, [{
    key: "ipv4",
    value: function ipv4() {
      // coercing to int forces validation here
      var ipv4Int = this.toInt();

      if (ipv4Int && ipv4Int !== 0) {
        return this.addr;
      }

      return undefined;
    }
  }, {
    key: "toInt",
    value: function toInt() {
      // e.g. 10.57.50.83
      // should become
      // 171520595
      var parts = this.addr.split('.'); // The eslint tool always complains about using bitwise operators,
      // but in this case it's actually intentional, so we disable the warning:

      /* eslint-disable-next-line */

      return parts[0] << 24 | parts[1] << 16 | parts[2] << 8 | parts[3];
    }
  }, {
    key: "toString",
    value: function toString() {
      return "InetAddress(".concat(this.addr, ")");
    }
  }]);

  return InetAddress;
}(); // In non-node environments we fallback to 127.0.0.1


function getLocalAddress() {
  var isNode = (typeof process === "undefined" ? "undefined" : _typeof(process)) === 'object' && typeof process.on === 'function';

  if (!isNode) {
    return new InetAddress('127.0.0.1');
  } // eslint-disable-next-line global-require


  var networkAddress = network;
  return new InetAddress(networkAddress.ipv4());
} // Cache this value at import time so as to avoid network interface
// lookup on every call


var cachedLocalAddress = getLocalAddress();

InetAddress.getLocalAddress = function () {
  return cachedLocalAddress;
};

var InetAddress_1 = InetAddress;

var SimpleAnnotation = /*#__PURE__*/function () {
  function SimpleAnnotation() {
    _classCallCheck(this, SimpleAnnotation);
  }

  _createClass(SimpleAnnotation, [{
    key: "toString",
    value: function toString() {
      return "".concat(this.annotationType, "()");
    }
  }]);

  return SimpleAnnotation;
}();

var ClientSend = /*#__PURE__*/function (_SimpleAnnotation) {
  _inherits(ClientSend, _SimpleAnnotation);

  var _super = _createSuper(ClientSend);

  function ClientSend() {
    _classCallCheck(this, ClientSend);

    return _super.apply(this, arguments);
  }

  return ClientSend;
}(SimpleAnnotation);

var ClientRecv = /*#__PURE__*/function (_SimpleAnnotation2) {
  _inherits(ClientRecv, _SimpleAnnotation2);

  var _super2 = _createSuper(ClientRecv);

  function ClientRecv() {
    _classCallCheck(this, ClientRecv);

    return _super2.apply(this, arguments);
  }

  return ClientRecv;
}(SimpleAnnotation);

var ServerSend = /*#__PURE__*/function (_SimpleAnnotation3) {
  _inherits(ServerSend, _SimpleAnnotation3);

  var _super3 = _createSuper(ServerSend);

  function ServerSend() {
    _classCallCheck(this, ServerSend);

    return _super3.apply(this, arguments);
  }

  return ServerSend;
}(SimpleAnnotation);

var ServerRecv = /*#__PURE__*/function (_SimpleAnnotation4) {
  _inherits(ServerRecv, _SimpleAnnotation4);

  var _super4 = _createSuper(ServerRecv);

  function ServerRecv() {
    _classCallCheck(this, ServerRecv);

    return _super4.apply(this, arguments);
  }

  return ServerRecv;
}(SimpleAnnotation);

var ProducerStart = /*#__PURE__*/function (_SimpleAnnotation5) {
  _inherits(ProducerStart, _SimpleAnnotation5);

  var _super5 = _createSuper(ProducerStart);

  function ProducerStart() {
    _classCallCheck(this, ProducerStart);

    return _super5.apply(this, arguments);
  }

  return ProducerStart;
}(SimpleAnnotation);

var ProducerStop = /*#__PURE__*/function (_SimpleAnnotation6) {
  _inherits(ProducerStop, _SimpleAnnotation6);

  var _super6 = _createSuper(ProducerStop);

  function ProducerStop() {
    _classCallCheck(this, ProducerStop);

    return _super6.apply(this, arguments);
  }

  return ProducerStop;
}(SimpleAnnotation);

var ConsumerStart = /*#__PURE__*/function (_SimpleAnnotation7) {
  _inherits(ConsumerStart, _SimpleAnnotation7);

  var _super7 = _createSuper(ConsumerStart);

  function ConsumerStart() {
    _classCallCheck(this, ConsumerStart);

    return _super7.apply(this, arguments);
  }

  return ConsumerStart;
}(SimpleAnnotation);

var ConsumerStop = /*#__PURE__*/function (_SimpleAnnotation8) {
  _inherits(ConsumerStop, _SimpleAnnotation8);

  var _super8 = _createSuper(ConsumerStop);

  function ConsumerStop() {
    _classCallCheck(this, ConsumerStop);

    return _super8.apply(this, arguments);
  }

  return ConsumerStop;
}(SimpleAnnotation);

function LocalOperationStart(name) {
  this.name = name;
}

LocalOperationStart.prototype.toString = function () {
  return "LocalOperationStart(\"".concat(this.name, "\")");
};

var LocalOperationStop = /*#__PURE__*/function (_SimpleAnnotation9) {
  _inherits(LocalOperationStop, _SimpleAnnotation9);

  var _super9 = _createSuper(LocalOperationStop);

  function LocalOperationStop() {
    _classCallCheck(this, LocalOperationStop);

    return _super9.apply(this, arguments);
  }

  return LocalOperationStop;
}(SimpleAnnotation);

function Message(message) {
  this.message = message;
}

Message.prototype.toString = function () {
  return "Message(\"".concat(this.message, "\")");
};

function ServiceName(serviceName) {
  this.serviceName = serviceName;
}

ServiceName.prototype.toString = function () {
  return "ServiceName(\"".concat(this.serviceName, "\")");
};

function Rpc(name) {
  this.name = name;
}

Rpc.prototype.toString = function () {
  return "Rpc(\"".concat(this.name, "\")");
};

function ClientAddr(_ref) {
  var host = _ref.host,
      port = _ref.port;
  this.host = host;
  this.port = port;
}

ClientAddr.prototype.toString = function () {
  return "ClientAddr(host=\"".concat(this.host, "\", port=").concat(this.port, ")");
};

function ServerAddr(_ref2) {
  var serviceName = _ref2.serviceName,
      host = _ref2.host,
      port = _ref2.port;
  this.serviceName = serviceName;
  this.host = host || undefined;
  this.port = port || 0;
}

ServerAddr.prototype.toString = function () {
  return "ServerAddr(serviceName=\"".concat(this.serviceName, "\", host=\"").concat(this.host, "\", port=").concat(this.port, ")");
};

function LocalAddr(_ref3) {
  var host = _ref3.host,
      port = _ref3.port;
  this.host = host || InetAddress_1.getLocalAddress();
  this.port = port || 0;
}

LocalAddr.prototype.toString = function () {
  return "LocalAddr(host=\"".concat(this.host.toString(), "\", port=").concat(this.port, ")");
};

function MessageAddr(_ref4) {
  var serviceName = _ref4.serviceName,
      host = _ref4.host,
      port = _ref4.port;
  this.serviceName = serviceName;
  this.host = host;
  this.port = port;
}

MessageAddr.prototype.toString = function () {
  return "MessageAddr(serviceName=\"".concat(this.serviceName, "\", host=\"").concat(this.host, "\", port=").concat(this.port, ")");
};

function BinaryAnnotation(key, value) {
  this.key = key;
  this.value = value;
}

BinaryAnnotation.prototype.toString = function () {
  return "BinaryAnnotation(".concat(this.key, "=\"").concat(this.value, "\")");
};

var annotation = {
  ClientSend: ClientSend,
  ClientRecv: ClientRecv,
  ServerSend: ServerSend,
  ServerRecv: ServerRecv,
  ProducerStart: ProducerStart,
  ProducerStop: ProducerStop,
  ConsumerStart: ConsumerStart,
  ConsumerStop: ConsumerStop,
  MessageAddr: MessageAddr,
  Message: Message,
  ServiceName: ServiceName,
  Rpc: Rpc,
  ClientAddr: ClientAddr,
  ServerAddr: ServerAddr,
  LocalAddr: LocalAddr,
  BinaryAnnotation: BinaryAnnotation,
  LocalOperationStart: LocalOperationStart,
  LocalOperationStop: LocalOperationStop
};
Object.keys(annotation).forEach(function (key) {
  annotation[key].prototype.annotationType = key;
});
var annotation_1 = annotation;

var isPromise_1 = isPromise;
var default_1 = isPromise;

function isPromise(obj) {
  return !!obj && (typeof obj === 'object' || typeof obj === 'function') && typeof obj.then === 'function';
}
isPromise_1.default = default_1;

var Some$1 = option.Some; // Determines whether or not a traceId should be sampled.
// If no sample decision is already made (by a debug flag, or
// the "sampled" property is set), it will use evaluator,
// which is a function traceId => Boolean, and returns true if
// the traceId should be sampled (stored in Zipkin).

var Sampler = /*#__PURE__*/function () {
  function Sampler(evaluator) {
    _classCallCheck(this, Sampler);

    this.evaluator = evaluator;
  }

  _createClass(Sampler, [{
    key: "shouldSample",
    value: function shouldSample(traceId) {
      var _this = this;

      var result = traceId.sampled.getOrElse(function () {
        return _this.evaluator(traceId);
      });
      return new Some$1(result);
    }
  }, {
    key: "toString",
    value: function toString() {
      return "Sampler(".concat(this.evaluator.toString(), ")");
    }
  }]);

  return Sampler;
}();

function neverSample(traceId) {
  // eslint-disable-line no-unused-vars
  return false;
}

neverSample.toString = function () {
  return 'never sample';
};

function alwaysSample(traceId) {
  // eslint-disable-line no-unused-vars
  return true;
}

alwaysSample.toString = function () {
  return 'always sample';
};

function makeCountingEvaluator(sampleRate) {
  if (sampleRate <= 0) {
    return neverSample;
  } else if (sampleRate >= 1) {
    return alwaysSample;
  } else {
    var counter = 0;
    var limit = parseInt(1 / sampleRate);

    var counting = function counting(traceId) {
      // eslint-disable-line no-unused-vars
      counter %= limit;
      var shouldSample = counter === 0;
      counter += 1;
      return shouldSample;
    };

    counting.toString = function () {
      return "countingSampler: sampleRate=".concat(sampleRate);
    };

    return counting;
  }
}

var CountingSampler = /*#__PURE__*/function (_Sampler) {
  _inherits(CountingSampler, _Sampler);

  var _super = _createSuper(CountingSampler);

  function CountingSampler() {
    var sampleRate = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;

    _classCallCheck(this, CountingSampler);

    return _super.call(this, makeCountingEvaluator(sampleRate < 1 ? sampleRate : 1));
  }

  return CountingSampler;
}(Sampler);

var sampler = {
  Sampler: Sampler,
  CountingSampler: CountingSampler,
  neverSample: neverSample,
  alwaysSample: alwaysSample
};

// Copyright 2020 The OpenZipkin Authors; licensed to You under the Apache License, Version 2.0.
var Record = /*#__PURE__*/function () {
  function Record(_ref) {
    var traceId = _ref.traceId,
        timestamp = _ref.timestamp,
        annotation = _ref.annotation;

    _classCallCheck(this, Record);

    this.traceId = traceId;
    this.timestamp = timestamp;
    this.annotation = annotation;
  }

  _createClass(Record, [{
    key: "toString",
    value: function toString() {
      return "Record(traceId=".concat(this.traceId.toString(), ", annotation=").concat(this.annotation.toString(), ")");
    }
  }]);

  return Record;
}();

var record = Record;

var Some$2 = option.Some,
    None$1 = option.None,
    verifyIsOptional$1 = option.verifyIsOptional,
    verifyIsNotOptional$1 = option.verifyIsNotOptional,
    isOptional$1 = option.isOptional;
var T = new Some$2(true);

var TraceId = /*#__PURE__*/function () {
  function TraceId(params) {
    _classCallCheck(this, TraceId);

    var spanId = params.spanId,
        _params$traceId = params.traceId,
        traceId = _params$traceId === void 0 ? spanId : _params$traceId,
        _params$parentId = params.parentId,
        parentId = _params$parentId === void 0 ? None$1 : _params$parentId,
        _params$flags = params.flags,
        flags = _params$flags === void 0 ? 0 : _params$flags,
        _params$debug = params.debug,
        debug = _params$debug === void 0 ? flags === 1 : _params$debug,
        _params$sampled = params.sampled,
        sampled = _params$sampled === void 0 ? None$1 : _params$sampled,
        _params$shared = params.shared,
        shared = _params$shared === void 0 ? false : _params$shared;
    verifyIsNotOptional$1(spanId);
    verifyIsOptional$1(parentId);
    verifyIsOptional$1(sampled); // support old signatures which allowed traceId to be optional

    if (isOptional$1(traceId)) {
      this._traceId = traceId.getOrElse(spanId);
    } else if (typeof traceId === 'undefined' || traceId === null) {
      this._traceId = spanId;
    } else {
      this._traceId = traceId;
    }

    this._parentId = parentId;
    this._spanId = spanId;
    this._sampled = debug ? T : sampled;
    this._debug = debug;
    this._shared = shared;
  }

  _createClass(TraceId, [{
    key: "isDebug",
    value: function isDebug() {
      return this._debug;
    }
  }, {
    key: "isShared",
    value: function isShared() {
      return this._shared;
    }
  }, {
    key: "toString",
    value: function toString() {
      return "TraceId(spanId=".concat(this.spanId.toString()) + ", parentSpanId=".concat(this.parentSpanId.toString()) + ", traceId=".concat(this.traceId.toString(), ")");
    }
  }, {
    key: "traceId",
    get: function get() {
      return this._traceId;
    }
  }, {
    key: "parentSpanId",
    get: function get() {
      return this._parentId;
    }
    /**
     * Please use parentSpanId instead as this can return confusing results (the span ID when absent).
     *
     * @deprecated since version v0.19
     */

  }, {
    key: "parentId",
    get: function get() {
      return this._parentId.getOrElse(this._spanId);
    }
  }, {
    key: "spanId",
    get: function get() {
      return this._spanId;
    }
  }, {
    key: "sampled",
    get: function get() {
      return this._sampled;
    }
    /**
     * Please use isDebug instead.
     *
     * @deprecated since version v0.19
     */

  }, {
    key: "flags",
    get: function get() {
      return this._debug ? 1 : 0;
    }
  }]);

  return TraceId;
}();

var TraceId_1 = TraceId;

// Copyright 2020 The OpenZipkin Authors; licensed to You under the Apache License, Version 2.0.
// === Generate a random 64-bit number in fixed-length hex format
function randomTraceId() {
  var digits = '0123456789abcdef';
  var n = '';

  for (var i = 0; i < 16; i += 1) {
    var rand = Math.floor(Math.random() * 16);
    n += digits[rand];
  }

  return n;
}

var randomTraceId_1 = randomTraceId;

// Copyright 2020 The OpenZipkin Authors; licensed to You under the Apache License, Version 2.0.
var hrTimeSupport = typeof process !== 'undefined' && process.hrtime; // since hrtime isn't available, we can ignore the input parameters

function nowLegacy() {
  return Date.now() * 1000;
}

function nowHrTime(startTimestamp, startTick) {
  if (startTimestamp && startTick) {
    var _hrtime = process.hrtime(startTick);

    var elapsedMicros = Math.floor(_hrtime[0] * 1000000 + _hrtime[1] / 1000);
    return startTimestamp + elapsedMicros;
  } else {
    return Date.now() * 1000;
  }
} // Returns the current time in epoch microseconds
// if startTimestamp and startTick are present, process.hrtime is used
// See https://nodejs.org/api/process.html#process_process_hrtime_time


var now = hrTimeSupport ? nowHrTime : nowLegacy;
var hrtime = hrTimeSupport ? function () {
  return process.hrtime();
} : function () {
  return undefined;
};
var time = {
  now: now,
  hrtime: hrtime
};

// Copyright 2020 The OpenZipkin Authors; licensed to You under the Apache License, Version 2.0.
function Endpoint(_ref) {
  var serviceName = _ref.serviceName,
      ipv4 = _ref.ipv4,
      port = _ref.port;
  this.setServiceName(serviceName);
  this.setIpv4(ipv4);
  this.setPort(port);
}

Endpoint.prototype.setServiceName = function setServiceName(serviceName) {
  // In zipkin, names are lowercase. This eagerly converts to alert users early.
  this.serviceName = serviceName ? serviceName.toLocaleLowerCase() : undefined;
};

Endpoint.prototype.setIpv4 = function setIpv4(ipv4) {
  this.ipv4 = ipv4;
};

Endpoint.prototype.setPort = function setPort(port) {
  this.port = port || undefined;
};

Endpoint.prototype.isEmpty = function isEmpty() {
  return this.serviceName === undefined && this.ipv4 === undefined && this.port === undefined;
};

function Annotation(timestamp, value) {
  this.timestamp = timestamp;
  this.value = value.toString();
}

Annotation.prototype.toString = function toString() {
  return "Annotation(value=\"".concat(this.value, "\")");
};

function Span(traceId) {
  var _this = this;

  this.traceId = traceId.traceId;
  traceId.parentSpanId.ifPresent(function (id) {
    _this.parentId = id;
  });
  this.id = traceId.spanId;
  this.name = undefined; // no default

  this.kind = undefined; // no default

  this.timestamp = undefined;
  this.duration = undefined;
  this.localEndpoint = undefined; // no default

  this.remoteEndpoint = undefined; // no default

  this.annotations = [];
  this.tags = {};
  this.debug = traceId.isDebug();
  this.shared = traceId.isShared();
}

Span.prototype.setName = function setName(name) {
  // In zipkin, names are lowercase. This eagerly converts to alert users early.
  this.name = name ? name.toLocaleLowerCase() : undefined;
};

Span.prototype.setKind = function setKind(kind) {
  this.kind = kind;
};

Span.prototype.setTimestamp = function setTimestamp(timestamp) {
  this.timestamp = timestamp;
};

Span.prototype.setDuration = function setDuration(duration) {
  // Due to rounding errors, a fraction ends up as zero, so check undefined
  if (typeof duration !== 'undefined') {
    this.duration = Math.max(duration, 1);
  }
};

Span.prototype.setLocalEndpoint = function setLocalEndpoint(ep) {
  if (ep && !ep.isEmpty()) {
    this.localEndpoint = ep;
  } else {
    this.localEndpoint = undefined;
  }
};

Span.prototype.setRemoteEndpoint = function setRemoteEndpoint(ep) {
  if (ep && !ep.isEmpty()) {
    this.remoteEndpoint = ep;
  } else {
    this.remoteEndpoint = undefined;
  }
};

Span.prototype.addAnnotation = function addAnnotation(timestamp, value) {
  this.annotations.push(new Annotation(timestamp, value));
};

Span.prototype.putTag = function putTag(key, value) {
  this.tags[key] = value.toString();
};

Span.prototype.setDebug = function setDebug(debug) {
  this.debug = debug;
};

Span.prototype.setShared = function setShared(shared) {
  this.shared = shared;
};

Span.prototype.toString = function toString() {
  var annotations = this.annotations.map(function (a) {
    return a.toString();
  }).join(', ');
  return "Span(id=".concat(this.traceId, ", annotations=[").concat(annotations, "])");
};

var Endpoint_1 = Endpoint;
var Span_1 = Span;
var model = {
  Endpoint: Endpoint_1,
  Span: Span_1
};

var None$2 = option.None,
    Some$3 = option.Some;
var Sampler$1 = sampler.Sampler,
    alwaysSample$1 = sampler.alwaysSample;
var now$1 = time.now,
    hrtime$1 = time.hrtime;
var Endpoint$1 = model.Endpoint;

function requiredArg(name) {
  throw new Error("Tracer: Missing required argument ".concat(name, "."));
}

function isUndefinedOrNull(obj) {
  return typeof obj === 'undefined' || obj === null;
}

var Tracer = /*#__PURE__*/function () {
  function Tracer(_ref) {
    var _ref$ctxImpl = _ref.ctxImpl,
        ctxImpl = _ref$ctxImpl === void 0 ? requiredArg('ctxImpl') : _ref$ctxImpl,
        _ref$recorder = _ref.recorder,
        recorder = _ref$recorder === void 0 ? requiredArg('recorder') : _ref$recorder,
        _ref$sampler = _ref.sampler,
        sampler$$1 = _ref$sampler === void 0 ? new Sampler$1(alwaysSample$1) : _ref$sampler,
        _ref$traceId128Bit = _ref.traceId128Bit,
        traceId128Bit = _ref$traceId128Bit === void 0 ? false : _ref$traceId128Bit,
        _ref$supportsJoin = _ref.supportsJoin,
        supportsJoin = _ref$supportsJoin === void 0 ? true : _ref$supportsJoin,
        localServiceName = _ref.localServiceName,
        localEndpoint = _ref.localEndpoint,
        _ref$log = _ref.log,
        log = _ref$log === void 0 ? console : _ref$log,
        defaultTags = _ref.defaultTags;

    _classCallCheck(this, Tracer);

    this.log = log;
    this.recorder = recorder;
    this.sampler = sampler$$1;
    this.traceId128Bit = traceId128Bit;
    this.supportsJoin = supportsJoin;

    if (localEndpoint) {
      this._localEndpoint = localEndpoint;
    } else {
      this._localEndpoint = new Endpoint$1({
        serviceName: localServiceName || 'unknown'
      });
    }

    this._ctxImpl = ctxImpl; // The sentinel is used until there's a trace ID in scope.
    // Technically, this ID should have been unsampled, but it can break code to change that now.

    this._sentinelTraceId = this.createRootId();
    this._startTimestamp = now$1();
    this._startTick = hrtime$1(); // only set defaultTags in recorders which know about it

    if (this.recorder.setDefaultTags) {
      this.recorder.setDefaultTags(defaultTags);
    }
  }

  _createClass(Tracer, [{
    key: "scoped",
    value: function scoped(callback) {
      return this._ctxImpl.scoped(callback);
    }
  }, {
    key: "letId",
    value: function letId(id, callback) {
      return this._ctxImpl.letContext(id, callback);
    }
  }, {
    key: "createRootId",
    value: function createRootId() {
      var isSampled = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : None$2;
      var isDebug = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var rootSpanId = randomTraceId_1();
      var traceId = this.traceId128Bit ? randomTraceId_1() + rootSpanId : rootSpanId;
      var id = new TraceId_1({
        traceId: traceId,
        parentId: None$2,
        spanId: rootSpanId,
        sampled: isSampled,
        flags: isDebug ? 1 : 0
      });

      if (isSampled === None$2) {
        id._sampled = this.sampler.shouldSample(id);
      }

      return id;
    }
  }, {
    key: "createChildId",
    value: function createChildId(parentId) {
      if (isUndefinedOrNull(parentId)) {
        /* eslint-disable no-param-reassign */
        parentId = this._ctxImpl.getContext();
      }

      if (parentId === this._sentinelTraceId || isUndefinedOrNull(parentId)) {
        return this.createRootId();
      }

      var childId = new TraceId_1({
        traceId: parentId.traceId,
        parentId: new Some$3(parentId.spanId),
        spanId: randomTraceId_1(),
        debug: parentId.isDebug(),
        sampled: parentId.sampled
      });

      if (childId.sampled.present === false) {
        childId._sampled = this.sampler.shouldSample(childId);
      }

      return childId;
    } // this allows you to avoid use of implicit trace ID and defer implicit timestamp derivation

  }, {
    key: "_explicitRecord",
    value: function _explicitRecord(traceId, annotation) {
      var timestamp = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : now$1(this._startTimestamp, this._startTick);
      this.recorder.record(new record({
        traceId: traceId,
        timestamp: timestamp,
        annotation: annotation
      }));
    } // creates a span, timing the given callable, adding any error as a tag
    // if the callable returns a promise, a span stops after the promise resolves

  }, {
    key: "local",
    value: function local(operationName, callable) {
      var _this = this;

      if (typeof callable !== 'function') {
        throw new Error('you must pass a function');
      }

      return this.scoped(function () {
        var traceId = _this.createChildId();

        _this.setId(traceId);

        _this.recordServiceName(_this._localEndpoint.serviceName);

        _this.recordAnnotation(new annotation_1.LocalOperationStart(operationName));

        var result;

        try {
          result = callable();
        } catch (err) {
          _this.recordBinary('error', err.message ? err.message : err.toString());

          _this.recordAnnotation(new annotation_1.LocalOperationStop());

          throw err;
        } // Finish the span on a synchronous success


        if (!isPromise_1(result)) {
          _this.recordAnnotation(new annotation_1.LocalOperationStop());

          return result;
        }

        if (!traceId.sampled.getOrElse(false)) {
          return result; // no need to stop as it was never started
        } // At this point we know we are sampled. Explicitly record against the ID
        // Ensure the span representing the promise completes


        return result.then(function (output) {
          _this._explicitRecord(traceId, new annotation_1.LocalOperationStop());

          return output;
        })["catch"](function (err) {
          var message = err.message ? err.message : err.toString();

          _this._explicitRecord(traceId, new annotation_1.BinaryAnnotation('error', message));

          _this._explicitRecord(traceId, new annotation_1.LocalOperationStop());

          throw err;
        });
      });
    }
  }, {
    key: "join",
    value: function join(traceId) {
      if (isUndefinedOrNull(traceId)) {
        throw new Error('traceId is a required arg');
      } // duck type check until we sort out a better way. We don't want to break
      // transpiled usage ex. `traceId instanceof TraceId_1: false` See #422


      if (isUndefinedOrNull(traceId._spanId)) {
        throw new Error('Must be valid TraceId instance');
      }

      if (!this.supportsJoin) {
        return this.createChildId(traceId);
      }

      if (traceId.sampled === None$2) {
        /* eslint-disable no-param-reassign */
        traceId._sampled = this.sampler.shouldSample(traceId);
      } else {
        /* eslint-disable no-param-reassign */
        traceId._shared = true;
      }

      return traceId;
    }
  }, {
    key: "setId",
    value: function setId(traceId) {
      this._ctxImpl.setContext(traceId);
    } // Returns the current trace ID or a sentinel value indicating its absence.

  }, {
    key: "recordAnnotation",
    value: function recordAnnotation(annotation, timestamp) {
      if (this.id.sampled.getOrElse(false)) {
        this._explicitRecord(this.id, annotation, timestamp);
      }
    }
  }, {
    key: "recordMessage",
    value: function recordMessage(message) {
      this.recordAnnotation(new annotation_1.Message(message));
    }
  }, {
    key: "recordServiceName",
    value: function recordServiceName(serviceName) {
      this.recordAnnotation(new annotation_1.ServiceName(serviceName));
    }
  }, {
    key: "recordRpc",
    value: function recordRpc(name) {
      this.recordAnnotation(new annotation_1.Rpc(name));
    }
  }, {
    key: "recordClientAddr",
    value: function recordClientAddr(ia) {
      this.recordAnnotation(new annotation_1.ClientAddr(ia));
    }
  }, {
    key: "recordServerAddr",
    value: function recordServerAddr(ia) {
      this.recordAnnotation(new annotation_1.ServerAddr(ia));
    }
  }, {
    key: "recordLocalAddr",
    value: function recordLocalAddr(ia) {
      this.recordAnnotation(new annotation_1.LocalAddr(ia));
    }
  }, {
    key: "recordBinary",
    value: function recordBinary(key, value) {
      this.recordAnnotation(new annotation_1.BinaryAnnotation(key, value));
    }
  }, {
    key: "writeIdToConsole",
    value: function writeIdToConsole(message) {
      this.log.info("".concat(message, ": ").concat(this.id.toString()));
    }
  }, {
    key: "setTags",
    value: function setTags() {
      var tags = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      // eslint-disable-next-line no-restricted-syntax
      for (var tag in tags) {
        if (Object.prototype.hasOwnProperty.call(tags, tag)) {
          this.recordBinary(tag, tags[tag]);
        }
      }
    }
  }, {
    key: "id",
    get: function get() {
      return this._ctxImpl.getContext() || this._sentinelTraceId;
    }
  }, {
    key: "localEndpoint",
    get: function get() {
      return this._localEndpoint;
    }
  }]);

  return Tracer;
}();

var tracer = Tracer;

// Copyright 2020 The OpenZipkin Authors; licensed to You under the Apache License, Version 2.0.
var explicitContext = /*#__PURE__*/function () {
  function ExplicitContext() {
    _classCallCheck(this, ExplicitContext);

    this.currentCtx = null;
  }

  _createClass(ExplicitContext, [{
    key: "setContext",
    value: function setContext(ctx) {
      this.currentCtx = ctx;
    }
  }, {
    key: "getContext",
    value: function getContext() {
      return this.currentCtx;
    }
  }, {
    key: "scoped",
    value: function scoped(callable) {
      var prevCtx = this.getContext();

      try {
        return callable();
      } finally {
        this.setContext(prevCtx);
      }
    }
  }, {
    key: "letContext",
    value: function letContext(ctx, callable) {
      var _this = this;

      return this.scoped(function () {
        _this.setContext(ctx);

        return callable();
      });
    }
  }]);

  return ExplicitContext;
}();

var noop = function createNoopTracer() {
  var recorder = {
    record: function record() {}
  };
  var ctxImpl = new explicitContext();
  return new tracer({
    recorder: recorder,
    ctxImpl: ctxImpl
  });
};

// Copyright 2020 The OpenZipkin Authors; licensed to You under the Apache License, Version 2.0.
var httpHeaders = {
  TraceId: 'X-B3-TraceId',
  SpanId: 'X-B3-SpanId',
  ParentSpanId: 'X-B3-ParentSpanId',
  Sampled: 'X-B3-Sampled',
  Flags: 'X-B3-Flags'
};

var now$2 = time.now;
var Span$1 = model.Span,
    Endpoint$2 = model.Endpoint;
/**
 * defaultTags property name
 * @type {symbol}
 */

var defaultTagsSymbol = Symbol('defaultTags');

function _timedOut(span) {
  return span.timeoutTimestamp < now$2();
}
/**
 * @class PartialSpan
 */


var PartialSpan = /*#__PURE__*/function () {
  /**
   * @constructor
   * @param {TraceId} traceId
   * @param {number} timeoutTimestamp (epoch in microseconds) after this moment, data
   * should be forcibly flushed
   */
  function PartialSpan(traceId, timeoutTimestamp) {
    _classCallCheck(this, PartialSpan);

    this.traceId = traceId;
    this.timeoutTimestamp = timeoutTimestamp;
    this.delegate = new Span$1(traceId);
    this.localEndpoint = new Endpoint$2({});
    this.shouldFlush = false;
  }
  /**
   * Conditionally records the duration of the span, if it has a timestamp.
   *
   * @param {number} finishTimestamp (epoch in microseconds) to calculate the duration from
   */


  _createClass(PartialSpan, [{
    key: "setDuration",
    value: function setDuration(finishTimestamp) {
      if (this.shouldFlush) {
        return;
      }

      this.shouldFlush = true; // even if we can't derive duration, we should report on finish

      var startTimestamp = this.delegate.timestamp;

      if (typeof startTimestamp === 'undefined') {
        // We can't calculate duration without a start timestamp,
        // but an annotation is better than nothing
        this.delegate.addAnnotation(finishTimestamp, 'finish');
      } else {
        this.delegate.setDuration(finishTimestamp - startTimestamp);
      }
    }
  }]);

  return PartialSpan;
}();
/**
 * default timeout = 60 seconds (in microseconds)
 * @type {number}
 */


var defaultTimeout = 60 * 1000000;
/**
 * @class BatchRecorder
 */

var BatchRecorder = /*#__PURE__*/function () {
  /**
   * @constructor
   * @param {Object} options
   * @param {Logger} options.logger logs the data to zipkin server
   * @param {number} options.timeout timeout after which an unfinished span
   * is flushed to zipkin in **microseconds**. Passing this value has
   * implications in the reported data of the span so we discourage users
   * to pass a value for it unless there is a good reason for.
   */
  function BatchRecorder(_ref) {
    var _this = this;

    var logger = _ref.logger,
        _ref$timeout = _ref.timeout,
        timeout = _ref$timeout === void 0 ? defaultTimeout : _ref$timeout;

    _classCallCheck(this, BatchRecorder);

    this.logger = logger;
    this.timeout = timeout;
    /**
     * @type Map<string, PartialSpan>
     */

    this.partialSpans = new Map();
    this[defaultTagsSymbol] = {}; // read through the partials spans regularly
    // and collect any timed-out ones

    var timer = setInterval(function () {
      _this.partialSpans.forEach(function (span, id) {
        if (_timedOut(span)) {
          // the zipkin-js.flush annotation makes it explicit that
          // the span has been reported because of a timeout, even
          // when it is not finished yet (and thus enqueued for reporting)
          span.delegate.addAnnotation(now$2(), 'zipkin-js.flush');

          _this._writeSpan(id, span);
        }
      });
    }, 1000); // every second, this will flush to zipkin any spans that have timed out

    if (timer.unref) {
      // unref might not be available in browsers
      timer.unref(); // Allows Node to terminate instead of blocking on timer
    }
  }

  _createClass(BatchRecorder, [{
    key: "_addDefaultTagsAndLocalEndpoint",
    value: function _addDefaultTagsAndLocalEndpoint(span) {
      var defaultTags = this[defaultTagsSymbol]; // eslint-disable-next-line no-restricted-syntax

      for (var tag in defaultTags) {
        if (Object.prototype.hasOwnProperty.call(defaultTags, tag)) {
          span.delegate.putTag(tag, defaultTags[tag]);
        }
      }

      span.delegate.setLocalEndpoint(span.localEndpoint);
    }
  }, {
    key: "_writeSpan",
    value: function _writeSpan(id,
    /** @type PartialSpan */
    span) {
      var isNew = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

      // TODO(adriancole) refactor so this responsibility isn't in writeSpan
      if (!isNew && typeof this.partialSpans.get(id) === 'undefined') {
        // Span not found. Could have been expired.
        return;
      } // ready for garbage collection


      this.partialSpans["delete"](id);
      var spanToWrite = span.delegate; // Only add default tags and local endpoint on the first report of a span

      if (span.delegate.timestamp) {
        this._addDefaultTagsAndLocalEndpoint(span);
      }

      this.logger.logSpan(spanToWrite);
    }
  }, {
    key: "_updateSpanMap",
    value: function _updateSpanMap(id, timestamp, updater) {
      var span;
      var isNew = false; // we need to special case late finish annotations

      if (this.partialSpans.has(id)) {
        span = this.partialSpans.get(id);
      } else {
        isNew = true;
        span = new PartialSpan(id, timestamp + this.timeout);
      }

      updater(span);

      if (span.shouldFlush) {
        this._writeSpan(id, span, isNew);
      } else {
        this.partialSpans.set(id, span);
      }
    }
    /**
     * Calling this will flush any pending spans to the transport.
     *
     * Note: the transport itself may be batching, in such case you may need to flush that also.
     */

  }, {
    key: "flush",
    value: function flush() {
      var _this2 = this;

      this.partialSpans.forEach(function (span, id) {
        _this2._writeSpan(id, span);
      });
    }
  }, {
    key: "record",
    value: function record(rec) {
      var id = rec.traceId;

      this._updateSpanMap(id, rec.timestamp, function (
      /** @type PartialSpan */
      span) {
        switch (rec.annotation.annotationType) {
          case 'ClientAddr':
            span.delegate.setKind('SERVER');
            span.delegate.setRemoteEndpoint(new Endpoint$2({
              serviceName: rec.annotation.serviceName,
              ipv4: rec.annotation.host && rec.annotation.host.ipv4(),
              port: rec.annotation.port
            }));
            break;

          case 'ClientSend':
            span.delegate.setKind('CLIENT');
            span.delegate.setTimestamp(rec.timestamp);
            break;

          case 'ClientRecv':
            span.delegate.setKind('CLIENT');
            span.setDuration(rec.timestamp);
            break;

          case 'ServerSend':
            span.delegate.setKind('SERVER');
            span.setDuration(rec.timestamp);
            break;

          case 'ServerRecv':
            span.delegate.setShared(id.isShared());
            span.delegate.setKind('SERVER');
            span.delegate.setTimestamp(rec.timestamp);
            break;

          case 'ProducerStart':
            span.delegate.setKind('PRODUCER');
            span.delegate.setTimestamp(rec.timestamp);
            break;

          case 'ProducerStop':
            span.delegate.setKind('PRODUCER');
            span.setDuration(rec.timestamp);
            break;

          case 'ConsumerStart':
            span.delegate.setKind('CONSUMER');
            span.delegate.setTimestamp(rec.timestamp);
            break;

          case 'ConsumerStop':
            span.delegate.setKind('CONSUMER');
            span.setDuration(rec.timestamp);
            break;

          case 'MessageAddr':
            span.delegate.setRemoteEndpoint(new Endpoint$2({
              serviceName: rec.annotation.serviceName,
              ipv4: rec.annotation.host && rec.annotation.host.ipv4(),
              port: rec.annotation.port
            }));
            break;

          case 'LocalOperationStart':
            span.delegate.setName(rec.annotation.name);
            span.delegate.setTimestamp(rec.timestamp);
            break;

          case 'LocalOperationStop':
            span.setDuration(rec.timestamp);
            break;

          case 'Message':
            span.delegate.addAnnotation(rec.timestamp, rec.annotation.message);
            break;

          case 'Rpc':
            span.delegate.setName(rec.annotation.name);
            break;

          case 'ServiceName':
            span.localEndpoint.setServiceName(rec.annotation.serviceName);
            break;

          case 'BinaryAnnotation':
            span.delegate.putTag(rec.annotation.key, rec.annotation.value);
            break;

          case 'LocalAddr':
            span.localEndpoint.setIpv4(rec.annotation.host && rec.annotation.host.ipv4());
            span.localEndpoint.setPort(rec.annotation.port);
            break;

          case 'ServerAddr':
            span.delegate.setKind('CLIENT');
            span.delegate.setRemoteEndpoint(new Endpoint$2({
              serviceName: rec.annotation.serviceName,
              ipv4: rec.annotation.host && rec.annotation.host.ipv4(),
              port: rec.annotation.port
            }));
            break;

          default:
            break;
        }
      });
    }
  }, {
    key: "setDefaultTags",
    value: function setDefaultTags(tags) {
      this[defaultTagsSymbol] = tags;
    }
  }, {
    key: "toString",
    value: function toString() {
      // eslint-disable-line class-methods-use-this
      return 'BatchRecorder()';
    }
  }]);

  return BatchRecorder;
}();

var batchRecorder = BatchRecorder;

// Copyright 2020 The OpenZipkin Authors; licensed to You under the Apache License, Version 2.0.
var ConsoleRecorder = /*#__PURE__*/function () {
  /* eslint-disable no-console */
  function ConsoleRecorder() {
    var logger = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : console.log;

    _classCallCheck(this, ConsoleRecorder);

    this.logger = logger;
  }

  _createClass(ConsoleRecorder, [{
    key: "record",
    value: function record(rec) {
      var _rec$traceId = rec.traceId,
          spanId = _rec$traceId.spanId,
          parentId = _rec$traceId.parentId,
          traceId = _rec$traceId.traceId;
      this.logger("Record at (timestamp=".concat(rec.timestamp, ", spanId=").concat(spanId, ", parentId=").concat(parentId, ", ") + "traceId=".concat(traceId, "): ").concat(rec.annotation.toString()));
    }
  }, {
    key: "toString",
    value: function toString() {
      // eslint-disable-line class-methods-use-this
      return 'consoleTracer';
    }
  }]);

  return ConsoleRecorder;
}();

var consoleRecorder = ConsoleRecorder;

function parseRequestUrl(requestUrl) {
  var parsed = url.parse(requestUrl);
  return {
    host: parsed.hostname,
    path: parsed.pathname
  };
}

var parseUrl = parseRequestUrl;

var Some$4 = option.Some,
    None$3 = option.None;

function stringToBoolean(str) {
  return str === '1' || str === 'true';
}

function stringToIntOption(str) {
  try {
    return new Some$4(parseInt(str));
  } catch (err) {
    return None$3;
  }
}

function containsRequiredHeaders(readHeader) {
  return readHeader(httpHeaders.TraceId) !== None$3 && readHeader(httpHeaders.SpanId) !== None$3;
}

function requiredArg$1(name) {
  throw new Error("HttpServerInstrumentation: Missing required argument ".concat(name, "."));
}

var HttpServerInstrumentation = /*#__PURE__*/function () {
  function HttpServerInstrumentation(_ref) {
    var _ref$tracer = _ref.tracer,
        tracer = _ref$tracer === void 0 ? requiredArg$1('tracer') : _ref$tracer,
        _ref$serviceName = _ref.serviceName,
        serviceName = _ref$serviceName === void 0 ? tracer.localEndpoint.serviceName : _ref$serviceName,
        host = _ref.host,
        _ref$port = _ref.port,
        port = _ref$port === void 0 ? requiredArg$1('port') : _ref$port;

    _classCallCheck(this, HttpServerInstrumentation);

    this.tracer = tracer;
    this.serviceName = serviceName;
    this.host = host && new InetAddress_1(host);
    this.port = port;
  }

  _createClass(HttpServerInstrumentation, [{
    key: "_createIdFromHeaders",
    value: function _createIdFromHeaders(readHeader) {
      if (containsRequiredHeaders(readHeader)) {
        var spanId = readHeader(httpHeaders.SpanId);
        var parentId = spanId.map(function (sid) {
          var traceId = readHeader(httpHeaders.TraceId);
          var parentSpanId = readHeader(httpHeaders.ParentSpanId);
          var sampled = readHeader(httpHeaders.Sampled);
          var flags = readHeader(httpHeaders.Flags).flatMap(stringToIntOption).getOrElse(0);
          return new TraceId_1({
            traceId: traceId.getOrElse(),
            parentId: parentSpanId,
            spanId: sid,
            debug: flags === 1,
            sampled: sampled.map(stringToBoolean)
          });
        });
        return new Some$4(this.tracer.join(parentId.getOrElse()));
      } else if (readHeader(httpHeaders.Flags) !== None$3 || readHeader(httpHeaders.Sampled) !== None$3) {
        var sampled = readHeader(httpHeaders.Sampled) === None$3 ? None$3 : readHeader(httpHeaders.Sampled).map(stringToBoolean);
        var flags = readHeader(httpHeaders.Flags).flatMap(stringToIntOption).getOrElse(0);
        return new Some$4(this.tracer.createRootId(sampled, flags === 1));
      } else {
        return new Some$4(this.tracer.createRootId());
      }
    }
  }, {
    key: "spanNameFromRoute",
    value: function spanNameFromRoute(method, route, code) {
      // eslint-disable-line class-methods-use-this
      if (code > 299 && code < 400) return "".concat(method, " redirected");
      if (code === 404) return "".concat(method, " not_found");
      if (!route || route === '') return method;
      return "".concat(method, " ").concat(route);
    }
  }, {
    key: "recordRequest",
    value: function recordRequest(method, requestUrl, readHeader) {
      var _this = this;

      this._createIdFromHeaders(readHeader).ifPresent(function (id) {
        return _this.tracer.setId(id);
      });

      var id = this.tracer.id;

      var _parseRequestUrl = parseUrl(requestUrl),
          path = _parseRequestUrl.path;

      this.tracer.recordServiceName(this.serviceName);
      this.tracer.recordRpc(method.toUpperCase());
      this.tracer.recordBinary('http.path', path);
      this.tracer.recordAnnotation(new annotation_1.ServerRecv());
      this.tracer.recordAnnotation(new annotation_1.LocalAddr({
        host: this.host,
        port: this.port
      }));
      return id;
    }
  }, {
    key: "recordResponse",
    value: function recordResponse(id, statusCode, error) {
      this.tracer.setId(id);
      this.tracer.recordBinary('http.status_code', statusCode.toString());

      if (error) {
        this.tracer.recordBinary('error', error.toString());
      } else if (statusCode < 200 || statusCode > 399) {
        this.tracer.recordBinary('error', statusCode.toString());
      }

      this.tracer.recordAnnotation(new annotation_1.ServerSend());
    }
  }]);

  return HttpServerInstrumentation;
}();

var httpServer = HttpServerInstrumentation;

function appendZipkinHeaders(req, traceId) {
  var headers = req.headers || {};
  headers[httpHeaders.TraceId] = traceId.traceId;
  headers[httpHeaders.SpanId] = traceId.spanId;
  traceId.parentSpanId.ifPresent(function (psid) {
    headers[httpHeaders.ParentSpanId] = psid;
  });
  traceId.sampled.ifPresent(function (sampled) {
    headers[httpHeaders.Sampled] = sampled ? '1' : '0';
  });

  if (traceId.isDebug()) {
    headers[httpHeaders.Flags] = '1';
  }

  return headers;
}

function addZipkinHeaders(req, traceId) {
  var headers = appendZipkinHeaders(req, traceId);
  return Object.assign({}, req, {
    headers: headers
  });
}

var request = {
  addZipkinHeaders: addZipkinHeaders
};

function requiredArg$2(name) {
  throw new Error("HttpClientInstrumentation: Missing required argument ".concat(name, "."));
}

var HttpClientInstrumentation = /*#__PURE__*/function () {
  function HttpClientInstrumentation(_ref) {
    var _ref$tracer = _ref.tracer,
        tracer = _ref$tracer === void 0 ? requiredArg$2('tracer') : _ref$tracer,
        _ref$serviceName = _ref.serviceName,
        serviceName = _ref$serviceName === void 0 ? tracer.localEndpoint.serviceName : _ref$serviceName,
        remoteServiceName = _ref.remoteServiceName;

    _classCallCheck(this, HttpClientInstrumentation);

    this.tracer = tracer;
    this.serviceName = serviceName;
    this.remoteServiceName = remoteServiceName;
  }

  _createClass(HttpClientInstrumentation, [{
    key: "recordRequest",
    value: function recordRequest(request$$1, url$$1, method) {
      this.tracer.setId(this.tracer.createChildId());
      var traceId = this.tracer.id;

      var _parseRequestUrl = parseUrl(url$$1),
          path = _parseRequestUrl.path;

      this.tracer.recordServiceName(this.serviceName);
      this.tracer.recordRpc(method.toUpperCase());
      this.tracer.recordBinary('http.path', path);
      this.tracer.recordAnnotation(new annotation_1.ClientSend());

      if (this.remoteServiceName) {
        // TODO: can we get the host and port of the http connection?
        this.tracer.recordAnnotation(new annotation_1.ServerAddr({
          serviceName: this.remoteServiceName
        }));
      }

      return request.addZipkinHeaders(request$$1, traceId);
    }
  }, {
    key: "recordResponse",
    value: function recordResponse(traceId, statusCode) {
      this.tracer.setId(traceId);
      this.tracer.recordBinary('http.status_code', statusCode.toString());

      if (statusCode < 200 || statusCode > 399) {
        this.tracer.recordBinary('error', statusCode.toString());
      }

      this.tracer.recordAnnotation(new annotation_1.ClientRecv());
    }
  }, {
    key: "recordError",
    value: function recordError(traceId, error) {
      this.tracer.setId(traceId);
      this.tracer.recordBinary('error', error.toString());
      this.tracer.recordAnnotation(new annotation_1.ClientRecv());
    }
  }]);

  return HttpClientInstrumentation;
}();

var httpClient = HttpClientInstrumentation;

var instrumentation = {
  HttpServer: httpServer,
  HttpClient: httpClient
};

// Copyright 2020 The OpenZipkin Authors; licensed to You under the Apache License, Version 2.0.
function toV1Endpoint(endpoint) {
  if (endpoint === undefined) {
    return undefined;
  }

  var res = {
    serviceName: endpoint.serviceName || '' // undefined is not allowed in v1

  };

  if (endpoint.ipv4) {
    res.ipv4 = endpoint.ipv4;
  }

  if (endpoint.port) {
    res.port = endpoint.port;
  }

  return res;
}

function toV1Annotation(ann, endpoint) {
  return {
    value: ann.value,
    timestamp: ann.timestamp,
    endpoint: endpoint
  };
}

function encodeV1(span) {
  var res = {
    traceId: span.traceId
  };

  if (span.parentId) {
    // instead of writing "parentId": NULL
    res.parentId = span.parentId;
  }

  res.id = span.id;
  res.name = span.name || ''; // undefined is not allowed in v1
  // Log timestamp and duration if this tracer started and completed this span.

  if (!span.shared) {
    res.timestamp = span.timestamp;
    res.duration = span.duration;
  }

  var jsonEndpoint = toV1Endpoint(span.localEndpoint);
  var beginAnnotation;
  var endAnnotation;
  var addressKey;

  switch (span.kind) {
    case 'CLIENT':
      beginAnnotation = span.timestamp ? 'cs' : undefined;
      endAnnotation = 'cr';
      addressKey = 'sa';
      break;

    case 'SERVER':
      beginAnnotation = span.timestamp ? 'sr' : undefined;
      endAnnotation = 'ss';
      addressKey = 'ca';
      break;

    case 'PRODUCER':
      beginAnnotation = span.timestamp ? 'ms' : undefined;
      endAnnotation = 'ws';
      addressKey = 'ma';
      break;

    case 'CONSUMER':
      if (span.timestamp && span.duration) {
        beginAnnotation = 'wr';
        endAnnotation = 'mr';
      } else if (span.timestamp) {
        beginAnnotation = 'mr';
      }

      addressKey = 'ma';
      break;

    default:
  }

  if (span.annotations.length > 0 || beginAnnotation) {
    // don't write empty array
    res.annotations = span.annotations.map(function (ann) {
      return toV1Annotation(ann, jsonEndpoint);
    });
  }

  if (beginAnnotation) {
    res.annotations.push({
      value: beginAnnotation,
      timestamp: span.timestamp,
      endpoint: jsonEndpoint
    });

    if (span.duration) {
      res.annotations.push({
        value: endAnnotation,
        timestamp: span.timestamp + span.duration,
        endpoint: jsonEndpoint
      });
    }
  }

  var keys = Object.keys(span.tags);

  if (keys.length > 0 || span.remoteEndpoint) {
    // don't write empty array
    res.binaryAnnotations = keys.map(function (key) {
      return {
        key: key,
        value: span.tags[key],
        endpoint: jsonEndpoint
      };
    });
  }

  if (span.remoteEndpoint) {
    var address = {
      key: addressKey,
      value: true,
      endpoint: toV1Endpoint(span.remoteEndpoint)
    };
    res.binaryAnnotations.push(address);
  }

  if (span.debug) {
    // instead of writing "debug": false
    res.debug = true;
  }

  return JSON.stringify(res);
}

function encodeV2(span) {
  var copy = {
    traceId: span.traceId
  };

  if (span.parentId) {
    copy.parentId = span.parentId;
  }

  copy.id = span.id;

  if (span.name) {
    copy.name = span.name;
  }

  if (span.kind) {
    copy.kind = span.kind;
  }

  if (span.timestamp) {
    copy.timestamp = span.timestamp;
  }

  if (span.duration) {
    copy.duration = span.duration;
  }

  if (span.localEndpoint) {
    copy.localEndpoint = span.localEndpoint;
  }

  if (span.remoteEndpoint) {
    copy.remoteEndpoint = span.remoteEndpoint;
  }

  if (span.annotations.length > 0) {
    copy.annotations = span.annotations;
  }

  if (Object.keys(span.tags).length > 0) {
    copy.tags = span.tags;
  }

  if (span.debug) {
    copy.debug = true;
  }

  if (span.shared) {
    copy.shared = true;
  }

  return JSON.stringify(copy);
}

var JSON_V1 = {
  encode: function encode(span) {
    return encodeV1(span);
  }
};
var JSON_V2 = {
  encode: function encode(span) {
    return encodeV2(span);
  }
};
var jsonEncoder = {
  JSON_V1: JSON_V1,
  JSON_V2: JSON_V2
};

// Copyright 2020 The OpenZipkin Authors; licensed to You under the Apache License, Version 2.0.

exports.option = option;
exports.Annotation = annotation_1;
exports.Tracer = tracer;
exports.createNoopTracer = noop;
exports.randomTraceId = randomTraceId_1;
exports.sampler = sampler;
exports.TraceId = TraceId_1;
exports.HttpHeaders = httpHeaders;
exports.InetAddress = InetAddress_1;
exports.BatchRecorder = batchRecorder;
exports.ConsoleRecorder = consoleRecorder;
exports.ExplicitContext = explicitContext;
exports.Instrumentation = instrumentation;
exports.Request = request;
exports.jsonEncoder = jsonEncoder;
exports.model = model;
exports.parseRequestUrl = parseUrl;
