"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("../../tsr-declarations");
var lib_1 = require("ts-runtime/lib");
// Copyright 2020 The OpenZipkin Authors; licensed to You under the Apache License, Version 2.0.
var chai_1 = require("chai");
var zipkin_1 = require("zipkin");
describe('TraceId', function () {
    it('should have correct type', function () {
        var traceId = lib_1.default.nullable(lib_1.default.ref("zipkin.TraceId.1398652972")).assert(new zipkin_1.TraceId({
            traceId: '1',
            parentId: new zipkin_1.option.Some('1'),
            spanId: '2'
        }));
        chai_1.expect(traceId.isShared()).to.equal(false);
        var sampled = lib_1.default.nullable(lib_1.default.ref("zipkin.option.IOption.1398652972", lib_1.default.nullable(lib_1.default.boolean()))).assert(traceId.sampled);
        chai_1.expect(sampled.map).to.be.a('function');
        chai_1.expect(sampled).to.equal(zipkin_1.option.None);
        var parentId = lib_1.default.nullable(lib_1.default.ref("zipkin.option.IOption.1398652972", lib_1.default.nullable(lib_1.default.string()))).assert(traceId.parentSpanId);
        chai_1.expect(parentId.map).to.be.a('function');
    });
});
