"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("../../tsr-declarations");
var lib_1 = require("ts-runtime/lib");
// Copyright 2020 The OpenZipkin Authors; licensed to You under the Apache License, Version 2.0.
var chai_1 = require("chai");
var zipkin_1 = require("zipkin");
describe('Annotation types', function () {
    describe('[ClientSend, ClientRecv, ServerSend, ServerRecv, ProducerStart, ProducerStop, ConsumerStart, ConsumerStop, LocalOperationStop]', function () {
        it('should return correct type', function () {
            var clientSend = lib_1.default.nullable(lib_1.default.ref("zipkin.Annotation.ClientSend.1398652972")).assert(new zipkin_1.Annotation.ClientSend());
            var clientRecv = lib_1.default.nullable(lib_1.default.ref("zipkin.Annotation.ClientRecv.1398652972")).assert(new zipkin_1.Annotation.ClientRecv());
            var serverSend = lib_1.default.nullable(lib_1.default.ref("zipkin.Annotation.ServerSend.1398652972")).assert(new zipkin_1.Annotation.ServerSend());
            var serverRecv = lib_1.default.nullable(lib_1.default.ref("zipkin.Annotation.ServerRecv.1398652972")).assert(new zipkin_1.Annotation.ServerRecv());
            var ProducerStart = lib_1.default.nullable(lib_1.default.ref("zipkin.Annotation.ProducerStart.1398652972")).assert(new zipkin_1.Annotation.ProducerStart());
            var ProducerStop = lib_1.default.nullable(lib_1.default.ref("zipkin.Annotation.ProducerStop.1398652972")).assert(new zipkin_1.Annotation.ProducerStop());
            var ConsumerStart = lib_1.default.nullable(lib_1.default.ref("zipkin.Annotation.ConsumerStart.1398652972")).assert(new zipkin_1.Annotation.ConsumerStart());
            var ConsumerStop = lib_1.default.nullable(lib_1.default.ref("zipkin.Annotation.ConsumerStop.1398652972")).assert(new zipkin_1.Annotation.ConsumerStop());
            var localOperationStop = lib_1.default.nullable(lib_1.default.ref("zipkin.Annotation.LocalOperationStop.1398652972")).assert(new zipkin_1.Annotation.LocalOperationStop());
            chai_1.expect(clientSend).to.have.property('annotationType');
            chai_1.expect(clientRecv).to.have.property('annotationType');
            chai_1.expect(serverSend).to.have.property('annotationType');
            chai_1.expect(serverRecv).to.have.property('annotationType');
            chai_1.expect(ProducerStart).to.have.property('annotationType');
            chai_1.expect(ProducerStop).to.have.property('annotationType');
            chai_1.expect(ConsumerStart).to.have.property('annotationType');
            chai_1.expect(ConsumerStop).to.have.property('annotationType');
            chai_1.expect(localOperationStop).to.have.property('annotationType');
        });
    });
    describe('[LocalOperationStart, Message, ServiceName, Rpc]', function () {
        it('should return correct type', function () {
            var localOperationStart = lib_1.default.nullable(lib_1.default.ref("zipkin.Annotation.LocalOperationStart.1398652972")).assert(new zipkin_1.Annotation.LocalOperationStart('name'));
            var message = lib_1.default.nullable(lib_1.default.ref("zipkin.Annotation.Message.1398652972")).assert(new zipkin_1.Annotation.Message('name'));
            var serviceName = lib_1.default.nullable(lib_1.default.ref("zipkin.Annotation.ServiceName.1398652972")).assert(new zipkin_1.Annotation.ServiceName('name'));
            var rpc = lib_1.default.nullable(lib_1.default.ref("zipkin.Annotation.Rpc.1398652972")).assert(new zipkin_1.Annotation.Rpc('name'));
            chai_1.expect(localOperationStart).to.have.property('name');
            chai_1.expect(message).to.have.property('message');
            chai_1.expect(serviceName).to.have.property('serviceName');
            chai_1.expect(rpc).to.have.property('name');
        });
    });
    describe('[ClientAddr, ServerAddr, MessageAddr, LocalAddr]', function () {
        it('should return correct type', function () {
            var clientAddr = lib_1.default.nullable(lib_1.default.ref("zipkin.Annotation.ClientAddr.1398652972")).assert(new zipkin_1.Annotation.ClientAddr({
                host: zipkin_1.InetAddress.getLocalAddress(),
                port: 8000
            }));
            var serverAddr = lib_1.default.nullable(lib_1.default.ref("zipkin.Annotation.ServerAddr.1398652972")).assert(new zipkin_1.Annotation.ServerAddr({
                serviceName: 'name',
                host: zipkin_1.InetAddress.getLocalAddress(),
                port: 8000
            }));
            var MessageAddr = lib_1.default.nullable(lib_1.default.ref("zipkin.Annotation.MessageAddr.1398652972")).assert(new zipkin_1.Annotation.MessageAddr({
                serviceName: 'name',
                host: zipkin_1.InetAddress.getLocalAddress(),
                port: 8000
            }));
            var localAddr = lib_1.default.nullable(lib_1.default.ref("zipkin.Annotation.LocalAddr.1398652972")).assert(new zipkin_1.Annotation.LocalAddr({
                host: zipkin_1.InetAddress.getLocalAddress(),
                port: 8000
            }));
            chai_1.expect(clientAddr).to.have.property('annotationType');
            chai_1.expect(serverAddr).to.have.property('serviceName');
            chai_1.expect(MessageAddr).to.have.property('serviceName');
            chai_1.expect(localAddr).to.have.property('host');
        });
    });
    describe('BinaryAnnotation', function () {
        it('should return correct type', function () {
            var binaryAnnotation = lib_1.default.nullable(lib_1.default.ref("zipkin.Annotation.BinaryAnnotation.1398652972")).assert(new zipkin_1.Annotation.BinaryAnnotation('binary-annotation', 'some-value'));
            chai_1.expect(binaryAnnotation.value).to.equal('some-value');
        });
    });
});
