"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("../../tsr-declarations");
var lib_1 = require("ts-runtime/lib");
// Copyright 2020 The OpenZipkin Authors; licensed to You under the Apache License, Version 2.0.
var chai_1 = require("chai");
var zipkin_1 = require("zipkin");
describe('Instrumentation', function () {
    describe('HttpClient', function () {
        it('should have correct type', function () {
            var instrumentation = lib_1.default.nullable(lib_1.default.ref("zipkin.Instrumentation.HttpClient.1398652972")).assert(new zipkin_1.Instrumentation.HttpClient({
                tracer: new zipkin_1.Tracer({
                    ctxImpl: new zipkin_1.ExplicitContext(),
                    recorder: new zipkin_1.ConsoleRecorder()
                }),
                serviceName: 'weather-app',
                remoteServiceName: 'weather-forecast-service'
            }));
            chai_1.expect(instrumentation.recordRequest).to.be.a('function');
        });
    });
    describe('HttpServer', function () {
        it('should have correct type', function () {
            var instrumentation = lib_1.default.nullable(lib_1.default.ref("zipkin.Instrumentation.HttpServer.1398652972")).assert(new zipkin_1.Instrumentation.HttpServer({
                tracer: new zipkin_1.Tracer({
                    ctxImpl: new zipkin_1.ExplicitContext(),
                    recorder: new zipkin_1.ConsoleRecorder()
                }),
                port: 8000
            }));
            chai_1.expect(instrumentation.recordRequest).to.be.a('function');
        });
    });
});
