"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("../../tsr-declarations");
var lib_1 = require("ts-runtime/lib");
// Copyright 2020 The OpenZipkin Authors; licensed to You under the Apache License, Version 2.0.
var chai_1 = require("chai");
var zipkin_1 = require("zipkin");
describe('JsonEncoder', function () {
    it('should have correct type', function () {
        var v1 = lib_1.default.nullable(lib_1.default.ref("zipkin.JsonEncoder.1398652972")).assert(zipkin_1.jsonEncoder.JSON_V1);
        var v2 = lib_1.default.nullable(lib_1.default.ref("zipkin.JsonEncoder.1398652972")).assert(zipkin_1.jsonEncoder.JSON_V2);
        var span = lib_1.default.nullable(lib_1.default.ref("zipkin.model.Span.1398652972")).assert(new zipkin_1.model.Span(new zipkin_1.TraceId({ spanId: 'xyz' })));
        chai_1.expect(v1.encode(span)).to.be.a('string');
        chai_1.expect(v2.encode(span)).to.be.a('string');
    });
});
