"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("../../tsr-declarations");
var lib_1 = require("ts-runtime/lib");
// Copyright 2020 The OpenZipkin Authors; licensed to You under the Apache License, Version 2.0.
var chai_1 = require("chai");
var zipkin_1 = require("zipkin");
describe('Model', function () {
    describe('Endpoint', function () {
        it('should have correct type', function () {
            var endpoint = lib_1.default.nullable(lib_1.default.ref("zipkin.model.Endpoint.1398652972")).assert(new zipkin_1.model.Endpoint({
                serviceName: 'Unknown',
                ipv4: '10.0.0.1',
                port: 8000
            }));
            chai_1.expect(endpoint.setIpv4).to.be.a('function');
        });
    });
    describe('Span', function () {
        it('should have correct type', function () {
            var span = lib_1.default.nullable(lib_1.default.ref("zipkin.model.Span.1398652972")).assert(new zipkin_1.model.Span(new zipkin_1.TraceId({
                traceId: 'a',
                spanId: 'b'
            })));
            chai_1.expect(span.traceId).to.be.a('string');
        });
    });
});
