"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("../../tsr-declarations");
var lib_1 = require("ts-runtime/lib");
// Copyright 2020 The OpenZipkin Authors; licensed to You under the Apache License, Version 2.0.
var chai_1 = require("chai");
var zipkin_1 = require("zipkin");
var Some = zipkin_1.option.Some;
var None = zipkin_1.option.None;
describe('Option', function () {
    describe('None', function () {
        it('should have expected interface', function () {
            // Both type and present will be checked by ts-runtime
            var value = lib_1.default.nullable(lib_1.default.ref("zipkin.option.INone.1398652972", lib_1.default.void())).assert(None);
            // Avoid unused value warning
            chai_1.expect(value.type).to.equal('None');
        });
        it('getOrElse should return value type', function () {
            var value = lib_1.default.nullable(lib_1.default.ref("zipkin.option.IOption.1398652972", lib_1.default.nullable(lib_1.default.number()))).assert(None);
            chai_1.expect(value.getOrElse(0)).to.equal(0);
            chai_1.expect(value.getOrElse(function () {
                return 0;
            })).to.equal(0);
        });
        it('ifPresent should return void', function () {
            var value = lib_1.default.nullable(lib_1.default.ref("zipkin.option.IOption.1398652972", lib_1.default.nullable(lib_1.default.number()))).assert(None);
            var x = lib_1.default.void().assert(value.ifPresent(function (v) {
                return v;
            }));
            chai_1.expect(x).to.equal(undefined);
        });
        it('map should have correct return types', function () {
            var mappedValue = lib_1.default.nullable(lib_1.default.ref("zipkin.option.IOption.1398652972", lib_1.default.any())).assert(None.map(function (v) {
                return v;
            }));
            chai_1.expect(mappedValue).to.equal(None);
        });
        it('flatMap should have correct return types', function () {
            var mappedValue1 = lib_1.default.nullable(lib_1.default.ref("zipkin.option.IOption.1398652972", lib_1.default.any())).assert(None.flatMap(function (v) {
                return new Some(v);
            }));
            var mappedValue2 = lib_1.default.nullable(lib_1.default.ref("zipkin.option.IOption.1398652972", lib_1.default.any())).assert(None.flatMap(function (_) {
                return None;
            }));
            chai_1.expect(mappedValue1).to.equal(None);
            chai_1.expect(mappedValue2).to.equal(None);
        });
    });
    describe('Some', function () {
        it('should have expected interface', function () {
            // Both type and present will be checked by ts-runtime
            var value = lib_1.default.nullable(lib_1.default.ref("zipkin.option.IOption.1398652972", lib_1.default.nullable(lib_1.default.number()))).assert(new Some(0));
            // Avoid unused value warning
            chai_1.expect(value.type).to.equal('Some');
        });
        it('getOrElse should return value type', function () {
            var value = lib_1.default.nullable(lib_1.default.ref("zipkin.option.IOption.1398652972", lib_1.default.nullable(lib_1.default.number()))).assert(new Some(0));
            chai_1.expect(value.getOrElse(1)).to.equal(0);
            chai_1.expect(value.getOrElse(function () {
                return 1;
            })).to.equal(0);
        });
        it('ifPresent should return void', function () {
            var value = lib_1.default.nullable(lib_1.default.ref("zipkin.option.IOption.1398652972", lib_1.default.nullable(lib_1.default.number()))).assert(new Some(0));
            var x = lib_1.default.void().assert(value.ifPresent(function (v) {
                return v;
            }));
            chai_1.expect(x).to.equal(undefined);
        });
        it('map should have correct return types', function () {
            var value = lib_1.default.nullable(lib_1.default.ref("zipkin.option.IOption.1398652972", lib_1.default.nullable(lib_1.default.string()))).assert(new Some('some value'));
            var mappedValue = lib_1.default.nullable(lib_1.default.ref("zipkin.option.IOption.1398652972", lib_1.default.nullable(lib_1.default.number()))).assert(value.map(function (v) {
                return v.length;
            }));
            chai_1.expect(mappedValue.type).to.equal('Some');
            chai_1.expect(mappedValue.getOrElse(0)).to.equal('some value'.length);
        });
        it('flatMap should have correct return types', function () {
            var value = new Some('some value');
            var mappedValue1 = lib_1.default.nullable(lib_1.default.ref("zipkin.option.IOption.1398652972", lib_1.default.nullable(lib_1.default.number()))).assert(value.flatMap(function (v) {
                return new Some(v.length);
            }));
            var mappedValue2 = lib_1.default.nullable(lib_1.default.ref("zipkin.option.IOption.1398652972", lib_1.default.nullable(lib_1.default.number()))).assert(value.flatMap(function (_) {
                return None;
            }));
            chai_1.expect(mappedValue1.getOrElse(0)).to.equal('some value'.length);
            chai_1.expect(mappedValue2.getOrElse(0)).to.equal(0);
        });
    });
});
