"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("../../tsr-declarations");
var lib_1 = require("ts-runtime/lib");
// Copyright 2020 The OpenZipkin Authors; licensed to You under the Apache License, Version 2.0.
var chai_1 = require("chai");
var zipkin_1 = require("zipkin");
describe('Recorder types', function () {
    describe('BatchRecorder', function () {
        it('should return correct type', function () {
            var Log = /** @class */ (function () {
                function Log() {
                    lib_1.default.ref("zipkin.Logger.1398652972").assert(this);
                }
                Log.prototype.logSpan = function (span) {
                    var _spanType = lib_1.default.nullable(lib_1.default.ref("zipkin.model.Span.1398652972"));
                    var _returnType = lib_1.default.return(lib_1.default.void());
                    lib_1.default.param("span", _spanType).assert(span);
                };
                return Log;
            }());
            var batchRecorder = lib_1.default.nullable(lib_1.default.ref("zipkin.BatchRecorder.1398652972")).assert(new zipkin_1.BatchRecorder({
                logger: new Log(),
                timeout: 1000
            }));
            chai_1.expect(batchRecorder.record).to.be.a('function');
        });
    });
    describe('ConsoleRecorder', function () {
        it('should ConsoleRecorder return correct type', function () {
            var consoleRecorder = lib_1.default.nullable(lib_1.default.ref("zipkin.ConsoleRecorder.1398652972")).assert(new zipkin_1.ConsoleRecorder());
            chai_1.expect(consoleRecorder.record).to.be.a('function');
        });
    });
});
