"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("../../tsr-declarations");
var lib_1 = require("ts-runtime/lib");
// Copyright 2020 The OpenZipkin Authors; licensed to You under the Apache License, Version 2.0.
var chai_1 = require("chai");
var zipkin_1 = require("zipkin");
describe('Request', function () {
    describe('addZipkinHeaders', function () {
        it('should have correct return types', function () {
            var traceId = new zipkin_1.TraceId({
                traceId: '863ac35c9f6413ad48485a3953bb6124',
                spanId: '48485a3953bb6124'
            });
            var requestWithHeaders = lib_1.default.nullable(lib_1.default.ref("zipkin.RequestZipkinHeaders.1398652972")).assert(zipkin_1.Request.addZipkinHeaders({}, traceId));
            chai_1.expect(requestWithHeaders).to.have.property('headers');
        });
        it('should have correct return types when using generic', function () {
            var traceId = new zipkin_1.TraceId({
                traceId: '863ac35c9f6413ad48485a3953bb6124',
                spanId: '48485a3953bb6124'
            });
            var requestWithCookie = lib_1.default.nullable(lib_1.default.ref("zipkin.RequestZipkinHeaders.1398652972", lib_1.default.object(lib_1.default.property("url", lib_1.default.nullable(lib_1.default.string()))), lib_1.default.object(lib_1.default.property("cookie", lib_1.default.nullable(lib_1.default.string()))))).assert(zipkin_1.Request.addZipkinHeaders({ url: 'google.com', headers: { cookie: 'abc' } }, traceId));
            chai_1.expect(requestWithCookie.headers.cookie).to.equal('abc');
            chai_1.expect(requestWithCookie.url).to.equal('google.com');
        });
    });
});
