import { PseudoPromise } from "../PseudoPromise";
import { MakeErrorData, ZodError, ZodErrorMap, ZodIssue } from "../ZodError";
export declare const ZodParsedType: {
    number: "number";
    string: "string";
    nan: "nan";
    integer: "integer";
    float: "float";
    boolean: "boolean";
    date: "date";
    bigint: "bigint";
    symbol: "symbol";
    function: "function";
    undefined: "undefined";
    null: "null";
    array: "array";
    object: "object";
    unknown: "unknown";
    promise: "promise";
    void: "void";
    never: "never";
    map: "map";
    set: "set";
};
export declare type ZodParsedType = keyof typeof ZodParsedType;
export declare const getParsedType: (data: any) => ZodParsedType;
export declare const makeIssue: (data: any, path: (string | number)[], errorMap: ZodErrorMap, errorData: MakeErrorData) => ZodIssue;
export declare type ParseParams = {
    data: any;
    path: (string | number)[];
    errorMap: ZodErrorMap;
    parentError: ZodError;
    async: boolean;
};
export declare type ParseParamsNoData = Omit<ParseParams, "data">;
export declare type ParsePathComponent = string | number;
export declare type ParsePath = null | {
    readonly component: ParsePathComponent;
    readonly parent: ParsePath;
    readonly count: number;
};
export declare const EMPTY_PATH: ParsePath;
export declare const pathToArray: (path: ParsePath) => ParsePathComponent[];
export declare const pathFromArray: (arr: ParsePathComponent[]) => ParsePath;
export declare type ParseContextParameters = {
    errorMap: ZodErrorMap;
    async: boolean;
};
export declare class ParseContext {
    readonly path: ParsePath;
    readonly issues: ZodIssue[];
    readonly params: ParseContextParameters;
    constructor(path: ParsePath, issues: ZodIssue[], params: ParseContextParameters);
    stepInto(component: ParsePathComponent): ParseContext;
    addIssue(data: any, errorData: MakeErrorData): void;
}
export declare const createRootContext: (params: Partial<ParseParamsNoData>) => ParseContext;
export declare type INVALID = {
    valid: false;
};
export declare const INVALID: INVALID;
export declare type OK<T> = {
    valid: true;
    value: T;
};
export declare const OK: <T>(value: T) => OK<T>;
export declare type ASYNC<T> = PseudoPromise<T>;
export declare const ASYNC: <T>(promise: Promise<T>) => ASYNC<T>;
export declare type SyncParseReturnType<T> = OK<T> | INVALID;
export declare type ParseReturnType<T> = SyncParseReturnType<T> | ASYNC<SyncParseReturnType<T>>;
export declare const isInvalid: (x: ParseReturnType<any>) => x is INVALID;
export declare const isOk: <T>(x: ParseReturnType<T>) => x is OK<T>;
export declare const isAsync: <T>(x: ParseReturnType<T>) => x is ASYNC<SyncParseReturnType<T>>;
//# sourceMappingURL=parseUtil.d.ts.map