"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.isAsync = exports.isOk = exports.isInvalid = exports.ASYNC = exports.OK = exports.INVALID = exports.createRootContext = exports.ParseContext = exports.pathFromArray = exports.pathToArray = exports.EMPTY_PATH = exports.makeIssue = exports.getParsedType = exports.ZodParsedType = void 0;
var PseudoPromise_1 = require("../PseudoPromise");
var ZodError_1 = require("../ZodError");
var util_1 = require("./util");
exports.ZodParsedType = util_1.util.arrayToEnum([
    "string",
    "nan",
    "number",
    "integer",
    "float",
    "boolean",
    "date",
    "bigint",
    "symbol",
    "function",
    "undefined",
    "null",
    "array",
    "object",
    "unknown",
    "promise",
    "void",
    "never",
    "map",
    "set",
]);
var getParsedType = function (data) {
    var t = typeof data;
    switch (t) {
        case "undefined":
            return exports.ZodParsedType.undefined;
        case "string":
            return exports.ZodParsedType.string;
        case "number":
            return Number.isNaN(data) ? exports.ZodParsedType.nan : exports.ZodParsedType.number;
        case "boolean":
            return exports.ZodParsedType.boolean;
        case "function":
            return exports.ZodParsedType.function;
        case "bigint":
            return exports.ZodParsedType.bigint;
        case "object":
            if (Array.isArray(data))
                return exports.ZodParsedType.array;
            if (data === null)
                return exports.ZodParsedType.null;
            if (data.then &&
                typeof data.then === "function" &&
                data.catch &&
                typeof data.catch === "function") {
                return exports.ZodParsedType.promise;
            }
            if (data instanceof Map) {
                return exports.ZodParsedType.map;
            }
            if (data instanceof Set) {
                return exports.ZodParsedType.set;
            }
            if (data instanceof Date) {
                return exports.ZodParsedType.date;
            }
            return exports.ZodParsedType.object;
        default:
            return exports.ZodParsedType.unknown;
    }
};
exports.getParsedType = getParsedType;
var makeIssue = function (data, path, errorMap, errorData) {
    var fullPath = __spreadArray(__spreadArray([], __read(path)), __read((errorData.path || [])));
    var errorArg = __assign(__assign({}, errorData), { path: fullPath });
    var defaultError = ZodError_1.defaultErrorMap(errorArg, {
        data: data,
        defaultError: "Invalid input",
    });
    return __assign(__assign({}, errorData), { path: fullPath, message: errorData.message ||
            errorMap(errorArg, {
                data: data,
                defaultError: defaultError.message,
            }).message });
};
exports.makeIssue = makeIssue;
exports.EMPTY_PATH = null;
var pathToArray = function (path) {
    if (path === null)
        return [];
    var arr = new Array(path.count);
    while (path !== null) {
        arr[path.count - 1] = path.component;
        path = path.parent;
    }
    return arr;
};
exports.pathToArray = pathToArray;
var pathFromArray = function (arr) {
    var path = null;
    for (var i = 0; i < arr.length; i++) {
        path = { parent: path, component: arr[i], count: i + 1 };
    }
    return path;
};
exports.pathFromArray = pathFromArray;
var ParseContext = /** @class */ (function () {
    function ParseContext(path, issues, params) {
        this.path = path;
        this.issues = issues;
        this.params = params;
    }
    ParseContext.prototype.stepInto = function (component) {
        return new ParseContext(this.path === null
            ? { parent: null, count: 1, component: component }
            : { parent: this.path, count: this.path.count + 1, component: component }, this.issues, this.params);
    };
    ParseContext.prototype.addIssue = function (data, errorData) {
        var issue = exports.makeIssue(data, exports.pathToArray(this.path), this.params.errorMap, errorData);
        this.issues.push(issue);
    };
    return ParseContext;
}());
exports.ParseContext = ParseContext;
var createRootContext = function (params) {
    var _a;
    return new ParseContext(exports.EMPTY_PATH, [], {
        async: (_a = params.async) !== null && _a !== void 0 ? _a : false,
        errorMap: params.errorMap || ZodError_1.overrideErrorMap,
    });
};
exports.createRootContext = createRootContext;
exports.INVALID = Object.freeze({ valid: false });
var OK = function (value) { return ({ valid: true, value: value }); };
exports.OK = OK;
var ASYNC = function (promise) {
    return new PseudoPromise_1.PseudoPromise(promise);
};
exports.ASYNC = ASYNC;
var isInvalid = function (x) {
    return x === exports.INVALID;
};
exports.isInvalid = isInvalid;
var isOk = function (x) {
    return x.valid === true;
};
exports.isOk = isOk;
var isAsync = function (x) { return x instanceof PseudoPromise_1.PseudoPromise; };
exports.isAsync = isAsync;
//# sourceMappingURL=parseUtil.js.map