/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

function __spreadArray(to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
}

var PseudoPromise = /** @class */ (function () {
    function PseudoPromise(promise) {
        this.promise = promise;
    }
    PseudoPromise.prototype.then = function (f) {
        return new PseudoPromise(this.promise.then(f));
    };
    PseudoPromise.all = function (pps) {
        return new PseudoPromise(Promise.all(pps.map(function (v) { return (v instanceof PseudoPromise ? v.promise : v); })));
    };
    return PseudoPromise;
}());

var util;
(function (util) {
    function assertNever(_x) {
        throw new Error();
    }
    util.assertNever = assertNever;
    util.arrayToEnum = function (items) {
        var e_1, _a;
        var obj = {};
        try {
            for (var items_1 = __values(items), items_1_1 = items_1.next(); !items_1_1.done; items_1_1 = items_1.next()) {
                var item = items_1_1.value;
                obj[item] = item;
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (items_1_1 && !items_1_1.done && (_a = items_1.return)) _a.call(items_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return obj;
    };
    util.getValidEnumValues = function (obj) {
        var e_2, _a;
        var validKeys = Object.keys(obj).filter(function (k) { return typeof obj[obj[k]] !== "number"; });
        var filtered = {};
        try {
            for (var validKeys_1 = __values(validKeys), validKeys_1_1 = validKeys_1.next(); !validKeys_1_1.done; validKeys_1_1 = validKeys_1.next()) {
                var k = validKeys_1_1.value;
                filtered[k] = obj[k];
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (validKeys_1_1 && !validKeys_1_1.done && (_a = validKeys_1.return)) _a.call(validKeys_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return util.getValues(filtered);
    };
    util.getValues = function (obj) {
        return Object.keys(obj).map(function (e) {
            return obj[e];
        });
    };
    util.objectValues = function (obj) {
        return Object.keys(obj).map(function (e) {
            return obj[e];
        });
    };
    util.find = function (arr, checker) {
        var e_3, _a;
        try {
            for (var arr_1 = __values(arr), arr_1_1 = arr_1.next(); !arr_1_1.done; arr_1_1 = arr_1.next()) {
                var item = arr_1_1.value;
                if (checker(item))
                    return item;
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (arr_1_1 && !arr_1_1.done && (_a = arr_1.return)) _a.call(arr_1);
            }
            finally { if (e_3) throw e_3.error; }
        }
        return undefined;
    };
})(util || (util = {}));

var ZodIssueCode = util.arrayToEnum([
    "invalid_type",
    "custom",
    "invalid_union",
    "invalid_enum_value",
    "unrecognized_keys",
    "invalid_arguments",
    "invalid_return_type",
    "invalid_date",
    "invalid_string",
    "too_small",
    "too_big",
    "invalid_intersection_types",
]);
var quotelessJson = function (obj) {
    var json = JSON.stringify(obj, null, 2);
    return json.replace(/"([^"]+)":/g, "$1:");
};
var ZodError = /** @class */ (function () {
    function ZodError(issues) {
        var _this = this;
        this.issues = [];
        this.format = function () {
            var fieldErrors = { _errors: [] };
            var processError = function (error) {
                var e_1, _a;
                try {
                    for (var _b = __values(error.issues), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var issue = _c.value;
                        if (issue.code === "invalid_union") {
                            issue.unionErrors.map(processError);
                        }
                        else if (issue.code === "invalid_return_type") {
                            processError(issue.returnTypeError);
                        }
                        else if (issue.code === "invalid_arguments") {
                            processError(issue.argumentsError);
                        }
                        else if (issue.path.length === 0) {
                            fieldErrors._errors.push(issue.message);
                        }
                        else {
                            var curr = fieldErrors;
                            var i = 0;
                            while (i < issue.path.length) {
                                var el = issue.path[i];
                                var terminal = i === issue.path.length - 1;
                                if (!terminal) {
                                    if (typeof el === "string") {
                                        curr[el] = curr[el] || { _errors: [] };
                                    }
                                    else if (typeof el === "number") {
                                        var errorArray = [];
                                        errorArray._errors = [];
                                        curr[el] = curr[el] || errorArray;
                                    }
                                }
                                else {
                                    curr[el] = curr[el] || { _errors: [] };
                                    curr[el]._errors.push(issue.message);
                                }
                                curr = curr[el];
                                i++;
                            }
                        }
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
            };
            processError(_this);
            return fieldErrors;
        };
        this.addIssue = function (sub) {
            _this.issues = __spreadArray(__spreadArray([], __read(_this.issues)), [sub]);
        };
        this.addIssues = function (subs) {
            if (subs === void 0) { subs = []; }
            _this.issues = __spreadArray(__spreadArray([], __read(_this.issues)), __read(subs));
        };
        this.flatten = function () {
            var e_2, _a;
            var fieldErrors = {};
            var formErrors = [];
            try {
                for (var _b = __values(_this.issues), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var sub = _c.value;
                    if (sub.path.length > 0) {
                        fieldErrors[sub.path[0]] = fieldErrors[sub.path[0]] || [];
                        fieldErrors[sub.path[0]].push(sub.message);
                    }
                    else {
                        formErrors.push(sub.message);
                    }
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_2) throw e_2.error; }
            }
            return { formErrors: formErrors, fieldErrors: fieldErrors };
        };
        this.issues = issues;
    }
    Object.defineProperty(ZodError.prototype, "errors", {
        get: function () {
            return this.issues;
        },
        enumerable: false,
        configurable: true
    });
    ZodError.prototype.toString = function () {
        return "ZodError: " + JSON.stringify(this.issues, null, 2);
    };
    Object.defineProperty(ZodError.prototype, "message", {
        get: function () {
            return JSON.stringify(this.issues, null, 2);
            // const errorMessage: string[] = [
            //   `${this.issues.length} validation issue(s)`,
            //   '',
            // ];
            // for (const err of this.issues) {
            //   errorMessage.push(
            //     `  Issue #${this.issues.indexOf(err)}: ${err.code} at ${err.path.join(
            //       '.',
            //     )}`,
            //   );
            //   errorMessage.push(`  ` + err.message);
            //   errorMessage.push('');
            // }
            // return errorMessage.join('\n');
            // return quotelessJson(this);
            // .map(({ path, message }) => {
            //   return path.length ? `${path.join('./index')}: ${message}` : `${message}`;
            // })
            // .join('\n');
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ZodError.prototype, "isEmpty", {
        get: function () {
            return this.issues.length === 0;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ZodError.prototype, "formErrors", {
        // denormalize = ():DenormalizedError{
        // }
        get: function () {
            return this.flatten();
        },
        enumerable: false,
        configurable: true
    });
    ZodError.create = function (issues) {
        var error = new ZodError(issues);
        return error;
    };
    return ZodError;
}());
var defaultErrorMap = function (error, _ctx) {
    var message;
    switch (error.code) {
        case ZodIssueCode.invalid_type:
            if (error.received === "undefined") {
                message = "Required";
            }
            else {
                message = "Expected " + error.expected + ", received " + error.received;
            }
            break;
        case ZodIssueCode.unrecognized_keys:
            message = "Unrecognized key(s) in object: " + error.keys
                .map(function (k) { return "'" + k + "'"; })
                .join(", ");
            break;
        case ZodIssueCode.invalid_union:
            message = "Invalid input";
            break;
        case ZodIssueCode.invalid_enum_value:
            message = "Invalid enum value. Expected " + error.options
                .map(function (val) { return (typeof val === "string" ? "'" + val + "'" : val); })
                .join(" | ") + ", received " + (typeof _ctx.data === "string" ? "'" + _ctx.data + "'" : _ctx.data);
            break;
        case ZodIssueCode.invalid_arguments:
            message = "Invalid function arguments";
            break;
        case ZodIssueCode.invalid_return_type:
            message = "Invalid function return type";
            break;
        case ZodIssueCode.invalid_date:
            message = "Invalid date";
            break;
        // case ZodIssueCode.too_small:
        //   const tooShortNoun = _ctx.data === 'string' ? 'characters' : 'items';
        //   message = `Too short, should be at least ${error.minimum} ${tooShortNoun}`;
        //   break;
        // case ZodIssueCode.too_big:
        //   const tooLongNoun = _ctx.data === 'string' ? 'characters' : 'items';
        //   message = `Too short, should be at most ${error.maximum} ${tooLongNoun}`;
        //   break;
        case ZodIssueCode.invalid_string:
            if (error.validation !== "regex")
                message = "Invalid " + error.validation;
            else
                message = "Invalid";
            break;
        // case ZodIssueCode.invalid_url:
        //   message = 'Invalid URL.';
        //   break;
        // case ZodIssueCode.invalid_uuid:
        //   message = 'Invalid UUID.';
        //   break;
        case ZodIssueCode.too_small:
            if (error.type === "array")
                message = "Should have " + (error.inclusive ? "at least" : "more than") + " " + error.minimum + " items";
            else if (error.type === "string")
                message = "Should be " + (error.inclusive ? "at least" : "over") + " " + error.minimum + " characters";
            else if (error.type === "number")
                message = "Value should be greater than " + (error.inclusive ? "or equal to " : "") + error.minimum;
            else
                message = "Invalid input";
            break;
        case ZodIssueCode.too_big:
            if (error.type === "array")
                message = "Should have " + (error.inclusive ? "at most" : "less than") + " " + error.maximum + " items";
            else if (error.type === "string")
                message = "Should be " + (error.inclusive ? "at most" : "under") + " " + error.maximum + " characters long";
            else if (error.type === "number")
                message = "Value should be less than " + (error.inclusive ? "or equal to " : "") + error.maximum;
            else
                message = "Invalid input";
            break;
        case ZodIssueCode.custom:
            message = "Invalid input";
            break;
        case ZodIssueCode.invalid_intersection_types:
            message = "Intersections only support objects";
            break;
        default:
            message = _ctx.defaultError;
            util.assertNever(error);
    }
    return { message: message };
    // return `Invalid input`;
};
var overrideErrorMap = defaultErrorMap;
var setErrorMap = function (map) {
    overrideErrorMap = map;
};

var ZodParsedType = util.arrayToEnum([
    "string",
    "nan",
    "number",
    "integer",
    "float",
    "boolean",
    "date",
    "bigint",
    "symbol",
    "function",
    "undefined",
    "null",
    "array",
    "object",
    "unknown",
    "promise",
    "void",
    "never",
    "map",
    "set",
]);
var getParsedType = function (data) {
    var t = typeof data;
    switch (t) {
        case "undefined":
            return ZodParsedType.undefined;
        case "string":
            return ZodParsedType.string;
        case "number":
            return Number.isNaN(data) ? ZodParsedType.nan : ZodParsedType.number;
        case "boolean":
            return ZodParsedType.boolean;
        case "function":
            return ZodParsedType.function;
        case "bigint":
            return ZodParsedType.bigint;
        case "object":
            if (Array.isArray(data))
                return ZodParsedType.array;
            if (data === null)
                return ZodParsedType.null;
            if (data.then &&
                typeof data.then === "function" &&
                data.catch &&
                typeof data.catch === "function") {
                return ZodParsedType.promise;
            }
            if (data instanceof Map) {
                return ZodParsedType.map;
            }
            if (data instanceof Set) {
                return ZodParsedType.set;
            }
            if (data instanceof Date) {
                return ZodParsedType.date;
            }
            return ZodParsedType.object;
        default:
            return ZodParsedType.unknown;
    }
};
var makeIssue = function (data, path, errorMap, errorData) {
    var fullPath = __spreadArray(__spreadArray([], __read(path)), __read((errorData.path || [])));
    var errorArg = __assign(__assign({}, errorData), { path: fullPath });
    var defaultError = defaultErrorMap(errorArg, {
        data: data,
        defaultError: "Invalid input",
    });
    return __assign(__assign({}, errorData), { path: fullPath, message: errorData.message ||
            errorMap(errorArg, {
                data: data,
                defaultError: defaultError.message,
            }).message });
};
var EMPTY_PATH = null;
var pathToArray = function (path) {
    if (path === null)
        return [];
    var arr = new Array(path.count);
    while (path !== null) {
        arr[path.count - 1] = path.component;
        path = path.parent;
    }
    return arr;
};
var pathFromArray = function (arr) {
    var path = null;
    for (var i = 0; i < arr.length; i++) {
        path = { parent: path, component: arr[i], count: i + 1 };
    }
    return path;
};
var ParseContext = /** @class */ (function () {
    function ParseContext(path, issues, params) {
        this.path = path;
        this.issues = issues;
        this.params = params;
    }
    ParseContext.prototype.stepInto = function (component) {
        return new ParseContext(this.path === null
            ? { parent: null, count: 1, component: component }
            : { parent: this.path, count: this.path.count + 1, component: component }, this.issues, this.params);
    };
    ParseContext.prototype.addIssue = function (data, errorData) {
        var issue = makeIssue(data, pathToArray(this.path), this.params.errorMap, errorData);
        this.issues.push(issue);
    };
    return ParseContext;
}());
var createRootContext$1 = function (params) {
    var _a;
    return new ParseContext(EMPTY_PATH, [], {
        async: (_a = params.async) !== null && _a !== void 0 ? _a : false,
        errorMap: params.errorMap || overrideErrorMap,
    });
};
var INVALID = Object.freeze({ valid: false });
var OK = function (value) { return ({ valid: true, value: value }); };
var ASYNC = function (promise) {
    return new PseudoPromise(promise);
};
var isInvalid = function (x) {
    return x === INVALID;
};
var isOk = function (x) {
    return x.valid === true;
};
var isAsync = function (x) { return x instanceof PseudoPromise; };

var errorUtil;
(function (errorUtil) {
    errorUtil.errToObj = function (message) {
        return typeof message === "string" ? { message: message } : message || {};
    };
    errorUtil.toString = function (message) {
        return typeof message === "string" ? message : message === null || message === void 0 ? void 0 : message.message;
    };
})(errorUtil || (errorUtil = {}));

var createTasks = function (ctx) {
    return ctx.params.async ? [] : null;
};
var createRootContext = function (params) {
    var _a;
    return new ParseContext(pathFromArray(params.path || []), [], {
        async: (_a = params.async) !== null && _a !== void 0 ? _a : false,
        errorMap: params.errorMap || overrideErrorMap,
    });
};
var handleResult = function (ctx, result, parentError) {
    if (isOk(result)) {
        return { success: true, data: result.value };
    }
    else {
        parentError === null || parentError === void 0 ? void 0 : parentError.addIssues(ctx.issues);
        var error = new ZodError(ctx.issues);
        return { success: false, error: error };
    }
};
var ZodType = /** @class */ (function () {
    function ZodType(def) {
        var _this = this;
        this.parse = function (data, params) {
            var result = _this.safeParse(data, params);
            if (result.success)
                return result.data;
            throw result.error;
        };
        this.safeParse = function (data, params) {
            var ctx = createRootContext(__assign(__assign({}, params), { async: false }));
            var result = _this._parseSync(ctx, data, getParsedType(data));
            return handleResult(ctx, result, params === null || params === void 0 ? void 0 : params.parentError);
        };
        this.parseAsync = function (data, params) { return __awaiter(_this, void 0, void 0, function () {
            var result;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.safeParseAsync(data, params)];
                    case 1:
                        result = _a.sent();
                        if (result.success)
                            return [2 /*return*/, result.data];
                        throw result.error;
                }
            });
        }); };
        this.safeParseAsync = function (data, params) { return __awaiter(_this, void 0, void 0, function () {
            var ctx, maybeAsyncResult, result;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        ctx = createRootContext(__assign(__assign({}, params), { async: true }));
                        maybeAsyncResult = this._parse(ctx, data, getParsedType(data));
                        return [4 /*yield*/, (isAsync(maybeAsyncResult)
                                ? maybeAsyncResult.promise
                                : Promise.resolve(maybeAsyncResult))];
                    case 1:
                        result = _a.sent();
                        return [2 /*return*/, handleResult(ctx, result, params === null || params === void 0 ? void 0 : params.parentError)];
                }
            });
        }); };
        /** Alias of safeParseAsync */
        this.spa = this.safeParseAsync;
        this.refine = function (check, message) {
            var getIssueProperties = function (val) {
                if (typeof message === "string" || typeof message === "undefined") {
                    return { message: message };
                }
                else if (typeof message === "function") {
                    return message(val);
                }
                else {
                    return message;
                }
            };
            return _this._refinement(function (val, ctx) {
                var result = check(val);
                var setError = function () {
                    return ctx.addIssue(__assign({ code: ZodIssueCode.custom }, getIssueProperties(val)));
                };
                if (result instanceof Promise) {
                    return result.then(function (data) {
                        if (!data) {
                            setError();
                            return false;
                        }
                        else {
                            return true;
                        }
                    });
                }
                if (!result) {
                    setError();
                    return false;
                }
                else {
                    return true;
                }
            });
        };
        this.refinement = function (check, refinementData) {
            return _this._refinement(function (val, ctx) {
                if (!check(val)) {
                    ctx.addIssue(typeof refinementData === "function"
                        ? refinementData(val, ctx)
                        : refinementData);
                    return false;
                }
                else {
                    return true;
                }
            });
        };
        this.superRefine = this._refinement;
        this.optional = function () {
            return ZodOptional.create(_this);
        };
        this.nullable = function () {
            return ZodNullable.create(_this);
        };
        this.nullish = function () { return _this.optional().nullable(); };
        this.array = function () { return ZodArray.create(_this); };
        this.isOptional = function () { return _this.safeParse(undefined).success; };
        this.isNullable = function () { return _this.safeParse(null).success; };
        this._def = def;
        this.transform = this.transform.bind(this);
        this.default = this.default.bind(this);
    }
    ZodType.prototype._parseSync = function (_ctx, _data, _parsedType) {
        var result = this._parse(_ctx, _data, _parsedType);
        if (isAsync(result)) {
            throw new Error("Synchronous parse encountered promise.");
        }
        return result;
    };
    ZodType.prototype._refinement = function (refinement) {
        var returnType;
        if (this instanceof ZodEffects) {
            returnType = new ZodEffects(__assign(__assign({}, this._def), { effects: __spreadArray(__spreadArray([], __read((this._def.effects || []))), [
                    { type: "refinement", refinement: refinement },
                ]) }));
        }
        else {
            returnType = new ZodEffects({
                schema: this,
                effects: [{ type: "refinement", refinement: refinement }],
            });
        }
        return returnType;
    };
    ZodType.prototype.or = function (option) {
        return ZodUnion.create([this, option]);
    };
    ZodType.prototype.and = function (incoming) {
        return ZodIntersection.create(this, incoming);
    };
    ZodType.prototype.transform = function (transform) {
        return new ZodEffects({
            schema: this,
            effects: [{ type: "transform", transform: transform }],
        });
    };
    ZodType.prototype.default = function (def) {
        var defaultValueFunc = typeof def === "function" ? def : function () { return def; };
        // if (this instanceof ZodOptional) {
        //   return new ZodOptional({
        //     ...this._def,
        //     defaultValue: defaultValueFunc,
        //   }) as any;
        // }
        return new ZodDefault({
            innerType: this,
            defaultValue: defaultValueFunc,
        });
    };
    return ZodType;
}());
var uuidRegex = /^([a-f0-9]{8}-[a-f0-9]{4}-[1-5][a-f0-9]{3}-[89ab][a-f0-9]{3}-[a-f0-9]{12}|00000000-0000-0000-0000-000000000000)$/i;
// from https://stackoverflow.com/a/46181/1550155
// old version: too slow, didn't support unicode
// const emailRegex = /^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))$/i;
// eslint-disable-next-line
var emailRegex = /^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i;
var ZodString = /** @class */ (function (_super) {
    __extends(ZodString, _super);
    function ZodString() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._regex = function (regex, validation, message) {
            return _this.refinement(function (data) { return regex.test(data); }, __assign({ validation: validation, code: ZodIssueCode.invalid_string }, errorUtil.errToObj(message)));
        };
        _this.email = function (message) {
            return new ZodString(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    __assign({ kind: "email" }, errorUtil.errToObj(message)),
                ]) }));
        };
        _this.url = function (message) {
            return new ZodString(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    __assign({ kind: "url" }, errorUtil.errToObj(message)),
                ]) }));
        };
        _this.uuid = function (message) {
            return new ZodString(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    __assign({ kind: "uuid" }, errorUtil.errToObj(message)),
                ]) }));
        };
        _this.regex = function (regex, message) {
            return new ZodString(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    __assign({ kind: "regex", regex: regex }, errorUtil.errToObj(message)),
                ]) }));
        };
        _this.min = function (minLength, message) {
            return new ZodString(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    __assign({ kind: "min", value: minLength }, errorUtil.errToObj(message)),
                ]) }));
        };
        _this.max = function (maxLength, message) {
            return new ZodString(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    __assign({ kind: "max", value: maxLength }, errorUtil.errToObj(message)),
                ]) }));
        };
        /**
         * Deprecated.
         * Use z.string().min(1) instead.
         */
        _this.nonempty = function (message) {
            return _this.min(1, errorUtil.errToObj(message));
        };
        return _this;
    }
    ZodString.prototype._parse = function (ctx, data, parsedType) {
        var e_1, _a;
        if (parsedType !== ZodParsedType.string) {
            ctx.addIssue(data, {
                code: ZodIssueCode.invalid_type,
                expected: ZodParsedType.string,
                received: parsedType,
            });
            return INVALID;
        }
        var invalid = false;
        try {
            for (var _b = __values(this._def.checks), _c = _b.next(); !_c.done; _c = _b.next()) {
                var check = _c.value;
                if (check.kind === "min") {
                    if (data.length < check.value) {
                        invalid = true;
                        ctx.addIssue(data, {
                            code: ZodIssueCode.too_small,
                            minimum: check.value,
                            type: "string",
                            inclusive: true,
                            message: check.message,
                        });
                    }
                }
                else if (check.kind === "max") {
                    if (data.length > check.value) {
                        invalid = true;
                        ctx.addIssue(data, {
                            code: ZodIssueCode.too_big,
                            maximum: check.value,
                            type: "string",
                            inclusive: true,
                            message: check.message,
                            // ...errorUtil.errToObj(this._def.maxLength.message),
                        });
                    }
                }
                else if (check.kind === "email") {
                    if (!emailRegex.test(data)) {
                        invalid = true;
                        ctx.addIssue(data, {
                            validation: "email",
                            code: ZodIssueCode.invalid_string,
                            message: check.message,
                        });
                    }
                }
                else if (check.kind === "uuid") {
                    if (!uuidRegex.test(data)) {
                        invalid = true;
                        ctx.addIssue(data, {
                            validation: "uuid",
                            code: ZodIssueCode.invalid_string,
                            message: check.message,
                        });
                    }
                }
                else if (check.kind === "url") {
                    try {
                        new URL(data);
                    }
                    catch (_d) {
                        invalid = true;
                        ctx.addIssue(data, {
                            validation: "url",
                            code: ZodIssueCode.invalid_string,
                            message: check.message,
                        });
                    }
                }
                else if (check.kind === "regex") {
                    if (!check.regex.test(data)) {
                        invalid = true;
                        ctx.addIssue(data, {
                            validation: "regex",
                            code: ZodIssueCode.invalid_string,
                            message: check.message,
                        });
                    }
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return invalid ? INVALID : OK(data);
    };
    ZodString.prototype.length = function (len, message) {
        return this.min(len, message).max(len, message);
    };
    Object.defineProperty(ZodString.prototype, "isEmail", {
        get: function () {
            return !!this._def.checks.find(function (ch) { return ch.kind === "email"; });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ZodString.prototype, "isURL", {
        get: function () {
            return !!this._def.checks.find(function (ch) { return ch.kind === "url"; });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ZodString.prototype, "isUUID", {
        get: function () {
            return !!this._def.checks.find(function (ch) { return ch.kind === "uuid"; });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ZodString.prototype, "minLength", {
        get: function () {
            var min = -Infinity;
            this._def.checks.map(function (ch) {
                if (ch.kind === "min") {
                    if (min === null || ch.value > min) {
                        min = ch.value;
                    }
                }
            });
            return min;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ZodString.prototype, "maxLength", {
        get: function () {
            var max = null;
            this._def.checks.map(function (ch) {
                if (ch.kind === "min") {
                    if (max === null || ch.value < max) {
                        max = ch.value;
                    }
                }
            });
            return max;
        },
        enumerable: false,
        configurable: true
    });
    ZodString.create = function () {
        return new ZodString({
            checks: [],
        });
    };
    return ZodString;
}(ZodType));
var ZodNumber = /** @class */ (function (_super) {
    __extends(ZodNumber, _super);
    function ZodNumber() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.min = function (value, message) {
            return new ZodNumber(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    {
                        kind: "min",
                        value: value,
                        inclusive: true,
                        message: errorUtil.toString(message),
                    },
                ]) }));
        };
        _this.max = function (value, message) {
            return new ZodNumber(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    {
                        kind: "max",
                        value: value,
                        inclusive: true,
                        message: errorUtil.toString(message),
                    },
                ]) }));
        };
        _this.int = function (message) {
            return new ZodNumber(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    {
                        kind: "int",
                        message: errorUtil.toString(message),
                    },
                ]) }));
        };
        _this.positive = function (message) {
            return new ZodNumber(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    {
                        kind: "min",
                        value: 0,
                        inclusive: false,
                        message: errorUtil.toString(message),
                    },
                ]) }));
        };
        _this.negative = function (message) {
            return new ZodNumber(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    {
                        kind: "max",
                        value: 0,
                        inclusive: false,
                        message: errorUtil.toString(message),
                    },
                ]) }));
        };
        _this.nonpositive = function (message) {
            return new ZodNumber(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    {
                        kind: "max",
                        value: 0,
                        inclusive: true,
                        message: errorUtil.toString(message),
                    },
                ]) }));
        };
        _this.nonnegative = function (message) {
            return new ZodNumber(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    {
                        kind: "min",
                        value: 0,
                        inclusive: true,
                        message: errorUtil.toString(message),
                    },
                ]) }));
        };
        return _this;
    }
    ZodNumber.prototype._parse = function (ctx, data, parsedType) {
        var e_2, _a;
        if (parsedType !== ZodParsedType.number) {
            ctx.addIssue(data, {
                code: ZodIssueCode.invalid_type,
                expected: ZodParsedType.number,
                received: parsedType,
            });
            return INVALID;
        }
        var invalid = false;
        try {
            for (var _b = __values(this._def.checks), _c = _b.next(); !_c.done; _c = _b.next()) {
                var check = _c.value;
                if (check.kind === "int") {
                    if (!Number.isInteger(data)) {
                        invalid = true;
                        ctx.addIssue(data, {
                            code: ZodIssueCode.invalid_type,
                            expected: "integer",
                            received: "float",
                            message: check.message,
                        });
                    }
                }
                else if (check.kind === "min") {
                    // const MIN = check.value;
                    var tooSmall = check.inclusive
                        ? data < check.value
                        : data <= check.value;
                    if (tooSmall) {
                        invalid = true;
                        ctx.addIssue(data, {
                            code: ZodIssueCode.too_small,
                            minimum: check.value,
                            type: "number",
                            inclusive: check.inclusive,
                            message: check.message,
                        });
                    }
                }
                else if (check.kind === "max") {
                    var tooBig = check.inclusive
                        ? data > check.value
                        : data >= check.value;
                    if (tooBig) {
                        invalid = true;
                        ctx.addIssue(data, {
                            code: ZodIssueCode.too_big,
                            maximum: check.value,
                            type: "number",
                            inclusive: check.inclusive,
                            message: check.message,
                        });
                    }
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return invalid ? INVALID : OK(data);
    };
    Object.defineProperty(ZodNumber.prototype, "minValue", {
        get: function () {
            var e_3, _a;
            var min = null;
            try {
                for (var _b = __values(this._def.checks), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var ch = _c.value;
                    if (ch.kind === "min") {
                        if (min === null || ch.value > min)
                            min = ch.value;
                    }
                }
            }
            catch (e_3_1) { e_3 = { error: e_3_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_3) throw e_3.error; }
            }
            return min;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ZodNumber.prototype, "maxValue", {
        get: function () {
            var e_4, _a;
            var max = null;
            try {
                for (var _b = __values(this._def.checks), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var ch = _c.value;
                    if (ch.kind === "max") {
                        if (max === null || ch.value < max)
                            max = ch.value;
                    }
                }
            }
            catch (e_4_1) { e_4 = { error: e_4_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_4) throw e_4.error; }
            }
            return max;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ZodNumber.prototype, "isInt", {
        get: function () {
            return !!this._def.checks.find(function (ch) { return ch.kind === "int"; });
        },
        enumerable: false,
        configurable: true
    });
    ZodNumber.create = function () {
        return new ZodNumber({
            checks: [],
        });
    };
    return ZodNumber;
}(ZodType));
var ZodBigInt = /** @class */ (function (_super) {
    __extends(ZodBigInt, _super);
    function ZodBigInt() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodBigInt.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType !== ZodParsedType.bigint) {
            ctx.addIssue(data, {
                code: ZodIssueCode.invalid_type,
                expected: ZodParsedType.bigint,
                received: parsedType,
            });
            return INVALID;
        }
        return OK(data);
    };
    ZodBigInt.create = function () {
        return new ZodBigInt({});
    };
    return ZodBigInt;
}(ZodType));
var ZodBoolean = /** @class */ (function (_super) {
    __extends(ZodBoolean, _super);
    function ZodBoolean() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodBoolean.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType !== ZodParsedType.boolean) {
            ctx.addIssue(data, {
                code: ZodIssueCode.invalid_type,
                expected: ZodParsedType.boolean,
                received: parsedType,
            });
            return INVALID;
        }
        return OK(data);
    };
    ZodBoolean.create = function () {
        return new ZodBoolean({});
    };
    return ZodBoolean;
}(ZodType));
var ZodDate = /** @class */ (function (_super) {
    __extends(ZodDate, _super);
    function ZodDate() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodDate.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType !== ZodParsedType.date) {
            ctx.addIssue(data, {
                code: ZodIssueCode.invalid_type,
                expected: ZodParsedType.date,
                received: parsedType,
            });
            return INVALID;
        }
        if (isNaN(data.getTime())) {
            ctx.addIssue(data, {
                code: ZodIssueCode.invalid_date,
            });
            return INVALID;
        }
        return OK(new Date(data.getTime()));
    };
    ZodDate.create = function () {
        return new ZodDate({});
    };
    return ZodDate;
}(ZodType));
var ZodUndefined = /** @class */ (function (_super) {
    __extends(ZodUndefined, _super);
    function ZodUndefined() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodUndefined.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType !== ZodParsedType.undefined) {
            ctx.addIssue(data, {
                code: ZodIssueCode.invalid_type,
                expected: ZodParsedType.undefined,
                received: parsedType,
            });
            return INVALID;
        }
        return OK(data);
    };
    ZodUndefined.create = function () {
        return new ZodUndefined({});
    };
    return ZodUndefined;
}(ZodType));
var ZodNull = /** @class */ (function (_super) {
    __extends(ZodNull, _super);
    function ZodNull() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodNull.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType !== ZodParsedType.null) {
            ctx.addIssue(data, {
                code: ZodIssueCode.invalid_type,
                expected: ZodParsedType.null,
                received: parsedType,
            });
            return INVALID;
        }
        return OK(data);
    };
    ZodNull.create = function () {
        return new ZodNull({});
    };
    return ZodNull;
}(ZodType));
var ZodAny = /** @class */ (function (_super) {
    __extends(ZodAny, _super);
    function ZodAny() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodAny.prototype._parse = function (_ctx, data, _parsedType) {
        return OK(data);
    };
    ZodAny.create = function () {
        return new ZodAny({});
    };
    return ZodAny;
}(ZodType));
var ZodUnknown = /** @class */ (function (_super) {
    __extends(ZodUnknown, _super);
    function ZodUnknown() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodUnknown.prototype._parse = function (_ctx, data, _parsedType) {
        return OK(data);
    };
    ZodUnknown.create = function () {
        return new ZodUnknown({});
    };
    return ZodUnknown;
}(ZodType));
var ZodNever = /** @class */ (function (_super) {
    __extends(ZodNever, _super);
    function ZodNever() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodNever.prototype._parse = function (ctx, data, parsedType) {
        ctx.addIssue(data, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.never,
            received: parsedType,
        });
        return INVALID;
    };
    ZodNever.create = function () {
        return new ZodNever({});
    };
    return ZodNever;
}(ZodType));
var ZodVoid = /** @class */ (function (_super) {
    __extends(ZodVoid, _super);
    function ZodVoid() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodVoid.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType !== ZodParsedType.undefined &&
            parsedType !== ZodParsedType.null) {
            ctx.addIssue(data, {
                code: ZodIssueCode.invalid_type,
                expected: ZodParsedType.void,
                received: parsedType,
            });
            return INVALID;
        }
        return OK(data);
    };
    ZodVoid.create = function () {
        return new ZodVoid({});
    };
    return ZodVoid;
}(ZodType));
var parseArray = function (ctx, data, parsedType, def, nonEmpty) {
    if (parsedType !== ZodParsedType.array) {
        ctx.addIssue(data, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.array,
            received: parsedType,
        });
        return INVALID;
    }
    var invalid = false;
    if (def.minLength !== null) {
        if (data.length < def.minLength.value) {
            invalid = true;
            ctx.addIssue(data, {
                code: ZodIssueCode.too_small,
                minimum: def.minLength.value,
                type: "array",
                inclusive: true,
                message: def.minLength.message,
            });
        }
    }
    if (def.maxLength !== null) {
        if (data.length > def.maxLength.value) {
            invalid = true;
            ctx.addIssue(data, {
                code: ZodIssueCode.too_big,
                maximum: def.maxLength.value,
                type: "array",
                inclusive: true,
                message: def.maxLength.message,
            });
        }
    }
    if (nonEmpty && data.length < 1) {
        invalid = true;
        ctx.addIssue(data, {
            code: ZodIssueCode.too_small,
            minimum: 1,
            type: "array",
            inclusive: true,
            // message: this._def.minLength.message,
            // ...errorUtil.errToObj(this._def.minLength.message),
        });
    }
    if (invalid) {
        return INVALID;
    }
    var tasks = createTasks(ctx);
    var result = new Array(data.length);
    var type = def.type;
    var handleParsed = function (index, parsedItem) {
        if (isOk(parsedItem)) {
            result[index] = parsedItem.value;
        }
        else if (isInvalid(parsedItem)) {
            invalid = true;
        }
        else {
            tasks === null || tasks === void 0 ? void 0 : tasks.push(parsedItem.promise.then(function (parsed) { return handleParsed(index, parsed); }));
        }
    };
    data.forEach(function (item, index) {
        handleParsed(index, type._parse(ctx.stepInto(index), item, getParsedType(item)));
    });
    if (tasks !== null && tasks.length > 0) {
        return ASYNC(Promise.all(tasks).then(function () { return (invalid ? INVALID : OK(result)); }));
    }
    else {
        return invalid ? INVALID : OK(result);
    }
};
var ZodArray = /** @class */ (function (_super) {
    __extends(ZodArray, _super);
    function ZodArray() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.min = function (minLength, message) {
            return new ZodArray(__assign(__assign({}, _this._def), { minLength: { value: minLength, message: errorUtil.toString(message) } }));
        };
        _this.max = function (maxLength, message) {
            return new ZodArray(__assign(__assign({}, _this._def), { maxLength: { value: maxLength, message: errorUtil.toString(message) } }));
        };
        _this.length = function (len, message) {
            return _this.min(len, message).max(len, message);
        };
        _this.nonempty = function () {
            return new ZodNonEmptyArray(__assign({}, _this._def));
        };
        return _this;
    }
    ZodArray.prototype._parse = function (ctx, data, parsedType) {
        var nonEmpty = false;
        return parseArray(ctx, data, parsedType, this._def, nonEmpty);
    };
    Object.defineProperty(ZodArray.prototype, "element", {
        get: function () {
            return this._def.type;
        },
        enumerable: false,
        configurable: true
    });
    ZodArray.create = function (schema) {
        return new ZodArray({
            type: schema,
            minLength: null,
            maxLength: null,
        });
    };
    return ZodArray;
}(ZodType));
var ZodNonEmptyArray = /** @class */ (function (_super) {
    __extends(ZodNonEmptyArray, _super);
    function ZodNonEmptyArray() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.min = function (minLength, message) {
            return new ZodNonEmptyArray(__assign(__assign({}, _this._def), { minLength: { value: minLength, message: errorUtil.toString(message) } }));
        };
        _this.max = function (maxLength, message) {
            return new ZodNonEmptyArray(__assign(__assign({}, _this._def), { maxLength: { value: maxLength, message: errorUtil.toString(message) } }));
        };
        _this.length = function (len, message) {
            return _this.min(len, message).max(len, message);
        };
        return _this;
    }
    ZodNonEmptyArray.prototype._parse = function (ctx, data, parsedType) {
        var nonEmpty = true;
        return parseArray(ctx, data, parsedType, this._def, nonEmpty);
    };
    ZodNonEmptyArray.create = function (schema) {
        return new ZodNonEmptyArray({
            type: schema,
            minLength: null,
            maxLength: null,
        });
    };
    return ZodNonEmptyArray;
}(ZodType));
/////////////////////////////////////////
/////////////////////////////////////////
//////////                     //////////
//////////      ZodObject      //////////
//////////                     //////////
/////////////////////////////////////////
/////////////////////////////////////////
var objectUtil;
(function (objectUtil) {
    objectUtil.mergeShapes = function (first, second) {
        return __assign(__assign({}, first), second);
    };
    objectUtil.intersectShapes = function (first, second) {
        var e_5, _a;
        var firstKeys = Object.keys(first);
        var secondKeys = Object.keys(second);
        var sharedKeys = firstKeys.filter(function (k) { return secondKeys.indexOf(k) !== -1; });
        var sharedShape = {};
        try {
            for (var sharedKeys_1 = __values(sharedKeys), sharedKeys_1_1 = sharedKeys_1.next(); !sharedKeys_1_1.done; sharedKeys_1_1 = sharedKeys_1.next()) {
                var k = sharedKeys_1_1.value;
                sharedShape[k] = ZodIntersection.create(first[k], second[k]);
            }
        }
        catch (e_5_1) { e_5 = { error: e_5_1 }; }
        finally {
            try {
                if (sharedKeys_1_1 && !sharedKeys_1_1.done && (_a = sharedKeys_1.return)) _a.call(sharedKeys_1);
            }
            finally { if (e_5) throw e_5.error; }
        }
        return __assign(__assign(__assign({}, first), second), sharedShape);
    };
})(objectUtil || (objectUtil = {}));
var mergeObjects = function (first) { return function (second) {
    var mergedShape = objectUtil.mergeShapes(first._def.shape(), second._def.shape());
    var merged = new ZodObject({
        // effects: [...(first._def.effects || []), ...(second._def.effects || [])],
        unknownKeys: first._def.unknownKeys,
        catchall: first._def.catchall,
        shape: function () { return mergedShape; },
    });
    return merged;
}; };
var AugmentFactory = function (def) { return function (augmentation) {
    return new ZodObject(__assign(__assign({}, def), { shape: function () { return (__assign(__assign({}, def.shape()), augmentation)); } }));
}; };
var ZodObject = /** @class */ (function (_super) {
    __extends(ZodObject, _super);
    function ZodObject() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._cached = null;
        _this.strict = function () {
            return new ZodObject(__assign(__assign({}, _this._def), { unknownKeys: "strict" }));
        };
        _this.strip = function () {
            return new ZodObject(__assign(__assign({}, _this._def), { unknownKeys: "strip" }));
        };
        _this.passthrough = function () {
            return new ZodObject(__assign(__assign({}, _this._def), { unknownKeys: "passthrough" }));
        };
        /**
         * @deprecated In most cases, this is no longer needed - unknown properties are now silently stripped.
         * If you want to pass through unknown properies, use `.passthrough()` instead.
         */
        _this.nonstrict = _this.passthrough;
        _this.augment = AugmentFactory(_this._def);
        _this.extend = AugmentFactory(_this._def);
        _this.setKey = function (key, schema) {
            var _a;
            return _this.augment((_a = {}, _a[key] = schema, _a));
        };
        /**
         * Prior to zod@1.0.12 there was a bug in the
         * inferred type of merged objects. Please
         * upgrade if you are experiencing issues.
         */
        _this.merge = function (merging) {
            var mergedShape = objectUtil.mergeShapes(_this._def.shape(), merging._def.shape());
            var merged = new ZodObject({
                // effects: [], // wipe all refinements
                unknownKeys: merging._def.unknownKeys,
                catchall: merging._def.catchall,
                shape: function () { return mergedShape; },
            });
            return merged;
        };
        _this.catchall = function (index) {
            return new ZodObject(__assign(__assign({}, _this._def), { catchall: index }));
        };
        _this.pick = function (mask) {
            var shape = {};
            Object.keys(mask).map(function (key) {
                shape[key] = _this.shape[key];
            });
            return new ZodObject(__assign(__assign({}, _this._def), { shape: function () { return shape; } }));
        };
        _this.omit = function (mask) {
            var shape = {};
            Object.keys(_this.shape).map(function (key) {
                if (Object.keys(mask).indexOf(key) === -1) {
                    shape[key] = _this.shape[key];
                }
            });
            return new ZodObject(__assign(__assign({}, _this._def), { shape: function () { return shape; } }));
        };
        _this.partial = function () {
            var newShape = {};
            for (var key in _this.shape) {
                var fieldSchema = _this.shape[key];
                newShape[key] = fieldSchema.isOptional()
                    ? fieldSchema
                    : fieldSchema.optional();
            }
            return new ZodObject(__assign(__assign({}, _this._def), { shape: function () { return newShape; } }));
        };
        _this.deepPartial = function () {
            var newShape = {};
            for (var key in _this.shape) {
                var fieldSchema = _this.shape[key];
                if (fieldSchema instanceof ZodObject) {
                    newShape[key] = fieldSchema.isOptional()
                        ? fieldSchema
                        : fieldSchema.deepPartial().optional();
                }
                else {
                    newShape[key] = fieldSchema.isOptional()
                        ? fieldSchema
                        : fieldSchema.optional();
                }
            }
            return new ZodObject(__assign(__assign({}, _this._def), { shape: function () { return newShape; } }));
        };
        _this.required = function () {
            var newShape = {};
            for (var key in _this.shape) {
                var fieldSchema = _this.shape[key];
                var newField = fieldSchema;
                while (newField instanceof ZodOptional) {
                    newField = newField._def.innerType;
                }
                newShape[key] = newField;
            }
            return new ZodObject(__assign(__assign({}, _this._def), { shape: function () { return newShape; } }));
        };
        return _this;
    }
    ZodObject.prototype._getCached = function () {
        if (this._cached !== null)
            return this._cached;
        var shape = this._def.shape();
        var keys = Object.keys(shape);
        return (this._cached = { shape: shape, keys: keys });
    };
    ZodObject.prototype._parse = function (ctx, data, parsedType) {
        var e_6, _a, e_7, _b, e_8, _c;
        if (parsedType !== ZodParsedType.object) {
            ctx.addIssue(data, {
                code: ZodIssueCode.invalid_type,
                expected: ZodParsedType.object,
                received: parsedType,
            });
            return INVALID;
        }
        var _d = this._getCached(), shape = _d.shape, shapeKeys = _d.keys;
        var invalid = false;
        var tasks = createTasks(ctx);
        var resultObject = {};
        var handleParsed = function (key, parsedValue) {
            if (isOk(parsedValue)) {
                var value = parsedValue.value;
                if (typeof value !== "undefined" || key in data) {
                    // key was valid but result was undefined: add it to the result object
                    // only if key was in the input data object - if it wasn't, then it's
                    // an optional key that should not be added
                    resultObject[key] = value;
                }
            }
            else if (isInvalid(parsedValue)) {
                invalid = true;
            }
            else {
                tasks === null || tasks === void 0 ? void 0 : tasks.push(parsedValue.promise.then(function (parsed) { return handleParsed(key, parsed); }));
            }
        };
        try {
            for (var shapeKeys_1 = __values(shapeKeys), shapeKeys_1_1 = shapeKeys_1.next(); !shapeKeys_1_1.done; shapeKeys_1_1 = shapeKeys_1.next()) {
                var key = shapeKeys_1_1.value;
                var keyValidator = shape[key];
                var value = data[key];
                handleParsed(key, keyValidator._parse(ctx.stepInto(key), value, getParsedType(value)));
            }
        }
        catch (e_6_1) { e_6 = { error: e_6_1 }; }
        finally {
            try {
                if (shapeKeys_1_1 && !shapeKeys_1_1.done && (_a = shapeKeys_1.return)) _a.call(shapeKeys_1);
            }
            finally { if (e_6) throw e_6.error; }
        }
        if (this._def.catchall instanceof ZodNever) {
            var unknownKeys = this._def.unknownKeys;
            if (unknownKeys === "passthrough") {
                var dataKeys = Object.keys(data);
                var extraKeys = dataKeys.filter(function (k) { return !(k in shape); });
                try {
                    for (var extraKeys_1 = __values(extraKeys), extraKeys_1_1 = extraKeys_1.next(); !extraKeys_1_1.done; extraKeys_1_1 = extraKeys_1.next()) {
                        var key = extraKeys_1_1.value;
                        resultObject[key] = data[key];
                    }
                }
                catch (e_7_1) { e_7 = { error: e_7_1 }; }
                finally {
                    try {
                        if (extraKeys_1_1 && !extraKeys_1_1.done && (_b = extraKeys_1.return)) _b.call(extraKeys_1);
                    }
                    finally { if (e_7) throw e_7.error; }
                }
            }
            else if (unknownKeys === "strict") {
                var dataKeys = Object.keys(data);
                var extraKeys = dataKeys.filter(function (k) { return !(k in shape); });
                if (extraKeys.length > 0) {
                    invalid = true;
                    ctx.addIssue(data, {
                        code: ZodIssueCode.unrecognized_keys,
                        keys: extraKeys,
                    });
                }
            }
            else if (unknownKeys === "strip") ;
            else {
                throw new Error("Internal ZodObject error: invalid unknownKeys value.");
            }
        }
        else {
            // run catchall validation
            var catchall = this._def.catchall;
            var dataKeys = Object.keys(data);
            var extraKeys = dataKeys.filter(function (k) { return !(k in shape); });
            try {
                for (var extraKeys_2 = __values(extraKeys), extraKeys_2_1 = extraKeys_2.next(); !extraKeys_2_1.done; extraKeys_2_1 = extraKeys_2.next()) {
                    var key = extraKeys_2_1.value;
                    var value = data[key];
                    handleParsed(key, catchall._parse(ctx.stepInto(key), value, getParsedType(value)));
                }
            }
            catch (e_8_1) { e_8 = { error: e_8_1 }; }
            finally {
                try {
                    if (extraKeys_2_1 && !extraKeys_2_1.done && (_c = extraKeys_2.return)) _c.call(extraKeys_2);
                }
                finally { if (e_8) throw e_8.error; }
            }
        }
        if (tasks !== null && tasks.length > 0) {
            return ASYNC(Promise.all(tasks).then(function () {
                return invalid ? INVALID : OK(resultObject);
            }));
        }
        else {
            return invalid ? INVALID : OK(resultObject);
        }
    };
    Object.defineProperty(ZodObject.prototype, "shape", {
        get: function () {
            return this._def.shape();
        },
        enumerable: false,
        configurable: true
    });
    ZodObject.create = function (shape) {
        return new ZodObject({
            shape: function () { return shape; },
            unknownKeys: "strip",
            catchall: ZodNever.create(),
        });
    };
    ZodObject.strictCreate = function (shape) {
        return new ZodObject({
            shape: function () { return shape; },
            unknownKeys: "strict",
            catchall: ZodNever.create(),
        });
    };
    ZodObject.lazycreate = function (shape) {
        return new ZodObject({
            shape: shape,
            unknownKeys: "strip",
            catchall: ZodNever.create(),
        });
    };
    return ZodObject;
}(ZodType));
// export type toOpts<T> = T extends ZodUnionOptions ? T : never;
// export type ZodUnionType<
//   A extends ZodTypeAny,
//   B extends ZodTypeAny
// > = A extends ZodUnion<infer AOpts>
//   ? B extends ZodUnion<infer BOpts>
//     ? ZodUnion<toOpts<[...AOpts, ...BOpts]>>
//     : ZodUnion<toOpts<[...AOpts, B]>>
//   : B extends ZodUnion<infer BOpts>
//   ? ZodUnion<toOpts<[A, ...BOpts]>>
//   : ZodUnion<toOpts<[A, B]>>;
var ZodUnion = /** @class */ (function (_super) {
    __extends(ZodUnion, _super);
    function ZodUnion() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodUnion.prototype._parse = function (ctx, data, parsedType) {
        var e_9, _a;
        var options = this._def.options;
        var noMatch = function (allIssues) {
            var unionErrors = allIssues.map(function (issues) { return new ZodError(issues); });
            var nonTypeErrors = unionErrors.filter(function (err) {
                return err.issues[0].code !== "invalid_type";
            });
            if (nonTypeErrors.length === 1) {
                // TODO encapsulate
                nonTypeErrors[0].issues.forEach(function (issue) { return ctx.issues.push(issue); });
            }
            else {
                ctx.addIssue(data, {
                    code: ZodIssueCode.invalid_union,
                    unionErrors: unionErrors,
                });
            }
            return INVALID;
        };
        if (ctx.params.async) {
            var contexts_1 = options.map(function () { return new ParseContext(ctx.path, [], ctx.params); });
            return PseudoPromise.all(options.map(function (option, index) {
                return option._parse(contexts_1[index], data, parsedType);
            })).then(function (parsedOptions) {
                var e_10, _a;
                try {
                    for (var parsedOptions_1 = __values(parsedOptions), parsedOptions_1_1 = parsedOptions_1.next(); !parsedOptions_1_1.done; parsedOptions_1_1 = parsedOptions_1.next()) {
                        var parsedOption = parsedOptions_1_1.value;
                        if (isOk(parsedOption)) {
                            return parsedOption;
                        }
                    }
                }
                catch (e_10_1) { e_10 = { error: e_10_1 }; }
                finally {
                    try {
                        if (parsedOptions_1_1 && !parsedOptions_1_1.done && (_a = parsedOptions_1.return)) _a.call(parsedOptions_1);
                    }
                    finally { if (e_10) throw e_10.error; }
                }
                return noMatch(contexts_1.map(function (ctx) { return ctx.issues; }));
            });
        }
        else {
            var allIssues = [];
            try {
                for (var options_1 = __values(options), options_1_1 = options_1.next(); !options_1_1.done; options_1_1 = options_1.next()) {
                    var option = options_1_1.value;
                    var optionCtx = new ParseContext(ctx.path, [], ctx.params);
                    var parsedOption = option._parseSync(optionCtx, data, parsedType);
                    if (isInvalid(parsedOption)) {
                        allIssues.push(optionCtx.issues);
                    }
                    else {
                        return parsedOption;
                    }
                }
            }
            catch (e_9_1) { e_9 = { error: e_9_1 }; }
            finally {
                try {
                    if (options_1_1 && !options_1_1.done && (_a = options_1.return)) _a.call(options_1);
                }
                finally { if (e_9) throw e_9.error; }
            }
            return noMatch(allIssues);
        }
    };
    Object.defineProperty(ZodUnion.prototype, "options", {
        get: function () {
            return this._def.options;
        },
        enumerable: false,
        configurable: true
    });
    ZodUnion.create = function (types) {
        return new ZodUnion({
            options: types,
        });
    };
    return ZodUnion;
}(ZodType));
function mergeValues(a, b) {
    var e_11, _a;
    var aType = getParsedType(a);
    var bType = getParsedType(b);
    if (a === b) {
        return { valid: true, data: a };
    }
    else if (aType === ZodParsedType.object && bType === ZodParsedType.object) {
        var bKeysSet_1 = new Set(Object.keys(b));
        var sharedKeys = Object.keys(a).filter(function (key) { return bKeysSet_1.has(key); });
        var newObj = __assign(__assign({}, a), b);
        try {
            for (var sharedKeys_2 = __values(sharedKeys), sharedKeys_2_1 = sharedKeys_2.next(); !sharedKeys_2_1.done; sharedKeys_2_1 = sharedKeys_2.next()) {
                var key = sharedKeys_2_1.value;
                var sharedValue = mergeValues(a[key], b[key]);
                if (!sharedValue.valid) {
                    return { valid: false };
                }
                newObj[key] = sharedValue.data;
            }
        }
        catch (e_11_1) { e_11 = { error: e_11_1 }; }
        finally {
            try {
                if (sharedKeys_2_1 && !sharedKeys_2_1.done && (_a = sharedKeys_2.return)) _a.call(sharedKeys_2);
            }
            finally { if (e_11) throw e_11.error; }
        }
        return { valid: true, data: newObj };
    }
    else {
        return { valid: false };
    }
}
var ZodIntersection = /** @class */ (function (_super) {
    __extends(ZodIntersection, _super);
    function ZodIntersection() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodIntersection.prototype._parse = function (ctx, data, parsedType) {
        var handleParsed = function (parsedLeft, parsedRight) {
            if (isInvalid(parsedLeft) || isInvalid(parsedRight)) {
                return INVALID;
            }
            var merged = mergeValues(parsedLeft.value, parsedRight.value);
            if (!merged.valid) {
                ctx.addIssue(data, {
                    code: ZodIssueCode.invalid_intersection_types,
                });
                return INVALID;
            }
            return OK(merged.data);
        };
        if (ctx.params.async) {
            return PseudoPromise.all([
                this._def.left._parse(ctx, data, parsedType),
                this._def.right._parse(ctx, data, parsedType),
            ]).then(function (_a) {
                var _b = __read(_a, 2), left = _b[0], right = _b[1];
                return handleParsed(left, right);
            });
        }
        else {
            return handleParsed(this._def.left._parseSync(ctx, data, parsedType), this._def.right._parseSync(ctx, data, parsedType));
        }
    };
    ZodIntersection.create = function (left, right) {
        return new ZodIntersection({
            left: left,
            right: right,
        });
    };
    return ZodIntersection;
}(ZodType));
var ZodTuple = /** @class */ (function (_super) {
    __extends(ZodTuple, _super);
    function ZodTuple() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodTuple.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType !== ZodParsedType.array) {
            ctx.addIssue(data, {
                code: ZodIssueCode.invalid_type,
                expected: ZodParsedType.array,
                received: parsedType,
            });
            return INVALID;
        }
        if (data.length > this._def.items.length) {
            ctx.addIssue(data, {
                code: ZodIssueCode.too_big,
                maximum: this._def.items.length,
                inclusive: true,
                type: "array",
            });
            return INVALID;
        }
        else if (data.length < this._def.items.length) {
            ctx.addIssue(data, {
                code: ZodIssueCode.too_small,
                minimum: this._def.items.length,
                inclusive: true,
                type: "array",
            });
            return INVALID;
        }
        var tasks = createTasks(ctx);
        var items = this._def.items;
        var parseResult = new Array(items.length);
        var invalid = false;
        var handleParsed = function (index, parsedItem) {
            if (isOk(parsedItem)) {
                parseResult[index] = parsedItem.value;
            }
            else if (isInvalid(parsedItem)) {
                invalid = true;
            }
            else {
                tasks === null || tasks === void 0 ? void 0 : tasks.push(parsedItem.promise.then(function (parsed) { return handleParsed(index, parsed); }));
            }
        };
        items.forEach(function (item, index) {
            handleParsed(index, item._parse(ctx.stepInto(index), data[index], getParsedType(data[index])));
        });
        if (tasks !== null && tasks.length > 0) {
            return ASYNC(Promise.all(tasks).then(function () { return (invalid ? INVALID : OK(parseResult)); }));
        }
        else {
            return invalid ? INVALID : OK(parseResult);
        }
    };
    Object.defineProperty(ZodTuple.prototype, "items", {
        get: function () {
            return this._def.items;
        },
        enumerable: false,
        configurable: true
    });
    ZodTuple.create = function (schemas) {
        return new ZodTuple({
            items: schemas,
        });
    };
    return ZodTuple;
}(ZodType));
var ZodRecord = /** @class */ (function (_super) {
    __extends(ZodRecord, _super);
    function ZodRecord() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodRecord.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType !== ZodParsedType.object) {
            ctx.addIssue(data, {
                code: ZodIssueCode.invalid_type,
                expected: ZodParsedType.object,
                received: parsedType,
            });
            return INVALID;
        }
        var tasks = createTasks(ctx);
        var valueType = this._def.valueType;
        var parseResult = {};
        var invalid = false;
        var handleParsed = function (key, parsedKey) {
            if (isOk(parsedKey)) {
                parseResult[key] = parsedKey.value;
            }
            else if (isInvalid(parsedKey)) {
                invalid = true;
            }
            else {
                tasks === null || tasks === void 0 ? void 0 : tasks.push(parsedKey.promise.then(function (parsed) { return handleParsed(key, parsed); }));
            }
        };
        for (var key in data) {
            handleParsed(key, valueType._parse(ctx.stepInto(key), data[key], getParsedType(data[key])));
        }
        if (tasks !== null && tasks.length > 0) {
            return ASYNC(Promise.all(tasks).then(function () { return (invalid ? INVALID : OK(parseResult)); }));
        }
        else {
            return invalid ? INVALID : OK(parseResult);
        }
    };
    ZodRecord.create = function (valueType) {
        return new ZodRecord({
            valueType: valueType,
        });
    };
    return ZodRecord;
}(ZodType));
var ZodMap = /** @class */ (function (_super) {
    __extends(ZodMap, _super);
    function ZodMap() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodMap.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType !== ZodParsedType.map) {
            ctx.addIssue(data, {
                code: ZodIssueCode.invalid_type,
                expected: ZodParsedType.map,
                received: parsedType,
            });
            return INVALID;
        }
        var keyType = this._def.keyType;
        var valueType = this._def.valueType;
        var dataMap = data;
        var parseResult = new Map();
        var tasks = createTasks(ctx);
        var invalid = false;
        var handleParsed = function (parsedKey, parsedValue) {
            if (isAsync(parsedKey) || isAsync(parsedValue)) {
                tasks === null || tasks === void 0 ? void 0 : tasks.push(PseudoPromise.all([parsedKey, parsedValue]).promise.then(function (_a) {
                    var _b = __read(_a, 2), k = _b[0], v = _b[1];
                    return handleParsed(k, v);
                }));
            }
            else if (isInvalid(parsedKey) || isInvalid(parsedValue)) {
                invalid = true;
            }
            else {
                parseResult.set(parsedKey.value, parsedValue.value);
            }
        };
        __spreadArray([], __read(dataMap.entries())).forEach(function (_a, index) {
            var _b = __read(_a, 2), key = _b[0], value = _b[1];
            var entryCtx = ctx.stepInto(index);
            var parsedKey = keyType._parse(entryCtx.stepInto("key"), key, getParsedType(key));
            var parsedValue = valueType._parse(entryCtx.stepInto("value"), value, getParsedType(value));
            handleParsed(parsedKey, parsedValue);
        });
        if (tasks !== null && tasks.length > 0) {
            return ASYNC(Promise.all(tasks).then(function () { return (invalid ? INVALID : OK(parseResult)); }));
        }
        else {
            return invalid ? INVALID : OK(parseResult);
        }
    };
    ZodMap.create = function (keyType, valueType) {
        return new ZodMap({
            valueType: valueType,
            keyType: keyType,
        });
    };
    return ZodMap;
}(ZodType));
var ZodSet = /** @class */ (function (_super) {
    __extends(ZodSet, _super);
    function ZodSet() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodSet.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType !== ZodParsedType.set) {
            ctx.addIssue(data, {
                code: ZodIssueCode.invalid_type,
                expected: ZodParsedType.set,
                received: parsedType,
            });
            return INVALID;
        }
        var dataSet = data;
        var valueType = this._def.valueType;
        var parsedSet = new Set();
        var tasks = createTasks(ctx);
        var invalid = false;
        var handleParsed = function (parsedItem) {
            if (isOk(parsedItem)) {
                parsedSet.add(parsedItem.value);
            }
            else if (isInvalid(parsedItem)) {
                invalid = true;
            }
            else {
                tasks === null || tasks === void 0 ? void 0 : tasks.push(parsedItem.promise.then(function (parsed) { return handleParsed(parsed); }));
            }
        };
        __spreadArray([], __read(dataSet.values())).forEach(function (item, i) {
            return handleParsed(valueType._parse(ctx.stepInto(i), item, getParsedType(item)));
        });
        if (tasks !== null && tasks.length > 0) {
            return ASYNC(Promise.all(tasks).then(function () { return (invalid ? INVALID : OK(parsedSet)); }));
        }
        else {
            return invalid ? INVALID : OK(parsedSet);
        }
    };
    ZodSet.create = function (valueType) {
        return new ZodSet({
            valueType: valueType,
        });
    };
    return ZodSet;
}(ZodType));
var ZodFunction = /** @class */ (function (_super) {
    __extends(ZodFunction, _super);
    function ZodFunction() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.args = function () {
            var items = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                items[_i] = arguments[_i];
            }
            return new ZodFunction(__assign(__assign({}, _this._def), { args: ZodTuple.create(items) }));
        };
        _this.returns = function (returnType) {
            return new ZodFunction(__assign(__assign({}, _this._def), { returns: returnType }));
        };
        _this.implement = function (func) {
            var validatedFunc = _this.parse(func);
            return validatedFunc;
        };
        _this.strictImplement = function (func) {
            var validatedFunc = _this.parse(func);
            return validatedFunc;
        };
        _this.validate = _this.implement;
        return _this;
    }
    ZodFunction.prototype._parse = function (ctx, data, parsedType) {
        var _this = this;
        if (parsedType !== ZodParsedType.function) {
            ctx.addIssue(data, {
                code: ZodIssueCode.invalid_type,
                expected: ZodParsedType.function,
                received: parsedType,
            });
            return INVALID;
        }
        var handleArgs = function (args, parsedArgs) {
            if (!parsedArgs.success) {
                var issue = makeIssue(args, pathToArray(ctx.path), ctx.params.errorMap, {
                    code: ZodIssueCode.invalid_arguments,
                    argumentsError: parsedArgs.error,
                });
                throw new ZodError([issue]);
            }
            return parsedArgs.data;
        };
        var handleReturns = function (returns, parsedReturns) {
            if (!parsedReturns.success) {
                var issue = makeIssue(returns, pathToArray(ctx.path), ctx.params.errorMap, {
                    code: ZodIssueCode.invalid_return_type,
                    returnTypeError: parsedReturns.error,
                });
                throw new ZodError([issue]);
            }
            return parsedReturns.data;
        };
        var params = { errorMap: ctx.params.errorMap };
        var fn = data;
        if (this._def.returns instanceof ZodPromise) {
            return OK(function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                return __awaiter(_this, void 0, void 0, function () {
                    var parsedArgs, _a, _b, result, _c, _d;
                    return __generator(this, function (_e) {
                        switch (_e.label) {
                            case 0:
                                _a = handleArgs;
                                _b = [args];
                                return [4 /*yield*/, this._def.args.spa(args, params)];
                            case 1:
                                parsedArgs = _a.apply(void 0, _b.concat([_e.sent()]));
                                return [4 /*yield*/, fn.apply(void 0, __spreadArray([], __read(parsedArgs)))];
                            case 2:
                                result = _e.sent();
                                _c = handleReturns;
                                _d = [result];
                                return [4 /*yield*/, this._def.returns.spa(result, params)];
                            case 3: return [2 /*return*/, _c.apply(void 0, _d.concat([_e.sent()]))];
                        }
                    });
                });
            });
        }
        else {
            return OK(function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                var parsedArgs = handleArgs(args, _this._def.args.safeParse(args, params));
                var result = fn.apply(void 0, __spreadArray([], __read(parsedArgs)));
                return handleReturns(result, _this._def.returns.safeParse(result, params));
            });
        }
    };
    ZodFunction.prototype.parameters = function () {
        return this._def.args;
    };
    ZodFunction.prototype.returnType = function () {
        return this._def.returns;
    };
    ZodFunction.create = function (args, returns) {
        return new ZodFunction({
            args: args || ZodTuple.create([]),
            returns: returns || ZodUnknown.create(),
        });
    };
    return ZodFunction;
}(ZodType));
var ZodLazy = /** @class */ (function (_super) {
    __extends(ZodLazy, _super);
    function ZodLazy() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(ZodLazy.prototype, "schema", {
        get: function () {
            return this._def.getter();
        },
        enumerable: false,
        configurable: true
    });
    ZodLazy.prototype._parse = function (ctx, data, parsedType) {
        var lazySchema = this._def.getter();
        return lazySchema._parse(ctx, data, parsedType);
    };
    ZodLazy.create = function (getter) {
        return new ZodLazy({
            getter: getter,
        });
    };
    return ZodLazy;
}(ZodType));
var ZodLiteral = /** @class */ (function (_super) {
    __extends(ZodLiteral, _super);
    function ZodLiteral() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodLiteral.prototype._parse = function (ctx, data, _parsedType) {
        if (data !== this._def.value) {
            ctx.addIssue(data, {
                code: ZodIssueCode.invalid_type,
                expected: this._def.value,
                received: data,
            });
            return INVALID;
        }
        return OK(data);
    };
    ZodLiteral.create = function (value) {
        return new ZodLiteral({
            value: value,
        });
    };
    return ZodLiteral;
}(ZodType));
var ZodEnum = /** @class */ (function (_super) {
    __extends(ZodEnum, _super);
    function ZodEnum() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodEnum.prototype._parse = function (ctx, data, _parsedType) {
        if (this._def.values.indexOf(data) === -1) {
            ctx.addIssue(data, {
                code: ZodIssueCode.invalid_enum_value,
                options: this._def.values,
            });
            return INVALID;
        }
        return OK(data);
    };
    Object.defineProperty(ZodEnum.prototype, "options", {
        get: function () {
            return this._def.values;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ZodEnum.prototype, "enum", {
        get: function () {
            var e_12, _a;
            var enumValues = {};
            try {
                for (var _b = __values(this._def.values), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var val = _c.value;
                    enumValues[val] = val;
                }
            }
            catch (e_12_1) { e_12 = { error: e_12_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_12) throw e_12.error; }
            }
            return enumValues;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ZodEnum.prototype, "Values", {
        get: function () {
            var e_13, _a;
            var enumValues = {};
            try {
                for (var _b = __values(this._def.values), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var val = _c.value;
                    enumValues[val] = val;
                }
            }
            catch (e_13_1) { e_13 = { error: e_13_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_13) throw e_13.error; }
            }
            return enumValues;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ZodEnum.prototype, "Enum", {
        get: function () {
            var e_14, _a;
            var enumValues = {};
            try {
                for (var _b = __values(this._def.values), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var val = _c.value;
                    enumValues[val] = val;
                }
            }
            catch (e_14_1) { e_14 = { error: e_14_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_14) throw e_14.error; }
            }
            return enumValues;
        },
        enumerable: false,
        configurable: true
    });
    ZodEnum.create = function (values) {
        return new ZodEnum({
            values: values,
        });
    };
    return ZodEnum;
}(ZodType));
var ZodNativeEnum = /** @class */ (function (_super) {
    __extends(ZodNativeEnum, _super);
    function ZodNativeEnum() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodNativeEnum.prototype._parse = function (ctx, data, _parsedType) {
        var nativeEnumValues = util.getValidEnumValues(this._def.values);
        if (nativeEnumValues.indexOf(data) === -1) {
            ctx.addIssue(data, {
                code: ZodIssueCode.invalid_enum_value,
                options: util.objectValues(nativeEnumValues),
            });
            return INVALID;
        }
        return OK(data);
    };
    ZodNativeEnum.create = function (values) {
        return new ZodNativeEnum({
            values: values,
        });
    };
    return ZodNativeEnum;
}(ZodType));
var ZodPromise = /** @class */ (function (_super) {
    __extends(ZodPromise, _super);
    function ZodPromise() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodPromise.prototype._parse = function (ctx, data, parsedType) {
        var _this = this;
        if (parsedType !== ZodParsedType.promise && ctx.params.async === false) {
            ctx.addIssue(data, {
                code: ZodIssueCode.invalid_type,
                expected: ZodParsedType.promise,
                received: parsedType,
            });
            return INVALID;
        }
        var promisified = parsedType === ZodParsedType.promise ? data : Promise.resolve(data);
        return OK(promisified.then(function (data) {
            return _this._def.type.parseAsync(data, {
                path: pathToArray(ctx.path),
                errorMap: ctx.params.errorMap,
            });
        }));
    };
    ZodPromise.create = function (schema) {
        return new ZodPromise({
            type: schema,
        });
    };
    return ZodPromise;
}(ZodType));
var ZodEffects = /** @class */ (function (_super) {
    __extends(ZodEffects, _super);
    function ZodEffects(def) {
        return _super.call(this, def) || this;
        // if (def.schema instanceof ZodEffects) {
        //   throw new Error("ZodEffects cannot be nested.");
        // }
    }
    ZodEffects.prototype.innerType = function () {
        return this._def.schema;
    };
    ZodEffects.prototype._parse = function (ctx, data, parsedType) {
        var isSync = ctx.params.async === false;
        var effects = this._def.effects || [];
        var checkCtx = {
            addIssue: function (arg) {
                ctx.addIssue(data, arg);
            },
            get path() {
                return pathToArray(ctx.path);
            },
        };
        var invalid = false;
        var applyEffect = function (acc, effect) {
            switch (effect.type) {
                case "refinement":
                    var result = effect.refinement(acc, checkCtx);
                    if (result instanceof Promise) {
                        if (isSync) {
                            throw new Error("You can't use .parse() on a schema containing async refinements. Use .parseAsync instead.");
                        }
                        else {
                            return result.then(function (res) {
                                invalid = invalid || !res;
                                return acc;
                            });
                        }
                    }
                    else {
                        invalid = invalid || !result;
                        return acc;
                    }
                case "transform":
                    var transformed = effect.transform(acc);
                    if (transformed instanceof Promise && isSync) {
                        throw new Error("You can't use .parse() on a schema containing async transformations. Use .parseAsync instead.");
                    }
                    return transformed;
                default:
                    throw new Error("Invalid effect type.");
            }
        };
        if (isSync) {
            var base = this._def.schema._parseSync(ctx, data, parsedType);
            if (isOk(base)) {
                var result = effects.reduce(applyEffect, base.value);
                return invalid ? INVALID : OK(result);
            }
            else {
                return INVALID;
            }
        }
        else {
            var applyAsyncEffects_1 = function (base) {
                var result = effects.reduce(function (acc, eff) {
                    return acc instanceof Promise
                        ? acc.then(function (val) { return applyEffect(val, eff); })
                        : applyEffect(acc, eff);
                }, base);
                if (result instanceof Promise) {
                    return ASYNC(result.then(function (val) { return (invalid ? INVALID : OK(val)); }));
                }
                else {
                    return invalid ? INVALID : OK(result);
                }
            };
            var baseResult = this._def.schema._parse(ctx, data, parsedType);
            if (isOk(baseResult)) {
                return applyAsyncEffects_1(baseResult.value);
            }
            else if (isInvalid(baseResult)) {
                return INVALID;
            }
            else {
                return ASYNC(baseResult.promise.then(function (base) {
                    if (isInvalid(base))
                        return INVALID;
                    var result = applyAsyncEffects_1(base.value);
                    return isAsync(result) ? result.promise : result;
                }));
            }
        }
    };
    ZodEffects.create = function (schema) {
        var newTx = new ZodEffects({
            schema: schema,
        });
        return newTx;
    };
    return ZodEffects;
}(ZodType));
var ZodOptional = /** @class */ (function (_super) {
    __extends(ZodOptional, _super);
    function ZodOptional() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodOptional.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType === ZodParsedType.undefined) {
            return OK(undefined);
        }
        return this._def.innerType._parse(ctx, data, parsedType);
    };
    ZodOptional.prototype.unwrap = function () {
        return this._def.innerType;
    };
    ZodOptional.create = function (type) {
        return new ZodOptional({
            innerType: type,
        });
    };
    return ZodOptional;
}(ZodType));
var ZodNullable = /** @class */ (function (_super) {
    __extends(ZodNullable, _super);
    function ZodNullable() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodNullable.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType === ZodParsedType.null) {
            return OK(null);
        }
        return this._def.innerType._parse(ctx, data, parsedType);
    };
    ZodNullable.prototype.unwrap = function () {
        return this._def.innerType;
    };
    ZodNullable.create = function (type) {
        return new ZodNullable({
            innerType: type,
        });
    };
    return ZodNullable;
}(ZodType));
var ZodDefault = /** @class */ (function (_super) {
    __extends(ZodDefault, _super);
    function ZodDefault() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodDefault.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType === ZodParsedType.undefined) {
            data = this._def.defaultValue();
        }
        return this._def.innerType._parse(ctx, data, getParsedType(data));
    };
    ZodDefault.prototype.removeDefault = function () {
        return this._def.innerType;
    };
    ZodDefault.create = function (type) {
        return new ZodOptional({
            innerType: type,
        });
    };
    return ZodDefault;
}(ZodType));
var custom = function (check, params) {
    if (check)
        return ZodAny.create().refine(check, params);
    return ZodAny.create();
};
var late = {
    object: ZodObject.lazycreate,
};
var instanceOfType = function (cls, params) {
    if (params === void 0) { params = {
        message: "Input not instance of " + cls.name,
    }; }
    return custom(function (data) { return data instanceof cls; }, params);
};
var stringType = ZodString.create;
var numberType = ZodNumber.create;
var bigIntType = ZodBigInt.create;
var booleanType = ZodBoolean.create;
var dateType = ZodDate.create;
var undefinedType = ZodUndefined.create;
var nullType = ZodNull.create;
var anyType = ZodAny.create;
var unknownType = ZodUnknown.create;
var neverType = ZodNever.create;
var voidType = ZodVoid.create;
var arrayType = ZodArray.create;
var objectType = ZodObject.create;
var strictObjectType = ZodObject.strictCreate;
var unionType = ZodUnion.create;
var intersectionType = ZodIntersection.create;
var tupleType = ZodTuple.create;
var recordType = ZodRecord.create;
var mapType = ZodMap.create;
var setType = ZodSet.create;
var functionType = ZodFunction.create;
var lazyType = ZodLazy.create;
var literalType = ZodLiteral.create;
var enumType = ZodEnum.create;
var nativeEnumType = ZodNativeEnum.create;
var promiseType = ZodPromise.create;
var effectsType = ZodEffects.create;
var optionalType = ZodOptional.create;
var nullableType = ZodNullable.create;
var ostring = function () { return stringType().optional(); };
var onumber = function () { return numberType().optional(); };
var oboolean = function () { return booleanType().optional(); };

var external = /*#__PURE__*/Object.freeze({
    __proto__: null,
    ZodParsedType: ZodParsedType,
    getParsedType: getParsedType,
    makeIssue: makeIssue,
    EMPTY_PATH: EMPTY_PATH,
    pathToArray: pathToArray,
    pathFromArray: pathFromArray,
    ParseContext: ParseContext,
    createRootContext: createRootContext$1,
    INVALID: INVALID,
    OK: OK,
    ASYNC: ASYNC,
    isInvalid: isInvalid,
    isOk: isOk,
    isAsync: isAsync,
    ZodType: ZodType,
    ZodString: ZodString,
    ZodNumber: ZodNumber,
    ZodBigInt: ZodBigInt,
    ZodBoolean: ZodBoolean,
    ZodDate: ZodDate,
    ZodUndefined: ZodUndefined,
    ZodNull: ZodNull,
    ZodAny: ZodAny,
    ZodUnknown: ZodUnknown,
    ZodNever: ZodNever,
    ZodVoid: ZodVoid,
    ZodArray: ZodArray,
    ZodNonEmptyArray: ZodNonEmptyArray,
    get objectUtil () { return objectUtil; },
    mergeObjects: mergeObjects,
    ZodObject: ZodObject,
    ZodUnion: ZodUnion,
    ZodIntersection: ZodIntersection,
    ZodTuple: ZodTuple,
    ZodRecord: ZodRecord,
    ZodMap: ZodMap,
    ZodSet: ZodSet,
    ZodFunction: ZodFunction,
    ZodLazy: ZodLazy,
    ZodLiteral: ZodLiteral,
    ZodEnum: ZodEnum,
    ZodNativeEnum: ZodNativeEnum,
    ZodPromise: ZodPromise,
    ZodEffects: ZodEffects,
    ZodTransformer: ZodEffects,
    ZodOptional: ZodOptional,
    ZodNullable: ZodNullable,
    ZodDefault: ZodDefault,
    custom: custom,
    Schema: ZodType,
    ZodSchema: ZodType,
    late: late,
    any: anyType,
    array: arrayType,
    bigint: bigIntType,
    boolean: booleanType,
    date: dateType,
    effect: effectsType,
    'enum': enumType,
    'function': functionType,
    'instanceof': instanceOfType,
    intersection: intersectionType,
    lazy: lazyType,
    literal: literalType,
    map: mapType,
    nativeEnum: nativeEnumType,
    never: neverType,
    'null': nullType,
    nullable: nullableType,
    number: numberType,
    object: objectType,
    oboolean: oboolean,
    onumber: onumber,
    optional: optionalType,
    ostring: ostring,
    promise: promiseType,
    record: recordType,
    set: setType,
    strictObject: strictObjectType,
    string: stringType,
    transformer: effectsType,
    tuple: tupleType,
    'undefined': undefinedType,
    union: unionType,
    unknown: unknownType,
    'void': voidType,
    ZodIssueCode: ZodIssueCode,
    quotelessJson: quotelessJson,
    ZodError: ZodError,
    defaultErrorMap: defaultErrorMap,
    get overrideErrorMap () { return overrideErrorMap; },
    setErrorMap: setErrorMap
});

export { ASYNC, EMPTY_PATH, INVALID, OK, ParseContext, ZodType as Schema, ZodAny, ZodArray, ZodBigInt, ZodBoolean, ZodDate, ZodDefault, ZodEffects, ZodEnum, ZodError, ZodFunction, ZodIntersection, ZodIssueCode, ZodLazy, ZodLiteral, ZodMap, ZodNativeEnum, ZodNever, ZodNonEmptyArray, ZodNull, ZodNullable, ZodNumber, ZodObject, ZodOptional, ZodParsedType, ZodPromise, ZodRecord, ZodType as ZodSchema, ZodSet, ZodString, ZodEffects as ZodTransformer, ZodTuple, ZodType, ZodUndefined, ZodUnion, ZodUnknown, ZodVoid, anyType as any, arrayType as array, bigIntType as bigint, booleanType as boolean, createRootContext$1 as createRootContext, custom, dateType as date, defaultErrorMap, effectsType as effect, enumType as enum, functionType as function, getParsedType, instanceOfType as instanceof, intersectionType as intersection, isAsync, isInvalid, isOk, late, lazyType as lazy, literalType as literal, makeIssue, mapType as map, mergeObjects, nativeEnumType as nativeEnum, neverType as never, nullType as null, nullableType as nullable, numberType as number, objectType as object, objectUtil, oboolean, onumber, optionalType as optional, ostring, overrideErrorMap, pathFromArray, pathToArray, promiseType as promise, quotelessJson, recordType as record, setType as set, setErrorMap, strictObjectType as strictObject, stringType as string, effectsType as transformer, tupleType as tuple, undefinedType as undefined, unionType as union, unknownType as unknown, voidType as void, external as z };
//# sourceMappingURL=index.mjs.map
