import { errorUtil } from "./helpers/errorUtil";
import { ParseContext, ParseParamsNoData, ParseReturnType, SyncParseReturnType, ZodParsedType } from "./helpers/parseUtil";
import { partialUtil } from "./helpers/partialUtil";
import { util } from "./helpers/util";
import { MakeErrorData, StringValidation, ZodCustomIssue, ZodError } from "./ZodError";
export declare type RefinementCtx = {
    addIssue: (arg: MakeErrorData) => void;
    path: (string | number)[];
};
export declare type ZodRawShape = {
    [k: string]: ZodTypeAny;
};
export declare type ZodTypeAny = ZodType<any, any, any>;
export declare type TypeOf<T extends ZodType<any>> = T["_output"];
export declare type input<T extends ZodType<any>> = T["_input"];
export declare type output<T extends ZodType<any>> = T["_output"];
export type { TypeOf as infer };
export declare type CustomErrorParams = Partial<util.Omit<ZodCustomIssue, "code">>;
export interface ZodTypeDef {
}
export declare abstract class ZodType<Output, Def extends ZodTypeDef = ZodTypeDef, Input = Output> {
    readonly _type: Output;
    readonly _output: Output;
    readonly _input: Input;
    readonly _def: Def;
    abstract _parse(_ctx: ParseContext, _data: any, _parsedType: ZodParsedType): ParseReturnType<Output>;
    _parseSync(_ctx: ParseContext, _data: any, _parsedType: ZodParsedType): SyncParseReturnType<Output>;
    parse: (data: unknown, params?: Partial<ParseParamsNoData>) => Output;
    safeParse: (data: unknown, params?: Partial<ParseParamsNoData>) => {
        success: true;
        data: Output;
    } | {
        success: false;
        error: ZodError<Input>;
    };
    parseAsync: (x: unknown, params?: Partial<ParseParamsNoData>) => Promise<Output>;
    safeParseAsync: (x: unknown, params?: Partial<ParseParamsNoData>) => Promise<{
        success: true;
        data: Output;
    } | {
        success: false;
        error: ZodError;
    }>;
    /** Alias of safeParseAsync */
    spa: (x: unknown, params?: Partial<ParseParamsNoData> | undefined) => Promise<{
        success: true;
        data: Output;
    } | {
        success: false;
        error: ZodError;
    }>;
    /** The .is method has been removed in Zod 3. For details see https://github.com/colinhacks/zod/tree/v3. */
    is: never;
    /** The .check method has been removed in Zod 3. For details see https://github.com/colinhacks/zod/tree/v3. */
    check: never;
    refine: <Func extends (arg: Output) => any, This extends this = this>(check: Func, message?: string | CustomErrorParams | ((arg: Output) => CustomErrorParams)) => ZodEffectsType<This>;
    refinement: <This extends this = this>(check: (arg: Output) => any, refinementData: MakeErrorData | ((arg: Output, ctx: RefinementCtx) => MakeErrorData)) => ZodEffectsType<This>;
    _refinement<This extends this>(refinement: InternalCheck<Output>["refinement"]): ZodEffectsType<This>;
    superRefine: <This extends this>(refinement: InternalCheck<Output>["refinement"]) => ZodEffectsType<This>;
    constructor(def: Def);
    optional: <This extends this = this>() => ZodOptional<This>;
    nullable: <This extends this = this>() => ZodNullable<This>;
    nullish: <This extends this = this>() => ZodNullable<ZodOptional<This>>;
    array: () => ZodArray<this>;
    or<T extends ZodTypeAny>(option: T): ZodUnion<[this, T]>;
    and<T extends ZodTypeAny>(incoming: T): ZodIntersection<this, T>;
    transform<NewOut>(transform: (arg: Output) => NewOut | Promise<NewOut>): ZodEffects<this, NewOut>;
    default<This extends this = this>(def: util.noUndefined<Input>): ZodDefault<This>;
    default<This extends this = this>(def: () => util.noUndefined<Input>): ZodDefault<This>;
    isOptional: () => boolean;
    isNullable: () => boolean;
}
declare type ZodStringCheck = {
    kind: "min";
    value: number;
    message?: string;
} | {
    kind: "max";
    value: number;
    message?: string;
} | {
    kind: "email";
    message?: string;
} | {
    kind: "url";
    message?: string;
} | {
    kind: "uuid";
    message?: string;
} | {
    kind: "regex";
    regex: RegExp;
    message?: string;
};
export interface ZodStringDef extends ZodTypeDef {
    checks: ZodStringCheck[];
}
export declare class ZodString extends ZodType<string, ZodStringDef> {
    _parse(ctx: ParseContext, data: string, parsedType: ZodParsedType): ParseReturnType<string>;
    protected _regex: (regex: RegExp, validation: StringValidation, message?: errorUtil.ErrMessage | undefined) => ZodEffectsType<this>;
    email: (message?: errorUtil.ErrMessage | undefined) => ZodString;
    url: (message?: errorUtil.ErrMessage | undefined) => ZodString;
    uuid: (message?: errorUtil.ErrMessage | undefined) => ZodString;
    regex: (regex: RegExp, message?: errorUtil.ErrMessage | undefined) => ZodString;
    min: (minLength: number, message?: errorUtil.ErrMessage | undefined) => ZodString;
    max: (maxLength: number, message?: errorUtil.ErrMessage | undefined) => ZodString;
    length(len: number, message?: errorUtil.ErrMessage): ZodString;
    /**
     * Deprecated.
     * Use z.string().min(1) instead.
     */
    nonempty: (message?: errorUtil.ErrMessage | undefined) => ZodString;
    get isEmail(): boolean;
    get isURL(): boolean;
    get isUUID(): boolean;
    get minLength(): number;
    get maxLength(): null;
    static create: () => ZodString;
}
declare type ZodNumberCheck = {
    kind: "min";
    value: number;
    inclusive: boolean;
    message?: string;
} | {
    kind: "max";
    value: number;
    inclusive: boolean;
    message?: string;
} | {
    kind: "int";
    message?: string;
};
export interface ZodNumberDef extends ZodTypeDef {
    checks: ZodNumberCheck[];
}
export declare class ZodNumber extends ZodType<number, ZodNumberDef> {
    _parse(ctx: ParseContext, data: number, parsedType: ZodParsedType): ParseReturnType<number>;
    static create: () => ZodNumber;
    min: (value: number, message?: errorUtil.ErrMessage | undefined) => ZodNumber;
    max: (value: number, message?: errorUtil.ErrMessage | undefined) => ZodNumber;
    int: (message?: errorUtil.ErrMessage | undefined) => ZodNumber;
    positive: (message?: errorUtil.ErrMessage | undefined) => ZodNumber;
    negative: (message?: errorUtil.ErrMessage | undefined) => ZodNumber;
    nonpositive: (message?: errorUtil.ErrMessage | undefined) => ZodNumber;
    nonnegative: (message?: errorUtil.ErrMessage | undefined) => ZodNumber;
    get minValue(): number | null;
    get maxValue(): number | null;
    get isInt(): boolean;
}
export declare type ZodBigIntDef = ZodTypeDef;
export declare class ZodBigInt extends ZodType<bigint, ZodBigIntDef> {
    _parse(ctx: ParseContext, data: bigint, parsedType: ZodParsedType): ParseReturnType<bigint>;
    static create: () => ZodBigInt;
}
export declare type ZodBooleanDef = ZodTypeDef;
export declare class ZodBoolean extends ZodType<boolean, ZodBooleanDef> {
    _parse(ctx: ParseContext, data: boolean, parsedType: ZodParsedType): ParseReturnType<boolean>;
    static create: () => ZodBoolean;
}
export declare type ZodDateDef = ZodTypeDef;
export declare class ZodDate extends ZodType<Date, ZodDateDef> {
    _parse(ctx: ParseContext, data: Date, parsedType: ZodParsedType): ParseReturnType<Date>;
    static create: () => ZodDate;
}
export declare type ZodUndefinedDef = ZodTypeDef;
export declare class ZodUndefined extends ZodType<undefined> {
    _parse(ctx: ParseContext, data: undefined, parsedType: ZodParsedType): ParseReturnType<undefined>;
    static create: () => ZodUndefined;
}
export declare type ZodNullDef = ZodTypeDef;
export declare class ZodNull extends ZodType<null, ZodNullDef> {
    _parse(ctx: ParseContext, data: null, parsedType: ZodParsedType): ParseReturnType<null>;
    static create: () => ZodNull;
}
export declare type ZodAnyDef = ZodTypeDef;
export declare class ZodAny extends ZodType<any, ZodAnyDef> {
    _parse(_ctx: ParseContext, data: any, _parsedType: ZodParsedType): ParseReturnType<any>;
    static create: () => ZodAny;
}
export declare type ZodUnknownDef = ZodTypeDef;
export declare class ZodUnknown extends ZodType<unknown, ZodUnknownDef> {
    _parse(_ctx: ParseContext, data: any, _parsedType: ZodParsedType): ParseReturnType<unknown>;
    static create: () => ZodUnknown;
}
export declare type ZodNeverDef = ZodTypeDef;
export declare class ZodNever extends ZodType<never, ZodNeverDef> {
    _parse(ctx: ParseContext, data: any, parsedType: ZodParsedType): ParseReturnType<never>;
    static create: () => ZodNever;
}
export declare type ZodVoidDef = ZodTypeDef;
export declare class ZodVoid extends ZodType<void, ZodVoidDef> {
    _parse(ctx: ParseContext, data: any, parsedType: ZodParsedType): ParseReturnType<void>;
    static create: () => ZodVoid;
}
export interface ZodArrayDef<T extends ZodTypeAny = ZodTypeAny> extends ZodTypeDef {
    type: T;
    minLength: {
        value: number;
        message?: string;
    } | null;
    maxLength: {
        value: number;
        message?: string;
    } | null;
}
export declare class ZodArray<T extends ZodTypeAny> extends ZodType<T["_output"][], ZodArrayDef<T>, T["_input"][]> {
    _parse(ctx: ParseContext, data: any, parsedType: ZodParsedType): ParseReturnType<T["_output"][]>;
    get element(): T;
    min: (minLength: number, message?: errorUtil.ErrMessage | undefined) => this;
    max: (maxLength: number, message?: errorUtil.ErrMessage | undefined) => this;
    length: (len: number, message?: errorUtil.ErrMessage | undefined) => this;
    nonempty: () => ZodNonEmptyArray<T>;
    static create: <T_1 extends ZodTypeAny>(schema: T_1) => ZodArray<T_1>;
}
export interface ZodNonEmptyArrayDef<T extends ZodTypeAny = ZodTypeAny> extends ZodTypeDef {
    type: T;
    minLength: {
        value: number;
        message?: string;
    } | null;
    maxLength: {
        value: number;
        message?: string;
    } | null;
}
export declare class ZodNonEmptyArray<T extends ZodTypeAny> extends ZodType<[
    T["_output"],
    ...T["_output"][]
], ZodNonEmptyArrayDef<T>, [
    T["_input"],
    ...T["_input"][]
]> {
    _parse(ctx: ParseContext, data: any, parsedType: ZodParsedType): ParseReturnType<[T["_output"], ...T["_output"][]]>;
    min: (minLength: number, message?: errorUtil.ErrMessage | undefined) => ZodNonEmptyArray<T>;
    max: (maxLength: number, message?: errorUtil.ErrMessage | undefined) => ZodNonEmptyArray<T>;
    length: (len: number, message?: errorUtil.ErrMessage | undefined) => ZodNonEmptyArray<T>;
    static create: <T_1 extends ZodTypeAny>(schema: T_1) => ZodNonEmptyArray<T_1>;
}
export declare namespace objectUtil {
    export type MergeShapes<U extends ZodRawShape, V extends ZodRawShape> = {
        [k in Exclude<keyof U, keyof V>]: U[k];
    } & V;
    type optionalKeys<T extends object> = {
        [k in keyof T]: unknown extends T[k] ? never : undefined extends T[k] ? k : never;
    }[keyof T];
    type requiredKeys<T extends object> = Exclude<keyof T, optionalKeys<T>>;
    export type addQuestionMarks<T extends object> = {
        [k in optionalKeys<T>]?: T[k];
    } & {
        [k in requiredKeys<T>]: T[k];
    };
    export type identity<T> = T;
    export type flatten<T extends object> = identity<{
        [k in keyof T]: T[k];
    }>;
    export type noNeverKeys<T extends ZodRawShape> = {
        [k in keyof T]: [T[k]] extends [never] ? never : k;
    }[keyof T];
    export type noNever<T extends ZodRawShape> = identity<{
        [k in noNeverKeys<T>]: k extends keyof T ? T[k] : never;
    }>;
    export const mergeShapes: <U extends ZodRawShape, T extends ZodRawShape>(first: U, second: T) => T & U;
    export const intersectShapes: <U extends ZodRawShape, T extends ZodRawShape>(first: U, second: T) => T & U;
    export {};
}
export declare const mergeObjects: <First extends AnyZodObject>(first: First) => <Second extends AnyZodObject>(second: Second) => ZodObject<First["_shape"] & Second["_shape"], First["_unknownKeys"], First["_catchall"], objectOutputType<First["_shape"] & Second["_shape"], First["_catchall"]>, objectInputType<First["_shape"] & Second["_shape"], First["_catchall"]>>;
declare type extend<A, B> = {
    [k in Exclude<keyof A, keyof B>]: A[k];
} & {
    [k in keyof B]: B[k];
};
declare type UnknownKeysParam = "passthrough" | "strict" | "strip";
export declare type Primitive = string | number | bigint | boolean | null | undefined;
export declare type Scalars = Primitive | Primitive[];
export interface ZodObjectDef<T extends ZodRawShape = ZodRawShape, UnknownKeys extends UnknownKeysParam = UnknownKeysParam, Catchall extends ZodTypeAny = ZodTypeAny> extends ZodTypeDef {
    shape: () => T;
    catchall: Catchall;
    unknownKeys: UnknownKeys;
}
export declare type baseObjectOutputType<Shape extends ZodRawShape> = objectUtil.flatten<objectUtil.addQuestionMarks<{
    [k in keyof Shape]: Shape[k]["_output"];
}>>;
export declare type objectOutputType<Shape extends ZodRawShape, Catchall extends ZodTypeAny> = ZodTypeAny extends Catchall ? baseObjectOutputType<Shape> : objectUtil.flatten<baseObjectOutputType<Shape> & {
    [k: string]: Catchall["_output"];
}>;
export declare type baseObjectInputType<Shape extends ZodRawShape> = objectUtil.flatten<objectUtil.addQuestionMarks<{
    [k in keyof Shape]: Shape[k]["_input"];
}>>;
export declare type objectInputType<Shape extends ZodRawShape, Catchall extends ZodTypeAny> = ZodTypeAny extends Catchall ? baseObjectInputType<Shape> : objectUtil.flatten<baseObjectInputType<Shape> & {
    [k: string]: Catchall["_input"];
}>;
declare type deoptional<T extends ZodTypeAny> = T extends ZodOptional<infer U> ? deoptional<U> : T;
export declare class ZodObject<T extends ZodRawShape, UnknownKeys extends UnknownKeysParam = "strip", Catchall extends ZodTypeAny = ZodTypeAny, Output = objectOutputType<T, Catchall>, Input = objectInputType<T, Catchall>> extends ZodType<Output, ZodObjectDef<T, UnknownKeys, Catchall>, Input> {
    readonly _shape: T;
    readonly _unknownKeys: UnknownKeys;
    readonly _catchall: Catchall;
    private _cached;
    _getCached(): {
        shape: T;
        keys: string[];
    };
    _parse(ctx: ParseContext, data: any, parsedType: ZodParsedType): ParseReturnType<Output>;
    get shape(): T;
    strict: () => ZodObject<T, "strict", Catchall>;
    strip: () => ZodObject<T, "strip", Catchall>;
    passthrough: () => ZodObject<T, "passthrough", Catchall>;
    /**
     * @deprecated In most cases, this is no longer needed - unknown properties are now silently stripped.
     * If you want to pass through unknown properies, use `.passthrough()` instead.
     */
    nonstrict: () => ZodObject<T, "passthrough", Catchall>;
    augment: <Augmentation extends ZodRawShape>(augmentation: Augmentation) => ZodObject<extend<T, Augmentation>, UnknownKeys, Catchall, objectOutputType<extend<T, Augmentation>, Catchall>, objectInputType<extend<T, Augmentation>, Catchall>>;
    extend: <Augmentation extends ZodRawShape>(augmentation: Augmentation) => ZodObject<extend<T, Augmentation>, UnknownKeys, Catchall, objectOutputType<extend<T, Augmentation>, Catchall>, objectInputType<extend<T, Augmentation>, Catchall>>;
    setKey: <Key extends string, Schema extends ZodTypeAny>(key: Key, schema: Schema) => ZodObject<T & { [k in Key]: Schema; }, UnknownKeys, Catchall, objectOutputType<T & { [k in Key]: Schema; }, Catchall>, objectInputType<T & { [k in Key]: Schema; }, Catchall>>;
    /**
     * Prior to zod@1.0.12 there was a bug in the
     * inferred type of merged objects. Please
     * upgrade if you are experiencing issues.
     */
    merge: <Incoming extends AnyZodObject>(merging: Incoming) => ZodObject<extend<T, Incoming["_shape"]>, UnknownKeys, Catchall>;
    catchall: <Index extends ZodTypeAny>(index: Index) => ZodObject<T, UnknownKeys, Index, objectOutputType<T, Index>, objectInputType<T, Index>>;
    pick: <Mask extends { [k in keyof T]?: true | undefined; }>(mask: Mask) => ZodObject<{ [k_2 in objectUtil.noNeverKeys<{ [k_1 in keyof Mask]: k_1 extends keyof T ? T[k_1] : never; }>]: k_2 extends keyof Mask ? { [k_1 in keyof Mask]: k_1 extends keyof T ? T[k_1] : never; }[k_2] : never; }, UnknownKeys, Catchall, objectOutputType<{ [k_2 in objectUtil.noNeverKeys<{ [k_1 in keyof Mask]: k_1 extends keyof T ? T[k_1] : never; }>]: k_2 extends keyof Mask ? { [k_1 in keyof Mask]: k_1 extends keyof T ? T[k_1] : never; }[k_2] : never; }, Catchall>, objectInputType<{ [k_2 in objectUtil.noNeverKeys<{ [k_1 in keyof Mask]: k_1 extends keyof T ? T[k_1] : never; }>]: k_2 extends keyof Mask ? { [k_1 in keyof Mask]: k_1 extends keyof T ? T[k_1] : never; }[k_2] : never; }, Catchall>>;
    omit: <Mask extends { [k in keyof T]?: true | undefined; }>(mask: Mask) => ZodObject<{ [k_2 in objectUtil.noNeverKeys<{ [k_1 in keyof T]: k_1 extends keyof Mask ? never : T[k_1]; }>]: k_2 extends keyof T ? { [k_1 in keyof T]: k_1 extends keyof Mask ? never : T[k_1]; }[k_2] : never; }, UnknownKeys, Catchall, objectOutputType<{ [k_2 in objectUtil.noNeverKeys<{ [k_1 in keyof T]: k_1 extends keyof Mask ? never : T[k_1]; }>]: k_2 extends keyof T ? { [k_1 in keyof T]: k_1 extends keyof Mask ? never : T[k_1]; }[k_2] : never; }, Catchall>, objectInputType<{ [k_2 in objectUtil.noNeverKeys<{ [k_1 in keyof T]: k_1 extends keyof Mask ? never : T[k_1]; }>]: k_2 extends keyof T ? { [k_1 in keyof T]: k_1 extends keyof Mask ? never : T[k_1]; }[k_2] : never; }, Catchall>>;
    partial: () => ZodObject<{ [k in keyof T]: ReturnType<T[k]["optional"]>; }, UnknownKeys, Catchall, objectOutputType<{ [k in keyof T]: ReturnType<T[k]["optional"]>; }, Catchall>, objectInputType<{ [k in keyof T]: ReturnType<T[k]["optional"]>; }, Catchall>>;
    deepPartial: () => partialUtil.RootDeepPartial<this>;
    required: () => ZodObject<{ [k in keyof T]: deoptional<T[k]>; }, UnknownKeys, Catchall, objectOutputType<{ [k in keyof T]: deoptional<T[k]>; }, Catchall>, objectInputType<{ [k in keyof T]: deoptional<T[k]>; }, Catchall>>;
    static create: <T_1 extends ZodRawShape>(shape: T_1) => ZodObject<T_1, "strip", ZodTypeAny, { [k_1 in keyof objectUtil.addQuestionMarks<{ [k in keyof T_1]: T_1[k]["_output"]; }>]: objectUtil.addQuestionMarks<{ [k in keyof T_1]: T_1[k]["_output"]; }>[k_1]; }, { [k_3 in keyof objectUtil.addQuestionMarks<{ [k_2 in keyof T_1]: T_1[k_2]["_input"]; }>]: objectUtil.addQuestionMarks<{ [k_2 in keyof T_1]: T_1[k_2]["_input"]; }>[k_3]; }>;
    static strictCreate: <T_1 extends ZodRawShape>(shape: T_1) => ZodObject<T_1, "strict", ZodTypeAny, { [k_1 in keyof objectUtil.addQuestionMarks<{ [k in keyof T_1]: T_1[k]["_output"]; }>]: objectUtil.addQuestionMarks<{ [k in keyof T_1]: T_1[k]["_output"]; }>[k_1]; }, { [k_3 in keyof objectUtil.addQuestionMarks<{ [k_2 in keyof T_1]: T_1[k_2]["_input"]; }>]: objectUtil.addQuestionMarks<{ [k_2 in keyof T_1]: T_1[k_2]["_input"]; }>[k_3]; }>;
    static lazycreate: <T_1 extends ZodRawShape>(shape: () => T_1) => ZodObject<T_1, "strip", ZodTypeAny, { [k_1 in keyof objectUtil.addQuestionMarks<{ [k in keyof T_1]: T_1[k]["_output"]; }>]: objectUtil.addQuestionMarks<{ [k in keyof T_1]: T_1[k]["_output"]; }>[k_1]; }, { [k_3 in keyof objectUtil.addQuestionMarks<{ [k_2 in keyof T_1]: T_1[k_2]["_input"]; }>]: objectUtil.addQuestionMarks<{ [k_2 in keyof T_1]: T_1[k_2]["_input"]; }>[k_3]; }>;
}
export declare type AnyZodObject = ZodObject<any, any, any>;
declare type ZodUnionOptions = [ZodTypeAny, ...ZodTypeAny[]];
export interface ZodUnionDef<T extends ZodUnionOptions = [ZodTypeAny, ZodTypeAny, ...ZodTypeAny[]]> extends ZodTypeDef {
    options: T;
}
export declare class ZodUnion<T extends ZodUnionOptions> extends ZodType<T[number]["_output"], ZodUnionDef<T>, T[number]["_input"]> {
    _parse(ctx: ParseContext, data: any, parsedType: ZodParsedType): ParseReturnType<T[number]["_output"]>;
    get options(): T;
    static create: <T_1 extends [ZodTypeAny, ZodTypeAny, ...ZodTypeAny[]]>(types: T_1) => ZodUnion<T_1>;
}
export interface ZodIntersectionDef<T extends ZodTypeAny = ZodTypeAny, U extends ZodTypeAny = ZodTypeAny> extends ZodTypeDef {
    left: T;
    right: U;
}
export declare class ZodIntersection<T extends ZodTypeAny, U extends ZodTypeAny> extends ZodType<T["_output"] & U["_output"], ZodIntersectionDef<T, U>, T["_input"] & U["_input"]> {
    _parse(ctx: ParseContext, data: any, parsedType: ZodParsedType): ParseReturnType<T & U>;
    static create: <T_1 extends ZodTypeAny, U_1 extends ZodTypeAny>(left: T_1, right: U_1) => ZodIntersection<T_1, U_1>;
}
export declare type OutputTypeOfTuple<T extends [ZodTypeAny, ...ZodTypeAny[]] | []> = {
    [k in keyof T]: T[k] extends ZodType<any, any> ? T[k]["_output"] : never;
};
export declare type InputTypeOfTuple<T extends [ZodTypeAny, ...ZodTypeAny[]] | []> = {
    [k in keyof T]: T[k] extends ZodType<any, any> ? T[k]["_input"] : never;
};
export interface ZodTupleDef<T extends [ZodTypeAny, ...ZodTypeAny[]] | [] = [ZodTypeAny, ...ZodTypeAny[]]> extends ZodTypeDef {
    items: T;
}
export declare class ZodTuple<T extends [ZodTypeAny, ...ZodTypeAny[]] | [] = [ZodTypeAny, ...ZodTypeAny[]]> extends ZodType<OutputTypeOfTuple<T>, ZodTupleDef<T>, InputTypeOfTuple<T>> {
    _parse(ctx: ParseContext, data: any, parsedType: ZodParsedType): ParseReturnType<any>;
    get items(): T;
    static create: <T_1 extends [] | [ZodTypeAny, ...ZodTypeAny[]]>(schemas: T_1) => ZodTuple<T_1>;
}
export interface ZodRecordDef<Value extends ZodTypeAny = ZodTypeAny> extends ZodTypeDef {
    valueType: Value;
}
export declare class ZodRecord<Value extends ZodTypeAny = ZodTypeAny> extends ZodType<Record<string, Value["_output"]>, ZodRecordDef<Value>, Record<string, Value["_input"]>> {
    _parse(ctx: ParseContext, data: any, parsedType: ZodParsedType): ParseReturnType<Record<string, any>>;
    static create: <Value_1 extends ZodTypeAny = ZodTypeAny>(valueType: Value_1) => ZodRecord<Value_1>;
}
export interface ZodMapDef<Key extends ZodTypeAny = ZodTypeAny, Value extends ZodTypeAny = ZodTypeAny> extends ZodTypeDef {
    valueType: Value;
    keyType: Key;
}
export declare class ZodMap<Key extends ZodTypeAny = ZodTypeAny, Value extends ZodTypeAny = ZodTypeAny> extends ZodType<Map<Key["_output"], Value["_output"]>, ZodMapDef<Key, Value>, Map<Key["_input"], Value["_input"]>> {
    _parse(ctx: ParseContext, data: any, parsedType: ZodParsedType): ParseReturnType<Map<any, any>>;
    static create: <Key_1 extends ZodTypeAny = ZodTypeAny, Value_1 extends ZodTypeAny = ZodTypeAny>(keyType: Key_1, valueType: Value_1) => ZodMap<Key_1, Value_1>;
}
export interface ZodSetDef<Value extends ZodTypeAny = ZodTypeAny> extends ZodTypeDef {
    valueType: Value;
}
export declare class ZodSet<Value extends ZodTypeAny = ZodTypeAny> extends ZodType<Set<Value["_output"]>, ZodSetDef<Value>, Set<Value["_input"]>> {
    _parse(ctx: ParseContext, data: any, parsedType: ZodParsedType): ParseReturnType<Set<any>>;
    static create: <Value_1 extends ZodTypeAny = ZodTypeAny>(valueType: Value_1) => ZodSet<Value_1>;
}
export interface ZodFunctionDef<Args extends ZodTuple<any> = ZodTuple<any>, Returns extends ZodTypeAny = ZodTypeAny> extends ZodTypeDef {
    args: Args;
    returns: Returns;
}
export declare type OuterTypeOfFunction<Args extends ZodTuple<any>, Returns extends ZodTypeAny> = Args["_input"] extends Array<any> ? (...args: Args["_input"]) => Returns["_output"] : never;
export declare type InnerTypeOfFunction<Args extends ZodTuple<any>, Returns extends ZodTypeAny> = Args["_output"] extends Array<any> ? (...args: Args["_output"]) => Returns["_input"] : never;
export declare class ZodFunction<Args extends ZodTuple<any>, Returns extends ZodTypeAny> extends ZodType<OuterTypeOfFunction<Args, Returns>, ZodFunctionDef<Args, Returns>, InnerTypeOfFunction<Args, Returns>> {
    _parse(ctx: ParseContext, data: any, parsedType: ZodParsedType): ParseReturnType<any>;
    parameters(): Args;
    returnType(): Returns;
    args: <Items extends [] | [ZodTypeAny, ...ZodTypeAny[]]>(...items: Items) => ZodFunction<ZodTuple<Items>, Returns>;
    returns: <NewReturnType extends ZodType<any, any, any>>(returnType: NewReturnType) => ZodFunction<Args, NewReturnType>;
    implement: <F extends InnerTypeOfFunction<Args, Returns>>(func: F) => F;
    strictImplement: (func: InnerTypeOfFunction<Args, Returns>) => InnerTypeOfFunction<Args, Returns>;
    validate: <F extends InnerTypeOfFunction<Args, Returns>>(func: F) => F;
    static create: <T extends ZodTuple<any> = ZodTuple<[]>, U extends ZodTypeAny = ZodUnknown>(args?: T | undefined, returns?: U | undefined) => ZodFunction<T, U>;
}
export interface ZodLazyDef<T extends ZodTypeAny = ZodTypeAny> extends ZodTypeDef {
    getter: () => T;
}
export declare class ZodLazy<T extends ZodTypeAny> extends ZodType<output<T>, ZodLazyDef<T>, input<T>> {
    get schema(): T;
    _parse(ctx: ParseContext, data: any, parsedType: ZodParsedType): ParseReturnType<output<T>>;
    static create: <T_1 extends ZodTypeAny>(getter: () => T_1) => ZodLazy<T_1>;
}
export interface ZodLiteralDef<T extends any = any> extends ZodTypeDef {
    value: T;
}
export declare class ZodLiteral<T extends any> extends ZodType<T, ZodLiteralDef<T>> {
    _parse(ctx: ParseContext, data: any, _parsedType: ZodParsedType): ParseReturnType<T>;
    static create: <T_1 extends Primitive>(value: T_1) => ZodLiteral<T_1>;
}
export declare type ArrayKeys = keyof any[];
export declare type Indices<T> = Exclude<keyof T, ArrayKeys>;
declare type EnumValues = [string, ...string[]];
declare type Values<T extends EnumValues> = {
    [k in T[number]]: k;
};
export interface ZodEnumDef<T extends EnumValues = EnumValues> extends ZodTypeDef {
    values: T;
}
export declare class ZodEnum<T extends [string, ...string[]]> extends ZodType<T[number], ZodEnumDef<T>> {
    _parse(ctx: ParseContext, data: any, _parsedType: ZodParsedType): ParseReturnType<T[number]>;
    get options(): T;
    get enum(): Values<T>;
    get Values(): Values<T>;
    get Enum(): Values<T>;
    static create: <U extends string, T_1 extends [U, ...U[]]>(values: T_1) => ZodEnum<T_1>;
}
export interface ZodNativeEnumDef<T extends EnumLike = EnumLike> extends ZodTypeDef {
    values: T;
}
declare type EnumLike = {
    [k: string]: string | number;
    [nu: number]: string;
};
export declare class ZodNativeEnum<T extends EnumLike> extends ZodType<T[keyof T], ZodNativeEnumDef<T>> {
    _parse(ctx: ParseContext, data: any, _parsedType: ZodParsedType): ParseReturnType<T[keyof T]>;
    static create: <T_1 extends EnumLike>(values: T_1) => ZodNativeEnum<T_1>;
}
export interface ZodPromiseDef<T extends ZodTypeAny = ZodTypeAny> extends ZodTypeDef {
    type: T;
}
export declare class ZodPromise<T extends ZodTypeAny> extends ZodType<Promise<T["_output"]>, ZodPromiseDef<T>, Promise<T["_input"]>> {
    _parse(ctx: ParseContext, data: any, parsedType: ZodParsedType): ParseReturnType<Promise<T["_output"]>>;
    static create: <T_1 extends ZodTypeAny>(schema: T_1) => ZodPromise<T_1>;
}
declare type ZodEffectsType<T extends ZodTypeAny> = T extends ZodEffects<any, any> ? T : ZodEffects<T, T["_output"]>;
export declare type InternalCheck<T> = {
    type: "refinement";
    refinement: (arg: T, ctx: RefinementCtx) => boolean | Promise<boolean>;
};
export declare type Mod<T> = {
    type: "transform";
    transform: (arg: T) => any;
};
export declare type Effect<T> = InternalCheck<T> | Mod<T>;
export interface ZodEffectsDef<T extends ZodTypeAny = ZodTypeAny> extends ZodTypeDef {
    schema: T;
    effects?: Effect<any>[];
}
export declare class ZodEffects<T extends ZodTypeAny, Output = T["_type"]> extends ZodType<Output, ZodEffectsDef<T>, T["_input"]> {
    innerType(): T;
    _parse(ctx: ParseContext, data: any, parsedType: ZodParsedType): ParseReturnType<Output>;
    constructor(def: ZodEffectsDef<T>);
    static create: <I extends ZodTypeAny>(schema: I) => ZodEffects<I, I["_output"]>;
}
export { ZodEffects as ZodTransformer };
export interface ZodOptionalDef<T extends ZodTypeAny = ZodTypeAny> extends ZodTypeDef {
    innerType: T;
}
export declare type ZodOptionalType<T extends ZodTypeAny> = ZodOptional<T>;
export declare class ZodOptional<T extends ZodTypeAny> extends ZodType<T["_output"] | undefined, ZodOptionalDef<T>, T["_input"] | undefined> {
    _parse(ctx: ParseContext, data: any, parsedType: ZodParsedType): ParseReturnType<T["_output"] | undefined>;
    unwrap(): T;
    static create: <T_1 extends ZodTypeAny>(type: T_1) => ZodOptional<T_1>;
}
export interface ZodNullableDef<T extends ZodTypeAny = ZodTypeAny> extends ZodTypeDef {
    innerType: T;
}
export declare type ZodNullableType<T extends ZodTypeAny> = ZodNullable<T>;
export declare class ZodNullable<T extends ZodTypeAny> extends ZodType<T["_output"] | null, ZodNullableDef<T>, T["_input"] | null> {
    _parse(ctx: ParseContext, data: any, parsedType: ZodParsedType): ParseReturnType<T["_output"] | null>;
    unwrap(): T;
    static create: <T_1 extends ZodTypeAny>(type: T_1) => ZodNullable<T_1>;
}
export interface ZodDefaultDef<T extends ZodTypeAny = ZodTypeAny> extends ZodTypeDef {
    innerType: T;
    defaultValue: () => util.noUndefined<T["_input"]>;
}
export declare class ZodDefault<T extends ZodTypeAny> extends ZodType<util.noUndefined<T["_output"]>, ZodDefaultDef<T>, T["_input"] | undefined> {
    _parse(ctx: ParseContext, data: any, parsedType: ZodParsedType): ParseReturnType<util.noUndefined<T["_output"]>>;
    removeDefault(): T;
    static create: <T_1 extends ZodTypeAny>(type: T_1) => ZodOptional<T_1>;
}
export declare const custom: <T>(check?: ((data: unknown) => any) | undefined, params?: Parameters<ZodTypeAny["refine"]>[1]) => ZodType<T, ZodTypeDef, T>;
export { ZodType as Schema, ZodType as ZodSchema };
export declare const late: {
    object: <T extends ZodRawShape>(shape: () => T) => ZodObject<T, "strip", ZodTypeAny, { [k_1 in keyof objectUtil.addQuestionMarks<{ [k in keyof T]: T[k]["_output"]; }>]: objectUtil.addQuestionMarks<{ [k in keyof T]: T[k]["_output"]; }>[k_1]; }, { [k_3 in keyof objectUtil.addQuestionMarks<{ [k_2 in keyof T]: T[k_2]["_input"]; }>]: objectUtil.addQuestionMarks<{ [k_2 in keyof T]: T[k_2]["_input"]; }>[k_3]; }>;
};
export declare type ZodFirstPartySchemaTypes = ZodString | ZodNumber | ZodBigInt | ZodBoolean | ZodDate | ZodUndefined | ZodNull | ZodAny | ZodUnknown | ZodNever | ZodVoid | ZodArray<any> | ZodObject<any> | ZodUnion<any> | ZodIntersection<any, any> | ZodTuple | ZodRecord | ZodMap | ZodSet | ZodFunction<any, any> | ZodLazy<any> | ZodLiteral<any> | ZodEnum<any> | ZodEffects<any> | ZodNativeEnum<any> | ZodOptional<any> | ZodNullable<any> | ZodDefault<any> | ZodPromise<any>;
declare const instanceOfType: <T extends new (...args: any[]) => any>(cls: T, params?: Parameters<ZodTypeAny["refine"]>[1]) => ZodType<InstanceType<T>, ZodTypeDef, InstanceType<T>>;
declare const stringType: () => ZodString;
declare const numberType: () => ZodNumber;
declare const bigIntType: () => ZodBigInt;
declare const booleanType: () => ZodBoolean;
declare const dateType: () => ZodDate;
declare const undefinedType: () => ZodUndefined;
declare const nullType: () => ZodNull;
declare const anyType: () => ZodAny;
declare const unknownType: () => ZodUnknown;
declare const neverType: () => ZodNever;
declare const voidType: () => ZodVoid;
declare const arrayType: <T extends ZodTypeAny>(schema: T) => ZodArray<T>;
declare const objectType: <T extends ZodRawShape>(shape: T) => ZodObject<T, "strip", ZodTypeAny, { [k_1 in keyof objectUtil.addQuestionMarks<{ [k in keyof T]: T[k]["_output"]; }>]: objectUtil.addQuestionMarks<{ [k in keyof T]: T[k]["_output"]; }>[k_1]; }, { [k_3 in keyof objectUtil.addQuestionMarks<{ [k_2 in keyof T]: T[k_2]["_input"]; }>]: objectUtil.addQuestionMarks<{ [k_2 in keyof T]: T[k_2]["_input"]; }>[k_3]; }>;
declare const strictObjectType: <T extends ZodRawShape>(shape: T) => ZodObject<T, "strict", ZodTypeAny, { [k_1 in keyof objectUtil.addQuestionMarks<{ [k in keyof T]: T[k]["_output"]; }>]: objectUtil.addQuestionMarks<{ [k in keyof T]: T[k]["_output"]; }>[k_1]; }, { [k_3 in keyof objectUtil.addQuestionMarks<{ [k_2 in keyof T]: T[k_2]["_input"]; }>]: objectUtil.addQuestionMarks<{ [k_2 in keyof T]: T[k_2]["_input"]; }>[k_3]; }>;
declare const unionType: <T extends [ZodTypeAny, ZodTypeAny, ...ZodTypeAny[]]>(types: T) => ZodUnion<T>;
declare const intersectionType: <T extends ZodTypeAny, U extends ZodTypeAny>(left: T, right: U) => ZodIntersection<T, U>;
declare const tupleType: <T extends [] | [ZodTypeAny, ...ZodTypeAny[]]>(schemas: T) => ZodTuple<T>;
declare const recordType: <Value extends ZodTypeAny = ZodTypeAny>(valueType: Value) => ZodRecord<Value>;
declare const mapType: <Key extends ZodTypeAny = ZodTypeAny, Value extends ZodTypeAny = ZodTypeAny>(keyType: Key, valueType: Value) => ZodMap<Key, Value>;
declare const setType: <Value extends ZodTypeAny = ZodTypeAny>(valueType: Value) => ZodSet<Value>;
declare const functionType: <T extends ZodTuple<any> = ZodTuple<[]>, U extends ZodTypeAny = ZodUnknown>(args?: T | undefined, returns?: U | undefined) => ZodFunction<T, U>;
declare const lazyType: <T extends ZodTypeAny>(getter: () => T) => ZodLazy<T>;
declare const literalType: <T extends Primitive>(value: T) => ZodLiteral<T>;
declare const enumType: <U extends string, T extends [U, ...U[]]>(values: T) => ZodEnum<T>;
declare const nativeEnumType: <T extends EnumLike>(values: T) => ZodNativeEnum<T>;
declare const promiseType: <T extends ZodTypeAny>(schema: T) => ZodPromise<T>;
declare const effectsType: <I extends ZodTypeAny>(schema: I) => ZodEffects<I, I["_output"]>;
declare const optionalType: <T extends ZodTypeAny>(type: T) => ZodOptional<T>;
declare const nullableType: <T extends ZodTypeAny>(type: T) => ZodNullable<T>;
declare const ostring: () => ZodOptional<ZodString>;
declare const onumber: () => ZodOptional<ZodNumber>;
declare const oboolean: () => ZodOptional<ZodBoolean>;
export { anyType as any, arrayType as array, bigIntType as bigint, booleanType as boolean, dateType as date, effectsType as effect, enumType as enum, functionType as function, instanceOfType as instanceof, intersectionType as intersection, lazyType as lazy, literalType as literal, mapType as map, nativeEnumType as nativeEnum, neverType as never, nullType as null, nullableType as nullable, numberType as number, objectType as object, oboolean, onumber, optionalType as optional, ostring, promiseType as promise, recordType as record, setType as set, strictObjectType as strictObject, stringType as string, effectsType as transformer, tupleType as tuple, undefinedType as undefined, unionType as union, unknownType as unknown, voidType as void, };
//# sourceMappingURL=types.d.ts.map