"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.literal = exports.lazy = exports.intersection = exports.instanceof = exports.function = exports.enum = exports.effect = exports.date = exports.boolean = exports.bigint = exports.array = exports.any = exports.late = exports.ZodSchema = exports.Schema = exports.custom = exports.ZodDefault = exports.ZodNullable = exports.ZodOptional = exports.ZodTransformer = exports.ZodEffects = exports.ZodPromise = exports.ZodNativeEnum = exports.ZodEnum = exports.ZodLiteral = exports.ZodLazy = exports.ZodFunction = exports.ZodSet = exports.ZodMap = exports.ZodRecord = exports.ZodTuple = exports.ZodIntersection = exports.ZodUnion = exports.ZodObject = exports.mergeObjects = exports.objectUtil = exports.ZodNonEmptyArray = exports.ZodArray = exports.ZodVoid = exports.ZodNever = exports.ZodUnknown = exports.ZodAny = exports.ZodNull = exports.ZodUndefined = exports.ZodDate = exports.ZodBoolean = exports.ZodBigInt = exports.ZodNumber = exports.ZodString = exports.ZodType = void 0;
exports.void = exports.unknown = exports.union = exports.undefined = exports.tuple = exports.transformer = exports.string = exports.strictObject = exports.set = exports.record = exports.promise = exports.ostring = exports.optional = exports.onumber = exports.oboolean = exports.object = exports.number = exports.nullable = exports.null = exports.never = exports.nativeEnum = exports.map = void 0;
var errorUtil_1 = require("./helpers/errorUtil");
var parseUtil_1 = require("./helpers/parseUtil");
var util_1 = require("./helpers/util");
var PseudoPromise_1 = require("./PseudoPromise");
var ZodError_1 = require("./ZodError");
var createTasks = function (ctx) {
    return ctx.params.async ? [] : null;
};
var createRootContext = function (params) {
    var _a;
    return new parseUtil_1.ParseContext(parseUtil_1.pathFromArray(params.path || []), [], {
        async: (_a = params.async) !== null && _a !== void 0 ? _a : false,
        errorMap: params.errorMap || ZodError_1.overrideErrorMap,
    });
};
var handleResult = function (ctx, result, parentError) {
    if (parseUtil_1.isOk(result)) {
        return { success: true, data: result.value };
    }
    else {
        parentError === null || parentError === void 0 ? void 0 : parentError.addIssues(ctx.issues);
        var error = new ZodError_1.ZodError(ctx.issues);
        return { success: false, error: error };
    }
};
var ZodType = /** @class */ (function () {
    function ZodType(def) {
        var _this = this;
        this.parse = function (data, params) {
            var result = _this.safeParse(data, params);
            if (result.success)
                return result.data;
            throw result.error;
        };
        this.safeParse = function (data, params) {
            var ctx = createRootContext(__assign(__assign({}, params), { async: false }));
            var result = _this._parseSync(ctx, data, parseUtil_1.getParsedType(data));
            return handleResult(ctx, result, params === null || params === void 0 ? void 0 : params.parentError);
        };
        this.parseAsync = function (data, params) { return __awaiter(_this, void 0, void 0, function () {
            var result;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.safeParseAsync(data, params)];
                    case 1:
                        result = _a.sent();
                        if (result.success)
                            return [2 /*return*/, result.data];
                        throw result.error;
                }
            });
        }); };
        this.safeParseAsync = function (data, params) { return __awaiter(_this, void 0, void 0, function () {
            var ctx, maybeAsyncResult, result;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        ctx = createRootContext(__assign(__assign({}, params), { async: true }));
                        maybeAsyncResult = this._parse(ctx, data, parseUtil_1.getParsedType(data));
                        return [4 /*yield*/, (parseUtil_1.isAsync(maybeAsyncResult)
                                ? maybeAsyncResult.promise
                                : Promise.resolve(maybeAsyncResult))];
                    case 1:
                        result = _a.sent();
                        return [2 /*return*/, handleResult(ctx, result, params === null || params === void 0 ? void 0 : params.parentError)];
                }
            });
        }); };
        /** Alias of safeParseAsync */
        this.spa = this.safeParseAsync;
        this.refine = function (check, message) {
            var getIssueProperties = function (val) {
                if (typeof message === "string" || typeof message === "undefined") {
                    return { message: message };
                }
                else if (typeof message === "function") {
                    return message(val);
                }
                else {
                    return message;
                }
            };
            return _this._refinement(function (val, ctx) {
                var result = check(val);
                var setError = function () {
                    return ctx.addIssue(__assign({ code: ZodError_1.ZodIssueCode.custom }, getIssueProperties(val)));
                };
                if (result instanceof Promise) {
                    return result.then(function (data) {
                        if (!data) {
                            setError();
                            return false;
                        }
                        else {
                            return true;
                        }
                    });
                }
                if (!result) {
                    setError();
                    return false;
                }
                else {
                    return true;
                }
            });
        };
        this.refinement = function (check, refinementData) {
            return _this._refinement(function (val, ctx) {
                if (!check(val)) {
                    ctx.addIssue(typeof refinementData === "function"
                        ? refinementData(val, ctx)
                        : refinementData);
                    return false;
                }
                else {
                    return true;
                }
            });
        };
        this.superRefine = this._refinement;
        this.optional = function () {
            return ZodOptional.create(_this);
        };
        this.nullable = function () {
            return ZodNullable.create(_this);
        };
        this.nullish = function () { return _this.optional().nullable(); };
        this.array = function () { return ZodArray.create(_this); };
        this.isOptional = function () { return _this.safeParse(undefined).success; };
        this.isNullable = function () { return _this.safeParse(null).success; };
        this._def = def;
        this.transform = this.transform.bind(this);
        this.default = this.default.bind(this);
    }
    ZodType.prototype._parseSync = function (_ctx, _data, _parsedType) {
        var result = this._parse(_ctx, _data, _parsedType);
        if (parseUtil_1.isAsync(result)) {
            throw new Error("Synchronous parse encountered promise.");
        }
        return result;
    };
    ZodType.prototype._refinement = function (refinement) {
        var returnType;
        if (this instanceof ZodEffects) {
            returnType = new ZodEffects(__assign(__assign({}, this._def), { effects: __spreadArray(__spreadArray([], __read((this._def.effects || []))), [
                    { type: "refinement", refinement: refinement },
                ]) }));
        }
        else {
            returnType = new ZodEffects({
                schema: this,
                effects: [{ type: "refinement", refinement: refinement }],
            });
        }
        return returnType;
    };
    ZodType.prototype.or = function (option) {
        return ZodUnion.create([this, option]);
    };
    ZodType.prototype.and = function (incoming) {
        return ZodIntersection.create(this, incoming);
    };
    ZodType.prototype.transform = function (transform) {
        return new ZodEffects({
            schema: this,
            effects: [{ type: "transform", transform: transform }],
        });
    };
    ZodType.prototype.default = function (def) {
        var defaultValueFunc = typeof def === "function" ? def : function () { return def; };
        // if (this instanceof ZodOptional) {
        //   return new ZodOptional({
        //     ...this._def,
        //     defaultValue: defaultValueFunc,
        //   }) as any;
        // }
        return new ZodDefault({
            innerType: this,
            defaultValue: defaultValueFunc,
        });
    };
    return ZodType;
}());
exports.ZodType = ZodType;
exports.Schema = ZodType;
exports.ZodSchema = ZodType;
var uuidRegex = /^([a-f0-9]{8}-[a-f0-9]{4}-[1-5][a-f0-9]{3}-[89ab][a-f0-9]{3}-[a-f0-9]{12}|00000000-0000-0000-0000-000000000000)$/i;
// from https://stackoverflow.com/a/46181/1550155
// old version: too slow, didn't support unicode
// const emailRegex = /^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))$/i;
// eslint-disable-next-line
var emailRegex = /^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i;
var ZodString = /** @class */ (function (_super) {
    __extends(ZodString, _super);
    function ZodString() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._regex = function (regex, validation, message) {
            return _this.refinement(function (data) { return regex.test(data); }, __assign({ validation: validation, code: ZodError_1.ZodIssueCode.invalid_string }, errorUtil_1.errorUtil.errToObj(message)));
        };
        _this.email = function (message) {
            return new ZodString(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    __assign({ kind: "email" }, errorUtil_1.errorUtil.errToObj(message)),
                ]) }));
        };
        _this.url = function (message) {
            return new ZodString(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    __assign({ kind: "url" }, errorUtil_1.errorUtil.errToObj(message)),
                ]) }));
        };
        _this.uuid = function (message) {
            return new ZodString(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    __assign({ kind: "uuid" }, errorUtil_1.errorUtil.errToObj(message)),
                ]) }));
        };
        _this.regex = function (regex, message) {
            return new ZodString(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    __assign({ kind: "regex", regex: regex }, errorUtil_1.errorUtil.errToObj(message)),
                ]) }));
        };
        _this.min = function (minLength, message) {
            return new ZodString(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    __assign({ kind: "min", value: minLength }, errorUtil_1.errorUtil.errToObj(message)),
                ]) }));
        };
        _this.max = function (maxLength, message) {
            return new ZodString(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    __assign({ kind: "max", value: maxLength }, errorUtil_1.errorUtil.errToObj(message)),
                ]) }));
        };
        /**
         * Deprecated.
         * Use z.string().min(1) instead.
         */
        _this.nonempty = function (message) {
            return _this.min(1, errorUtil_1.errorUtil.errToObj(message));
        };
        return _this;
    }
    ZodString.prototype._parse = function (ctx, data, parsedType) {
        var e_1, _a;
        if (parsedType !== parseUtil_1.ZodParsedType.string) {
            ctx.addIssue(data, {
                code: ZodError_1.ZodIssueCode.invalid_type,
                expected: parseUtil_1.ZodParsedType.string,
                received: parsedType,
            });
            return parseUtil_1.INVALID;
        }
        var invalid = false;
        try {
            for (var _b = __values(this._def.checks), _c = _b.next(); !_c.done; _c = _b.next()) {
                var check = _c.value;
                if (check.kind === "min") {
                    if (data.length < check.value) {
                        invalid = true;
                        ctx.addIssue(data, {
                            code: ZodError_1.ZodIssueCode.too_small,
                            minimum: check.value,
                            type: "string",
                            inclusive: true,
                            message: check.message,
                        });
                    }
                }
                else if (check.kind === "max") {
                    if (data.length > check.value) {
                        invalid = true;
                        ctx.addIssue(data, {
                            code: ZodError_1.ZodIssueCode.too_big,
                            maximum: check.value,
                            type: "string",
                            inclusive: true,
                            message: check.message,
                            // ...errorUtil.errToObj(this._def.maxLength.message),
                        });
                    }
                }
                else if (check.kind === "email") {
                    if (!emailRegex.test(data)) {
                        invalid = true;
                        ctx.addIssue(data, {
                            validation: "email",
                            code: ZodError_1.ZodIssueCode.invalid_string,
                            message: check.message,
                        });
                    }
                }
                else if (check.kind === "uuid") {
                    if (!uuidRegex.test(data)) {
                        invalid = true;
                        ctx.addIssue(data, {
                            validation: "uuid",
                            code: ZodError_1.ZodIssueCode.invalid_string,
                            message: check.message,
                        });
                    }
                }
                else if (check.kind === "url") {
                    try {
                        new URL(data);
                    }
                    catch (_d) {
                        invalid = true;
                        ctx.addIssue(data, {
                            validation: "url",
                            code: ZodError_1.ZodIssueCode.invalid_string,
                            message: check.message,
                        });
                    }
                }
                else if (check.kind === "regex") {
                    if (!check.regex.test(data)) {
                        invalid = true;
                        ctx.addIssue(data, {
                            validation: "regex",
                            code: ZodError_1.ZodIssueCode.invalid_string,
                            message: check.message,
                        });
                    }
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return invalid ? parseUtil_1.INVALID : parseUtil_1.OK(data);
    };
    ZodString.prototype.length = function (len, message) {
        return this.min(len, message).max(len, message);
    };
    Object.defineProperty(ZodString.prototype, "isEmail", {
        get: function () {
            return !!this._def.checks.find(function (ch) { return ch.kind === "email"; });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ZodString.prototype, "isURL", {
        get: function () {
            return !!this._def.checks.find(function (ch) { return ch.kind === "url"; });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ZodString.prototype, "isUUID", {
        get: function () {
            return !!this._def.checks.find(function (ch) { return ch.kind === "uuid"; });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ZodString.prototype, "minLength", {
        get: function () {
            var min = -Infinity;
            this._def.checks.map(function (ch) {
                if (ch.kind === "min") {
                    if (min === null || ch.value > min) {
                        min = ch.value;
                    }
                }
            });
            return min;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ZodString.prototype, "maxLength", {
        get: function () {
            var max = null;
            this._def.checks.map(function (ch) {
                if (ch.kind === "min") {
                    if (max === null || ch.value < max) {
                        max = ch.value;
                    }
                }
            });
            return max;
        },
        enumerable: false,
        configurable: true
    });
    ZodString.create = function () {
        return new ZodString({
            checks: [],
        });
    };
    return ZodString;
}(ZodType));
exports.ZodString = ZodString;
var ZodNumber = /** @class */ (function (_super) {
    __extends(ZodNumber, _super);
    function ZodNumber() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.min = function (value, message) {
            return new ZodNumber(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    {
                        kind: "min",
                        value: value,
                        inclusive: true,
                        message: errorUtil_1.errorUtil.toString(message),
                    },
                ]) }));
        };
        _this.max = function (value, message) {
            return new ZodNumber(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    {
                        kind: "max",
                        value: value,
                        inclusive: true,
                        message: errorUtil_1.errorUtil.toString(message),
                    },
                ]) }));
        };
        _this.int = function (message) {
            return new ZodNumber(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    {
                        kind: "int",
                        message: errorUtil_1.errorUtil.toString(message),
                    },
                ]) }));
        };
        _this.positive = function (message) {
            return new ZodNumber(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    {
                        kind: "min",
                        value: 0,
                        inclusive: false,
                        message: errorUtil_1.errorUtil.toString(message),
                    },
                ]) }));
        };
        _this.negative = function (message) {
            return new ZodNumber(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    {
                        kind: "max",
                        value: 0,
                        inclusive: false,
                        message: errorUtil_1.errorUtil.toString(message),
                    },
                ]) }));
        };
        _this.nonpositive = function (message) {
            return new ZodNumber(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    {
                        kind: "max",
                        value: 0,
                        inclusive: true,
                        message: errorUtil_1.errorUtil.toString(message),
                    },
                ]) }));
        };
        _this.nonnegative = function (message) {
            return new ZodNumber(__assign(__assign({}, _this._def), { checks: __spreadArray(__spreadArray([], __read(_this._def.checks)), [
                    {
                        kind: "min",
                        value: 0,
                        inclusive: true,
                        message: errorUtil_1.errorUtil.toString(message),
                    },
                ]) }));
        };
        return _this;
    }
    ZodNumber.prototype._parse = function (ctx, data, parsedType) {
        var e_2, _a;
        if (parsedType !== parseUtil_1.ZodParsedType.number) {
            ctx.addIssue(data, {
                code: ZodError_1.ZodIssueCode.invalid_type,
                expected: parseUtil_1.ZodParsedType.number,
                received: parsedType,
            });
            return parseUtil_1.INVALID;
        }
        var invalid = false;
        try {
            for (var _b = __values(this._def.checks), _c = _b.next(); !_c.done; _c = _b.next()) {
                var check = _c.value;
                if (check.kind === "int") {
                    if (!Number.isInteger(data)) {
                        invalid = true;
                        ctx.addIssue(data, {
                            code: ZodError_1.ZodIssueCode.invalid_type,
                            expected: "integer",
                            received: "float",
                            message: check.message,
                        });
                    }
                }
                else if (check.kind === "min") {
                    // const MIN = check.value;
                    var tooSmall = check.inclusive
                        ? data < check.value
                        : data <= check.value;
                    if (tooSmall) {
                        invalid = true;
                        ctx.addIssue(data, {
                            code: ZodError_1.ZodIssueCode.too_small,
                            minimum: check.value,
                            type: "number",
                            inclusive: check.inclusive,
                            message: check.message,
                        });
                    }
                }
                else if (check.kind === "max") {
                    var tooBig = check.inclusive
                        ? data > check.value
                        : data >= check.value;
                    if (tooBig) {
                        invalid = true;
                        ctx.addIssue(data, {
                            code: ZodError_1.ZodIssueCode.too_big,
                            maximum: check.value,
                            type: "number",
                            inclusive: check.inclusive,
                            message: check.message,
                        });
                    }
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return invalid ? parseUtil_1.INVALID : parseUtil_1.OK(data);
    };
    Object.defineProperty(ZodNumber.prototype, "minValue", {
        get: function () {
            var e_3, _a;
            var min = null;
            try {
                for (var _b = __values(this._def.checks), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var ch = _c.value;
                    if (ch.kind === "min") {
                        if (min === null || ch.value > min)
                            min = ch.value;
                    }
                }
            }
            catch (e_3_1) { e_3 = { error: e_3_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_3) throw e_3.error; }
            }
            return min;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ZodNumber.prototype, "maxValue", {
        get: function () {
            var e_4, _a;
            var max = null;
            try {
                for (var _b = __values(this._def.checks), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var ch = _c.value;
                    if (ch.kind === "max") {
                        if (max === null || ch.value < max)
                            max = ch.value;
                    }
                }
            }
            catch (e_4_1) { e_4 = { error: e_4_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_4) throw e_4.error; }
            }
            return max;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ZodNumber.prototype, "isInt", {
        get: function () {
            return !!this._def.checks.find(function (ch) { return ch.kind === "int"; });
        },
        enumerable: false,
        configurable: true
    });
    ZodNumber.create = function () {
        return new ZodNumber({
            checks: [],
        });
    };
    return ZodNumber;
}(ZodType));
exports.ZodNumber = ZodNumber;
var ZodBigInt = /** @class */ (function (_super) {
    __extends(ZodBigInt, _super);
    function ZodBigInt() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodBigInt.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType !== parseUtil_1.ZodParsedType.bigint) {
            ctx.addIssue(data, {
                code: ZodError_1.ZodIssueCode.invalid_type,
                expected: parseUtil_1.ZodParsedType.bigint,
                received: parsedType,
            });
            return parseUtil_1.INVALID;
        }
        return parseUtil_1.OK(data);
    };
    ZodBigInt.create = function () {
        return new ZodBigInt({});
    };
    return ZodBigInt;
}(ZodType));
exports.ZodBigInt = ZodBigInt;
var ZodBoolean = /** @class */ (function (_super) {
    __extends(ZodBoolean, _super);
    function ZodBoolean() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodBoolean.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType !== parseUtil_1.ZodParsedType.boolean) {
            ctx.addIssue(data, {
                code: ZodError_1.ZodIssueCode.invalid_type,
                expected: parseUtil_1.ZodParsedType.boolean,
                received: parsedType,
            });
            return parseUtil_1.INVALID;
        }
        return parseUtil_1.OK(data);
    };
    ZodBoolean.create = function () {
        return new ZodBoolean({});
    };
    return ZodBoolean;
}(ZodType));
exports.ZodBoolean = ZodBoolean;
var ZodDate = /** @class */ (function (_super) {
    __extends(ZodDate, _super);
    function ZodDate() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodDate.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType !== parseUtil_1.ZodParsedType.date) {
            ctx.addIssue(data, {
                code: ZodError_1.ZodIssueCode.invalid_type,
                expected: parseUtil_1.ZodParsedType.date,
                received: parsedType,
            });
            return parseUtil_1.INVALID;
        }
        if (isNaN(data.getTime())) {
            ctx.addIssue(data, {
                code: ZodError_1.ZodIssueCode.invalid_date,
            });
            return parseUtil_1.INVALID;
        }
        return parseUtil_1.OK(new Date(data.getTime()));
    };
    ZodDate.create = function () {
        return new ZodDate({});
    };
    return ZodDate;
}(ZodType));
exports.ZodDate = ZodDate;
var ZodUndefined = /** @class */ (function (_super) {
    __extends(ZodUndefined, _super);
    function ZodUndefined() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodUndefined.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType !== parseUtil_1.ZodParsedType.undefined) {
            ctx.addIssue(data, {
                code: ZodError_1.ZodIssueCode.invalid_type,
                expected: parseUtil_1.ZodParsedType.undefined,
                received: parsedType,
            });
            return parseUtil_1.INVALID;
        }
        return parseUtil_1.OK(data);
    };
    ZodUndefined.create = function () {
        return new ZodUndefined({});
    };
    return ZodUndefined;
}(ZodType));
exports.ZodUndefined = ZodUndefined;
var ZodNull = /** @class */ (function (_super) {
    __extends(ZodNull, _super);
    function ZodNull() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodNull.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType !== parseUtil_1.ZodParsedType.null) {
            ctx.addIssue(data, {
                code: ZodError_1.ZodIssueCode.invalid_type,
                expected: parseUtil_1.ZodParsedType.null,
                received: parsedType,
            });
            return parseUtil_1.INVALID;
        }
        return parseUtil_1.OK(data);
    };
    ZodNull.create = function () {
        return new ZodNull({});
    };
    return ZodNull;
}(ZodType));
exports.ZodNull = ZodNull;
var ZodAny = /** @class */ (function (_super) {
    __extends(ZodAny, _super);
    function ZodAny() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodAny.prototype._parse = function (_ctx, data, _parsedType) {
        return parseUtil_1.OK(data);
    };
    ZodAny.create = function () {
        return new ZodAny({});
    };
    return ZodAny;
}(ZodType));
exports.ZodAny = ZodAny;
var ZodUnknown = /** @class */ (function (_super) {
    __extends(ZodUnknown, _super);
    function ZodUnknown() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodUnknown.prototype._parse = function (_ctx, data, _parsedType) {
        return parseUtil_1.OK(data);
    };
    ZodUnknown.create = function () {
        return new ZodUnknown({});
    };
    return ZodUnknown;
}(ZodType));
exports.ZodUnknown = ZodUnknown;
var ZodNever = /** @class */ (function (_super) {
    __extends(ZodNever, _super);
    function ZodNever() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodNever.prototype._parse = function (ctx, data, parsedType) {
        ctx.addIssue(data, {
            code: ZodError_1.ZodIssueCode.invalid_type,
            expected: parseUtil_1.ZodParsedType.never,
            received: parsedType,
        });
        return parseUtil_1.INVALID;
    };
    ZodNever.create = function () {
        return new ZodNever({});
    };
    return ZodNever;
}(ZodType));
exports.ZodNever = ZodNever;
var ZodVoid = /** @class */ (function (_super) {
    __extends(ZodVoid, _super);
    function ZodVoid() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodVoid.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType !== parseUtil_1.ZodParsedType.undefined &&
            parsedType !== parseUtil_1.ZodParsedType.null) {
            ctx.addIssue(data, {
                code: ZodError_1.ZodIssueCode.invalid_type,
                expected: parseUtil_1.ZodParsedType.void,
                received: parsedType,
            });
            return parseUtil_1.INVALID;
        }
        return parseUtil_1.OK(data);
    };
    ZodVoid.create = function () {
        return new ZodVoid({});
    };
    return ZodVoid;
}(ZodType));
exports.ZodVoid = ZodVoid;
var parseArray = function (ctx, data, parsedType, def, nonEmpty) {
    if (parsedType !== parseUtil_1.ZodParsedType.array) {
        ctx.addIssue(data, {
            code: ZodError_1.ZodIssueCode.invalid_type,
            expected: parseUtil_1.ZodParsedType.array,
            received: parsedType,
        });
        return parseUtil_1.INVALID;
    }
    var invalid = false;
    if (def.minLength !== null) {
        if (data.length < def.minLength.value) {
            invalid = true;
            ctx.addIssue(data, {
                code: ZodError_1.ZodIssueCode.too_small,
                minimum: def.minLength.value,
                type: "array",
                inclusive: true,
                message: def.minLength.message,
            });
        }
    }
    if (def.maxLength !== null) {
        if (data.length > def.maxLength.value) {
            invalid = true;
            ctx.addIssue(data, {
                code: ZodError_1.ZodIssueCode.too_big,
                maximum: def.maxLength.value,
                type: "array",
                inclusive: true,
                message: def.maxLength.message,
            });
        }
    }
    if (nonEmpty && data.length < 1) {
        invalid = true;
        ctx.addIssue(data, {
            code: ZodError_1.ZodIssueCode.too_small,
            minimum: 1,
            type: "array",
            inclusive: true,
            // message: this._def.minLength.message,
            // ...errorUtil.errToObj(this._def.minLength.message),
        });
    }
    if (invalid) {
        return parseUtil_1.INVALID;
    }
    var tasks = createTasks(ctx);
    var result = new Array(data.length);
    var type = def.type;
    var handleParsed = function (index, parsedItem) {
        if (parseUtil_1.isOk(parsedItem)) {
            result[index] = parsedItem.value;
        }
        else if (parseUtil_1.isInvalid(parsedItem)) {
            invalid = true;
        }
        else {
            tasks === null || tasks === void 0 ? void 0 : tasks.push(parsedItem.promise.then(function (parsed) { return handleParsed(index, parsed); }));
        }
    };
    data.forEach(function (item, index) {
        handleParsed(index, type._parse(ctx.stepInto(index), item, parseUtil_1.getParsedType(item)));
    });
    if (tasks !== null && tasks.length > 0) {
        return parseUtil_1.ASYNC(Promise.all(tasks).then(function () { return (invalid ? parseUtil_1.INVALID : parseUtil_1.OK(result)); }));
    }
    else {
        return invalid ? parseUtil_1.INVALID : parseUtil_1.OK(result);
    }
};
var ZodArray = /** @class */ (function (_super) {
    __extends(ZodArray, _super);
    function ZodArray() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.min = function (minLength, message) {
            return new ZodArray(__assign(__assign({}, _this._def), { minLength: { value: minLength, message: errorUtil_1.errorUtil.toString(message) } }));
        };
        _this.max = function (maxLength, message) {
            return new ZodArray(__assign(__assign({}, _this._def), { maxLength: { value: maxLength, message: errorUtil_1.errorUtil.toString(message) } }));
        };
        _this.length = function (len, message) {
            return _this.min(len, message).max(len, message);
        };
        _this.nonempty = function () {
            return new ZodNonEmptyArray(__assign({}, _this._def));
        };
        return _this;
    }
    ZodArray.prototype._parse = function (ctx, data, parsedType) {
        var nonEmpty = false;
        return parseArray(ctx, data, parsedType, this._def, nonEmpty);
    };
    Object.defineProperty(ZodArray.prototype, "element", {
        get: function () {
            return this._def.type;
        },
        enumerable: false,
        configurable: true
    });
    ZodArray.create = function (schema) {
        return new ZodArray({
            type: schema,
            minLength: null,
            maxLength: null,
        });
    };
    return ZodArray;
}(ZodType));
exports.ZodArray = ZodArray;
var ZodNonEmptyArray = /** @class */ (function (_super) {
    __extends(ZodNonEmptyArray, _super);
    function ZodNonEmptyArray() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.min = function (minLength, message) {
            return new ZodNonEmptyArray(__assign(__assign({}, _this._def), { minLength: { value: minLength, message: errorUtil_1.errorUtil.toString(message) } }));
        };
        _this.max = function (maxLength, message) {
            return new ZodNonEmptyArray(__assign(__assign({}, _this._def), { maxLength: { value: maxLength, message: errorUtil_1.errorUtil.toString(message) } }));
        };
        _this.length = function (len, message) {
            return _this.min(len, message).max(len, message);
        };
        return _this;
    }
    ZodNonEmptyArray.prototype._parse = function (ctx, data, parsedType) {
        var nonEmpty = true;
        return parseArray(ctx, data, parsedType, this._def, nonEmpty);
    };
    ZodNonEmptyArray.create = function (schema) {
        return new ZodNonEmptyArray({
            type: schema,
            minLength: null,
            maxLength: null,
        });
    };
    return ZodNonEmptyArray;
}(ZodType));
exports.ZodNonEmptyArray = ZodNonEmptyArray;
/////////////////////////////////////////
/////////////////////////////////////////
//////////                     //////////
//////////      ZodObject      //////////
//////////                     //////////
/////////////////////////////////////////
/////////////////////////////////////////
var objectUtil;
(function (objectUtil) {
    objectUtil.mergeShapes = function (first, second) {
        return __assign(__assign({}, first), second);
    };
    objectUtil.intersectShapes = function (first, second) {
        var e_5, _a;
        var firstKeys = Object.keys(first);
        var secondKeys = Object.keys(second);
        var sharedKeys = firstKeys.filter(function (k) { return secondKeys.indexOf(k) !== -1; });
        var sharedShape = {};
        try {
            for (var sharedKeys_1 = __values(sharedKeys), sharedKeys_1_1 = sharedKeys_1.next(); !sharedKeys_1_1.done; sharedKeys_1_1 = sharedKeys_1.next()) {
                var k = sharedKeys_1_1.value;
                sharedShape[k] = ZodIntersection.create(first[k], second[k]);
            }
        }
        catch (e_5_1) { e_5 = { error: e_5_1 }; }
        finally {
            try {
                if (sharedKeys_1_1 && !sharedKeys_1_1.done && (_a = sharedKeys_1.return)) _a.call(sharedKeys_1);
            }
            finally { if (e_5) throw e_5.error; }
        }
        return __assign(__assign(__assign({}, first), second), sharedShape);
    };
})(objectUtil = exports.objectUtil || (exports.objectUtil = {}));
var mergeObjects = function (first) { return function (second) {
    var mergedShape = objectUtil.mergeShapes(first._def.shape(), second._def.shape());
    var merged = new ZodObject({
        // effects: [...(first._def.effects || []), ...(second._def.effects || [])],
        unknownKeys: first._def.unknownKeys,
        catchall: first._def.catchall,
        shape: function () { return mergedShape; },
    });
    return merged;
}; };
exports.mergeObjects = mergeObjects;
var AugmentFactory = function (def) { return function (augmentation) {
    return new ZodObject(__assign(__assign({}, def), { shape: function () { return (__assign(__assign({}, def.shape()), augmentation)); } }));
}; };
var ZodObject = /** @class */ (function (_super) {
    __extends(ZodObject, _super);
    function ZodObject() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._cached = null;
        _this.strict = function () {
            return new ZodObject(__assign(__assign({}, _this._def), { unknownKeys: "strict" }));
        };
        _this.strip = function () {
            return new ZodObject(__assign(__assign({}, _this._def), { unknownKeys: "strip" }));
        };
        _this.passthrough = function () {
            return new ZodObject(__assign(__assign({}, _this._def), { unknownKeys: "passthrough" }));
        };
        /**
         * @deprecated In most cases, this is no longer needed - unknown properties are now silently stripped.
         * If you want to pass through unknown properies, use `.passthrough()` instead.
         */
        _this.nonstrict = _this.passthrough;
        _this.augment = AugmentFactory(_this._def);
        _this.extend = AugmentFactory(_this._def);
        _this.setKey = function (key, schema) {
            var _a;
            return _this.augment((_a = {}, _a[key] = schema, _a));
        };
        /**
         * Prior to zod@1.0.12 there was a bug in the
         * inferred type of merged objects. Please
         * upgrade if you are experiencing issues.
         */
        _this.merge = function (merging) {
            var mergedShape = objectUtil.mergeShapes(_this._def.shape(), merging._def.shape());
            var merged = new ZodObject({
                // effects: [], // wipe all refinements
                unknownKeys: merging._def.unknownKeys,
                catchall: merging._def.catchall,
                shape: function () { return mergedShape; },
            });
            return merged;
        };
        _this.catchall = function (index) {
            return new ZodObject(__assign(__assign({}, _this._def), { catchall: index }));
        };
        _this.pick = function (mask) {
            var shape = {};
            Object.keys(mask).map(function (key) {
                shape[key] = _this.shape[key];
            });
            return new ZodObject(__assign(__assign({}, _this._def), { shape: function () { return shape; } }));
        };
        _this.omit = function (mask) {
            var shape = {};
            Object.keys(_this.shape).map(function (key) {
                if (Object.keys(mask).indexOf(key) === -1) {
                    shape[key] = _this.shape[key];
                }
            });
            return new ZodObject(__assign(__assign({}, _this._def), { shape: function () { return shape; } }));
        };
        _this.partial = function () {
            var newShape = {};
            for (var key in _this.shape) {
                var fieldSchema = _this.shape[key];
                newShape[key] = fieldSchema.isOptional()
                    ? fieldSchema
                    : fieldSchema.optional();
            }
            return new ZodObject(__assign(__assign({}, _this._def), { shape: function () { return newShape; } }));
        };
        _this.deepPartial = function () {
            var newShape = {};
            for (var key in _this.shape) {
                var fieldSchema = _this.shape[key];
                if (fieldSchema instanceof ZodObject) {
                    newShape[key] = fieldSchema.isOptional()
                        ? fieldSchema
                        : fieldSchema.deepPartial().optional();
                }
                else {
                    newShape[key] = fieldSchema.isOptional()
                        ? fieldSchema
                        : fieldSchema.optional();
                }
            }
            return new ZodObject(__assign(__assign({}, _this._def), { shape: function () { return newShape; } }));
        };
        _this.required = function () {
            var newShape = {};
            for (var key in _this.shape) {
                var fieldSchema = _this.shape[key];
                var newField = fieldSchema;
                while (newField instanceof ZodOptional) {
                    newField = newField._def.innerType;
                }
                newShape[key] = newField;
            }
            return new ZodObject(__assign(__assign({}, _this._def), { shape: function () { return newShape; } }));
        };
        return _this;
    }
    ZodObject.prototype._getCached = function () {
        if (this._cached !== null)
            return this._cached;
        var shape = this._def.shape();
        var keys = Object.keys(shape);
        return (this._cached = { shape: shape, keys: keys });
    };
    ZodObject.prototype._parse = function (ctx, data, parsedType) {
        var e_6, _a, e_7, _b, e_8, _c;
        if (parsedType !== parseUtil_1.ZodParsedType.object) {
            ctx.addIssue(data, {
                code: ZodError_1.ZodIssueCode.invalid_type,
                expected: parseUtil_1.ZodParsedType.object,
                received: parsedType,
            });
            return parseUtil_1.INVALID;
        }
        var _d = this._getCached(), shape = _d.shape, shapeKeys = _d.keys;
        var invalid = false;
        var tasks = createTasks(ctx);
        var resultObject = {};
        var handleParsed = function (key, parsedValue) {
            if (parseUtil_1.isOk(parsedValue)) {
                var value = parsedValue.value;
                if (typeof value !== "undefined" || key in data) {
                    // key was valid but result was undefined: add it to the result object
                    // only if key was in the input data object - if it wasn't, then it's
                    // an optional key that should not be added
                    resultObject[key] = value;
                }
            }
            else if (parseUtil_1.isInvalid(parsedValue)) {
                invalid = true;
            }
            else {
                tasks === null || tasks === void 0 ? void 0 : tasks.push(parsedValue.promise.then(function (parsed) { return handleParsed(key, parsed); }));
            }
        };
        try {
            for (var shapeKeys_1 = __values(shapeKeys), shapeKeys_1_1 = shapeKeys_1.next(); !shapeKeys_1_1.done; shapeKeys_1_1 = shapeKeys_1.next()) {
                var key = shapeKeys_1_1.value;
                var keyValidator = shape[key];
                var value = data[key];
                handleParsed(key, keyValidator._parse(ctx.stepInto(key), value, parseUtil_1.getParsedType(value)));
            }
        }
        catch (e_6_1) { e_6 = { error: e_6_1 }; }
        finally {
            try {
                if (shapeKeys_1_1 && !shapeKeys_1_1.done && (_a = shapeKeys_1.return)) _a.call(shapeKeys_1);
            }
            finally { if (e_6) throw e_6.error; }
        }
        if (this._def.catchall instanceof ZodNever) {
            var unknownKeys = this._def.unknownKeys;
            if (unknownKeys === "passthrough") {
                var dataKeys = Object.keys(data);
                var extraKeys = dataKeys.filter(function (k) { return !(k in shape); });
                try {
                    for (var extraKeys_1 = __values(extraKeys), extraKeys_1_1 = extraKeys_1.next(); !extraKeys_1_1.done; extraKeys_1_1 = extraKeys_1.next()) {
                        var key = extraKeys_1_1.value;
                        resultObject[key] = data[key];
                    }
                }
                catch (e_7_1) { e_7 = { error: e_7_1 }; }
                finally {
                    try {
                        if (extraKeys_1_1 && !extraKeys_1_1.done && (_b = extraKeys_1.return)) _b.call(extraKeys_1);
                    }
                    finally { if (e_7) throw e_7.error; }
                }
            }
            else if (unknownKeys === "strict") {
                var dataKeys = Object.keys(data);
                var extraKeys = dataKeys.filter(function (k) { return !(k in shape); });
                if (extraKeys.length > 0) {
                    invalid = true;
                    ctx.addIssue(data, {
                        code: ZodError_1.ZodIssueCode.unrecognized_keys,
                        keys: extraKeys,
                    });
                }
            }
            else if (unknownKeys === "strip") {
            }
            else {
                throw new Error("Internal ZodObject error: invalid unknownKeys value.");
            }
        }
        else {
            // run catchall validation
            var catchall = this._def.catchall;
            var dataKeys = Object.keys(data);
            var extraKeys = dataKeys.filter(function (k) { return !(k in shape); });
            try {
                for (var extraKeys_2 = __values(extraKeys), extraKeys_2_1 = extraKeys_2.next(); !extraKeys_2_1.done; extraKeys_2_1 = extraKeys_2.next()) {
                    var key = extraKeys_2_1.value;
                    var value = data[key];
                    handleParsed(key, catchall._parse(ctx.stepInto(key), value, parseUtil_1.getParsedType(value)));
                }
            }
            catch (e_8_1) { e_8 = { error: e_8_1 }; }
            finally {
                try {
                    if (extraKeys_2_1 && !extraKeys_2_1.done && (_c = extraKeys_2.return)) _c.call(extraKeys_2);
                }
                finally { if (e_8) throw e_8.error; }
            }
        }
        if (tasks !== null && tasks.length > 0) {
            return parseUtil_1.ASYNC(Promise.all(tasks).then(function () {
                return invalid ? parseUtil_1.INVALID : parseUtil_1.OK(resultObject);
            }));
        }
        else {
            return invalid ? parseUtil_1.INVALID : parseUtil_1.OK(resultObject);
        }
    };
    Object.defineProperty(ZodObject.prototype, "shape", {
        get: function () {
            return this._def.shape();
        },
        enumerable: false,
        configurable: true
    });
    ZodObject.create = function (shape) {
        return new ZodObject({
            shape: function () { return shape; },
            unknownKeys: "strip",
            catchall: ZodNever.create(),
        });
    };
    ZodObject.strictCreate = function (shape) {
        return new ZodObject({
            shape: function () { return shape; },
            unknownKeys: "strict",
            catchall: ZodNever.create(),
        });
    };
    ZodObject.lazycreate = function (shape) {
        return new ZodObject({
            shape: shape,
            unknownKeys: "strip",
            catchall: ZodNever.create(),
        });
    };
    return ZodObject;
}(ZodType));
exports.ZodObject = ZodObject;
// export type toOpts<T> = T extends ZodUnionOptions ? T : never;
// export type ZodUnionType<
//   A extends ZodTypeAny,
//   B extends ZodTypeAny
// > = A extends ZodUnion<infer AOpts>
//   ? B extends ZodUnion<infer BOpts>
//     ? ZodUnion<toOpts<[...AOpts, ...BOpts]>>
//     : ZodUnion<toOpts<[...AOpts, B]>>
//   : B extends ZodUnion<infer BOpts>
//   ? ZodUnion<toOpts<[A, ...BOpts]>>
//   : ZodUnion<toOpts<[A, B]>>;
var ZodUnion = /** @class */ (function (_super) {
    __extends(ZodUnion, _super);
    function ZodUnion() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodUnion.prototype._parse = function (ctx, data, parsedType) {
        var e_9, _a;
        var options = this._def.options;
        var noMatch = function (allIssues) {
            var unionErrors = allIssues.map(function (issues) { return new ZodError_1.ZodError(issues); });
            var nonTypeErrors = unionErrors.filter(function (err) {
                return err.issues[0].code !== "invalid_type";
            });
            if (nonTypeErrors.length === 1) {
                // TODO encapsulate
                nonTypeErrors[0].issues.forEach(function (issue) { return ctx.issues.push(issue); });
            }
            else {
                ctx.addIssue(data, {
                    code: ZodError_1.ZodIssueCode.invalid_union,
                    unionErrors: unionErrors,
                });
            }
            return parseUtil_1.INVALID;
        };
        if (ctx.params.async) {
            var contexts_1 = options.map(function () { return new parseUtil_1.ParseContext(ctx.path, [], ctx.params); });
            return PseudoPromise_1.PseudoPromise.all(options.map(function (option, index) {
                return option._parse(contexts_1[index], data, parsedType);
            })).then(function (parsedOptions) {
                var e_10, _a;
                try {
                    for (var parsedOptions_1 = __values(parsedOptions), parsedOptions_1_1 = parsedOptions_1.next(); !parsedOptions_1_1.done; parsedOptions_1_1 = parsedOptions_1.next()) {
                        var parsedOption = parsedOptions_1_1.value;
                        if (parseUtil_1.isOk(parsedOption)) {
                            return parsedOption;
                        }
                    }
                }
                catch (e_10_1) { e_10 = { error: e_10_1 }; }
                finally {
                    try {
                        if (parsedOptions_1_1 && !parsedOptions_1_1.done && (_a = parsedOptions_1.return)) _a.call(parsedOptions_1);
                    }
                    finally { if (e_10) throw e_10.error; }
                }
                return noMatch(contexts_1.map(function (ctx) { return ctx.issues; }));
            });
        }
        else {
            var allIssues = [];
            try {
                for (var options_1 = __values(options), options_1_1 = options_1.next(); !options_1_1.done; options_1_1 = options_1.next()) {
                    var option = options_1_1.value;
                    var optionCtx = new parseUtil_1.ParseContext(ctx.path, [], ctx.params);
                    var parsedOption = option._parseSync(optionCtx, data, parsedType);
                    if (parseUtil_1.isInvalid(parsedOption)) {
                        allIssues.push(optionCtx.issues);
                    }
                    else {
                        return parsedOption;
                    }
                }
            }
            catch (e_9_1) { e_9 = { error: e_9_1 }; }
            finally {
                try {
                    if (options_1_1 && !options_1_1.done && (_a = options_1.return)) _a.call(options_1);
                }
                finally { if (e_9) throw e_9.error; }
            }
            return noMatch(allIssues);
        }
    };
    Object.defineProperty(ZodUnion.prototype, "options", {
        get: function () {
            return this._def.options;
        },
        enumerable: false,
        configurable: true
    });
    ZodUnion.create = function (types) {
        return new ZodUnion({
            options: types,
        });
    };
    return ZodUnion;
}(ZodType));
exports.ZodUnion = ZodUnion;
function mergeValues(a, b) {
    var e_11, _a;
    var aType = parseUtil_1.getParsedType(a);
    var bType = parseUtil_1.getParsedType(b);
    if (a === b) {
        return { valid: true, data: a };
    }
    else if (aType === parseUtil_1.ZodParsedType.object && bType === parseUtil_1.ZodParsedType.object) {
        var bKeysSet_1 = new Set(Object.keys(b));
        var sharedKeys = Object.keys(a).filter(function (key) { return bKeysSet_1.has(key); });
        var newObj = __assign(__assign({}, a), b);
        try {
            for (var sharedKeys_2 = __values(sharedKeys), sharedKeys_2_1 = sharedKeys_2.next(); !sharedKeys_2_1.done; sharedKeys_2_1 = sharedKeys_2.next()) {
                var key = sharedKeys_2_1.value;
                var sharedValue = mergeValues(a[key], b[key]);
                if (!sharedValue.valid) {
                    return { valid: false };
                }
                newObj[key] = sharedValue.data;
            }
        }
        catch (e_11_1) { e_11 = { error: e_11_1 }; }
        finally {
            try {
                if (sharedKeys_2_1 && !sharedKeys_2_1.done && (_a = sharedKeys_2.return)) _a.call(sharedKeys_2);
            }
            finally { if (e_11) throw e_11.error; }
        }
        return { valid: true, data: newObj };
    }
    else {
        return { valid: false };
    }
}
var ZodIntersection = /** @class */ (function (_super) {
    __extends(ZodIntersection, _super);
    function ZodIntersection() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodIntersection.prototype._parse = function (ctx, data, parsedType) {
        var handleParsed = function (parsedLeft, parsedRight) {
            if (parseUtil_1.isInvalid(parsedLeft) || parseUtil_1.isInvalid(parsedRight)) {
                return parseUtil_1.INVALID;
            }
            var merged = mergeValues(parsedLeft.value, parsedRight.value);
            if (!merged.valid) {
                ctx.addIssue(data, {
                    code: ZodError_1.ZodIssueCode.invalid_intersection_types,
                });
                return parseUtil_1.INVALID;
            }
            return parseUtil_1.OK(merged.data);
        };
        if (ctx.params.async) {
            return PseudoPromise_1.PseudoPromise.all([
                this._def.left._parse(ctx, data, parsedType),
                this._def.right._parse(ctx, data, parsedType),
            ]).then(function (_a) {
                var _b = __read(_a, 2), left = _b[0], right = _b[1];
                return handleParsed(left, right);
            });
        }
        else {
            return handleParsed(this._def.left._parseSync(ctx, data, parsedType), this._def.right._parseSync(ctx, data, parsedType));
        }
    };
    ZodIntersection.create = function (left, right) {
        return new ZodIntersection({
            left: left,
            right: right,
        });
    };
    return ZodIntersection;
}(ZodType));
exports.ZodIntersection = ZodIntersection;
var ZodTuple = /** @class */ (function (_super) {
    __extends(ZodTuple, _super);
    function ZodTuple() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodTuple.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType !== parseUtil_1.ZodParsedType.array) {
            ctx.addIssue(data, {
                code: ZodError_1.ZodIssueCode.invalid_type,
                expected: parseUtil_1.ZodParsedType.array,
                received: parsedType,
            });
            return parseUtil_1.INVALID;
        }
        if (data.length > this._def.items.length) {
            ctx.addIssue(data, {
                code: ZodError_1.ZodIssueCode.too_big,
                maximum: this._def.items.length,
                inclusive: true,
                type: "array",
            });
            return parseUtil_1.INVALID;
        }
        else if (data.length < this._def.items.length) {
            ctx.addIssue(data, {
                code: ZodError_1.ZodIssueCode.too_small,
                minimum: this._def.items.length,
                inclusive: true,
                type: "array",
            });
            return parseUtil_1.INVALID;
        }
        var tasks = createTasks(ctx);
        var items = this._def.items;
        var parseResult = new Array(items.length);
        var invalid = false;
        var handleParsed = function (index, parsedItem) {
            if (parseUtil_1.isOk(parsedItem)) {
                parseResult[index] = parsedItem.value;
            }
            else if (parseUtil_1.isInvalid(parsedItem)) {
                invalid = true;
            }
            else {
                tasks === null || tasks === void 0 ? void 0 : tasks.push(parsedItem.promise.then(function (parsed) { return handleParsed(index, parsed); }));
            }
        };
        items.forEach(function (item, index) {
            handleParsed(index, item._parse(ctx.stepInto(index), data[index], parseUtil_1.getParsedType(data[index])));
        });
        if (tasks !== null && tasks.length > 0) {
            return parseUtil_1.ASYNC(Promise.all(tasks).then(function () { return (invalid ? parseUtil_1.INVALID : parseUtil_1.OK(parseResult)); }));
        }
        else {
            return invalid ? parseUtil_1.INVALID : parseUtil_1.OK(parseResult);
        }
    };
    Object.defineProperty(ZodTuple.prototype, "items", {
        get: function () {
            return this._def.items;
        },
        enumerable: false,
        configurable: true
    });
    ZodTuple.create = function (schemas) {
        return new ZodTuple({
            items: schemas,
        });
    };
    return ZodTuple;
}(ZodType));
exports.ZodTuple = ZodTuple;
var ZodRecord = /** @class */ (function (_super) {
    __extends(ZodRecord, _super);
    function ZodRecord() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodRecord.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType !== parseUtil_1.ZodParsedType.object) {
            ctx.addIssue(data, {
                code: ZodError_1.ZodIssueCode.invalid_type,
                expected: parseUtil_1.ZodParsedType.object,
                received: parsedType,
            });
            return parseUtil_1.INVALID;
        }
        var tasks = createTasks(ctx);
        var valueType = this._def.valueType;
        var parseResult = {};
        var invalid = false;
        var handleParsed = function (key, parsedKey) {
            if (parseUtil_1.isOk(parsedKey)) {
                parseResult[key] = parsedKey.value;
            }
            else if (parseUtil_1.isInvalid(parsedKey)) {
                invalid = true;
            }
            else {
                tasks === null || tasks === void 0 ? void 0 : tasks.push(parsedKey.promise.then(function (parsed) { return handleParsed(key, parsed); }));
            }
        };
        for (var key in data) {
            handleParsed(key, valueType._parse(ctx.stepInto(key), data[key], parseUtil_1.getParsedType(data[key])));
        }
        if (tasks !== null && tasks.length > 0) {
            return parseUtil_1.ASYNC(Promise.all(tasks).then(function () { return (invalid ? parseUtil_1.INVALID : parseUtil_1.OK(parseResult)); }));
        }
        else {
            return invalid ? parseUtil_1.INVALID : parseUtil_1.OK(parseResult);
        }
    };
    ZodRecord.create = function (valueType) {
        return new ZodRecord({
            valueType: valueType,
        });
    };
    return ZodRecord;
}(ZodType));
exports.ZodRecord = ZodRecord;
var ZodMap = /** @class */ (function (_super) {
    __extends(ZodMap, _super);
    function ZodMap() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodMap.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType !== parseUtil_1.ZodParsedType.map) {
            ctx.addIssue(data, {
                code: ZodError_1.ZodIssueCode.invalid_type,
                expected: parseUtil_1.ZodParsedType.map,
                received: parsedType,
            });
            return parseUtil_1.INVALID;
        }
        var keyType = this._def.keyType;
        var valueType = this._def.valueType;
        var dataMap = data;
        var parseResult = new Map();
        var tasks = createTasks(ctx);
        var invalid = false;
        var handleParsed = function (parsedKey, parsedValue) {
            if (parseUtil_1.isAsync(parsedKey) || parseUtil_1.isAsync(parsedValue)) {
                tasks === null || tasks === void 0 ? void 0 : tasks.push(PseudoPromise_1.PseudoPromise.all([parsedKey, parsedValue]).promise.then(function (_a) {
                    var _b = __read(_a, 2), k = _b[0], v = _b[1];
                    return handleParsed(k, v);
                }));
            }
            else if (parseUtil_1.isInvalid(parsedKey) || parseUtil_1.isInvalid(parsedValue)) {
                invalid = true;
            }
            else {
                parseResult.set(parsedKey.value, parsedValue.value);
            }
        };
        __spreadArray([], __read(dataMap.entries())).forEach(function (_a, index) {
            var _b = __read(_a, 2), key = _b[0], value = _b[1];
            var entryCtx = ctx.stepInto(index);
            var parsedKey = keyType._parse(entryCtx.stepInto("key"), key, parseUtil_1.getParsedType(key));
            var parsedValue = valueType._parse(entryCtx.stepInto("value"), value, parseUtil_1.getParsedType(value));
            handleParsed(parsedKey, parsedValue);
        });
        if (tasks !== null && tasks.length > 0) {
            return parseUtil_1.ASYNC(Promise.all(tasks).then(function () { return (invalid ? parseUtil_1.INVALID : parseUtil_1.OK(parseResult)); }));
        }
        else {
            return invalid ? parseUtil_1.INVALID : parseUtil_1.OK(parseResult);
        }
    };
    ZodMap.create = function (keyType, valueType) {
        return new ZodMap({
            valueType: valueType,
            keyType: keyType,
        });
    };
    return ZodMap;
}(ZodType));
exports.ZodMap = ZodMap;
var ZodSet = /** @class */ (function (_super) {
    __extends(ZodSet, _super);
    function ZodSet() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodSet.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType !== parseUtil_1.ZodParsedType.set) {
            ctx.addIssue(data, {
                code: ZodError_1.ZodIssueCode.invalid_type,
                expected: parseUtil_1.ZodParsedType.set,
                received: parsedType,
            });
            return parseUtil_1.INVALID;
        }
        var dataSet = data;
        var valueType = this._def.valueType;
        var parsedSet = new Set();
        var tasks = createTasks(ctx);
        var invalid = false;
        var handleParsed = function (parsedItem) {
            if (parseUtil_1.isOk(parsedItem)) {
                parsedSet.add(parsedItem.value);
            }
            else if (parseUtil_1.isInvalid(parsedItem)) {
                invalid = true;
            }
            else {
                tasks === null || tasks === void 0 ? void 0 : tasks.push(parsedItem.promise.then(function (parsed) { return handleParsed(parsed); }));
            }
        };
        __spreadArray([], __read(dataSet.values())).forEach(function (item, i) {
            return handleParsed(valueType._parse(ctx.stepInto(i), item, parseUtil_1.getParsedType(item)));
        });
        if (tasks !== null && tasks.length > 0) {
            return parseUtil_1.ASYNC(Promise.all(tasks).then(function () { return (invalid ? parseUtil_1.INVALID : parseUtil_1.OK(parsedSet)); }));
        }
        else {
            return invalid ? parseUtil_1.INVALID : parseUtil_1.OK(parsedSet);
        }
    };
    ZodSet.create = function (valueType) {
        return new ZodSet({
            valueType: valueType,
        });
    };
    return ZodSet;
}(ZodType));
exports.ZodSet = ZodSet;
var ZodFunction = /** @class */ (function (_super) {
    __extends(ZodFunction, _super);
    function ZodFunction() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.args = function () {
            var items = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                items[_i] = arguments[_i];
            }
            return new ZodFunction(__assign(__assign({}, _this._def), { args: ZodTuple.create(items) }));
        };
        _this.returns = function (returnType) {
            return new ZodFunction(__assign(__assign({}, _this._def), { returns: returnType }));
        };
        _this.implement = function (func) {
            var validatedFunc = _this.parse(func);
            return validatedFunc;
        };
        _this.strictImplement = function (func) {
            var validatedFunc = _this.parse(func);
            return validatedFunc;
        };
        _this.validate = _this.implement;
        return _this;
    }
    ZodFunction.prototype._parse = function (ctx, data, parsedType) {
        var _this = this;
        if (parsedType !== parseUtil_1.ZodParsedType.function) {
            ctx.addIssue(data, {
                code: ZodError_1.ZodIssueCode.invalid_type,
                expected: parseUtil_1.ZodParsedType.function,
                received: parsedType,
            });
            return parseUtil_1.INVALID;
        }
        var handleArgs = function (args, parsedArgs) {
            if (!parsedArgs.success) {
                var issue = parseUtil_1.makeIssue(args, parseUtil_1.pathToArray(ctx.path), ctx.params.errorMap, {
                    code: ZodError_1.ZodIssueCode.invalid_arguments,
                    argumentsError: parsedArgs.error,
                });
                throw new ZodError_1.ZodError([issue]);
            }
            return parsedArgs.data;
        };
        var handleReturns = function (returns, parsedReturns) {
            if (!parsedReturns.success) {
                var issue = parseUtil_1.makeIssue(returns, parseUtil_1.pathToArray(ctx.path), ctx.params.errorMap, {
                    code: ZodError_1.ZodIssueCode.invalid_return_type,
                    returnTypeError: parsedReturns.error,
                });
                throw new ZodError_1.ZodError([issue]);
            }
            return parsedReturns.data;
        };
        var params = { errorMap: ctx.params.errorMap };
        var fn = data;
        if (this._def.returns instanceof ZodPromise) {
            return parseUtil_1.OK(function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                return __awaiter(_this, void 0, void 0, function () {
                    var parsedArgs, _a, _b, result, _c, _d;
                    return __generator(this, function (_e) {
                        switch (_e.label) {
                            case 0:
                                _a = handleArgs;
                                _b = [args];
                                return [4 /*yield*/, this._def.args.spa(args, params)];
                            case 1:
                                parsedArgs = _a.apply(void 0, _b.concat([_e.sent()]));
                                return [4 /*yield*/, fn.apply(void 0, __spreadArray([], __read(parsedArgs)))];
                            case 2:
                                result = _e.sent();
                                _c = handleReturns;
                                _d = [result];
                                return [4 /*yield*/, this._def.returns.spa(result, params)];
                            case 3: return [2 /*return*/, _c.apply(void 0, _d.concat([_e.sent()]))];
                        }
                    });
                });
            });
        }
        else {
            return parseUtil_1.OK(function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                var parsedArgs = handleArgs(args, _this._def.args.safeParse(args, params));
                var result = fn.apply(void 0, __spreadArray([], __read(parsedArgs)));
                return handleReturns(result, _this._def.returns.safeParse(result, params));
            });
        }
    };
    ZodFunction.prototype.parameters = function () {
        return this._def.args;
    };
    ZodFunction.prototype.returnType = function () {
        return this._def.returns;
    };
    ZodFunction.create = function (args, returns) {
        return new ZodFunction({
            args: args || ZodTuple.create([]),
            returns: returns || ZodUnknown.create(),
        });
    };
    return ZodFunction;
}(ZodType));
exports.ZodFunction = ZodFunction;
var ZodLazy = /** @class */ (function (_super) {
    __extends(ZodLazy, _super);
    function ZodLazy() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(ZodLazy.prototype, "schema", {
        get: function () {
            return this._def.getter();
        },
        enumerable: false,
        configurable: true
    });
    ZodLazy.prototype._parse = function (ctx, data, parsedType) {
        var lazySchema = this._def.getter();
        return lazySchema._parse(ctx, data, parsedType);
    };
    ZodLazy.create = function (getter) {
        return new ZodLazy({
            getter: getter,
        });
    };
    return ZodLazy;
}(ZodType));
exports.ZodLazy = ZodLazy;
var ZodLiteral = /** @class */ (function (_super) {
    __extends(ZodLiteral, _super);
    function ZodLiteral() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodLiteral.prototype._parse = function (ctx, data, _parsedType) {
        if (data !== this._def.value) {
            ctx.addIssue(data, {
                code: ZodError_1.ZodIssueCode.invalid_type,
                expected: this._def.value,
                received: data,
            });
            return parseUtil_1.INVALID;
        }
        return parseUtil_1.OK(data);
    };
    ZodLiteral.create = function (value) {
        return new ZodLiteral({
            value: value,
        });
    };
    return ZodLiteral;
}(ZodType));
exports.ZodLiteral = ZodLiteral;
var ZodEnum = /** @class */ (function (_super) {
    __extends(ZodEnum, _super);
    function ZodEnum() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodEnum.prototype._parse = function (ctx, data, _parsedType) {
        if (this._def.values.indexOf(data) === -1) {
            ctx.addIssue(data, {
                code: ZodError_1.ZodIssueCode.invalid_enum_value,
                options: this._def.values,
            });
            return parseUtil_1.INVALID;
        }
        return parseUtil_1.OK(data);
    };
    Object.defineProperty(ZodEnum.prototype, "options", {
        get: function () {
            return this._def.values;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ZodEnum.prototype, "enum", {
        get: function () {
            var e_12, _a;
            var enumValues = {};
            try {
                for (var _b = __values(this._def.values), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var val = _c.value;
                    enumValues[val] = val;
                }
            }
            catch (e_12_1) { e_12 = { error: e_12_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_12) throw e_12.error; }
            }
            return enumValues;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ZodEnum.prototype, "Values", {
        get: function () {
            var e_13, _a;
            var enumValues = {};
            try {
                for (var _b = __values(this._def.values), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var val = _c.value;
                    enumValues[val] = val;
                }
            }
            catch (e_13_1) { e_13 = { error: e_13_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_13) throw e_13.error; }
            }
            return enumValues;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ZodEnum.prototype, "Enum", {
        get: function () {
            var e_14, _a;
            var enumValues = {};
            try {
                for (var _b = __values(this._def.values), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var val = _c.value;
                    enumValues[val] = val;
                }
            }
            catch (e_14_1) { e_14 = { error: e_14_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_14) throw e_14.error; }
            }
            return enumValues;
        },
        enumerable: false,
        configurable: true
    });
    ZodEnum.create = function (values) {
        return new ZodEnum({
            values: values,
        });
    };
    return ZodEnum;
}(ZodType));
exports.ZodEnum = ZodEnum;
var ZodNativeEnum = /** @class */ (function (_super) {
    __extends(ZodNativeEnum, _super);
    function ZodNativeEnum() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodNativeEnum.prototype._parse = function (ctx, data, _parsedType) {
        var nativeEnumValues = util_1.util.getValidEnumValues(this._def.values);
        if (nativeEnumValues.indexOf(data) === -1) {
            ctx.addIssue(data, {
                code: ZodError_1.ZodIssueCode.invalid_enum_value,
                options: util_1.util.objectValues(nativeEnumValues),
            });
            return parseUtil_1.INVALID;
        }
        return parseUtil_1.OK(data);
    };
    ZodNativeEnum.create = function (values) {
        return new ZodNativeEnum({
            values: values,
        });
    };
    return ZodNativeEnum;
}(ZodType));
exports.ZodNativeEnum = ZodNativeEnum;
var ZodPromise = /** @class */ (function (_super) {
    __extends(ZodPromise, _super);
    function ZodPromise() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodPromise.prototype._parse = function (ctx, data, parsedType) {
        var _this = this;
        if (parsedType !== parseUtil_1.ZodParsedType.promise && ctx.params.async === false) {
            ctx.addIssue(data, {
                code: ZodError_1.ZodIssueCode.invalid_type,
                expected: parseUtil_1.ZodParsedType.promise,
                received: parsedType,
            });
            return parseUtil_1.INVALID;
        }
        var promisified = parsedType === parseUtil_1.ZodParsedType.promise ? data : Promise.resolve(data);
        return parseUtil_1.OK(promisified.then(function (data) {
            return _this._def.type.parseAsync(data, {
                path: parseUtil_1.pathToArray(ctx.path),
                errorMap: ctx.params.errorMap,
            });
        }));
    };
    ZodPromise.create = function (schema) {
        return new ZodPromise({
            type: schema,
        });
    };
    return ZodPromise;
}(ZodType));
exports.ZodPromise = ZodPromise;
var ZodEffects = /** @class */ (function (_super) {
    __extends(ZodEffects, _super);
    function ZodEffects(def) {
        return _super.call(this, def) || this;
        // if (def.schema instanceof ZodEffects) {
        //   throw new Error("ZodEffects cannot be nested.");
        // }
    }
    ZodEffects.prototype.innerType = function () {
        return this._def.schema;
    };
    ZodEffects.prototype._parse = function (ctx, data, parsedType) {
        var isSync = ctx.params.async === false;
        var effects = this._def.effects || [];
        var checkCtx = {
            addIssue: function (arg) {
                ctx.addIssue(data, arg);
            },
            get path() {
                return parseUtil_1.pathToArray(ctx.path);
            },
        };
        var invalid = false;
        var applyEffect = function (acc, effect) {
            switch (effect.type) {
                case "refinement":
                    var result = effect.refinement(acc, checkCtx);
                    if (result instanceof Promise) {
                        if (isSync) {
                            throw new Error("You can't use .parse() on a schema containing async refinements. Use .parseAsync instead.");
                        }
                        else {
                            return result.then(function (res) {
                                invalid = invalid || !res;
                                return acc;
                            });
                        }
                    }
                    else {
                        invalid = invalid || !result;
                        return acc;
                    }
                case "transform":
                    var transformed = effect.transform(acc);
                    if (transformed instanceof Promise && isSync) {
                        throw new Error("You can't use .parse() on a schema containing async transformations. Use .parseAsync instead.");
                    }
                    return transformed;
                default:
                    throw new Error("Invalid effect type.");
            }
        };
        if (isSync) {
            var base = this._def.schema._parseSync(ctx, data, parsedType);
            if (parseUtil_1.isOk(base)) {
                var result = effects.reduce(applyEffect, base.value);
                return invalid ? parseUtil_1.INVALID : parseUtil_1.OK(result);
            }
            else {
                return parseUtil_1.INVALID;
            }
        }
        else {
            var applyAsyncEffects_1 = function (base) {
                var result = effects.reduce(function (acc, eff) {
                    return acc instanceof Promise
                        ? acc.then(function (val) { return applyEffect(val, eff); })
                        : applyEffect(acc, eff);
                }, base);
                if (result instanceof Promise) {
                    return parseUtil_1.ASYNC(result.then(function (val) { return (invalid ? parseUtil_1.INVALID : parseUtil_1.OK(val)); }));
                }
                else {
                    return invalid ? parseUtil_1.INVALID : parseUtil_1.OK(result);
                }
            };
            var baseResult = this._def.schema._parse(ctx, data, parsedType);
            if (parseUtil_1.isOk(baseResult)) {
                return applyAsyncEffects_1(baseResult.value);
            }
            else if (parseUtil_1.isInvalid(baseResult)) {
                return parseUtil_1.INVALID;
            }
            else {
                return parseUtil_1.ASYNC(baseResult.promise.then(function (base) {
                    if (parseUtil_1.isInvalid(base))
                        return parseUtil_1.INVALID;
                    var result = applyAsyncEffects_1(base.value);
                    return parseUtil_1.isAsync(result) ? result.promise : result;
                }));
            }
        }
    };
    ZodEffects.create = function (schema) {
        var newTx = new ZodEffects({
            schema: schema,
        });
        return newTx;
    };
    return ZodEffects;
}(ZodType));
exports.ZodEffects = ZodEffects;
exports.ZodTransformer = ZodEffects;
var ZodOptional = /** @class */ (function (_super) {
    __extends(ZodOptional, _super);
    function ZodOptional() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodOptional.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType === parseUtil_1.ZodParsedType.undefined) {
            return parseUtil_1.OK(undefined);
        }
        return this._def.innerType._parse(ctx, data, parsedType);
    };
    ZodOptional.prototype.unwrap = function () {
        return this._def.innerType;
    };
    ZodOptional.create = function (type) {
        return new ZodOptional({
            innerType: type,
        });
    };
    return ZodOptional;
}(ZodType));
exports.ZodOptional = ZodOptional;
var ZodNullable = /** @class */ (function (_super) {
    __extends(ZodNullable, _super);
    function ZodNullable() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodNullable.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType === parseUtil_1.ZodParsedType.null) {
            return parseUtil_1.OK(null);
        }
        return this._def.innerType._parse(ctx, data, parsedType);
    };
    ZodNullable.prototype.unwrap = function () {
        return this._def.innerType;
    };
    ZodNullable.create = function (type) {
        return new ZodNullable({
            innerType: type,
        });
    };
    return ZodNullable;
}(ZodType));
exports.ZodNullable = ZodNullable;
var ZodDefault = /** @class */ (function (_super) {
    __extends(ZodDefault, _super);
    function ZodDefault() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZodDefault.prototype._parse = function (ctx, data, parsedType) {
        if (parsedType === parseUtil_1.ZodParsedType.undefined) {
            data = this._def.defaultValue();
        }
        return this._def.innerType._parse(ctx, data, parseUtil_1.getParsedType(data));
    };
    ZodDefault.prototype.removeDefault = function () {
        return this._def.innerType;
    };
    ZodDefault.create = function (type) {
        return new ZodOptional({
            innerType: type,
        });
    };
    return ZodDefault;
}(ZodType));
exports.ZodDefault = ZodDefault;
var custom = function (check, params) {
    if (check)
        return ZodAny.create().refine(check, params);
    return ZodAny.create();
};
exports.custom = custom;
exports.late = {
    object: ZodObject.lazycreate,
};
var instanceOfType = function (cls, params) {
    if (params === void 0) { params = {
        message: "Input not instance of " + cls.name,
    }; }
    return exports.custom(function (data) { return data instanceof cls; }, params);
};
exports.instanceof = instanceOfType;
var stringType = ZodString.create;
exports.string = stringType;
var numberType = ZodNumber.create;
exports.number = numberType;
var bigIntType = ZodBigInt.create;
exports.bigint = bigIntType;
var booleanType = ZodBoolean.create;
exports.boolean = booleanType;
var dateType = ZodDate.create;
exports.date = dateType;
var undefinedType = ZodUndefined.create;
exports.undefined = undefinedType;
var nullType = ZodNull.create;
exports.null = nullType;
var anyType = ZodAny.create;
exports.any = anyType;
var unknownType = ZodUnknown.create;
exports.unknown = unknownType;
var neverType = ZodNever.create;
exports.never = neverType;
var voidType = ZodVoid.create;
exports.void = voidType;
var arrayType = ZodArray.create;
exports.array = arrayType;
var objectType = ZodObject.create;
exports.object = objectType;
var strictObjectType = ZodObject.strictCreate;
exports.strictObject = strictObjectType;
var unionType = ZodUnion.create;
exports.union = unionType;
var intersectionType = ZodIntersection.create;
exports.intersection = intersectionType;
var tupleType = ZodTuple.create;
exports.tuple = tupleType;
var recordType = ZodRecord.create;
exports.record = recordType;
var mapType = ZodMap.create;
exports.map = mapType;
var setType = ZodSet.create;
exports.set = setType;
var functionType = ZodFunction.create;
exports.function = functionType;
var lazyType = ZodLazy.create;
exports.lazy = lazyType;
var literalType = ZodLiteral.create;
exports.literal = literalType;
var enumType = ZodEnum.create;
exports.enum = enumType;
var nativeEnumType = ZodNativeEnum.create;
exports.nativeEnum = nativeEnumType;
var promiseType = ZodPromise.create;
exports.promise = promiseType;
var effectsType = ZodEffects.create;
exports.effect = effectsType;
exports.transformer = effectsType;
var optionalType = ZodOptional.create;
exports.optional = optionalType;
var nullableType = ZodNullable.create;
exports.nullable = nullableType;
var ostring = function () { return stringType().optional(); };
exports.ostring = ostring;
var onumber = function () { return numberType().optional(); };
exports.onumber = onumber;
var oboolean = function () { return booleanType().optional(); };
exports.oboolean = oboolean;
//# sourceMappingURL=types.js.map