'use strict';
var log = [];
var logArgs = [];
var wtfMock = {
    log: log,
    logArgs: logArgs,
    reset: function () {
        log.length = 0;
        logArgs.length = 0;
    },
    trace: {
        leaveScope: function (scope, returnValue) {
            return scope(returnValue);
        },
        beginTimeRange: function (type, action) {
            logArgs.push([]);
            log.push('>>> ' + type + '[' + action + ']');
            return function () {
                logArgs.push([]);
                log.push('<<< ' + type);
            };
        },
        endTimeRange: function (range) {
            range();
        },
        events: {
            createScope: function (signature, flags) {
                var parts = signature.split('(');
                var name = parts[0];
                return function scopeFn() {
                    var args = [];
                    for (var i = arguments.length - 1; i >= 0; i--) {
                        var arg = arguments[i];
                        if (arg !== undefined) {
                            args.unshift(arg);
                        }
                    }
                    log.push('> ' + name + '(' + args.join(', ') + ')');
                    logArgs.push(args);
                    return function (retValue) {
                        log.push('< ' + name + (retValue == undefined ? '' : ' => ' + retValue));
                        logArgs.push(retValue);
                        return retValue;
                    };
                };
            },
            createInstance: function (signature, flags) {
                var parts = signature.split('(');
                var name = parts[0];
                return function eventFn() {
                    var args = [];
                    for (var i = arguments.length - 1; i >= 0; i--) {
                        var arg = arguments[i];
                        if (arg !== undefined) {
                            args.unshift(arg);
                        }
                    }
                    log.push('# ' + name + '(' + args.join(', ') + ')');
                    logArgs.push(args);
                };
            }
        }
    },
};
beforeEach(function () {
    wtfMock.reset();
});
window.wtfMock = wtfMock;
window.wtf = wtfMock;
//# sourceMappingURL=data:application/json;base64,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