var util_1 = require('../util');
function supportsImports() {
    return 'import' in document.createElement('link');
}
supportsImports.message = 'HTML Imports';
describe('HTML Imports', util_1.ifEnvSupports(supportsImports, function () {
    var testZone = global.zone.fork();
    it('should work with addEventListener', function (done) {
        var link;
        testZone.run(function () {
            link = document.createElement('link');
            link.rel = 'import';
            link.href = 'someUrl';
            link.addEventListener('error', function () {
                expect(global.zone).toBeDirectChildOf(testZone);
                document.head.removeChild(link);
                done();
            });
        });
        document.head.appendChild(link);
    });
    function supportsOnEvents() {
        var link = document.createElement('link');
        var linkPropDesc = Object.getOwnPropertyDescriptor(link, 'onerror');
        return !(linkPropDesc && linkPropDesc.value === null);
    }
    supportsOnEvents.message = 'Supports HTMLLinkElement#onxxx patching';
    util_1.ifEnvSupports(supportsOnEvents, function () {
        it('should work with onerror', function (done) {
            var link;
            testZone.run(function () {
                link = document.createElement('link');
                link.rel = 'import';
                link.href = 'anotherUrl';
                link.onerror = function () {
                    expect(global.zone).toBeDirectChildOf(testZone);
                    document.head.removeChild(link);
                    done();
                };
            });
            document.head.appendChild(link);
        });
        it('should work with onload', function (done) {
            var link;
            testZone.run(function () {
                link = document.createElement('link');
                link.rel = 'import';
                link.href = '/base/test/assets/import.html';
                link.onload = function () {
                    expect(global.zone).toBeDirectChildOf(testZone);
                    document.head.removeChild(link);
                    done();
                };
            });
            document.head.appendChild(link);
        });
    });
}));
//# sourceMappingURL=data:application/json;base64,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