var util_1 = require('../util');
describe('WebSocket', util_1.ifEnvSupports('WebSocket', function () {
    var socket;
    var TEST_SERVER_URL = 'ws://localhost:8001';
    var flag;
    var testZone = global.zone.fork();
    beforeEach(function (done) {
        socket = new WebSocket(TEST_SERVER_URL);
        socket.addEventListener('open', done);
        socket.addEventListener('error', function () {
            fail("Can't establish socket to " + TEST_SERVER_URL +
                "! do you have test/ws-server.js running?");
            done();
        });
    });
    afterEach(function (done) {
        socket.addEventListener('close', done);
        socket.close();
        done();
    });
    it('should work with addEventListener', function (done) {
        testZone.run(function () {
            socket.addEventListener('message', function (event) {
                expect(global.zone).toBeDirectChildOf(testZone);
                expect(event['data']).toBe('hi');
                done();
            });
        });
        socket.send('hi');
    });
    it('should respect removeEventListener', function (done) {
        var log = '';
        function logOnMessage() {
            log += 'a';
            expect(log).toEqual('a');
            socket.removeEventListener('message', logOnMessage);
            socket.send('hi');
            setTimeout(function () {
                expect(log).toEqual('a');
                done();
            }, 10);
        }
        ;
        socket.addEventListener('message', logOnMessage);
        socket.send('hi');
    });
    it('should work with onmessage', function (done) {
        testZone.run(function () {
            socket.onmessage = function (contents) {
                expect(global.zone).toBeDirectChildOf(testZone);
                expect(contents.data).toBe('hi');
                done();
            };
        });
        socket.send('hi');
    });
    it('should only allow one onmessage handler', function (done) {
        var log = '';
        socket.onmessage = function () {
            log += 'a';
            expect(log).toEqual('b');
            done();
        };
        socket.onmessage = function () {
            log += 'b';
            expect(log).toEqual('b');
            done();
        };
        socket.send('hi');
    });
    it('should handle removing onmessage', function (done) {
        var log = '';
        socket.onmessage = function () {
            log += 'a';
        };
        socket.onmessage = null;
        socket.send('hi');
        setTimeout(function () {
            expect(log).toEqual('');
            done();
        }, 100);
    });
}));
//# sourceMappingURL=data:application/json;base64,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