var util_1 = require('../util');
describe('XMLHttpRequest', function () {
    var testZone = global.zone.fork();
    it('should work with onreadystatechange', function (done) {
        var req;
        testZone.run(function () {
            req = new XMLHttpRequest();
            var firstCall = true;
            req.onreadystatechange = function () {
                // Make sure that the callback will only be called once
                req.onreadystatechange = null;
                expect(global.zone).toBeDirectChildOf(testZone);
                done();
            };
            req.open('get', '/', true);
        });
        req.send();
    });
    var supportsOnProgress = function () {
        return 'onprogress' in new XMLHttpRequest();
    };
    supportsOnProgress.message = "XMLHttpRequest.onprogress";
    describe('onprogress', util_1.ifEnvSupports(supportsOnProgress, function () {
        it('should work with onprogress', function (done) {
            var req;
            testZone.run(function () {
                req = new XMLHttpRequest();
                req.onprogress = function () {
                    // Make sure that the callback will only be called once
                    req.onprogress = null;
                    expect(global.zone).toBeDirectChildOf(testZone);
                    done();
                };
                req.open('get', '/', true);
            });
            req.send();
        });
    }));
    it('should preserve other setters', function () {
        var req = new XMLHttpRequest();
        req.open('get', '/', true);
        req.send();
        try {
            req.responseType = 'document';
            expect(req.responseType).toBe('document');
        }
        catch (e) {
            //Android browser: using this setter throws, this should be preserved
            expect(e.message).toBe('INVALID_STATE_ERR: DOM Exception 11');
        }
    });
    it('should preserve static constants', function () {
        expect(XMLHttpRequest.UNSENT).toEqual(0);
        expect(XMLHttpRequest.OPENED).toEqual(1);
        expect(XMLHttpRequest.HEADERS_RECEIVED).toEqual(2);
        expect(XMLHttpRequest.LOADING).toEqual(3);
        expect(XMLHttpRequest.DONE).toEqual(4);
    });
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiWE1MSHR0cFJlcXVlc3Quc3BlYy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3Rlc3QvcGF0Y2gvWE1MSHR0cFJlcXVlc3Quc3BlYy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxxQkFBNEIsU0FBUyxDQUFDLENBQUE7QUFFdEMsUUFBUSxDQUFDLGdCQUFnQixFQUFFO0lBQ3pCLElBQUksUUFBUSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFFbEMsRUFBRSxDQUFDLHFDQUFxQyxFQUFFLFVBQVUsSUFBSTtRQUN0RCxJQUFJLEdBQUcsQ0FBQztRQUVSLFFBQVEsQ0FBQyxHQUFHLENBQUM7WUFDWCxHQUFHLEdBQUcsSUFBSSxjQUFjLEVBQUUsQ0FBQztZQUMzQixJQUFJLFNBQVMsR0FBRyxJQUFJLENBQUM7WUFDckIsR0FBRyxDQUFDLGtCQUFrQixHQUFHO2dCQUN2Qix1REFBdUQ7Z0JBQ3ZELEdBQUcsQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUM7Z0JBQzlCLE1BQU0sQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLENBQUMsaUJBQWlCLENBQUMsUUFBUSxDQUFDLENBQUM7Z0JBQ2hELElBQUksRUFBRSxDQUFDO1lBQ1QsQ0FBQyxDQUFDO1lBQ0YsR0FBRyxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsR0FBRyxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQzdCLENBQUMsQ0FBQyxDQUFDO1FBRUgsR0FBRyxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ2IsQ0FBQyxDQUFDLENBQUM7SUFFSCxJQUFJLGtCQUFrQixHQUFHO1FBQ3ZCLE1BQU0sQ0FBQyxZQUFZLElBQUksSUFBSSxjQUFjLEVBQUUsQ0FBQztJQUM5QyxDQUFDLENBQUM7SUFDSSxrQkFBbUIsQ0FBQyxPQUFPLEdBQUcsMkJBQTJCLENBQUM7SUFFaEUsUUFBUSxDQUFDLFlBQVksRUFBRSxvQkFBYSxDQUFDLGtCQUFrQixFQUFFO1FBQ3ZELEVBQUUsQ0FBQyw2QkFBNkIsRUFBRSxVQUFVLElBQUk7WUFDOUMsSUFBSSxHQUFHLENBQUM7WUFDUixRQUFRLENBQUMsR0FBRyxDQUFDO2dCQUNYLEdBQUcsR0FBRyxJQUFJLGNBQWMsRUFBRSxDQUFDO2dCQUMzQixHQUFHLENBQUMsVUFBVSxHQUFHO29CQUNmLHVEQUF1RDtvQkFDdkQsR0FBRyxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7b0JBQ3RCLE1BQU0sQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLENBQUMsaUJBQWlCLENBQUMsUUFBUSxDQUFDLENBQUM7b0JBQ2hELElBQUksRUFBRSxDQUFDO2dCQUNULENBQUMsQ0FBQztnQkFDRixHQUFHLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRSxHQUFHLEVBQUUsSUFBSSxDQUFDLENBQUM7WUFDN0IsQ0FBQyxDQUFDLENBQUM7WUFFSCxHQUFHLENBQUMsSUFBSSxFQUFFLENBQUM7UUFDYixDQUFDLENBQUMsQ0FBQztJQUNMLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFFSixFQUFFLENBQUMsK0JBQStCLEVBQUU7UUFDbEMsSUFBSSxHQUFHLEdBQUcsSUFBSSxjQUFjLEVBQUUsQ0FBQztRQUMvQixHQUFHLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRSxHQUFHLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDM0IsR0FBRyxDQUFDLElBQUksRUFBRSxDQUFDO1FBQ1gsSUFBSSxDQUFDO1lBQ0gsR0FBRyxDQUFDLFlBQVksR0FBRyxVQUFVLENBQUM7WUFDOUIsTUFBTSxDQUFDLEdBQUcsQ0FBQyxZQUFZLENBQUMsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDNUMsQ0FBRTtRQUFBLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDWCxxRUFBcUU7WUFDckUsTUFBTSxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsQ0FBQyxJQUFJLENBQUMscUNBQXFDLENBQUMsQ0FBQztRQUNoRSxDQUFDO0lBQ0gsQ0FBQyxDQUFDLENBQUM7SUFFSCxFQUFFLENBQUMsa0NBQWtDLEVBQUU7UUFDckMsTUFBTSxDQUFDLGNBQWMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDekMsTUFBTSxDQUFDLGNBQWMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDekMsTUFBTSxDQUFDLGNBQWMsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUNuRCxNQUFNLENBQUMsY0FBYyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUMxQyxNQUFNLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUN6QyxDQUFDLENBQUMsQ0FBQztBQUNMLENBQUMsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtpZkVudlN1cHBvcnRzfSBmcm9tICcuLi91dGlsJztcblxuZGVzY3JpYmUoJ1hNTEh0dHBSZXF1ZXN0JywgZnVuY3Rpb24gKCkge1xuICB2YXIgdGVzdFpvbmUgPSBnbG9iYWwuem9uZS5mb3JrKCk7XG5cbiAgaXQoJ3Nob3VsZCB3b3JrIHdpdGggb25yZWFkeXN0YXRlY2hhbmdlJywgZnVuY3Rpb24gKGRvbmUpIHtcbiAgICB2YXIgcmVxO1xuXG4gICAgdGVzdFpvbmUucnVuKGZ1bmN0aW9uKCkge1xuICAgICAgcmVxID0gbmV3IFhNTEh0dHBSZXF1ZXN0KCk7XG4gICAgICB2YXIgZmlyc3RDYWxsID0gdHJ1ZTtcbiAgICAgIHJlcS5vbnJlYWR5c3RhdGVjaGFuZ2UgPSBmdW5jdGlvbiAoKSB7XG4gICAgICAgIC8vIE1ha2Ugc3VyZSB0aGF0IHRoZSBjYWxsYmFjayB3aWxsIG9ubHkgYmUgY2FsbGVkIG9uY2VcbiAgICAgICAgcmVxLm9ucmVhZHlzdGF0ZWNoYW5nZSA9IG51bGw7XG4gICAgICAgIGV4cGVjdChnbG9iYWwuem9uZSkudG9CZURpcmVjdENoaWxkT2YodGVzdFpvbmUpO1xuICAgICAgICBkb25lKCk7XG4gICAgICB9O1xuICAgICAgcmVxLm9wZW4oJ2dldCcsICcvJywgdHJ1ZSk7XG4gICAgfSk7XG5cbiAgICByZXEuc2VuZCgpO1xuICB9KTtcblxuICB2YXIgc3VwcG9ydHNPblByb2dyZXNzID0gZnVuY3Rpb24oKSB7XG4gICAgcmV0dXJuICdvbnByb2dyZXNzJyBpbiBuZXcgWE1MSHR0cFJlcXVlc3QoKTtcbiAgfTtcbiAgKDxhbnk+c3VwcG9ydHNPblByb2dyZXNzKS5tZXNzYWdlID0gXCJYTUxIdHRwUmVxdWVzdC5vbnByb2dyZXNzXCI7XG5cbiAgZGVzY3JpYmUoJ29ucHJvZ3Jlc3MnLCBpZkVudlN1cHBvcnRzKHN1cHBvcnRzT25Qcm9ncmVzcywgZnVuY3Rpb24gKCkge1xuICAgIGl0KCdzaG91bGQgd29yayB3aXRoIG9ucHJvZ3Jlc3MnLCBmdW5jdGlvbiAoZG9uZSkge1xuICAgICAgdmFyIHJlcTtcbiAgICAgIHRlc3Rab25lLnJ1bihmdW5jdGlvbigpIHtcbiAgICAgICAgcmVxID0gbmV3IFhNTEh0dHBSZXF1ZXN0KCk7XG4gICAgICAgIHJlcS5vbnByb2dyZXNzID0gZnVuY3Rpb24gKCkge1xuICAgICAgICAgIC8vIE1ha2Ugc3VyZSB0aGF0IHRoZSBjYWxsYmFjayB3aWxsIG9ubHkgYmUgY2FsbGVkIG9uY2VcbiAgICAgICAgICByZXEub25wcm9ncmVzcyA9IG51bGw7XG4gICAgICAgICAgZXhwZWN0KGdsb2JhbC56b25lKS50b0JlRGlyZWN0Q2hpbGRPZih0ZXN0Wm9uZSk7XG4gICAgICAgICAgZG9uZSgpO1xuICAgICAgICB9O1xuICAgICAgICByZXEub3BlbignZ2V0JywgJy8nLCB0cnVlKTtcbiAgICAgIH0pO1xuXG4gICAgICByZXEuc2VuZCgpO1xuICAgIH0pO1xuICB9KSk7XG5cbiAgaXQoJ3Nob3VsZCBwcmVzZXJ2ZSBvdGhlciBzZXR0ZXJzJywgZnVuY3Rpb24gKCkge1xuICAgIHZhciByZXEgPSBuZXcgWE1MSHR0cFJlcXVlc3QoKTtcbiAgICByZXEub3BlbignZ2V0JywgJy8nLCB0cnVlKTtcbiAgICByZXEuc2VuZCgpO1xuICAgIHRyeSB7XG4gICAgICByZXEucmVzcG9uc2VUeXBlID0gJ2RvY3VtZW50JztcbiAgICAgIGV4cGVjdChyZXEucmVzcG9uc2VUeXBlKS50b0JlKCdkb2N1bWVudCcpO1xuICAgIH0gY2F0Y2ggKGUpIHtcbiAgICAgIC8vQW5kcm9pZCBicm93c2VyOiB1c2luZyB0aGlzIHNldHRlciB0aHJvd3MsIHRoaXMgc2hvdWxkIGJlIHByZXNlcnZlZFxuICAgICAgZXhwZWN0KGUubWVzc2FnZSkudG9CZSgnSU5WQUxJRF9TVEFURV9FUlI6IERPTSBFeGNlcHRpb24gMTEnKTtcbiAgICB9XG4gIH0pO1xuXG4gIGl0KCdzaG91bGQgcHJlc2VydmUgc3RhdGljIGNvbnN0YW50cycsIGZ1bmN0aW9uKCkge1xuICAgIGV4cGVjdChYTUxIdHRwUmVxdWVzdC5VTlNFTlQpLnRvRXF1YWwoMCk7XG4gICAgZXhwZWN0KFhNTEh0dHBSZXF1ZXN0Lk9QRU5FRCkudG9FcXVhbCgxKTtcbiAgICBleHBlY3QoWE1MSHR0cFJlcXVlc3QuSEVBREVSU19SRUNFSVZFRCkudG9FcXVhbCgyKTtcbiAgICBleHBlY3QoWE1MSHR0cFJlcXVlc3QuTE9BRElORykudG9FcXVhbCgzKTtcbiAgICBleHBlY3QoWE1MSHR0cFJlcXVlc3QuRE9ORSkudG9FcXVhbCg0KTtcbiAgfSk7XG59KTtcblxuIl19