import Clip from './Clip';
import { ArrayLike, Dictionary } from '../core/types';
import { AnimationEasing } from './easing';
import Animation from './Animation';
declare type NumberArray = ArrayLike<number>;
declare type InterpolatableType = string | number | NumberArray | NumberArray[];
export declare function interpolateNumber(p0: number, p1: number, percent: number): number;
export declare function step(p0: any, p1: any, percent: number): any;
export declare function interpolate1DArray(out: NumberArray, p0: NumberArray, p1: NumberArray, percent: number): void;
export declare function interpolate2DArray(out: NumberArray[], p0: NumberArray[], p1: NumberArray[], percent: number): void;
export declare function cloneValue(value: InterpolatableType): number | any[];
declare type Keyframe = {
    time: number;
    value: unknown;
    percent: number;
    additiveValue?: unknown;
};
declare class Track {
    keyframes: Keyframe[];
    maxTime: number;
    propName: string;
    useSpline: boolean;
    arrDim: number;
    isValueColor: boolean;
    interpolable: boolean;
    private _finished;
    private _needsSort;
    private _isAllValueEqual;
    private _additiveTrack;
    private _additiveValue;
    private _lastFrame;
    private _lastFramePercent;
    constructor(propName: string);
    isFinished(): boolean;
    setFinished(): void;
    needsAnimate(): boolean;
    getAdditiveTrack(): Track;
    addKeyframe(time: number, value: unknown): {
        time: number;
        value: unknown;
        percent: number;
    };
    prepare(additiveTrack?: Track): void;
    step(target: any, percent: number): void;
    private _addToTarget;
}
declare type DoneCallback = () => void;
declare type AbortCallback = () => void;
export declare type OnframeCallback<T> = (target: T, percent: number) => void;
export declare type AnimationPropGetter<T> = (target: T, key: string) => InterpolatableType;
export declare type AnimationPropSetter<T> = (target: T, key: string, value: InterpolatableType) => void;
export default class Animator<T> {
    animation?: Animation;
    targetName?: string;
    scope?: string;
    __fromStateTransition?: string;
    private _tracks;
    private _trackKeys;
    private _target;
    private _loop;
    private _delay;
    private _maxTime;
    private _paused;
    private _started;
    private _additiveAnimators;
    private _doneCbs;
    private _onframeCbs;
    private _abortedCbs;
    private _clip;
    constructor(target: T, loop: boolean, additiveTo?: Animator<any>[]);
    getTarget(): T;
    changeTarget(target: T): void;
    when(time: number, props: Dictionary<any>): this;
    whenWithKeys(time: number, props: Dictionary<any>, propNames: string[]): this;
    pause(): void;
    resume(): void;
    isPaused(): boolean;
    private _doneCallback;
    private _abortedCallback;
    private _setTracksFinished;
    private _getAdditiveTrack;
    start(easing?: AnimationEasing, forceAnimate?: boolean): this;
    stop(forwardToLast?: boolean): void;
    delay(time: number): this;
    during(cb: OnframeCallback<T>): this;
    done(cb: DoneCallback): this;
    aborted(cb: AbortCallback): this;
    getClip(): Clip;
    getTrack(propName: string): Track;
    stopTracks(propNames: string[], forwardToLast?: boolean): boolean;
    saveFinalToTarget(target: T, trackKeys?: readonly string[]): void;
    __changeFinalValue(finalProps: Dictionary<any>, trackKeys?: readonly string[]): void;
}
export {};
