import { reducer } from './chunk-7LT4AZED.js';
import { targets, getHeaderName } from './chunk-UEZF7UNC.js';
export { addClientPlugin, addTarget, addTargetClient } from './chunk-UEZF7UNC.js';
import './chunk-UPA5TN5W.js';
import { parse, format } from 'url';
import { stringify } from 'qs';

// src/helpers/utils.ts
var availableTargets = () => Object.keys(targets).map((targetId) => ({
  ...targets[targetId].info,
  clients: Object.keys(targets[targetId].clientsById).map(
    (clientId) => targets[targetId].clientsById[clientId].info
  )
}));
var extname = (targetId, clientId) => {
  const target = targets[targetId];
  if (!target) {
    return "";
  }
  return target.clientsById[clientId]?.info.extname || "";
};

// src/index.ts
var isHarEntry = (value) => typeof value === "object" && "log" in value && typeof value.log === "object" && "entries" in value.log && Array.isArray(value.log.entries);
var HTTPSnippet = class {
  constructor(input, opts = {}) {
    this.initCalled = false;
    this.entries = [];
    this.requests = [];
    this.options = {};
    this.options = {
      harIsAlreadyEncoded: false,
      ...opts
    };
    this.requests = [];
    if (isHarEntry(input)) {
      this.entries = input.log.entries;
    } else {
      this.entries = [
        {
          request: input
        }
      ];
    }
  }
  init() {
    this.initCalled = true;
    this.requests = this.entries.map(({ request }) => {
      const req = {
        bodySize: 0,
        headersSize: 0,
        headers: [],
        cookies: [],
        httpVersion: "HTTP/1.1",
        queryString: [],
        postData: {
          mimeType: request.postData?.mimeType || "application/octet-stream"
        },
        ...request
      };
      if (req.postData && !req.postData.mimeType) {
        req.postData.mimeType = "application/octet-stream";
      }
      return this.prepare(req, this.options);
    });
    return this;
  }
  prepare(harRequest, options) {
    const request = {
      ...harRequest,
      fullUrl: "",
      uriObj: {},
      queryObj: {},
      headersObj: {},
      cookiesObj: {},
      allHeaders: {}
    };
    if (request.queryString && request.queryString.length) {
      request.queryObj = request.queryString.reduce(reducer, {});
    }
    if (request.headers && request.headers.length) {
      const http2VersionRegex = /^HTTP\/2/;
      request.headersObj = request.headers.reduce((accumulator, { name, value }) => {
        const headerName = http2VersionRegex.exec(request.httpVersion) ? name.toLocaleLowerCase() : name;
        return {
          ...accumulator,
          [headerName]: value
        };
      }, {});
    }
    if (request.cookies && request.cookies.length) {
      request.cookiesObj = request.cookies.reduceRight(
        (accumulator, { name, value }) => ({
          ...accumulator,
          [name]: value
        }),
        {}
      );
    }
    const cookies = request.cookies?.map(({ name, value }) => {
      if (options.harIsAlreadyEncoded) {
        return `${name}=${value}`;
      }
      return `${encodeURIComponent(name)}=${encodeURIComponent(value)}`;
    });
    if (cookies?.length) {
      request.allHeaders.cookie = cookies.join("; ");
    }
    switch (request.postData.mimeType) {
      case "multipart/mixed":
      case "multipart/related":
      case "multipart/form-data":
      case "multipart/alternative":
        request.postData.text = "";
        request.postData.mimeType = "multipart/form-data";
        if (request.postData?.params) {
          const boundary = "---011000010111000001101001";
          const carriage = `${boundary}--`;
          const rn = "\r\n";
          const escape = (str) => str.replace(/\n/g, "%0A").replace(/\r/g, "%0D").replace(/"/g, "%22");
          const normalizeLinefeeds = (value) => value.replace(/\r?\n|\r/g, "\r\n");
          const payload = [`--${boundary}`];
          request.postData?.params.forEach((param, i) => {
            const name = param.name;
            const value = param.value || "";
            const filename = param.fileName || null;
            const contentType = param.contentType || "application/octet-stream";
            if (filename) {
              payload.push(
                `Content-Disposition: form-data; name="${escape(normalizeLinefeeds(name))}"; filename="${filename}"`
              );
              payload.push(`Content-Type: ${contentType}`);
            } else {
              payload.push(`Content-Disposition: form-data; name="${escape(normalizeLinefeeds(name))}"`);
            }
            payload.push("");
            payload.push(normalizeLinefeeds(value));
            if (i !== request.postData.params.length - 1) {
              payload.push(`--${boundary}`);
            }
          });
          payload.push(`--${carriage}`);
          request.postData.boundary = boundary;
          request.postData.text = payload.join(rn);
          const contentTypeHeader = getHeaderName(request.headersObj, "content-type") || "content-type";
          request.headersObj[contentTypeHeader] = `multipart/form-data; boundary=${boundary}`;
        }
        break;
      case "application/x-www-form-urlencoded":
        if (!request.postData.params) {
          request.postData.text = "";
        } else {
          request.postData.paramsObj = request.postData.params.reduce(reducer, {});
          request.postData.text = stringify(request.postData.paramsObj);
        }
        break;
      case "text/json":
      case "text/x-json":
      case "application/json":
      case "application/x-json":
        request.postData.mimeType = "application/json";
        if (request.postData.text) {
          try {
            request.postData.jsonObj = JSON.parse(request.postData.text);
          } catch (e) {
            request.postData.mimeType = "text/plain";
          }
        }
        break;
    }
    const allHeaders = {
      ...request.allHeaders,
      ...request.headersObj
    };
    const urlWithParsedQuery = parse(request.url, true, true);
    request.queryObj = {
      ...request.queryObj,
      ...urlWithParsedQuery.query
    };
    let search;
    if (options.harIsAlreadyEncoded) {
      search = stringify(request.queryObj, {
        encode: false,
        indices: false
      });
    } else {
      search = stringify(request.queryObj, {
        indices: false
      });
    }
    const uriObj = {
      ...urlWithParsedQuery,
      query: request.queryObj,
      search,
      path: search ? `${urlWithParsedQuery.pathname}?${search}` : urlWithParsedQuery.pathname
    };
    const url = format({
      ...urlWithParsedQuery,
      query: null,
      search: null
    });
    const fullUrl = format({
      ...urlWithParsedQuery,
      ...uriObj
    });
    return {
      ...request,
      allHeaders,
      fullUrl,
      url,
      uriObj
    };
  }
  convert(targetId, clientId, options) {
    if (!this.initCalled) {
      this.init();
    }
    if (!options && clientId) {
      options = clientId;
    }
    const target = targets[targetId];
    if (!target) {
      return false;
    }
    const { convert } = target.clientsById[clientId || target.info.default];
    const results = this.requests.map((request) => convert(request, options));
    return results;
  }
};
/*! formdata-polyfill. MIT License. Jimmy Wärting <https://jimmy.warting.se/opensource> */

export { HTTPSnippet, availableTargets, extname };
//# sourceMappingURL=out.js.map
//# sourceMappingURL=index.js.map