this.zxcvbnts = this.zxcvbnts || {};
this.zxcvbnts["matcher-pwned"] = (function (exports) {
    'use strict';

    const isNodeJs = typeof process !== 'undefined' && process.release && process.release.name === 'node';
    const textEncode = text => {
      if (isNodeJs) {
        const utf8 = decodeURI(encodeURIComponent(text));
        const result = new Uint8Array(utf8.length);
        for (let i = 0; i < utf8.length; i += 1) {
          result[i] = utf8.charCodeAt(i);
        }
        return result;
      }
      try {
        // eslint-disable-next-line compat/compat
        return new TextEncoder().encode(text);
      } catch (error) {
        throw new Error(`No encoder found, ${error}`);
      }
    };
    const digestMessage = async message => {
      const data = textEncode(message);
      let hash = '';
      if (isNodeJs) {
        // eslint-disable-next-line global-require
        const crypto = require('crypto');
        hash = crypto.createHash('sha1').update(message).digest('hex').toUpperCase();
      } else if (crypto) {
        const hashBuffer = await crypto.subtle.digest('SHA-1', data);
        const hashArray = Array.from(new Uint8Array(hashBuffer));
        hash = hashArray.map(b => b.toString(16).padStart(2, '0')).join('').toUpperCase();
      }
      return hash;
    };
    const pwnedUrl = 'https://api.pwnedpasswords.com/range/';
    const defaultNetworkErrorHandler = _error => {
      return false;
    };
    var haveIBeenPwned = (async (password, {
      universalFetch,
      url = pwnedUrl,
      networkErrorHandler = defaultNetworkErrorHandler
    }) => {
      // we don't need to check passwords with a length smaller 2 which can happen for repeat matcher or if we don't have a fetch function
      if (!universalFetch || password.length < 2) {
        return null;
      }
      const passwordHash = (await digestMessage(password)).toUpperCase();
      const range = passwordHash.slice(0, 5);
      const suffix = passwordHash.slice(5);
      const response = await universalFetch(`${url}${range}`, {
        method: 'GET',
        headers: {
          'Add-Padding': 'true'
        }
      }).catch(error => {
        return networkErrorHandler(error);
      });
      if (typeof response === 'boolean') {
        return false;
      }
      if (response.status >= 400) {
        return networkErrorHandler(response);
      }
      const result = await response.text();
      const resultArray = result.split('\r\n');
      return resultArray.find(entry => {
        const passwordHasPart = entry.split(':')[0];
        return passwordHasPart === suffix;
      });
    });

    /*
     * -------------------------------------------------------------------------------
     *  Have i been pwned matching factory ---------------------------------------------------
     * -------------------------------------------------------------------------------
     */
    var MatchPwned = ((universalFetch, {
      url,
      networkErrorHandler
    }) => {
      return class MatchPwned {
        async match({
          password
        }) {
          const matches = [];
          const pwned = await haveIBeenPwned(password, {
            universalFetch,
            url,
            networkErrorHandler
          });
          if (pwned) {
            // @ts-ignore
            matches.push({
              pattern: 'pwned',
              pwnedAmount: parseInt(pwned.split(':')[1], 10),
              i: 0,
              j: password.length - 1,
              token: password
            });
          }
          return matches;
        }
      };
    });

    // TODO make some more appropriated guesses logic?
    var scoring = (() => {
      return 1;
    });

    var FeedbackFactory = (options => {
      return () => {
        return {
          warning: options.translations.warnings.pwned,
          suggestions: [options.translations.suggestions.pwned]
        };
      };
    });

    const matcherPwnedFactory = (universalFetch, options, config = {}) => {
      return {
        Matching: MatchPwned(universalFetch, config),
        feedback: FeedbackFactory(options),
        scoring
      };
    };

    exports.haveIBeenPwned = haveIBeenPwned;
    exports.matcherPwnedFactory = matcherPwnedFactory;

    return exports;

})({});
//# sourceMappingURL=zxcvbn-ts.js.map
