//@ui5-bundle Eventing-preload-1.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/model/FilterOperator", function(){"use strict";var t={EQ:"EQ",NE:"NE",LT:"LT",LE:"LE",GT:"GT",GE:"GE",BT:"BT",NB:"NB",Contains:"Contains",NotContains:"NotContains",StartsWith:"StartsWith",NotStartsWith:"NotStartsWith",EndsWith:"EndsWith",NotEndsWith:"NotEndsWith",All:"All",Any:"Any"};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/model/Sorter", ["sap/base/Log","sap/ui/base/Object","sap/ui/core/Configuration"],function(t,r,n){"use strict";var e=r.extend("sap.ui.model.Sorter",{constructor:function(r,n,e,o){if(typeof r==="object"){var i=r;r=i.path;n=i.descending;e=i.group;o=i.comparator}this.sPath=r;var u=this.sPath.indexOf(">");if(u>0){t.error('Model names are not allowed in sorter-paths: "'+this.sPath+'"');this.sPath=this.sPath.substr(u+1)}this.bDescending=n;this.vGroup=e;if(typeof e=="boolean"&&e){this.fnGroup=function(t){return t.getProperty(this.sPath)}}if(typeof e=="function"){this.fnGroup=e}this.fnCompare=o},getGroup:function(t){var r=this.fnGroup(t);if(typeof r==="string"||typeof r==="number"||typeof r==="boolean"||r==null){r={key:r}}return r},getGroupFunction:function(){return this.fnGroup&&this.fnGroup.bind(this)}});e.defaultComparator=function(t,r){if(t==r){return 0}if(r==null){return-1}if(t==null){return 1}if(typeof t=="string"&&typeof r=="string"){return t.localeCompare(r,n.getLanguageTag())}if(t<r){return-1}if(t>r){return 1}return 0};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/performance/Measurement", ["sap/base/Log","sap/ui/thirdparty/URI","sap/base/util/now"],function(e,t,r){"use strict";var t=window.URI;function n(){function n(e,t,r,n,i){this.id=e;this.info=t;this.start=r;this.end=n;this.pause=0;this.resume=0;this.duration=0;this.time=0;this.categories=i;this.average=false;this.count=0;this.completeDuration=0}function i(e){if(!o){return true}if(!e){return o===null}for(var t=0;t<o.length;t++){if(e.indexOf(o[t])>-1){return true}}return false}function s(e){if(!e){e=["javascript"]}e=typeof e==="string"?e.split(","):e;if(!i(e)){return null}return e}function u(e,t){for(var r=0;r<t.length;r++){if(e.categories.indexOf(t[r])>-1){return true}}return t.length===0}var a=false,f=XMLHttpRequest,o=null,l=[],d=[],c={},h={};this.getActive=function(){return a};this.setActive=function(e,r){var n,i;if(!r){r=null}else if(typeof r==="string"){r=r.split(",")}o=r;if(a===e){return}a=e;if(a){for(var s in c){this[s]=c[s].bind(this)}c={};n=this.end;i=this.start;XMLHttpRequest=function(){var e=new f,r=e.open,s;e.open=function(){s=new t(arguments[1],new t(document.baseURI).search("")).href();i(s,"Request for "+s,"xmlhttprequest");e.addEventListener("loadend",n.bind(null,s));r.apply(this,arguments)};return e}}else{XMLHttpRequest=f}return a};c["start"]=function(t,i,u){if(!a){return}u=s(u);if(!u){return}var f=r(),o=new n(t,i,f,0,u);if(e.getLevel("sap.ui.Performance")>=4&&window.console&&console.time){console.time(i+" - "+t)}e.info("Performance measurement start: "+t+" on "+f);if(o){h[t]=o;return this.getMeasurement(o.id)}else{return false}};c["pause"]=function(t){if(!a){return}var n=r();var i=h[t];if(i&&i.end>0){return false}if(i&&i.pause==0){i.pause=n;if(i.pause>=i.resume&&i.resume>0){i.duration=i.duration+i.pause-i.resume;i.resume=0}else if(i.pause>=i.start){i.duration=i.pause-i.start}}if(i){e.info("Performance measurement pause: "+t+" on "+n+" duration: "+i.duration);return this.getMeasurement(i.id)}else{return false}};c["resume"]=function(t){if(!a){return}var n=r();var i=h[t];if(i&&i.pause>0){i.pause=0;i.resume=n}if(i){e.info("Performance measurement resume: "+t+" on "+n+" duration: "+i.duration);return this.getMeasurement(i.id)}else{return false}};c["end"]=function(t){if(!a){return}var n=r();var i=h[t];if(i&&!i.end){e.info("Performance measurement end: "+t+" on "+n);i.end=n;if(i.end>=i.resume&&i.resume>0){i.duration=i.duration+i.end-i.resume;i.resume=0}else if(i.pause>0){i.pause=0}else if(i.end>=i.start){if(i.average){i.completeDuration+=i.end-i.start;i.count++;i.duration=i.completeDuration/i.count;i.start=n}else{i.duration=i.end-i.start}}if(i.end>=i.start){i.time=i.end-i.start}}if(i){if(e.getLevel("sap.ui.Performance")>=4&&window.console&&console.timeEnd){console.timeEnd(i.info+" - "+t)}return this.getMeasurement(t)}else{return false}};c["clear"]=function(){h={}};c["remove"]=function(e){delete h[e]};c["add"]=function(e,t,r,i,u,f,o){if(!a){return}o=s(o);if(!o){return false}var l=new n(e,t,r,i,o);l.time=u;l.duration=f;if(l){h[e]=l;return this.getMeasurement(l.id)}else{return false}};c["average"]=function(e,t,n){if(!a){return}n=s(n);if(!n){return}var i=h[e],u=r();if(!i||!i.average){this.start(e,t,n);i=h[e];i.average=true}else{if(!i.end){i.completeDuration+=u-i.start;i.count++}i.start=u;i.end=0}return this.getMeasurement(i.id)};this.getMeasurement=function(e){var t=h[e];if(t){var r={};for(var n in t){r[n]=t[n]}return r}else{return false}};this.getAllMeasurements=function(e){return this.filterMeasurements(function(e){return e},e)};this.filterMeasurements=function(){var e,t,r=0,n=[],i=typeof arguments[r]==="function"?arguments[r++]:undefined,s=typeof arguments[r]==="boolean"?arguments[r++]:undefined,a=Array.isArray(arguments[r])?arguments[r]:[];for(var f in h){e=this.getMeasurement(f);t=s===false&&e.end===0||s!==false&&(!s||e.end);if(t&&u(e,a)&&(!i||i(e))){n.push(e)}}return n};this.registerMethod=function(t,r,n,i){var s=r[n];if(s&&typeof s==="function"){var u=l.indexOf(s)>-1;if(!u){d.push({func:s,obj:r,method:n,id:t});var a=this;r[n]=function(){a.average(t,t+" method average",i);var e=s.apply(this,arguments);a.end(t);return e};l.push(r[n]);return true}}else{e.debug(n+" in not a function. Measurement.register failed")}return false};this.unregisterMethod=function(e,t,r){var n=t[r],i=l.indexOf(n);if(n&&i>-1){t[r]=d[i].func;l.splice(i,1);d.splice(i,1);return true}return false};this.unregisterAllMethods=function(){while(d.length>0){var e=d[0];this.unregisterMethod(e.id,e.obj,e.method)}};var m=location.search.match(/sap-ui-measure=([^\&]*)/);if(m&&m[1]){if(m[1]==="true"||m[1]==="x"||m[1]==="X"){this.setActive(true)}else{this.setActive(true,m[1])}}else{var p=function(){return null};for(var v in c){this[v]=p}}}return new n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/performance/XHRInterceptor", ["sap/base/Log"],function(e){"use strict";var t="XHRInterceptor";var r=Object.create(null);var n=Object.create(null);function i(e){r[e]=Object.create(null);n[e]=window.XMLHttpRequest.prototype[e];window.XMLHttpRequest.prototype[e]=function(){var t=arguments;n[e].apply(this,t);for(var i in r[e]){r[e][i].apply(this,t)}}}var u={register:function(n,u,o){e.debug("Register '"+n+"' for XHR function '"+u+"'",t);if(!r[u]){i(u)}r[u][n]=o},unregister:function(n,i){var u=delete r[i][n];e.debug("Unregister '"+n+"' for XHR function '"+i+(u?"'":"' failed"),t);return u},isRegistered:function(e,t){return r[t]&&r[t][e]}};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/performance/trace/FESRHelper", [],function(){"use strict";var t={FESR_NAMESPACE:"http://schemas.sap.com/sapui5/extension/sap.ui.core.FESR/1",setSemanticStepname:function(t,s,i){var a=t.data("sap-ui-custom-settings");if(a===null){a={}}if(!a[this.FESR_NAMESPACE]){a[this.FESR_NAMESPACE]={}}a[this.FESR_NAMESPACE][s]=i;t.data("sap-ui-custom-settings",a)},getSemanticStepname:function(t,s){var i=t&&t.data("sap-ui-custom-settings")&&t.data("sap-ui-custom-settings")[this.FESR_NAMESPACE];if(!i){return}return i[s]}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/performance/trace/Interaction", ["sap/ui/performance/Measurement","sap/ui/performance/XHRInterceptor","sap/ui/performance/trace/FESRHelper","sap/base/util/LoaderExtensions","sap/base/util/now","sap/base/util/uid","sap/base/Log","sap/ui/thirdparty/URI"],function(e,t,i,n,r,s,a,o){"use strict";var u=window.location.host,p="INTERACTION",d=false,f=[],g,c={"application/zip":true,"application/vnd.rar":true,"application/gzip":true,"application/x-tar":true,"application/java-archive":true,"image/jpeg":true,"application/pdf":true},l="zip,rar,arj,z,gz,tar,lzh,cab,hqx,ace,jar,ear,war,jpg,jpeg,pdf,gzip";let m=false,h;function v(e){var t=new o(e).host();return t&&t!==u}function y(e){var t=e.toString();var i="";for(var n=0;n<t.length;n+=2){i+=String.fromCharCode(parseInt(t.substr(n,2),16))}return i.trim()}function S(e){return{event:"startup",trigger:"undetermined",component:"undetermined",appVersion:"undetermined",start:e||window.performance.timing.fetchStart,end:0,navigation:0,roundtrip:0,processing:0,duration:0,requests:[],measurements:[],sapStatistics:[],requestTime:0,networkTime:0,bytesSent:0,bytesReceived:0,requestCompression:"X",busyDuration:0,id:s(),passportAction:"undetermined_startup_0"}}function I(e){if(e.start>g.start&&e.end<g.end){return e}}function L(e){var t=e.startTime>0&&e.startTime<=e.requestStart&&e.requestStart<=e.responseEnd;var i=g.start<=performance.timing.navigationStart+e.requestStart&&g.end>=performance.timing.navigationStart+e.responseEnd;return i&&t&&e.initiatorType==="xmlhttprequest"}function b(e){this.end=e.responseEnd>this.end?e.responseEnd:this.end;g.requestTime+=e.responseEnd-e.startTime;if(this.roundtripHigherLimit<=e.startTime){g.navigation+=this.navigationHigherLimit-this.navigationLowerLimit;g.roundtrip+=this.roundtripHigherLimit-this.roundtripLowerLimit;this.navigationLowerLimit=e.startTime;this.roundtripLowerLimit=e.startTime}if(e.responseEnd>this.roundtripHigherLimit){this.roundtripHigherLimit=e.responseEnd}if(e.requestStart>this.navigationHigherLimit){this.navigationHigherLimit=e.requestStart}}function T(e){var t={start:e[0].startTime,end:e[0].responseEnd,navigationLowerLimit:e[0].startTime,navigationHigherLimit:e[0].requestStart,roundtripLowerLimit:e[0].startTime,roundtripHigherLimit:e[0].responseEnd};e.forEach(b,t);g.navigation+=t.navigationHigherLimit-t.navigationLowerLimit;g.roundtrip+=t.roundtripHigherLimit-t.roundtripLowerLimit;if(g.networkTime){var i=g.requestTime-g.networkTime;g.networkTime=i/e.length}else{g.networkTime=0}if(g.processing===0){var n=g.start-window.performance.timing.fetchStart;g.duration=t.end-n;g.processing=t.start-n}}function E(t){if(g){var i=window.performance.getEntriesByType("resource");var n;g.end=t;g.processing=t-g.start;g.duration=g.processing;g.requests=i.filter(L);g.completeRoundtrips=0;g.measurements=e.filterMeasurements(I,true);if(g.requests.length>0){T(g.requests)}g.completeRoundtrips=g.requests.length;var r=g.processing-g.navigation-g.roundtrip;g.processing=r>-1?r:0;g.completed=true;Object.freeze(g);if(g.semanticStepName||g.duration>=2||g.requests.length>0||d){f.push(g);n=f[f.length-1];if(a.isLoggable()){a.debug("Interaction step finished: trigger: "+g.trigger+"; duration: "+g.duration+"; requests: "+g.requests.length,"Interaction.js")}}if(M.onInteractionFinished){M.onInteractionFinished(n)}g=null;q=null;d=false;A=false;N=false;clearTimeout(h)}}function w(e){var t,i;if(e){var n,r;n=sap.ui.require("sap/ui/core/Component");if(n){while(e&&e.getParent){r=n.getOwnerComponentFor(e);if(r||e instanceof n){r=r||e;var s=r.getManifestEntry("sap.app");t=s&&s.id||r.getMetadata().getName();i=s&&s.applicationVersion&&s.applicationVersion.version}e=e.getParent()}}}return{id:t?t:"undetermined",version:i?i:""}}var H=false,q,R,A=false,N=false,C,P=false,_=false,D=0,j=Object.getOwnPropertyDescriptor(HTMLScriptElement.prototype,"src");function k(){Object.defineProperty(HTMLScriptElement.prototype,"src",{set:function(e){var t;if(!this.dataset.sapUiCoreInteractionHandled){t=M.notifyAsyncStep();this.addEventListener("load",function(){t()});this.addEventListener("error",function(){t()});this.dataset.sapUiCoreInteractionHandled="true"}j.set.call(this,e)},get:j.get})}function z(){t.register(p,"send",function(){if(this.pendingInteraction){this.pendingInteraction.bytesSent+=arguments[0]?arguments[0].length:0}});t.register(p,"setRequestHeader",function(e,t){if(!this.requestHeaderLength){this.requestHeaderLength=0}this.requestHeaderLength+=(e+"").length+(t+"").length});t.register(p,"open",function(e,t,i){var n,r,s;function a(e){if(this.readyState===4){e()}}if(g){var o=!v(t);if(o){n=M.passportHeader.get(this);if(n&&n.length>=370){r=y(n.substring(150,230));if(parseInt(n.substring(8,10),16)>2){s=n.substring(372,404)}}if(!n||r&&s&&g.passportAction.endsWith(r)){this.addEventListener("readystatechange",B.bind(this,g.id))}}if(o||i!==false){this.addEventListener("readystatechange",a.bind(this,M.notifyAsyncStep()))}this.pendingInteraction=g}})}function O(e,t,i,n){var r=e.split(".").pop().split(/\#|\?/)[0];if(t==="gzip"||t==="br"||i in c||r&&l.indexOf(r)!==-1||n<1024){return true}else{return false}}function B(e){if(this.readyState===4){if(this.pendingInteraction&&!this.pendingInteraction.completed&&g.id===e){var t=this.getResponseHeader("content-length"),i=O(this.responseURL,this.getResponseHeader("content-encoding"),this.getResponseHeader("content-type"),t),n=this.getResponseHeader("sap-perf-fesrec");this.pendingInteraction.bytesReceived+=t?parseInt(t):0;this.pendingInteraction.bytesReceived+=this.getAllResponseHeaders().length;this.pendingInteraction.bytesSent+=this.requestHeaderLength||0;this.pendingInteraction.requestCompression=i&&this.pendingInteraction.requestCompression!==false;this.pendingInteraction.networkTime+=n?Math.round(parseFloat(n,10)/1e3):0;var r=this.getResponseHeader("sap-statistics");if(r){var s=window.performance.getEntriesByType("resource");this.pendingInteraction.sapStatistics.push({url:this.responseURL,statistics:r,timing:s?s[s.length-1]:undefined})}delete this.requestHeaderLength;delete this.pendingInteraction}}}var M={getAll:function(e){if(e){M.end(true)}return f},filter:function(e){var t=[];if(e){for(var i=0,n=f.length;i<n;i++){if(e(f[i])){t.push(f[i])}}}return t},getPending:function(){return g},clear:function(){f=[]},start:function(e,t){var n=r();if(g){E(n)}if(C){clearTimeout(C)}D=0;if(window.performance.clearResourceTimings){window.performance.clearResourceTimings()}var s=w(t);g=S(m?n:undefined);g.event=e;g.component=s.id;g.appVersion=s.version;if(t&&t.getId){g.trigger=t.getId();g.semanticStepName=i.getSemanticStepname(t,e)}if(a.isLoggable(null,"sap.ui.Performance")){console.time("INTERACTION: "+g.trigger+" - "+g.event)}if(a.isLoggable()){a.debug("Interaction step started: trigger: "+g.trigger+"; type: "+g.event,"Interaction.js")}},end:function(e){if(g){if(e){if(a.isLoggable(null,"sap.ui.Performance")){console.timeEnd("INTERACTION: "+g.trigger+" - "+g.event)}E(g.preliminaryEnd||r());if(a.isLoggable()){a.debug("Interaction ended...")}}else{g.preliminaryEnd=r()}}},getActive:function(){return H},setActive:function(e){H=e;if(e){if(!m){z();k();n.notifyResourceLoading=M.notifyAsyncStep}M.notifyStepStart("startup","startup",true);m=true}},notifyNavigation:function(){d=true},notifyShowBusyIndicator:function(e){e._sapui_fesr_fDelayedStartTime=r()+e.getBusyIndicatorDelay()},notifyHideBusyIndicator:function(e){if(e._sapui_fesr_fDelayedStartTime){var t=r()-e._sapui_fesr_fDelayedStartTime;M.addBusyDuration(t>0?t:0);delete e._sapui_fesr_fDelayedStartTime}},notifyStepStart:function(e,t,n){if(H){var r,s,a;if(!g&&q||n){if(n){r="startup"}else{r=e}M.start(r,t);g=M.getPending();if(g&&!g.completed&&M.onInteractionStarted){g.passportAction=M.onInteractionStarted(g,n)}if(q){R=q.srcControl}a=i.getSemanticStepname(R,e);if(t&&t.getId&&R&&t.getId()===R.getId()){N=true}else if(a){g.trigger=R.getId();g.semanticStepName=a;N=true}else{s=R;while(s&&s.getParent()){s=s.getParent();if(t.getId()===s.getId()){A=true;break}}}q=null;d=false;h=setTimeout(function(){q=null},0);P=false;M.notifyStepEnd(true)}else if(g&&R&&!N){s=R;a=i.getSemanticStepname(R,e);if(s&&t.getId()===s.getId()){g.trigger=t.getId();g.semanticStepName=a;g.event=e;N=true}else if(a){g.trigger=R.getId();g.semanticStepName=a;N=true}else if(!A){while(s&&s.getParent()){s=s.getParent();if(t.getId()===s.getId()){g.trigger=t.getId();g.semanticStepName=i.getSemanticStepname(t,e);g.event=e;break}}}}}},notifyAsyncStep:function(e){if(g){if(a.isLoggable(null,"sap.ui.Performance")&&e){console.time(e)}var t=g.id;delete g.preliminaryEnd;M.notifyAsyncStepStart();return function(){M.notifyAsyncStepEnd(t);if(a.isLoggable(null,"sap.ui.Performance")&&e){console.timeEnd(e)}}}else{return function(){}}},notifyAsyncStepStart:function(){if(g){D++;clearTimeout(C);P=false;if(a.isLoggable()){a.debug("Interaction relevant step started - Number of pending steps: "+D)}}},notifyAsyncStepEnd:function(e){if(g&&e===g.id){D--;M.notifyStepEnd(true);if(a.isLoggable()){a.debug("Interaction relevant step stopped - Number of pending steps: "+D)}}},notifyStepEnd:function(e){if(H&&!_){if(D===0||!e){if(P||!e){M.end(true);if(a.isLoggable()){a.debug("Interaction stopped")}P=false}else{M.end();P=true;if(C){clearTimeout(C)}C=setTimeout(M.notifyStepEnd,301);if(a.isLoggable()){a.debug("Interaction check for idle time - Number of pending steps: "+D)}}}}},notifyEventStart:function(e){q=H?e:null},notifyScrollEvent:function(e){},notifyEventEnd:function(){if(q){if(q.type.match(/^(mousedown|touchstart|keydown)$/)){M.end(true)}if(this.eventEndTimer){clearTimeout(this.eventEndTimer)}this.eventEndTimer=setTimeout(function(){q=null;delete this.eventEndTimer}.bind(this),10)}},onInteractionStarted:null,onInteractionFinished:null,setStepComponent:function(e){if(H&&g&&e&&!g.stepComponent){g.stepComponent=e}},addBusyDuration:function(e){if(H&&g){if(!g.busyDuration){g.busyDuration=0}g.busyDuration+=e}}};return M});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/util/ActivityDetection", ["sap/ui/core/Theming"],function(e){"use strict";var t={},n=true,i=null,r=1e4,o=[],u=false,c=null;function s(){i=null;if(u&&document.hidden!==true){d();return}n=false;c.observe(document.documentElement,{childList:true,attributes:true,subtree:true,characterData:true})}function d(){if(document.hidden){return}if(!n){n=true;f(o);c.disconnect()}if(i){u=true}else{i=setTimeout(s,r);u=false}}function f(e){if(e.length===0){return}var t=e.slice();setTimeout(function(){var e;for(var n=0,i=t.length;n<i;n++){e=t[n];e.fFunction.call(e.oListener||window)}},0)}t.attachActivate=function(e,t){o.push({oListener:t,fFunction:e})};t.detachActivate=function(e,t){for(var n=0,i=o.length;n<i;n++){if(o[n].fFunction===e&&o[n].oListener===t){o.splice(n,1);break}}};t.isActive=function(){return n};t.refresh=d;var a=["resize","orientationchange","mousemove","mousedown","mouseup","paste","cut","keydown","keyup","DOMMouseScroll","mousewheel"];if("ontouchstart"in window){a.push("touchstart","touchmove","touchend","touchcancel")}for(var h=0;h<a.length;h++){window.addEventListener(a[h],t.refresh,{capture:true,passive:true})}if(window.MutationObserver){c=new window.MutationObserver(t.refresh)}else if(window.WebKitMutationObserver){c=new window.WebKitMutationObserver(t.refresh)}else{c={observe:function(){document.documentElement.addEventListener("DOMSubtreeModified",t.refresh)},disconnect:function(){document.documentElement.removeEventListener("DOMSubtreeModified",t.refresh)}}}if(typeof document.hidden==="boolean"){document.addEventListener("visibilitychange",function(){if(document.hidden!==true){t.refresh()}},false)}e.attachApplied(function(){t.refresh()});d();return t});
sap.ui.require.preload({
	"sap/ui/thirdparty/URI.js":function(){
/*!
 * URI.js - Mutating URLs
 *
 * Version: 1.19.11
 *
 * Author: Rodney Rehm
 * Web: http://medialize.github.io/URI.js/
 *
 * Licensed under
 *   MIT License http://www.opensource.org/licenses/mit-license
 *
 */
(function(e,t){"use strict";if(typeof module==="object"&&module.exports){module.exports=t(require("./punycode"),require("./IPv6"),require("./SecondLevelDomains"))}else if(typeof define==="function"&&define.amd){e.URI=t(e.punycode,e.IPv6,e.SecondLevelDomains,e);define("sap/ui/thirdparty/URI",[],function(){return e.URI})}else{e.URI=t(e.punycode,e.IPv6,e.SecondLevelDomains,e)}})(this,function(e,t,r,n){"use strict";var i=n&&n.URI;function s(e,t){var r=arguments.length>=1;var n=arguments.length>=2;if(!(this instanceof s)){if(r){if(n){return new s(e,t)}return new s(e)}return new s}if(e===undefined){if(r){throw new TypeError("undefined is not a valid argument for URI")}if(typeof location!=="undefined"){e=location.href+""}else{e=""}}if(e===null){if(r){throw new TypeError("null is not a valid argument for URI")}}this.href(e);if(t!==undefined){return this.absoluteTo(t)}return this}function a(e){return/^[0-9]+$/.test(e)}s.version="1.19.11";var o=s.prototype;var u=Object.prototype.hasOwnProperty;function h(e){return e.replace(/([.*+?^=!:${}()|[\]\/\\])/g,"\\$1")}function f(e){if(e===undefined){return"Undefined"}return String(Object.prototype.toString.call(e)).slice(8,-1)}function p(e){return f(e)==="Array"}function l(e,t){var r={};var n,i;if(f(t)==="RegExp"){r=null}else if(p(t)){for(n=0,i=t.length;n<i;n++){r[t[n]]=true}}else{r[t]=true}for(n=0,i=e.length;n<i;n++){var s=r&&r[e[n]]!==undefined||!r&&t.test(e[n]);if(s){e.splice(n,1);i--;n--}}return e}function c(e,t){var r,n;if(p(t)){for(r=0,n=t.length;r<n;r++){if(!c(e,t[r])){return false}}return true}var i=f(t);for(r=0,n=e.length;r<n;r++){if(i==="RegExp"){if(typeof e[r]==="string"&&e[r].match(t)){return true}}else if(e[r]===t){return true}}return false}function d(e,t){if(!p(e)||!p(t)){return false}if(e.length!==t.length){return false}e.sort();t.sort();for(var r=0,n=e.length;r<n;r++){if(e[r]!==t[r]){return false}}return true}function m(e){var t=/^\/+|\/+$/g;return e.replace(t,"")}s._parts=function(){return{protocol:null,username:null,password:null,hostname:null,urn:null,port:null,path:null,query:null,fragment:null,preventInvalidHostname:s.preventInvalidHostname,duplicateQueryParameters:s.duplicateQueryParameters,escapeQuerySpace:s.escapeQuerySpace}};s.preventInvalidHostname=false;s.duplicateQueryParameters=false;s.escapeQuerySpace=true;s.protocol_expression=/^[a-z][a-z0-9.+-]*$/i;s.idn_expression=/[^a-z0-9\._-]/i;s.punycode_expression=/(xn--)/i;s.ip4_expression=/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;s.ip6_expression=/^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/;s.find_uri_expression=/\b((?:[a-z][\w-]+:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]+|\(([^\s()<>]+|(\([^\s()<>]+\)))*\))+(?:\(([^\s()<>]+|(\([^\s()<>]+\)))*\)|[^\s`!()\[\]{};:'".,<>?«»“”‘’]))/gi;s.findUri={start:/\b(?:([a-z][a-z0-9.+-]*:\/\/)|www\.)/gi,end:/[\s\r\n]|$/,trim:/[`!()\[\]{};:'".,<>?«»“”„‘’]+$/,parens:/(\([^\)]*\)|\[[^\]]*\]|\{[^}]*\}|<[^>]*>)/g};s.leading_whitespace_expression=/^[\x00-\x20\u00a0\u1680\u2000-\u200a\u2028\u2029\u202f\u205f\u3000\ufeff]+/;s.ascii_tab_whitespace=/[\u0009\u000A\u000D]+/g;s.defaultPorts={http:"80",https:"443",ftp:"21",gopher:"70",ws:"80",wss:"443"};s.hostProtocols=["http","https"];s.invalid_hostname_characters=/[^a-zA-Z0-9\.\-:_]/;s.domAttributes={a:"href",blockquote:"cite",link:"href",base:"href",script:"src",form:"action",img:"src",area:"href",iframe:"src",embed:"src",source:"src",track:"src",input:"src",audio:"src",video:"src"};s.getDomAttribute=function(e){if(!e||!e.nodeName){return undefined}var t=e.nodeName.toLowerCase();if(t==="input"&&e.type!=="image"){return undefined}return s.domAttributes[t]};function g(e){return escape(e)}function _(e){return encodeURIComponent(e).replace(/[!'()*]/g,g).replace(/\*/g,"%2A")}s.encode=_;s.decode=decodeURIComponent;s.iso8859=function(){s.encode=escape;s.decode=unescape};s.unicode=function(){s.encode=_;s.decode=decodeURIComponent};s.characters={pathname:{encode:{expression:/%(24|26|2B|2C|3B|3D|3A|40)/gi,map:{"%24":"$","%26":"&","%2B":"+","%2C":",","%3B":";","%3D":"=","%3A":":","%40":"@"}},decode:{expression:/[\/\?#]/g,map:{"/":"%2F","?":"%3F","#":"%23"}}},reserved:{encode:{expression:/%(21|23|24|26|27|28|29|2A|2B|2C|2F|3A|3B|3D|3F|40|5B|5D)/gi,map:{"%3A":":","%2F":"/","%3F":"?","%23":"#","%5B":"[","%5D":"]","%40":"@","%21":"!","%24":"$","%26":"&","%27":"'","%28":"(","%29":")","%2A":"*","%2B":"+","%2C":",","%3B":";","%3D":"="}}},urnpath:{encode:{expression:/%(21|24|27|28|29|2A|2B|2C|3B|3D|40)/gi,map:{"%21":"!","%24":"$","%27":"'","%28":"(","%29":")","%2A":"*","%2B":"+","%2C":",","%3B":";","%3D":"=","%40":"@"}},decode:{expression:/[\/\?#:]/g,map:{"/":"%2F","?":"%3F","#":"%23",":":"%3A"}}}};s.encodeQuery=function(e,t){var r=s.encode(e+"");if(t===undefined){t=s.escapeQuerySpace}return t?r.replace(/%20/g,"+"):r};s.decodeQuery=function(e,t){e+="";if(t===undefined){t=s.escapeQuerySpace}try{return s.decode(t?e.replace(/\+/g,"%20"):e)}catch(t){return e}};var v={encode:"encode",decode:"decode"};var y;var b=function(e,t){return function(r){try{return s[t](r+"").replace(s.characters[e][t].expression,function(r){return s.characters[e][t].map[r]})}catch(e){return r}}};for(y in v){s[y+"PathSegment"]=b("pathname",v[y]);s[y+"UrnPathSegment"]=b("urnpath",v[y])}var w=function(e,t,r){return function(n){var i;if(!r){i=s[t]}else{i=function(e){return s[t](s[r](e))}}var a=(n+"").split(e);for(var o=0,u=a.length;o<u;o++){a[o]=i(a[o])}return a.join(e)}};s.decodePath=w("/","decodePathSegment");s.decodeUrnPath=w(":","decodeUrnPathSegment");s.recodePath=w("/","encodePathSegment","decode");s.recodeUrnPath=w(":","encodeUrnPathSegment","decode");s.encodeReserved=b("reserved","encode");s.parse=function(e,t){var r;if(!t){t={preventInvalidHostname:s.preventInvalidHostname}}e=e.replace(s.leading_whitespace_expression,"");e=e.replace(s.ascii_tab_whitespace,"");r=e.indexOf("#");if(r>-1){t.fragment=e.substring(r+1)||null;e=e.substring(0,r)}r=e.indexOf("?");if(r>-1){t.query=e.substring(r+1)||null;e=e.substring(0,r)}e=e.replace(/^(https?|ftp|wss?)?:+[/\\]*/i,"$1://");e=e.replace(/^[/\\]{2,}/i,"//");if(e.substring(0,2)==="//"){t.protocol=null;e=e.substring(2);e=s.parseAuthority(e,t)}else{r=e.indexOf(":");if(r>-1){t.protocol=e.substring(0,r)||null;if(t.protocol&&!t.protocol.match(s.protocol_expression)){t.protocol=undefined}else if(e.substring(r+1,r+3).replace(/\\/g,"/")==="//"){e=e.substring(r+3);e=s.parseAuthority(e,t)}else{e=e.substring(r+1);t.urn=true}}}t.path=e;return t};s.parseHost=function(e,t){if(!e){e=""}e=e.replace(/\\/g,"/");var r=e.indexOf("/");var n;var i;if(r===-1){r=e.length}if(e.charAt(0)==="["){n=e.indexOf("]");t.hostname=e.substring(1,n)||null;t.port=e.substring(n+2,r)||null;if(t.port==="/"){t.port=null}}else{var a=e.indexOf(":");var o=e.indexOf("/");var u=e.indexOf(":",a+1);if(u!==-1&&(o===-1||u<o)){t.hostname=e.substring(0,r)||null;t.port=null}else{i=e.substring(0,r).split(":");t.hostname=i[0]||null;t.port=i[1]||null}}if(t.hostname&&e.substring(r).charAt(0)!=="/"){r++;e="/"+e}if(t.preventInvalidHostname){s.ensureValidHostname(t.hostname,t.protocol)}if(t.port){s.ensureValidPort(t.port)}return e.substring(r)||"/"};s.parseAuthority=function(e,t){e=s.parseUserinfo(e,t);return s.parseHost(e,t)};s.parseUserinfo=function(e,t){var r=e;var n=e.indexOf("\\");if(n!==-1){e=e.replace(/\\/g,"/")}var i=e.indexOf("/");var a=e.lastIndexOf("@",i>-1?i:e.length-1);var o;if(a>-1&&(i===-1||a<i)){o=e.substring(0,a).split(":");t.username=o[0]?s.decode(o[0]):null;o.shift();t.password=o[0]?s.decode(o.join(":")):null;e=r.substring(a+1)}else{t.username=null;t.password=null}return e};s.parseQuery=function(e,t){if(!e){return{}}e=e.replace(/&+/g,"&").replace(/^\?*&*|&+$/g,"");if(!e){return{}}var r={};var n=e.split("&");var i=n.length;var a,o,h;for(var f=0;f<i;f++){a=n[f].split("=");o=s.decodeQuery(a.shift(),t);h=a.length?s.decodeQuery(a.join("="),t):null;if(o==="__proto__"){continue}else if(u.call(r,o)){if(typeof r[o]==="string"||r[o]===null){r[o]=[r[o]]}r[o].push(h)}else{r[o]=h}}return r};s.build=function(e){var t="";var r=false;if(e.protocol){t+=e.protocol+":"}if(!e.urn&&(t||e.hostname)){t+="//";r=true}t+=s.buildAuthority(e)||"";if(typeof e.path==="string"){if(e.path.charAt(0)!=="/"&&r){t+="/"}t+=e.path}if(typeof e.query==="string"&&e.query){t+="?"+e.query}if(typeof e.fragment==="string"&&e.fragment){t+="#"+e.fragment}return t};s.buildHost=function(e){var t="";if(!e.hostname){return""}else if(s.ip6_expression.test(e.hostname)){t+="["+e.hostname+"]"}else{t+=e.hostname}if(e.port){t+=":"+e.port}return t};s.buildAuthority=function(e){return s.buildUserinfo(e)+s.buildHost(e)};s.buildUserinfo=function(e){var t="";if(e.username){t+=s.encode(e.username)}if(e.password){t+=":"+s.encode(e.password)}if(t){t+="@"}return t};s.buildQuery=function(e,t,r){var n="";var i,a,o,h;for(a in e){if(a==="__proto__"){continue}else if(u.call(e,a)){if(p(e[a])){i={};for(o=0,h=e[a].length;o<h;o++){if(e[a][o]!==undefined&&i[e[a][o]+""]===undefined){n+="&"+s.buildQueryParameter(a,e[a][o],r);if(t!==true){i[e[a][o]+""]=true}}}}else if(e[a]!==undefined){n+="&"+s.buildQueryParameter(a,e[a],r)}}}return n.substring(1)};s.buildQueryParameter=function(e,t,r){return s.encodeQuery(e,r)+(t!==null?"="+s.encodeQuery(t,r):"")};s.addQuery=function(e,t,r){if(typeof t==="object"){for(var n in t){if(u.call(t,n)){s.addQuery(e,n,t[n])}}}else if(typeof t==="string"){if(e[t]===undefined){e[t]=r;return}else if(typeof e[t]==="string"){e[t]=[e[t]]}if(!p(r)){r=[r]}e[t]=(e[t]||[]).concat(r)}else{throw new TypeError("URI.addQuery() accepts an object, string as the name parameter")}};s.setQuery=function(e,t,r){if(typeof t==="object"){for(var n in t){if(u.call(t,n)){s.setQuery(e,n,t[n])}}}else if(typeof t==="string"){e[t]=r===undefined?null:r}else{throw new TypeError("URI.setQuery() accepts an object, string as the name parameter")}};s.removeQuery=function(e,t,r){var n,i,a;if(p(t)){for(n=0,i=t.length;n<i;n++){e[t[n]]=undefined}}else if(f(t)==="RegExp"){for(a in e){if(t.test(a)){e[a]=undefined}}}else if(typeof t==="object"){for(a in t){if(u.call(t,a)){s.removeQuery(e,a,t[a])}}}else if(typeof t==="string"){if(r!==undefined){if(f(r)==="RegExp"){if(!p(e[t])&&r.test(e[t])){e[t]=undefined}else{e[t]=l(e[t],r)}}else if(e[t]===String(r)&&(!p(r)||r.length===1)){e[t]=undefined}else if(p(e[t])){e[t]=l(e[t],r)}}else{e[t]=undefined}}else{throw new TypeError("URI.removeQuery() accepts an object, string, RegExp as the first parameter")}};s.hasQuery=function(e,t,r,n){switch(f(t)){case"String":break;case"RegExp":for(var i in e){if(u.call(e,i)){if(t.test(i)&&(r===undefined||s.hasQuery(e,i,r))){return true}}}return false;case"Object":for(var a in t){if(u.call(t,a)){if(!s.hasQuery(e,a,t[a])){return false}}}return true;default:throw new TypeError("URI.hasQuery() accepts a string, regular expression or object as the name parameter")}switch(f(r)){case"Undefined":return t in e;case"Boolean":var o=Boolean(p(e[t])?e[t].length:e[t]);return r===o;case"Function":return!!r(e[t],t,e);case"Array":if(!p(e[t])){return false}var h=n?c:d;return h(e[t],r);case"RegExp":if(!p(e[t])){return Boolean(e[t]&&e[t].match(r))}if(!n){return false}return c(e[t],r);case"Number":r=String(r);case"String":if(!p(e[t])){return e[t]===r}if(!n){return false}return c(e[t],r);default:throw new TypeError("URI.hasQuery() accepts undefined, boolean, string, number, RegExp, Function as the value parameter")}};s.joinPaths=function(){var e=[];var t=[];var r=0;for(var n=0;n<arguments.length;n++){var i=new s(arguments[n]);e.push(i);var a=i.segment();for(var o=0;o<a.length;o++){if(typeof a[o]==="string"){t.push(a[o])}if(a[o]){r++}}}if(!t.length||!r){return new s("")}var u=new s("").segment(t);if(e[0].path()===""||e[0].path().slice(0,1)==="/"){u.path("/"+u.path())}return u.normalize()};s.commonPath=function(e,t){var r=Math.min(e.length,t.length);var n;for(n=0;n<r;n++){if(e.charAt(n)!==t.charAt(n)){n--;break}}if(n<1){return e.charAt(0)===t.charAt(0)&&e.charAt(0)==="/"?"/":""}if(e.charAt(n)!=="/"||t.charAt(n)!=="/"){n=e.substring(0,n).lastIndexOf("/")}return e.substring(0,n+1)};s.withinString=function(e,t,r){r||(r={});var n=r.start||s.findUri.start;var i=r.end||s.findUri.end;var a=r.trim||s.findUri.trim;var o=r.parens||s.findUri.parens;var u=/[a-z0-9-]=["']?$/i;n.lastIndex=0;while(true){var h=n.exec(e);if(!h){break}var f=h.index;if(r.ignoreHtml){var p=e.slice(Math.max(f-3,0),f);if(p&&u.test(p)){continue}}var l=f+e.slice(f).search(i);var c=e.slice(f,l);var d=-1;while(true){var m=o.exec(c);if(!m){break}var g=m.index+m[0].length;d=Math.max(d,g)}if(d>-1){c=c.slice(0,d)+c.slice(d).replace(a,"")}else{c=c.replace(a,"")}if(c.length<=h[0].length){continue}if(r.ignore&&r.ignore.test(c)){continue}l=f+c.length;var _=t(c,f,l,e);if(_===undefined){n.lastIndex=l;continue}_=String(_);e=e.slice(0,f)+_+e.slice(l);n.lastIndex=f+_.length}n.lastIndex=0;return e};s.ensureValidHostname=function(t,r){var n=!!t;var i=!!r;var a=false;if(i){a=c(s.hostProtocols,r)}if(a&&!n){throw new TypeError("Hostname cannot be empty, if protocol is "+r)}else if(t&&t.match(s.invalid_hostname_characters)){if(!e){throw new TypeError('Hostname "'+t+'" contains characters other than [A-Z0-9.-:_] and Punycode.js is not available')}if(e.toASCII(t).match(s.invalid_hostname_characters)){throw new TypeError('Hostname "'+t+'" contains characters other than [A-Z0-9.-:_]')}}};s.ensureValidPort=function(e){if(!e){return}var t=Number(e);if(a(t)&&t>0&&t<65536){return}throw new TypeError('Port "'+e+'" is not a valid port')};s.noConflict=function(e){if(e){var t={URI:this.noConflict()};if(n.URITemplate&&typeof n.URITemplate.noConflict==="function"){t.URITemplate=n.URITemplate.noConflict()}if(n.IPv6&&typeof n.IPv6.noConflict==="function"){t.IPv6=n.IPv6.noConflict()}if(n.SecondLevelDomains&&typeof n.SecondLevelDomains.noConflict==="function"){t.SecondLevelDomains=n.SecondLevelDomains.noConflict()}return t}else if(n.URI===this){n.URI=i}return this};o.build=function(e){if(e===true){this._deferred_build=true}else if(e===undefined||this._deferred_build){this._string=s.build(this._parts);this._deferred_build=false}return this};o.clone=function(){return new s(this)};o.valueOf=o.toString=function(){return this.build(false)._string};function Q(e){return function(t,r){if(t===undefined){return this._parts[e]||""}else{this._parts[e]=t||null;this.build(!r);return this}}}function A(e,t){return function(r,n){if(r===undefined){return this._parts[e]||""}else{if(r!==null){r=r+"";if(r.charAt(0)===t){r=r.substring(1)}}this._parts[e]=r;this.build(!n);return this}}}o.protocol=Q("protocol");o.username=Q("username");o.password=Q("password");o.hostname=Q("hostname");o.port=Q("port");o.query=A("query","?");o.fragment=A("fragment","#");o.search=function(e,t){var r=this.query(e,t);return typeof r==="string"&&r.length?"?"+r:r};o.hash=function(e,t){var r=this.fragment(e,t);return typeof r==="string"&&r.length?"#"+r:r};o.pathname=function(e,t){if(e===undefined||e===true){var r=this._parts.path||(this._parts.hostname?"/":"");return e?(this._parts.urn?s.decodeUrnPath:s.decodePath)(r):r}else{if(this._parts.urn){this._parts.path=e?s.recodeUrnPath(e):""}else{this._parts.path=e?s.recodePath(e):"/"}this.build(!t);return this}};o.path=o.pathname;o.href=function(e,t){var r;if(e===undefined){return this.toString()}this._string="";this._parts=s._parts();var n=e instanceof s;var i=typeof e==="object"&&(e.hostname||e.path||e.pathname);if(e.nodeName){var a=s.getDomAttribute(e);e=e[a]||"";i=false}if(!n&&i&&e.pathname!==undefined){e=e.toString()}if(typeof e==="string"||e instanceof String){this._parts=s.parse(String(e),this._parts)}else if(n||i){var o=n?e._parts:e;for(r in o){if(r==="query"){continue}if(u.call(this._parts,r)){this._parts[r]=o[r]}}if(o.query){this.query(o.query,false)}}else{throw new TypeError("invalid input")}this.build(!t);return this};o.is=function(e){var t=false;var n=false;var i=false;var a=false;var o=false;var u=false;var h=false;var f=!this._parts.urn;if(this._parts.hostname){f=false;n=s.ip4_expression.test(this._parts.hostname);i=s.ip6_expression.test(this._parts.hostname);t=n||i;a=!t;o=a&&r&&r.has(this._parts.hostname);u=a&&s.idn_expression.test(this._parts.hostname);h=a&&s.punycode_expression.test(this._parts.hostname)}switch(e.toLowerCase()){case"relative":return f;case"absolute":return!f;case"domain":case"name":return a;case"sld":return o;case"ip":return t;case"ip4":case"ipv4":case"inet4":return n;case"ip6":case"ipv6":case"inet6":return i;case"idn":return u;case"url":return!this._parts.urn;case"urn":return!!this._parts.urn;case"punycode":return h}return null};var x=o.protocol;var P=o.port;var I=o.hostname;o.protocol=function(e,t){if(e){e=e.replace(/:(\/\/)?$/,"");if(!e.match(s.protocol_expression)){throw new TypeError('Protocol "'+e+"\" contains characters other than [A-Z0-9.+-] or doesn't start with [A-Z]")}}return x.call(this,e,t)};o.scheme=o.protocol;o.port=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e!==undefined){if(e===0){e=null}if(e){e+="";if(e.charAt(0)===":"){e=e.substring(1)}s.ensureValidPort(e)}}return P.call(this,e,t)};o.hostname=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e!==undefined){var r={preventInvalidHostname:this._parts.preventInvalidHostname};var n=s.parseHost(e,r);if(n!=="/"){throw new TypeError('Hostname "'+e+'" contains characters other than [A-Z0-9.-]')}e=r.hostname;if(this._parts.preventInvalidHostname){s.ensureValidHostname(e,this._parts.protocol)}}return I.call(this,e,t)};o.origin=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e===undefined){var r=this.protocol();var n=this.authority();if(!n){return""}return(r?r+"://":"")+this.authority()}else{var i=s(e);this.protocol(i.protocol()).authority(i.authority()).build(!t);return this}};o.host=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e===undefined){return this._parts.hostname?s.buildHost(this._parts):""}else{var r=s.parseHost(e,this._parts);if(r!=="/"){throw new TypeError('Hostname "'+e+'" contains characters other than [A-Z0-9.-]')}this.build(!t);return this}};o.authority=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e===undefined){return this._parts.hostname?s.buildAuthority(this._parts):""}else{var r=s.parseAuthority(e,this._parts);if(r!=="/"){throw new TypeError('Hostname "'+e+'" contains characters other than [A-Z0-9.-]')}this.build(!t);return this}};o.userinfo=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e===undefined){var r=s.buildUserinfo(this._parts);return r?r.substring(0,r.length-1):r}else{if(e[e.length-1]!=="@"){e+="@"}s.parseUserinfo(e,this._parts);this.build(!t);return this}};o.resource=function(e,t){var r;if(e===undefined){return this.path()+this.search()+this.hash()}r=s.parse(e);this._parts.path=r.path;this._parts.query=r.query;this._parts.fragment=r.fragment;this.build(!t);return this};o.subdomain=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e===undefined){if(!this._parts.hostname||this.is("IP")){return""}var r=this._parts.hostname.length-this.domain().length-1;return this._parts.hostname.substring(0,r)||""}else{var n=this._parts.hostname.length-this.domain().length;var i=this._parts.hostname.substring(0,n);var a=new RegExp("^"+h(i));if(e&&e.charAt(e.length-1)!=="."){e+="."}if(e.indexOf(":")!==-1){throw new TypeError("Domains cannot contain colons")}if(e){s.ensureValidHostname(e,this._parts.protocol)}this._parts.hostname=this._parts.hostname.replace(a,e);this.build(!t);return this}};o.domain=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(typeof e==="boolean"){t=e;e=undefined}if(e===undefined){if(!this._parts.hostname||this.is("IP")){return""}var r=this._parts.hostname.match(/\./g);if(r&&r.length<2){return this._parts.hostname}var n=this._parts.hostname.length-this.tld(t).length-1;n=this._parts.hostname.lastIndexOf(".",n-1)+1;return this._parts.hostname.substring(n)||""}else{if(!e){throw new TypeError("cannot set domain empty")}if(e.indexOf(":")!==-1){throw new TypeError("Domains cannot contain colons")}s.ensureValidHostname(e,this._parts.protocol);if(!this._parts.hostname||this.is("IP")){this._parts.hostname=e}else{var i=new RegExp(h(this.domain())+"$");this._parts.hostname=this._parts.hostname.replace(i,e)}this.build(!t);return this}};o.tld=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(typeof e==="boolean"){t=e;e=undefined}if(e===undefined){if(!this._parts.hostname||this.is("IP")){return""}var n=this._parts.hostname.lastIndexOf(".");var i=this._parts.hostname.substring(n+1);if(t!==true&&r&&r.list[i.toLowerCase()]){return r.get(this._parts.hostname)||i}return i}else{var s;if(!e){throw new TypeError("cannot set TLD empty")}else if(e.match(/[^a-zA-Z0-9-]/)){if(r&&r.is(e)){s=new RegExp(h(this.tld())+"$");this._parts.hostname=this._parts.hostname.replace(s,e)}else{throw new TypeError('TLD "'+e+'" contains characters other than [A-Z0-9]')}}else if(!this._parts.hostname||this.is("IP")){throw new ReferenceError("cannot set TLD on non-domain host")}else{s=new RegExp(h(this.tld())+"$");this._parts.hostname=this._parts.hostname.replace(s,e)}this.build(!t);return this}};o.directory=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e===undefined||e===true){if(!this._parts.path&&!this._parts.hostname){return""}if(this._parts.path==="/"){return"/"}var r=this._parts.path.length-this.filename().length-1;var n=this._parts.path.substring(0,r)||(this._parts.hostname?"/":"");return e?s.decodePath(n):n}else{var i=this._parts.path.length-this.filename().length;var a=this._parts.path.substring(0,i);var o=new RegExp("^"+h(a));if(!this.is("relative")){if(!e){e="/"}if(e.charAt(0)!=="/"){e="/"+e}}if(e&&e.charAt(e.length-1)!=="/"){e+="/"}e=s.recodePath(e);this._parts.path=this._parts.path.replace(o,e);this.build(!t);return this}};o.filename=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(typeof e!=="string"){if(!this._parts.path||this._parts.path==="/"){return""}var r=this._parts.path.lastIndexOf("/");var n=this._parts.path.substring(r+1);return e?s.decodePathSegment(n):n}else{var i=false;if(e.charAt(0)==="/"){e=e.substring(1)}if(e.match(/\.?\//)){i=true}var a=new RegExp(h(this.filename())+"$");e=s.recodePath(e);this._parts.path=this._parts.path.replace(a,e);if(i){this.normalizePath(t)}else{this.build(!t)}return this}};o.suffix=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e===undefined||e===true){if(!this._parts.path||this._parts.path==="/"){return""}var r=this.filename();var n=r.lastIndexOf(".");var i,a;if(n===-1){return""}i=r.substring(n+1);a=/^[a-z0-9%]+$/i.test(i)?i:"";return e?s.decodePathSegment(a):a}else{if(e.charAt(0)==="."){e=e.substring(1)}var o=this.suffix();var u;if(!o){if(!e){return this}this._parts.path+="."+s.recodePath(e)}else if(!e){u=new RegExp(h("."+o)+"$")}else{u=new RegExp(h(o)+"$")}if(u){e=s.recodePath(e);this._parts.path=this._parts.path.replace(u,e)}this.build(!t);return this}};o.segment=function(e,t,r){var n=this._parts.urn?":":"/";var i=this.path();var s=i.substring(0,1)==="/";var a=i.split(n);if(e!==undefined&&typeof e!=="number"){r=t;t=e;e=undefined}if(e!==undefined&&typeof e!=="number"){throw new Error('Bad segment "'+e+'", must be 0-based integer')}if(s){a.shift()}if(e<0){e=Math.max(a.length+e,0)}if(t===undefined){return e===undefined?a:a[e]}else if(e===null||a[e]===undefined){if(p(t)){a=[];for(var o=0,u=t.length;o<u;o++){if(!t[o].length&&(!a.length||!a[a.length-1].length)){continue}if(a.length&&!a[a.length-1].length){a.pop()}a.push(m(t[o]))}}else if(t||typeof t==="string"){t=m(t);if(a[a.length-1]===""){a[a.length-1]=t}else{a.push(t)}}}else{if(t){a[e]=m(t)}else{a.splice(e,1)}}if(s){a.unshift("")}return this.path(a.join(n),r)};o.segmentCoded=function(e,t,r){var n,i,a;if(typeof e!=="number"){r=t;t=e;e=undefined}if(t===undefined){n=this.segment(e,t,r);if(!p(n)){n=n!==undefined?s.decode(n):undefined}else{for(i=0,a=n.length;i<a;i++){n[i]=s.decode(n[i])}}return n}if(!p(t)){t=typeof t==="string"||t instanceof String?s.encode(t):t}else{for(i=0,a=t.length;i<a;i++){t[i]=s.encode(t[i])}}return this.segment(e,t,r)};var S=o.query;o.query=function(e,t){if(e===true){return s.parseQuery(this._parts.query,this._parts.escapeQuerySpace)}else if(typeof e==="function"){var r=s.parseQuery(this._parts.query,this._parts.escapeQuerySpace);var n=e.call(this,r);this._parts.query=s.buildQuery(n||r,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace);this.build(!t);return this}else if(e!==undefined&&typeof e!=="string"){this._parts.query=s.buildQuery(e,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace);this.build(!t);return this}else{return S.call(this,e,t)}};o.setQuery=function(e,t,r){var n=s.parseQuery(this._parts.query,this._parts.escapeQuerySpace);if(typeof e==="string"||e instanceof String){n[e]=t!==undefined?t:null}else if(typeof e==="object"){for(var i in e){if(u.call(e,i)){n[i]=e[i]}}}else{throw new TypeError("URI.addQuery() accepts an object, string as the name parameter")}this._parts.query=s.buildQuery(n,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace);if(typeof e!=="string"){r=t}this.build(!r);return this};o.addQuery=function(e,t,r){var n=s.parseQuery(this._parts.query,this._parts.escapeQuerySpace);s.addQuery(n,e,t===undefined?null:t);this._parts.query=s.buildQuery(n,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace);if(typeof e!=="string"){r=t}this.build(!r);return this};o.removeQuery=function(e,t,r){var n=s.parseQuery(this._parts.query,this._parts.escapeQuerySpace);s.removeQuery(n,e,t);this._parts.query=s.buildQuery(n,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace);if(typeof e!=="string"){r=t}this.build(!r);return this};o.hasQuery=function(e,t,r){var n=s.parseQuery(this._parts.query,this._parts.escapeQuerySpace);return s.hasQuery(n,e,t,r)};o.setSearch=o.setQuery;o.addSearch=o.addQuery;o.removeSearch=o.removeQuery;o.hasSearch=o.hasQuery;o.normalize=function(){if(this._parts.urn){return this.normalizeProtocol(false).normalizePath(false).normalizeQuery(false).normalizeFragment(false).build()}return this.normalizeProtocol(false).normalizeHostname(false).normalizePort(false).normalizePath(false).normalizeQuery(false).normalizeFragment(false).build()};o.normalizeProtocol=function(e){if(typeof this._parts.protocol==="string"){this._parts.protocol=this._parts.protocol.toLowerCase();this.build(!e)}return this};o.normalizeHostname=function(r){if(this._parts.hostname){if(this.is("IDN")&&e){this._parts.hostname=e.toASCII(this._parts.hostname)}else if(this.is("IPv6")&&t){this._parts.hostname=t.best(this._parts.hostname)}this._parts.hostname=this._parts.hostname.toLowerCase();this.build(!r)}return this};o.normalizePort=function(e){if(typeof this._parts.protocol==="string"&&this._parts.port===s.defaultPorts[this._parts.protocol]){this._parts.port=null;this.build(!e)}return this};o.normalizePath=function(e){var t=this._parts.path;if(!t){return this}if(this._parts.urn){this._parts.path=s.recodeUrnPath(this._parts.path);this.build(!e);return this}if(this._parts.path==="/"){return this}t=s.recodePath(t);var r;var n="";var i,a;if(t.charAt(0)!=="/"){r=true;t="/"+t}if(t.slice(-3)==="/.."||t.slice(-2)==="/."){t+="/"}t=t.replace(/(\/(\.\/)+)|(\/\.$)/g,"/").replace(/\/{2,}/g,"/");if(r){n=t.substring(1).match(/^(\.\.\/)+/)||"";if(n){n=n[0]}}while(true){i=t.search(/\/\.\.(\/|$)/);if(i===-1){break}else if(i===0){t=t.substring(3);continue}a=t.substring(0,i).lastIndexOf("/");if(a===-1){a=i}t=t.substring(0,a)+t.substring(i+3)}if(r&&this.is("relative")){t=n+t.substring(1)}this._parts.path=t;this.build(!e);return this};o.normalizePathname=o.normalizePath;o.normalizeQuery=function(e){if(typeof this._parts.query==="string"){if(!this._parts.query.length){this._parts.query=null}else{this.query(s.parseQuery(this._parts.query,this._parts.escapeQuerySpace))}this.build(!e)}return this};o.normalizeFragment=function(e){if(!this._parts.fragment){this._parts.fragment=null;this.build(!e)}return this};o.normalizeSearch=o.normalizeQuery;o.normalizeHash=o.normalizeFragment;o.iso8859=function(){var e=s.encode;var t=s.decode;s.encode=escape;s.decode=decodeURIComponent;try{this.normalize()}finally{s.encode=e;s.decode=t}return this};o.unicode=function(){var e=s.encode;var t=s.decode;s.encode=_;s.decode=unescape;try{this.normalize()}finally{s.encode=e;s.decode=t}return this};o.readable=function(){var t=this.clone();t.username("").password("").normalize();var r="";if(t._parts.protocol){r+=t._parts.protocol+"://"}if(t._parts.hostname){if(t.is("punycode")&&e){r+=e.toUnicode(t._parts.hostname);if(t._parts.port){r+=":"+t._parts.port}}else{r+=t.host()}}if(t._parts.hostname&&t._parts.path&&t._parts.path.charAt(0)!=="/"){r+="/"}r+=t.path(true);if(t._parts.query){var n="";for(var i=0,a=t._parts.query.split("&"),o=a.length;i<o;i++){var u=(a[i]||"").split("=");n+="&"+s.decodeQuery(u[0],this._parts.escapeQuerySpace).replace(/&/g,"%26");if(u[1]!==undefined){n+="="+s.decodeQuery(u[1],this._parts.escapeQuerySpace).replace(/&/g,"%26")}}r+="?"+n.substring(1)}r+=s.decodeQuery(t.hash(),true);return r};o.absoluteTo=function(e){var t=this.clone();var r=["protocol","username","password","hostname","port"];var n,i,a;if(this._parts.urn){throw new Error("URNs do not have any generally defined hierarchical components")}if(!(e instanceof s)){e=new s(e)}if(t._parts.protocol){return t}else{t._parts.protocol=e._parts.protocol}if(this._parts.hostname){return t}for(i=0;a=r[i];i++){t._parts[a]=e._parts[a]}if(!t._parts.path){t._parts.path=e._parts.path;if(!t._parts.query){t._parts.query=e._parts.query}}else{if(t._parts.path.substring(-2)===".."){t._parts.path+="/"}if(t.path().charAt(0)!=="/"){n=e.directory();n=n?n:e.path().indexOf("/")===0?"/":"";t._parts.path=(n?n+"/":"")+t._parts.path;t.normalizePath()}}t.build();return t};o.relativeTo=function(e){var t=this.clone().normalize();var r,n,i,a,o;if(t._parts.urn){throw new Error("URNs do not have any generally defined hierarchical components")}e=new s(e).normalize();r=t._parts;n=e._parts;a=t.path();o=e.path();if(a.charAt(0)!=="/"){throw new Error("URI is already relative")}if(o.charAt(0)!=="/"){throw new Error("Cannot calculate a URI relative to another relative URI")}if(r.protocol===n.protocol){r.protocol=null}if(r.username!==n.username||r.password!==n.password){return t.build()}if(r.protocol!==null||r.username!==null||r.password!==null){return t.build()}if(r.hostname===n.hostname&&r.port===n.port){r.hostname=null;r.port=null}else{return t.build()}if(a===o){r.path="";return t.build()}i=s.commonPath(a,o);if(!i){return t.build()}var u=n.path.substring(i.length).replace(/[^\/]*$/,"").replace(/.*?\//g,"../");r.path=u+r.path.substring(i.length)||"./";return t.build()};o.equals=function(e){var t=this.clone();var r=new s(e);var n={};var i={};var a={};var o,h,f;t.normalize();r.normalize();if(t.toString()===r.toString()){return true}o=t.query();h=r.query();t.query("");r.query("");if(t.toString()!==r.toString()){return false}if(o.length!==h.length){return false}n=s.parseQuery(o,this._parts.escapeQuerySpace);i=s.parseQuery(h,this._parts.escapeQuerySpace);for(f in n){if(u.call(n,f)){if(!p(n[f])){if(n[f]!==i[f]){return false}}else if(!d(n[f],i[f])){return false}a[f]=true}}for(f in i){if(u.call(i,f)){if(!a[f]){return false}}}return true};o.preventInvalidHostname=function(e){this._parts.preventInvalidHostname=!!e;return this};o.duplicateQueryParameters=function(e){this._parts.duplicateQueryParameters=!!e;return this};o.escapeQuerySpace=function(e){this._parts.escapeQuerySpace=!!e;return this};return s});
},
	"sap/ui/thirdparty/jquery-compat.js":function(){
/*!
 * jQuery Migrate - v3.3.1 - 2020-06-25T01:07Z
 * Copyright OpenJS Foundation and other contributors
 */
(function(e){"use strict";var t=document.querySelector("SCRIPT[src][id=sap-ui-bootstrap]");var r=window["sap-ui-config"]||{};if(/sap-ui-excludeJQueryCompat=(true|x)/.test(location.search)||t&&t.getAttribute("data-sap-ui-excludejquerycompat")==="true"||r["excludejquerycompat"]===true||r["excludeJQueryCompat"]===true){return}if(typeof window.sap!=="object"&&typeof window.sap!=="function"){window.sap={}}if(typeof window.sap.ui!=="object"){window.sap.ui={}}sap.ui._jQuery3Compat={_factory:e};if(window.jQuery){e(jQuery,window)}})(function(jQuery,e){"use strict";jQuery.migrateVersion="3.3.1";function t(e,t){var r,n=/^(\d+)\.(\d+)\.(\d+)/,i=n.exec(e)||[],o=n.exec(t)||[];for(r=1;r<=3;r++){if(+i[r]>+o[r]){return 1}if(+i[r]<+o[r]){return-1}}return 0}function r(e){return t(jQuery.fn.jquery,e)>=0}if(r("3.0.0")&&!r("4.0.0")){if(jQuery.fn.jquery!=="3.6.0"&&console){console.warn("The current jQuery version "+jQuery.fn.jquery+" is different than the version 3.6.0 that is used for testing jquery-compat.js. jquery-compat.js is applied but it may not work properly.")}}else{if(console){console.error("The current jQuery version "+jQuery.fn.jquery+" differs at the major version than the version 3.6.0 that is used for testing jquery-compat.js. jquery-compat.js shouldn't be applied in this case!")}return}var n={};jQuery.migrateDeduplicateWarnings=false;jQuery.migrateWarnings=[];function i(e){var t;e=e.replace(" and removed","");if(!jQuery.migrateDeduplicateWarnings||!n[e]){t=sap&&sap.ui&&sap.ui.require?sap.ui.require("sap/base/Log"):false;n[e]=true;jQuery.migrateWarnings.push(e);if(!jQuery.migrateMute){e="JQMIGRATE: "+e;if(t){if(jQuery.migrateTrace){t.setLevel(5)}t[jQuery.migrateTrace?"trace":"warning"](e,"jQueryThreeDeprecation",null,function(){return{type:"jQueryThreeDeprecation",name:"jquery-compat"}})}else if(console&&console.warn){console.warn(e);if(jQuery.migrateTrace&&console.trace){console.trace()}}}}}sap.ui._jQuery3Compat._migrateWarn=i;function o(e,t,r,n){Object.defineProperty(e,t,{configurable:true,enumerable:true,get:function(){i(n);return r},set:function(e){i(n);r=e}})}function a(e,t,r,n){e[t]=function(){i(n);return r.apply(this,arguments)}}var s={},u=jQuery.fn.init,c=/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;jQuery.fn.init=function(t){var r=Array.prototype.slice.call(arguments);if(typeof t==="string"&&t==="#"){i("jQuery( '#' ) is not a valid selector");r[0]=[]}var n=u.apply(this,r);if(r[0]){if(r[0].nodeType){n.context=r[0]}else if(typeof r[0]==="string"&&!(r[0][0]==="<"&&r[0][r[0].length-1]===">"&&r[0].length>=3)){n.context=e.document}}return n};jQuery.fn.init.prototype=jQuery.fn;a(jQuery.fn,"size",function(){return this.length},"jQuery.fn.size() is deprecated and removed; use the .length property");a(jQuery,"parseJSON",function(){return JSON.parse.apply(null,arguments)},"jQuery.parseJSON is deprecated; use JSON.parse");a(jQuery,"holdReady",jQuery.holdReady,"jQuery.holdReady is deprecated");a(jQuery,"unique",jQuery.uniqueSort,"jQuery.unique is deprecated; use jQuery.uniqueSort");o(jQuery.expr,"filters",jQuery.expr.pseudos,"jQuery.expr.filters is deprecated; use jQuery.expr.pseudos");o(jQuery.expr,":",jQuery.expr.pseudos,"jQuery.expr[':'] is deprecated; use jQuery.expr.pseudos");if(r("3.1.1")){a(jQuery,"trim",function(e){return e==null?"":(e+"").replace(c,"")},"jQuery.trim is deprecated; use String.prototype.trim")}if(r("3.2.0")){a(jQuery,"nodeName",function(e,t){return e.nodeName&&e.nodeName.toLowerCase()===t.toLowerCase()},"jQuery.nodeName is deprecated")}if(r("3.3.0")){a(jQuery,"isNumeric",function(e){var t=typeof e;return(t==="number"||t==="string")&&!isNaN(e-parseFloat(e))},"jQuery.isNumeric() is deprecated");jQuery.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "),function(e,t){s["[object "+t+"]"]=t.toLowerCase()});a(jQuery,"type",function(e){if(e==null){return e+""}return typeof e==="object"||typeof e==="function"?s[Object.prototype.toString.call(e)]||"object":typeof e},"jQuery.type is deprecated");a(jQuery,"isFunction",function(e){return typeof e==="function"},"jQuery.isFunction() is deprecated");a(jQuery,"isWindow",function(e){return e!=null&&e===e.window},"jQuery.isWindow() is deprecated");a(jQuery,"isArray",Array.isArray,"jQuery.isArray is deprecated; use Array.isArray")}if(jQuery.ajax){var f=jQuery.ajax;jQuery.ajax=function(){var e=f.apply(this,arguments);if(e.promise){a(e,"success",e.done,"jQXHR.success is deprecated and removed");a(e,"error",e.fail,"jQXHR.error is deprecated and removed");a(e,"complete",e.always,"jQXHR.complete is deprecated and removed")}return e}}var p=jQuery.fn.removeAttr,d=jQuery.fn.toggleClass,l=/\S+/g;jQuery.fn.removeAttr=function(e){var t=this;jQuery.each(e.match(l),function(e,r){if(jQuery.expr.match.bool.test(r)){i("jQuery.fn.removeAttr no longer sets boolean properties: "+r);t.prop(r,false)}});return p.apply(this,arguments)};jQuery.fn.toggleClass=function(e){if(e!==undefined&&typeof e!=="boolean"){return d.apply(this,arguments)}i("jQuery.fn.toggleClass( boolean ) is deprecated");return this.each(function(){var t=this.getAttribute&&this.getAttribute("class")||"";if(t){jQuery.data(this,"__className__",t)}if(this.setAttribute){this.setAttribute("class",t||e===false?"":jQuery.data(this,"__className__")||"")}})};function y(e){return e.replace(/-([a-z])/g,function(e,t){return t.toUpperCase()})}var h,m=/^[a-z]/,v=/^(?:Border(?:Top|Right|Bottom|Left)?(?:Width|)|(?:Margin|Padding)?(?:Top|Right|Bottom|Left)?|(?:Min|Max)?(?:Width|Height))$/;if(typeof Proxy!=="undefined"){jQuery.cssProps=new Proxy(jQuery.cssProps||{},{set:function(){i("jQuery.cssProps is deprecated");return Reflect.set.apply(this,arguments)}})}function g(e){return m.test(e)&&v.test(e[0].toUpperCase()+e.slice(1))}h=jQuery.fn.css;jQuery.fn.css=function(e,t){var r,n=this;if(e&&typeof e==="object"&&!Array.isArray(e)){jQuery.each(e,function(e,t){jQuery.fn.css.call(n,e,t)})}if(typeof t==="number"){r=y(e);if(!g(r)&&!jQuery.cssNumber[r]){i('Number-typed values are deprecated for jQuery.fn.css( "'+e+'", value )')}}return h.apply(this,arguments)};if(jQuery.fx){var j,Q;j=jQuery.fx.interval||13;Q="jQuery.fx.interval is deprecated";if(e.requestAnimationFrame){Object.defineProperty(jQuery.fx,"interval",{configurable:true,enumerable:true,get:function(){if(!e.document.hidden){i(Q)}return j},set:function(e){i(Q);j=e}})}}var b=jQuery.fn.load,x=jQuery.event.add,w=jQuery.event.fix;jQuery.event.props=[];jQuery.event.fixHooks={};o(jQuery.event.props,"concat",jQuery.event.props.concat,"jQuery.event.props.concat() is deprecated and removed");jQuery.event.fix=function(e){var t,r=e.type,n=this.fixHooks[r],o=jQuery.event.props;if(o.length){i("jQuery.event.props are deprecated and removed: "+o.join());while(o.length){jQuery.event.addProp(o.pop())}}if(n&&!n._migrated_){n._migrated_=true;i("jQuery.event.fixHooks are deprecated and removed: "+r);if((o=n.props)&&o.length){while(o.length){jQuery.event.addProp(o.pop())}}}t=w.call(this,e);return n&&n.filter?n.filter(t,e):t};jQuery.event.add=function(t,r){if(t===e&&r==="load"&&e.document.readyState==="complete"){i("jQuery(window).on('load'...) called after load event occurred")}return x.apply(this,arguments)};jQuery.each(["load","unload","error"],function(e,t){jQuery.fn[t]=function(){var e=Array.prototype.slice.call(arguments,0);if(t==="load"&&typeof e[0]==="string"){return b.apply(this,e)}i("jQuery.fn."+t+"() is deprecated");e.splice(0,0,t);if(arguments.length){return this.on.apply(this,e)}this.triggerHandler.apply(this,e);return this}});jQuery.each(("blur focus focusin focusout resize scroll click dblclick "+"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave "+"change select submit keydown keypress keyup contextmenu").split(" "),function(e,t){jQuery.fn[t]=function(e,r){i("jQuery.fn."+t+"() event shorthand is deprecated");return arguments.length>0?this.on(t,null,e,r):this.trigger(t)}});jQuery(function(){jQuery(e.document).triggerHandler("ready")});jQuery.event.special.ready={setup:function(){if(this===e.document){i("'ready' event is deprecated")}}};jQuery.fn.extend({bind:function(e,t,r){i("jQuery.fn.bind() is deprecated");return this.on(e,null,t,r)},unbind:function(e,t){i("jQuery.fn.unbind() is deprecated");return this.off(e,null,t)},delegate:function(e,t,r,n){i("jQuery.fn.delegate() is deprecated");return this.on(t,e,r,n)},undelegate:function(e,t,r){i("jQuery.fn.undelegate() is deprecated");return arguments.length===1?this.off(e,"**"):this.off(t,e||"**",r)},hover:function(e,t){i("jQuery.fn.hover() is deprecated");return this.on("mouseenter",e).on("mouseleave",t||e)}});var A=jQuery.fn.offset;jQuery.fn.offset=function(){var e=this[0];if(e&&(!e.nodeType||!e.getBoundingClientRect)){i("jQuery.fn.offset() requires a valid DOM element");return arguments.length?this:undefined}return A.apply(this,arguments)};var q=jQuery.fn.andSelf||jQuery.fn.addBack;jQuery.fn.andSelf=function(){i("jQuery.fn.andSelf() is deprecated and removed, use jQuery.fn.addBack()");return q.apply(this,arguments)};var C=jQuery.Deferred,k=[["resolve","done",jQuery.Callbacks("once memory"),jQuery.Callbacks("once memory"),"resolved"],["reject","fail",jQuery.Callbacks("once memory"),jQuery.Callbacks("once memory"),"rejected"],["notify","progress",jQuery.Callbacks("memory"),jQuery.Callbacks("memory")]];jQuery.Deferred=function(e){var t=C(),r=t.promise();t.pipe=r.pipe=function(){var e=arguments;if(typeof arguments[2]!=="boolean"||!arguments[2]){i("deferred.pipe() is deprecated")}return jQuery.Deferred(function(n){jQuery.each(k,function(i,o){var a=typeof e[i]==="function"&&e[i];t[o[1]](function(){var e=a&&a.apply(this,arguments);if(e&&typeof e.promise==="function"){e.promise().done(n.resolve).fail(n.reject).progress(n.notify)}else{n[o[0]+"With"](this===r?n.promise():this,a?[e]:arguments)}})});e=null}).promise()};t.then=r.then=function(){return t.pipe(arguments[0],arguments[1],true)};t.notify=function(){t.notifyWith(this===t?r:this,arguments);return this};t.resolve=function(){t.resolveWith(this===t?r:this,arguments);return this};t.reject=function(){t.rejectWith(this===t?r:this,arguments);return this};if(e){e.call(t,t)}return t};jQuery.Deferred.exceptionHook=C.exceptionHook;var N={},S=["innerHeight","height","outerHeight","innerWidth","width","outerWidth"];S.forEach(function(e){N[e]=jQuery.fn[e];jQuery.fn[e]=function(){var t=N[e].apply(this,arguments);if(t===undefined&&this.length===0){return null}else{if(typeof t==="number"){t=Math.round(t)}return t}}})});
},
	"sap/ui/thirdparty/jquery-mobile-custom.js":function(){
/*
* jQuery Mobile v1.3.1
* http://jquerymobile.com
*
* Copyright 2010, 2013 jQuery Foundation, Inc. and other contributors
* Released under the MIT license.
* http://jquery.org/license
*
*/
(function(e,t,n){if(typeof define==="function"&&define.amd){define(["jquery"],function(i){n(i,e,t);return i.mobile})}else{n(e.jQuery,e,t)}})(this,document,function(jQuery,e,t,n){
// About: License
// Copyright (c) 2010 "Cowboy" Ben Alman,
// Dual licensed under the MIT and GPL licenses.
// http://benalman.com/about/license/
(function(e,n,i){var o="hashchange",r=t,a,s=e.event.special,u=r.documentMode,l="on"+o in n&&(u===i||u>7);function c(e){e=e||location.href;return"#"+e.replace(/^[^#]*#?(.*)$/,"$1")}e.fn[o]=function(e){return e?this.on(o,e):this.trigger(o)};e.fn[o].delay=50;s[o]=e.extend(s[o],{setup:function(){if(l){return false}e(a.start)},teardown:function(){if(l){return false}e(a.stop)}});a=function(){var t={},r,a=c(),s=function(e){return e},u=s,l=s;t.start=function(){r||f()};t.stop=function(){r&&clearTimeout(r);r=i};function f(){var t=c(),i=l(a);if(t!==a){u(a=t,i);e(n).trigger(o)}else if(i!==a){location.href=location.href.replace(/#.*/,"")+i}r=setTimeout(f,e.fn[o].delay)}return t}()})(jQuery,this);(function(e){e.mobile={};jQuery.mobile.orientationChangeEnabled=true})(jQuery);(function(e,n,i){var o={};e.mobile=e.extend(e.mobile,{version:"1.3.1",ns:"",subPageUrlKey:"ui-page",activePageClass:"ui-page-active",activeBtnClass:"ui-btn-active",focusClass:"ui-focus",ajaxEnabled:true,hashListeningEnabled:true,linkBindingEnabled:true,defaultPageTransition:"fade",maxTransitionWidth:false,minScrollBack:250,touchOverflowEnabled:false,defaultDialogTransition:"pop",pageLoadErrorMessage:"Error Loading Page",pageLoadErrorMessageTheme:"e",phonegapNavigationEnabled:false,autoInitializePage:true,pushStateEnabled:true,ignoreContentEnabled:false,orientationChangeEnabled:true,buttonMarkup:{hoverDelay:200},window:e(n),document:e(t),keyCode:{ALT:18,BACKSPACE:8,CAPS_LOCK:20,COMMA:188,COMMAND:91,COMMAND_LEFT:91,COMMAND_RIGHT:93,CONTROL:17,DELETE:46,DOWN:40,END:35,ENTER:13,ESCAPE:27,HOME:36,INSERT:45,LEFT:37,MENU:93,NUMPAD_ADD:107,NUMPAD_DECIMAL:110,NUMPAD_DIVIDE:111,NUMPAD_ENTER:108,NUMPAD_MULTIPLY:106,NUMPAD_SUBTRACT:109,PAGE_DOWN:34,PAGE_UP:33,PERIOD:190,RIGHT:39,SHIFT:16,SPACE:32,TAB:9,UP:38,WINDOWS:91},behaviors:{},silentScroll:function(t){if(typeof t!=="number"){t=e.mobile.defaultHomeScroll}e.event.special.scrollstart.enabled=false;setTimeout(function(){n.scrollTo(0,t);e.mobile.document.trigger("silentscroll",{x:0,y:t})},20);setTimeout(function(){e.event.special.scrollstart.enabled=true},150)},nsNormalizeDict:o,nsNormalize:function(t){if(!t){return}return o[t]||(o[t]=e.camelCase(e.mobile.ns+t))},getInheritedTheme:function(e,t){var n=e[0],i="",o=/ui-(bar|body|overlay)-([a-z])\b/,r,a;while(n){r=n.className||"";if(r&&(a=o.exec(r))&&(i=a[2])){break}n=n.parentNode}return i||t||"a"},closestPageData:function(e){return e.closest(':jqmData(role="page"), :jqmData(role="dialog")').data("mobile-page")},enhanceable:function(e){return this.haveParents(e,"enhance")},hijackable:function(e){return this.haveParents(e,"ajax")},haveParents:function(t,n){if(!e.mobile.ignoreContentEnabled){return t}var i=t.length,o=e(),r,a,s;for(var u=0;u<i;u++){a=t.eq(u);s=false;r=t[u];while(r){var l=r.getAttribute?r.getAttribute("data-"+e.mobile.ns+n):"";if(l==="false"){s=true;break}r=r.parentNode}if(!s){o=o.add(a)}}return o},getScreenHeight:function(){return n.innerHeight||e.mobile.window.height()}},e.mobile);e.fn.jqmData=function(t,n){var o;if(typeof t!=="undefined"){if(t){t=e.mobile.nsNormalize(t)}if(arguments.length<2||n===i){o=this.data(t)}else{o=this.data(t,n)}}return o};e.jqmData=function(t,n,i){var o;if(typeof n!=="undefined"){o=e.data(t,n?e.mobile.nsNormalize(n):n,i)}return o};e.fn.jqmRemoveData=function(t){return this.removeData(e.mobile.nsNormalize(t))};e.jqmRemoveData=function(t,n){return e.removeData(t,e.mobile.nsNormalize(n))};e.fn.removeWithDependents=function(){e.removeWithDependents(this)};e.removeWithDependents=function(t){var n=e(t);(n.jqmData("dependents")||e()).remove();n.remove()};e.fn.addDependents=function(t){e.addDependents(e(this),t)};e.addDependents=function(t,n){var i=e(t).jqmData("dependents")||e();e(t).jqmData("dependents",e.merge(i,n))};e.fn.getEncodedText=function(){return e("<div/>").text(e(this).text()).html()};e.fn.jqmEnhanceable=function(){return e.mobile.enhanceable(this)};e.fn.jqmHijackable=function(){return e.mobile.hijackable(this)};var r=e.find,a=/:jqmData\(([^)]*)\)/g;e.find=function(t,n,i,o){t=t.replace(a,"[data-"+(e.mobile.ns||"")+"$1]");return r.call(this,t,n,i,o)};e.extend(e.find,r)})(jQuery,this);(function(n,i){
/*! matchMedia() polyfill - Test a CSS media type/query in JS. Authors & copyright (c) 2012: Scott Jehl, Paul Irish, Nicholas Zakas. Dual MIT/BSD license */
e.matchMedia=e.matchMedia||function(e,t){var n,i=e.documentElement,o=i.firstElementChild||i.firstChild,r=e.createElement("body"),a=e.createElement("div");a.id="mq-test-1";a.style.cssText="position:absolute;top:-100em";r.style.background="none";r.appendChild(a);return function(e){a.innerHTML='&shy;<style media="'+e+'"> #mq-test-1 { width: 42px; }</style>';i.insertBefore(r,o);n=a.offsetWidth===42;i.removeChild(r);return{matches:n,media:e}}}(t);n.mobile.media=function(t){return e.matchMedia(t).matches}})(jQuery);(function(n,i){var o={touch:"ontouchend"in t};if(e.sap&&sap.ui&&sap.ui.Device&&sap.ui.Device.support&&!(sap.ui.Device.browser.msie||sap.ui.Device.browser.edge)){o.touch=sap.ui.Device.support.touch}n.mobile.support=n.mobile.support||{};n.extend(n.support,o);n.extend(n.mobile.support,o)})(jQuery);(function(t,n){t.extend(t.support,{orientation:"orientation"in e&&"onorientationchange"in e})})(jQuery);(function(n,i){function o(e){var t=e.charAt(0).toUpperCase()+e.substr(1),n=(e+" "+s.join(t+" ")+t).split(" ");for(var o in n){if(a[n[o]]!==i){return true}}}var r=n("<body>").prependTo("html"),a=r[0].style,s=["Webkit","Moz","O"],u="palmGetResource"in e,l=e.opera,c=e.operamini&&{}.toString.call(e.operamini)==="[object OperaMini]",f=e.blackberry&&!o("-webkit-transform");function d(e,n,i){var o=t.createElement("div"),r=function(e){return e.charAt(0).toUpperCase()+e.substr(1)},a=function(e){if(e===""){return""}else{return"-"+e.charAt(0).toLowerCase()+e.substr(1)+"-"}},u=function(t){var i=a(t)+e+": "+n+";",s=r(t),u=s+(s===""?e:r(e));o.style=i;if(!!o.style[u]){c=true}},l=i?i:s,c;for(var f=0;f<l.length;f++){u(l[f])}return!!c}function h(){var o="transform-3d",a=n.mobile.media("(-"+s.join("-"+o+"),(-")+"-"+o+"),("+o+")");if(a){return!!a}var u=t.createElement("div"),l={MozTransform:"-moz-transform",transform:"transform"};r.append(u);for(var c in l){if(u.style[c]!==i){u.style[c]="translate3d( 100px, 1px, 1px )";a=e.getComputedStyle(u).getPropertyValue(l[c])}}return!!a&&a!=="none"}function p(){var n=t.createElement("x"),i=t.documentElement,o=e.getComputedStyle,r=o&&o(n,""),a;if(!("pointerEvents"in n.style)){return false}n.style.pointerEvents="auto";n.style.pointerEvents="x";i.appendChild(n);a=r&&r.pointerEvents==="auto";i.removeChild(n);return!!a}function v(){var e=t.createElement("div");return typeof e.getBoundingClientRect!=="undefined"}n.extend(n.mobile,{browser:{}});n.mobile.browser.oldIE=function(){var e=3,n=t.createElement("div"),i=n.all||[];do{n.innerHTML="\x3c!--[if gt IE "+ ++e+"]><br><![endif]--\x3e"}while(i[0]);return e>4?e:!e}();function m(){var t=e,n=navigator.userAgent,i=navigator.platform,o=n.match(/AppleWebKit\/([0-9]+)/),r=!!o&&o[1],a=n.match(/Fennec\/([0-9]+)/),s=!!a&&a[1],u=n.match(/Opera Mobi\/([0-9]+)/),l=!!u&&u[1];if((i.indexOf("iPhone")>-1||i.indexOf("iPad")>-1||i.indexOf("iPod")>-1)&&r&&r<534||t.operamini&&{}.toString.call(t.operamini)==="[object OperaMini]"||u&&l<7458||n.indexOf("Android")>-1&&r&&r<533||s&&s<6||"palmGetResource"in e&&r&&r<534||n.indexOf("MeeGo")>-1&&n.indexOf("NokiaBrowser/8.5.0")>-1){return false}return true}n.extend(n.support,{cssTransitions:"WebKitTransitionEvent"in e||d("transition","height 100ms linear",["Webkit","Moz",""])&&!n.mobile.browser.oldIE&&!l,pushState:"pushState"in history&&"replaceState"in history&&!(e.navigator.userAgent.indexOf("Firefox")>=0&&e.top!==e)&&e.navigator.userAgent.search(/CriOS/)===-1,mediaquery:n.mobile.media("only all"),cssPseudoElement:!!o("content"),touchOverflow:!!o("overflowScrolling"),cssTransform3d:h(),boxShadow:!!o("boxShadow")&&!f,fixedPosition:m(),scrollTop:("pageXOffset"in e||"scrollTop"in t.documentElement||"scrollTop"in r[0])&&!u&&!c,dynamicBaseTag:true,cssPointerEvents:p(),boundingRect:v()});r.remove();var g=function(){var t=e.navigator.userAgent;return t.indexOf("Nokia")>-1&&(t.indexOf("Symbian/3")>-1||t.indexOf("Series60/5")>-1)&&t.indexOf("AppleWebKit")>-1&&t.match(/(BrowserNG|NokiaBrowser)\/7\.[0-3]/)}();n.mobile.gradeA=function(){return(n.support.mediaquery||n.mobile.browser.oldIE&&n.mobile.browser.oldIE>=7)&&(n.support.boundingRect||n.fn.jquery.match(/1\.[0-7+]\.[0-9+]?/)!==null)};n.mobile.ajaxBlacklist=e.blackberry&&!e.WebKitPoint||c||g;if(g){n(function(){n("head link[rel='stylesheet']").attr("rel","alternate stylesheet").attr("rel","stylesheet")})}if(!n.support.boxShadow){n("html").addClass("ui-mobile-nosupport-boxshadow")}})(jQuery);(function(e,t){var n=e.mobile.window,i,o;e.event.special.navigate=i={bound:false,pushStateEnabled:true,originalEventName:t,isPushStateEnabled:function(){return e.support.pushState&&e.mobile.pushStateEnabled===true&&this.isHashChangeEnabled()},isHashChangeEnabled:function(){return e.mobile.hashListeningEnabled===true},popstate:function(t){var i=new e.Event("navigate"),o=new e.Event("beforenavigate"),r=t.originalEvent.state||{},a=location.href;n.trigger(o);if(o.isDefaultPrevented()){return}if(t.historyState){e.extend(r,t.historyState)}i.originalEvent=t;setTimeout(function(){n.trigger(i,{state:r})},0)},hashchange:function(t,i){var o=new e.Event("navigate"),r=new e.Event("beforenavigate");n.trigger(r);if(r.isDefaultPrevented()){return}o.originalEvent=t;n.trigger(o,{state:t.hashchangeState||{}})},setup:function(e,t){if(i.bound){return}i.bound=true;if(i.isPushStateEnabled()){i.originalEventName="popstate";n.on("popstate.navigate",i.popstate)}else if(i.isHashChangeEnabled()){i.originalEventName="hashchange";n.on("hashchange.navigate",i.hashchange)}}}})(jQuery);(function(e){e.event.special.throttledresize={setup:function(){e(this).on("resize",n)},teardown:function(){e(this).off("resize",n)}};var t=250,n=function(){r=(new Date).getTime();a=r-i;if(a>=t){i=r;e(this).trigger("throttledresize")}else{if(o){clearTimeout(o)}o=setTimeout(n,t-a)}},i=0,o,r,a})(jQuery);(function(e,n){var i=e(n),o="orientationchange",r,a,s,u,l,c={0:true,180:true};if(e.support.orientation){var f=n.innerWidth||i.width(),d=n.innerHeight||i.height(),h=50;u=f>d&&f-d>h;l=c[n.orientation];if(u&&l||!u&&!l){c={"-90":true,90:true}}}e.event.special.orientationchange=e.extend({},e.event.special.orientationchange,{setup:function(){if(e.support.orientation&&!e.event.special.orientationchange.disabled){return false}s=a();i.on("throttledresize",p)},teardown:function(){if(e.support.orientation&&!e.event.special.orientationchange.disabled){return false}i.off("throttledresize",p)},add:function(e){var t=e.handler;e.handler=function(e){e.orientation=a();return t.apply(this,arguments)}}});function p(){var e=a();if(e!==s){s=e;i.trigger(o)}}e.event.special.orientationchange.orientation=a=function(){var i=true,o=t.documentElement;if(e.support.orientation){i=c[n.orientation]}else{i=o&&o.clientWidth/o.clientHeight<1.1}return i?"portrait":"landscape"};e.fn[o]=function(e){return e?this.on(o,e):this.trigger(o)};if(e.attrFn){e.attrFn[o]=true}})(jQuery,this);(function(e,t,n,i){var o="virtualMouseBindings",r="virtualTouchID",a="vmouseover vmousedown vmousemove vmouseup vclick vmouseout vmousecancel".split(" "),s="clientX clientY pageX pageY screenX screenY".split(" "),u=e.event.mouseHooks?e.event.mouseHooks.props:[],l=("altKey bubbles cancelable ctrlKey currentTarget detail eventPhase "+"metaKey relatedTarget shiftKey target timeStamp view which").split(" "),c=l.concat(u),f={},d=0,h=0,p=0,v=false,m=[],g=false,b=false,E="addEventListener"in n,w=e(n),D=1,T=0,y;e.vmouse={moveDistanceThreshold:10,clickDistanceThreshold:10,resetTimerDuration:1500};function x(e){while(e&&typeof e.originalEvent!=="undefined"){e=e.originalEvent}return e}function M(t,n){var o=t.type,r,a,u,f,d,h,p,v,m;t=e.Event(t);t.type=n;r=t.originalEvent;a=l;if(o.search(/^(mouse|click)/)>-1){a=c}if(r){for(p=a.length,f;p;){f=a[--p];t[f]=r[f]}}if(o.search(/mouse(down|up)|click/)>-1&&!t.which){t.which=1}if(o.search(/^touch/)!==-1){u=x(r);o=u.touches;d=u.changedTouches;h=o&&o.length?o[0]:d&&d.length?d[0]:i;if(h){for(v=0,m=s.length;v<m;v++){f=s[v];t[f]=h[f]}}}return t}function S(t){var n={},i,r;while(t){i=e.data(t,o);for(r in i){if(i[r]){n[r]=n.hasVirtualBinding=true}}t=t.parentNode}return n}function P(t,n){var i;while(t){i=e.data(t,o);if(i&&(!n||i[n])){return t}t=t.parentNode}return null}function C(){b=false}function N(){b=true}function A(){T=0;m.length=0;g=false;N()}function k(){C()}function O(){_();d=setTimeout(function(){d=0;A()},e.vmouse.resetTimerDuration)}function _(){if(d){clearTimeout(d);d=0}}function j(t,n,i){var o;if(i&&i[t]||!i&&P(n.target,t)){o=M(n,t);e(n.target).trigger(o)}return o}function L(t){var n=e.data(t.target,r);if(!g&&(!T||T!==n)){var i=j("v"+t.type,t);if(i){if(i.isDefaultPrevented()){t.preventDefault()}if(i.isPropagationStopped()){t.stopPropagation()}if(i.isImmediatePropagationStopped()){t.stopImmediatePropagation()}}}}function I(t){var n=x(t).touches,i,o;if(n&&n.length===1){i=t.target;o=S(i);if(o.hasVirtualBinding){T=D++;e.data(i,r,T);_();k();v=false;var a=x(t).touches[0];h=a.pageX;p=a.pageY;j("vmouseover",t,o);j("vmousedown",t,o)}}}function z(e){if(b){return}if(!v){j("vmousecancel",e,S(e.target))}v=true;O()}function q(t){if(b){return}var n=x(t).touches[0],i=v,o=e.vmouse.moveDistanceThreshold,r=S(t.target);v=v||(Math.abs(n.pageX-h)>o||Math.abs(n.pageY-p)>o);if(v&&!i){j("vmousecancel",t,r)}j("vmousemove",t,r);O()}function H(n){if(b){return}N();var i=S(n.target),o;j("vmouseup",n,i);if(!v){j("vclick",n,i);if(e.support.touch){o=x(n).changedTouches[0];m.push({touchID:T,x:o.clientX,y:o.clientY+t.scrollY,target:n.target});g=true}}j("vmouseout",n,i);v=false;O()}function W(t){var n=e.data(t,o),i;if(n){for(i in n){if(n[i]){return true}}}return false}function B(){}function R(t){var n=t.substr(1);return{setup:function(i,r){if(!W(this)){e.data(this,o,{})}var a=e.data(this,o);a[t]=true;f[t]=(f[t]||0)+1;if(f[t]===1){w.on(n,L)}e(this).on(n,B);if(E){f["touchstart"]=(f["touchstart"]||0)+1;if(f["touchstart"]===1){w.on("touchstart",I).on("touchend",H).on("touchmove",q)}}},teardown:function(i,r){--f[t];if(!f[t]){w.off(n,L)}if(E){--f["touchstart"];if(!f["touchstart"]){w.off("touchstart",I).off("touchmove",q).off("touchend",H).off("scroll",z)}}var a=e(this),s=e.data(this,o);if(s){s[t]=false}a.off(n,B);if(!W(this)){a.removeData(o)}}}}for(var U=0;U<a.length;U++){e.event.special[a[U]]=R(a[U])}if(E){function Y(n){var i=m.length,o=n.target,a,s,u,l,c,f;if(i){a=n.clientX;s=n.clientY+t.scrollY;y=e.vmouse.clickDistanceThreshold;u=o;while(u){for(l=0;l<i;l++){c=m[l];f=0;if(u===o&&Math.abs(c.x-a)<y&&Math.abs(c.y-s)<y||e.data(u,r)===c.touchID){if(!n.isSynthetic){n._sapui_delayedMouseEvent=true}if(o!==c.target){n.preventDefault();n.stopPropagation()}if(n.type==="click"){m.length=0}return}}u=u.parentNode}}}n.addEventListener("mousedown",Y,true);n.addEventListener("mouseup",Y,true);n.addEventListener("mouseover",Y,true);n.addEventListener("click",Y,true)}})(jQuery,e,t);(function(e,n,i){var o=e(t);e.each(("touchstart touchmove touchend "+"tap taphold "+"swipe swipeleft swiperight "+"scrollstart scrollstop").split(" "),function(t,n){e.fn[n]=function(e){return e?this.on(n,e):this.trigger(n)};if(e.attrFn){e.attrFn[n]=true}});var r=e.mobile.support.touch,a="touchmove scroll",s=r?"touchstart":"mousedown",u=r?"touchend touchcancel":"mouseup dragstart",l=r?"touchmove":"mousemove";function c(t,n,i){var o=i.type;i.type=n;e.event.dispatch.call(t,i);i.type=o}e.event.special.scrollstart={enabled:true,setup:function(){var t=this,n=e(t),i,o;function r(e,n){i=n;c(t,i?"scrollstart":"scrollstop",e)}n.on(a,function(t){if(!e.event.special.scrollstart.enabled){return}if(!i){r(t,true)}clearTimeout(o);o=setTimeout(function(){r(t,false)},50)})}};e.event.special.tap={tapholdThreshold:750,setup:function(){var t=this,n=e(t),i,r,a;function s(e){var t=e.target;var n=sap.ui.Device.browser;return n.edge&&n.version>=14&&(t.tagName.toLowerCase()==="button"&&t.contains(i)||i.tagName.toLowerCase()==="button"&&i.contains(t))}function u(){clearTimeout(a)}function l(){u();n.removeData("__tap_event_in_progress");n.off("vclick",d).off("vmouseup",u);o.off("vmousecancel",l).off("dragstart",l).off("vmouseup",f)}function f(t){if(t.target!==i&&!e.contains(i,t.target)&&!s(t)){l()}}function d(e){l();if(i===e.target||s(e)){c(t,"tap",e)}}n.on("vmousedown",function(s){if(s.which&&s.which!==1){return}i=s.target;r=s.originalEvent;if(n.data("__tap_event_in_progress")){l()}n.data("__tap_event_in_progress","X");n.on("vmouseup",u).on("vclick",d);o.on("vmousecancel",l).on("dragstart",l).on("vmouseup",f);a=setTimeout(function(){var n=e.event.fix(r);n.type="taphold";c(t,"taphold",n)},e.event.special.tap.tapholdThreshold)})}};e.event.special.swipe={scrollSupressionThreshold:30,durationThreshold:1e3,horizontalDistanceThreshold:30,verticalDistanceThreshold:75,start:function(t){var n=t.originalEvent&&t.originalEvent.touches?t.originalEvent.touches[0]:t;return{time:(new Date).getTime(),coords:[n.pageX,n.pageY],origin:e(t.target)}},stop:function(e){var t=e.originalEvent&&e.originalEvent.touches?e.originalEvent.touches[0]:e;return{time:(new Date).getTime(),coords:[t.pageX,t.pageY]}},handleSwipe:function(t,n){if(n.time-t.time<e.event.special.swipe.durationThreshold&&Math.abs(t.coords[0]-n.coords[0])>e.event.special.swipe.horizontalDistanceThreshold&&Math.abs(t.coords[1]-n.coords[1])<e.event.special.swipe.verticalDistanceThreshold){t.origin.trigger("swipe").trigger(t.coords[0]>n.coords[0]?"swipeleft":"swiperight")}},setup:function(){var t=this,o=e(t);o.on(s,function(t){if(t.isMarked("swipestartHandled")){return}t.setMarked("swipestartHandled");var r=e.event.special.swipe.start(t),a;function s(t){if(!r){return}a=e.event.special.swipe.stop(t);if(t.cancelable&&!n.getSelection().toString()&&Math.abs(r.coords[0]-a.coords[0])>e.event.special.swipe.scrollSupressionThreshold){t.preventDefault()}}function c(t){o.off(l,s).off(u,c);if(r&&a){e.event.special.swipe.handleSwipe(r,a)}r=a=i}o.on(l,s).on(u,c)})}};e.each({scrollstop:"scrollstart",taphold:"tap",swipeleft:"swipe",swiperight:"swipe"},function(t,n){e.event.special[t]={setup:function(){e(this).on(n,e.noop)}}})})(jQuery,this)});
},
	"sap/ui/thirdparty/jquery.js":function(){
/*!
 * jQuery JavaScript Library v3.6.0
 * https://jquery.com/
 *
 * Includes Sizzle.js
 * https://sizzlejs.com/
 *
 * Copyright OpenJS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 *
 * Date: 2021-03-02T17:08Z
 */
(function(e,t){"use strict";if(typeof module==="object"&&typeof module.exports==="object"){module.exports=e.document?t(e,true):function(e){if(!e.document){throw new Error("jQuery requires a window with a document")}return t(e)}}else{t(e)}})(typeof window!=="undefined"?window:this,function(e,t){"use strict";var n=[];var r=Object.getPrototypeOf;var i=n.slice;var o=n.flat?function(e){return n.flat.call(e)}:function(e){return n.concat.apply([],e)};var a=n.push;var s=n.indexOf;var u={};var f=u.toString;var l=u.hasOwnProperty;var c=l.toString;var d=c.call(Object);var p={};var h=function e(t){return typeof t==="function"&&typeof t.nodeType!=="number"&&typeof t.item!=="function"};var g=function e(t){return t!=null&&t===t.window};var y=e.document;var m={type:true,src:true,nonce:true,noModule:true};function v(e,t,n){n=n||y;var r,i,o=n.createElement("script");o.text=e;if(t){for(r in m){i=t[r]||t.getAttribute&&t.getAttribute(r);if(i){o.setAttribute(r,i)}}}n.head.appendChild(o).parentNode.removeChild(o)}function x(e){if(e==null){return e+""}return typeof e==="object"||typeof e==="function"?u[f.call(e)]||"object":typeof e}var b="3.6.0",jQuery=function(e,t){return new jQuery.fn.init(e,t)};jQuery.fn=jQuery.prototype={jquery:b,constructor:jQuery,length:0,toArray:function(){return i.call(this)},get:function(e){if(e==null){return i.call(this)}return e<0?this[e+this.length]:this[e]},pushStack:function(e){var t=jQuery.merge(this.constructor(),e);t.prevObject=this;return t},each:function(e){return jQuery.each(this,e)},map:function(e){return this.pushStack(jQuery.map(this,function(t,n){return e.call(t,n,t)}))},slice:function(){return this.pushStack(i.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},even:function(){return this.pushStack(jQuery.grep(this,function(e,t){return(t+1)%2}))},odd:function(){return this.pushStack(jQuery.grep(this,function(e,t){return t%2}))},eq:function(e){var t=this.length,n=+e+(e<0?t:0);return this.pushStack(n>=0&&n<t?[this[n]]:[])},end:function(){return this.prevObject||this.constructor()},push:a,sort:n.sort,splice:n.splice};jQuery.extend=jQuery.fn.extend=function(){var e,t,n,r,i,o,a=arguments[0]||{},s=1,u=arguments.length,f=false;if(typeof a==="boolean"){f=a;a=arguments[s]||{};s++}if(typeof a!=="object"&&!h(a)){a={}}if(s===u){a=this;s--}for(;s<u;s++){if((e=arguments[s])!=null){for(t in e){r=e[t];if(t==="__proto__"||a===r){continue}if(f&&r&&(jQuery.isPlainObject(r)||(i=Array.isArray(r)))){n=a[t];if(i&&!Array.isArray(n)){o=[]}else if(!i&&!jQuery.isPlainObject(n)){o={}}else{o=n}i=false;a[t]=jQuery.extend(f,o,r)}else if(r!==undefined){a[t]=r}}}}return a};jQuery.extend({expando:"jQuery"+(b+Math.random()).replace(/\D/g,""),isReady:true,error:function(e){throw new Error(e)},noop:function(){},isPlainObject:function(e){var t,n;if(!e||f.call(e)!=="[object Object]"){return false}t=r(e);if(!t){return true}n=l.call(t,"constructor")&&t.constructor;return typeof n==="function"&&c.call(n)===d},isEmptyObject:function(e){var t;for(t in e){return false}return true},globalEval:function(e,t,n){v(e,{nonce:t&&t.nonce},n)},each:function(e,t){var n,r=0;if(w(e)){n=e.length;for(;r<n;r++){if(t.call(e[r],r,e[r])===false){break}}}else{for(r in e){if(t.call(e[r],r,e[r])===false){break}}}return e},makeArray:function(e,t){var n=t||[];if(e!=null){if(w(Object(e))){jQuery.merge(n,typeof e==="string"?[e]:e)}else{a.call(n,e)}}return n},inArray:function(e,t,n){return t==null?-1:s.call(t,e,n)},merge:function(e,t){var n=+t.length,r=0,i=e.length;for(;r<n;r++){e[i++]=t[r]}e.length=i;return e},grep:function(e,t,n){var r,i=[],o=0,a=e.length,s=!n;for(;o<a;o++){r=!t(e[o],o);if(r!==s){i.push(e[o])}}return i},map:function(e,t,n){var r,i,a=0,s=[];if(w(e)){r=e.length;for(;a<r;a++){i=t(e[a],a,n);if(i!=null){s.push(i)}}}else{for(a in e){i=t(e[a],a,n);if(i!=null){s.push(i)}}}return o(s)},guid:1,support:p});if(typeof Symbol==="function"){jQuery.fn[Symbol.iterator]=n[Symbol.iterator]}jQuery.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "),function(e,t){u["[object "+t+"]"]=t.toLowerCase()});function w(e){var t=!!e&&"length"in e&&e.length,n=x(e);if(h(e)||g(e)){return false}return n==="array"||t===0||typeof t==="number"&&t>0&&t-1 in e}var T=
/*!
 * Sizzle CSS Selector Engine v2.3.6
 * https://sizzlejs.com/
 *
 * Copyright JS Foundation and other contributors
 * Released under the MIT license
 * https://js.foundation/
 *
 * Date: 2021-02-16
 */
function(e){var t,n,r,i,o,a,s,u,f,l,c,d,p,h,g,y,m,v,x,b="sizzle"+1*new Date,w=e.document,T=0,C=0,k=ue(),E=ue(),S=ue(),A=ue(),j=function(e,t){if(e===t){c=true}return 0},N={}.hasOwnProperty,D=[],q=D.pop,L=D.push,H=D.push,O=D.slice,P=function(e,t){var n=0,r=e.length;for(;n<r;n++){if(e[n]===t){return n}}return-1},R="checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|"+"ismap|loop|multiple|open|readonly|required|scoped",M="[\\x20\\t\\r\\n\\f]",I="(?:\\\\[\\da-fA-F]{1,6}"+M+"?|\\\\[^\\r\\n\\f]|[\\w-]|[^\0-\\x7f])+",W="\\["+M+"*("+I+")(?:"+M+"*([*^$|!~]?=)"+M+"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|("+I+"))|)"+M+"*\\]",F=":("+I+")(?:\\(("+"('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|"+"((?:\\\\.|[^\\\\()[\\]]|"+W+")*)|"+".*"+")\\)|)",B=new RegExp(M+"+","g"),_=new RegExp("^"+M+"+|((?:^|[^\\\\])(?:\\\\.)*)"+M+"+$","g"),$=new RegExp("^"+M+"*,"+M+"*"),z=new RegExp("^"+M+"*([>+~]|"+M+")"+M+"*"),X=new RegExp(M+"|>"),U=new RegExp(F),Q=new RegExp("^"+I+"$"),V={ID:new RegExp("^#("+I+")"),CLASS:new RegExp("^\\.("+I+")"),TAG:new RegExp("^("+I+"|[*])"),ATTR:new RegExp("^"+W),PSEUDO:new RegExp("^"+F),CHILD:new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\("+M+"*(even|odd|(([+-]|)(\\d*)n|)"+M+"*(?:([+-]|)"+M+"*(\\d+)|))"+M+"*\\)|)","i"),bool:new RegExp("^(?:"+R+")$","i"),needsContext:new RegExp("^"+M+"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\("+M+"*((?:-\\d)?\\d*)"+M+"*\\)|)(?=[^-]|$)","i")},G=/HTML$/i,Y=/^(?:input|select|textarea|button)$/i,J=/^h\d$/i,K=/^[^{]+\{\s*\[native \w/,Z=/^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,ee=/[+~]/,te=new RegExp("\\\\[\\da-fA-F]{1,6}"+M+"?|\\\\([^\\r\\n\\f])","g"),ne=function(e,t){var n="0x"+e.slice(1)-65536;return t?t:n<0?String.fromCharCode(n+65536):String.fromCharCode(n>>10|55296,n&1023|56320)},re=/([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,ie=function(e,t){if(t){if(e==="\0"){return"�"}return e.slice(0,-1)+"\\"+e.charCodeAt(e.length-1).toString(16)+" "}return"\\"+e},oe=function(){d()},ae=be(function(e){return e.disabled===true&&e.nodeName.toLowerCase()==="fieldset"},{dir:"parentNode",next:"legend"});try{H.apply(D=O.call(w.childNodes),w.childNodes);D[w.childNodes.length].nodeType}catch(e){H={apply:D.length?function(e,t){L.apply(e,O.call(t))}:function(e,t){var n=e.length,r=0;while(e[n++]=t[r++]){}e.length=n-1}}}function se(e,t,r,i){var o,s,f,l,c,h,m,v=t&&t.ownerDocument,w=t?t.nodeType:9;r=r||[];if(typeof e!=="string"||!e||w!==1&&w!==9&&w!==11){return r}if(!i){d(t);t=t||p;if(g){if(w!==11&&(c=Z.exec(e))){if(o=c[1]){if(w===9){if(f=t.getElementById(o)){if(f.id===o){r.push(f);return r}}else{return r}}else{if(v&&(f=v.getElementById(o))&&x(t,f)&&f.id===o){r.push(f);return r}}}else if(c[2]){H.apply(r,t.getElementsByTagName(e));return r}else if((o=c[3])&&n.getElementsByClassName&&t.getElementsByClassName){H.apply(r,t.getElementsByClassName(o));return r}}if(n.qsa&&!A[e+" "]&&(!y||!y.test(e))&&(w!==1||t.nodeName.toLowerCase()!=="object")){m=e;v=t;if(w===1&&(X.test(e)||z.test(e))){v=ee.test(e)&&me(t.parentNode)||t;if(v!==t||!n.scope){if(l=t.getAttribute("id")){l=l.replace(re,ie)}else{t.setAttribute("id",l=b)}}h=a(e);s=h.length;while(s--){h[s]=(l?"#"+l:":scope")+" "+xe(h[s])}m=h.join(",")}try{H.apply(r,v.querySelectorAll(m));return r}catch(t){A(e,true)}finally{if(l===b){t.removeAttribute("id")}}}}}return u(e.replace(_,"$1"),t,r,i)}function ue(){var e=[];function t(n,i){if(e.push(n+" ")>r.cacheLength){delete t[e.shift()]}return t[n+" "]=i}return t}function fe(e){e[b]=true;return e}function le(e){var t=p.createElement("fieldset");try{return!!e(t)}catch(e){return false}finally{if(t.parentNode){t.parentNode.removeChild(t)}t=null}}function ce(e,t){var n=e.split("|"),i=n.length;while(i--){r.attrHandle[n[i]]=t}}function de(e,t){var n=t&&e,r=n&&e.nodeType===1&&t.nodeType===1&&e.sourceIndex-t.sourceIndex;if(r){return r}if(n){while(n=n.nextSibling){if(n===t){return-1}}}return e?1:-1}function pe(e){return function(t){var n=t.nodeName.toLowerCase();return n==="input"&&t.type===e}}function he(e){return function(t){var n=t.nodeName.toLowerCase();return(n==="input"||n==="button")&&t.type===e}}function ge(e){return function(t){if("form"in t){if(t.parentNode&&t.disabled===false){if("label"in t){if("label"in t.parentNode){return t.parentNode.disabled===e}else{return t.disabled===e}}return t.isDisabled===e||t.isDisabled!==!e&&ae(t)===e}return t.disabled===e}else if("label"in t){return t.disabled===e}return false}}function ye(e){return fe(function(t){t=+t;return fe(function(n,r){var i,o=e([],n.length,t),a=o.length;while(a--){if(n[i=o[a]]){n[i]=!(r[i]=n[i])}}})})}function me(e){return e&&typeof e.getElementsByTagName!=="undefined"&&e}n=se.support={};o=se.isXML=function(e){var t=e&&e.namespaceURI,n=e&&(e.ownerDocument||e).documentElement;return!G.test(t||n&&n.nodeName||"HTML")};d=se.setDocument=function(e){var t,i,a=e?e.ownerDocument||e:w;if(a==p||a.nodeType!==9||!a.documentElement){return p}p=a;h=p.documentElement;g=!o(p);if(w!=p&&(i=p.defaultView)&&i.top!==i){if(i.addEventListener){i.addEventListener("unload",oe,false)}else if(i.attachEvent){i.attachEvent("onunload",oe)}}n.scope=le(function(e){h.appendChild(e).appendChild(p.createElement("div"));return typeof e.querySelectorAll!=="undefined"&&!e.querySelectorAll(":scope fieldset div").length});n.attributes=le(function(e){e.className="i";return!e.getAttribute("className")});n.getElementsByTagName=le(function(e){e.appendChild(p.createComment(""));return!e.getElementsByTagName("*").length});n.getElementsByClassName=K.test(p.getElementsByClassName);n.getById=le(function(e){h.appendChild(e).id=b;return!p.getElementsByName||!p.getElementsByName(b).length});if(n.getById){r.filter["ID"]=function(e){var t=e.replace(te,ne);return function(e){return e.getAttribute("id")===t}};r.find["ID"]=function(e,t){if(typeof t.getElementById!=="undefined"&&g){var n=t.getElementById(e);return n?[n]:[]}}}else{r.filter["ID"]=function(e){var t=e.replace(te,ne);return function(e){var n=typeof e.getAttributeNode!=="undefined"&&e.getAttributeNode("id");return n&&n.value===t}};r.find["ID"]=function(e,t){if(typeof t.getElementById!=="undefined"&&g){var n,r,i,o=t.getElementById(e);if(o){n=o.getAttributeNode("id");if(n&&n.value===e){return[o]}i=t.getElementsByName(e);r=0;while(o=i[r++]){n=o.getAttributeNode("id");if(n&&n.value===e){return[o]}}}return[]}}}r.find["TAG"]=n.getElementsByTagName?function(e,t){if(typeof t.getElementsByTagName!=="undefined"){return t.getElementsByTagName(e)}else if(n.qsa){return t.querySelectorAll(e)}}:function(e,t){var n,r=[],i=0,o=t.getElementsByTagName(e);if(e==="*"){while(n=o[i++]){if(n.nodeType===1){r.push(n)}}return r}return o};r.find["CLASS"]=n.getElementsByClassName&&function(e,t){if(typeof t.getElementsByClassName!=="undefined"&&g){return t.getElementsByClassName(e)}};m=[];y=[];if(n.qsa=K.test(p.querySelectorAll)){le(function(e){var t;h.appendChild(e).innerHTML="<a id='"+b+"'></a>"+"<select id='"+b+"-\r\\' msallowcapture=''>"+"<option selected=''></option></select>";if(e.querySelectorAll("[msallowcapture^='']").length){y.push("[*^$]="+M+"*(?:''|\"\")")}if(!e.querySelectorAll("[selected]").length){y.push("\\["+M+"*(?:value|"+R+")")}if(!e.querySelectorAll("[id~="+b+"-]").length){y.push("~=")}t=p.createElement("input");t.setAttribute("name","");e.appendChild(t);if(!e.querySelectorAll("[name='']").length){y.push("\\["+M+"*name"+M+"*="+M+"*(?:''|\"\")")}if(!e.querySelectorAll(":checked").length){y.push(":checked")}if(!e.querySelectorAll("a#"+b+"+*").length){y.push(".#.+[+~]")}e.querySelectorAll("\\\f");y.push("[\\r\\n\\f]")});le(function(e){e.innerHTML="<a href='' disabled='disabled'></a>"+"<select disabled='disabled'><option/></select>";var t=p.createElement("input");t.setAttribute("type","hidden");e.appendChild(t).setAttribute("name","D");if(e.querySelectorAll("[name=d]").length){y.push("name"+M+"*[*^$|!~]?=")}if(e.querySelectorAll(":enabled").length!==2){y.push(":enabled",":disabled")}h.appendChild(e).disabled=true;if(e.querySelectorAll(":disabled").length!==2){y.push(":enabled",":disabled")}e.querySelectorAll("*,:x");y.push(",.*:")})}if(n.matchesSelector=K.test(v=h.matches||h.webkitMatchesSelector||h.mozMatchesSelector||h.oMatchesSelector||h.msMatchesSelector)){le(function(e){n.disconnectedMatch=v.call(e,"*");v.call(e,"[s!='']:x");m.push("!=",F)})}y=y.length&&new RegExp(y.join("|"));m=m.length&&new RegExp(m.join("|"));t=K.test(h.compareDocumentPosition);x=t||K.test(h.contains)?function(e,t){var n=e.nodeType===9?e.documentElement:e,r=t&&t.parentNode;return e===r||!!(r&&r.nodeType===1&&(n.contains?n.contains(r):e.compareDocumentPosition&&e.compareDocumentPosition(r)&16))}:function(e,t){if(t){while(t=t.parentNode){if(t===e){return true}}}return false};j=t?function(e,t){if(e===t){c=true;return 0}var r=!e.compareDocumentPosition-!t.compareDocumentPosition;if(r){return r}r=(e.ownerDocument||e)==(t.ownerDocument||t)?e.compareDocumentPosition(t):1;if(r&1||!n.sortDetached&&t.compareDocumentPosition(e)===r){if(e==p||e.ownerDocument==w&&x(w,e)){return-1}if(t==p||t.ownerDocument==w&&x(w,t)){return 1}return l?P(l,e)-P(l,t):0}return r&4?-1:1}:function(e,t){if(e===t){c=true;return 0}var n,r=0,i=e.parentNode,o=t.parentNode,a=[e],s=[t];if(!i||!o){return e==p?-1:t==p?1:i?-1:o?1:l?P(l,e)-P(l,t):0}else if(i===o){return de(e,t)}n=e;while(n=n.parentNode){a.unshift(n)}n=t;while(n=n.parentNode){s.unshift(n)}while(a[r]===s[r]){r++}return r?de(a[r],s[r]):a[r]==w?-1:s[r]==w?1:0};return p};se.matches=function(e,t){return se(e,null,null,t)};se.matchesSelector=function(e,t){d(e);if(n.matchesSelector&&g&&!A[t+" "]&&(!m||!m.test(t))&&(!y||!y.test(t))){try{var r=v.call(e,t);if(r||n.disconnectedMatch||e.document&&e.document.nodeType!==11){return r}}catch(e){A(t,true)}}return se(t,p,null,[e]).length>0};se.contains=function(e,t){if((e.ownerDocument||e)!=p){d(e)}return x(e,t)};se.attr=function(e,t){if((e.ownerDocument||e)!=p){d(e)}var i=r.attrHandle[t.toLowerCase()],o=i&&N.call(r.attrHandle,t.toLowerCase())?i(e,t,!g):undefined;return o!==undefined?o:n.attributes||!g?e.getAttribute(t):(o=e.getAttributeNode(t))&&o.specified?o.value:null};se.escape=function(e){return(e+"").replace(re,ie)};se.error=function(e){throw new Error("Syntax error, unrecognized expression: "+e)};se.uniqueSort=function(e){var t,r=[],i=0,o=0;c=!n.detectDuplicates;l=!n.sortStable&&e.slice(0);e.sort(j);if(c){while(t=e[o++]){if(t===e[o]){i=r.push(o)}}while(i--){e.splice(r[i],1)}}l=null;return e};i=se.getText=function(e){var t,n="",r=0,o=e.nodeType;if(!o){while(t=e[r++]){n+=i(t)}}else if(o===1||o===9||o===11){if(typeof e.textContent==="string"){return e.textContent}else{for(e=e.firstChild;e;e=e.nextSibling){n+=i(e)}}}else if(o===3||o===4){return e.nodeValue}return n};r=se.selectors={cacheLength:50,createPseudo:fe,match:V,attrHandle:{},find:{},relative:{">":{dir:"parentNode",first:true}," ":{dir:"parentNode"},"+":{dir:"previousSibling",first:true},"~":{dir:"previousSibling"}},preFilter:{ATTR:function(e){e[1]=e[1].replace(te,ne);e[3]=(e[3]||e[4]||e[5]||"").replace(te,ne);if(e[2]==="~="){e[3]=" "+e[3]+" "}return e.slice(0,4)},CHILD:function(e){e[1]=e[1].toLowerCase();if(e[1].slice(0,3)==="nth"){if(!e[3]){se.error(e[0])}e[4]=+(e[4]?e[5]+(e[6]||1):2*(e[3]==="even"||e[3]==="odd"));e[5]=+(e[7]+e[8]||e[3]==="odd")}else if(e[3]){se.error(e[0])}return e},PSEUDO:function(e){var t,n=!e[6]&&e[2];if(V["CHILD"].test(e[0])){return null}if(e[3]){e[2]=e[4]||e[5]||""}else if(n&&U.test(n)&&(t=a(n,true))&&(t=n.indexOf(")",n.length-t)-n.length)){e[0]=e[0].slice(0,t);e[2]=n.slice(0,t)}return e.slice(0,3)}},filter:{TAG:function(e){var t=e.replace(te,ne).toLowerCase();return e==="*"?function(){return true}:function(e){return e.nodeName&&e.nodeName.toLowerCase()===t}},CLASS:function(e){var t=k[e+" "];return t||(t=new RegExp("(^|"+M+")"+e+"("+M+"|$)"))&&k(e,function(e){return t.test(typeof e.className==="string"&&e.className||typeof e.getAttribute!=="undefined"&&e.getAttribute("class")||"")})},ATTR:function(e,t,n){return function(r){var i=se.attr(r,e);if(i==null){return t==="!="}if(!t){return true}i+="";return t==="="?i===n:t==="!="?i!==n:t==="^="?n&&i.indexOf(n)===0:t==="*="?n&&i.indexOf(n)>-1:t==="$="?n&&i.slice(-n.length)===n:t==="~="?(" "+i.replace(B," ")+" ").indexOf(n)>-1:t==="|="?i===n||i.slice(0,n.length+1)===n+"-":false}},CHILD:function(e,t,n,r,i){var o=e.slice(0,3)!=="nth",a=e.slice(-4)!=="last",s=t==="of-type";return r===1&&i===0?function(e){return!!e.parentNode}:function(t,n,u){var f,l,c,d,p,h,g=o!==a?"nextSibling":"previousSibling",y=t.parentNode,m=s&&t.nodeName.toLowerCase(),v=!u&&!s,x=false;if(y){if(o){while(g){d=t;while(d=d[g]){if(s?d.nodeName.toLowerCase()===m:d.nodeType===1){return false}}h=g=e==="only"&&!h&&"nextSibling"}return true}h=[a?y.firstChild:y.lastChild];if(a&&v){d=y;c=d[b]||(d[b]={});l=c[d.uniqueID]||(c[d.uniqueID]={});f=l[e]||[];p=f[0]===T&&f[1];x=p&&f[2];d=p&&y.childNodes[p];while(d=++p&&d&&d[g]||(x=p=0)||h.pop()){if(d.nodeType===1&&++x&&d===t){l[e]=[T,p,x];break}}}else{if(v){d=t;c=d[b]||(d[b]={});l=c[d.uniqueID]||(c[d.uniqueID]={});f=l[e]||[];p=f[0]===T&&f[1];x=p}if(x===false){while(d=++p&&d&&d[g]||(x=p=0)||h.pop()){if((s?d.nodeName.toLowerCase()===m:d.nodeType===1)&&++x){if(v){c=d[b]||(d[b]={});l=c[d.uniqueID]||(c[d.uniqueID]={});l[e]=[T,x]}if(d===t){break}}}}}x-=i;return x===r||x%r===0&&x/r>=0}}},PSEUDO:function(e,t){var n,i=r.pseudos[e]||r.setFilters[e.toLowerCase()]||se.error("unsupported pseudo: "+e);if(i[b]){return i(t)}if(i.length>1){n=[e,e,"",t];return r.setFilters.hasOwnProperty(e.toLowerCase())?fe(function(e,n){var r,o=i(e,t),a=o.length;while(a--){r=P(e,o[a]);e[r]=!(n[r]=o[a])}}):function(e){return i(e,0,n)}}return i}},pseudos:{not:fe(function(e){var t=[],n=[],r=s(e.replace(_,"$1"));return r[b]?fe(function(e,t,n,i){var o,a=r(e,null,i,[]),s=e.length;while(s--){if(o=a[s]){e[s]=!(t[s]=o)}}}):function(e,i,o){t[0]=e;r(t,null,o,n);t[0]=null;return!n.pop()}}),has:fe(function(e){return function(t){return se(e,t).length>0}}),contains:fe(function(e){e=e.replace(te,ne);return function(t){return(t.textContent||i(t)).indexOf(e)>-1}}),lang:fe(function(e){if(!Q.test(e||"")){se.error("unsupported lang: "+e)}e=e.replace(te,ne).toLowerCase();return function(t){var n;do{if(n=g?t.lang:t.getAttribute("xml:lang")||t.getAttribute("lang")){n=n.toLowerCase();return n===e||n.indexOf(e+"-")===0}}while((t=t.parentNode)&&t.nodeType===1);return false}}),target:function(t){var n=e.location&&e.location.hash;return n&&n.slice(1)===t.id},root:function(e){return e===h},focus:function(e){return e===p.activeElement&&(!p.hasFocus||p.hasFocus())&&!!(e.type||e.href||~e.tabIndex)},enabled:ge(false),disabled:ge(true),checked:function(e){var t=e.nodeName.toLowerCase();return t==="input"&&!!e.checked||t==="option"&&!!e.selected},selected:function(e){if(e.parentNode){e.parentNode.selectedIndex}return e.selected===true},empty:function(e){for(e=e.firstChild;e;e=e.nextSibling){if(e.nodeType<6){return false}}return true},parent:function(e){return!r.pseudos["empty"](e)},header:function(e){return J.test(e.nodeName)},input:function(e){return Y.test(e.nodeName)},button:function(e){var t=e.nodeName.toLowerCase();return t==="input"&&e.type==="button"||t==="button"},text:function(e){var t;return e.nodeName.toLowerCase()==="input"&&e.type==="text"&&((t=e.getAttribute("type"))==null||t.toLowerCase()==="text")},first:ye(function(){return[0]}),last:ye(function(e,t){return[t-1]}),eq:ye(function(e,t,n){return[n<0?n+t:n]}),even:ye(function(e,t){var n=0;for(;n<t;n+=2){e.push(n)}return e}),odd:ye(function(e,t){var n=1;for(;n<t;n+=2){e.push(n)}return e}),lt:ye(function(e,t,n){var r=n<0?n+t:n>t?t:n;for(;--r>=0;){e.push(r)}return e}),gt:ye(function(e,t,n){var r=n<0?n+t:n;for(;++r<t;){e.push(r)}return e})}};r.pseudos["nth"]=r.pseudos["eq"];for(t in{radio:true,checkbox:true,file:true,password:true,image:true}){r.pseudos[t]=pe(t)}for(t in{submit:true,reset:true}){r.pseudos[t]=he(t)}function ve(){}ve.prototype=r.filters=r.pseudos;r.setFilters=new ve;a=se.tokenize=function(e,t){var n,i,o,a,s,u,f,l=E[e+" "];if(l){return t?0:l.slice(0)}s=e;u=[];f=r.preFilter;while(s){if(!n||(i=$.exec(s))){if(i){s=s.slice(i[0].length)||s}u.push(o=[])}n=false;if(i=z.exec(s)){n=i.shift();o.push({value:n,type:i[0].replace(_," ")});s=s.slice(n.length)}for(a in r.filter){if((i=V[a].exec(s))&&(!f[a]||(i=f[a](i)))){n=i.shift();o.push({value:n,type:a,matches:i});s=s.slice(n.length)}}if(!n){break}}return t?s.length:s?se.error(e):E(e,u).slice(0)};function xe(e){var t=0,n=e.length,r="";for(;t<n;t++){r+=e[t].value}return r}function be(e,t,n){var r=t.dir,i=t.next,o=i||r,a=n&&o==="parentNode",s=C++;return t.first?function(t,n,i){while(t=t[r]){if(t.nodeType===1||a){return e(t,n,i)}}return false}:function(t,n,u){var f,l,c,d=[T,s];if(u){while(t=t[r]){if(t.nodeType===1||a){if(e(t,n,u)){return true}}}}else{while(t=t[r]){if(t.nodeType===1||a){c=t[b]||(t[b]={});l=c[t.uniqueID]||(c[t.uniqueID]={});if(i&&i===t.nodeName.toLowerCase()){t=t[r]||t}else if((f=l[o])&&f[0]===T&&f[1]===s){return d[2]=f[2]}else{l[o]=d;if(d[2]=e(t,n,u)){return true}}}}}return false}}function we(e){return e.length>1?function(t,n,r){var i=e.length;while(i--){if(!e[i](t,n,r)){return false}}return true}:e[0]}function Te(e,t,n){var r=0,i=t.length;for(;r<i;r++){se(e,t[r],n)}return n}function Ce(e,t,n,r,i){var o,a=[],s=0,u=e.length,f=t!=null;for(;s<u;s++){if(o=e[s]){if(!n||n(o,r,i)){a.push(o);if(f){t.push(s)}}}}return a}function ke(e,t,n,r,i,o){if(r&&!r[b]){r=ke(r)}if(i&&!i[b]){i=ke(i,o)}return fe(function(o,a,s,u){var f,l,c,d=[],p=[],h=a.length,g=o||Te(t||"*",s.nodeType?[s]:s,[]),y=e&&(o||!t)?Ce(g,d,e,s,u):g,m=n?i||(o?e:h||r)?[]:a:y;if(n){n(y,m,s,u)}if(r){f=Ce(m,p);r(f,[],s,u);l=f.length;while(l--){if(c=f[l]){m[p[l]]=!(y[p[l]]=c)}}}if(o){if(i||e){if(i){f=[];l=m.length;while(l--){if(c=m[l]){f.push(y[l]=c)}}i(null,m=[],f,u)}l=m.length;while(l--){if((c=m[l])&&(f=i?P(o,c):d[l])>-1){o[f]=!(a[f]=c)}}}}else{m=Ce(m===a?m.splice(h,m.length):m);if(i){i(null,a,m,u)}else{H.apply(a,m)}}})}function Ee(e){var t,n,i,o=e.length,a=r.relative[e[0].type],s=a||r.relative[" "],u=a?1:0,l=be(function(e){return e===t},s,true),c=be(function(e){return P(t,e)>-1},s,true),d=[function(e,n,r){var i=!a&&(r||n!==f)||((t=n).nodeType?l(e,n,r):c(e,n,r));t=null;return i}];for(;u<o;u++){if(n=r.relative[e[u].type]){d=[be(we(d),n)]}else{n=r.filter[e[u].type].apply(null,e[u].matches);if(n[b]){i=++u;for(;i<o;i++){if(r.relative[e[i].type]){break}}return ke(u>1&&we(d),u>1&&xe(e.slice(0,u-1).concat({value:e[u-2].type===" "?"*":""})).replace(_,"$1"),n,u<i&&Ee(e.slice(u,i)),i<o&&Ee(e=e.slice(i)),i<o&&xe(e))}d.push(n)}}return we(d)}function Se(e,t){var n=t.length>0,i=e.length>0,o=function(o,a,s,u,l){var c,h,y,m=0,v="0",x=o&&[],b=[],w=f,C=o||i&&r.find["TAG"]("*",l),k=T+=w==null?1:Math.random()||.1,E=C.length;if(l){f=a==p||a||l}for(;v!==E&&(c=C[v])!=null;v++){if(i&&c){h=0;if(!a&&c.ownerDocument!=p){d(c);s=!g}while(y=e[h++]){if(y(c,a||p,s)){u.push(c);break}}if(l){T=k}}if(n){if(c=!y&&c){m--}if(o){x.push(c)}}}m+=v;if(n&&v!==m){h=0;while(y=t[h++]){y(x,b,a,s)}if(o){if(m>0){while(v--){if(!(x[v]||b[v])){b[v]=q.call(u)}}}b=Ce(b)}H.apply(u,b);if(l&&!o&&b.length>0&&m+t.length>1){se.uniqueSort(u)}}if(l){T=k;f=w}return x};return n?fe(o):o}s=se.compile=function(e,t){var n,r=[],i=[],o=S[e+" "];if(!o){if(!t){t=a(e)}n=t.length;while(n--){o=Ee(t[n]);if(o[b]){r.push(o)}else{i.push(o)}}o=S(e,Se(i,r));o.selector=e}return o};u=se.select=function(e,t,n,i){var o,u,f,l,c,d=typeof e==="function"&&e,p=!i&&a(e=d.selector||e);n=n||[];if(p.length===1){u=p[0]=p[0].slice(0);if(u.length>2&&(f=u[0]).type==="ID"&&t.nodeType===9&&g&&r.relative[u[1].type]){t=(r.find["ID"](f.matches[0].replace(te,ne),t)||[])[0];if(!t){return n}else if(d){t=t.parentNode}e=e.slice(u.shift().value.length)}o=V["needsContext"].test(e)?0:u.length;while(o--){f=u[o];if(r.relative[l=f.type]){break}if(c=r.find[l]){if(i=c(f.matches[0].replace(te,ne),ee.test(u[0].type)&&me(t.parentNode)||t)){u.splice(o,1);e=i.length&&xe(u);if(!e){H.apply(n,i);return n}break}}}}(d||s(e,p))(i,t,!g,n,!t||ee.test(e)&&me(t.parentNode)||t);return n};n.sortStable=b.split("").sort(j).join("")===b;n.detectDuplicates=!!c;d();n.sortDetached=le(function(e){return e.compareDocumentPosition(p.createElement("fieldset"))&1});if(!le(function(e){e.innerHTML="<a href='#'></a>";return e.firstChild.getAttribute("href")==="#"})){ce("type|href|height|width",function(e,t,n){if(!n){return e.getAttribute(t,t.toLowerCase()==="type"?1:2)}})}if(!n.attributes||!le(function(e){e.innerHTML="<input/>";e.firstChild.setAttribute("value","");return e.firstChild.getAttribute("value")===""})){ce("value",function(e,t,n){if(!n&&e.nodeName.toLowerCase()==="input"){return e.defaultValue}})}if(!le(function(e){return e.getAttribute("disabled")==null})){ce(R,function(e,t,n){var r;if(!n){return e[t]===true?t.toLowerCase():(r=e.getAttributeNode(t))&&r.specified?r.value:null}})}return se}(e);jQuery.find=T;jQuery.expr=T.selectors;jQuery.expr[":"]=jQuery.expr.pseudos;jQuery.uniqueSort=jQuery.unique=T.uniqueSort;jQuery.text=T.getText;jQuery.isXMLDoc=T.isXML;jQuery.contains=T.contains;jQuery.escapeSelector=T.escape;var C=function(e,t,n){var r=[],i=n!==undefined;while((e=e[t])&&e.nodeType!==9){if(e.nodeType===1){if(i&&jQuery(e).is(n)){break}r.push(e)}}return r};var k=function(e,t){var n=[];for(;e;e=e.nextSibling){if(e.nodeType===1&&e!==t){n.push(e)}}return n};var E=jQuery.expr.match.needsContext;function S(e,t){return e.nodeName&&e.nodeName.toLowerCase()===t.toLowerCase()}var A=/^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i;function j(e,t,n){if(h(t)){return jQuery.grep(e,function(e,r){return!!t.call(e,r,e)!==n})}if(t.nodeType){return jQuery.grep(e,function(e){return e===t!==n})}if(typeof t!=="string"){return jQuery.grep(e,function(e){return s.call(t,e)>-1!==n})}return jQuery.filter(t,e,n)}jQuery.filter=function(e,t,n){var r=t[0];if(n){e=":not("+e+")"}if(t.length===1&&r.nodeType===1){return jQuery.find.matchesSelector(r,e)?[r]:[]}return jQuery.find.matches(e,jQuery.grep(t,function(e){return e.nodeType===1}))};jQuery.fn.extend({find:function(e){var t,n,r=this.length,i=this;if(typeof e!=="string"){return this.pushStack(jQuery(e).filter(function(){for(t=0;t<r;t++){if(jQuery.contains(i[t],this)){return true}}}))}n=this.pushStack([]);for(t=0;t<r;t++){jQuery.find(e,i[t],n)}return r>1?jQuery.uniqueSort(n):n},filter:function(e){return this.pushStack(j(this,e||[],false))},not:function(e){return this.pushStack(j(this,e||[],true))},is:function(e){return!!j(this,typeof e==="string"&&E.test(e)?jQuery(e):e||[],false).length}});var N,D=/^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/,q=jQuery.fn.init=function(e,t,n){var r,i;if(!e){return this}n=n||N;if(typeof e==="string"){if(e[0]==="<"&&e[e.length-1]===">"&&e.length>=3){r=[null,e,null]}else{r=D.exec(e)}if(r&&(r[1]||!t)){if(r[1]){t=t instanceof jQuery?t[0]:t;jQuery.merge(this,jQuery.parseHTML(r[1],t&&t.nodeType?t.ownerDocument||t:y,true));if(A.test(r[1])&&jQuery.isPlainObject(t)){for(r in t){if(h(this[r])){this[r](t[r])}else{this.attr(r,t[r])}}}return this}else{i=y.getElementById(r[2]);if(i){this[0]=i;this.length=1}return this}}else if(!t||t.jquery){return(t||n).find(e)}else{return this.constructor(t).find(e)}}else if(e.nodeType){this[0]=e;this.length=1;return this}else if(h(e)){return n.ready!==undefined?n.ready(e):e(jQuery)}return jQuery.makeArray(e,this)};q.prototype=jQuery.fn;N=jQuery(y);var L=/^(?:parents|prev(?:Until|All))/,H={children:true,contents:true,next:true,prev:true};jQuery.fn.extend({has:function(e){var t=jQuery(e,this),n=t.length;return this.filter(function(){var e=0;for(;e<n;e++){if(jQuery.contains(this,t[e])){return true}}})},closest:function(e,t){var n,r=0,i=this.length,o=[],a=typeof e!=="string"&&jQuery(e);if(!E.test(e)){for(;r<i;r++){for(n=this[r];n&&n!==t;n=n.parentNode){if(n.nodeType<11&&(a?a.index(n)>-1:n.nodeType===1&&jQuery.find.matchesSelector(n,e))){o.push(n);break}}}}return this.pushStack(o.length>1?jQuery.uniqueSort(o):o)},index:function(e){if(!e){return this[0]&&this[0].parentNode?this.first().prevAll().length:-1}if(typeof e==="string"){return s.call(jQuery(e),this[0])}return s.call(this,e.jquery?e[0]:e)},add:function(e,t){return this.pushStack(jQuery.uniqueSort(jQuery.merge(this.get(),jQuery(e,t))))},addBack:function(e){return this.add(e==null?this.prevObject:this.prevObject.filter(e))}});function O(e,t){while((e=e[t])&&e.nodeType!==1){}return e}jQuery.each({parent:function(e){var t=e.parentNode;return t&&t.nodeType!==11?t:null},parents:function(e){return C(e,"parentNode")},parentsUntil:function(e,t,n){return C(e,"parentNode",n)},next:function(e){return O(e,"nextSibling")},prev:function(e){return O(e,"previousSibling")},nextAll:function(e){return C(e,"nextSibling")},prevAll:function(e){return C(e,"previousSibling")},nextUntil:function(e,t,n){return C(e,"nextSibling",n)},prevUntil:function(e,t,n){return C(e,"previousSibling",n)},siblings:function(e){return k((e.parentNode||{}).firstChild,e)},children:function(e){return k(e.firstChild)},contents:function(e){if(e.contentDocument!=null&&r(e.contentDocument)){return e.contentDocument}if(S(e,"template")){e=e.content||e}return jQuery.merge([],e.childNodes)}},function(e,t){jQuery.fn[e]=function(n,r){var i=jQuery.map(this,t,n);if(e.slice(-5)!=="Until"){r=n}if(r&&typeof r==="string"){i=jQuery.filter(r,i)}if(this.length>1){if(!H[e]){jQuery.uniqueSort(i)}if(L.test(e)){i.reverse()}}return this.pushStack(i)}});var P=/[^\x20\t\r\n\f]+/g;function R(e){var t={};jQuery.each(e.match(P)||[],function(e,n){t[n]=true});return t}jQuery.Callbacks=function(e){e=typeof e==="string"?R(e):jQuery.extend({},e);var t,n,r,i,o=[],a=[],s=-1,u=function(){i=i||e.once;r=t=true;for(;a.length;s=-1){n=a.shift();while(++s<o.length){if(o[s].apply(n[0],n[1])===false&&e.stopOnFalse){s=o.length;n=false}}}if(!e.memory){n=false}t=false;if(i){if(n){o=[]}else{o=""}}},f={add:function(){if(o){if(n&&!t){s=o.length-1;a.push(n)}(function t(n){jQuery.each(n,function(n,r){if(h(r)){if(!e.unique||!f.has(r)){o.push(r)}}else if(r&&r.length&&x(r)!=="string"){t(r)}})})(arguments);if(n&&!t){u()}}return this},remove:function(){jQuery.each(arguments,function(e,t){var n;while((n=jQuery.inArray(t,o,n))>-1){o.splice(n,1);if(n<=s){s--}}});return this},has:function(e){return e?jQuery.inArray(e,o)>-1:o.length>0},empty:function(){if(o){o=[]}return this},disable:function(){i=a=[];o=n="";return this},disabled:function(){return!o},lock:function(){i=a=[];if(!n&&!t){o=n=""}return this},locked:function(){return!!i},fireWith:function(e,n){if(!i){n=n||[];n=[e,n.slice?n.slice():n];a.push(n);if(!t){u()}}return this},fire:function(){f.fireWith(this,arguments);return this},fired:function(){return!!r}};return f};function M(e){return e}function I(e){throw e}function W(e,t,n,r){var i;try{if(e&&h(i=e.promise)){i.call(e).done(t).fail(n)}else if(e&&h(i=e.then)){i.call(e,t,n)}else{t.apply(undefined,[e].slice(r))}}catch(e){n.apply(undefined,[e])}}jQuery.extend({Deferred:function(t){var n=[["notify","progress",jQuery.Callbacks("memory"),jQuery.Callbacks("memory"),2],["resolve","done",jQuery.Callbacks("once memory"),jQuery.Callbacks("once memory"),0,"resolved"],["reject","fail",jQuery.Callbacks("once memory"),jQuery.Callbacks("once memory"),1,"rejected"]],r="pending",i={state:function(){return r},always:function(){o.done(arguments).fail(arguments);return this},catch:function(e){return i.then(null,e)},pipe:function(){var e=arguments;return jQuery.Deferred(function(t){jQuery.each(n,function(n,r){var i=h(e[r[4]])&&e[r[4]];o[r[1]](function(){var e=i&&i.apply(this,arguments);if(e&&h(e.promise)){e.promise().progress(t.notify).done(t.resolve).fail(t.reject)}else{t[r[0]+"With"](this,i?[e]:arguments)}})});e=null}).promise()},then:function(t,r,i){var o=0;function a(t,n,r,i){return function(){var s=this,u=arguments,f=function(){var e,f;if(t<o){return}e=r.apply(s,u);if(e===n.promise()){throw new TypeError("Thenable self-resolution")}f=e&&(typeof e==="object"||typeof e==="function")&&e.then;if(h(f)){if(i){f.call(e,a(o,n,M,i),a(o,n,I,i))}else{o++;f.call(e,a(o,n,M,i),a(o,n,I,i),a(o,n,M,n.notifyWith))}}else{if(r!==M){s=undefined;u=[e]}(i||n.resolveWith)(s,u)}},l=i?f:function(){try{f()}catch(e){if(jQuery.Deferred.exceptionHook){jQuery.Deferred.exceptionHook(e,l.stackTrace)}if(t+1>=o){if(r!==I){s=undefined;u=[e]}n.rejectWith(s,u)}}};if(t){l()}else{if(jQuery.Deferred.getStackHook){l.stackTrace=jQuery.Deferred.getStackHook()}e.setTimeout(l)}}}return jQuery.Deferred(function(e){n[0][3].add(a(0,e,h(i)?i:M,e.notifyWith));n[1][3].add(a(0,e,h(t)?t:M));n[2][3].add(a(0,e,h(r)?r:I))}).promise()},promise:function(e){return e!=null?jQuery.extend(e,i):i}},o={};jQuery.each(n,function(e,t){var a=t[2],s=t[5];i[t[1]]=a.add;if(s){a.add(function(){r=s},n[3-e][2].disable,n[3-e][3].disable,n[0][2].lock,n[0][3].lock)}a.add(t[3].fire);o[t[0]]=function(){o[t[0]+"With"](this===o?undefined:this,arguments);return this};o[t[0]+"With"]=a.fireWith});i.promise(o);if(t){t.call(o,o)}return o},when:function(e){var t=arguments.length,n=t,r=Array(n),o=i.call(arguments),a=jQuery.Deferred(),s=function(e){return function(n){r[e]=this;o[e]=arguments.length>1?i.call(arguments):n;if(! --t){a.resolveWith(r,o)}}};if(t<=1){W(e,a.done(s(n)).resolve,a.reject,!t);if(a.state()==="pending"||h(o[n]&&o[n].then)){return a.then()}}while(n--){W(o[n],s(n),a.reject)}return a.promise()}});var F=/^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;jQuery.Deferred.exceptionHook=function(t,n){if(e.console&&e.console.warn&&t&&F.test(t.name)){e.console.warn("jQuery.Deferred exception: "+t.message,t.stack,n)}};jQuery.readyException=function(t){e.setTimeout(function(){throw t})};var B=jQuery.Deferred();jQuery.fn.ready=function(e){B.then(e).catch(function(e){jQuery.readyException(e)});return this};jQuery.extend({isReady:false,readyWait:1,ready:function(e){if(e===true?--jQuery.readyWait:jQuery.isReady){return}jQuery.isReady=true;if(e!==true&&--jQuery.readyWait>0){return}B.resolveWith(y,[jQuery])}});jQuery.ready.then=B.then;function _(){y.removeEventListener("DOMContentLoaded",_);e.removeEventListener("load",_);jQuery.ready()}if(y.readyState==="complete"||y.readyState!=="loading"&&!y.documentElement.doScroll){e.setTimeout(jQuery.ready)}else{y.addEventListener("DOMContentLoaded",_);e.addEventListener("load",_)}var $=function(e,t,n,r,i,o,a){var s=0,u=e.length,f=n==null;if(x(n)==="object"){i=true;for(s in n){$(e,t,s,n[s],true,o,a)}}else if(r!==undefined){i=true;if(!h(r)){a=true}if(f){if(a){t.call(e,r);t=null}else{f=t;t=function(e,t,n){return f.call(jQuery(e),n)}}}if(t){for(;s<u;s++){t(e[s],n,a?r:r.call(e[s],s,t(e[s],n)))}}}if(i){return e}if(f){return t.call(e)}return u?t(e[0],n):o};var z=/^-ms-/,X=/-([a-z])/g;function U(e,t){return t.toUpperCase()}function Q(e){return e.replace(z,"ms-").replace(X,U)}var V=function(e){return e.nodeType===1||e.nodeType===9||!+e.nodeType};function G(){this.expando=jQuery.expando+G.uid++}G.uid=1;G.prototype={cache:function(e){var t=e[this.expando];if(!t){t={};if(V(e)){if(e.nodeType){e[this.expando]=t}else{Object.defineProperty(e,this.expando,{value:t,configurable:true})}}}return t},set:function(e,t,n){var r,i=this.cache(e);if(typeof t==="string"){i[Q(t)]=n}else{for(r in t){i[Q(r)]=t[r]}}return i},get:function(e,t){return t===undefined?this.cache(e):e[this.expando]&&e[this.expando][Q(t)]},access:function(e,t,n){if(t===undefined||t&&typeof t==="string"&&n===undefined){return this.get(e,t)}this.set(e,t,n);return n!==undefined?n:t},remove:function(e,t){var n,r=e[this.expando];if(r===undefined){return}if(t!==undefined){if(Array.isArray(t)){t=t.map(Q)}else{t=Q(t);t=t in r?[t]:t.match(P)||[]}n=t.length;while(n--){delete r[t[n]]}}if(t===undefined||jQuery.isEmptyObject(r)){if(e.nodeType){e[this.expando]=undefined}else{delete e[this.expando]}}},hasData:function(e){var t=e[this.expando];return t!==undefined&&!jQuery.isEmptyObject(t)}};var Y=new G;var J=new G;var K=/^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,Z=/[A-Z]/g;function ee(e){if(e==="true"){return true}if(e==="false"){return false}if(e==="null"){return null}if(e===+e+""){return+e}if(K.test(e)){return JSON.parse(e)}return e}function te(e,t,n){var r;if(n===undefined&&e.nodeType===1){r="data-"+t.replace(Z,"-$&").toLowerCase();n=e.getAttribute(r);if(typeof n==="string"){try{n=ee(n)}catch(e){}J.set(e,t,n)}else{n=undefined}}return n}jQuery.extend({hasData:function(e){return J.hasData(e)||Y.hasData(e)},data:function(e,t,n){return J.access(e,t,n)},removeData:function(e,t){J.remove(e,t)},_data:function(e,t,n){return Y.access(e,t,n)},_removeData:function(e,t){Y.remove(e,t)}});jQuery.fn.extend({data:function(e,t){var n,r,i,o=this[0],a=o&&o.attributes;if(e===undefined){if(this.length){i=J.get(o);if(o.nodeType===1&&!Y.get(o,"hasDataAttrs")){n=a.length;while(n--){if(a[n]){r=a[n].name;if(r.indexOf("data-")===0){r=Q(r.slice(5));te(o,r,i[r])}}}Y.set(o,"hasDataAttrs",true)}}return i}if(typeof e==="object"){return this.each(function(){J.set(this,e)})}return $(this,function(t){var n;if(o&&t===undefined){n=J.get(o,e);if(n!==undefined){return n}n=te(o,e);if(n!==undefined){return n}return}this.each(function(){J.set(this,e,t)})},null,t,arguments.length>1,null,true)},removeData:function(e){return this.each(function(){J.remove(this,e)})}});jQuery.extend({queue:function(e,t,n){var r;if(e){t=(t||"fx")+"queue";r=Y.get(e,t);if(n){if(!r||Array.isArray(n)){r=Y.access(e,t,jQuery.makeArray(n))}else{r.push(n)}}return r||[]}},dequeue:function(e,t){t=t||"fx";var n=jQuery.queue(e,t),r=n.length,i=n.shift(),o=jQuery._queueHooks(e,t),a=function(){jQuery.dequeue(e,t)};if(i==="inprogress"){i=n.shift();r--}if(i){if(t==="fx"){n.unshift("inprogress")}delete o.stop;i.call(e,a,o)}if(!r&&o){o.empty.fire()}},_queueHooks:function(e,t){var n=t+"queueHooks";return Y.get(e,n)||Y.access(e,n,{empty:jQuery.Callbacks("once memory").add(function(){Y.remove(e,[t+"queue",n])})})}});jQuery.fn.extend({queue:function(e,t){var n=2;if(typeof e!=="string"){t=e;e="fx";n--}if(arguments.length<n){return jQuery.queue(this[0],e)}return t===undefined?this:this.each(function(){var n=jQuery.queue(this,e,t);jQuery._queueHooks(this,e);if(e==="fx"&&n[0]!=="inprogress"){jQuery.dequeue(this,e)}})},dequeue:function(e){return this.each(function(){jQuery.dequeue(this,e)})},clearQueue:function(e){return this.queue(e||"fx",[])},promise:function(e,t){var n,r=1,i=jQuery.Deferred(),o=this,a=this.length,s=function(){if(! --r){i.resolveWith(o,[o])}};if(typeof e!=="string"){t=e;e=undefined}e=e||"fx";while(a--){n=Y.get(o[a],e+"queueHooks");if(n&&n.empty){r++;n.empty.add(s)}}s();return i.promise(t)}});var ne=/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source;var re=new RegExp("^(?:([+-])=|)("+ne+")([a-z%]*)$","i");var ie=["Top","Right","Bottom","Left"];var oe=y.documentElement;var ae=function(e){return jQuery.contains(e.ownerDocument,e)},se={composed:true};if(oe.getRootNode){ae=function(e){return jQuery.contains(e.ownerDocument,e)||e.getRootNode(se)===e.ownerDocument}}var ue=function(e,t){e=t||e;return e.style.display==="none"||e.style.display===""&&ae(e)&&jQuery.css(e,"display")==="none"};function fe(e,t,n,r){var i,o,a=20,s=r?function(){return r.cur()}:function(){return jQuery.css(e,t,"")},u=s(),f=n&&n[3]||(jQuery.cssNumber[t]?"":"px"),l=e.nodeType&&(jQuery.cssNumber[t]||f!=="px"&&+u)&&re.exec(jQuery.css(e,t));if(l&&l[3]!==f){u=u/2;f=f||l[3];l=+u||1;while(a--){jQuery.style(e,t,l+f);if((1-o)*(1-(o=s()/u||.5))<=0){a=0}l=l/o}l=l*2;jQuery.style(e,t,l+f);n=n||[]}if(n){l=+l||+u||0;i=n[1]?l+(n[1]+1)*n[2]:+n[2];if(r){r.unit=f;r.start=l;r.end=i}}return i}var le={};function ce(e){var t,n=e.ownerDocument,r=e.nodeName,i=le[r];if(i){return i}t=n.body.appendChild(n.createElement(r));i=jQuery.css(t,"display");t.parentNode.removeChild(t);if(i==="none"){i="block"}le[r]=i;return i}function de(e,t){var n,r,i=[],o=0,a=e.length;for(;o<a;o++){r=e[o];if(!r.style){continue}n=r.style.display;if(t){if(n==="none"){i[o]=Y.get(r,"display")||null;if(!i[o]){r.style.display=""}}if(r.style.display===""&&ue(r)){i[o]=ce(r)}}else{if(n!=="none"){i[o]="none";Y.set(r,"display",n)}}}for(o=0;o<a;o++){if(i[o]!=null){e[o].style.display=i[o]}}return e}jQuery.fn.extend({show:function(){return de(this,true)},hide:function(){return de(this)},toggle:function(e){if(typeof e==="boolean"){return e?this.show():this.hide()}return this.each(function(){if(ue(this)){jQuery(this).show()}else{jQuery(this).hide()}})}});var pe=/^(?:checkbox|radio)$/i;var he=/<([a-z][^\/\0>\x20\t\r\n\f]*)/i;var ge=/^$|^module$|\/(?:java|ecma)script/i;(function(){var e=y.createDocumentFragment(),t=e.appendChild(y.createElement("div")),n=y.createElement("input");n.setAttribute("type","radio");n.setAttribute("checked","checked");n.setAttribute("name","t");t.appendChild(n);p.checkClone=t.cloneNode(true).cloneNode(true).lastChild.checked;t.innerHTML="<textarea>x</textarea>";p.noCloneChecked=!!t.cloneNode(true).lastChild.defaultValue;t.innerHTML="<option></option>";p.option=!!t.lastChild})();var ye={thead:[1,"<table>","</table>"],col:[2,"<table><colgroup>","</colgroup></table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],_default:[0,"",""]};ye.tbody=ye.tfoot=ye.colgroup=ye.caption=ye.thead;ye.th=ye.td;if(!p.option){ye.optgroup=ye.option=[1,"<select multiple='multiple'>","</select>"]}function me(e,t){var n;if(typeof e.getElementsByTagName!=="undefined"){n=e.getElementsByTagName(t||"*")}else if(typeof e.querySelectorAll!=="undefined"){n=e.querySelectorAll(t||"*")}else{n=[]}if(t===undefined||t&&S(e,t)){return jQuery.merge([e],n)}return n}function ve(e,t){var n=0,r=e.length;for(;n<r;n++){Y.set(e[n],"globalEval",!t||Y.get(t[n],"globalEval"))}}var xe=/<|&#?\w+;/;function be(e,t,n,r,i){var o,a,s,u,f,l,c=t.createDocumentFragment(),d=[],p=0,h=e.length;for(;p<h;p++){o=e[p];if(o||o===0){if(x(o)==="object"){jQuery.merge(d,o.nodeType?[o]:o)}else if(!xe.test(o)){d.push(t.createTextNode(o))}else{a=a||c.appendChild(t.createElement("div"));s=(he.exec(o)||["",""])[1].toLowerCase();u=ye[s]||ye._default;a.innerHTML=u[1]+jQuery.htmlPrefilter(o)+u[2];l=u[0];while(l--){a=a.lastChild}jQuery.merge(d,a.childNodes);a=c.firstChild;a.textContent=""}}}c.textContent="";p=0;while(o=d[p++]){if(r&&jQuery.inArray(o,r)>-1){if(i){i.push(o)}continue}f=ae(o);a=me(c.appendChild(o),"script");if(f){ve(a)}if(n){l=0;while(o=a[l++]){if(ge.test(o.type||"")){n.push(o)}}}}return c}var we=/^([^.]*)(?:\.(.+)|)/;function Te(){return true}function Ce(){return false}function ke(e,t){return e===Ee()===(t==="focus")}function Ee(){try{return y.activeElement}catch(e){}}function Se(e,t,n,r,i,o){var a,s;if(typeof t==="object"){if(typeof n!=="string"){r=r||n;n=undefined}for(s in t){Se(e,s,n,r,t[s],o)}return e}if(r==null&&i==null){i=n;r=n=undefined}else if(i==null){if(typeof n==="string"){i=r;r=undefined}else{i=r;r=n;n=undefined}}if(i===false){i=Ce}else if(!i){return e}if(o===1){a=i;i=function(e){jQuery().off(e);return a.apply(this,arguments)};i.guid=a.guid||(a.guid=jQuery.guid++)}return e.each(function(){jQuery.event.add(this,t,i,r,n)})}jQuery.event={global:{},add:function(e,t,n,r,i){var o,a,s,u,f,l,c,d,p,h,g,y=Y.get(e);if(!V(e)){return}if(n.handler){o=n;n=o.handler;i=o.selector}if(i){jQuery.find.matchesSelector(oe,i)}if(!n.guid){n.guid=jQuery.guid++}if(!(u=y.events)){u=y.events=Object.create(null)}if(!(a=y.handle)){a=y.handle=function(t){return typeof jQuery!=="undefined"&&jQuery.event.triggered!==t.type?jQuery.event.dispatch.apply(e,arguments):undefined}}t=(t||"").match(P)||[""];f=t.length;while(f--){s=we.exec(t[f])||[];p=g=s[1];h=(s[2]||"").split(".").sort();if(!p){continue}c=jQuery.event.special[p]||{};p=(i?c.delegateType:c.bindType)||p;c=jQuery.event.special[p]||{};l=jQuery.extend({type:p,origType:g,data:r,handler:n,guid:n.guid,selector:i,needsContext:i&&jQuery.expr.match.needsContext.test(i),namespace:h.join(".")},o);if(!(d=u[p])){d=u[p]=[];d.delegateCount=0;if(!c.setup||c.setup.call(e,r,h,a)===false){if(e.addEventListener){e.addEventListener(p,a)}}}if(c.add){c.add.call(e,l);if(!l.handler.guid){l.handler.guid=n.guid}}if(i){d.splice(d.delegateCount++,0,l)}else{d.push(l)}jQuery.event.global[p]=true}},remove:function(e,t,n,r,i){var o,a,s,u,f,l,c,d,p,h,g,y=Y.hasData(e)&&Y.get(e);if(!y||!(u=y.events)){return}t=(t||"").match(P)||[""];f=t.length;while(f--){s=we.exec(t[f])||[];p=g=s[1];h=(s[2]||"").split(".").sort();if(!p){for(p in u){jQuery.event.remove(e,p+t[f],n,r,true)}continue}c=jQuery.event.special[p]||{};p=(r?c.delegateType:c.bindType)||p;d=u[p]||[];s=s[2]&&new RegExp("(^|\\.)"+h.join("\\.(?:.*\\.|)")+"(\\.|$)");a=o=d.length;while(o--){l=d[o];if((i||g===l.origType)&&(!n||n.guid===l.guid)&&(!s||s.test(l.namespace))&&(!r||r===l.selector||r==="**"&&l.selector)){d.splice(o,1);if(l.selector){d.delegateCount--}if(c.remove){c.remove.call(e,l)}}}if(a&&!d.length){if(!c.teardown||c.teardown.call(e,h,y.handle)===false){jQuery.removeEvent(e,p,y.handle)}delete u[p]}}if(jQuery.isEmptyObject(u)){Y.remove(e,"handle events")}},dispatch:function(e){var t,n,r,i,o,a,s=new Array(arguments.length),u=jQuery.event.fix(e),f=(Y.get(this,"events")||Object.create(null))[u.type]||[],l=jQuery.event.special[u.type]||{};s[0]=u;for(t=1;t<arguments.length;t++){s[t]=arguments[t]}u.delegateTarget=this;if(l.preDispatch&&l.preDispatch.call(this,u)===false){return}a=jQuery.event.handlers.call(this,u,f);t=0;while((i=a[t++])&&!u.isPropagationStopped()){u.currentTarget=i.elem;n=0;while((o=i.handlers[n++])&&!u.isImmediatePropagationStopped()){if(!u.rnamespace||o.namespace===false||u.rnamespace.test(o.namespace)){u.handleObj=o;u.data=o.data;r=((jQuery.event.special[o.origType]||{}).handle||o.handler).apply(i.elem,s);if(r!==undefined){if((u.result=r)===false){u.preventDefault();u.stopPropagation()}}}}}if(l.postDispatch){l.postDispatch.call(this,u)}return u.result},handlers:function(e,t){var n,r,i,o,a,s=[],u=t.delegateCount,f=e.target;if(u&&f.nodeType&&!(e.type==="click"&&e.button>=1)){for(;f!==this;f=f.parentNode||this){if(f.nodeType===1&&!(e.type==="click"&&f.disabled===true)){o=[];a={};for(n=0;n<u;n++){r=t[n];i=r.selector+" ";if(a[i]===undefined){a[i]=r.needsContext?jQuery(i,this).index(f)>-1:jQuery.find(i,this,null,[f]).length}if(a[i]){o.push(r)}}if(o.length){s.push({elem:f,handlers:o})}}}}f=this;if(u<t.length){s.push({elem:f,handlers:t.slice(u)})}return s},addProp:function(e,t){Object.defineProperty(jQuery.Event.prototype,e,{enumerable:true,configurable:true,get:h(t)?function(){if(this.originalEvent){return t(this.originalEvent)}}:function(){if(this.originalEvent){return this.originalEvent[e]}},set:function(t){Object.defineProperty(this,e,{enumerable:true,configurable:true,writable:true,value:t})}})},fix:function(e){return e[jQuery.expando]?e:new jQuery.Event(e)},special:{load:{noBubble:true},click:{setup:function(e){var t=this||e;if(pe.test(t.type)&&t.click&&S(t,"input")){Ae(t,"click",Te)}return false},trigger:function(e){var t=this||e;if(pe.test(t.type)&&t.click&&S(t,"input")){Ae(t,"click")}return true},_default:function(e){var t=e.target;return pe.test(t.type)&&t.click&&S(t,"input")&&Y.get(t,"click")||S(t,"a")}},beforeunload:{postDispatch:function(e){if(e.result!==undefined&&e.originalEvent){e.originalEvent.returnValue=e.result}}}}};function Ae(e,t,n){if(!n){if(Y.get(e,t)===undefined){jQuery.event.add(e,t,Te)}return}Y.set(e,t,false);jQuery.event.add(e,t,{namespace:false,handler:function(e){var r,o,a=Y.get(this,t);if(e.isTrigger&1&&this[t]){if(!a.length){a=i.call(arguments);Y.set(this,t,a);r=n(this,t);this[t]();o=Y.get(this,t);if(a!==o||r){Y.set(this,t,false)}else{o={}}if(a!==o){e.stopImmediatePropagation();e.preventDefault();return o&&o.value}}else if((jQuery.event.special[t]||{}).delegateType){e.stopPropagation()}}else if(a.length){Y.set(this,t,{value:jQuery.event.trigger(jQuery.extend(a[0],jQuery.Event.prototype),a.slice(1),this)});e.stopImmediatePropagation()}}})}jQuery.removeEvent=function(e,t,n){if(e.removeEventListener){e.removeEventListener(t,n)}};jQuery.Event=function(e,t){if(!(this instanceof jQuery.Event)){return new jQuery.Event(e,t)}if(e&&e.type){this.originalEvent=e;this.type=e.type;this.isDefaultPrevented=e.defaultPrevented||e.defaultPrevented===undefined&&e.returnValue===false?Te:Ce;this.target=e.target&&e.target.nodeType===3?e.target.parentNode:e.target;this.currentTarget=e.currentTarget;this.relatedTarget=e.relatedTarget}else{this.type=e}if(t){jQuery.extend(this,t)}this.timeStamp=e&&e.timeStamp||Date.now();this[jQuery.expando]=true};jQuery.Event.prototype={constructor:jQuery.Event,isDefaultPrevented:Ce,isPropagationStopped:Ce,isImmediatePropagationStopped:Ce,isSimulated:false,preventDefault:function(){var e=this.originalEvent;this.isDefaultPrevented=Te;if(e&&!this.isSimulated){e.preventDefault()}},stopPropagation:function(){var e=this.originalEvent;this.isPropagationStopped=Te;if(e&&!this.isSimulated){e.stopPropagation()}},stopImmediatePropagation:function(){var e=this.originalEvent;this.isImmediatePropagationStopped=Te;if(e&&!this.isSimulated){e.stopImmediatePropagation()}this.stopPropagation()}};jQuery.each({altKey:true,bubbles:true,cancelable:true,changedTouches:true,ctrlKey:true,detail:true,eventPhase:true,metaKey:true,pageX:true,pageY:true,shiftKey:true,view:true,char:true,code:true,charCode:true,key:true,keyCode:true,button:true,buttons:true,clientX:true,clientY:true,offsetX:true,offsetY:true,pointerId:true,pointerType:true,screenX:true,screenY:true,targetTouches:true,toElement:true,touches:true,which:true},jQuery.event.addProp);jQuery.each({focus:"focusin",blur:"focusout"},function(e,t){jQuery.event.special[e]={setup:function(){Ae(this,e,ke);return false},trigger:function(){Ae(this,e);return true},_default:function(){return true},delegateType:t}});jQuery.each({mouseenter:"mouseover",mouseleave:"mouseout",pointerenter:"pointerover",pointerleave:"pointerout"},function(e,t){jQuery.event.special[e]={delegateType:t,bindType:t,handle:function(e){var n,r=this,i=e.relatedTarget,o=e.handleObj;if(!i||i!==r&&!jQuery.contains(r,i)){e.type=o.origType;n=o.handler.apply(this,arguments);e.type=t}return n}}});jQuery.fn.extend({on:function(e,t,n,r){return Se(this,e,t,n,r)},one:function(e,t,n,r){return Se(this,e,t,n,r,1)},off:function(e,t,n){var r,i;if(e&&e.preventDefault&&e.handleObj){r=e.handleObj;jQuery(e.delegateTarget).off(r.namespace?r.origType+"."+r.namespace:r.origType,r.selector,r.handler);return this}if(typeof e==="object"){for(i in e){this.off(i,t,e[i])}return this}if(t===false||typeof t==="function"){n=t;t=undefined}if(n===false){n=Ce}return this.each(function(){jQuery.event.remove(this,e,n,t)})}});var je=/<script|<style|<link/i,Ne=/checked\s*(?:[^=]|=\s*.checked.)/i,De=/^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;function qe(t,n){if(S(t,"table")&&S(n.nodeType!==11?n:n.firstChild,"tr")){var r=jQuery(t).children("tbody")[0];if(r){return r}else{if(e.sap&&e.sap.ui&&e.sap.ui._jQuery3Compat&&e.sap.ui._jQuery3Compat._migrateWarn){e.sap.ui._jQuery3Compat._migrateWarn("Trying to add a <tr> element to a <table> without a <tbody>. "+"At this point, jQuery version 2 would have inserted a <tbody> element for you. "+"Since jQuery version 3, jQuery does not automatically create a <tbody> element anymore. "+"Please add the <tbody> on your own, if your code or CSS expects it.")}return t}}return t}function Le(e){e.type=(e.getAttribute("type")!==null)+"/"+e.type;return e}function He(e){if((e.type||"").slice(0,5)==="true/"){e.type=e.type.slice(5)}else{e.removeAttribute("type")}return e}function Oe(e,t){var n,r,i,o,a,s,u;if(t.nodeType!==1){return}if(Y.hasData(e)){o=Y.get(e);u=o.events;if(u){Y.remove(t,"handle events");for(i in u){for(n=0,r=u[i].length;n<r;n++){jQuery.event.add(t,i,u[i][n])}}}}if(J.hasData(e)){a=J.access(e);s=jQuery.extend({},a);J.set(t,s)}}function Pe(e,t){var n=t.nodeName.toLowerCase();if(n==="input"&&pe.test(e.type)){t.checked=e.checked}else if(n==="input"||n==="textarea"){t.defaultValue=e.defaultValue}}function Re(e,t,n,r){t=o(t);var i,a,s,u,f,l,c=0,d=e.length,g=d-1,y=t[0],m=h(y);if(m||d>1&&typeof y==="string"&&!p.checkClone&&Ne.test(y)){return e.each(function(i){var o=e.eq(i);if(m){t[0]=y.call(this,i,o.html())}Re(o,t,n,r)})}if(d){i=be(t,e[0].ownerDocument,false,e,r);a=i.firstChild;if(i.childNodes.length===1){i=a}if(a||r){s=jQuery.map(me(i,"script"),Le);u=s.length;for(;c<d;c++){f=i;if(c!==g){f=jQuery.clone(f,true,true);if(u){jQuery.merge(s,me(f,"script"))}}n.call(e[c],f,c)}if(u){l=s[s.length-1].ownerDocument;jQuery.map(s,He);for(c=0;c<u;c++){f=s[c];if(ge.test(f.type||"")&&!Y.access(f,"globalEval")&&jQuery.contains(l,f)){if(f.src&&(f.type||"").toLowerCase()!=="module"){if(jQuery._evalUrl&&!f.noModule){jQuery._evalUrl(f.src,{nonce:f.nonce||f.getAttribute("nonce")},l)}}else{v(f.textContent.replace(De,""),f,l)}}}}}}return e}function Me(e,t,n){var r,i=t?jQuery.filter(t,e):e,o=0;for(;(r=i[o])!=null;o++){if(!n&&r.nodeType===1){jQuery.cleanData(me(r))}if(r.parentNode){if(n&&ae(r)){ve(me(r,"script"))}r.parentNode.removeChild(r)}}return e}jQuery.extend({htmlPrefilter:function(e){return e},clone:function(e,t,n){var r,i,o,a,s=e.cloneNode(true),u=ae(e);if(!p.noCloneChecked&&(e.nodeType===1||e.nodeType===11)&&!jQuery.isXMLDoc(e)){a=me(s);o=me(e);for(r=0,i=o.length;r<i;r++){Pe(o[r],a[r])}}if(t){if(n){o=o||me(e);a=a||me(s);for(r=0,i=o.length;r<i;r++){Oe(o[r],a[r])}}else{Oe(e,s)}}a=me(s,"script");if(a.length>0){ve(a,!u&&me(e,"script"))}return s},cleanData:function(e){var t,n,r,i=jQuery.event.special,o=0;for(;(n=e[o])!==undefined;o++){if(V(n)){if(t=n[Y.expando]){if(t.events){for(r in t.events){if(i[r]){jQuery.event.remove(n,r)}else{jQuery.removeEvent(n,r,t.handle)}}}n[Y.expando]=undefined}if(n[J.expando]){n[J.expando]=undefined}}}}});if(/(?:\?|&)sap-ui-xx-self-closing-check=(?:x|X|true)/.exec(e.location.search)){var Ie=new RegExp("^(?:a|abbr|address|article|aside|audio|b|bdi|bdo|blockquote|body|button|canvas|caption|cite|code|colgroup|data|datalist|dd|del|details|dfn|dialog|div|dl|dt|em|fieldset"+"|figcaption|figure|footer|form|h1|h2|h3|h4|h5|h6|head|header|hgroup|html|i|iframe|ins|kbd|label|legend|li|main|map|mark|menu|meter|nav|noscript|object|ol|optgroup|option"+"|output|p|picture|pre|progress|q|rp|rt|ruby|s|samp|script|section|select|slot|small|span|strong|style|sub|summary|sup|table|tbody|td|template|textarea|tfoot|th|thead|time"+"|title|tr|u|ul|var|video)$","i");var We=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:-]+)[^>]*)\/>/gi;jQuery.htmlPrefilter=function(e){e.replace(We,function(t,n,r){if(Ie.test(r)&&t.length<e.length){var i="<"+n+"></"+r+">";var o="https://launchpad.support.sap.com/#/notes/2944336";var a="https://github.com/SAP/openui5/blob/master/docs/self_closing_tags_fix_instructions.md";var s="jQuery incompatibility: non-void HTML tags must not use self-closing syntax.\n"+"HTML element used as self-closing tag: <"+n+"/>\n"+"HTML element should be closed correctly, such as: "+i+"\n"+"Please check the following note for more information:\n";var u=s+o+" or\n"+a;console.error(u);try{sap.ui.require(["sap/m/MessageBox","sap/m/FormattedText","sap/base/security/encodeXML"],function(e,t,n){var r=new t({htmlText:n(s).replace(/&#xa;/g,"<br>")+'<a href="'+o+'" target="_blank" rel="noopener noreferrer">'+o+"</a> or<br>"+'<a href="'+a+'" target="_blank" rel="noopener noreferrer">'+a+"</a>"});e.alert(r,{title:"Incompatibility detected"})},function(){console.error("Showing error with UI5 controls failed. Falling back to alert().");setTimeout(function(){alert(u)})})}catch(e){console.error("Exception in error handling: "+e+". Falling back to alert().");setTimeout(function(){alert(u)})}}});return e}}jQuery.fn.extend({detach:function(e){return Me(this,e,true)},remove:function(e){return Me(this,e)},text:function(e){return $(this,function(e){return e===undefined?jQuery.text(this):this.empty().each(function(){if(this.nodeType===1||this.nodeType===11||this.nodeType===9){this.textContent=e}})},null,e,arguments.length)},append:function(){return Re(this,arguments,function(e){if(this.nodeType===1||this.nodeType===11||this.nodeType===9){var t=qe(this,e);t.appendChild(e)}})},prepend:function(){return Re(this,arguments,function(e){if(this.nodeType===1||this.nodeType===11||this.nodeType===9){var t=qe(this,e);t.insertBefore(e,t.firstChild)}})},before:function(){return Re(this,arguments,function(e){if(this.parentNode){this.parentNode.insertBefore(e,this)}})},after:function(){return Re(this,arguments,function(e){if(this.parentNode){this.parentNode.insertBefore(e,this.nextSibling)}})},empty:function(){var e,t=0;for(;(e=this[t])!=null;t++){if(e.nodeType===1){jQuery.cleanData(me(e,false));e.textContent=""}}return this},clone:function(e,t){e=e==null?false:e;t=t==null?e:t;return this.map(function(){return jQuery.clone(this,e,t)})},html:function(e){return $(this,function(e){var t=this[0]||{},n=0,r=this.length;if(e===undefined&&t.nodeType===1){return t.innerHTML}if(typeof e==="string"&&!je.test(e)&&!ye[(he.exec(e)||["",""])[1].toLowerCase()]){e=jQuery.htmlPrefilter(e);try{for(;n<r;n++){t=this[n]||{};if(t.nodeType===1){jQuery.cleanData(me(t,false));t.innerHTML=e}}t=0}catch(e){}}if(t){this.empty().append(e)}},null,e,arguments.length)},replaceWith:function(){var e=[];return Re(this,arguments,function(t){var n=this.parentNode;if(jQuery.inArray(this,e)<0){jQuery.cleanData(me(this));if(n){n.replaceChild(t,this)}}},e)}});jQuery.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(e,t){jQuery.fn[e]=function(e){var n,r=[],i=jQuery(e),o=i.length-1,s=0;for(;s<=o;s++){n=s===o?this:this.clone(true);jQuery(i[s])[t](n);a.apply(r,n.get())}return this.pushStack(r)}});var Fe=new RegExp("^("+ne+")(?!px)[a-z%]+$","i");var Be=function(t){var n=t.ownerDocument.defaultView;if(!n||!n.opener){n=e}return n.getComputedStyle(t)};var _e=function(e,t,n){var r,i,o={};for(i in t){o[i]=e.style[i];e.style[i]=t[i]}r=n.call(e);for(i in t){e.style[i]=o[i]}return r};var $e=new RegExp(ie.join("|"),"i");(function(){function t(){if(!l){return}f.style.cssText="position:absolute;left:-11111px;width:60px;"+"margin-top:1px;padding:0;border:0";l.style.cssText="position:relative;display:block;box-sizing:border-box;overflow:scroll;"+"margin:auto;border:1px;padding:1px;"+"width:60%;top:1%";oe.appendChild(f).appendChild(l);var t=e.getComputedStyle(l);r=t.top!=="1%";u=n(t.marginLeft)===12;l.style.right="60%";a=n(t.right)===36;i=n(t.width)===36;l.style.position="absolute";o=n(l.offsetWidth/3)===12;oe.removeChild(f);l=null}function n(e){return Math.round(parseFloat(e))}var r,i,o,a,s,u,f=y.createElement("div"),l=y.createElement("div");if(!l.style){return}l.style.backgroundClip="content-box";l.cloneNode(true).style.backgroundClip="";p.clearCloneStyle=l.style.backgroundClip==="content-box";jQuery.extend(p,{boxSizingReliable:function(){t();return i},pixelBoxStyles:function(){t();return a},pixelPosition:function(){t();return r},reliableMarginLeft:function(){t();return u},scrollboxSize:function(){t();return o},reliableTrDimensions:function(){var t,n,r,i;if(s==null){t=y.createElement("table");n=y.createElement("tr");r=y.createElement("div");t.style.cssText="position:absolute;left:-11111px;border-collapse:separate";n.style.cssText="border:1px solid";n.style.height="1px";r.style.height="9px";r.style.display="block";oe.appendChild(t).appendChild(n).appendChild(r);i=e.getComputedStyle(n);s=parseInt(i.height,10)+parseInt(i.borderTopWidth,10)+parseInt(i.borderBottomWidth,10)===n.offsetHeight;oe.removeChild(t)}return s}})})();function ze(e,t,n){var r,i,o,a,s=e.style;n=n||Be(e);if(n){a=n.getPropertyValue(t)||n[t];if(a===""&&!ae(e)){a=jQuery.style(e,t)}if(!p.pixelBoxStyles()&&Fe.test(a)&&$e.test(t)){r=s.width;i=s.minWidth;o=s.maxWidth;s.minWidth=s.maxWidth=s.width=a;a=n.width;s.width=r;s.minWidth=i;s.maxWidth=o}}return a!==undefined?a+"":a}function Xe(e,t){return{get:function(){if(e()){delete this.get;return}return(this.get=t).apply(this,arguments)}}}var Ue=["Webkit","Moz","ms"],Qe=y.createElement("div").style,Ve={};function Ge(e){var t=e[0].toUpperCase()+e.slice(1),n=Ue.length;while(n--){e=Ue[n]+t;if(e in Qe){return e}}}function Ye(e){var t=jQuery.cssProps[e]||Ve[e];if(t){return t}if(e in Qe){return e}return Ve[e]=Ge(e)||e}var Je=/^(none|table(?!-c[ea]).+)/,Ke=/^--/,Ze={position:"absolute",visibility:"hidden",display:"block"},et={letterSpacing:"0",fontWeight:"400"};function tt(e,t,n){var r=re.exec(t);return r?Math.max(0,r[2]-(n||0))+(r[3]||"px"):t}function nt(e,t,n,r,i,o){var a=t==="width"?1:0,s=0,u=0;if(n===(r?"border":"content")){return 0}for(;a<4;a+=2){if(n==="margin"){u+=jQuery.css(e,n+ie[a],true,i)}if(!r){u+=jQuery.css(e,"padding"+ie[a],true,i);if(n!=="padding"){u+=jQuery.css(e,"border"+ie[a]+"Width",true,i)}else{s+=jQuery.css(e,"border"+ie[a]+"Width",true,i)}}else{if(n==="content"){u-=jQuery.css(e,"padding"+ie[a],true,i)}if(n!=="margin"){u-=jQuery.css(e,"border"+ie[a]+"Width",true,i)}}}if(!r&&o>=0){u+=Math.max(0,Math.ceil(e["offset"+t[0].toUpperCase()+t.slice(1)]-o-u-s-.5))||0}return u}function rt(e,t,n){var r=Be(e),i=!p.boxSizingReliable()||n,o=i&&jQuery.css(e,"boxSizing",false,r)==="border-box",a=o,s=ze(e,t,r),u="offset"+t[0].toUpperCase()+t.slice(1);if(Fe.test(s)){if(!n){return s}s="auto"}if((!p.boxSizingReliable()&&o||!p.reliableTrDimensions()&&S(e,"tr")||s==="auto"||!parseFloat(s)&&jQuery.css(e,"display",false,r)==="inline")&&e.getClientRects().length){o=jQuery.css(e,"boxSizing",false,r)==="border-box";a=u in e;if(a){s=e[u]}}s=parseFloat(s)||0;return s+nt(e,t,n||(o?"border":"content"),a,r,s)+"px"}jQuery.extend({cssHooks:{opacity:{get:function(e,t){if(t){var n=ze(e,"opacity");return n===""?"1":n}}}},cssNumber:{animationIterationCount:true,columnCount:true,fillOpacity:true,flexGrow:true,flexShrink:true,fontWeight:true,gridArea:true,gridColumn:true,gridColumnEnd:true,gridColumnStart:true,gridRow:true,gridRowEnd:true,gridRowStart:true,lineHeight:true,opacity:true,order:true,orphans:true,widows:true,zIndex:true,zoom:true},cssProps:{},style:function(e,t,n,r){if(!e||e.nodeType===3||e.nodeType===8||!e.style){return}var i,o,a,s=Q(t),u=Ke.test(t),f=e.style;if(!u){t=Ye(s)}a=jQuery.cssHooks[t]||jQuery.cssHooks[s];if(n!==undefined){o=typeof n;if(o==="string"&&(i=re.exec(n))&&i[1]){n=fe(e,t,i);o="number"}if(n==null||n!==n){return}if(o==="number"&&!u){n+=i&&i[3]||(jQuery.cssNumber[s]?"":"px")}if(!p.clearCloneStyle&&n===""&&t.indexOf("background")===0){f[t]="inherit"}if(!a||!("set"in a)||(n=a.set(e,n,r))!==undefined){if(u){f.setProperty(t,n)}else{f[t]=n}}}else{if(a&&"get"in a&&(i=a.get(e,false,r))!==undefined){return i}return f[t]}},css:function(e,t,n,r){var i,o,a,s=Q(t),u=Ke.test(t);if(!u){t=Ye(s)}a=jQuery.cssHooks[t]||jQuery.cssHooks[s];if(a&&"get"in a){i=a.get(e,true,n)}if(i===undefined){i=ze(e,t,r)}if(i==="normal"&&t in et){i=et[t]}if(n===""||n){o=parseFloat(i);return n===true||isFinite(o)?o||0:i}return i}});jQuery.each(["height","width"],function(e,t){jQuery.cssHooks[t]={get:function(e,n,r){if(n){return Je.test(jQuery.css(e,"display"))&&(!e.getClientRects().length||!e.getBoundingClientRect().width)?_e(e,Ze,function(){return rt(e,t,r)}):rt(e,t,r)}},set:function(e,n,r){var i,o=Be(e),a=!p.scrollboxSize()&&o.position==="absolute",s=a||r,u=s&&jQuery.css(e,"boxSizing",false,o)==="border-box",f=r?nt(e,t,r,u,o):0;if(u&&a){f-=Math.ceil(e["offset"+t[0].toUpperCase()+t.slice(1)]-parseFloat(o[t])-nt(e,t,"border",false,o)-.5)}if(f&&(i=re.exec(n))&&(i[3]||"px")!=="px"){e.style[t]=n;n=jQuery.css(e,t)}return tt(e,n,f)}}});jQuery.cssHooks.marginLeft=Xe(p.reliableMarginLeft,function(e,t){if(t){return(parseFloat(ze(e,"marginLeft"))||e.getBoundingClientRect().left-_e(e,{marginLeft:0},function(){return e.getBoundingClientRect().left}))+"px"}});jQuery.each({margin:"",padding:"",border:"Width"},function(e,t){jQuery.cssHooks[e+t]={expand:function(n){var r=0,i={},o=typeof n==="string"?n.split(" "):[n];for(;r<4;r++){i[e+ie[r]+t]=o[r]||o[r-2]||o[0]}return i}};if(e!=="margin"){jQuery.cssHooks[e+t].set=tt}});jQuery.fn.extend({css:function(e,t){return $(this,function(e,t,n){var r,i,o={},a=0;if(Array.isArray(t)){r=Be(e);i=t.length;for(;a<i;a++){o[t[a]]=jQuery.css(e,t[a],false,r)}return o}return n!==undefined?jQuery.style(e,t,n):jQuery.css(e,t)},e,t,arguments.length>1)}});function it(e,t,n,r,i){return new it.prototype.init(e,t,n,r,i)}jQuery.Tween=it;it.prototype={constructor:it,init:function(e,t,n,r,i,o){this.elem=e;this.prop=n;this.easing=i||jQuery.easing._default;this.options=t;this.start=this.now=this.cur();this.end=r;this.unit=o||(jQuery.cssNumber[n]?"":"px")},cur:function(){var e=it.propHooks[this.prop];return e&&e.get?e.get(this):it.propHooks._default.get(this)},run:function(e){var t,n=it.propHooks[this.prop];if(this.options.duration){this.pos=t=jQuery.easing[this.easing](e,this.options.duration*e,0,1,this.options.duration)}else{this.pos=t=e}this.now=(this.end-this.start)*t+this.start;if(this.options.step){this.options.step.call(this.elem,this.now,this)}if(n&&n.set){n.set(this)}else{it.propHooks._default.set(this)}return this}};it.prototype.init.prototype=it.prototype;it.propHooks={_default:{get:function(e){var t;if(e.elem.nodeType!==1||e.elem[e.prop]!=null&&e.elem.style[e.prop]==null){return e.elem[e.prop]}t=jQuery.css(e.elem,e.prop,"");return!t||t==="auto"?0:t},set:function(e){if(jQuery.fx.step[e.prop]){jQuery.fx.step[e.prop](e)}else if(e.elem.nodeType===1&&(jQuery.cssHooks[e.prop]||e.elem.style[Ye(e.prop)]!=null)){jQuery.style(e.elem,e.prop,e.now+e.unit)}else{e.elem[e.prop]=e.now}}}};it.propHooks.scrollTop=it.propHooks.scrollLeft={set:function(e){if(e.elem.nodeType&&e.elem.parentNode){e.elem[e.prop]=e.now}}};jQuery.easing={linear:function(e){return e},swing:function(e){return.5-Math.cos(e*Math.PI)/2},_default:"swing"};jQuery.fx=it.prototype.init;jQuery.fx.step={};var ot,at,st=/^(?:toggle|show|hide)$/,ut=/queueHooks$/;function ft(){if(at){if(y.hidden===false&&e.requestAnimationFrame){e.requestAnimationFrame(ft)}else{e.setTimeout(ft,jQuery.fx.interval)}jQuery.fx.tick()}}function lt(){e.setTimeout(function(){ot=undefined});return ot=Date.now()}function ct(e,t){var n,r=0,i={height:e};t=t?1:0;for(;r<4;r+=2-t){n=ie[r];i["margin"+n]=i["padding"+n]=e}if(t){i.opacity=i.width=e}return i}function dt(e,t,n){var r,i=(gt.tweeners[t]||[]).concat(gt.tweeners["*"]),o=0,a=i.length;for(;o<a;o++){if(r=i[o].call(n,t,e)){return r}}}function pt(e,t,n){var r,i,o,a,s,u,f,l,c="width"in t||"height"in t,d=this,p={},h=e.style,g=e.nodeType&&ue(e),y=Y.get(e,"fxshow");if(!n.queue){a=jQuery._queueHooks(e,"fx");if(a.unqueued==null){a.unqueued=0;s=a.empty.fire;a.empty.fire=function(){if(!a.unqueued){s()}}}a.unqueued++;d.always(function(){d.always(function(){a.unqueued--;if(!jQuery.queue(e,"fx").length){a.empty.fire()}})})}for(r in t){i=t[r];if(st.test(i)){delete t[r];o=o||i==="toggle";if(i===(g?"hide":"show")){if(i==="show"&&y&&y[r]!==undefined){g=true}else{continue}}p[r]=y&&y[r]||jQuery.style(e,r)}}u=!jQuery.isEmptyObject(t);if(!u&&jQuery.isEmptyObject(p)){return}if(c&&e.nodeType===1){n.overflow=[h.overflow,h.overflowX,h.overflowY];f=y&&y.display;if(f==null){f=Y.get(e,"display")}l=jQuery.css(e,"display");if(l==="none"){if(f){l=f}else{de([e],true);f=e.style.display||f;l=jQuery.css(e,"display");de([e])}}if(l==="inline"||l==="inline-block"&&f!=null){if(jQuery.css(e,"float")==="none"){if(!u){d.done(function(){h.display=f});if(f==null){l=h.display;f=l==="none"?"":l}}h.display="inline-block"}}}if(n.overflow){h.overflow="hidden";d.always(function(){h.overflow=n.overflow[0];h.overflowX=n.overflow[1];h.overflowY=n.overflow[2]})}u=false;for(r in p){if(!u){if(y){if("hidden"in y){g=y.hidden}}else{y=Y.access(e,"fxshow",{display:f})}if(o){y.hidden=!g}if(g){de([e],true)}d.done(function(){if(!g){de([e])}Y.remove(e,"fxshow");for(r in p){jQuery.style(e,r,p[r])}})}u=dt(g?y[r]:0,r,d);if(!(r in y)){y[r]=u.start;if(g){u.end=u.start;u.start=0}}}}function ht(e,t){var n,r,i,o,a;for(n in e){r=Q(n);i=t[r];o=e[n];if(Array.isArray(o)){i=o[1];o=e[n]=o[0]}if(n!==r){e[r]=o;delete e[n]}a=jQuery.cssHooks[r];if(a&&"expand"in a){o=a.expand(o);delete e[r];for(n in o){if(!(n in e)){e[n]=o[n];t[n]=i}}}else{t[r]=i}}}function gt(e,t,n){var r,i,o=0,a=gt.prefilters.length,s=jQuery.Deferred().always(function(){delete u.elem}),u=function(){if(i){return false}var t=ot||lt(),n=Math.max(0,f.startTime+f.duration-t),r=n/f.duration||0,o=1-r,a=0,u=f.tweens.length;for(;a<u;a++){f.tweens[a].run(o)}s.notifyWith(e,[f,o,n]);if(o<1&&u){return n}if(!u){s.notifyWith(e,[f,1,0])}s.resolveWith(e,[f]);return false},f=s.promise({elem:e,props:jQuery.extend({},t),opts:jQuery.extend(true,{specialEasing:{},easing:jQuery.easing._default},n),originalProperties:t,originalOptions:n,startTime:ot||lt(),duration:n.duration,tweens:[],createTween:function(t,n){var r=jQuery.Tween(e,f.opts,t,n,f.opts.specialEasing[t]||f.opts.easing);f.tweens.push(r);return r},stop:function(t){var n=0,r=t?f.tweens.length:0;if(i){return this}i=true;for(;n<r;n++){f.tweens[n].run(1)}if(t){s.notifyWith(e,[f,1,0]);s.resolveWith(e,[f,t])}else{s.rejectWith(e,[f,t])}return this}}),l=f.props;ht(l,f.opts.specialEasing);for(;o<a;o++){r=gt.prefilters[o].call(f,e,l,f.opts);if(r){if(h(r.stop)){jQuery._queueHooks(f.elem,f.opts.queue).stop=r.stop.bind(r)}return r}}jQuery.map(l,dt,f);if(h(f.opts.start)){f.opts.start.call(e,f)}f.progress(f.opts.progress).done(f.opts.done,f.opts.complete).fail(f.opts.fail).always(f.opts.always);jQuery.fx.timer(jQuery.extend(u,{elem:e,anim:f,queue:f.opts.queue}));return f}jQuery.Animation=jQuery.extend(gt,{tweeners:{"*":[function(e,t){var n=this.createTween(e,t);fe(n.elem,e,re.exec(t),n);return n}]},tweener:function(e,t){if(h(e)){t=e;e=["*"]}else{e=e.match(P)}var n,r=0,i=e.length;for(;r<i;r++){n=e[r];gt.tweeners[n]=gt.tweeners[n]||[];gt.tweeners[n].unshift(t)}},prefilters:[pt],prefilter:function(e,t){if(t){gt.prefilters.unshift(e)}else{gt.prefilters.push(e)}}});jQuery.speed=function(e,t,n){var r=e&&typeof e==="object"?jQuery.extend({},e):{complete:n||!n&&t||h(e)&&e,duration:e,easing:n&&t||t&&!h(t)&&t};if(jQuery.fx.off){r.duration=0}else{if(typeof r.duration!=="number"){if(r.duration in jQuery.fx.speeds){r.duration=jQuery.fx.speeds[r.duration]}else{r.duration=jQuery.fx.speeds._default}}}if(r.queue==null||r.queue===true){r.queue="fx"}r.old=r.complete;r.complete=function(){if(h(r.old)){r.old.call(this)}if(r.queue){jQuery.dequeue(this,r.queue)}};return r};jQuery.fn.extend({fadeTo:function(e,t,n,r){return this.filter(ue).css("opacity",0).show().end().animate({opacity:t},e,n,r)},animate:function(e,t,n,r){var i=jQuery.isEmptyObject(e),o=jQuery.speed(t,n,r),a=function(){var t=gt(this,jQuery.extend({},e),o);if(i||Y.get(this,"finish")){t.stop(true)}};a.finish=a;return i||o.queue===false?this.each(a):this.queue(o.queue,a)},stop:function(e,t,n){var r=function(e){var t=e.stop;delete e.stop;t(n)};if(typeof e!=="string"){n=t;t=e;e=undefined}if(t){this.queue(e||"fx",[])}return this.each(function(){var t=true,i=e!=null&&e+"queueHooks",o=jQuery.timers,a=Y.get(this);if(i){if(a[i]&&a[i].stop){r(a[i])}}else{for(i in a){if(a[i]&&a[i].stop&&ut.test(i)){r(a[i])}}}for(i=o.length;i--;){if(o[i].elem===this&&(e==null||o[i].queue===e)){o[i].anim.stop(n);t=false;o.splice(i,1)}}if(t||!n){jQuery.dequeue(this,e)}})},finish:function(e){if(e!==false){e=e||"fx"}return this.each(function(){var t,n=Y.get(this),r=n[e+"queue"],i=n[e+"queueHooks"],o=jQuery.timers,a=r?r.length:0;n.finish=true;jQuery.queue(this,e,[]);if(i&&i.stop){i.stop.call(this,true)}for(t=o.length;t--;){if(o[t].elem===this&&o[t].queue===e){o[t].anim.stop(true);o.splice(t,1)}}for(t=0;t<a;t++){if(r[t]&&r[t].finish){r[t].finish.call(this)}}delete n.finish})}});jQuery.each(["toggle","show","hide"],function(e,t){var n=jQuery.fn[t];jQuery.fn[t]=function(e,r,i){return e==null||typeof e==="boolean"?n.apply(this,arguments):this.animate(ct(t,true),e,r,i)}});jQuery.each({slideDown:ct("show"),slideUp:ct("hide"),slideToggle:ct("toggle"),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},function(e,t){jQuery.fn[e]=function(e,n,r){return this.animate(t,e,n,r)}});jQuery.timers=[];jQuery.fx.tick=function(){var e,t=0,n=jQuery.timers;ot=Date.now();for(;t<n.length;t++){e=n[t];if(!e()&&n[t]===e){n.splice(t--,1)}}if(!n.length){jQuery.fx.stop()}ot=undefined};jQuery.fx.timer=function(e){jQuery.timers.push(e);jQuery.fx.start()};jQuery.fx.interval=13;jQuery.fx.start=function(){if(at){return}at=true;ft()};jQuery.fx.stop=function(){at=null};jQuery.fx.speeds={slow:600,fast:200,_default:400};jQuery.fn.delay=function(t,n){t=jQuery.fx?jQuery.fx.speeds[t]||t:t;n=n||"fx";return this.queue(n,function(n,r){var i=e.setTimeout(n,t);r.stop=function(){e.clearTimeout(i)}})};(function(){var e=y.createElement("input"),t=y.createElement("select"),n=t.appendChild(y.createElement("option"));e.type="checkbox";p.checkOn=e.value!=="";p.optSelected=n.selected;e=y.createElement("input");e.value="t";e.type="radio";p.radioValue=e.value==="t"})();var yt,mt=jQuery.expr.attrHandle;jQuery.fn.extend({attr:function(e,t){return $(this,jQuery.attr,e,t,arguments.length>1)},removeAttr:function(e){return this.each(function(){jQuery.removeAttr(this,e)})}});jQuery.extend({attr:function(e,t,n){var r,i,o=e.nodeType;if(o===3||o===8||o===2){return}if(typeof e.getAttribute==="undefined"){return jQuery.prop(e,t,n)}if(o!==1||!jQuery.isXMLDoc(e)){i=jQuery.attrHooks[t.toLowerCase()]||(jQuery.expr.match.bool.test(t)?yt:undefined)}if(n!==undefined){if(n===null){jQuery.removeAttr(e,t);return}if(i&&"set"in i&&(r=i.set(e,n,t))!==undefined){return r}e.setAttribute(t,n+"");return n}if(i&&"get"in i&&(r=i.get(e,t))!==null){return r}r=jQuery.find.attr(e,t);return r==null?undefined:r},attrHooks:{type:{set:function(e,t){if(!p.radioValue&&t==="radio"&&S(e,"input")){var n=e.value;e.setAttribute("type",t);if(n){e.value=n}return t}}},style:{set:function(e,t){return e.style=t+""}}},removeAttr:function(e,t){var n,r=0,i=t&&t.match(P);if(i&&e.nodeType===1){while(n=i[r++]){if(n==="style"){e.style=""}else{e.removeAttribute(n)}}}}});yt={set:function(e,t,n){if(t===false){jQuery.removeAttr(e,n)}else{e.setAttribute(n,n)}return n}};jQuery.each(jQuery.expr.match.bool.source.match(/\w+/g),function(e,t){var n=mt[t]||jQuery.find.attr;mt[t]=function(e,t,r){var i,o,a=t.toLowerCase();if(!r){o=mt[a];mt[a]=i;i=n(e,t,r)!=null?a:null;mt[a]=o}return i}});var vt=/^(?:input|select|textarea|button)$/i,xt=/^(?:a|area)$/i;jQuery.fn.extend({prop:function(e,t){return $(this,jQuery.prop,e,t,arguments.length>1)},removeProp:function(e){return this.each(function(){delete this[jQuery.propFix[e]||e]})}});jQuery.extend({prop:function(e,t,n){var r,i,o=e.nodeType;if(o===3||o===8||o===2){return}if(o!==1||!jQuery.isXMLDoc(e)){t=jQuery.propFix[t]||t;i=jQuery.propHooks[t]}if(n!==undefined){if(i&&"set"in i&&(r=i.set(e,n,t))!==undefined){return r}return e[t]=n}if(i&&"get"in i&&(r=i.get(e,t))!==null){return r}return e[t]},propHooks:{tabIndex:{get:function(e){var t=jQuery.find.attr(e,"tabindex");if(t){return parseInt(t,10)}if(vt.test(e.nodeName)||xt.test(e.nodeName)&&e.href){return 0}return-1}}},propFix:{for:"htmlFor",class:"className"}});if(!p.optSelected){jQuery.propHooks.selected={get:function(e){var t=e.parentNode;if(t&&t.parentNode){t.parentNode.selectedIndex}return null},set:function(e){var t=e.parentNode;if(t){t.selectedIndex;if(t.parentNode){t.parentNode.selectedIndex}}}}}jQuery.each(["tabIndex","readOnly","maxLength","cellSpacing","cellPadding","rowSpan","colSpan","useMap","frameBorder","contentEditable"],function(){jQuery.propFix[this.toLowerCase()]=this});function bt(e){var t=e.match(P)||[];return t.join(" ")}function wt(e){return e.getAttribute&&e.getAttribute("class")||""}function Tt(e){if(Array.isArray(e)){return e}if(typeof e==="string"){return e.match(P)||[]}return[]}jQuery.fn.extend({addClass:function(e){var t,n,r,i,o,a,s,u=0;if(h(e)){return this.each(function(t){jQuery(this).addClass(e.call(this,t,wt(this)))})}t=Tt(e);if(t.length){while(n=this[u++]){i=wt(n);r=n.nodeType===1&&" "+bt(i)+" ";if(r){a=0;while(o=t[a++]){if(r.indexOf(" "+o+" ")<0){r+=o+" "}}s=bt(r);if(i!==s){n.setAttribute("class",s)}}}}return this},removeClass:function(e){var t,n,r,i,o,a,s,u=0;if(h(e)){return this.each(function(t){jQuery(this).removeClass(e.call(this,t,wt(this)))})}if(!arguments.length){return this.attr("class","")}t=Tt(e);if(t.length){while(n=this[u++]){i=wt(n);r=n.nodeType===1&&" "+bt(i)+" ";if(r){a=0;while(o=t[a++]){while(r.indexOf(" "+o+" ")>-1){r=r.replace(" "+o+" "," ")}}s=bt(r);if(i!==s){n.setAttribute("class",s)}}}}return this},toggleClass:function(e,t){var n=typeof e,r=n==="string"||Array.isArray(e);if(typeof t==="boolean"&&r){return t?this.addClass(e):this.removeClass(e)}if(h(e)){return this.each(function(n){jQuery(this).toggleClass(e.call(this,n,wt(this),t),t)})}return this.each(function(){var t,i,o,a;if(r){i=0;o=jQuery(this);a=Tt(e);while(t=a[i++]){if(o.hasClass(t)){o.removeClass(t)}else{o.addClass(t)}}}else if(e===undefined||n==="boolean"){t=wt(this);if(t){Y.set(this,"__className__",t)}if(this.setAttribute){this.setAttribute("class",t||e===false?"":Y.get(this,"__className__")||"")}}})},hasClass:function(e){var t,n,r=0;t=" "+e+" ";while(n=this[r++]){if(n.nodeType===1&&(" "+bt(wt(n))+" ").indexOf(t)>-1){return true}}return false}});var Ct=/\r/g;jQuery.fn.extend({val:function(e){var t,n,r,i=this[0];if(!arguments.length){if(i){t=jQuery.valHooks[i.type]||jQuery.valHooks[i.nodeName.toLowerCase()];if(t&&"get"in t&&(n=t.get(i,"value"))!==undefined){return n}n=i.value;if(typeof n==="string"){return n.replace(Ct,"")}return n==null?"":n}return}r=h(e);return this.each(function(n){var i;if(this.nodeType!==1){return}if(r){i=e.call(this,n,jQuery(this).val())}else{i=e}if(i==null){i=""}else if(typeof i==="number"){i+=""}else if(Array.isArray(i)){i=jQuery.map(i,function(e){return e==null?"":e+""})}t=jQuery.valHooks[this.type]||jQuery.valHooks[this.nodeName.toLowerCase()];if(!t||!("set"in t)||t.set(this,i,"value")===undefined){this.value=i}})}});jQuery.extend({valHooks:{option:{get:function(e){var t=jQuery.find.attr(e,"value");return t!=null?t:bt(jQuery.text(e))}},select:{get:function(e){var t,n,r,i=e.options,o=e.selectedIndex,a=e.type==="select-one",s=a?null:[],u=a?o+1:i.length;if(o<0){r=u}else{r=a?o:0}for(;r<u;r++){n=i[r];if((n.selected||r===o)&&!n.disabled&&(!n.parentNode.disabled||!S(n.parentNode,"optgroup"))){t=jQuery(n).val();if(a){return t}s.push(t)}}return s},set:function(e,t){var n,r,i=e.options,o=jQuery.makeArray(t),a=i.length;while(a--){r=i[a];if(r.selected=jQuery.inArray(jQuery.valHooks.option.get(r),o)>-1){n=true}}if(!n){e.selectedIndex=-1}return o}}}});jQuery.each(["radio","checkbox"],function(){jQuery.valHooks[this]={set:function(e,t){if(Array.isArray(t)){return e.checked=jQuery.inArray(jQuery(e).val(),t)>-1}}};if(!p.checkOn){jQuery.valHooks[this].get=function(e){return e.getAttribute("value")===null?"on":e.value}}});var kt=/^(?:focusinfocus|focusoutblur)$/,Et=function(e){e.stopPropagation()};jQuery.extend(jQuery.event,{trigger:function(t,n,r,i){var o,a,s,u,f,c,d,p,m=[r||y],v=l.call(t,"type")?t.type:t,x=l.call(t,"namespace")?t.namespace.split("."):[];a=p=s=r=r||y;if(r.nodeType===3||r.nodeType===8){return}if(kt.test(v+jQuery.event.triggered)){return}if(v.indexOf(".")>-1){x=v.split(".");v=x.shift();x.sort()}f=v.indexOf(":")<0&&"on"+v;t=t[jQuery.expando]?t:new jQuery.Event(v,typeof t==="object"&&t);t.isTrigger=i?2:3;t.namespace=x.join(".");t.rnamespace=t.namespace?new RegExp("(^|\\.)"+x.join("\\.(?:.*\\.|)")+"(\\.|$)"):null;t.result=undefined;if(!t.target){t.target=r}n=n==null?[t]:jQuery.makeArray(n,[t]);d=jQuery.event.special[v]||{};if(!i&&d.trigger&&d.trigger.apply(r,n)===false){return}if(!i&&!d.noBubble&&!g(r)){u=d.delegateType||v;if(!kt.test(u+v)){a=a.parentNode}for(;a;a=a.parentNode){m.push(a);s=a}if(s===(r.ownerDocument||y)){m.push(s.defaultView||s.parentWindow||e)}}o=0;while((a=m[o++])&&!t.isPropagationStopped()){p=a;t.type=o>1?u:d.bindType||v;c=(Y.get(a,"events")||Object.create(null))[t.type]&&Y.get(a,"handle");if(c){c.apply(a,n)}c=f&&a[f];if(c&&c.apply&&V(a)){t.result=c.apply(a,n);if(t.result===false){t.preventDefault()}}}t.type=v;if(!i&&!t.isDefaultPrevented()){if((!d._default||d._default.apply(m.pop(),n)===false)&&V(r)){if(f&&h(r[v])&&!g(r)){s=r[f];if(s){r[f]=null}jQuery.event.triggered=v;if(t.isPropagationStopped()){p.addEventListener(v,Et)}r[v]();if(t.isPropagationStopped()){p.removeEventListener(v,Et)}jQuery.event.triggered=undefined;if(s){r[f]=s}}}}return t.result},simulate:function(e,t,n){var r=jQuery.extend(new jQuery.Event,n,{type:e,isSimulated:true});jQuery.event.trigger(r,null,t)}});jQuery.fn.extend({trigger:function(e,t){return this.each(function(){jQuery.event.trigger(e,t,this)})},triggerHandler:function(e,t){var n=this[0];if(n){return jQuery.event.trigger(e,t,n,true)}}});var St=e.location;var At={guid:Date.now()};var jt=/\?/;jQuery.parseXML=function(t){var n,r;if(!t||typeof t!=="string"){return null}try{n=(new e.DOMParser).parseFromString(t,"text/xml")}catch(e){}r=n&&n.getElementsByTagName("parsererror")[0];if(!n||r){jQuery.error("Invalid XML: "+(r?jQuery.map(r.childNodes,function(e){return e.textContent}).join("\n"):t))}return n};var Nt=/\[\]$/,Dt=/\r?\n/g,qt=/^(?:submit|button|image|reset|file)$/i,Lt=/^(?:input|select|textarea|keygen)/i;function Ht(e,t,n,r){var i;if(Array.isArray(t)){jQuery.each(t,function(t,i){if(n||Nt.test(e)){r(e,i)}else{Ht(e+"["+(typeof i==="object"&&i!=null?t:"")+"]",i,n,r)}})}else if(!n&&x(t)==="object"){for(i in t){Ht(e+"["+i+"]",t[i],n,r)}}else{r(e,t)}}jQuery.param=function(e,t){var n,r=[],i=function(e,t){var n=h(t)?t():t;r[r.length]=encodeURIComponent(e)+"="+encodeURIComponent(n==null?"":n)};if(e==null){return""}if(Array.isArray(e)||e.jquery&&!jQuery.isPlainObject(e)){jQuery.each(e,function(){i(this.name,this.value)})}else{for(n in e){Ht(n,e[n],t,i)}}return r.join("&")};jQuery.fn.extend({serialize:function(){return jQuery.param(this.serializeArray())},serializeArray:function(){return this.map(function(){var e=jQuery.prop(this,"elements");return e?jQuery.makeArray(e):this}).filter(function(){var e=this.type;return this.name&&!jQuery(this).is(":disabled")&&Lt.test(this.nodeName)&&!qt.test(e)&&(this.checked||!pe.test(e))}).map(function(e,t){var n=jQuery(this).val();if(n==null){return null}if(Array.isArray(n)){return jQuery.map(n,function(e){return{name:t.name,value:e.replace(Dt,"\r\n")}})}return{name:t.name,value:n.replace(Dt,"\r\n")}}).get()}});var Ot=/%20/g,Pt=/#.*$/,Rt=/([?&])_=[^&]*/,Mt=/^(.*?):[ \t]*([^\r\n]*)$/gm,It=/^(?:about|app|app-storage|.+-extension|file|res|widget):$/,Wt=/^(?:GET|HEAD)$/,Ft=/^\/\//,Bt={},_t={},$t="*/".concat("*"),zt=y.createElement("a");zt.href=St.href;function Xt(e){return function(t,n){if(typeof t!=="string"){n=t;t="*"}var r,i=0,o=t.toLowerCase().match(P)||[];if(h(n)){while(r=o[i++]){if(r[0]==="+"){r=r.slice(1)||"*";(e[r]=e[r]||[]).unshift(n)}else{(e[r]=e[r]||[]).push(n)}}}}}function Ut(e,t,n,r){var i={},o=e===_t;function a(s){var u;i[s]=true;jQuery.each(e[s]||[],function(e,s){var f=s(t,n,r);if(typeof f==="string"&&!o&&!i[f]){t.dataTypes.unshift(f);a(f);return false}else if(o){return!(u=f)}});return u}return a(t.dataTypes[0])||!i["*"]&&a("*")}function Qt(e,t){var n,r,i=jQuery.ajaxSettings.flatOptions||{};for(n in t){if(t[n]!==undefined){(i[n]?e:r||(r={}))[n]=t[n]}}if(r){jQuery.extend(true,e,r)}return e}function Vt(e,t,n){var r,i,o,a,s=e.contents,u=e.dataTypes;while(u[0]==="*"){u.shift();if(r===undefined){r=e.mimeType||t.getResponseHeader("Content-Type")}}if(r){for(i in s){if(s[i]&&s[i].test(r)){u.unshift(i);break}}}if(u[0]in n){o=u[0]}else{for(i in n){if(!u[0]||e.converters[i+" "+u[0]]){o=i;break}if(!a){a=i}}o=o||a}if(o){if(o!==u[0]){u.unshift(o)}return n[o]}}function Gt(e,t,n,r){var i,o,a,s,u,f={},l=e.dataTypes.slice();if(l[1]){for(a in e.converters){f[a.toLowerCase()]=e.converters[a]}}o=l.shift();while(o){if(e.responseFields[o]){n[e.responseFields[o]]=t}if(!u&&r&&e.dataFilter){t=e.dataFilter(t,e.dataType)}u=o;o=l.shift();if(o){if(o==="*"){o=u}else if(u!=="*"&&u!==o){a=f[u+" "+o]||f["* "+o];if(!a){for(i in f){s=i.split(" ");if(s[1]===o){a=f[u+" "+s[0]]||f["* "+s[0]];if(a){if(a===true){a=f[i]}else if(f[i]!==true){o=s[0];l.unshift(s[1])}break}}}}if(a!==true){if(a&&e.throws){t=a(t)}else{try{t=a(t)}catch(e){return{state:"parsererror",error:a?e:"No conversion from "+u+" to "+o}}}}}}}return{state:"success",data:t}}jQuery.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:St.href,type:"GET",isLocal:It.test(St.protocol),global:true,processData:true,async:true,contentType:"application/x-www-form-urlencoded; charset=UTF-8",accepts:{"*":$t,text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript"},contents:{xml:/\bxml\b/,html:/\bhtml/,json:/\bjson\b/},responseFields:{xml:"responseXML",text:"responseText",json:"responseJSON"},converters:{"* text":String,"text html":true,"text json":JSON.parse,"text xml":jQuery.parseXML},flatOptions:{url:true,context:true}},ajaxSetup:function(e,t){return t?Qt(Qt(e,jQuery.ajaxSettings),t):Qt(jQuery.ajaxSettings,e)},ajaxPrefilter:Xt(Bt),ajaxTransport:Xt(_t),ajax:function(t,n){if(typeof t==="object"){n=t;t=undefined}n=n||{};var r,i,o,a,s,u,f,l,c,d,p=jQuery.ajaxSetup({},n),h=p.context||p,g=p.context&&(h.nodeType||h.jquery)?jQuery(h):jQuery.event,m=jQuery.Deferred(),v=jQuery.Callbacks("once memory"),x=p.statusCode||{},b={},w={},T="canceled",C={readyState:0,getResponseHeader:function(e){var t;if(f){if(!a){a={};while(t=Mt.exec(o)){a[t[1].toLowerCase()+" "]=(a[t[1].toLowerCase()+" "]||[]).concat(t[2])}}t=a[e.toLowerCase()+" "]}return t==null?null:t.join(", ")},getAllResponseHeaders:function(){return f?o:null},setRequestHeader:function(e,t){if(f==null){e=w[e.toLowerCase()]=w[e.toLowerCase()]||e;b[e]=t}return this},overrideMimeType:function(e){if(f==null){p.mimeType=e}return this},statusCode:function(e){var t;if(e){if(f){C.always(e[C.status])}else{for(t in e){x[t]=[x[t],e[t]]}}}return this},abort:function(e){var t=e||T;if(r){r.abort(t)}k(0,t);return this}};m.promise(C);p.url=((t||p.url||St.href)+"").replace(Ft,St.protocol+"//");p.type=n.method||n.type||p.method||p.type;p.dataTypes=(p.dataType||"*").toLowerCase().match(P)||[""];if(p.crossDomain==null){u=y.createElement("a");try{u.href=p.url;u.href=u.href;p.crossDomain=zt.protocol+"//"+zt.host!==u.protocol+"//"+u.host}catch(e){p.crossDomain=true}}if(p.data&&p.processData&&typeof p.data!=="string"){p.data=jQuery.param(p.data,p.traditional)}Ut(Bt,p,n,C);if(f){return C}l=jQuery.event&&p.global;if(l&&jQuery.active++===0){jQuery.event.trigger("ajaxStart")}p.type=p.type.toUpperCase();p.hasContent=!Wt.test(p.type);i=p.url.replace(Pt,"");if(!p.hasContent){d=p.url.slice(i.length);if(p.data&&(p.processData||typeof p.data==="string")){i+=(jt.test(i)?"&":"?")+p.data;delete p.data}if(p.cache===false){i=i.replace(Rt,"$1");d=(jt.test(i)?"&":"?")+"_="+At.guid+++d}p.url=i+d}else if(p.data&&p.processData&&(p.contentType||"").indexOf("application/x-www-form-urlencoded")===0){p.data=p.data.replace(Ot,"+")}if(p.ifModified){if(jQuery.lastModified[i]){C.setRequestHeader("If-Modified-Since",jQuery.lastModified[i])}if(jQuery.etag[i]){C.setRequestHeader("If-None-Match",jQuery.etag[i])}}if(p.data&&p.hasContent&&p.contentType!==false||n.contentType){C.setRequestHeader("Content-Type",p.contentType)}C.setRequestHeader("Accept",p.dataTypes[0]&&p.accepts[p.dataTypes[0]]?p.accepts[p.dataTypes[0]]+(p.dataTypes[0]!=="*"?", "+$t+"; q=0.01":""):p.accepts["*"]);for(c in p.headers){C.setRequestHeader(c,p.headers[c])}if(p.beforeSend&&(p.beforeSend.call(h,C,p)===false||f)){return C.abort()}T="abort";v.add(p.complete);C.done(p.success);C.fail(p.error);r=Ut(_t,p,n,C);if(!r){k(-1,"No Transport")}else{C.readyState=1;if(l){g.trigger("ajaxSend",[C,p])}if(f){return C}if(p.async&&p.timeout>0){s=e.setTimeout(function(){C.abort("timeout")},p.timeout)}try{f=false;r.send(b,k)}catch(e){if(f){throw e}k(-1,e)}}function k(t,n,a,u){var c,d,y,b,w,T=n;if(f){return}f=true;if(s){e.clearTimeout(s)}r=undefined;o=u||"";C.readyState=t>0?4:0;c=t>=200&&t<300||t===304;if(a){b=Vt(p,C,a)}if(!c&&jQuery.inArray("script",p.dataTypes)>-1&&jQuery.inArray("json",p.dataTypes)<0){p.converters["text script"]=function(){}}b=Gt(p,b,C,c);if(c){if(p.ifModified){w=C.getResponseHeader("Last-Modified");if(w){jQuery.lastModified[i]=w}w=C.getResponseHeader("etag");if(w){jQuery.etag[i]=w}}if(t===204||p.type==="HEAD"){T="nocontent"}else if(t===304){T="notmodified"}else{T=b.state;d=b.data;y=b.error;c=!y}}else{y=T;if(t||!T){T="error";if(t<0){t=0}}}C.status=t;C.statusText=(n||T)+"";if(c){m.resolveWith(h,[d,T,C])}else{m.rejectWith(h,[C,T,y])}C.statusCode(x);x=undefined;if(l){g.trigger(c?"ajaxSuccess":"ajaxError",[C,p,c?d:y])}v.fireWith(h,[C,T]);if(l){g.trigger("ajaxComplete",[C,p]);if(! --jQuery.active){jQuery.event.trigger("ajaxStop")}}}return C},getJSON:function(e,t,n){return jQuery.get(e,t,n,"json")},getScript:function(e,t){return jQuery.get(e,undefined,t,"script")}});jQuery.each(["get","post"],function(e,t){jQuery[t]=function(e,n,r,i){if(h(n)){i=i||r;r=n;n=undefined}return jQuery.ajax(jQuery.extend({url:e,type:t,dataType:i,data:n,success:r},jQuery.isPlainObject(e)&&e))}});jQuery.ajaxPrefilter(function(e){var t;for(t in e.headers){if(t.toLowerCase()==="content-type"){e.contentType=e.headers[t]||""}}});jQuery._evalUrl=function(e,t,n){return jQuery.ajax({url:e,type:"GET",dataType:"script",cache:true,async:false,global:false,converters:{"text script":function(){}},dataFilter:function(e){jQuery.globalEval(e,t,n)}})};jQuery.fn.extend({wrapAll:function(e){var t;if(this[0]){if(h(e)){e=e.call(this[0])}t=jQuery(e,this[0].ownerDocument).eq(0).clone(true);if(this[0].parentNode){t.insertBefore(this[0])}t.map(function(){var e=this;while(e.firstElementChild){e=e.firstElementChild}return e}).append(this)}return this},wrapInner:function(e){if(h(e)){return this.each(function(t){jQuery(this).wrapInner(e.call(this,t))})}return this.each(function(){var t=jQuery(this),n=t.contents();if(n.length){n.wrapAll(e)}else{t.append(e)}})},wrap:function(e){var t=h(e);return this.each(function(n){jQuery(this).wrapAll(t?e.call(this,n):e)})},unwrap:function(e){this.parent(e).not("body").each(function(){jQuery(this).replaceWith(this.childNodes)});return this}});jQuery.expr.pseudos.hidden=function(e){return!jQuery.expr.pseudos.visible(e)};jQuery.expr.pseudos.visible=function(e){return!!(e.offsetWidth||e.offsetHeight||e.getClientRects().length)};jQuery.ajaxSettings.xhr=function(){try{return new e.XMLHttpRequest}catch(e){}};var Yt={0:200,1223:204},Jt=jQuery.ajaxSettings.xhr();p.cors=!!Jt&&"withCredentials"in Jt;p.ajax=Jt=!!Jt;jQuery.ajaxTransport(function(t){var n,r;if(p.cors||Jt&&!t.crossDomain){return{send:function(i,o){var a,s=t.xhr();s.open(t.type,t.url,t.async,t.username,t.password);if(t.xhrFields){for(a in t.xhrFields){s[a]=t.xhrFields[a]}}if(t.mimeType&&s.overrideMimeType){s.overrideMimeType(t.mimeType)}if(!t.crossDomain&&!i["X-Requested-With"]){i["X-Requested-With"]="XMLHttpRequest"}for(a in i){s.setRequestHeader(a,i[a])}n=function(e){return function(){if(n){n=r=s.onload=s.onerror=s.onabort=s.ontimeout=s.onreadystatechange=null;if(e==="abort"){s.abort()}else if(e==="error"){if(typeof s.status!=="number"){o(0,"error")}else{o(s.status,s.statusText)}}else{o(Yt[s.status]||s.status,s.statusText,(s.responseType||"text")!=="text"||typeof s.responseText!=="string"?{binary:s.response}:{text:s.responseText},s.getAllResponseHeaders())}}}};s.onload=n();r=s.onerror=s.ontimeout=n("error");if(s.onabort!==undefined){s.onabort=r}else{s.onreadystatechange=function(){if(s.readyState===4){e.setTimeout(function(){if(n){r()}})}}}n=n("abort");try{s.send(t.hasContent&&t.data||null)}catch(e){if(n){throw e}}},abort:function(){if(n){n()}}}}});jQuery.ajaxPrefilter(function(e){if(e.crossDomain){e.contents.script=false}});jQuery.ajaxSetup({accepts:{script:"text/javascript, application/javascript, "+"application/ecmascript, application/x-ecmascript"},contents:{script:/\b(?:java|ecma)script\b/},converters:{"text script":function(e){jQuery.globalEval(e);return e}}});jQuery.ajaxPrefilter("script",function(e){if(e.cache===undefined){e.cache=false}if(e.crossDomain){e.type="GET"}});jQuery.ajaxTransport("script",function(e){if(e.crossDomain||e.scriptAttrs){var t,n;return{send:function(r,i){t=jQuery("<script>").attr(e.scriptAttrs||{}).prop({charset:e.scriptCharset,src:e.url}).on("load error",n=function(e){t.remove();n=null;if(e){i(e.type==="error"?404:200,e.type)}});y.head.appendChild(t[0])},abort:function(){if(n){n()}}}}});var Kt=[],Zt=/(=)\?(?=&|$)|\?\?/;jQuery.ajaxSetup({jsonp:"callback",jsonpCallback:function(){var e=Kt.pop()||jQuery.expando+"_"+At.guid++;this[e]=true;return e}});jQuery.ajaxPrefilter("json jsonp",function(t,n,r){var i,o,a,s=t.jsonp!==false&&(Zt.test(t.url)?"url":typeof t.data==="string"&&(t.contentType||"").indexOf("application/x-www-form-urlencoded")===0&&Zt.test(t.data)&&"data");if(s||t.dataTypes[0]==="jsonp"){i=t.jsonpCallback=h(t.jsonpCallback)?t.jsonpCallback():t.jsonpCallback;if(s){t[s]=t[s].replace(Zt,"$1"+i)}else if(t.jsonp!==false){t.url+=(jt.test(t.url)?"&":"?")+t.jsonp+"="+i}t.converters["script json"]=function(){if(!a){jQuery.error(i+" was not called")}return a[0]};t.dataTypes[0]="json";o=e[i];e[i]=function(){a=arguments};r.always(function(){if(o===undefined){jQuery(e).removeProp(i)}else{e[i]=o}if(t[i]){t.jsonpCallback=n.jsonpCallback;Kt.push(i)}if(a&&h(o)){o(a[0])}a=o=undefined});return"script"}});p.createHTMLDocument=function(){var e=y.implementation.createHTMLDocument("").body;e.innerHTML="<form></form><form></form>";return e.childNodes.length===2}();jQuery.parseHTML=function(e,t,n){if(typeof e!=="string"){return[]}if(typeof t==="boolean"){n=t;t=false}var r,i,o;if(!t){if(p.createHTMLDocument){t=y.implementation.createHTMLDocument("");if(t.domain!==y.domain){t.domain=y.domain}r=t.createElement("base");r.href=y.location.href;t.head.appendChild(r)}else{t=y}}i=A.exec(e);o=!n&&[];if(i){return[t.createElement(i[1])]}i=be([e],t,o);if(o&&o.length){jQuery(o).remove()}return jQuery.merge([],i.childNodes)};jQuery.fn.load=function(e,t,n){var r,i,o,a=this,s=e.indexOf(" ");if(s>-1){r=bt(e.slice(s));e=e.slice(0,s)}if(h(t)){n=t;t=undefined}else if(t&&typeof t==="object"){i="POST"}if(a.length>0){jQuery.ajax({url:e,type:i||"GET",dataType:"html",data:t}).done(function(e){o=arguments;a.html(r?jQuery("<div>").append(jQuery.parseHTML(e)).find(r):e)}).always(n&&function(e,t){a.each(function(){n.apply(this,o||[e.responseText,t,e])})})}return this};jQuery.expr.pseudos.animated=function(e){return jQuery.grep(jQuery.timers,function(t){return e===t.elem}).length};jQuery.offset={setOffset:function(e,t,n){var r,i,o,a,s,u,f,l=jQuery.css(e,"position"),c=jQuery(e),d={};if(l==="static"){e.style.position="relative"}s=c.offset();o=jQuery.css(e,"top");u=jQuery.css(e,"left");f=(l==="absolute"||l==="fixed")&&(o+u).indexOf("auto")>-1;if(f){r=c.position();a=r.top;i=r.left}else{a=parseFloat(o)||0;i=parseFloat(u)||0}if(h(t)){t=t.call(e,n,jQuery.extend({},s))}if(t.top!=null){d.top=t.top-s.top+a}if(t.left!=null){d.left=t.left-s.left+i}if("using"in t){t.using.call(e,d)}else{c.css(d)}}};p.safeBoundingClientRect=function(){var e=y.createElement("div");try{return!!e.getBoundingClientRect()}catch(e){return false}finally{e=null}}();jQuery.fn.extend({offset:function(e){if(arguments.length){return e===undefined?this:this.each(function(t){jQuery.offset.setOffset(this,e,t)})}var t,n,r=this[0];if(!r){return}if(!p.safeBoundingClientRect&&!r.getClientRects().length){return{top:0,left:0}}t=r.getBoundingClientRect();n=r.ownerDocument.defaultView;return{top:t.top+n.pageYOffset,left:t.left+n.pageXOffset}},position:function(){if(!this[0]){return}var e,t,n,r=this[0],i={top:0,left:0};if(jQuery.css(r,"position")==="fixed"){t=r.getBoundingClientRect()}else{t=this.offset();n=r.ownerDocument;e=this.offsetParent()[0];while(e&&(e===n.body||e===n.documentElement)&&jQuery.css(e,"position")==="static"){e=e.parentNode}if(e&&e!==r&&e.nodeType===1){i=jQuery(e).offset();i.top+=jQuery.css(e,"borderTopWidth",true);i.left+=jQuery.css(e,"borderLeftWidth",true)}}return{top:t.top-i.top-jQuery.css(r,"marginTop",true),left:t.left-i.left-jQuery.css(r,"marginLeft",true)}},offsetParent:function(){return this.map(function(){var e=this.offsetParent;while(e&&jQuery.css(e,"position")==="static"){e=e.offsetParent}return e||oe})}});jQuery.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},function(e,t){var n="pageYOffset"===t;jQuery.fn[e]=function(r){return $(this,function(e,r,i){var o;if(g(e)){o=e}else if(e.nodeType===9){o=e.defaultView}if(i===undefined){return o?o[t]:e[r]}if(o){o.scrollTo(!n?i:o.pageXOffset,n?i:o.pageYOffset)}else{e[r]=i}},e,r,arguments.length)}});jQuery.each(["top","left"],function(e,t){jQuery.cssHooks[t]=Xe(p.pixelPosition,function(e,n){if(n){n=ze(e,t);return Fe.test(n)?jQuery(e).position()[t]+"px":n}})});jQuery.each({Height:"height",Width:"width"},function(e,t){jQuery.each({padding:"inner"+e,content:t,"":"outer"+e},function(n,r){jQuery.fn[r]=function(i,o){var a=arguments.length&&(n||typeof i!=="boolean"),s=n||(i===true||o===true?"margin":"border");return $(this,function(t,n,i){var o;if(g(t)){return r.indexOf("outer")===0?t["inner"+e]:t.document.documentElement["client"+e]}if(t.nodeType===9){o=t.documentElement;return Math.max(t.body["scroll"+e],o["scroll"+e],t.body["offset"+e],o["offset"+e],o["client"+e])}return i===undefined?jQuery.css(t,n,s):jQuery.style(t,n,i,s)},t,a?i:undefined,a)}})});jQuery.each(["ajaxStart","ajaxStop","ajaxComplete","ajaxError","ajaxSuccess","ajaxSend"],function(e,t){jQuery.fn[t]=function(e){return this.on(t,e)}});jQuery.fn.extend({bind:function(e,t,n){return this.on(e,null,t,n)},unbind:function(e,t){return this.off(e,null,t)},delegate:function(e,t,n,r){return this.on(t,e,n,r)},undelegate:function(e,t,n){return arguments.length===1?this.off(e,"**"):this.off(t,e||"**",n)},hover:function(e,t){return this.mouseenter(e).mouseleave(t||e)}});jQuery.each(("blur focus focusin focusout resize scroll click dblclick "+"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave "+"change select submit keydown keypress keyup contextmenu").split(" "),function(e,t){jQuery.fn[t]=function(e,n){return arguments.length>0?this.on(t,null,e,n):this.trigger(t)}});var en=/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;jQuery.proxy=function(e,t){var n,r,o;if(typeof t==="string"){n=e[t];t=e;e=n}if(!h(e)){return undefined}r=i.call(arguments,2);o=function(){return e.apply(t||this,r.concat(i.call(arguments)))};o.guid=e.guid=e.guid||jQuery.guid++;return o};jQuery.holdReady=function(e){if(e){jQuery.readyWait++}else{jQuery.ready(true)}};jQuery.isArray=Array.isArray;jQuery.parseJSON=JSON.parse;jQuery.nodeName=S;jQuery.isFunction=h;jQuery.isWindow=g;jQuery.camelCase=Q;jQuery.type=x;jQuery.now=Date.now;jQuery.isNumeric=function(e){var t=jQuery.type(e);return(t==="number"||t==="string")&&!isNaN(e-parseFloat(e))};jQuery.trim=function(e){return e==null?"":(e+"").replace(en,"")};if(typeof define==="function"&&define.amd){define("jquery",[],function(){return jQuery})}var tn=e.jQuery,nn=e.$;jQuery.noConflict=function(t){if(e.$===jQuery){e.$=nn}if(t&&e.jQuery===jQuery){e.jQuery=tn}return jQuery};if(typeof t==="undefined"){e.jQuery=e.$=jQuery}return jQuery});if(window.sap&&window.sap.ui&&window.sap.ui._jQuery3Compat){sap.ui._jQuery3Compat._factory(jQuery,window)}
}
});
//# sourceMappingURL=Eventing-preload-1.js.map
