/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/now","sap/base/util/Version","sap/base/assert","sap/base/Log","sap/ui/dom/includeScript","sap/ui/dom/includeStylesheet","sap/ui/security/FrameOptions","sap/ui/performance/Measurement","sap/ui/performance/trace/Interaction","sap/base/util/LoaderExtensions","sap/ui/Device","sap/ui/thirdparty/jquery","ui5loader-autoconfig","jquery.sap.stubs"],function(now,Version,assert,Log,includeScript,includeStylesheet,FrameOptions,Measurement,Interaction,LoaderExtensions,Device,jQuery){"use strict";if(!jQuery){throw new Error("Loading of jQuery failed")}var ui5loader=sap.ui.loader;if(!ui5loader||!ui5loader._){throw new Error("The UI5 compatilbility module requires a UI5 specific AMD implementation")}var _ui5loader=ui5loader._;(function(){jQuery.support=jQuery.support||{};jQuery.support.retina=Device.support.retina;jQuery.support.touch=Device.support.touch;jQuery.support.cssTransforms=true;jQuery.support.cssTransforms3d=true;jQuery.support.cssTransitions=true;jQuery.support.cssAnimations=true;jQuery.support.cssGradients=true;jQuery.support.flexBoxPrefixed=false;jQuery.support.flexBoxLayout=false;jQuery.support.newFlexBoxLayout=true;jQuery.support.hasFlexBoxSupport=true})();jQuery.sap=jQuery.sap||{};jQuery.sap.Version=Version;jQuery.sap.now=now;var fnMakeLocalStorageAccessor=function(e,r,o){return function(t){try{if(t!=null||r==="string"){if(t){localStorage.setItem(e,r==="boolean"?"X":t)}else{localStorage.removeItem(e)}o(t)}t=localStorage.getItem(e);return r==="boolean"?t==="X":t}catch(r){Log.warning("Could not access localStorage while accessing '"+e+"' (value: '"+t+"', are cookies disabled?): "+r.message)}}};jQuery.sap.debug=fnMakeLocalStorageAccessor.call(this,"sap-ui-debug","",function(e){alert("Usage of debug sources is "+(e?"on":"off")+" now.\nFor the change to take effect, you need to reload the page.")});jQuery.sap.setReboot=fnMakeLocalStorageAccessor.call(this,"sap-ui-reboot-URL","string",function(e){if(e){alert("Next time this app is launched (only once), it will load UI5 from:\n"+e+".\nPlease reload the application page now.")}});jQuery.sap.statistics=fnMakeLocalStorageAccessor.call(this,"sap-ui-statistics","boolean",function(e){alert("Usage of Gateway statistics "+(e?"on":"off")+" now.\nFor the change to take effect, you need to reload the page.")});jQuery.sap.log=Object.assign(Log.getLogger(),{Level:Log.Level,getLogger:Log.getLogger,getLogEntries:Log.getLogEntries,addLogListener:Log.addLogListener,removeLogListener:Log.removeLogListener,logSupportInfo:Log.logSupportInfo,LogLevel:Log.Level,getLog:Log.getLogEntries});var sWindowName=typeof window==="undefined"||window.top==window?"":"["+window.location.pathname.split("/").slice(-1)[0]+"] ";jQuery.sap.assert=function(e,r){if(!e){var o=typeof r==="function"?r():r;assert(e,sWindowName+o)}};jQuery.sap.factory=function e(r){jQuery.sap.assert(typeof r=="object","oPrototype must be an object (incl. null)");function o(){}o.prototype=r;return o};jQuery.sap.newObject=function e(r){jQuery.sap.assert(typeof r=="object","oPrototype must be an object (incl. null)");return Object.create(r||null)};jQuery.sap.getter=function(e){return function(){return e}};jQuery.sap.getObject=function(e,r,o){var t=o||window,s=(e||"").split("."),a=s.length,n=isNaN(r)?0:a-r,u;if(sap.ui.loader._.getSyncCallBehavior()&&o===window){Log.error("[nosync] getObject called to retrieve global name '"+e+"'")}for(u=0;t&&u<a;u++){if(!t[s[u]]&&u<n){t[s[u]]={}}t=t[s[u]]}return t};jQuery.sap.setObject=function(e,r,o){var t=o||window,s=(e||"").split("."),a=s.length,n;if(a>0){for(n=0;t&&n<a-1;n++){if(!t[s[n]]){t[s[n]]={}}t=t[s[n]]}t[s[a-1]]=r}};jQuery.sap.measure=Measurement;jQuery.sap.measure.clearInteractionMeasurements=Interaction.clear;jQuery.sap.measure.startInteraction=Interaction.start;jQuery.sap.measure.endInteraction=Interaction.end;jQuery.sap.measure.getPendingInteractionMeasurement=Interaction.getPending;jQuery.sap.measure.filterInteractionMeasurements=Interaction.filter;jQuery.sap.measure.getAllInteractionMeasurements=Interaction.getAll;jQuery.sap.measure.getRequestTimings=function(){if(window.performance.getEntriesByType){return window.performance.getEntriesByType("resource")}return[]};jQuery.sap.measure.clearRequestTimings=function(){if(window.performance.clearResourceTimings){window.performance.clearResourceTimings()}};jQuery.sap.measure.setRequestBufferSize=function(e){if(window.performance.setResourceTimingBufferSize){window.performance.setResourceTimingBufferSize(e)}};(function(){var e=LoaderExtensions.getKnownSubtypes(),r;(function(){var o="";for(var t in e){o=(o?o+"|":"")+"(?:(?:"+e[t].join("\\.|")+"\\.)?"+t+")"}o="\\.(?:"+o+"|[^./]+)$";r=new RegExp(o)})();function o(e){if(/^jquery\.sap\./.test(e)){return e}return e.replace(/\./g,"/")}jQuery.sap.getModulePath=function(e,r){return jQuery.sap.getResourcePath(o(e),r)};jQuery.sap.getResourcePath=function(e,o){if(arguments.length===1&&e!=""){var t=e.split(/\//);var s=r.exec(t[t.length-1]);if(s){o=s[0];t[t.length-1]=t[t.length-1].slice(0,s.index);e=t.join("/")}else{o=""}}return _ui5loader.getResourcePath(e,o)};jQuery.sap.registerModulePath=function e(r,o){jQuery.sap.assert(!/\//.test(r),"module name must not contain a slash.");r=r.replace(/\./g,"/");o=o||".";LoaderExtensions.registerResourcePath(r,o)};jQuery.sap.registerResourcePath=LoaderExtensions.registerResourcePath;jQuery.sap.registerModuleShims=function(e){jQuery.sap.assert(typeof e==="object","mShims must be an object");ui5loader.config({shim:e})};jQuery.sap.isDeclared=function e(r,t){var s=_ui5loader.getModuleState(o(r)+".js");return s&&(t||s>0)};jQuery.sap.isResourceLoaded=function e(r){return!!_ui5loader.getModuleState(r)};jQuery.sap.getAllDeclaredModules=LoaderExtensions.getAllRequiredModules;jQuery.sap.declare=function(e,r){var t=e;if(typeof e==="object"){t=e.modName;e=o(e.modName)+(e.type?"."+e.type:"")+".js"}else{e=o(e)+".js"}_ui5loader.declareModule(e);if(r!==false){jQuery.sap.getObject(t,1)}};jQuery.sap.require=function(r){if(arguments.length>1){for(var t=0;t<arguments.length;t++){jQuery.sap.require(arguments[t])}return this}if(typeof r==="object"){jQuery.sap.assert(!r.type||e.js.indexOf(r.type)>=0,"type must be empty or one of "+e.js.join(", "));r=o(r.modName)+(r.type?"."+r.type:"")}else{r=o(r)}sap.ui.requireSync(r)};Object.defineProperty(jQuery.sap.require,"_hook",{get:function(){return _ui5loader.translate},set:function(e){jQuery.sap.assert(false,"jquery.sap.global: legacy hook for code transformation should no longer be used");_ui5loader.translate=e}});jQuery.sap.preloadModules=function(e,r,o){Log.error("jQuery.sap.preloadModules was never a public API and has been removed. Migrate to Core.loadLibrary()!")};jQuery.sap.registerPreloadedModules=function(e){var r=e.modules;if(Version(e.version||"1.0").compareTo("2.0")<0){r={};for(var t in e.modules){r[o(t)+".js"]=e.modules[t]}}sap.ui.require.preload(r,e.name,e.url)};jQuery.sap.unloadResources=_ui5loader.unloadResources;jQuery.sap.getResourceName=function(e,r){return o(e)+(r==null?".js":r)};jQuery.sap.loadResource=LoaderExtensions.loadResource;jQuery.sap._loadJSResourceAsync=_ui5loader.loadJSResourceAsync})();jQuery.sap.includeScript=includeScript;jQuery.sap.includeStyleSheet=includeStylesheet;jQuery.sap.FrameOptions=FrameOptions;jQuery.sap.globalEval=function(){eval(arguments[0])};(function(){var e=Device.browser;var r=e.name;if(!jQuery.browser){jQuery.browser=function(e){var r=/(webkit)[ \/]([\w.]+)/,o=/(opera)(?:.*version)?[ \/]([\w.]+)/,t=/(mozilla)(?:.*? rv:([\w.]+))?/,e=e.toLowerCase(),s=r.exec(e)||o.exec(e)||e.indexOf("compatible")<0&&t.exec(e)||[],a={};if(s[1]){a[s[1]]=true;a.version=s[2]||"0";if(a.webkit){a.safari=true}}return a}(window.navigator.userAgent)}if(r===e.BROWSER.CHROME){jQuery.browser.safari=false;jQuery.browser.chrome=true}else if(r===e.BROWSER.SAFARI){jQuery.browser.safari=true;jQuery.browser.chrome=false}if(r){jQuery.browser.fVersion=e.version;jQuery.browser.mobile=e.mobile}})();return jQuery});
//# sourceMappingURL=jquery.sap.global.js.map