/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/Button","sap/m/Toolbar","sap/ui/core/Core","sap/ui/core/format/DateFormat","sap/ui/core/IconPool","sap/ui/core/InvisibleText","sap/ui/unified/Calendar","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/calendar/CalendarUtils","./CalendarInCardRenderer","sap/ui/core/date/UI5Date"],function(t,e,a,i,r,o,s,n,h,c,_){"use strict";var p=s.extend("sap.f.CalendarInCard",{metadata:{library:"sap.f"},renderer:c});p.prototype.init=function(){s.prototype.init.apply(this,arguments);this.setProperty("_currentPicker","month")};p.prototype.onBeforeRendering=function(){var t=this.getAggregation("month"),e=this._getFocusedDate().toLocalJSDate();t[0].displayDate(e);this._iSize=0;switch(this._iMode){case 0:this._oPickerBtn.setText(this._formatPickerText(e));break;case 1:this._oPickerBtn.setText(this._formatMonthPickerText());break;case 2:case 3:this._oPickerBtn.setText(this._formatYearPickerText());break}this._updateTodayButtonState()};p.prototype.onAfterRendering=function(t){};p.prototype.onsaptabnext=function(t){};p.prototype.onsaptabprevious=function(t){};p.prototype._initializeHeader=function(){var i=this.getId()+"--Head",s=a.getLibraryResourceBundle("sap.f"),n=new t(i+"-PrevBtn",{icon:r.getIconURI("slim-arrow-left"),tooltip:s.getText("CALENDAR_BTN_PREV"),type:"Transparent",press:function(){this._handlePrevious()}.bind(this)}),h=new t({icon:r.getIconURI("slim-arrow-right"),tooltip:s.getText("CALENDAR_BTN_NEXT"),type:"Transparent",press:function(){this._handleNext()}.bind(this)}),c=new e(i,{ariaLabelledBy:o.getStaticId("sap.f","CALENDAR_NAVIGATION")});this._oTodayBtn=new t({text:s.getText("CALENDAR_TODAY"),ariaLabelledBy:o.getStaticId("sap.f","CALENDAR_NAVIGATE_TO_TODAY"),type:"Transparent",press:function(){this._handleTodayPress()}.bind(this)});this._oPickerBtn=new t({type:"Transparent",ariaLabelledBy:o.getStaticId("sap.f","CALENDAR_SELECT_RANGE"),press:function(){this._handlePickerButtonPress()}.bind(this)});c.addContent(n).addContent(this._oTodayBtn).addContent(h).addContent(this._oPickerBtn);this.setAggregation("header",c)};p.prototype._handlePickerButtonPress=function(){switch(this._iMode){case 0:this._showMonthPicker();this._oPickerBtn.getDomRef().focus();break;case 1:this._showYearPicker();this._oPickerBtn.getDomRef().focus();break;case 2:this._showYearRangePicker();break}};p.prototype._handleTodayPress=function(){var t=_.getInstance(),e=n.fromLocalJSDate(t);this.getAggregation("month")[0].setDate(t);this.getSelectedDates()[0].setStartDate(t);this._setFocusedDate(e);if(this._iMode===3){t.setFullYear(t.getFullYear()-this._getYearRangePicker().getRangeSize()/2);this._getYearRangePicker().setDate(t);this._oPickerBtn.setText(this._formatYearPickerText())}else if(this._iMode===2){this._getYearPicker().setDate(t);this._oPickerBtn.setText(this._formatYearPickerText())}else if(this._iMode===1){this.displayDate(t);this._getMonthPicker()._iYear=t.getFullYear();this._getMonthPicker().setMonth(t.getMonth());this._oPickerBtn.setText(this._formatMonthPickerText())}else{this._oPickerBtn.setText(this._formatPickerText())}this._addMonthFocusDelegate();this._updateTodayButtonState();this.fireStartDateChange();this.fireSelect()};p.prototype._formatPickerText=function(t){var e=t?t:this.getSelectedDates()[0].getStartDate(),r=a.getConfiguration().getRTL(),o=i.getDateInstance({format:"yMMMM"}),s=o.format(e),n,h;if(!r){n=s;if(h){n+=" - "+h}}else{if(h){n=h+" - "+s}else{n=s}}return n};p.prototype._formatYearPickerText=function(){var t=this._getYearPicker().getDate().getFullYear(),e=this._getYearPicker().getYears(),a=t-Math.floor(e/2),i=t+e/2-1;return""+a+" - "+i};p.prototype._formatMonthPickerText=function(){return i.getDateInstance({format:"y"}).format(this.getStartDate())};p.prototype._showMonthPicker=function(t){var e=this._getFocusedDate(),a=this._getMonthPicker();this.setProperty("_currentPicker","monthPicker");a._setYear(e.getYear());a._setDate(e);if(!t){a.setMonth(e.getMonth());this._setDisabledMonths(e.getYear(),a)}this._iMode=1;this._togglePrevNext(e,false);this._oPickerBtn.setText(this._formatMonthPickerText())};p.prototype._showYearPicker=function(){var t=this._getFocusedDate(),e=this._getYearPicker();this.setProperty("_currentPicker","yearPicker");this._togglePrevNexYearPicker();this._iMode=2;e.setDate(t.toLocalJSDate());this._oPickerBtn.setText(this._formatYearPickerText())};p.prototype._showYearRangePicker=function(){s.prototype._showYearRangePicker.apply(this,arguments);this._oPickerBtn.setVisible(false)};p.prototype._selectMonth=function(){s.prototype._selectMonth.apply(this,arguments);this._oPickerBtn.setText(this._formatPickerText());this._updateTodayButtonState()};p.prototype._selectYear=function(){s.prototype._selectYear.apply(this,arguments);this._oPickerBtn.setText(this._formatMonthPickerText());this._showMonthPicker();this._updateTodayButtonState()};p.prototype._selectYearRange=function(){var t=this.getAggregation("yearRangePicker"),e=t.getRangeSize(),a=this.getPrimaryCalendarType(),i=n.fromLocalJSDate(t.getDate(),a),r=this._getFocusedDate();i.setMonth(r.getMonth(),r.getDate());i.setYear(i.getYear()+Math.floor(e/2));r.setYear(i.getYear());this._setFocusedDate(r);this._showYearPicker();this._oPickerBtn.setVisible(true).setText(this._formatYearPickerText());this._updateTodayButtonState()};p.prototype._handlePrevious=function(){s.prototype._handlePrevious.apply(this,arguments);this._handleArrowNavigation(-1)};p.prototype._handleNext=function(){s.prototype._handleNext.apply(this,arguments);this._handleArrowNavigation(1)};p.prototype._handleArrowNavigation=function(t){var e,a,i;if(this._iMode===3){i=this._getYearRangePicker();i.getDate().setFullYear(i.getDate().getFullYear()+t*i.getYears());this._oPickerBtn.setText(this._formatYearPickerText())}else if(this._iMode===2){a=this._getYearPicker();a.getDate().setFullYear(a.getDate().getFullYear()+t*a.getYears());this._oPickerBtn.setText(this._formatYearPickerText())}else if(this._iMode===1){e=this._getMonthPicker();this._getFocusedDate().setYear(e._iYear);this.getAggregation("month")[0].getDate().setYear(e._iYear);this._oPickerBtn.setText(this._formatMonthPickerText())}else{this._oPickerBtn.setText(this._formatPickerText(this._getFocusedDate().toLocalJSDate()))}this._updateTodayButtonState()};p.prototype._dateMatchesVisibleRange=function(){var t=n.fromLocalJSDate(_.getInstance()),e,a,i,r,o;switch(this._iMode){case 0:e=this.getSelectedDates().length?this.getSelectedDates()[0].getStartDate():this.getStartDate();a=e.getDate()===t.getDate();return a&&h._isSameMonthAndYear(n.fromLocalJSDate(this.getStartDate()),t);case 1:return h._isSameMonthAndYear(n.fromLocalJSDate(this.getStartDate()),t);case 2:return h._isSameMonthAndYear(n.fromLocalJSDate(this._getYearPicker().getDate()),t);case 3:i=this._getYearRangePicker();r=i.getDate();o=_.getInstance(r.getFullYear()+i.getRangeSize()/2,r.getMonth(),r.getDate());return h._isSameMonthAndYear(n.fromLocalJSDate(o),t)}};p.prototype._updateTodayButtonState=function(){if(this._oTodayBtn){this._oTodayBtn.setEnabled(!this._dateMatchesVisibleRange())}};p.prototype._updateHeader=function(){};p.prototype.onsapescape=function(){this.fireCancel();this._closePickers();this._oPickerBtn.setVisible(true);this._oPickerBtn.setText(this._formatPickerText())};p.prototype._updateHeadersButtons=function(){};p.prototype._togglePrevNext=function(){};p.prototype._togglePrevNexYearPicker=function(){};p.prototype._initializeSecondMonthHeader=function(){};p.prototype._updateHeadersYearPrimaryText=function(){};p.prototype._updateHeadersYearAdditionalText=function(){};p.prototype._updateActiveHeaderYearButtonVisibility=function(){};p.prototype._setHeaderText=function(){};return p});
//# sourceMappingURL=CalendarInCard.js.map