/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","./library","sap/ui/core/library","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/core/Control","sap/ui/util/Storage","sap/m/library","sap/m/NavContainer","sap/ui/core/Configuration","sap/ui/dom/units/Rem","./FlexibleColumnLayoutRenderer","sap/base/Log","sap/base/assert","sap/base/util/isEmptyObject","sap/base/util/merge","sap/ui/core/InvisibleMessage","sap/ui/dom/jquery/Focusable"],function(jQuery,e,t,o,n,i,s,r,a,u,l,d,h,m,p,g,C){"use strict";var c=e.LayoutType;var f=t.InvisibleMessageMode;var _=i.extend("sap.f.FlexibleColumnLayout",{metadata:{interfaces:["sap.ui.core.IPlaceholderSupport"],properties:{autoFocus:{type:"boolean",group:"Behavior",defaultValue:true},layout:{type:"sap.f.LayoutType",defaultValue:c.OneColumn},defaultTransitionNameBeginColumn:{type:"string",group:"Appearance",defaultValue:"slide"},defaultTransitionNameMidColumn:{type:"string",group:"Appearance",defaultValue:"slide"},defaultTransitionNameEndColumn:{type:"string",group:"Appearance",defaultValue:"slide"},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:r.BackgroundDesign.Transparent},restoreFocusOnBackNavigation:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{beginColumnPages:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getBeginColumn",aggregation:"pages"}},midColumnPages:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getMidColumn",aggregation:"pages"}},endColumnPages:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getEndColumn",aggregation:"pages"}},landmarkInfo:{type:"sap.f.FlexibleColumnLayoutAccessibleLandmarkInfo",multiple:false},_beginColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_midColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_endColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"}},associations:{initialBeginColumnPage:{type:"sap.ui.core.Control",multiple:false},initialMidColumnPage:{type:"sap.ui.core.Control",multiple:false},initialEndColumnPage:{type:"sap.ui.core.Control",multiple:false}},events:{stateChange:{parameters:{layout:{type:"sap.f.LayoutType"},maxColumnsCount:{type:"int"},isNavigationArrow:{type:"boolean"},isResize:{type:"boolean"}}},beginColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterBeginColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},midColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterMidColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},endColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterEndColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},columnResize:{parameters:{beginColumn:{type:"boolean"},midColumn:{type:"boolean"},endColumn:{type:"boolean"}}}}},renderer:d});_.DEFAULT_COLUMN_LABELS={FirstColumn:"FCL_BEGIN_COLUMN_REGION_TEXT",MiddleColumn:"FCL_MID_COLUMN_REGION_TEXT",LastColumn:"FCL_END_COLUMN_REGION_TEXT"};_.COLUMN_RESIZING_ANIMATION_DURATION=560;_.PINNED_COLUMN_CLASS_NAME="sapFFCLPinnedColumn";_.ANIMATED_COLUMN_CLASS_NAME="sapFFCLAnimatedColumn";_.COLUMN_ORDER=["begin","mid","end"];_.COLUMN_SEPARATOR_WIDTH=l.toPx("1rem");_.prototype.init=function(){this._iWidth=0;this._oColumnFocusInfo={begin:{},mid:{},end:{}};this._initNavContainers();this._oLayoutHistory=new y;this._oAnimationEndListener=new v;this._oRenderedColumnPagesBoolMap={};this._oColumnWidthInfo={begin:0,mid:0,end:0};this._keyListeners={increase:this._resizeColumnOnKeypress.bind(this,"inc",1),decrease:this._resizeColumnOnKeypress.bind(this,"dec",1),increaseMore:this._resizeColumnOnKeypress.bind(this,"incMore",2),decreaseMore:this._resizeColumnOnKeypress.bind(this,"decMore",2),max:this._resizeColumnOnKeypress.bind(this,"max",1),min:this._resizeColumnOnKeypress.bind(this,"min",1)};this._enableKeyboardListeners();this._oInvisibleMessage=null;this._boundColumnSeparatorMove=this._onColumnSeparatorMove.bind(this);this._boundColumnSeparatorMoveEnd=this._onColumnSeparatorMoveEnd.bind(this);this._oLocalStorage={};this._bNeverRendered=true};_.prototype._getLocalStorage=function(e){if(!e){e=this.getMaxColumnsCount()}var t=e===3?"desktop":"tablet";if(!this._oLocalStorage[t]){var o=t==="desktop"?_.STORAGE_PREFIX_DESKTOP:_.STORAGE_PREFIX_TABLET;this._oLocalStorage[t]=new s(s.Type.local,o)}return this._oLocalStorage[t]};_.prototype._announceMessage=function(e){var t=_._getResourceBundle().getText(e);if(this._oInvisibleMessage){this._oInvisibleMessage.announce(t,f.Polite)}};_.prototype._enableKeyboardListeners=function(){this.onsaprightmodifiers=this._keyListeners.increase;this.onsapleftmodifiers=this._keyListeners.decrease;this.onsapright=this._keyListeners.increaseMore;this.onsapleft=this._keyListeners.decreaseMore;this.onsapend=this._keyListeners.max;this.onsaphome=this._keyListeners.min;this._keyboardEnabled=true};_.prototype._onNavContainerRendered=function(e){var t=e.srcControl,o=t.getPages().length>0,n=this._hasAnyColumnPagesRendered();this._setColumnPagesRendered(t.getId(),o);if(this._hasAnyColumnPagesRendered()!==n){this._hideShowColumnSeparators()}};_.prototype._createNavContainer=function(e){var t=e.charAt(0).toUpperCase()+e.slice(1);var o=new a(this.getId()+"-"+e+"ColumnNav",{autoFocus:this.getAutoFocus(),navigate:function(t){this._handleNavigationEvent(t,false,e)}.bind(this),afterNavigate:function(t){this._handleNavigationEvent(t,true,e)}.bind(this),defaultTransitionName:this["getDefaultTransitionName"+t+"Column"]()});o.addDelegate({onAfterRendering:this._onNavContainerRendered},this);this["_"+e+"ColumnFocusOutDelegate"]={onfocusout:function(t){this._oColumnFocusInfo[e]=t.target}};o.addEventDelegate(this["_"+e+"ColumnFocusOutDelegate"],this);return o};_.prototype._formatColumnLandmarkInfo=function(e,t){var o=null;if(e){o=e["get"+t+"Label"]()}return{role:"region",label:o||_._getResourceBundle().getText(_.DEFAULT_COLUMN_LABELS[t])}};_.prototype._handleNavigationEvent=function(e,t,o){var n,i;if(t){n="after"+(o.charAt(0).toUpperCase()+o.slice(1))+"ColumnNavigate"}else{n=o+"ColumnNavigate"}i=this.fireEvent(n,e.mParameters,true);if(!i){e.preventDefault()}};_.prototype._getColumnByStringName=function(e){if(e==="end"){return this._getEndColumn()}else if(e==="mid"){return this._getMidColumn()}else{return this._getBeginColumn()}};_.prototype._getBeginColumn=function(){return this.getAggregation("_beginColumnNav")};_.prototype._getMidColumn=function(){return this.getAggregation("_midColumnNav")};_.prototype._getEndColumn=function(){return this.getAggregation("_endColumnNav")};_.prototype._flushColumnContent=function(e){var t=this.getAggregation("_"+e+"ColumnNav"),o=sap.ui.getCore().createRenderManager();o.renderControl(t);o.flush(this._$columns[e].find(".sapFFCLColumnContent")[0],undefined,true);o.destroy()};_.prototype.setLayout=function(e){e=this.validateProperty("layout",e);var t=this.getLayout();if(t===e){return this}var o=this.setProperty("layout",e,true);this._oLayoutHistory.addEntry(e);this._resizeColumns();return o};_.prototype.setAutoFocus=function(e){e=this.validateProperty("autoFocus",e);var t=this.getAutoFocus();if(t===e){return this}this._getNavContainers().forEach(function(t){t.setAutoFocus(e)});return this.setProperty("autoFocus",e,true)};_.prototype.onBeforeRendering=function(){var e=this._$columns;if(!this._oInvisibleMessage){this._oInvisibleMessage=C.getInstance()}this._deregisterResizeHandler();this._oAnimationEndListener.cancelAll();if(this.$().length){_.COLUMN_ORDER.slice().forEach(function(t){e&&e[t]&&e[t].removeClass(_.ANIMATED_COLUMN_CLASS_NAME)})}};_.prototype.onAfterRendering=function(){this._measureControlWidth();this._registerResizeHandler();this._cacheDOMElements();this._resizeColumns();this._flushColumnContent("begin");this._flushColumnContent("mid");this._flushColumnContent("end");this._fireStateChange(false,false);this._bNeverRendered=false};_.prototype.onmousedown=function(e){if(this._ignoreMouse){return}var t=this._getColumnSeparator(e.target);if(!t){return}this._ignoreTouch=true;this._onColumnSeparatorMoveStart(e,t)};_.prototype.ontouchstart=function(e){if(this._ignoreTouch){return}var t=this._getColumnSeparator(e.target);if(!t){return}if(!e.changedTouches||!e.changedTouches[0]){return}this._ignoreMouse=true;this._onColumnSeparatorMoveStart(e.changedTouches[0],t,true)};_.prototype._restoreFocusToColumn=function(e){var t=this._oColumnFocusInfo[e];if(!t||p(t)){t=this._getFirstFocusableElement(e)}jQuery(t).trigger("focus")};_.prototype._getFirstFocusableElement=function(e){var t=this._getColumnByStringName(e),o=t.getCurrentPage();if(o){return o.$().firstFocusableDomRef()}return null};_.prototype._isFocusInSomeOfThePreviousColumns=function(e){var t=this._getLastVisibleColumnForLayout(e),o=_.COLUMN_ORDER.indexOf(t)-1,n;for(;o>=0;o--){n=this._getColumnByStringName(_.COLUMN_ORDER[o]);if(n&&n._isFocusInControl(n)){return true}}return false};_.prototype._getControlWidth=function(){if(this._iWidth===0){this._measureControlWidth()}return this._iWidth};_.prototype._measureControlWidth=function(){if(this.$().is(":visible")){this._iWidth=this.$().width()}else{this._iWidth=0}};_.prototype.exit=function(){this._removeNavContainersFocusOutDelegate();this._oRenderedColumnPagesBoolMap=null;this._oColumnFocusInfo=null;this._oLocalStorage=null;this._deregisterResizeHandler();this._handleEvent(jQuery.Event("Destroy"))};_.prototype._removeNavContainersFocusOutDelegate=function(){_.COLUMN_ORDER.forEach(function(e){this._getColumnByStringName(e).removeEventDelegate(this["_"+e+"ColumnFocusOutDelegate"])},this)};_.prototype._registerResizeHandler=function(){m(!this._iResizeHandlerId,"Resize handler already registered");this._iResizeHandlerId=n.register(this,this._onResize.bind(this))};_.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){n.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null}};_.prototype._initNavContainers=function(){this.setAggregation("_beginColumnNav",this._createNavContainer("begin"),true);this.setAggregation("_midColumnNav",this._createNavContainer("mid"),true);this.setAggregation("_endColumnNav",this._createNavContainer("end"),true)};_.prototype._getNavContainers=function(){return[this._getBeginColumn(),this._getMidColumn(),this._getEndColumn()]};_.prototype._cacheDOMElements=function(){this._cacheColumns();if(!o.system.phone){this._cacheColumnSeparators();this._$overlay=this.$("overlay");this._$overlaySeparator=this.$("overlaySeparator")}};_.prototype._cacheColumns=function(){this._$columns={begin:this.$("beginColumn"),mid:this.$("midColumn"),end:this.$("endColumn")}};_.prototype._cacheColumnSeparators=function(){this._oColumnSeparators={begin:this.$("separator-begin"),end:this.$("separator-end")}};_.prototype._getVisibleColumnsCount=function(e){return this._getVisibleColumnsForLayout(e).length};_.prototype._getVisibleColumnsForLayout=function(e){return _.COLUMN_ORDER.filter(function(t){return this._getColumnSizeForLayout(t,e)>0},this)};_.prototype._getVisibleColumnSeparatorsCount=function(){if(!this._oColumnSeparators){return 0}return Object.keys(this._oColumnSeparators).filter(function(e){return this._oColumnSeparators[e].data("visible")},this).length};_.prototype._getTotalColumnsWidth=function(e){var t=this._getRequiredColumnSeparatorsForLayout(e).length;return this._getControlWidth()-t*_.COLUMN_SEPARATOR_WIDTH};_.prototype._resizeColumns=function(e){var t=_.COLUMN_ORDER.slice(),o,n,i,s,r,a,u,l,d;if(!this.isActive()){return}e=g(this._getDefaultResizeOptions(),e);n=e.layout;s=this._getVisibleColumnsCount(n);if(s===0){return}o=e.hasAnimations;i=e.previousLayout;u=s===3&&n===c.ThreeColumnsEndExpanded;r=e.columnWidths||this._getAllColumnSizesForLayout(n,true);a=this._getLastVisibleColumnForLayout(n);l=e.restoreFocusOnBackNavigation&&i&&this._isNavigatingBackward(n,i)&&!this._isFocusInSomeOfThePreviousColumns(i);d=o&&i?this._getAnimationEndStatusForColumns():{};if(o&&i){this._pinColumnsBeforeResize(n,i,r);this._oAnimationEndListener.cancelAll()}t.slice().forEach(function(e){this._$columns[e].removeClass(_.ANIMATED_COLUMN_CLASS_NAME)}.bind(this));this._hideShowColumnSeparators();t.forEach(function(t){var s=r[t],h=o&&this._shouldRevealColumn(t,n,i),m=o&&this._shouldConcealColumn(t,n,i);this._resizeColumn(t,{width:s,shouldRestoreFocus:l&&t===a,shouldInsetColumn:u&&t==="mid",shouldRevealColumn:h,shouldConcealColumn:m,hidden:s===0&&this._oColumnWidthInfo[t]===0,autoSize:s>0&&t==="mid",hasAnimations:o,previousAnimationCompleted:!d[this._$columns[t]],updateContextualSettings:e.updateContextualSettings,updateMediaCSSClases:e.updateMediaCSSClases})},this);if(e.updateDetailedActiveClasses){this._addDetailedActiveClasses(n)}};_.prototype._resizeColumn=function(e,t){var i=this._$columns[e],s=i.get(0),r=t.width,a=E(r,this._getControlWidth(),t.shouldInsetColumn),u=t.autoSize,l=t.hasAnimations,d=t.shouldRevealColumn||t.shouldConcealColumn,h=this._canResizeColumnWithAnimation(e,t),m=l&&(h||u)&&!d,p=this._afterColumnResize.bind(this,e,g(t,{resumeResizeHandler:m})),C=function(){n.resume(s);s.querySelector(".sapFFCLColumnContent").style.width=""};if(u){a=""}i.toggleClass("sapFFCLColumnActive",r>0||t.shouldConcealColumn);i.toggleClass("sapFFCLColumnInset",t.shouldInsetColumn);i.removeClass("sapFFCLColumnHidden sapFFCLColumnOnlyActive sapFFCLColumnLastActive sapFFCLColumnFirstActive");if(m){n.suspend(s)}if(h){i.addClass(_.ANIMATED_COLUMN_CLASS_NAME);i.width(a);this._attachAfterColumnResizedOnce(e,p,C)}else if(u&&l){i.width(a);this._attachAfterAllColumnsResizedOnce(p,C)}else{i.width(a);p()}if(t.updateContextualSettings&&!o.system.phone){this._updateColumnContextualSettings(e,r)}if(t.updateMediaCSSClases&&!o.system.phone){this._updateColumnCSSClasses(e,r)}};_.prototype._afterColumnResize=function(e,t){var o=this._$columns[e],i=t.shouldRevealColumn,s=t.shouldConcealColumn,r=t.width,a=t.shouldRestoreFocus;if(i||s){o[0].querySelector(".sapFFCLColumnContent").style.width=""}o.toggleClass(_.PINNED_COLUMN_CLASS_NAME,false);o.toggleClass(_.ANIMATED_COLUMN_CLASS_NAME,false);if(s){o.removeClass("sapFFCLColumnActive")}o.toggleClass("sapFFCLColumnHidden",r===0);if(t.resumeResizeHandler){n.resume(o[0])}this._cacheColumnWidth(e,r);if(a){this._restoreFocusToColumn(e)}};_.prototype._pinColumnsBeforeResize=function(e,t,o){_.COLUMN_ORDER.slice().forEach(function(n){var i=this._shouldConcealColumn(n,e,t),s=this._shouldRevealColumn(n,e,t),r=i||s,a=this._$columns[n],u=a[0];a.toggleClass(_.PINNED_COLUMN_CLASS_NAME,r);if(s){u.querySelector(".sapFFCLColumnContent").style.width=E(o[n],this._getControlWidth())}else if(i){u.querySelector(".sapFFCLColumnContent").style.width=u.offsetWidth+"px"}},this)};_.prototype._getAnimationEndStatusForColumns=function(){var e={};_.COLUMN_ORDER.slice().forEach(function(t){e[t]=this._oAnimationEndListener.isWaitingForColumnResizeEnd(this._$columns[t])},this);return e};_.prototype._getAllColumnSizesForLayout=function(e,t){var o={};_.COLUMN_ORDER.slice().forEach(function(t){var n=this._getColumnSizeForLayout(t,e),i=this._convertColumnPercentWidthToPx(n,e);o[t]=i},this);if(t){this._normalizeColumnWidths(o,this._getVisibleColumnsForLayout(e))}return o};_.prototype._getDefaultResizeOptions=function(){var e=u.getAnimationMode();return{layout:this.getLayout(),previousLayout:this._getPreviousLayout(),restoreFocusOnBackNavigation:this.getRestoreFocusOnBackNavigation(),updateDetailedActiveClasses:true,updateContextualSettings:true,updateMediaCSSClases:true,hasAnimations:e!==u.AnimationMode.none&&e!==u.AnimationMode.minimal}};_.prototype._getPreviousLayout=function(){return this._getLayoutHistory().getEntry(1,true)||c.OneColumn};_.prototype._addDetailedActiveClasses=function(e){var t=_.COLUMN_ORDER.slice(),o=u.getRTL(),n=t.filter(function(t){return this._getColumnSizeForLayout(t,e)>0},this);if(o){t.reverse()}if(n.length===1){this._$columns[n[0]].addClass("sapFFCLColumnOnlyActive")}if(n.length>1){this._$columns[n[0]].addClass("sapFFCLColumnFirstActive");this._$columns[n[n.length-1]].addClass("sapFFCLColumnLastActive")}};_.prototype._resizeColumnOnKeypress=function(e,t,o){var n=this._getColumnSeparator(o.target),i,s;if(!n){return}var r=this._getControlWidth();var a=0;switch(e){case"inc":a=t;break;case"incMore":a=t*10;break;case"dec":a=0-t;break;case"decMore":a=0-t*10;break;case"max":a=r;break;case"min":a=0-r;break;default:h.warn("[FlexibleColumnLayout] Invalid keyboard resize type");break}i=n&&n.getBoundingClientRect().x;s=i+a;this._onColumnSeparatorMoveStart({pageX:i},n);this._onColumnSeparatorMove({pageX:s});this._onColumnSeparatorMoveEnd({pageX:s})};_.prototype._onColumnSeparatorMoveStart=function(e,t,o){var n=u.getRTL(),i=this._getDraggedSeparatorStartOffset(t,n);this._oMoveInfo={cursorStartX:e.pageX,cursorX:e.pageX,columnWidths:{begin:this._$columns.begin.get(0).offsetWidth,mid:this._$columns.mid.get(0).offsetWidth,end:this._$columns.end.get(0).offsetWidth},separator:t,separatorPosition:{x:i,direction:n?"right":"left"},layout:this.getLayout(),rtl:n};this._enterInteractiveResizeMode(o)};_.prototype._getDraggedSeparatorStartOffset=function(e,t){if(t){return this.getDomRef().clientWidth-e.offsetLeft-e.offsetWidth}return e.offsetLeft};_.prototype._onColumnSeparatorMove=function(e){if(e.preventDefault&&!e.changedTouches){e.preventDefault()}var t=T(e);this._previewResizedColumnsOnMoveSeparator(t)};_.prototype._onColumnSeparatorMoveEnd=function(e){var t=T(e);this._previewResizedColumnsOnMoveSeparator(t,true);this._saveResizedColumWidths();if(this._oMoveInfo.layout!==this.getLayout()){this.setLayout(this._oMoveInfo.layout);this._fireStateChange(true,false)}this._exitInteractiveResizeMode()};_.prototype._getColumnSeparator=function(e){var t=e,o=this.getId();if(t.classList.contains("sapFFCLColumnSeparatorGripIcon")){t=e.parentElement}if(t.classList.contains("sapFFCLColumnSeparatorDecorationBefore")||t.classList.contains("sapFFCLColumnSeparatorDecorationAfter")||t.classList.contains("sapFFCLColumnSeparatorGrip")){t=t.parentElement}if(!t.id||t.id.indexOf(o+"-separator")!==0){return null}return t};_.prototype._enterInteractiveResizeMode=function(e){var t=this._oMoveInfo.separatorPosition;this._$overlay.css("display","block");this._$overlaySeparator.css(t.direction,t.x);this._oMoveInfo.separator.style.visibility="hidden";if(e){document.addEventListener("touchend",this._boundColumnSeparatorMoveEnd);document.addEventListener("touchmove",this._boundColumnSeparatorMove)}else{document.addEventListener("mouseup",this._boundColumnSeparatorMoveEnd);document.addEventListener("mousemove",this._boundColumnSeparatorMove)}};_.prototype._exitInteractiveResizeMode=function(){this._$overlay.css("display","");this._oMoveInfo.separator.style.visibility="";this._oMoveInfo.separator.focus();this._ignoreMouse=false;this._ignoreTouch=false;this._oMoveInfo=null;document.removeEventListener("mouseup",this._boundColumnSeparatorMoveEnd);document.removeEventListener("mousemove",this._boundColumnSeparatorMove);document.removeEventListener("touchend",this._boundColumnSeparatorMoveEnd);document.removeEventListener("touchmove",this._boundColumnSeparatorMove)};_.prototype._previewResizedColumnsOnMoveSeparator=function(e,t){var o=function(t){var o=e-t;return this._oMoveInfo.rtl?-o:o}.bind(this);this._oMoveInfo.offsetFromPreviousPosition=o(this._oMoveInfo.cursorX);this._oMoveInfo.offsetFromStartPosition=o(this._oMoveInfo.cursorStartX);this._oMoveInfo.cursorX=e;if(!this._oMoveInfo.offsetFromStartPosition){return}if(!this._oMoveInfo.offsetFromPreviousPosition&&!t){return}var n=b(this._oMoveInfo.separator,this._oMoveInfo.layout,this.getMaxColumnsCount()),i=M(this._oMoveInfo.separator),s=this._oMoveInfo.offsetFromStartPosition>0,r=n[s?0:1],a=this._getVisibleColumnSeparatorsCount(),u=0,l=0,d,h=this._oMoveInfo.layout,m,p,C,c;this._oMoveInfo.columnWidths[n[0]]+=this._oMoveInfo.offsetFromPreviousPosition;this._oMoveInfo.columnWidths[n[1]]-=this._oMoveInfo.offsetFromPreviousPosition;this._oMoveInfo.columnEnlargedByDragging=r;C=g({},this._oMoveInfo.columnWidths);this._normalizeColumnWidths(C,n);d=this._oMoveInfo.columnWidths[n[1]]-C[n[1]];this._offsetDraggedColumnSeparator(this._oMoveInfo.offsetFromPreviousPosition+d);this._toggleColumnVisibility(r,true);m=this._getNextLayoutOnResizeByDrag(C,h,i,s,t);p=m!==h;if(p){this._hideShowColumnSeparators(m);u=a-this._getRequiredColumnSeparatorsForLayout(m).length;if(u){l=_.COLUMN_SEPARATOR_WIDTH*u;C.mid+=l}c=_.COLUMN_ORDER.some(function(e){return this._shouldRevealColumn(e,m,h)||this._shouldConcealColumn(e,m,h)},this);C=this._mergeColumnWidthsOnInteractiveLayoutChange({oldWidths:this._getAllColumnSizesForLayout(m,true),newWidths:{[n[0]]:C[n[0]],[n[1]]:C[n[1]]},layout:m,columnEnlargedByDragging:r});this._oMoveInfo.layout=m;this._oMoveInfo.cursorStartX=e}this._oMoveInfo.columnWidths=C;if(c){this._resizeColumns({columnWidths:C,layout:m,previousLayout:h,updateContextualSettings:false,updateMediaCSSClases:false,updateDetailedActiveClasses:false,restoreFocusOnBackNavigation:false})}else{this._$columns.begin.css("width",this._oMoveInfo.columnWidths.begin+"px");this._$columns.end.css("width",this._oMoveInfo.columnWidths.end+"px");n.forEach(function(e){this._updateColumnContextualSettings(e,this._oMoveInfo.columnWidths[e])},this)}if(p){this.fireEvent("_liveStateChange",{layout:m,maxColumnsCount:this.getMaxColumnsCount()})}};_.prototype._mergeColumnWidthsOnInteractiveLayoutChange=function(e){var t=e.oldWidths,o=e.newWidths,n=e.layout,i=e.columnEnlargedByDragging,s=Object.keys(o),r=this._getTotalColumnsWidth(n),a=function(e){return o[e]>=_.COLUMN_MIN_WIDTH},u=function(e){e.mid=r-e.begin-e.end;return e},l;if(s.indexOf("mid")>-1){l=s.find(e=>e!=="mid")}else{l=i}if(!a(l)){return t}return u(g(t,{[l]:o[l]}))};_.prototype._offsetDraggedColumnSeparator=function(e){this._oMoveInfo.separatorPosition.x+=e;this._$overlaySeparator.css(this._oMoveInfo.separatorPosition.direction,this._oMoveInfo.separatorPosition.x)};_.prototype._toggleColumnVisibility=function(e,t){this._$columns[e].toggleClass("sapFFCLColumnHidden",!t);this._$columns[e].toggleClass("sapFFCLColumnActive",t)};_.prototype._normalizeColumnWidths=function(e,t){var o=t.length;if(o<2){return}var n=function(t){if(this._isColumnAllowedToHaveBelowMinWidth(t)){return}var o=e[t]-_.COLUMN_MIN_WIDTH,n,s;if(o<0){e[t]=_.COLUMN_MIN_WIDTH;n=i(t);s=e[n];e[n]=s-Math.abs(o)}}.bind(this);function i(n){if(o===2){return t.find(function(e){return e!==n})}if(["begin","end"].indexOf(n)>-1){return"mid"}return e.begin>e.end?"begin":"end"}t.forEach(n)};_.prototype._isColumnAllowedToHaveBelowMinWidth=function(e){if(!this._oMoveInfo){return false}if(e===this._oMoveInfo.columnEnlargedByDragging){return true}return!this._isColumnAdjacentToDraggedSeparator(e)};_.prototype._convertColumnPercentWidthToPx=function(e,t){if(!e){return 0}var o=this._getTotalColumnsWidth(t);return Math.round(o*e/100)};_.prototype._convertColumnPxWidthToPercent=function(e,t){if(!e){return 0}var o=this._getTotalColumnsWidth(t),n=function(e){return e/o*100};if(typeof e==="number"){return n(e)}if(typeof e==="object"){var i=Object.assign({},e);Object.keys(i).forEach(function(e){var t=i[e];if(t){i[e]=n(t)}},this);return i}return null};_.prototype._isValidWidthDistributionForLayout=function(e,t){var o=e.split("/").map(e=>parseFloat(e)),n=o.reduce(function(e,t){return parseFloat(e)+t}),i;if(Math.round(n)!==100){return false}i=o.map(function(e){return this._convertColumnPercentWidthToPx(e,t)},this);if(i.some(function(e){return e>0&&e<_.COLUMN_MIN_WIDTH})){return false}return this._verifyColumnWidthsMatchLayout({begin:i[0],mid:i[1],end:i[2]},t)};_.prototype._saveResizedColumWidths=function(){var e=this._oMoveInfo.layout,t=this._convertColumnPxWidthToPercent(this._oMoveInfo.columnWidths,e),o=Object.values(t).join("/");if(this._isValidWidthDistributionForLayout(o,e)){this._getLocalStorage().put(e,o)}};_.prototype._getNextLayoutOnResizeByDrag=function(e,t,o,n,i){function s(e){return e.from===t&&e.separator===o&&e.forward===n}var r=e.begin,a=Math.ceil(this._convertColumnPxWidthToPercent(r,t)),u=this.getMaxColumnsCount(),l=u===2;if(s({from:c.TwoColumnsMidExpanded,separator:"begin",forward:true})&&e.begin>=e.mid){return c.TwoColumnsBeginExpanded}if(s({from:c.TwoColumnsBeginExpanded,separator:"begin",forward:false})&&e.begin<e.mid){return c.TwoColumnsMidExpanded}if(s({from:c.ThreeColumnsMidExpanded,separator:"begin",forward:true})&&a>=33){return c.ThreeColumnsMidExpandedEndHidden}if(s({from:c.ThreeColumnsMidExpandedEndHidden,separator:"begin",forward:false})&&a<33){return c.ThreeColumnsMidExpanded}if(s({from:c.ThreeColumnsMidExpandedEndHidden,separator:"end",forward:false})&&(e.end>=_.COLUMN_MIN_WIDTH||i)){return c.ThreeColumnsMidExpanded}if(s({from:c.ThreeColumnsMidExpanded,separator:"end",forward:false})&&e.mid<e.end){return c.ThreeColumnsEndExpanded}if(s({from:c.ThreeColumnsEndExpanded,separator:"end",forward:true})&&e.mid>=e.end){return c.ThreeColumnsMidExpanded}if(s({from:c.ThreeColumnsMidExpandedEndHidden,separator:"begin",forward:true})&&e.begin>=e.mid){return c.ThreeColumnsBeginExpandedEndHidden}if(s({from:c.ThreeColumnsBeginExpandedEndHidden,separator:"begin",forward:false})&&e.begin<e.mid){return c.ThreeColumnsMidExpandedEndHidden}if(s({from:c.ThreeColumnsMidExpanded,separator:"begin",forward:true})&&l&&(r>=_.COLUMN_MIN_WIDTH||i)){return c.ThreeColumnsMidExpandedEndHidden}if(s({from:c.TwoColumnsMidExpandedEndHidden,separator:"end",forward:false})&&l&&(e.end>=_.COLUMN_MIN_WIDTH||i)){return c.ThreeColumnsMidExpanded}return t};_.prototype._verifyColumnWidthsMatchLayout=function(e,t){var o=this.getMaxColumnsCount(),n=e.begin,i=Math.ceil(this._convertColumnPxWidthToPercent(n,t)),s={[c.TwoColumnsBeginExpanded]:function(){return e.begin>=e.mid},[c.TwoColumnsMidExpanded]:function(){return e.mid>e.begin},[c.ThreeColumnsEndExpanded]:function(){return e.end>e.mid&&i<33},[c.ThreeColumnsBeginExpandedEndHidden]:function(){return e.begin>=e.mid&&e.end===0},[c.ThreeColumnsMidExpanded]:function(){return e.mid>=e.end&&(o===3&&i<33||o===2&&i===0)},[c.ThreeColumnsMidExpandedEndHidden]:function(){return e.mid>e.begin&&e.end===0&&(o===3&&i>=33||o===2&&n>=_.COLUMN_MIN_WIDTH)}};return s[t]()};_.prototype._getColumnWidth=function(e){var t=this._$columns[e].get(0),o=t.style.width,n=parseInt(o),i;if(/px$/.test(o)){return n}i=/%$/.test(o);if(i&&n===100){return this._getControlWidth()}if(i&&n===0){return 0}return t.offsetWidth};_.prototype._cacheColumnWidth=function(e,t){var o;if(this._oColumnWidthInfo[e]!==t){o={};_.COLUMN_ORDER.forEach(function(t){o[t+"Column"]=t===e});this.fireColumnResize(o)}this._oColumnWidthInfo[e]=t};_.prototype._getLastVisibleColumnForLayout=function(e){var t=_.COLUMN_ORDER.slice(),o=this._getMaxColumnsCountForLayout(e,_.DESKTOP_BREAKPOINT);if(o>1){return t[o-1]}if(e===c.OneColumn){return"begin"}if(e===c.MidColumnFullScreen){return"mid"}if(e===c.EndColumnFullScreen){return"end"}};_.prototype._isNavigatingBackward=function(e,t){return[c.MidColumnFullScreen,c.EndColumnFullScreen].indexOf(t)>-1||_.COLUMN_ORDER.indexOf(this._getLastVisibleColumnForLayout(t))>_.COLUMN_ORDER.indexOf(this._getLastVisibleColumnForLayout(e))};_.prototype._shouldRevealColumn=function(e,t,o){var n=this._getMaxColumnsCountForLayout(t,_.DESKTOP_BREAKPOINT),i=this._getLastVisibleColumnForLayout(t),s=e===i,r=this._getMaxColumnsCountForLayout(o,_.DESKTOP_BREAKPOINT),a=o===c.MidColumnFullScreen||o===c.EndColumnFullScreen;return n>r&&!a&&s};_.prototype._isInteractivelyResizedColumn=function(e){return this._oMoveInfo&&this._isColumnAdjacentToDraggedSeparator(e)};_.prototype._isColumnAdjacentToDraggedSeparator=function(e){return this._oMoveInfo&&this._oMoveInfo.separator&&(this._$columns[e][0]===this._oMoveInfo.separator.previousElementSibling||this._$columns[e][0]===this._oMoveInfo.separator.nextElementSibling)};_.prototype._shouldConcealColumn=function(e,t,o){var n=this._getMaxColumnsCountForLayout(t,_.DESKTOP_BREAKPOINT),i=this._getMaxColumnsCountForLayout(o,_.DESKTOP_BREAKPOINT),s=this._getLastVisibleColumnForLayout(o),r=o===c.MidColumnFullScreen||o===c.EndColumnFullScreen;return n<i&&e===s&&!r&&this._getColumnSizeForLayout(e,t)===0};_.prototype._canResizeColumnWithAnimation=function(e,t){var o,n=t.width,i=t.hasAnimations,s=t.hidden,r=!t.previousAnimationCompleted;if(!i||s){return false}if(this._isInteractivelyResizedColumn(e)){return false}o=this._$columns[e];if(r){return o.width()!==n}if(this._bNeverRendered||t.autoSize){return false}return this._getColumnWidth(e)!==n};_.prototype._propagateContextualSettings=function(){};_.prototype._updateColumnContextualSettings=function(e,t){var o,n;o=this.getAggregation("_"+e+"ColumnNav");if(!o){return}n=o._getContextualSettings();if(!n||n.contextualWidth!==t){o._applyContextualSettings({contextualWidth:t})}};_.prototype._updateColumnCSSClasses=function(e,t){var n="";this._$columns[e].removeClass("sapUiContainer-Narrow sapUiContainer-Medium sapUiContainer-Wide sapUiContainer-ExtraWide");if(t<o.media._predefinedRangeSets[o.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0]){n="Narrow"}else if(t<o.media._predefinedRangeSets[o.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1]){n="Medium"}else if(t<o.media._predefinedRangeSets[o.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2]){n="Wide"}else{n="ExtraWide"}this._$columns[e].addClass("sapUiContainer-"+n)};_.prototype._getColumnSizeForLayout=function(e,t){var o=this._getColumnWidthDistributionForLayout(t),n=o.split("/"),i={begin:0,mid:1,end:2},s=n[i[e]];return parseFloat(s)};_.prototype.getMaxColumnsCount=function(){return this._getMaxColumnsCountForWidth(this._getControlWidth())};_.prototype._getMaxColumnsCountForWidth=function(e){if(e>=_.DESKTOP_BREAKPOINT){return 3}if(e>=_.TABLET_BREAKPOINT&&e<_.DESKTOP_BREAKPOINT){return 2}if(e>0){return 1}return 0};_.prototype._getMaxColumnsCountForLayout=function(e,t){var o=this._getMaxColumnsCountForWidth(t),n=this._getColumnWidthDistributionForLayout(e,false,o),i=n.split("/"),s={begin:0,mid:1,end:2},r,a,u=0;Object.keys(s).forEach(function(e){r=i[s[e]];a=parseInt(r);if(a){u++}});return u};_.prototype._onResize=function(e){var t=e.oldSize.width,o=e.size.width,n,i;this._iWidth=o;if(o===0){return}n=this._getMaxColumnsCountForWidth(t);i=this._getMaxColumnsCountForWidth(o);this._resizeColumns();if(i!==n){this._fireStateChange(false,true)}};_.prototype._setColumnPagesRendered=function(e,t){this._oRenderedColumnPagesBoolMap[e]=t};_.prototype._hasAnyColumnPagesRendered=function(){return Object.keys(this._oRenderedColumnPagesBoolMap).some(function(e){return this._oRenderedColumnPagesBoolMap[e]},this)};_.prototype._getRequiredColumnSeparatorsForLayout=function(e){var t={},n=[],i;if(o.system.phone){return[]}i=this.getMaxColumnsCount();if(i>1){t[c.TwoColumnsBeginExpanded]=["begin"];t[c.TwoColumnsMidExpanded]=["begin"];t[c.ThreeColumnsMidExpanded]=["begin","end"];t[c.ThreeColumnsEndExpanded]=["end"];t[c.ThreeColumnsMidExpandedEndHidden]=["begin","end"];t[c.ThreeColumnsBeginExpandedEndHidden]=["begin"];if(typeof t[e]==="object"){n=t[e]}}return n};_.prototype._hideShowColumnSeparators=function(e){var t=[],n;if(!this.isActive()||o.system.phone){return}e||(e=this.getLayout());t=this._getRequiredColumnSeparatorsForLayout(e);n=this._hasAnyColumnPagesRendered();Object.keys(this._oColumnSeparators).forEach(function(e){this._toggleSeparator(e,t.indexOf(e)!==-1,n)},this)};_.prototype._toggleSeparator=function(e,t,o){this._oColumnSeparators[e].toggle(t&&o);this._oColumnSeparators[e].data("visible",t)};_.prototype._fireStateChange=function(e,t){if(this._getControlWidth()===0){return}this.fireStateChange({isNavigationArrow:e,isResize:t,layout:this.getLayout(),maxColumnsCount:this.getMaxColumnsCount()})};_.prototype.setInitialBeginColumnPage=function(e){this._getBeginColumn().setInitialPage(e);this.setAssociation("initialBeginColumnPage",e,true);return this};_.prototype.setInitialMidColumnPage=function(e){this._getMidColumn().setInitialPage(e);this.setAssociation("initialMidColumnPage",e,true);return this};_.prototype.setInitialEndColumnPage=function(e){this._getEndColumn().setInitialPage(e);this.setAssociation("initialEndColumnPage",e,true);return this};_.prototype.to=function(e,t,o,n){if(this._getBeginColumn().getPage(e)){this._getBeginColumn().to(e,t,o,n)}else if(this._getMidColumn().getPage(e)){this._getMidColumn().to(e,t,o,n)}else{this._getEndColumn().to(e,t,o,n)}return this};_.prototype.backToPage=function(e,t,o){if(this._getBeginColumn().getPage(e)){this._getBeginColumn().backToPage(e,t,o)}else if(this._getMidColumn().getPage(e)){this._getMidColumn().backToPage(e,t,o)}else{this._getEndColumn().backToPage(e,t,o)}return this};_.prototype._safeBackToPage=function(e,t,o,n){if(this._getBeginColumn().getPage(e)){this._getBeginColumn()._safeBackToPage(e,t,o,n)}else if(this._getMidColumn().getPage(e)){this._getMidColumn()._safeBackToPage(e,t,o,n)}else{this._getEndColumn()._safeBackToPage(e,t,o,n)}};_.prototype.toBeginColumnPage=function(e,t,o,n){this._getBeginColumn().to(e,t,o,n);return this};_.prototype.toMidColumnPage=function(e,t,o,n){this._getMidColumn().to(e,t,o,n);return this};_.prototype.toEndColumnPage=function(e,t,o,n){this._getEndColumn().to(e,t,o,n);return this};_.prototype.backBeginColumn=function(e,t){return this._getBeginColumn().back(e,t)};_.prototype.backMidColumn=function(e,t){return this._getMidColumn().back(e,t)};_.prototype.backEndColumn=function(e,t){return this._getEndColumn().back(e,t)};_.prototype.backBeginColumnToPage=function(e,t,o){return this._getBeginColumn().backToPage(e,t,o)};_.prototype.backMidColumnToPage=function(e,t,o){return this._getMidColumn().backToPage(e,t,o)};_.prototype.backEndColumnToPage=function(e,t,o){return this._getEndColumn().backToPage(e,t,o)};_.prototype.backToTopBeginColumn=function(e,t){this._getBeginColumn().backToTop(e,t);return this};_.prototype.backToTopMidColumn=function(e,t){this._getMidColumn().backToTop(e,t);return this};_.prototype.backToTopEndColumn=function(e,t){this._getEndColumn().backToTop(e,t);return this};_.prototype.getCurrentBeginColumnPage=function(){return this._getBeginColumn().getCurrentPage()};_.prototype.getCurrentMidColumnPage=function(){return this._getMidColumn().getCurrentPage()};_.prototype.getCurrentEndColumnPage=function(){return this._getEndColumn().getCurrentPage()};_.prototype.setDefaultTransitionNameBeginColumn=function(e){this.setProperty("defaultTransitionNameBeginColumn",e,true);this._getBeginColumn().setDefaultTransitionName(e);return this};_.prototype.setDefaultTransitionNameMidColumn=function(e){this.setProperty("defaultTransitionNameMidColumn",e,true);this._getMidColumn().setDefaultTransitionName(e);return this};_.prototype.setDefaultTransitionNameEndColumn=function(e){this.setProperty("defaultTransitionNameEndColumn",e,true);this._getEndColumn().setDefaultTransitionName(e);return this};_.prototype._getLayoutHistory=function(){return this._oLayoutHistory};_.prototype._getColumnWidthDistributionForLayout=function(e,t,o){var n=this._getLocalStorage(o).get(e),i;o||(o=this.getMaxColumnsCount());if(o===0){i="0/0/0"}else if(o>1&&n){i=n}else{i=this._getDefaultColumnWidthDistributionForLayout(e,o)}if(t){i=i.split("/").map(function(e){return parseInt(e)})}return i};_.prototype._getDefaultColumnWidthDistributionForLayout=function(e,t){var o={};o[c.OneColumn]="100/0/0";o[c.MidColumnFullScreen]="0/100/0";o[c.EndColumnFullScreen]="0/0/100";if(t===1){o[c.TwoColumnsBeginExpanded]="0/100/0";o[c.TwoColumnsMidExpanded]="0/100/0";o[c.ThreeColumnsMidExpanded]="0/0/100";o[c.ThreeColumnsEndExpanded]="0/0/100";o[c.ThreeColumnsMidExpandedEndHidden]="0/0/100";o[c.ThreeColumnsBeginExpandedEndHidden]="0/0/100"}else{o[c.TwoColumnsBeginExpanded]="67/33/0";o[c.TwoColumnsMidExpanded]="33/67/0";o[c.ThreeColumnsMidExpanded]=t===2?"0/67/33":"25/50/25";o[c.ThreeColumnsEndExpanded]=t===2?"0/33/67":"25/25/50";o[c.ThreeColumnsMidExpandedEndHidden]="33/67/0";o[c.ThreeColumnsBeginExpandedEndHidden]="67/33/0"}return o[e]};_.prototype._attachAfterColumnResizedOnce=function(e,t,o){this._oAnimationEndListener.waitForColumnResizeEnd(this._$columns[e]).then(t).catch(function(){o&&o()})};_.prototype._attachAfterAllColumnsResizedOnce=function(e,t){this._oAnimationEndListener.waitForAllColumnsResizeEnd().then(e).catch(function(){t&&t()})};_.DESKTOP_BREAKPOINT=1280;_.TABLET_BREAKPOINT=960;_.COLUMN_MIN_WIDTH=312;_.STORAGE_PREFIX_TABLET="sap-f-fcl-tablet-column-width-distributions";_.STORAGE_PREFIX_DESKTOP="sap-f-fcl-desktop-column-width-distributions";_._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.f")};_.prototype.showPlaceholder=function(e){var t=sap.ui.require("sap/ui/core/Placeholder");if(!t||!t.isEnabled()){return}switch(e&&e.aggregation){case"beginColumnPages":return this.getAggregation("_beginColumnNav").showPlaceholder(e);case"midColumnPages":return this.getAggregation("_midColumnNav").showPlaceholder(e);default:return this.getAggregation("_endColumnNav").showPlaceholder(e)}};_.prototype.hidePlaceholder=function(e){switch(e.aggregation){case"beginColumnPages":this.getAggregation("_beginColumnNav").hidePlaceholder(e);break;case"midColumnPages":this.getAggregation("_midColumnNav").hidePlaceholder(e);break;default:this.getAggregation("_endColumnNav").hidePlaceholder(e)}};_.prototype.needPlaceholder=function(e,t){var o;switch(e){case"beginColumnPages":o=this.getAggregation("_beginColumnNav");break;case"midColumnPages":o=this.getAggregation("_midColumnNav");break;default:o=this.getAggregation("_endColumnNav")}return!t||o.getCurrentPage()!==t};function y(){this._aLayoutHistory=[]}y.prototype.addEntry=function(e){if(typeof e!=="undefined"){this._aLayoutHistory.push(e)}};y.prototype.getEntry=function(e,t){var o=this._aLayoutHistory;if(t){o=this._aLayoutHistory.slice().reverse()}return o[e]};y.prototype.getClosestEntryThatMatches=function(e){var t;for(t=this._aLayoutHistory.length-1;t>=0;t--){if(e.indexOf(this._aLayoutHistory[t])!==-1){return this._aLayoutHistory[t]}}};function v(){this._oListeners={};this._aPendingPromises=[];this._oPendingPromises={};this._oCancelPromises={};this._oPendingPromiseAll=null}v.prototype.waitForColumnResizeEnd=function(e){var t=e.get(0).id,o;if(!this._oPendingPromises[t]){o=new Promise(function(o,n){h.debug("FlexibleColumnLayout","wait for column "+t+" to resize");this._attachTransitionEnd(e,function(){h.debug("FlexibleColumnLayout","completed column "+t+" resize");this._cleanUp(e);o()}.bind(this));this._oCancelPromises[t]={cancel:function(){h.debug("FlexibleColumnLayout","cancel column "+t+" resize");this._cleanUp(e);n()}.bind(this)}}.bind(this));this._aPendingPromises.push(o);this._oPendingPromises[t]=o}return this._oPendingPromises[t]};v.prototype.waitForAllColumnsResizeEnd=function(){if(!this._oPendingPromiseAll){this._oPendingPromiseAll=new Promise(function(e,t){this.iTimer=setTimeout(function(){Promise.all(this._aPendingPromises).then(function(){h.debug("FlexibleColumnLayout","completed all columns resize");e()},0).catch(function(){t()});this.iTimer=null}.bind(this))}.bind(this))}return this._oPendingPromiseAll};v.prototype.isWaitingForColumnResizeEnd=function(e){var t=e.get(0).id;return!!this._oListeners[t]};v.prototype.cancelAll=function(){Object.keys(this._oCancelPromises).forEach(function(e){this._oCancelPromises[e].cancel()},this);this._oPendingPromises={};this._aPendingPromises=[];this._oCancelPromises={};this._oPendingPromiseAll=null;this._oListeners={};if(this.iTimer){clearTimeout(this.iTimer);this.iTimer=null}h.debug("FlexibleColumnLayout","detached all listeners for columns resize")};v.prototype._attachTransitionEnd=function(e,t){var o=e.get(0).id;if(!this._oListeners[o]){e.on("webkitTransitionEnd transitionend",t);this._oListeners[o]=t}};v.prototype._detachTransitionEnd=function(e){var t=e.get(0).id;if(this._oListeners[t]){e.off("webkitTransitionEnd transitionend",this._oListeners[t]);this._oListeners[t]=null}};v.prototype._cleanUp=function(e){if(e.length){var t=e.get(0).id;this._detachTransitionEnd(e);delete this._oPendingPromises[t];delete this._oCancelPromises[t]}};function E(e,t,o){var n;if(e===t){return"100%"}n=o?e-_.COLUMN_SEPARATOR_WIDTH:e;return n+"px"}function M(e){return e.classList.contains("sapFFCLColumnSeparatorBegin")?"begin":"end"}function b(e,t,o){var n=e.classList.contains("sapFFCLColumnSeparatorBegin");if(o===2&&t==c.ThreeColumnsMidExpandedEndHidden){return n?["begin","mid"]:["begin","end"]}if(o===2&&t==c.ThreeColumnsMidExpanded){return n?["begin","end"]:["mid","end"]}return n?["begin","mid"]:["mid","end"]}function T(e){var t=e;if(e.changedTouches&&e.changedTouches[0]){t=t.changedTouches[0]}return t.pageX}return _});
//# sourceMappingURL=FlexibleColumnLayout.js.map