/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BarInPageEnabler","./library","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/Device","./BarRenderer","sap/ui/thirdparty/jquery","sap/ui/core/Configuration"],function(t,e,i,r,s,o,jQuery,a){"use strict";var n=e.BarDesign;var l=e.TitleAlignment;var p=i.extend("sap.m.Bar",{metadata:{interfaces:["sap.m.IBar"],library:"sap.m",properties:{enableFlexBox:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},translucent:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},design:{type:"sap.m.BarDesign",group:"Appearance",defaultValue:n.Auto},titleAlignment:{type:"sap.m.TitleAlignment",group:"Misc",defaultValue:l.None}},aggregations:{contentLeft:{type:"sap.ui.core.Control",multiple:true,singularName:"contentLeft"},contentMiddle:{type:"sap.ui.core.Control",multiple:true,singularName:"contentMiddle"},contentRight:{type:"sap.ui.core.Control",multiple:true,singularName:"contentRight"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designtime:"sap/m/designtime/Bar.designtime",dnd:{draggable:false,droppable:true}},renderer:o});p.prototype.onBeforeRendering=function(){var t=this.getTitleAlignment(),e;this._removeAllListeners();for(e in l){if(e!==t){this.removeStyleClass("sapMBarTitleAlign"+e)}else{this.addStyleClass("sapMBarTitleAlign"+e)}}};p.prototype.onAfterRendering=function(){this._handleResize()};p.prototype.init=function(){this.data("sap-ui-fastnavgroup","true",true);this._sPrevTitleAlignmentClass=""};p.prototype.exit=function(){this._removeAllListeners();if(this._oflexBox){this._oflexBox.destroy();this._oflexBox=null}this._$MidBarPlaceHolder=null;this._$RightBar=null;this._$LeftBar=null};p._aResizeHandlers=["_sResizeListenerId","_sResizeListenerIdMid","_sResizeListenerIdRight","_sResizeListenerIdLeft"];p.prototype._removeAllListeners=function(){var t=this;p._aResizeHandlers.forEach(function(e){t._removeListenerFailsave(e)})};p.prototype._removeListenerFailsave=function(t){if(this[t]){r.deregister(this[t]);this[t]=null}};p.prototype._handleResize=function(){this._removeAllListeners();var t=!!this.getContentLeft().length,e=!!this.getContentMiddle().length,i=!!this.getContentRight().length;if(!e){e=this._oflexBox&&!!this._oflexBox.getItems().length}if(!this.getVisible()){return}if(!t&&!e&&!i){return}this._$LeftBar=this.$("BarLeft");this._$RightBar=this.$("BarRight");this._$MidBarPlaceHolder=this.$("BarPH");this._sResizeListenerId=r.register(this.getDomRef(),jQuery.proxy(this._handleResize,this));if(this.getEnableFlexBox()){this._updatePosition(t,e,i);return}if(t){this._sResizeListenerIdLeft=r.register(this._$LeftBar[0],jQuery.proxy(this._handleResize,this))}else{this._$LeftBar.addClass("sapMBarEmpty")}if(e){this._sResizeListenerIdMid=r.register(this._$MidBarPlaceHolder[0],jQuery.proxy(this._handleResize,this))}else{this._$MidBarPlaceHolder.addClass("sapMBarEmpty")}if(i){this._sResizeListenerIdRight=r.register(this._$RightBar[0],jQuery.proxy(this._handleResize,this))}else{this._$RightBar.addClass("sapMBarEmpty")}this._updatePosition(t,e,i)};p.prototype._updatePosition=function(t,e,i){if(!t&&e&&!i){return}if(t&&!e&&!i){return}if(!t&&!e&&i){return}var r=this.$().outerWidth(true);this._$RightBar.css({width:""});this._$LeftBar.css({width:""});this._$MidBarPlaceHolder.css({position:"",width:"",visibility:"hidden"});var s=this._$RightBar.outerWidth(true);if(s>r){if(t){this._$LeftBar.css({width:"0px"})}if(e){this._$MidBarPlaceHolder.css({width:"0px"})}this._$RightBar.css({width:r+"px"});return}var o=this._getBarContainerWidth(this._$LeftBar);if(r<o+s){o=r-s;this._$LeftBar.css({width:o+"px"});this._$MidBarPlaceHolder.css({width:"0px"});return}this._$MidBarPlaceHolder.css(this._getMidBarCss(s,r,o))};p.prototype._getMidBarCss=function(t,e,i){var r=this._$MidBarPlaceHolder.outerWidth(true),s=a.getRTL(),o={visibility:""};if(this.getEnableFlexBox()){var n=s?"right":"left";r=e-i-t-parseInt(this._$MidBarPlaceHolder.css("margin-left"))-parseInt(this._$MidBarPlaceHolder.css("margin-right"));o.position="absolute";o.width=r+"px";o[n]=i;return o}var p=e-i-t,d=e/2-r/2,h=i>d,g=e/2+r/2,u=e-t<g,f=this.getTitleAlignment();if(f!==l.None&&f!==l.Center||p>0&&(h||u)){o.position="absolute";o.width=p+"px";o.left=s?t:i}return o};p.prototype._getBarContainerWidth=function(t){var e,i=0,r=t.children(),o=0;if(s.browser.webkit||s.browser.firefox){for(e=0;e<r.length;e++){o+=jQuery(r[e]).outerWidth(true)}i=t.outerWidth(true)}else{var a;for(e=0;e<r.length;e++){a=window.getComputedStyle(r[e]);if(a.width=="auto"){o+=jQuery(r[e]).width()+1}else{o+=parseFloat(a.width)}o+=parseFloat(a.marginLeft);o+=parseFloat(a.marginRight);o+=parseFloat(a.paddingLeft);o+=parseFloat(a.paddingRight)}var n=window.getComputedStyle(t[0]);i+=parseFloat(n.width);i+=parseFloat(n.marginLeft);i+=parseFloat(n.marginRight);i+=parseFloat(n.paddingLeft);i+=parseFloat(n.paddingRight)}if(i<o){i=o}return i};var d=t.extend("sap.m.BarInAnyContentEnabler",{});d.mContexts={dialogFooter:{contextClass:"sapMFooter-CTX",tag:"Footer"}};d.prototype.getContext=function(){var e=t.prototype.getContext.call();for(var i in d.mContexts){e[i]=d.mContexts[i]}return e};p.prototype.getContext=d.prototype.getContext;p.prototype.isContextSensitive=d.prototype.isContextSensitive;p.prototype.setHTMLTag=d.prototype.setHTMLTag;p.prototype.getHTMLTag=d.prototype.getHTMLTag;p.prototype.applyTagAndContextClassFor=d.prototype.applyTagAndContextClassFor;p.prototype._applyContextClassFor=d.prototype._applyContextClassFor;p.prototype._applyTag=d.prototype._applyTag;p.prototype._getContextOptions=d.prototype._getContextOptions;p.prototype._setRootAccessibilityRole=d.prototype._setRootAccessibilityRole;p.prototype._getRootAccessibilityRole=d.prototype._getRootAccessibilityRole;p.prototype._setRootAriaLevel=d.prototype._setRootAriaLevel;p.prototype._getRootAriaLevel=d.prototype._getRootAriaLevel;return p});
//# sourceMappingURL=Bar.js.map