/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/ShortcutHintsMixin","sap/ui/core/EnabledPropagator","sap/ui/core/AccessKeysEnablement","sap/ui/core/IconPool","sap/ui/Device","sap/ui/core/ContextMenuSupport","sap/ui/core/library","./ButtonRenderer","sap/ui/events/KeyCodes","sap/ui/core/LabelEnablement","sap/m/BadgeEnabler","sap/ui/core/InvisibleText","sap/base/Log","sap/m/Image"],function(e,t,i,s,a,n,o,r,c,u,h,l,p,g,d,f,_){"use strict";var b=u.TextDirection;var y=e.ButtonType;var m=e.ButtonAccessibilityType;var v=e.ButtonAccessibleRole;var I=e.BadgeState;var T=u.aria.HasPopup;var B=1,A=9999;var S=i.extend("sap.m.Button",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.ui.core.IAccessKeySupport","sap.m.IToolbarInteractiveControl"],library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:""},type:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:y.Default},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},iconFirst:{type:"boolean",group:"Appearance",defaultValue:true},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:b.Inherit},ariaHasPopup:{type:"sap.ui.core.aria.HasPopup",group:"Accessibility",defaultValue:T.None},accessibleRole:{type:"sap.m.ButtonAccessibleRole",group:"Accessibility",defaultValue:v.Default},highlightAccKeysRef:{type:"boolean",defaultValue:false,visibility:"hidden"},accesskey:{type:"string",defaultValue:"",visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tap:{deprecated:true},press:{}},designtime:"sap/m/designtime/Button.designtime",dnd:{draggable:true,droppable:false}},renderer:h});a.call(S.prototype);c.apply(S.prototype);g.call(S.prototype);S.prototype.init=function(){this._onmouseenter=this._onmouseenter.bind(this);this._buttonPressed=false;s.addConfig(this,{event:"press",position:"0 0",addAccessibilityLabel:true},this);this.initBadgeEnablement({position:"topRight",selector:{suffix:"inner"}});this._oBadgeData={value:"",state:""};this._badgeMinValue=B;this._badgeMaxValue=A;n.registerControl(this)};S.prototype.badgeValueFormatter=function(e){var t=parseInt(e),i=this.getBadgeCustomData(),s=i.getVisible();if(isNaN(t)){return false}if(t<this._badgeMinValue){s&&i.setVisible(false)}else{!s&&i.setVisible(true);if(t>this._badgeMaxValue&&e.indexOf("+")===-1){e=this._badgeMaxValue<1e3?this._badgeMaxValue+"+":"999+"}}return e};S.prototype.setBadgeMinValue=function(e){var t=this.getBadgeCustomData().getValue();if(e&&!isNaN(e)&&e>=B&&e!=this._badgeMinValue&&e<=this._badgeMaxValue){this._badgeMinValue=e;this.badgeValueFormatter(t);this.invalidate()}else{f.warning("minValue is not valid (it is is less than minimum allowed badge value ["+B+"] or greater than maximum badge value ["+this._badgeMaxValue+"])",this)}return this};S.prototype.setBadgeMaxValue=function(e){if(e&&!isNaN(e)&&e<=A&&e!=this._badgeMaxValue&&e>=this._badgeMinValue){this._badgeMaxValue=e;this.invalidate()}else{f.warning("maxValue is not valid (it is is greater than than maximum allowed badge value ["+A+"] or less than minimum badge value ["+this._badgeMinValue+"])",this)}return this};S.prototype.onBadgeUpdate=function(e,t){if(this._oBadgeData.value!==e||this._oBadgeData.state!==t){if(t===I.Disappear){e=""}this._updateBadgeInvisibleText(e);this._oBadgeData={value:e,state:t}}};S.prototype._updateBadgeInvisibleText=function(e){var i=t.getLibraryResourceBundle("sap.m"),s,a;e=e.toString().trim();a=e.indexOf("+");if(a!==-1){s=i.getText("BUTTON_BADGE_MORE_THAN_ITEMS",e.substr(0,a))}else{switch(e){case"":s="";break;case"1":s=i.getText("BUTTON_BADGE_ONE_ITEM",e);break;default:s=i.getText("BUTTON_BADGE_MANY_ITEMS",e)}}this._getBadgeInvisibleText().setText(s)};S.prototype._getBadgeInvisibleText=function(){if(!this._oBadgeInvisibleText){this._oBadgeInvisibleText=new d(this.getId()+"-badge").toStatic()}return this._oBadgeInvisibleText};S.prototype.exit=function(){if(this._image){this._image.destroy()}if(this._iconBtn){this._iconBtn.destroy()}if(this._oBadgeInvisibleText){this._oBadgeInvisibleText.destroy();this._oBadgeData=null}this._bFocused=null;this.$().off("mouseenter",this._onmouseenter)};S.prototype.setType=function(e){this.setProperty("type",e);switch(e){case y.Critical:this._sTypeIconURI="sap-icon://alert";break;case y.Negative:this._sTypeIconURI="sap-icon://error";break;case y.Success:this._sTypeIconURI="sap-icon://sys-enter-2";break;case y.Neutral:this._sTypeIconURI="sap-icon://information";break;case y.Back:case y.Up:this._sTypeIconURI="sap-icon://nav-back";break;default:this._sTypeIconURI=null}return this};S.prototype.onBeforeRendering=function(){this._bRenderActive=this._bActive;this._updateAccessKey();this.$().off("mouseenter",this._onmouseenter)};S.prototype._updateAccessKey=function(){var e=this.getText();if(e){this.setProperty("accesskey",e[0].toLowerCase())}};S.prototype.onAfterRendering=function(){if(this._bRenderActive){this._activeButton();this._bRenderActive=this._bActive}if(this._bFocused){this._toggleLiveChangeAnnouncement("polite")}this.$().on("mouseenter",this._onmouseenter)};S.prototype.ontouchstart=function(e){e.setMarked();if(this._bRenderActive){delete this._bRenderActive}if(e.targetTouches.length===1){this._buttonPressed=true;this._activeButton()}if(this.getEnabled()&&this.getVisible()){if((r.browser.safari||r.browser.firefox)&&(e.originalEvent&&e.originalEvent.type==="mousedown")){this._setButtonFocus()}this._sTouchStartTargetId=e.target.id.replace(this.getId(),"")}else{this._sTouchStartTargetId=""}};S.prototype.ontouchend=function(e){var t;this._buttonPressed=e.originalEvent&&e.originalEvent.buttons&1;this._inactiveButton();if(this._bRenderActive){delete this._bRenderActive;this.ontap(e,true)}t=e.target.id.replace(this.getId(),"");if(this._buttonPressed===0&&(this._sTouchStartTargetId==="-BDI-content"&&(t==="-content"||t==="-inner"||t==="-img")||this._sTouchStartTargetId==="-content"&&(t==="-inner"||t==="-img")||this._sTouchStartTargetId==="-img"&&t!=="-img")){this.ontap(e,true)}this._sTouchStartTargetId=""};S.prototype.ontouchcancel=function(){this._buttonPressed=false;this._sTouchStartTargetId="";this._inactiveButton()};S.prototype.ontap=function(e,t){e.setMarked();delete this._bRenderActive;if(this.bFromTouchEnd){return}if(this.getEnabled()&&this.getVisible()){if(e.originalEvent&&e.originalEvent.type==="touchend"){this.focus()}this.fireTap({});this.firePress({})}this.bFromTouchEnd=t;if(this.bFromTouchEnd){setTimeout(function(){delete this.bFromTouchEnd}.bind(this),0)}};S.prototype.onkeydown=function(e){if((e.which===l.SPACE||e.which===l.ENTER||e.which===l.ESCAPE||e.which===l.SHIFT)&&!e.ctrlKey&&!e.metaKey){if(e.which===l.SPACE||e.which===l.ENTER){e.setMarked();this._activeButton()}if(e.which===l.ENTER){this.firePress({})}if(e.which===l.SPACE){this._bPressedSpace=true}if(this._bPressedSpace){if(e.which===l.SHIFT||e.which===l.ESCAPE){this._bPressedEscapeOrShift=true;this._inactiveButton()}}}else{if(this._bPressedSpace){e.preventDefault()}}};S.prototype.onkeyup=function(e){if(e.which===l.ENTER){e.setMarked();this._inactiveButton()}if(e.which===l.SPACE){if(!this._bPressedEscapeOrShift){e.setMarked();this._inactiveButton();this.firePress({})}else{this._bPressedEscapeOrShift=false}this._bPressedSpace=false}if(e.which===l.ESCAPE){this._bPressedSpace=false}};S.prototype._onmouseenter=function(e){if(this._buttonPressed&&e.originalEvent&&e.originalEvent.buttons&1){this._activeButton()}};S.prototype.onfocusin=function(){this._bFocused=true;this._toggleLiveChangeAnnouncement("polite")};S.prototype.onfocusout=function(){this._buttonPressed=false;this._bFocused=false;this._sTouchStartTargetId="";this._inactiveButton();this._toggleLiveChangeAnnouncement("off")};S.prototype._toggleLiveChangeAnnouncement=function(e){if(this._getText()){this.$("BDI-content").attr("aria-live",e)}else if(this._getAppliedIcon()){this.$("tooltip").attr("aria-live",e)}};S.prototype._activeButton=function(){if(!this._isUnstyled()){this.$("inner").addClass("sapMBtnActive")}this._bActive=this.getEnabled();if(this._bActive){if(this._getAppliedIcon()&&this.getActiveIcon()&&this._image){this._image.setSrc(this.getActiveIcon())}}};S.prototype._inactiveButton=function(){if(!this._isUnstyled()){this.$("inner").removeClass("sapMBtnActive")}this._bActive=false;if(this.getEnabled()){if(this._getAppliedIcon()&&this.getActiveIcon()&&this._image){this._image.setSrc(this._getAppliedIcon())}}};S.prototype._isHoverable=function(){return this.getEnabled()&&r.system.desktop};S.prototype._getImage=function(e,t,i,s){var a=o.isIconURI(t),n;if(this._image&&this._image.isA("sap.m.Image")&&a||this._image&&this._image.isA("sap.ui.core.Icon")&&!a){this._image.destroy();this._image=undefined}n=this.getIconFirst();if(this._image){this._image.setSrc(t);if(this._image.isA("sap.m.Image")){this._image.setActiveSrc(i);this._image.setDensityAware(s)}}else{this._image=o.createControlByURI({id:e,src:t,activeSrc:i,densityAware:s,useIconTooltip:false},_).addStyleClass("sapMBtnCustomIcon").setParent(this,null,true)}this._image.addStyleClass("sapMBtnIcon");this._image.toggleStyleClass("sapMBtnIconLeft",n);this._image.toggleStyleClass("sapMBtnIconRight",!n);return this._image};S.prototype._getInternalIconBtn=function(e,t){var i=this._iconBtn;if(i){i.setSrc(t)}else{i=o.createControlByURI({id:e,src:t,useIconTooltip:false},_).setParent(this,null,true)}i.addStyleClass("sapMBtnIcon");i.addStyleClass("sapMBtnIconLeft");this._iconBtn=i;return this._iconBtn};S.prototype._isUnstyled=function(){var e=false;if(this.getType()===y.Unstyled){e=true}return e};S.prototype.getPopupAnchorDomRef=function(){return this.getDomRef("inner")};S.prototype._getText=function(){return this.getText()};S.prototype._getTooltip=function(){var e,t;e=this.getTooltip_AsString();if(!e&&!this._getText()){t=o.getIconInfo(this._getAppliedIcon());if(t){e=t.text?t.text:t.name}}return e};S.prototype._getAppliedIcon=function(){return this.getIcon()||this._sTypeIconURI};S.prototype.getAccessibilityInfo=function(){var e=this._getText()||this.getTooltip_AsString(),i=this.getAccessibleRole();if(!e&&this._getAppliedIcon()){var s=o.getIconInfo(this._getAppliedIcon());if(s){e=s.text||s.name}}return{role:i===v.Default?"button":i.toLowerCase(),type:t.getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_BUTTON"),description:e,focusable:this.getEnabled(),enabled:this.getEnabled()}};S.prototype._setButtonFocus=function(){setTimeout(function(){this.focus()}.bind(this),0)};S.prototype._determineSelfReferencePresence=function(){var e=this.getAriaLabelledBy(),t=e.indexOf(this.getId())!==-1,i=p.getReferencingLabels(this).length>0,s=this.getParent(),a=!!(s&&s.enhanceAccessibilityState);return!t&&this._getText()&&(e.length>0||i||a||this._isBadgeButton())};S.prototype._determineAccessibilityType=function(){var e=this.getAriaLabelledBy().length>0,t=this.getAriaDescribedBy().length>0,i=p.getReferencingLabels(this).length>0,s=this.getType()!==y.Default,a=e||i||this._determineSelfReferencePresence(),n=t||s||this._isBadgeButton(),o;if(!a&&!n){o=m.Default}else if(a&&!n){o=m.Labelled}else if(!a&&n){o=m.Described}else if(a&&n){o=m.Combined}return o};S.prototype._isBadgeButton=function(){return this._oBadgeData&&this._oBadgeData.value!==""&&this._oBadgeData.State!==I.Disappear};S.prototype._getTitleAttribute=function(e){return this.getTooltip()};S.prototype._getToolbarInteractive=function(){return true};return S});
//# sourceMappingURL=Button.js.map