/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/library","sap/ui/core/Core","sap/ui/core/LocaleData","sap/ui/core/Theming","sap/ui/core/theming/Parameters","sap/m/IllustratedMessage","sap/m/Button","sap/ui/core/InvisibleMessage"],function(e,t,a,r,n,i,o,s){"use strict";var u={};var l="";var c=parseFloat(e.BaseFontSize);var m=null;var p=null;u.measureText=function(){var e=.05;var t=document.createElement("canvas").getContext("2d");var a=function(){l=[parseFloat(n.get({name:"sapMFontMediumSize"})||"0.875rem")*c+"px",n.get({name:"sapUiFontFamily"})||"Arial"].join(" ");return l};r.attachApplied(a);return function(r,n){t.font=n||l||a();return t.measureText(r||"").width/c+e}}();u.calcTypeWidth=function(){const e=a.getInstance(t.getConfiguration().getLocale()).getTimezoneTranslations();let n;var i=0;var o=[2023,9,26,22,47,58,999];var s=new Date(Date.UTC.apply(0,o));var l=new(Function.prototype.bind.apply(Date,[null].concat(o)));var c={Byte:3,SByte:3,Int16:5,Int32:9,Int64:12,Single:6,Float:12,Double:13,Decimal:15,Integer:9};r.attachApplied(function(){i=0});const m=function(){if(!n){[n]=Object.entries(e).reduce(([e,t],[a,r])=>typeof r==="string"&&r.length>t?[a,r.length]:[e,t],["",0])}return n};return function(e,a){var r=e.getMetadata().getName().split(".").pop();var n=a&&a.maxWidth||19;var o=a&&a.gap||0;var p=function(e){return Math.min(e+o,n)};if(r=="Boolean"){if(!i){var d=t.getLibraryResourceBundle("sap.ui.core");var f=u.measureText(d.getText("YES"));var g=u.measureText(d.getText("NO"));i=Math.max(f,g)}return p(i)}if(r=="String"||e.isA("sap.ui.model.odata.type.String")){var v=parseInt(e.getConstraints().maxLength)||0;if(!v||v*.25>n){return n}var T=u.measureText("A".repeat(v));if(v<n||n<10){return p(T)}var h=Math.log(T-n*.16)/Math.log(n/3)*(n/2)*Math.pow(n/19,1/T);return p(Math.min(h,T))}if(r.startsWith("Date")||r.startsWith("Time")){var x=e.getFormatOptions();var M=x.UTC?s:l;var A=M.toLocaleDateString();if(r=="TimeOfDay"){A=new Intl.DateTimeFormat("de",{hour:"numeric",minute:"numeric",second:"numeric"}).format(M);A=e.formatValue(A,"string")}else if(e.isA("sap.ui.model.odata.type.Time")){A=e.formatValue({__edmType:"Edm.Time",ms:s.valueOf()},"string")}else if(e.isA("sap.ui.model.odata.type.DateTimeWithTimezone")){A=e.formatValue([M,m()],"string")}else{A=e.formatValue(x.interval?[M,new Date(M*1.009)]:M,"string");(e.oFormat&&e.oFormat.oFormatOptions&&e.oFormat.oFormatOptions.pattern||"").replace(/[MELVec]{3,4}/,function(e){A+=e.length==4?"---":"-"})}return p(u.measureText(A))}if(c[r]){var L=parseInt(e.getConstraints().scale)||0;var y=parseInt(e.getConstraints().precision)||20;y=Math.min(y,c[r]);var E=2*Math.pow(10,y-L-1);E=e.formatValue(E,"string");return p(u.measureText(E))}return a&&a.defaultWidth||8}}();u.calcHeaderWidth=function(){var e="";var t="";var a=function(){if(!e){e=[n.get({name:"sapUiColumnHeaderFontWeight"})||"normal",l].join(" ")}return e};var i=function(){if(!t){t=[n.get({name:"sapMFontLargeSize"})||"normal",l].join(" ")}return t};r.attachApplied(function(){e="";t=""});return function(e,t,r,n,o){var s=e.length;var l=0;r=r||19;n=n||2;if(t>r){return r}if(n>s){return n}if(o){l=.125+u.measureText("*",i())}if(!t){var c=u.measureText(e,a());return c+l}t=Math.max(t,n);if(t>s){return t}var m=u.measureText(e,a());m=Math.min(m,r*.7);var p=Math.max(1,1-Math.log(Math.max(t-1.7,.2))/Math.log(r*.5)+1);var d=p*t;var f=Math.max(0,m-d);var c=f<.15?m:d+f*(1-1/t)/Math.E;return c+l}}();u.calcColumnWidth=function(e,t,a){if(!Array.isArray(e)){e=[e]}a=Object.assign({minWidth:2,maxWidth:19,defaultWidth:8,truncateLabel:true,padding:1.0625,gap:0},a);var r=0;var n=Math.max(1,a.minWidth);var i=Math.max(n,a.maxWidth);var o=a.treeColumn?3:0;var s=a.gap+o+e.reduce(function(e,t){var r=t,n={defaultWidth:a.defaultWidth,maxWidth:a.maxWidth};if(Array.isArray(t)){r=t[0];n=t[1]||n}var i=u.calcTypeWidth(r,n);return a.verticalArrangement?Math.max(e,i):e+i+(e&&.5)},0);if(t){r=u.calcHeaderWidth(t,a.truncateLabel?s:0,i,n,a.required);r+=a.headerGap?(8+14)/c:0}s=Math.max(n,s,r);s=Math.min(s,i);s=Math.ceil(s*100)/100;return s+a.padding+"rem"};u.getNoColumnsIllustratedMessage=function(a){var r=t.getLibraryResourceBundle("sap.m");var n=new i({illustrationType:e.IllustratedMessageType.AddColumn,title:r.getText("TABLE_NO_COLUMNS_TITLE"),description:r.getText("TABLE_NO_COLUMNS_DESCRIPTION")});if(a){var s=new o({icon:"sap-icon://action-settings",press:a});n.addAdditionalContent(s)}return n};u.getSelectAllPopover=function(){if(p){return p}p=Promise.all([new Promise(function(e){sap.ui.require(["sap/m/Popover","sap/m/Bar","sap/m/HBox","sap/m/Title","sap/ui/core/Icon","sap/ui/core/library","sap/m/Text"],function(t,a,r,n,i,o,s){e({Popover:t,Bar:a,HBox:r,Title:n,Icon:i,coreLib:o,Text:s})})}),t.getLibraryResourceBundle("sap.m",true)]).then(function(e){var t=e[0];var a=e[1];var r=t.coreLib.IconColor.Critical,n=t.coreLib.TitleLevel.H2;m=new t.Popover({customHeader:new t.Bar({contentMiddle:[new t.HBox({items:[new t.Icon({src:"sap-icon://message-warning",color:r}).addStyleClass("sapUiTinyMarginEnd"),new t.Title({text:a.getText("TABLE_SELECT_LIMIT_TITLE"),level:n})],renderType:"Bare",justifyContent:"Center",alignItems:"Center"})]}),content:[new t.Text]}).addStyleClass("sapUiContentPadding");return{oSelectAllNotificationPopover:m,oResourceBundle:a}});return p};u.showSelectionLimitPopover=function(e,t){u.getSelectAllPopover().then(function(a){var r=a.oSelectAllNotificationPopover;var n=a.oResourceBundle;var i=n.getText("TABLE_SELECT_LIMIT",[e]);r.getContent()[0].setText(i);if(t){r.openBy(t)}})};u.hideSelectionLimitPopover=function(){if(m&&m.isOpen()){m.close()}};u.announceTableUpdate=function(e,a){var r=s.getInstance();if(r){var n=t.getLibraryResourceBundle("sap.m");if(a==undefined){r.announce(n.getText("table.ANNOUNCEMENT_TABLE_UPDATED",[e]))}else if(a>1){r.announce(n.getText("table.ANNOUNCEMENT_TABLE_UPDATED_MULT",[e,a]))}else if(a===1){r.announce(n.getText("table.ANNOUNCEMENT_TABLE_UPDATED_SING",[e,a]))}else{r.announce(n.getText("table.ANNOUNCEMENT_TABLE_UPDATED_NOITEMS",[e]))}}};u.isEmpty=function(e){if(!e){return true}var t=e.getLength();if(t===1&&e.isA("sap.ui.model.analytics.AnalyticalBinding")){var a=e?e.providesGrandTotal()&&e.hasTotaledMeasures():false;if(a){t=0}}return t<=0};return u});
//# sourceMappingURL=Util.js.map