/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/ObjectPath","sap/base/assert","sap/base/Log","sap/base/util/isPlainObject","sap/base/util/resolveReference"],function(e,t,n,r,a){"use strict";var i=function(){throw new Error};i.prototype.getName=function(){return undefined};i.prototype.getBaseType=function(){return undefined};i.prototype.getPrimitiveType=function(){var e=this;while(e.getBaseType()){e=e.getBaseType()}return e};i.prototype.getComponentType=function(){return undefined};i.prototype.getDefaultValue=function(){return undefined};i.prototype.isArrayType=function(){return false};i.prototype.isEnumType=function(){return false};i.prototype.getEnumValues=function(){return undefined};i.prototype.parseValue=function(e){return e};i.prototype.isValid=undefined;i.prototype.setNormalizer=function(e){t(typeof e==="function","DataType.setNormalizer: fnNormalizer must be a function");this._fnNormalizer=typeof e==="function"?e:undefined};i.prototype.normalize=function(e){return this._fnNormalizer?this._fnNormalizer(e):e};function u(e,t,n){t=t||{};var r=n||i.prototype;var a=Object.create(r);a.getName=function(){return e};if(t.hasOwnProperty("defaultValue")){var u=t.defaultValue;a.getDefaultValue=function(){return u}}if(t.isValid){var o=t.isValid;a.isValid=r.isValid?function(e){if(!r.isValid(e)){return false}return o(e)}:o}if(t.parseValue){a.parseValue=t.parseValue}a.getBaseType=function(){return n};return a}var o={any:u("any",{defaultValue:null,isValid:function(e){return true}}),boolean:u("boolean",{defaultValue:false,isValid:function(e){return typeof e==="boolean"},parseValue:function(e){return e=="true"}}),int:u("int",{defaultValue:0,isValid:function(e){return typeof e==="number"&&(isNaN(e)||Math.floor(e)==e)},parseValue:function(e){return parseInt(e)}}),float:u("float",{defaultValue:0,isValid:function(e){return typeof e==="number"},parseValue:function(e){return parseFloat(e)}}),string:u("string",{defaultValue:"",isValid:function(e){return typeof e==="string"||e instanceof String},parseValue:function(e){return e}}),object:u("object",{defaultValue:null,isValid:function(e){return typeof e==="object"||typeof e==="function"},parseValue:function(e){return e?JSON.parse(e):null}}),function:u("function",{defaultValue:null,isValid:function(e){return e==null||typeof e==="function"},parseValue:function(e,t){if(e===""){return undefined}if(!/^\.?[A-Z_\$][A-Z0-9_\$]*(\.[A-Z_\$][A-Z0-9_\$]*)*$/i.test(e)){throw new Error("Function references must consist of dot separated "+"simple identifiers (A-Z, 0-9, _ or $) only, but was '"+e+"'")}var n,r=t&&t.context,i=t&&t.locals;n=a(e,Object.assign({".":r},i));if(n&&this.isValid(n)){return n}throw new TypeError("The string '"+e+"' couldn't be resolved to a function")}})};var s=u("array",{defaultValue:[]});function f(e){t(e instanceof i,"DataType.<createArrayType>: componentType must be a DataType");var n=Object.create(i.prototype);n.getName=function(){return e.getName()+"[]"};n.getComponentType=function(){return e};n.isValid=function(t){if(t===null){return true}if(Array.isArray(t)){for(var n=0;n<t.length;n++){if(!e.isValid(t[n])){return false}}return true}return false};n.parseValue=function(t){var n=t.split(",");for(var r=0;r<n.length;r++){n[r]=e.parseValue(n[r])}return n};n.isArrayType=function(){return true};n.getBaseType=function(){return s};return n}const p=Object.create(null);function l(e,t){var n={},r;for(var a in t){var u=t[a];if(!r){r=u}if(typeof u!=="string"){throw new Error("Value "+u+" for enum type "+e+" is not a string")}if(!n.hasOwnProperty(u)||a==u){n[u]=a}}var s=Object.create(i.prototype);s.getName=function(){return e};s.isValid=function(e){return typeof e==="string"&&n.hasOwnProperty(e)};s.parseValue=function(e){return t[e]};s.getDefaultValue=function(){return r};s.getBaseType=function(){return o.string};s.isEnumType=function(){return true};s.getEnumValues=function(){return t};return s}i.getType=function(a){t(a&&typeof a==="string","sTypeName must be a non-empty string");var u=o[a];if(!(u instanceof i)){if(a.indexOf("[]",a.length-2)>0){var s=a.slice(0,-2),y=this.getType(s);u=y&&f(y);if(u){o[a]=u}}else if(a!=="array"){u=p[a];if(u==null){u=e.get(a);if(u!=null){n.error(`The type '${a}' was accessed via globals. Defining enums via globals is deprecated. Please require the module 'sap/ui/base/DataType' and call the static 'DataType.registerEnum' API.`)}}if(u instanceof i){o[a]=u}else if(r(u)){u=o[a]=l(a,u);delete p[a]}else if(u){n.warning("[FUTURE FATAL] '"+a+"' is not a valid data type. Falling back to type 'any'.");u=o.any}else{n.error("[FUTURE FATAL] data type '"+a+"' could not be found.");u=undefined}}}return u};i.createType=function(e,r,a){t(typeof e==="string"&&e,"DataType.createType: type name must be a non-empty string");t(a==null||a instanceof i||typeof a==="string"&&a,"DataType.createType: base type must be empty or a DataType or a non-empty string");if(/[\[\]]/.test(e)){n.error("[FUTURE FATAL] DataType.createType: array types ('something[]') must not be created with createType, "+"they're created on-the-fly by DataType.getType")}if(typeof a==="string"){a=i.getType(a)}a=a||o.any;if(a.isArrayType()||a.isEnumType()){n.error("[FUTURE FATAL] DataType.createType: base type must not be an array- or enum-type")}if(e==="array"||o[e]instanceof i){if(e==="array"||o[e].getBaseType()==null){throw new Error("DataType.createType: primitive or hidden type "+e+" can't be re-defined")}n.warning("[FUTURE FATAL] DataTypes.createType: type "+e+" is redefined. "+"This is an unsupported usage of DataType and might cause issues.")}var s=o[e]=u(e,r,a);return s};var y=new Set;i.registerInterfaceTypes=function(t){t.forEach(function(t){y.add(t);e.set(t,t)})};i.registerEnum=function(e,t){p[e]=t};i._isEnumCandidate=function(e){return!Object.keys(e).some(t=>{const n=typeof e[t];return n==="object"||n==="function"})};i.isInterfaceType=function(e){return y.has(e)};return i},true);
//# sourceMappingURL=DataType.js.map