/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Event","./Object","sap/base/assert"],function(t,e,n){"use strict";var i=e.extend("sap.ui.base.EventProvider",{constructor:function(){e.call(this);this.mEventRegistry={}}});var r="EventHandlerChange";i.M_EVENTS={EventHandlerChange:r};i.prototype.attachEvent=function(t,e,i,o){var a=this.mEventRegistry;n(typeof t==="string"&&t,"EventProvider.attachEvent: sEventId must be a non-empty string");if(typeof e==="function"){o=i;i=e;e=undefined}n(typeof i==="function","EventProvider.attachEvent: fnFunction must be a function");n(!o||typeof o==="object","EventProvider.attachEvent: oListener must be empty or an object");o=o===this?undefined:o;var s=a[t];if(!Array.isArray(s)){s=a[t]=[]}s.push({oListener:o,fFunction:i,oData:e});if(a[r]){this.fireEvent(r,{EventId:t,type:"listenerAttached",listener:o,func:i,data:e})}return this};i.prototype.attachEventOnce=function(t,e,i,r){if(typeof e==="function"){r=i;i=e;e=undefined}n(typeof i==="function","EventProvider.attachEventOnce: fnFunction must be a function");var o=function(){this.detachEvent(t,o);i.apply(r||this,arguments)};o.oOriginal={fFunction:i,oListener:r,oData:e};this.attachEvent(t,e,o,undefined);return this};i.prototype.detachEvent=function(t,e,i){var o=this.mEventRegistry;n(typeof t==="string"&&t,"EventProvider.detachEvent: sEventId must be a non-empty string");n(typeof e==="function","EventProvider.detachEvent: fnFunction must be a function");n(!i||typeof i==="object","EventProvider.detachEvent: oListener must be empty or an object");var a=o[t];if(!Array.isArray(a)){return this}var s,f;i=i===this?undefined:i;for(var u=0,v=a.length;u<v;u++){if(a[u].fFunction===e&&a[u].oListener===i){s=a[u];a.splice(u,1);break}}if(!s){for(var u=0,v=a.length;u<v;u++){f=a[u].fFunction.oOriginal;if(f&&f.fFunction===e&&f.oListener===i){s=f;a.splice(u,1);break}}}if(a.length==0){delete o[t]}if(s&&o[r]){this.fireEvent(r,{EventId:t,type:"listenerDetached",listener:s.oListener,func:s.fFunction,data:s.oData})}return this};i.prototype.fireEvent=function(e,n,i,r){if(typeof n==="boolean"){r=i;i=n}var o=this,a=false,s,f,u,v,c;do{s=o.mEventRegistry[e];if(Array.isArray(s)){s=s.slice();f=new t(e,this,n);for(u=0,v=s.length;u<v;u++){c=s[u];c.fFunction.call(c.oListener||o,f,c.oData)}r=r&&!f.bCancelBubble}o=o.getEventingParent()}while(r&&o);if(f){a=f.bPreventDefault}return i?!a:this};i.prototype.hasListeners=function(t){return!!this.mEventRegistry[t]};i.getEventList=function(t){return t.mEventRegistry};i.hasListener=function(t,e,i,r){n(typeof e==="string"&&e,"EventProvider.hasListener: sEventId must be a non-empty string");n(typeof i==="function","EventProvider.hasListener: fnFunction must be a function");n(!r||typeof r==="object","EventProvider.hasListener: oListener must be empty or an object");var o=t&&t.mEventRegistry[e];if(o){for(var a=0,s=o.length;a<s;a++){if(o[a].fFunction===i&&o[a].oListener===r){return true}}}return false};i.prototype.getEventingParent=function(){return null};i.prototype.toString=function(){if(this.getMetadata){return"EventProvider "+this.getMetadata().getName()}else{return"EventProvider"}};i.prototype.destroy=function(){this.mEventRegistry={};e.prototype.destroy.apply(this,arguments)};return i});
//# sourceMappingURL=EventProvider.js.map