/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/base/assert","./library","sap/ui/core/Control","./PanelRenderer","sap/ui/core/ResizeHandler","sap/ui/core/Title","sap/ui/core/Configuration","sap/ui/dom/jquery/scrollLeftRTL"],function(jQuery,t,e,i,o,s,r,l){"use strict";var n=e.enums.BorderDesign;var h=e.enums.AreaDesign;var a=i.extend("sap.ui.commons.Panel",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},scrollLeft:{type:"int",group:"Behavior",defaultValue:0},scrollTop:{type:"int",group:"Behavior",defaultValue:0},applyContentPadding:{type:"boolean",group:"Appearance",defaultValue:true},collapsed:{type:"boolean",group:"Behavior",defaultValue:false},areaDesign:{type:"sap.ui.commons.enums.AreaDesign",group:"Appearance",defaultValue:h.Fill},borderDesign:{type:"sap.ui.commons.enums.BorderDesign",group:"Appearance",defaultValue:n.Box},showCollapseIcon:{type:"boolean",group:"Behavior",defaultValue:true},text:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},title:{type:"sap.ui.core.Title",multiple:false},buttons:{type:"sap.ui.commons.Button",multiple:true,singularName:"button"}}}});a.prototype.init=function(){this._oScrollDomRef=null;this._iMaxTbBtnWidth=-1;this._iTbMarginsAndBorders=0;this._iMinTitleWidth=30;this._iOptTitleWidth=30;this._iTitleMargin=0;this._bFocusCollapseIcon=false;this._resizeDelayTimer=null;this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");this.data("sap-ui-fastnavgroup","true",true)};a.prototype.exit=function(){this._rb=undefined};a.prototype.onThemeChanged=function(){if(this.getDomRef()&&this._oTitleDomRef){this.getDomRef().style.minWidth="auto";if(this._oToolbarDomRef){this._oToolbarDomRef.style.width="auto"}this._oTitleDomRef.style.width="auto";this._initializeSizes()}};a.prototype.onBeforeRendering=function(){if(this.sResizeListenerId){s.deregister(this.sResizeListenerId);this.sResizeListenerId=null}};a.prototype.onAfterRendering=function(){this._oScrollDomRef=this.getDomRef("cont");if(!this._oScrollDomRef){return}this._oHeaderDomRef=this.getDomRef("hdr");this._oTitleDomRef=this.getDomRef("title");this._oToolbarDomRef=this.getDomRef("tb");if(this._bFocusCollapseIcon){this._bFocusCollapseIcon=false;var t=this.$("collArrow");if(t.is(":visible")&&(t.css("visibility")=="visible"||t.css("visibility")=="inherit")){t.trigger("focus")}else{var e=this.$("collIco");if(e.is(":visible")&&(e.css("visibility")=="visible"||e.css("visibility")=="inherit")){e.trigger("focus")}}}this._initializeSizes();if(a._isSizeSet(this.getHeight())&&(this._hasIcon()||this.getButtons().length>0)){this._handleResizeNow();this.sResizeListenerId=s.register(this.getDomRef(),jQuery.proxy(this._handleResizeSoon,this))}};a.prototype.getFocusInfo=function(){var t=null;var e=this.getId();if(this._bFocusCollapseIcon){var i=this.$("collArrow");if(i.is(":visible")&&(i.css("visibility")=="visible"||i.css("visibility")=="inherit")){t=i[0].id}else{var o=this.$("collIco");if(o.is(":visible")&&(o.css("visibility")=="visible"||o.css("visibility")=="inherit")){t=o[0].id}}}return{id:t?t:e}};a.prototype.applyFocusInfo=function(t){var e;if(t&&t.id&&(e=jQuery(document.getElementById(t.id)))&&e.length>0){e.trigger("focus")}else{this.focus()}return this};a.prototype._initializeSizes=function(){var t=l.getRTL();var e=this.getButtons();if(e&&e.length>0){var i=0;jQuery(this._oToolbarDomRef).children().each(function(){var t=this.offsetWidth;if(t>i){i=t}});this._iMaxTbBtnWidth=i;if(this._oToolbarDomRef){this._oToolbarDomRef.style.minWidth=i+"px";var o=jQuery(this._oToolbarDomRef);this._iTbMarginsAndBorders=o.outerWidth(true)-o.width()}}var s=this._oTitleDomRef.offsetLeft;var r=this.getDomRef().offsetWidth;if(t){s=r-(s+this._oTitleDomRef.offsetWidth)}var n=jQuery(this._oTitleDomRef);this._iOptTitleWidth=n.width()+1;this._iTitleMargin=n.outerWidth(true)-n.outerWidth();var h=1e4;jQuery(this._oHeaderDomRef).children(".sapUiPanelHdrRightItem").each(function(){var e=this.offsetLeft;if(t){e=r-(e+this.offsetWidth)}if(e<h&&e>0){h=e}});var a=s;a+=this._iMinTitleWidth;a+=this._iMaxTbBtnWidth+1;a+=h==1e4?10:r-h;this.getDomRef().style.minWidth=a+10+"px";if(this._oScrollDomRef){var f=this.getProperty("scrollTop");if(f>0){this._oScrollDomRef.scrollTop=f}var p=this.getProperty("scrollLeft");if(p>0){this._oScrollDomRef.scrollLeft=p}}};a.prototype._fixContentHeight=function(){if(a._isSizeSet(this.getHeight())&&(this._hasIcon()||this.getButtons().length>0)){this._iContTop=this._oHeaderDomRef.offsetHeight;if(this._oScrollDomRef){this._oScrollDomRef.style.top=this._iContTop+"px"}}};a.prototype._handleResizeSoon=function(){if(this._resizeDelayTimer){clearTimeout(this._resizeDelayTimer)}this._resizeDelayTimer=setTimeout(function(){this._handleResizeNow();this._resizeDelayTimer=null}.bind(this),200)};a.prototype._handleResizeNow=function(){this._fixContentHeight()};a.prototype._hasIcon=function(){return this.getTitle()&&this.getTitle().getIcon()};a.prototype.setEnabled=function(t){this.setProperty("enabled",t,true);jQuery(this.getDomRef()).toggleClass("sapUiPanelDis",!t);return this};a.prototype.setApplyContentPadding=function(t){this.setProperty("applyContentPadding",t,true);jQuery(this.getDomRef()).toggleClass("sapUiPanelWithPadding",t);return this};a.prototype.setCollapsed=function(t){this.setProperty("collapsed",t,true);this._setCollapsedState(t);return this};a.prototype._setCollapsedState=function(t){var e=this.getDomRef();if(e){var i=l.getAccessibility();if(t){if(!this.getWidth()){e.style.width=this.getDomRef().offsetWidth+"px"}jQuery(e).addClass("sapUiPanelColl");if(i){e.setAttribute("aria-expanded","false")}if(this.getHeight()){e.style.height="auto"}var o=this._rb.getText("PANEL_EXPAND");this.$("collArrow").attr("title",o);this.$("collIco").attr("title",o)}else{if(!this.getDomRef("cont")){this._bFocusCollapseIcon=true;this.rerender()}else{jQuery(e).removeClass("sapUiPanelColl");if(i){e.setAttribute("aria-expanded","true")}if(!this.getWidth()){e.style.width="auto"}if(this.getHeight()){e.style.height=this.getHeight()}var s=this._rb.getText("PANEL_COLLAPSE");this.$("collArrow").attr("title",s);this.$("collIco").attr("title",s)}}}};a._isSizeSet=function(t){return t&&!(t=="auto")&&!(t=="inherit")};a.prototype.setTitle=function(t){var e=this.getTitle();this.setAggregation("title",t);if(e&&e!==t&&e.getId()===this.getId()+"-tit"){e.destroy()}return this};a.prototype.setText=function(t){if(!this.getTitle()){this.setTitle(new r(this.getId()+"-tit",{text:t}))}else{this.getTitle().setText(t)}return this};a.prototype.getText=function(){if(!this.getTitle()){return""}else{return this.getTitle().getText()}};a.prototype.getScrollLeft=function(){var e=0;if(this._oScrollDomRef){if(l.getRTL()){e=jQuery(this._oScrollDomRef).scrollLeftRTL()}else{e=jQuery(this._oScrollDomRef).scrollLeft()}t(typeof e=="number","scrollLeft read from DOM should be a number");this.setProperty("scrollLeft",e,true)}return e};a.prototype.setScrollLeft=function(t){this.setProperty("scrollLeft",t,true);if(this._oScrollDomRef){if(l.getRTL()){jQuery(this._oScrollDomRef).scrollLeftRTL(t)}else{jQuery(this._oScrollDomRef).scrollLeft(t)}}return this};a.prototype.getScrollTop=function(){var t=0;if(this._oScrollDomRef){t=Math.ceil(this._oScrollDomRef.scrollTop);this.setProperty("scrollTop",t,true)}return t};a.prototype.setScrollTop=function(t){this.setProperty("scrollTop",t,true);if(this._oScrollDomRef){this._oScrollDomRef.scrollTop=t}return this};a.prototype.setDimensions=function(e,i){t(typeof e=="string"&&typeof i=="string","sWidth and sHeight must be strings");this.setWidth(e);this.setHeight(i);return this};a.prototype.setWidth=function(t){this.setProperty("width",t,true);var e=this.getDomRef();if(e){e.style.width=t}return this};a.prototype.setHeight=function(t){this.setProperty("height",t,true);var e=this.getDomRef();if(e){e.style.height=t}return this};a.prototype.onclick=function(t){this._handleTrigger(t)};a.prototype.onsapspace=function(t){this._handleTrigger(t)};a.prototype._handleTrigger=function(t){var e=this.getId();if(t.target.id===e+"-collArrow"||t.target.id===e+"-collIco"||t.target.id===e&&t.type==="sapspace"&&this.getShowCollapseIcon()){this.setCollapsed(!this.getProperty("collapsed"));t.preventDefault();t.stopPropagation();this.fireEvent("collapsedToggled")}};return a});
//# sourceMappingURL=Panel.js.map